package com.xwd.hospital.server.rest;

import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.xwd.hospital.server.annotation.AuthUser;
import com.xwd.hospital.server.domain.DepartmentInfo;
import com.xwd.hospital.server.domain.FamilyDoctor;
import com.xwd.hospital.server.domain.User;
import com.xwd.hospital.server.dto.DepartmentDto;
import com.xwd.hospital.server.dto.ExcelDepartment;
import com.xwd.hospital.server.enums.DepartmentLevelEnum;
import com.xwd.hospital.server.rest.res.ApiResponse;
import com.xwd.hospital.server.service.DepartmentInfoService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@RestController
@Tag(name = "ExcelController", description = "excel导入")
@RequestMapping("/v1/pms/excel")
public class ExcelController {
    @Resource
    private DepartmentInfoService departmentInfoService;
    /**
     * 导入科室
     */
    @PostMapping("/importDepartments")
    @Operation(summary = "导入科室")
    public ApiResponse<FamilyDoctor> importDepartments(@RequestParam MultipartFile multipartFile) {
        try {
            File file = convertMultipartFileToFile(multipartFile);
            ExcelReader reader = ExcelUtil.getReader(file,"Sheet1");

            List<Map<String,Object>> allData = reader.readAll();
            //将 allData 转换为 ExcelDepartment 的list
            List<ExcelDepartment> excelDepartmentList = allData.stream().map(map -> {
                ExcelDepartment excelDepartment = new ExcelDepartment();
                excelDepartment.setDepartmentName(map.get("科室名称").toString());
                excelDepartment.setDepartmentIntroduce(null== map.get("科室描述")?"":map.get("科室描述").toString());
                //excel中临时序号
                excelDepartment.setExcelId(Long.parseLong(map.get("序号").toString()));
                excelDepartment.setExcelParentId(Long.parseLong(map.get("上级科室序号").toString()));
                return excelDepartment;
            }).collect(Collectors.toList());

            // 使用Collectors.groupingBy进行分组
            Map<Long, List<ExcelDepartment>> excelDepartmentGroups = excelDepartmentList.stream()
                    .collect(Collectors.groupingBy(ExcelDepartment::getExcelParentId));

            // 获取一级部门列表
            List<ExcelDepartment> topLevelDepartments = excelDepartmentGroups.get(0L);

            topLevelDepartments.forEach(excelDepartment -> {
                DepartmentInfo departmentInfo = new DepartmentInfo();
                departmentInfo.setDepartmentName(excelDepartment.getDepartmentName());
                departmentInfo.setDepartmentIntroduce(excelDepartment.getDepartmentIntroduce());
                departmentInfo.setDepartmentLevel(DepartmentLevelEnum.FIRST_LEVEL);
                departmentInfo.setParentId(0L);
                departmentInfoService.save(departmentInfo);
                //插入所有一级科室数据，同时返回记录数据库中的id
                excelDepartment.setId(departmentInfo.getId());
                //根据excelParentId获取当前一级科室下所有的科室
                List<ExcelDepartment> secondeDepartmentList = excelDepartmentGroups.get(excelDepartment.getExcelId());
                secondeDepartmentList.forEach(secondeDepartment -> {
                    DepartmentInfo secondeDepartmentInfo = new DepartmentInfo();
                    secondeDepartmentInfo.setDepartmentName(secondeDepartment.getDepartmentName());
                    secondeDepartmentInfo.setDepartmentIntroduce(secondeDepartment.getDepartmentIntroduce());
                    secondeDepartmentInfo.setDepartmentLevel(DepartmentLevelEnum.SECOND_LEVEL);
                    secondeDepartmentInfo.setParentId(departmentInfo.getId());
                    departmentInfoService.save(secondeDepartmentInfo);
                });
            });

        }catch (IOException e){
            return ApiResponse.fail(-1,"文件导入失败");
        }

        return ApiResponse.ok(null);
    }


    public File convertMultipartFileToFile(MultipartFile multipartFile) throws IOException {
        File file = new File(multipartFile.getOriginalFilename());
        FileUtils.writeByteArrayToFile(file, multipartFile.getBytes());
        return file;
    }

}
