/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：影像报告表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest;

import java.util.List;
import java.util.Arrays;

import cn.dev33.satoken.stp.SaLoginModel;
import cn.dev33.satoken.stp.StpUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.xwd.hospital.server.annotation.ApiCommon;
import com.xwd.hospital.server.annotation.AuthUser;
import com.xwd.hospital.server.base.BaseController;
import com.xwd.hospital.server.domain.User;
import com.xwd.hospital.server.dto.MedicalQualificationDto;
import com.xwd.hospital.server.dto.ReportDto;
import com.xwd.hospital.server.rest.res.ApiCode;
import com.xwd.hospital.server.domain.MedicalReport;
import com.xwd.hospital.server.rest.req.MedicalReportParam;
import com.xwd.hospital.server.rest.res.ApiResponse;
import com.xwd.hospital.server.service.MedicalReportService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@RestController
@Tag(name = "MedicalReportController", description = "影像报告表管理")
@RequestMapping("/v1/pms/medical-report")
public class MedicalReportController extends BaseController<MedicalReportService, MedicalReport, MedicalReportParam> {

    @Resource
    public void setService(MedicalReportService service) {
        this.service = service;
    }

    /**
     * 新增
     *
     * @param entity 要新增的对象
     * @return 新增的对象
     */
    @PostMapping("/")
    @Operation(summary = "新增")
    @Override
    public ApiResponse<MedicalReport> add(@RequestBody MedicalReport entity, @AuthUser User user) {
        entity.setEditorId(user.getId());
        entity.setEditorName(user.getUsername());
        entity.setDefault().validate(true);
        this.service.save(entity);
        return ApiResponse.ok(this.service.getById(entity.getId()));
    }

    /**
     * 批量新增
     *
     * @param entityList 要新增的对象
     * @return boolean 成功或失败
     */
    @PostMapping("/batch-save")
    @Operation(summary = "批量新增")
    @Override
    public ApiResponse<Boolean> batchSave(@RequestBody List<MedicalReport> entityList, @AuthUser User user) {
        entityList.forEach(entity -> {
            entity.setEditorId(user.getId());
            entity.setEditorName(user.getUsername());
            entity.setDefault().validate(true);
        });
        return ApiResponse.ok(this.service.saveBatch(entityList));
    }

    /**
     * 上传影像报告
     *
     */
    @PostMapping("/uploadReport")
    @Operation(summary = "上传影像报告")
    public ApiResponse uploadReport(@RequestBody ReportDto dto, @AuthUser User user) {
        boolean result = this.service.uploadReport(dto);
        if(result){
            return ApiResponse.ok(result);
        }else {
            return ApiResponse.fail(ApiCode.FAILED.getCode(),"身份证信息不正确");
        }

    }

    /**
     * 我的医嘱
     *
     */
    @GetMapping("/myDoctorAsk")
    @Operation(summary = "我的医嘱")
    public ApiResponse myDoctorAsk(@AuthUser User user) {

        return ApiResponse.ok(this.service.myDoctorAsk());
    }

}
