package com.xwd.hospital.server.rest;

import com.xwd.hospital.server.annotation.ApiCommon;
import com.xwd.hospital.server.dto.PatientMiniAppHomeDto;
import com.xwd.hospital.server.rest.res.ApiResponse;
import com.xwd.hospital.server.service.SmsService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@Tag(name = "SmsController", description = "通信服务")
@RequestMapping("/v1/system/sms")
public class SmsController {
    @Resource
    private SmsService smsService;

    /**
     * <pre>
     * 发送短信验证码
     * </pre>
     */
    @Operation(summary = "发送短信验证码")
    @PostMapping("/sendSms")
    @ApiCommon
    public ApiResponse sendSms(@RequestParam("phone") String phone) {
        return ApiResponse.ok(smsService.sendSms(phone));
    }

    /**
     * <pre>
     * 绑定手机号码
     * </pre>
     */
    @Operation(summary = "绑定手机号码")
    @PostMapping("/bindPhone")
    @ApiCommon
    public ApiResponse bindPhone(@RequestParam("proxyNumber") String proxyNumber,
                                 @RequestParam("phone") String phone) {
        return ApiResponse.ok(smsService.bindPhone(proxyNumber,phone));
    }

    /**
     * <pre>
     * 容联七陌回调接口
     * </pre>
     */
    @Operation(summary = "容联七陌回调接口")
    @GetMapping("/callback")
    @ApiCommon
    public ApiResponse callback(@RequestParam(value = "alerting_time",required = false) String alertingTime,
                                @RequestParam(value = "called",required = false) String called,
                                @RequestParam(value = "recorder_id",required = false) String recorderId,
                                @RequestParam(value = "caller_area",required = false) String callerArea,
                                @RequestParam(value = "begin_time",required = false) String beginTime,
                                @RequestParam(value = "called_area",required = false) String calledArea,
                                @RequestParam(value = "caller",required = false) String caller,
                                @RequestParam(value = "called_show",required = false) String calledShow,
                                @RequestParam(value = "connect_time",required = false) String connectTime,
                                @RequestParam(value = "result",required = false) String result,
                                @RequestParam(value = "release_time",required = false) String releaseTime,
                                @RequestParam(value = "account",required = false) String account,
                                @RequestParam(value = "mappingId",required = false) String mappingId,
                                @RequestParam(value = "appId",required = false) String appId,
                                @RequestParam(value = "call_duration",required = false) String callDuration,
                                @RequestParam(value = "userData",required = false) String userData,
                                @RequestParam(value = "answerTime",required = false) String answerTime,
                                @RequestParam(value = "smallNumberType",required = false) String smallNumberType,
                                @RequestParam(value = "calldisplay",required = false) String calldisplay) {
        return ApiResponse.ok(smsService.callback(alertingTime,called,recorderId,  callerArea, beginTime,
                calledArea, caller,calledShow,  connectTime,  result,
                 releaseTime, account,  mappingId,  appId,  callDuration,
                 userData,  answerTime,  smallNumberType,  calldisplay));
    }
}
