/**
 * 项目：互联网医疗
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest;

import com.xwd.hospital.server.annotation.ApiCommon;;
import com.xwd.hospital.server.annotation.AuthUsername;;
import com.xwd.hospital.server.rest.res.ApiResponse;
import com.xwd.hospital.server.util.FileUtils;
import com.xwd.hospital.server.util.TencentCOSUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

@Tag(name = "UploadController", description = "文件上传")
@Slf4j
@RestController
@RequestMapping("/v1/system/upload")
public class UploadController {

    @Resource
    private TencentCOSUtil tencentCOSUtil;

    @Operation(summary = "文件上传")
    @PostMapping
    @ApiCommon
    public ApiResponse upload(@RequestParam MultipartFile file) {
        String upload = tencentCOSUtil.upLoadFile(file);
        return ApiResponse.ok(upload);
    }

}
