/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：用户地址关系表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest;

import java.util.List;
import java.util.Arrays;

import cn.dev33.satoken.stp.SaLoginModel;
import cn.dev33.satoken.stp.StpUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.xwd.hospital.server.annotation.ApiCommon;
import com.xwd.hospital.server.annotation.AuthUser;
import com.xwd.hospital.server.base.BaseController;
import com.xwd.hospital.server.domain.User;
import com.xwd.hospital.server.domain.UserInfo;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.rest.res.ApiCode;
import com.xwd.hospital.server.domain.UserAddressInfo;
import com.xwd.hospital.server.rest.req.UserAddressInfoParam;
import com.xwd.hospital.server.rest.res.ApiResponse;
import com.xwd.hospital.server.service.UserAddressInfoService;
import com.xwd.hospital.server.service.UserInfoService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@RestController
@Tag(name = "UserAddressInfoController", description = "用户地址关系表管理")
@RequestMapping("/v1/pms/user-address-info")
public class UserAddressInfoController extends BaseController<UserAddressInfoService, UserAddressInfo, UserAddressInfoParam> {

    @Resource
    private UserInfoService userInfoService;
    @Resource
    public void setService(UserAddressInfoService service) {
        this.service = service;
    }

    /**
     * 新增
     *
     * @param entity 要新增的对象
     * @return 新增的对象
     */
    @PostMapping("/")
    @Operation(summary = "新增")
    @Override
    public ApiResponse<UserAddressInfo> add(@RequestBody UserAddressInfo entity, @AuthUser User user) {
        UserInfo userInfo = userInfoService.getOne(Wrappers.<UserInfo>query().eq("user_id", user.getId()));


        entity.setEditorId(user.getId());
        entity.setEditorName(user.getUsername());
        entity.setDefault().validate(true);
        if(entity.getDefaultFlag() == YesNoEnum.YES){
            //先查询出默认状态为yes的数据
            UserAddressInfo userAddressInfo = this.service.getOne(Wrappers.<UserAddressInfo>lambdaQuery().eq(UserAddressInfo::getUserInfoId,userInfo.getId()).eq(UserAddressInfo::getDefaultFlag, YesNoEnum.YES));
            if (userAddressInfo != null){
                userAddressInfo.setDefaultFlag(YesNoEnum.NO);
                this.service.updateById(userAddressInfo);
            }
        }
        this.service.save(entity);
        return ApiResponse.ok(this.service.getById(entity.getId()));
    }

    /**
     * 批量新增
     *
     * @param entityList 要新增的对象
     * @return boolean 成功或失败
     */
    @PostMapping("/batch-save")
    @Operation(summary = "批量新增")
    @Override
    public ApiResponse<Boolean> batchSave(@RequestBody List<UserAddressInfo> entityList, @AuthUser User user) {
        entityList.forEach(entity -> {
            entity.setEditorId(user.getId());
            entity.setEditorName(user.getUsername());
            entity.setDefault().validate(true);
        });
        return ApiResponse.ok(this.service.saveBatch(entityList));
    }

    /**
     * 更新
     *
     * @param entity 要更新的对象
     * @return 更新后的对象
     */
    @PutMapping("/")
    @Operation(summary = "更新")
    @ApiCommon
    @Override
    public ApiResponse<UserAddressInfo> update(
            @RequestBody UserAddressInfo entity,
            @RequestParam(value = "updateAllFields", defaultValue = "false") boolean updateAllFields,
            @AuthUser User user) {
        UserInfo userInfo = userInfoService.getOne(Wrappers.<UserInfo>query().eq("user_id", user.getId()));

        if(entity.getDefaultFlag() == YesNoEnum.YES){
            //先查询出默认状态为yes的数据
            UserAddressInfo userAddressInfo = this.service.getOne(Wrappers.<UserAddressInfo>lambdaQuery().eq(UserAddressInfo::getUserInfoId,userInfo.getId()).eq(UserAddressInfo::getDefaultFlag, YesNoEnum.YES));
            if (userAddressInfo != null){
                userAddressInfo.setDefaultFlag(YesNoEnum.NO);
                this.service.updateById(userAddressInfo);
            }
        }

        if (updateAllFields) {
            this.service.updateAllFieldsById(entity);
        } else {
            this.service.updateById(entity);
        }
        return ApiResponse.ok(this.service.getById(entity.getId()));
    }


}
