/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：学术文章
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.domain.ArticleInfo;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class ArticleInfoParam extends BaseParam<ArticleInfo> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 文章作者
     */
    @Parameter(description = "文章作者")
    private String articleAuthor;
    /**
     * 文章标题
     */
    @Parameter(description = "文章标题")
    private String articleTitle;
    /**
     * 文章内容
     */
    @Parameter(description = "文章内容")
    private String articleContent;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间")
    private java.util.Date updateTime;
    /**
     * 更新时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     * 更新时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<ArticleInfo> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<ArticleInfo> toQueryWrapper(String columnPrefix) {
        QueryWrapper<ArticleInfo> wrapper = Wrappers.<ArticleInfo>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        if (this.getArticleAuthor() != null) {
            if (this.getArticleAuthor().startsWith("%") && this.getArticleAuthor().endsWith("%")) {
                wrapper.like(columnPrefix + "article_author", this.getArticleAuthor().substring(1, this.getArticleAuthor().length() - 1));
            } else if (this.getArticleAuthor().startsWith("%") && !this.getArticleAuthor().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "article_author", this.getArticleAuthor().substring(1));
            } else if (this.getArticleAuthor().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "article_author", this.getArticleAuthor().substring(0, this.getArticleAuthor().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "article_author", this.getArticleAuthor());
            }
        }
        if (this.getArticleTitle() != null) {
            if (this.getArticleTitle().startsWith("%") && this.getArticleTitle().endsWith("%")) {
                wrapper.like(columnPrefix + "article_title", this.getArticleTitle().substring(1, this.getArticleTitle().length() - 1));
            } else if (this.getArticleTitle().startsWith("%") && !this.getArticleTitle().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "article_title", this.getArticleTitle().substring(1));
            } else if (this.getArticleTitle().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "article_title", this.getArticleTitle().substring(0, this.getArticleTitle().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "article_title", this.getArticleTitle());
            }
        }
        if (this.getArticleContent() != null) {
            if (this.getArticleContent().startsWith("%") && this.getArticleContent().endsWith("%")) {
                wrapper.like(columnPrefix + "article_content", this.getArticleContent().substring(1, this.getArticleContent().length() - 1));
            } else if (this.getArticleContent().startsWith("%") && !this.getArticleContent().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "article_content", this.getArticleContent().substring(1));
            } else if (this.getArticleContent().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "article_content", this.getArticleContent().substring(0, this.getArticleContent().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "article_content", this.getArticleContent());
            }
        }
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
