/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：家庭医生地址关系表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.domain.DoctorFamilyAddressInfo;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class DoctorFamilyAddressInfoParam extends BaseParam<DoctorFamilyAddressInfo> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 医生Id
     */
    @Parameter(description = "医生Id")
    private Long doctorId;
    /**
     * 姓名
     */
    @Parameter(description = "姓名")
    private String name;
    /**
     * 手机号码
     */
    @Parameter(description = "手机号码")
    private String phoneNumber;
    /**
     * 省
     */
    @Parameter(description = "省")
    private String province;
    /**
     * 市
     */
    @Parameter(description = "市")
    private String city;
    /**
     * 区
     */
    @Parameter(description = "区")
    private String district;
    /**
     * 详细地址
     */
    @Parameter(description = "详细地址")
    private String detailAddress;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间")
    private java.util.Date updateTime;
    /**
     * 更新时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     * 更新时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<DoctorFamilyAddressInfo> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<DoctorFamilyAddressInfo> toQueryWrapper(String columnPrefix) {
        QueryWrapper<DoctorFamilyAddressInfo> wrapper = Wrappers.<DoctorFamilyAddressInfo>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        wrapper.eq(this.getDoctorId() != null, columnPrefix + "doctor_id", this.getDoctorId());
        if (this.getName() != null) {
            if (this.getName().startsWith("%") && this.getName().endsWith("%")) {
                wrapper.like(columnPrefix + "name", this.getName().substring(1, this.getName().length() - 1));
            } else if (this.getName().startsWith("%") && !this.getName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "name", this.getName().substring(1));
            } else if (this.getName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "name", this.getName().substring(0, this.getName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "name", this.getName());
            }
        }
        if (this.getPhoneNumber() != null) {
            if (this.getPhoneNumber().startsWith("%") && this.getPhoneNumber().endsWith("%")) {
                wrapper.like(columnPrefix + "phone_number", this.getPhoneNumber().substring(1, this.getPhoneNumber().length() - 1));
            } else if (this.getPhoneNumber().startsWith("%") && !this.getPhoneNumber().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "phone_number", this.getPhoneNumber().substring(1));
            } else if (this.getPhoneNumber().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "phone_number", this.getPhoneNumber().substring(0, this.getPhoneNumber().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "phone_number", this.getPhoneNumber());
            }
        }
        if (this.getProvince() != null) {
            if (this.getProvince().startsWith("%") && this.getProvince().endsWith("%")) {
                wrapper.like(columnPrefix + "province", this.getProvince().substring(1, this.getProvince().length() - 1));
            } else if (this.getProvince().startsWith("%") && !this.getProvince().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "province", this.getProvince().substring(1));
            } else if (this.getProvince().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "province", this.getProvince().substring(0, this.getProvince().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "province", this.getProvince());
            }
        }
        if (this.getCity() != null) {
            if (this.getCity().startsWith("%") && this.getCity().endsWith("%")) {
                wrapper.like(columnPrefix + "city", this.getCity().substring(1, this.getCity().length() - 1));
            } else if (this.getCity().startsWith("%") && !this.getCity().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "city", this.getCity().substring(1));
            } else if (this.getCity().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "city", this.getCity().substring(0, this.getCity().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "city", this.getCity());
            }
        }
        if (this.getDistrict() != null) {
            if (this.getDistrict().startsWith("%") && this.getDistrict().endsWith("%")) {
                wrapper.like(columnPrefix + "district", this.getDistrict().substring(1, this.getDistrict().length() - 1));
            } else if (this.getDistrict().startsWith("%") && !this.getDistrict().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "district", this.getDistrict().substring(1));
            } else if (this.getDistrict().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "district", this.getDistrict().substring(0, this.getDistrict().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "district", this.getDistrict());
            }
        }
        if (this.getDetailAddress() != null) {
            if (this.getDetailAddress().startsWith("%") && this.getDetailAddress().endsWith("%")) {
                wrapper.like(columnPrefix + "detail_address", this.getDetailAddress().substring(1, this.getDetailAddress().length() - 1));
            } else if (this.getDetailAddress().startsWith("%") && !this.getDetailAddress().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "detail_address", this.getDetailAddress().substring(1));
            } else if (this.getDetailAddress().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "detail_address", this.getDetailAddress().substring(0, this.getDetailAddress().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "detail_address", this.getDetailAddress());
            }
        }
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
