/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：医生信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.enums.DoctorStateEnum;
import com.xwd.hospital.server.enums.SexTypeEnum;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.domain.DoctorInfo;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class DoctorInfoParam extends BaseParam<DoctorInfo> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 用户Id
     */
    @Parameter(description = "用户Id")
    private Long userId;
    /**
     * 医生医疗资质Id
     */
    @Parameter(description = "医生医疗资质Id")
    private Long medicalQualificationId;
    /**
     * 医生状态
     */
    @Parameter(description = "医生状态")
    private DoctorStateEnum doctorState;
    /**
     * 医生状态 IN值List
     */
    @Parameter(description = "医生状态 IN值List")
    private List<String> doctorStateList;
    /**
     * 医生姓名
     */
    @Parameter(description = "医生姓名")
    private String doctorName;
    /**
     * 性别
     */
    @Parameter(description = "性别")
    private SexTypeEnum sex;
    /**
     * 性别 IN值List
     */
    @Parameter(description = "性别 IN值List")
    private List<String> sexList;
    /**
     * 身份证号码
     */
    @Parameter(description = "身份证号码")
    private String idNo;
    /**
     * 出生日期
     */
    @Parameter(description = "出生日期")
    private String bornDate;
    /**
     * 手机号码
     */
    @Parameter(description = "手机号码")
    private String phoneNumber;
    /**
     * 擅长领域
     */
    @Parameter(description = "擅长领域")
    private String expertiseArea;
    /**
     * 简介
     */
    @Parameter(description = "简介")
    private String introduction;
    /**
     * 身份证图片正面
     */
    @Parameter(description = "身份证图片正面")
    private String idCardPictureFront;
    /**
     * 身份证图片背面
     */
    @Parameter(description = "身份证图片背面")
    private String idCardPictureBack;
    /**
     * 是否删除
     */
    @Parameter(description = "是否删除")
    private YesNoEnum deleteStatus;
    /**
     * 是否删除 IN值List
     */
    @Parameter(description = "是否删除 IN值List")
    private List<String> deleteStatusList;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间")
    private java.util.Date updateTime;
    /**
     * 更新时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     * 更新时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<DoctorInfo> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<DoctorInfo> toQueryWrapper(String columnPrefix) {
        QueryWrapper<DoctorInfo> wrapper = Wrappers.<DoctorInfo>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        wrapper.eq(this.getUserId() != null, columnPrefix + "user_id", this.getUserId());
        wrapper.eq(this.getMedicalQualificationId() != null, columnPrefix + "medical_qualification_id", this.getMedicalQualificationId());
        wrapper.eq(this.getDoctorState() != null, columnPrefix + "doctor_state", this.getDoctorState());
        wrapper.in(this.getDoctorStateList() != null && this.getDoctorStateList().size() > 0, columnPrefix + "doctor_state", this.getDoctorStateList());
        if (this.getDoctorName() != null) {
            if (this.getDoctorName().startsWith("%") && this.getDoctorName().endsWith("%")) {
                wrapper.like(columnPrefix + "doctor_name", this.getDoctorName().substring(1, this.getDoctorName().length() - 1));
            } else if (this.getDoctorName().startsWith("%") && !this.getDoctorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "doctor_name", this.getDoctorName().substring(1));
            } else if (this.getDoctorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "doctor_name", this.getDoctorName().substring(0, this.getDoctorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "doctor_name", this.getDoctorName());
            }
        }
        wrapper.eq(this.getSex() != null, columnPrefix + "sex", this.getSex());
        wrapper.in(this.getSexList() != null && this.getSexList().size() > 0, columnPrefix + "sex", this.getSexList());
        if (this.getIdNo() != null) {
            if (this.getIdNo().startsWith("%") && this.getIdNo().endsWith("%")) {
                wrapper.like(columnPrefix + "id_no", this.getIdNo().substring(1, this.getIdNo().length() - 1));
            } else if (this.getIdNo().startsWith("%") && !this.getIdNo().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "id_no", this.getIdNo().substring(1));
            } else if (this.getIdNo().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "id_no", this.getIdNo().substring(0, this.getIdNo().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "id_no", this.getIdNo());
            }
        }
        if (this.getBornDate() != null) {
            if (this.getBornDate().startsWith("%") && this.getBornDate().endsWith("%")) {
                wrapper.like(columnPrefix + "born_date", this.getBornDate().substring(1, this.getBornDate().length() - 1));
            } else if (this.getBornDate().startsWith("%") && !this.getBornDate().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "born_date", this.getBornDate().substring(1));
            } else if (this.getBornDate().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "born_date", this.getBornDate().substring(0, this.getBornDate().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "born_date", this.getBornDate());
            }
        }
        if (this.getPhoneNumber() != null) {
            if (this.getPhoneNumber().startsWith("%") && this.getPhoneNumber().endsWith("%")) {
                wrapper.like(columnPrefix + "phone_number", this.getPhoneNumber().substring(1, this.getPhoneNumber().length() - 1));
            } else if (this.getPhoneNumber().startsWith("%") && !this.getPhoneNumber().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "phone_number", this.getPhoneNumber().substring(1));
            } else if (this.getPhoneNumber().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "phone_number", this.getPhoneNumber().substring(0, this.getPhoneNumber().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "phone_number", this.getPhoneNumber());
            }
        }
        if (this.getExpertiseArea() != null) {
            if (this.getExpertiseArea().startsWith("%") && this.getExpertiseArea().endsWith("%")) {
                wrapper.like(columnPrefix + "expertise_area", this.getExpertiseArea().substring(1, this.getExpertiseArea().length() - 1));
            } else if (this.getExpertiseArea().startsWith("%") && !this.getExpertiseArea().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "expertise_area", this.getExpertiseArea().substring(1));
            } else if (this.getExpertiseArea().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "expertise_area", this.getExpertiseArea().substring(0, this.getExpertiseArea().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "expertise_area", this.getExpertiseArea());
            }
        }
        if (this.getIntroduction() != null) {
            if (this.getIntroduction().startsWith("%") && this.getIntroduction().endsWith("%")) {
                wrapper.like(columnPrefix + "introduction", this.getIntroduction().substring(1, this.getIntroduction().length() - 1));
            } else if (this.getIntroduction().startsWith("%") && !this.getIntroduction().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "introduction", this.getIntroduction().substring(1));
            } else if (this.getIntroduction().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "introduction", this.getIntroduction().substring(0, this.getIntroduction().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "introduction", this.getIntroduction());
            }
        }
        if (this.getIdCardPictureFront() != null) {
            if (this.getIdCardPictureFront().startsWith("%") && this.getIdCardPictureFront().endsWith("%")) {
                wrapper.like(columnPrefix + "id_card_picture_front", this.getIdCardPictureFront().substring(1, this.getIdCardPictureFront().length() - 1));
            } else if (this.getIdCardPictureFront().startsWith("%") && !this.getIdCardPictureFront().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "id_card_picture_front", this.getIdCardPictureFront().substring(1));
            } else if (this.getIdCardPictureFront().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "id_card_picture_front", this.getIdCardPictureFront().substring(0, this.getIdCardPictureFront().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "id_card_picture_front", this.getIdCardPictureFront());
            }
        }
        if (this.getIdCardPictureBack() != null) {
            if (this.getIdCardPictureBack().startsWith("%") && this.getIdCardPictureBack().endsWith("%")) {
                wrapper.like(columnPrefix + "id_card_picture_back", this.getIdCardPictureBack().substring(1, this.getIdCardPictureBack().length() - 1));
            } else if (this.getIdCardPictureBack().startsWith("%") && !this.getIdCardPictureBack().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "id_card_picture_back", this.getIdCardPictureBack().substring(1));
            } else if (this.getIdCardPictureBack().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "id_card_picture_back", this.getIdCardPictureBack().substring(0, this.getIdCardPictureBack().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "id_card_picture_back", this.getIdCardPictureBack());
            }
        }
        wrapper.eq(this.getDeleteStatus() != null, columnPrefix + "delete_status", this.getDeleteStatus());
        wrapper.in(this.getDeleteStatusList() != null && this.getDeleteStatusList().size() > 0, columnPrefix + "delete_status", this.getDeleteStatusList());
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
