/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：医生服务信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.enums.DoctorServiceEnum;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.domain.DoctorServiceInfo;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class DoctorServiceInfoParam extends BaseParam<DoctorServiceInfo> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 医生Id
     */
    @Parameter(description = "医生Id")
    private Long doctorId;
    /**
     * 服务名称
     */
    @Parameter(description = "服务名称")
    private DoctorServiceEnum serviceName;
    /**
     * 服务名称 IN值List
     */
    @Parameter(description = "服务名称 IN值List")
    private List<String> serviceNameList;
    /**
     * 服务价格
     */
    @Parameter(description = "服务价格")
    private java.math.BigDecimal servicePrice;
    /**
     * 服务状态
     */
    @Parameter(description = "服务状态")
    private YesNoEnum serviceState;
    /**
     * 服务状态 IN值List
     */
    @Parameter(description = "服务状态 IN值List")
    private List<String> serviceStateList;
    /**
     * 每日服务开始时间
     */
    @Parameter(description = "每日服务开始时间")
    private String serviceStartTime;
    /**
     * 每日服务结束时间
     */
    @Parameter(description = "每日服务结束时间")
    private String serviceEndTime;
    /**
     * 服务手机
     */
    @Parameter(description = "服务手机")
    private String servicePhoneNumber;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间")
    private java.util.Date updateTime;
    /**
     * 更新时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     * 更新时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<DoctorServiceInfo> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<DoctorServiceInfo> toQueryWrapper(String columnPrefix) {
        QueryWrapper<DoctorServiceInfo> wrapper = Wrappers.<DoctorServiceInfo>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        wrapper.eq(this.getDoctorId() != null, columnPrefix + "doctor_id", this.getDoctorId());
        wrapper.eq(this.getServiceName() != null, columnPrefix + "service_name", this.getServiceName());
        wrapper.in(this.getServiceNameList() != null && this.getServiceNameList().size() > 0, columnPrefix + "service_name", this.getServiceNameList());
        wrapper.eq(this.getServicePrice() != null, columnPrefix + "service_price", this.getServicePrice());
        wrapper.eq(this.getServiceState() != null, columnPrefix + "service_state", this.getServiceState());
        wrapper.in(this.getServiceStateList() != null && this.getServiceStateList().size() > 0, columnPrefix + "service_state", this.getServiceStateList());
        if (this.getServiceStartTime() != null) {
            if (this.getServiceStartTime().startsWith("%") && this.getServiceStartTime().endsWith("%")) {
                wrapper.like(columnPrefix + "service_start_time", this.getServiceStartTime().substring(1, this.getServiceStartTime().length() - 1));
            } else if (this.getServiceStartTime().startsWith("%") && !this.getServiceStartTime().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "service_start_time", this.getServiceStartTime().substring(1));
            } else if (this.getServiceStartTime().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "service_start_time", this.getServiceStartTime().substring(0, this.getServiceStartTime().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "service_start_time", this.getServiceStartTime());
            }
        }
        if (this.getServiceEndTime() != null) {
            if (this.getServiceEndTime().startsWith("%") && this.getServiceEndTime().endsWith("%")) {
                wrapper.like(columnPrefix + "service_end_time", this.getServiceEndTime().substring(1, this.getServiceEndTime().length() - 1));
            } else if (this.getServiceEndTime().startsWith("%") && !this.getServiceEndTime().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "service_end_time", this.getServiceEndTime().substring(1));
            } else if (this.getServiceEndTime().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "service_end_time", this.getServiceEndTime().substring(0, this.getServiceEndTime().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "service_end_time", this.getServiceEndTime());
            }
        }
        if (this.getServicePhoneNumber() != null) {
            if (this.getServicePhoneNumber().startsWith("%") && this.getServicePhoneNumber().endsWith("%")) {
                wrapper.like(columnPrefix + "service_phone_number", this.getServicePhoneNumber().substring(1, this.getServicePhoneNumber().length() - 1));
            } else if (this.getServicePhoneNumber().startsWith("%") && !this.getServicePhoneNumber().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "service_phone_number", this.getServicePhoneNumber().substring(1));
            } else if (this.getServicePhoneNumber().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "service_phone_number", this.getServicePhoneNumber().substring(0, this.getServicePhoneNumber().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "service_phone_number", this.getServicePhoneNumber());
            }
        }
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
