/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：家庭医生
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.enums.SexTypeEnum;
import com.xwd.hospital.server.enums.AuditStateEnum;
import com.xwd.hospital.server.domain.FamilyDoctor;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class FamilyDoctorParam extends BaseParam<FamilyDoctor> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 用户Id
     */
    @Parameter(description = "用户Id")
    private Long userInfoId;
    /**
     * 姓名
     */
    @Parameter(description = "姓名")
    private String name;
    /**
     * 性别
     */
    @Parameter(description = "性别")
    private SexTypeEnum sex;
    /**
     * 性别 IN值List
     */
    @Parameter(description = "性别 IN值List")
    private List<String> sexList;
    /**
     * 身份证号码
     */
    @Parameter(description = "身份证号码")
    private String idNo;
    /**
     * 出生日期
     */
    @Parameter(description = "出生日期")
    private String bornDate;
    /**
     * 手机号码
     */
    @Parameter(description = "手机号码")
    private String phoneNumber;
    /**
     * 家庭地址
     */
    @Parameter(description = "家庭地址")
    private String familyAddress;
    /**
     * 审核状态
     */
    @Parameter(description = "审核状态")
    private AuditStateEnum auditState;
    /**
     * 审核状态 IN值List
     */
    @Parameter(description = "审核状态 IN值List")
    private List<String> auditStateList;
    /**
     * 相关联的家庭医生Id
     */
    @Parameter(description = "相关联的家庭医生Id")
    private Long doctorId;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间")
    private java.util.Date updateTime;
    /**
     * 更新时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     * 更新时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<FamilyDoctor> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<FamilyDoctor> toQueryWrapper(String columnPrefix) {
        QueryWrapper<FamilyDoctor> wrapper = Wrappers.<FamilyDoctor>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        wrapper.eq(this.getUserInfoId() != null, columnPrefix + "user_info_id", this.getUserInfoId());
        if (this.getName() != null) {
            if (this.getName().startsWith("%") && this.getName().endsWith("%")) {
                wrapper.like(columnPrefix + "name", this.getName().substring(1, this.getName().length() - 1));
            } else if (this.getName().startsWith("%") && !this.getName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "name", this.getName().substring(1));
            } else if (this.getName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "name", this.getName().substring(0, this.getName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "name", this.getName());
            }
        }
        wrapper.eq(this.getSex() != null, columnPrefix + "sex", this.getSex());
        wrapper.in(this.getSexList() != null && this.getSexList().size() > 0, columnPrefix + "sex", this.getSexList());
        if (this.getIdNo() != null) {
            if (this.getIdNo().startsWith("%") && this.getIdNo().endsWith("%")) {
                wrapper.like(columnPrefix + "id_no", this.getIdNo().substring(1, this.getIdNo().length() - 1));
            } else if (this.getIdNo().startsWith("%") && !this.getIdNo().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "id_no", this.getIdNo().substring(1));
            } else if (this.getIdNo().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "id_no", this.getIdNo().substring(0, this.getIdNo().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "id_no", this.getIdNo());
            }
        }
        if (this.getBornDate() != null) {
            if (this.getBornDate().startsWith("%") && this.getBornDate().endsWith("%")) {
                wrapper.like(columnPrefix + "born_date", this.getBornDate().substring(1, this.getBornDate().length() - 1));
            } else if (this.getBornDate().startsWith("%") && !this.getBornDate().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "born_date", this.getBornDate().substring(1));
            } else if (this.getBornDate().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "born_date", this.getBornDate().substring(0, this.getBornDate().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "born_date", this.getBornDate());
            }
        }
        if (this.getPhoneNumber() != null) {
            if (this.getPhoneNumber().startsWith("%") && this.getPhoneNumber().endsWith("%")) {
                wrapper.like(columnPrefix + "phone_number", this.getPhoneNumber().substring(1, this.getPhoneNumber().length() - 1));
            } else if (this.getPhoneNumber().startsWith("%") && !this.getPhoneNumber().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "phone_number", this.getPhoneNumber().substring(1));
            } else if (this.getPhoneNumber().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "phone_number", this.getPhoneNumber().substring(0, this.getPhoneNumber().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "phone_number", this.getPhoneNumber());
            }
        }
        if (this.getFamilyAddress() != null) {
            if (this.getFamilyAddress().startsWith("%") && this.getFamilyAddress().endsWith("%")) {
                wrapper.like(columnPrefix + "family_address", this.getFamilyAddress().substring(1, this.getFamilyAddress().length() - 1));
            } else if (this.getFamilyAddress().startsWith("%") && !this.getFamilyAddress().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "family_address", this.getFamilyAddress().substring(1));
            } else if (this.getFamilyAddress().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "family_address", this.getFamilyAddress().substring(0, this.getFamilyAddress().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "family_address", this.getFamilyAddress());
            }
        }
        wrapper.eq(this.getAuditState() != null, columnPrefix + "audit_state", this.getAuditState());
        wrapper.in(this.getAuditStateList() != null && this.getAuditStateList().size() > 0, columnPrefix + "audit_state", this.getAuditStateList());
        wrapper.eq(this.getDoctorId() != null, columnPrefix + "doctor_id", this.getDoctorId());
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
