/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：医生医疗资质信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.enums.DoctorTitleEnum;
import com.xwd.hospital.server.enums.AuditStateEnum;
import com.xwd.hospital.server.domain.MedicalQualifications;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class MedicalQualificationsParam extends BaseParam<MedicalQualifications> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 医生Id
     */
    @Parameter(description = "医生Id")
    private Long doctorId;
    /**
     * 医院Id
     */
    @Parameter(description = "医院Id")
    private Long hospitalId;
    /**
     * 科室Id
     */
    @Parameter(description = "科室Id")
    private Long departmentId;
    /**
     * 职称
     */
    @Parameter(description = "职称")
    private DoctorTitleEnum title;
    /**
     * 职称 IN值List
     */
    @Parameter(description = "职称 IN值List")
    private List<String> titleList;
    /**
     * 审核状态
     */
    @Parameter(description = "审核状态")
    private AuditStateEnum auditState;
    /**
     * 审核状态 IN值List
     */
    @Parameter(description = "审核状态 IN值List")
    private List<String> auditStateList;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间")
    private java.util.Date updateTime;
    /**
     * 更新时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     * 更新时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<MedicalQualifications> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<MedicalQualifications> toQueryWrapper(String columnPrefix) {
        QueryWrapper<MedicalQualifications> wrapper = Wrappers.<MedicalQualifications>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        wrapper.eq(this.getDoctorId() != null, columnPrefix + "doctor_id", this.getDoctorId());
        wrapper.eq(this.getHospitalId() != null, columnPrefix + "hospital_id", this.getHospitalId());
        wrapper.eq(this.getDepartmentId() != null, columnPrefix + "department_id", this.getDepartmentId());
        wrapper.eq(this.getTitle() != null, columnPrefix + "title", this.getTitle());
        wrapper.in(this.getTitleList() != null && this.getTitleList().size() > 0, columnPrefix + "title", this.getTitleList());
        wrapper.eq(this.getAuditState() != null, columnPrefix + "audit_state", this.getAuditState());
        wrapper.in(this.getAuditStateList() != null && this.getAuditStateList().size() > 0, columnPrefix + "audit_state", this.getAuditStateList());
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
