/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：影像报告表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.enums.SexTypeEnum;
import com.xwd.hospital.server.enums.ReportStateEnum;
import com.xwd.hospital.server.domain.MedicalReport;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class MedicalReportParam extends BaseParam<MedicalReport> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 患者姓名
     */
    @Parameter(description = "患者姓名")
    private String patientName;
    /**
     * 患者身份证号码
     */
    @Parameter(description = "患者身份证号码")
    private String patientIdNo;
    /**
     * 性别
     */
    @Parameter(description = "性别")
    private SexTypeEnum sex;
    /**
     * 性别 IN值List
     */
    @Parameter(description = "性别 IN值List")
    private List<String> sexList;
    /**
     * 患者年龄
     */
    @Parameter(description = "患者年龄")
    private Integer age;
    /**
     * 影像报告项目
     */
    @Parameter(description = "影像报告项目")
    private String reportItem;
    /**
     * 影像说明
     */
    @Parameter(description = "影像说明")
    private String reportDeclare;
    /**
     * 报告医院
     */
    @Parameter(description = "报告医院")
    private String reportHospital;
    /**
     * 报告医生
     */
    @Parameter(description = "报告医生")
    private String reportDoctor;
    /**
     * 报告时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "报告时间")
    private java.util.Date reportTime;
    /**
     * 报告时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "报告时间 下限值(大于等于)")
    private java.util.Date reportTimeFrom;
    /**
     * 报告时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "报告时间 上限值(小于)")
    private java.util.Date reportTimeTo;
    /**
     * 影像报告状态
     */
    @Parameter(description = "影像报告状态")
    private ReportStateEnum reportState;
    /**
     * 影像报告状态 IN值List
     */
    @Parameter(description = "影像报告状态 IN值List")
    private List<String> reportStateList;
    /**
     * 医生Id
     */
    @Parameter(description = "医生Id")
    private Long doctorId;
    /**
     * 医生医嘱
     */
    @Parameter(description = "医生医嘱")
    private String doctorAsks;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间")
    private java.util.Date updateTime;
    /**
     * 更新时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     * 更新时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<MedicalReport> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<MedicalReport> toQueryWrapper(String columnPrefix) {
        QueryWrapper<MedicalReport> wrapper = Wrappers.<MedicalReport>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        if (this.getPatientName() != null) {
            if (this.getPatientName().startsWith("%") && this.getPatientName().endsWith("%")) {
                wrapper.like(columnPrefix + "patient_name", this.getPatientName().substring(1, this.getPatientName().length() - 1));
            } else if (this.getPatientName().startsWith("%") && !this.getPatientName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "patient_name", this.getPatientName().substring(1));
            } else if (this.getPatientName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "patient_name", this.getPatientName().substring(0, this.getPatientName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "patient_name", this.getPatientName());
            }
        }
        if (this.getPatientIdNo() != null) {
            if (this.getPatientIdNo().startsWith("%") && this.getPatientIdNo().endsWith("%")) {
                wrapper.like(columnPrefix + "patient_id_no", this.getPatientIdNo().substring(1, this.getPatientIdNo().length() - 1));
            } else if (this.getPatientIdNo().startsWith("%") && !this.getPatientIdNo().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "patient_id_no", this.getPatientIdNo().substring(1));
            } else if (this.getPatientIdNo().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "patient_id_no", this.getPatientIdNo().substring(0, this.getPatientIdNo().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "patient_id_no", this.getPatientIdNo());
            }
        }
        wrapper.eq(this.getSex() != null, columnPrefix + "sex", this.getSex());
        wrapper.in(this.getSexList() != null && this.getSexList().size() > 0, columnPrefix + "sex", this.getSexList());
        wrapper.eq(this.getAge() != null, columnPrefix + "age", this.getAge());
        if (this.getReportItem() != null) {
            if (this.getReportItem().startsWith("%") && this.getReportItem().endsWith("%")) {
                wrapper.like(columnPrefix + "report_item", this.getReportItem().substring(1, this.getReportItem().length() - 1));
            } else if (this.getReportItem().startsWith("%") && !this.getReportItem().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "report_item", this.getReportItem().substring(1));
            } else if (this.getReportItem().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "report_item", this.getReportItem().substring(0, this.getReportItem().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "report_item", this.getReportItem());
            }
        }
        if (this.getReportDeclare() != null) {
            if (this.getReportDeclare().startsWith("%") && this.getReportDeclare().endsWith("%")) {
                wrapper.like(columnPrefix + "report_declare", this.getReportDeclare().substring(1, this.getReportDeclare().length() - 1));
            } else if (this.getReportDeclare().startsWith("%") && !this.getReportDeclare().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "report_declare", this.getReportDeclare().substring(1));
            } else if (this.getReportDeclare().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "report_declare", this.getReportDeclare().substring(0, this.getReportDeclare().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "report_declare", this.getReportDeclare());
            }
        }
        if (this.getReportHospital() != null) {
            if (this.getReportHospital().startsWith("%") && this.getReportHospital().endsWith("%")) {
                wrapper.like(columnPrefix + "report_hospital", this.getReportHospital().substring(1, this.getReportHospital().length() - 1));
            } else if (this.getReportHospital().startsWith("%") && !this.getReportHospital().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "report_hospital", this.getReportHospital().substring(1));
            } else if (this.getReportHospital().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "report_hospital", this.getReportHospital().substring(0, this.getReportHospital().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "report_hospital", this.getReportHospital());
            }
        }
        if (this.getReportDoctor() != null) {
            if (this.getReportDoctor().startsWith("%") && this.getReportDoctor().endsWith("%")) {
                wrapper.like(columnPrefix + "report_doctor", this.getReportDoctor().substring(1, this.getReportDoctor().length() - 1));
            } else if (this.getReportDoctor().startsWith("%") && !this.getReportDoctor().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "report_doctor", this.getReportDoctor().substring(1));
            } else if (this.getReportDoctor().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "report_doctor", this.getReportDoctor().substring(0, this.getReportDoctor().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "report_doctor", this.getReportDoctor());
            }
        }
        wrapper.eq(this.getReportTime() != null, columnPrefix + "report_time", this.getReportTime());
        wrapper.ge(this.getReportTimeFrom() != null, columnPrefix + "report_time", this.getReportTimeFrom());
        wrapper.lt(this.getReportTimeTo() != null, columnPrefix + "report_time", this.getReportTimeTo());
        wrapper.eq(this.getReportState() != null, columnPrefix + "report_state", this.getReportState());
        wrapper.in(this.getReportStateList() != null && this.getReportStateList().size() > 0, columnPrefix + "report_state", this.getReportStateList());
        wrapper.eq(this.getDoctorId() != null, columnPrefix + "doctor_id", this.getDoctorId());
        if (this.getDoctorAsks() != null) {
            if (this.getDoctorAsks().startsWith("%") && this.getDoctorAsks().endsWith("%")) {
                wrapper.like(columnPrefix + "doctor_asks", this.getDoctorAsks().substring(1, this.getDoctorAsks().length() - 1));
            } else if (this.getDoctorAsks().startsWith("%") && !this.getDoctorAsks().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "doctor_asks", this.getDoctorAsks().substring(1));
            } else if (this.getDoctorAsks().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "doctor_asks", this.getDoctorAsks().substring(0, this.getDoctorAsks().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "doctor_asks", this.getDoctorAsks());
            }
        }
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
