/**
 * 项目：互联网医疗
 * 模型分组：系统管理
 * 模型名称：通知告警表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.enums.MessageTypeEnum;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.domain.Message;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class MessageParam extends BaseParam<Message> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 用户Id
     */
    @Parameter(description = "用户Id")
    private String userId;
    /**
     * 消息类型
     */
    @Parameter(description = "消息类型")
    private MessageTypeEnum msgType;
    /**
     * 消息类型 IN值List
     */
    @Parameter(description = "消息类型 IN值List")
    private List<String> msgTypeList;
    /**
     * 所属模块
     */
    @Parameter(description = "所属模块")
    private String module;
    /**
     * 操作内容
     */
    @Parameter(description = "操作内容")
    private String content;
    /**
     * 相关Id
     */
    @Parameter(description = "相关Id")
    private Long relateId;
    /**
     * 状态
     */
    @Parameter(description = "状态")
    private YesNoEnum state;
    /**
     * 状态 IN值List
     */
    @Parameter(description = "状态 IN值List")
    private List<String> stateList;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<Message> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<Message> toQueryWrapper(String columnPrefix) {
        QueryWrapper<Message> wrapper = Wrappers.<Message>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        if (this.getUserId() != null) {
            if (this.getUserId().startsWith("%") && this.getUserId().endsWith("%")) {
                wrapper.like(columnPrefix + "user_id", this.getUserId().substring(1, this.getUserId().length() - 1));
            } else if (this.getUserId().startsWith("%") && !this.getUserId().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "user_id", this.getUserId().substring(1));
            } else if (this.getUserId().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "user_id", this.getUserId().substring(0, this.getUserId().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "user_id", this.getUserId());
            }
        }
        wrapper.eq(this.getMsgType() != null, columnPrefix + "msg_type", this.getMsgType());
        wrapper.in(this.getMsgTypeList() != null && this.getMsgTypeList().size() > 0, columnPrefix + "msg_type", this.getMsgTypeList());
        if (this.getModule() != null) {
            if (this.getModule().startsWith("%") && this.getModule().endsWith("%")) {
                wrapper.like(columnPrefix + "module", this.getModule().substring(1, this.getModule().length() - 1));
            } else if (this.getModule().startsWith("%") && !this.getModule().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "module", this.getModule().substring(1));
            } else if (this.getModule().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "module", this.getModule().substring(0, this.getModule().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "module", this.getModule());
            }
        }
        if (this.getContent() != null) {
            if (this.getContent().startsWith("%") && this.getContent().endsWith("%")) {
                wrapper.like(columnPrefix + "content", this.getContent().substring(1, this.getContent().length() - 1));
            } else if (this.getContent().startsWith("%") && !this.getContent().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "content", this.getContent().substring(1));
            } else if (this.getContent().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "content", this.getContent().substring(0, this.getContent().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "content", this.getContent());
            }
        }
        wrapper.eq(this.getRelateId() != null, columnPrefix + "relate_id", this.getRelateId());
        wrapper.eq(this.getState() != null, columnPrefix + "state", this.getState());
        wrapper.in(this.getStateList() != null && this.getStateList().size() > 0, columnPrefix + "state", this.getStateList());
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        return wrapper;
    }

}
