/**
 * 项目：互联网医疗
 * 模型分组：系统管理
 * 模型名称：操作日志表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.domain.OperationLog;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class OperationLogParam extends BaseParam<OperationLog> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 日志类型
     */
    @Parameter(description = "日志类型")
    private String logType;
    /**
     * 所属模块
     */
    @Parameter(description = "所属模块")
    private String module;
    /**
     * 操作类型
     */
    @Parameter(description = "操作类型")
    private String operationType;
    /**
     * 操作内容
     */
    @Parameter(description = "操作内容")
    private String content;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<OperationLog> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<OperationLog> toQueryWrapper(String columnPrefix) {
        QueryWrapper<OperationLog> wrapper = Wrappers.<OperationLog>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        if (this.getLogType() != null) {
            if (this.getLogType().startsWith("%") && this.getLogType().endsWith("%")) {
                wrapper.like(columnPrefix + "log_type", this.getLogType().substring(1, this.getLogType().length() - 1));
            } else if (this.getLogType().startsWith("%") && !this.getLogType().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "log_type", this.getLogType().substring(1));
            } else if (this.getLogType().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "log_type", this.getLogType().substring(0, this.getLogType().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "log_type", this.getLogType());
            }
        }
        if (this.getModule() != null) {
            if (this.getModule().startsWith("%") && this.getModule().endsWith("%")) {
                wrapper.like(columnPrefix + "module", this.getModule().substring(1, this.getModule().length() - 1));
            } else if (this.getModule().startsWith("%") && !this.getModule().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "module", this.getModule().substring(1));
            } else if (this.getModule().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "module", this.getModule().substring(0, this.getModule().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "module", this.getModule());
            }
        }
        if (this.getOperationType() != null) {
            if (this.getOperationType().startsWith("%") && this.getOperationType().endsWith("%")) {
                wrapper.like(columnPrefix + "operation_type", this.getOperationType().substring(1, this.getOperationType().length() - 1));
            } else if (this.getOperationType().startsWith("%") && !this.getOperationType().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "operation_type", this.getOperationType().substring(1));
            } else if (this.getOperationType().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "operation_type", this.getOperationType().substring(0, this.getOperationType().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "operation_type", this.getOperationType());
            }
        }
        if (this.getContent() != null) {
            if (this.getContent().startsWith("%") && this.getContent().endsWith("%")) {
                wrapper.like(columnPrefix + "content", this.getContent().substring(1, this.getContent().length() - 1));
            } else if (this.getContent().startsWith("%") && !this.getContent().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "content", this.getContent().substring(1));
            } else if (this.getContent().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "content", this.getContent().substring(0, this.getContent().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "content", this.getContent());
            }
        }
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        return wrapper;
    }

}
