/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：订单操作变更记录表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.domain.OrderOperation;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class OrderOperationParam extends BaseParam<OrderOperation> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 订单id
     */
    @Parameter(description = "订单id")
    private Long orderId;
    /**
     * 订单号
     */
    @Parameter(description = "订单号")
    private String orderNo;
    /**
     * 订单操作变更
     */
    @Parameter(description = "订单操作变更")
    private String operateInfo;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间")
    private java.util.Date updateTime;
    /**
     * 更新时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     * 更新时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<OrderOperation> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<OrderOperation> toQueryWrapper(String columnPrefix) {
        QueryWrapper<OrderOperation> wrapper = Wrappers.<OrderOperation>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        wrapper.eq(this.getOrderId() != null, columnPrefix + "order_id", this.getOrderId());
        if (this.getOrderNo() != null) {
            if (this.getOrderNo().startsWith("%") && this.getOrderNo().endsWith("%")) {
                wrapper.like(columnPrefix + "order_no", this.getOrderNo().substring(1, this.getOrderNo().length() - 1));
            } else if (this.getOrderNo().startsWith("%") && !this.getOrderNo().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "order_no", this.getOrderNo().substring(1));
            } else if (this.getOrderNo().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "order_no", this.getOrderNo().substring(0, this.getOrderNo().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "order_no", this.getOrderNo());
            }
        }
        if (this.getOperateInfo() != null) {
            if (this.getOperateInfo().startsWith("%") && this.getOperateInfo().endsWith("%")) {
                wrapper.like(columnPrefix + "operate_info", this.getOperateInfo().substring(1, this.getOperateInfo().length() - 1));
            } else if (this.getOperateInfo().startsWith("%") && !this.getOperateInfo().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "operate_info", this.getOperateInfo().substring(1));
            } else if (this.getOperateInfo().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "operate_info", this.getOperateInfo().substring(0, this.getOperateInfo().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "operate_info", this.getOperateInfo());
            }
        }
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
