/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：订单表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.enums.OrderStateEnum;
import com.xwd.hospital.server.enums.OrderTypeEnum;
import com.xwd.hospital.server.enums.SexTypeEnum;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.domain.Order;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class OrderParam extends BaseParam<Order> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 用户Id
     */
    @Parameter(description = "用户Id")
    private Long userInfoId;
    /**
     * 医生Id
     */
    @Parameter(description = "医生Id")
    private Long doctorId;
    /**
     * 就诊人Id
     */
    @Parameter(description = "就诊人Id")
    private Long patientId;
    /**
     * 订单号
     */
    @Parameter(description = "订单号")
    private String orderNo;
    /**
     * 订单状态
     */
    @Parameter(description = "订单状态")
    private OrderStateEnum orderState;
    /**
     * 订单状态 IN值List
     */
    @Parameter(description = "订单状态 IN值List")
    private List<String> orderStateList;
    /**
     * 订单类型
     */
    @Parameter(description = "订单类型")
    private OrderTypeEnum orderType;
    /**
     * 订单类型 IN值List
     */
    @Parameter(description = "订单类型 IN值List")
    private List<String> orderTypeList;
    /**
     * 订单金额
     */
    @Parameter(description = "订单金额")
    private java.math.BigDecimal orderPrice;
    /**
     * 订单优惠金额
     */
    @Parameter(description = "订单优惠金额")
    private java.math.BigDecimal orderDiscount;
    /**
     * 订单实际支付金额
     */
    @Parameter(description = "订单实际支付金额")
    private java.math.BigDecimal orderActualPay;
    /**
     * 优惠券Id
     */
    @Parameter(description = "优惠券Id")
    private Long userCouponId;
    /**
     * 预约日期
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "预约日期")
    private java.util.Date appointmentDate;
    /**
     * 预约日期 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "预约日期 下限值(大于等于)")
    private java.util.Date appointmentDateFrom;
    /**
     * 预约日期 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "预约日期 上限值(小于)")
    private java.util.Date appointmentDateTo;
    /**
     * 每日服务开始时间
     */
    @Parameter(description = "每日服务开始时间")
    private String serviceStartTime;
    /**
     * 每日服务结束时间
     */
    @Parameter(description = "每日服务结束时间")
    private String serviceEndTime;
    /**
     * 医院名称
     */
    @Parameter(description = "医院名称")
    private String hospitalName;
    /**
     * 科室名称
     */
    @Parameter(description = "科室名称")
    private String departmentName;
    /**
     * 医生姓名
     */
    @Parameter(description = "医生姓名")
    private String doctorName;
    /**
     * 就诊人姓名
     */
    @Parameter(description = "就诊人姓名")
    private String patientName;
    /**
     * 性别
     */
    @Parameter(description = "性别")
    private SexTypeEnum patientSex;
    /**
     * 性别 IN值List
     */
    @Parameter(description = "性别 IN值List")
    private List<String> patientSexList;
    /**
     * 身份证号码
     */
    @Parameter(description = "身份证号码")
    private String patientIdNo;
    /**
     * 就诊人手机号码
     */
    @Parameter(description = "就诊人手机号码")
    private String patientPhoneNumber;
    /**
     * 就诊人出生日期
     */
    @Parameter(description = "就诊人出生日期")
    private String patientBornDate;
    /**
     * 患者自述
     */
    @Parameter(description = "患者自述")
    private String patientSelfIntroduce;
    /**
     * 订单驳回原因
     */
    @Parameter(description = "订单驳回原因")
    private String cancelReason;
    /**
     * 支付时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "支付时间")
    private java.util.Date payTime;
    /**
     * 支付时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "支付时间 下限值(大于等于)")
    private java.util.Date payTimeFrom;
    /**
     * 支付时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "支付时间 上限值(小于)")
    private java.util.Date payTimeTo;
    /**
     * 确认时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "确认时间")
    private java.util.Date confirmTime;
    /**
     * 确认时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "确认时间 下限值(大于等于)")
    private java.util.Date confirmTimeFrom;
    /**
     * 确认时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "确认时间 上限值(小于)")
    private java.util.Date confirmTimeTo;
    /**
     * 完成时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "完成时间")
    private java.util.Date completeTime;
    /**
     * 完成时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "完成时间 下限值(大于等于)")
    private java.util.Date completeTimeFrom;
    /**
     * 完成时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "完成时间 上限值(小于)")
    private java.util.Date completeTimeTo;
    /**
     * 是否删除
     */
    @Parameter(description = "是否删除")
    private YesNoEnum deleteStatus;
    /**
     * 是否删除 IN值List
     */
    @Parameter(description = "是否删除 IN值List")
    private List<String> deleteStatusList;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间")
    private java.util.Date updateTime;
    /**
     * 更新时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     * 更新时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<Order> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<Order> toQueryWrapper(String columnPrefix) {
        QueryWrapper<Order> wrapper = Wrappers.<Order>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        wrapper.eq(this.getUserInfoId() != null, columnPrefix + "user_info_id", this.getUserInfoId());
        wrapper.eq(this.getDoctorId() != null, columnPrefix + "doctor_id", this.getDoctorId());
        wrapper.eq(this.getPatientId() != null, columnPrefix + "patient_id", this.getPatientId());
        if (this.getOrderNo() != null) {
            if (this.getOrderNo().startsWith("%") && this.getOrderNo().endsWith("%")) {
                wrapper.like(columnPrefix + "order_no", this.getOrderNo().substring(1, this.getOrderNo().length() - 1));
            } else if (this.getOrderNo().startsWith("%") && !this.getOrderNo().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "order_no", this.getOrderNo().substring(1));
            } else if (this.getOrderNo().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "order_no", this.getOrderNo().substring(0, this.getOrderNo().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "order_no", this.getOrderNo());
            }
        }
        wrapper.eq(this.getOrderState() != null, columnPrefix + "order_state", this.getOrderState());
        wrapper.in(this.getOrderStateList() != null && this.getOrderStateList().size() > 0, columnPrefix + "order_state", this.getOrderStateList());
        wrapper.eq(this.getOrderType() != null, columnPrefix + "order_type", this.getOrderType());
        wrapper.in(this.getOrderTypeList() != null && this.getOrderTypeList().size() > 0, columnPrefix + "order_type", this.getOrderTypeList());
        wrapper.eq(this.getOrderPrice() != null, columnPrefix + "order_price", this.getOrderPrice());
        wrapper.eq(this.getOrderDiscount() != null, columnPrefix + "order_discount", this.getOrderDiscount());
        wrapper.eq(this.getOrderActualPay() != null, columnPrefix + "order_actual_pay", this.getOrderActualPay());
        wrapper.eq(this.getUserCouponId() != null, columnPrefix + "user_coupon_id", this.getUserCouponId());
        wrapper.eq(this.getAppointmentDate() != null, columnPrefix + "appointment_date", this.getAppointmentDate());
        wrapper.ge(this.getAppointmentDateFrom() != null, columnPrefix + "appointment_date", this.getAppointmentDateFrom());
        wrapper.lt(this.getAppointmentDateTo() != null, columnPrefix + "appointment_date", this.getAppointmentDateTo());
        if (this.getServiceStartTime() != null) {
            if (this.getServiceStartTime().startsWith("%") && this.getServiceStartTime().endsWith("%")) {
                wrapper.like(columnPrefix + "service_start_time", this.getServiceStartTime().substring(1, this.getServiceStartTime().length() - 1));
            } else if (this.getServiceStartTime().startsWith("%") && !this.getServiceStartTime().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "service_start_time", this.getServiceStartTime().substring(1));
            } else if (this.getServiceStartTime().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "service_start_time", this.getServiceStartTime().substring(0, this.getServiceStartTime().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "service_start_time", this.getServiceStartTime());
            }
        }
        if (this.getServiceEndTime() != null) {
            if (this.getServiceEndTime().startsWith("%") && this.getServiceEndTime().endsWith("%")) {
                wrapper.like(columnPrefix + "service_end_time", this.getServiceEndTime().substring(1, this.getServiceEndTime().length() - 1));
            } else if (this.getServiceEndTime().startsWith("%") && !this.getServiceEndTime().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "service_end_time", this.getServiceEndTime().substring(1));
            } else if (this.getServiceEndTime().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "service_end_time", this.getServiceEndTime().substring(0, this.getServiceEndTime().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "service_end_time", this.getServiceEndTime());
            }
        }
        if (this.getHospitalName() != null) {
            if (this.getHospitalName().startsWith("%") && this.getHospitalName().endsWith("%")) {
                wrapper.like(columnPrefix + "hospital_name", this.getHospitalName().substring(1, this.getHospitalName().length() - 1));
            } else if (this.getHospitalName().startsWith("%") && !this.getHospitalName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "hospital_name", this.getHospitalName().substring(1));
            } else if (this.getHospitalName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "hospital_name", this.getHospitalName().substring(0, this.getHospitalName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "hospital_name", this.getHospitalName());
            }
        }
        if (this.getDepartmentName() != null) {
            if (this.getDepartmentName().startsWith("%") && this.getDepartmentName().endsWith("%")) {
                wrapper.like(columnPrefix + "department_name", this.getDepartmentName().substring(1, this.getDepartmentName().length() - 1));
            } else if (this.getDepartmentName().startsWith("%") && !this.getDepartmentName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "department_name", this.getDepartmentName().substring(1));
            } else if (this.getDepartmentName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "department_name", this.getDepartmentName().substring(0, this.getDepartmentName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "department_name", this.getDepartmentName());
            }
        }
        if (this.getDoctorName() != null) {
            if (this.getDoctorName().startsWith("%") && this.getDoctorName().endsWith("%")) {
                wrapper.like(columnPrefix + "doctor_name", this.getDoctorName().substring(1, this.getDoctorName().length() - 1));
            } else if (this.getDoctorName().startsWith("%") && !this.getDoctorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "doctor_name", this.getDoctorName().substring(1));
            } else if (this.getDoctorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "doctor_name", this.getDoctorName().substring(0, this.getDoctorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "doctor_name", this.getDoctorName());
            }
        }
        if (this.getPatientName() != null) {
            if (this.getPatientName().startsWith("%") && this.getPatientName().endsWith("%")) {
                wrapper.like(columnPrefix + "patient_name", this.getPatientName().substring(1, this.getPatientName().length() - 1));
            } else if (this.getPatientName().startsWith("%") && !this.getPatientName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "patient_name", this.getPatientName().substring(1));
            } else if (this.getPatientName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "patient_name", this.getPatientName().substring(0, this.getPatientName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "patient_name", this.getPatientName());
            }
        }
        wrapper.eq(this.getPatientSex() != null, columnPrefix + "patient_sex", this.getPatientSex());
        wrapper.in(this.getPatientSexList() != null && this.getPatientSexList().size() > 0, columnPrefix + "patient_sex", this.getPatientSexList());
        if (this.getPatientIdNo() != null) {
            if (this.getPatientIdNo().startsWith("%") && this.getPatientIdNo().endsWith("%")) {
                wrapper.like(columnPrefix + "patient_id_no", this.getPatientIdNo().substring(1, this.getPatientIdNo().length() - 1));
            } else if (this.getPatientIdNo().startsWith("%") && !this.getPatientIdNo().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "patient_id_no", this.getPatientIdNo().substring(1));
            } else if (this.getPatientIdNo().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "patient_id_no", this.getPatientIdNo().substring(0, this.getPatientIdNo().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "patient_id_no", this.getPatientIdNo());
            }
        }
        if (this.getPatientPhoneNumber() != null) {
            if (this.getPatientPhoneNumber().startsWith("%") && this.getPatientPhoneNumber().endsWith("%")) {
                wrapper.like(columnPrefix + "patient_phone_number", this.getPatientPhoneNumber().substring(1, this.getPatientPhoneNumber().length() - 1));
            } else if (this.getPatientPhoneNumber().startsWith("%") && !this.getPatientPhoneNumber().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "patient_phone_number", this.getPatientPhoneNumber().substring(1));
            } else if (this.getPatientPhoneNumber().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "patient_phone_number", this.getPatientPhoneNumber().substring(0, this.getPatientPhoneNumber().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "patient_phone_number", this.getPatientPhoneNumber());
            }
        }
        if (this.getPatientBornDate() != null) {
            if (this.getPatientBornDate().startsWith("%") && this.getPatientBornDate().endsWith("%")) {
                wrapper.like(columnPrefix + "patient_born_date", this.getPatientBornDate().substring(1, this.getPatientBornDate().length() - 1));
            } else if (this.getPatientBornDate().startsWith("%") && !this.getPatientBornDate().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "patient_born_date", this.getPatientBornDate().substring(1));
            } else if (this.getPatientBornDate().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "patient_born_date", this.getPatientBornDate().substring(0, this.getPatientBornDate().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "patient_born_date", this.getPatientBornDate());
            }
        }
        if (this.getPatientSelfIntroduce() != null) {
            if (this.getPatientSelfIntroduce().startsWith("%") && this.getPatientSelfIntroduce().endsWith("%")) {
                wrapper.like(columnPrefix + "patient_self_introduce", this.getPatientSelfIntroduce().substring(1, this.getPatientSelfIntroduce().length() - 1));
            } else if (this.getPatientSelfIntroduce().startsWith("%") && !this.getPatientSelfIntroduce().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "patient_self_introduce", this.getPatientSelfIntroduce().substring(1));
            } else if (this.getPatientSelfIntroduce().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "patient_self_introduce", this.getPatientSelfIntroduce().substring(0, this.getPatientSelfIntroduce().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "patient_self_introduce", this.getPatientSelfIntroduce());
            }
        }
        if (this.getCancelReason() != null) {
            if (this.getCancelReason().startsWith("%") && this.getCancelReason().endsWith("%")) {
                wrapper.like(columnPrefix + "cancel_reason", this.getCancelReason().substring(1, this.getCancelReason().length() - 1));
            } else if (this.getCancelReason().startsWith("%") && !this.getCancelReason().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "cancel_reason", this.getCancelReason().substring(1));
            } else if (this.getCancelReason().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "cancel_reason", this.getCancelReason().substring(0, this.getCancelReason().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "cancel_reason", this.getCancelReason());
            }
        }
        wrapper.eq(this.getPayTime() != null, columnPrefix + "pay_time", this.getPayTime());
        wrapper.ge(this.getPayTimeFrom() != null, columnPrefix + "pay_time", this.getPayTimeFrom());
        wrapper.lt(this.getPayTimeTo() != null, columnPrefix + "pay_time", this.getPayTimeTo());
        wrapper.eq(this.getConfirmTime() != null, columnPrefix + "confirm_time", this.getConfirmTime());
        wrapper.ge(this.getConfirmTimeFrom() != null, columnPrefix + "confirm_time", this.getConfirmTimeFrom());
        wrapper.lt(this.getConfirmTimeTo() != null, columnPrefix + "confirm_time", this.getConfirmTimeTo());
        wrapper.eq(this.getCompleteTime() != null, columnPrefix + "complete_time", this.getCompleteTime());
        wrapper.ge(this.getCompleteTimeFrom() != null, columnPrefix + "complete_time", this.getCompleteTimeFrom());
        wrapper.lt(this.getCompleteTimeTo() != null, columnPrefix + "complete_time", this.getCompleteTimeTo());
        wrapper.eq(this.getDeleteStatus() != null, columnPrefix + "delete_status", this.getDeleteStatus());
        wrapper.in(this.getDeleteStatusList() != null && this.getDeleteStatusList().size() > 0, columnPrefix + "delete_status", this.getDeleteStatusList());
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
