/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：订单退款表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.enums.RefundStateEnum;
import com.xwd.hospital.server.domain.OrderRefund;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class OrderRefundParam extends BaseParam<OrderRefund> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 订单id
     */
    @Parameter(description = "订单id")
    private Long orderId;
    /**
     * 订单号
     */
    @Parameter(description = "订单号")
    private String orderNo;
    /**
     * 订单支付id
     */
    @Parameter(description = "订单支付id")
    private Long orderPayId;
    /**
     * 退款流水号
     */
    @Parameter(description = "退款流水号")
    private String refundNo;
    /**
     * 退款状态
     */
    @Parameter(description = "退款状态")
    private RefundStateEnum refundState;
    /**
     * 退款状态 IN值List
     */
    @Parameter(description = "退款状态 IN值List")
    private List<String> refundStateList;
    /**
     * 退款金额
     */
    @Parameter(description = "退款金额")
    private java.math.BigDecimal refundMoney;
    /**
     * 退款时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "退款时间")
    private java.util.Date refundTime;
    /**
     * 退款时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "退款时间 下限值(大于等于)")
    private java.util.Date refundTimeFrom;
    /**
     * 退款时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "退款时间 上限值(小于)")
    private java.util.Date refundTimeTo;
    /**
     * 完成时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "完成时间")
    private java.util.Date completeTime;
    /**
     * 完成时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "完成时间 下限值(大于等于)")
    private java.util.Date completeTimeFrom;
    /**
     * 完成时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "完成时间 上限值(小于)")
    private java.util.Date completeTimeTo;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间")
    private java.util.Date updateTime;
    /**
     * 更新时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     * 更新时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<OrderRefund> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<OrderRefund> toQueryWrapper(String columnPrefix) {
        QueryWrapper<OrderRefund> wrapper = Wrappers.<OrderRefund>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        wrapper.eq(this.getOrderId() != null, columnPrefix + "order_id", this.getOrderId());
        if (this.getOrderNo() != null) {
            if (this.getOrderNo().startsWith("%") && this.getOrderNo().endsWith("%")) {
                wrapper.like(columnPrefix + "order_no", this.getOrderNo().substring(1, this.getOrderNo().length() - 1));
            } else if (this.getOrderNo().startsWith("%") && !this.getOrderNo().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "order_no", this.getOrderNo().substring(1));
            } else if (this.getOrderNo().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "order_no", this.getOrderNo().substring(0, this.getOrderNo().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "order_no", this.getOrderNo());
            }
        }
        wrapper.eq(this.getOrderPayId() != null, columnPrefix + "order_pay_id", this.getOrderPayId());
        if (this.getRefundNo() != null) {
            if (this.getRefundNo().startsWith("%") && this.getRefundNo().endsWith("%")) {
                wrapper.like(columnPrefix + "refund_no", this.getRefundNo().substring(1, this.getRefundNo().length() - 1));
            } else if (this.getRefundNo().startsWith("%") && !this.getRefundNo().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "refund_no", this.getRefundNo().substring(1));
            } else if (this.getRefundNo().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "refund_no", this.getRefundNo().substring(0, this.getRefundNo().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "refund_no", this.getRefundNo());
            }
        }
        wrapper.eq(this.getRefundState() != null, columnPrefix + "refund_state", this.getRefundState());
        wrapper.in(this.getRefundStateList() != null && this.getRefundStateList().size() > 0, columnPrefix + "refund_state", this.getRefundStateList());
        wrapper.eq(this.getRefundMoney() != null, columnPrefix + "refund_money", this.getRefundMoney());
        wrapper.eq(this.getRefundTime() != null, columnPrefix + "refund_time", this.getRefundTime());
        wrapper.ge(this.getRefundTimeFrom() != null, columnPrefix + "refund_time", this.getRefundTimeFrom());
        wrapper.lt(this.getRefundTimeTo() != null, columnPrefix + "refund_time", this.getRefundTimeTo());
        wrapper.eq(this.getCompleteTime() != null, columnPrefix + "complete_time", this.getCompleteTime());
        wrapper.ge(this.getCompleteTimeFrom() != null, columnPrefix + "complete_time", this.getCompleteTimeFrom());
        wrapper.lt(this.getCompleteTimeTo() != null, columnPrefix + "complete_time", this.getCompleteTimeTo());
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
