/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：就诊人信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.enums.PatientRelationEnum;
import com.xwd.hospital.server.enums.SexTypeEnum;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.domain.PatientInfo;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class PatientInfoParam extends BaseParam<PatientInfo> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 用户Id
     */
    @Parameter(description = "用户Id")
    private Long userInfoId;
    /**
     * 就诊人关系
     */
    @Parameter(description = "就诊人关系")
    private PatientRelationEnum relation;
    /**
     * 就诊人关系 IN值List
     */
    @Parameter(description = "就诊人关系 IN值List")
    private List<String> relationList;
    /**
     * 就诊人姓名
     */
    @Parameter(description = "就诊人姓名")
    private String patientName;
    /**
     * 性别
     */
    @Parameter(description = "性别")
    private SexTypeEnum sex;
    /**
     * 性别 IN值List
     */
    @Parameter(description = "性别 IN值List")
    private List<String> sexList;
    /**
     * 身份证号码
     */
    @Parameter(description = "身份证号码")
    private String idNo;
    /**
     * 手机号码
     */
    @Parameter(description = "手机号码")
    private String phoneNumber;
    /**
     * 出生日期
     */
    @Parameter(description = "出生日期")
    private String bornDate;
    /**
     * 是否有监护人
     */
    @Parameter(description = "是否有监护人")
    private YesNoEnum guardianState;
    /**
     * 是否有监护人 IN值List
     */
    @Parameter(description = "是否有监护人 IN值List")
    private List<String> guardianStateList;
    /**
     * 就诊人姓名
     */
    @Parameter(description = "就诊人姓名")
    private String guardianName;
    /**
     * 监护人身份证号码
     */
    @Parameter(description = "监护人身份证号码")
    private String guardianIdentificationNumber;
    /**
     * 监护人手机号码
     */
    @Parameter(description = "监护人手机号码")
    private String guardianPhoneNumber;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间")
    private java.util.Date updateTime;
    /**
     * 更新时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     * 更新时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<PatientInfo> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<PatientInfo> toQueryWrapper(String columnPrefix) {
        QueryWrapper<PatientInfo> wrapper = Wrappers.<PatientInfo>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        wrapper.eq(this.getUserInfoId() != null, columnPrefix + "user_info_id", this.getUserInfoId());
        wrapper.eq(this.getRelation() != null, columnPrefix + "relation", this.getRelation());
        wrapper.in(this.getRelationList() != null && this.getRelationList().size() > 0, columnPrefix + "relation", this.getRelationList());
        if (this.getPatientName() != null) {
            if (this.getPatientName().startsWith("%") && this.getPatientName().endsWith("%")) {
                wrapper.like(columnPrefix + "patient_name", this.getPatientName().substring(1, this.getPatientName().length() - 1));
            } else if (this.getPatientName().startsWith("%") && !this.getPatientName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "patient_name", this.getPatientName().substring(1));
            } else if (this.getPatientName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "patient_name", this.getPatientName().substring(0, this.getPatientName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "patient_name", this.getPatientName());
            }
        }
        wrapper.eq(this.getSex() != null, columnPrefix + "sex", this.getSex());
        wrapper.in(this.getSexList() != null && this.getSexList().size() > 0, columnPrefix + "sex", this.getSexList());
        if (this.getIdNo() != null) {
            if (this.getIdNo().startsWith("%") && this.getIdNo().endsWith("%")) {
                wrapper.like(columnPrefix + "id_no", this.getIdNo().substring(1, this.getIdNo().length() - 1));
            } else if (this.getIdNo().startsWith("%") && !this.getIdNo().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "id_no", this.getIdNo().substring(1));
            } else if (this.getIdNo().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "id_no", this.getIdNo().substring(0, this.getIdNo().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "id_no", this.getIdNo());
            }
        }
        if (this.getPhoneNumber() != null) {
            if (this.getPhoneNumber().startsWith("%") && this.getPhoneNumber().endsWith("%")) {
                wrapper.like(columnPrefix + "phone_number", this.getPhoneNumber().substring(1, this.getPhoneNumber().length() - 1));
            } else if (this.getPhoneNumber().startsWith("%") && !this.getPhoneNumber().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "phone_number", this.getPhoneNumber().substring(1));
            } else if (this.getPhoneNumber().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "phone_number", this.getPhoneNumber().substring(0, this.getPhoneNumber().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "phone_number", this.getPhoneNumber());
            }
        }
        if (this.getBornDate() != null) {
            if (this.getBornDate().startsWith("%") && this.getBornDate().endsWith("%")) {
                wrapper.like(columnPrefix + "born_date", this.getBornDate().substring(1, this.getBornDate().length() - 1));
            } else if (this.getBornDate().startsWith("%") && !this.getBornDate().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "born_date", this.getBornDate().substring(1));
            } else if (this.getBornDate().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "born_date", this.getBornDate().substring(0, this.getBornDate().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "born_date", this.getBornDate());
            }
        }
        wrapper.eq(this.getGuardianState() != null, columnPrefix + "guardian_state", this.getGuardianState());
        wrapper.in(this.getGuardianStateList() != null && this.getGuardianStateList().size() > 0, columnPrefix + "guardian_state", this.getGuardianStateList());
        if (this.getGuardianName() != null) {
            if (this.getGuardianName().startsWith("%") && this.getGuardianName().endsWith("%")) {
                wrapper.like(columnPrefix + "guardian_name", this.getGuardianName().substring(1, this.getGuardianName().length() - 1));
            } else if (this.getGuardianName().startsWith("%") && !this.getGuardianName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "guardian_name", this.getGuardianName().substring(1));
            } else if (this.getGuardianName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "guardian_name", this.getGuardianName().substring(0, this.getGuardianName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "guardian_name", this.getGuardianName());
            }
        }
        if (this.getGuardianIdentificationNumber() != null) {
            if (this.getGuardianIdentificationNumber().startsWith("%") && this.getGuardianIdentificationNumber().endsWith("%")) {
                wrapper.like(columnPrefix + "guardian_identification_number", this.getGuardianIdentificationNumber().substring(1, this.getGuardianIdentificationNumber().length() - 1));
            } else if (this.getGuardianIdentificationNumber().startsWith("%") && !this.getGuardianIdentificationNumber().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "guardian_identification_number", this.getGuardianIdentificationNumber().substring(1));
            } else if (this.getGuardianIdentificationNumber().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "guardian_identification_number", this.getGuardianIdentificationNumber().substring(0, this.getGuardianIdentificationNumber().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "guardian_identification_number", this.getGuardianIdentificationNumber());
            }
        }
        if (this.getGuardianPhoneNumber() != null) {
            if (this.getGuardianPhoneNumber().startsWith("%") && this.getGuardianPhoneNumber().endsWith("%")) {
                wrapper.like(columnPrefix + "guardian_phone_number", this.getGuardianPhoneNumber().substring(1, this.getGuardianPhoneNumber().length() - 1));
            } else if (this.getGuardianPhoneNumber().startsWith("%") && !this.getGuardianPhoneNumber().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "guardian_phone_number", this.getGuardianPhoneNumber().substring(1));
            } else if (this.getGuardianPhoneNumber().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "guardian_phone_number", this.getGuardianPhoneNumber().substring(0, this.getGuardianPhoneNumber().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "guardian_phone_number", this.getGuardianPhoneNumber());
            }
        }
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
