/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：就诊人处方信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.domain.PatientPrescriptionInfo;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class PatientPrescriptionInfoParam extends BaseParam<PatientPrescriptionInfo> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 就诊人Id
     */
    @Parameter(description = "就诊人Id")
    private Long patientId;
    /**
     * 医院名称
     */
    @Parameter(description = "医院名称")
    private String hospitalName;
    /**
     * 科室名称
     */
    @Parameter(description = "科室名称")
    private String departmentName;
    /**
     * 处方时间
     */
    @Parameter(description = "处方时间")
    private String prescriptionTime;
    /**
     * 处方说明
     */
    @Parameter(description = "处方说明")
    private String prescriptionIntroduce;
    /**
     * 是否删除
     */
    @Parameter(description = "是否删除")
    private YesNoEnum deleteStatus;
    /**
     * 是否删除 IN值List
     */
    @Parameter(description = "是否删除 IN值List")
    private List<String> deleteStatusList;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间")
    private java.util.Date updateTime;
    /**
     * 更新时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     * 更新时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<PatientPrescriptionInfo> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<PatientPrescriptionInfo> toQueryWrapper(String columnPrefix) {
        QueryWrapper<PatientPrescriptionInfo> wrapper = Wrappers.<PatientPrescriptionInfo>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        wrapper.eq(this.getPatientId() != null, columnPrefix + "patient_id", this.getPatientId());
        if (this.getHospitalName() != null) {
            if (this.getHospitalName().startsWith("%") && this.getHospitalName().endsWith("%")) {
                wrapper.like(columnPrefix + "hospital_name", this.getHospitalName().substring(1, this.getHospitalName().length() - 1));
            } else if (this.getHospitalName().startsWith("%") && !this.getHospitalName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "hospital_name", this.getHospitalName().substring(1));
            } else if (this.getHospitalName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "hospital_name", this.getHospitalName().substring(0, this.getHospitalName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "hospital_name", this.getHospitalName());
            }
        }
        if (this.getDepartmentName() != null) {
            if (this.getDepartmentName().startsWith("%") && this.getDepartmentName().endsWith("%")) {
                wrapper.like(columnPrefix + "department_name", this.getDepartmentName().substring(1, this.getDepartmentName().length() - 1));
            } else if (this.getDepartmentName().startsWith("%") && !this.getDepartmentName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "department_name", this.getDepartmentName().substring(1));
            } else if (this.getDepartmentName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "department_name", this.getDepartmentName().substring(0, this.getDepartmentName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "department_name", this.getDepartmentName());
            }
        }
        if (this.getPrescriptionTime() != null) {
            if (this.getPrescriptionTime().startsWith("%") && this.getPrescriptionTime().endsWith("%")) {
                wrapper.like(columnPrefix + "prescription_time", this.getPrescriptionTime().substring(1, this.getPrescriptionTime().length() - 1));
            } else if (this.getPrescriptionTime().startsWith("%") && !this.getPrescriptionTime().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "prescription_time", this.getPrescriptionTime().substring(1));
            } else if (this.getPrescriptionTime().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "prescription_time", this.getPrescriptionTime().substring(0, this.getPrescriptionTime().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "prescription_time", this.getPrescriptionTime());
            }
        }
        if (this.getPrescriptionIntroduce() != null) {
            if (this.getPrescriptionIntroduce().startsWith("%") && this.getPrescriptionIntroduce().endsWith("%")) {
                wrapper.like(columnPrefix + "prescription_introduce", this.getPrescriptionIntroduce().substring(1, this.getPrescriptionIntroduce().length() - 1));
            } else if (this.getPrescriptionIntroduce().startsWith("%") && !this.getPrescriptionIntroduce().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "prescription_introduce", this.getPrescriptionIntroduce().substring(1));
            } else if (this.getPrescriptionIntroduce().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "prescription_introduce", this.getPrescriptionIntroduce().substring(0, this.getPrescriptionIntroduce().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "prescription_introduce", this.getPrescriptionIntroduce());
            }
        }
        wrapper.eq(this.getDeleteStatus() != null, columnPrefix + "delete_status", this.getDeleteStatus());
        wrapper.in(this.getDeleteStatusList() != null && this.getDeleteStatusList().size() > 0, columnPrefix + "delete_status", this.getDeleteStatusList());
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
