/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：续方开药订单记录信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.domain.PrescriptionOrderRecord;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class PrescriptionOrderRecordParam extends BaseParam<PrescriptionOrderRecord> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 订单id
     */
    @Parameter(description = "订单id")
    private Long orderId;
    /**
     * 订单号
     */
    @Parameter(description = "订单号")
    private String orderNo;
    /**
     * 患者提交处方id
     */
    @Parameter(description = "患者提交处方id")
    private Long prescriptionId;
    /**
     * 处方说明
     */
    @Parameter(description = "处方说明")
    private String prescriptionIntroduce;
    /**
     * 处方图片
     */
    @Parameter(description = "处方图片")
    private String prescriptionImage;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间")
    private java.util.Date updateTime;
    /**
     * 更新时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     * 更新时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<PrescriptionOrderRecord> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<PrescriptionOrderRecord> toQueryWrapper(String columnPrefix) {
        QueryWrapper<PrescriptionOrderRecord> wrapper = Wrappers.<PrescriptionOrderRecord>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        wrapper.eq(this.getOrderId() != null, columnPrefix + "order_id", this.getOrderId());
        if (this.getOrderNo() != null) {
            if (this.getOrderNo().startsWith("%") && this.getOrderNo().endsWith("%")) {
                wrapper.like(columnPrefix + "order_no", this.getOrderNo().substring(1, this.getOrderNo().length() - 1));
            } else if (this.getOrderNo().startsWith("%") && !this.getOrderNo().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "order_no", this.getOrderNo().substring(1));
            } else if (this.getOrderNo().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "order_no", this.getOrderNo().substring(0, this.getOrderNo().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "order_no", this.getOrderNo());
            }
        }
        wrapper.eq(this.getPrescriptionId() != null, columnPrefix + "prescription_id", this.getPrescriptionId());
        if (this.getPrescriptionIntroduce() != null) {
            if (this.getPrescriptionIntroduce().startsWith("%") && this.getPrescriptionIntroduce().endsWith("%")) {
                wrapper.like(columnPrefix + "prescription_introduce", this.getPrescriptionIntroduce().substring(1, this.getPrescriptionIntroduce().length() - 1));
            } else if (this.getPrescriptionIntroduce().startsWith("%") && !this.getPrescriptionIntroduce().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "prescription_introduce", this.getPrescriptionIntroduce().substring(1));
            } else if (this.getPrescriptionIntroduce().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "prescription_introduce", this.getPrescriptionIntroduce().substring(0, this.getPrescriptionIntroduce().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "prescription_introduce", this.getPrescriptionIntroduce());
            }
        }
        if (this.getPrescriptionImage() != null) {
            if (this.getPrescriptionImage().startsWith("%") && this.getPrescriptionImage().endsWith("%")) {
                wrapper.like(columnPrefix + "prescription_image", this.getPrescriptionImage().substring(1, this.getPrescriptionImage().length() - 1));
            } else if (this.getPrescriptionImage().startsWith("%") && !this.getPrescriptionImage().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "prescription_image", this.getPrescriptionImage().substring(1));
            } else if (this.getPrescriptionImage().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "prescription_image", this.getPrescriptionImage().substring(0, this.getPrescriptionImage().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "prescription_image", this.getPrescriptionImage());
            }
        }
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
