/**
 * 项目：互联网医疗
 * 模型分组：系统管理
 * 模型名称：配置表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.domain.Setting;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class SettingParam extends BaseParam<Setting> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 名称
     */
    @Parameter(description = "名称")
    private String name;
    /**
     * 代码
     */
    @Parameter(description = "代码")
    private String code;
    /**
     * 值
     */
    @Parameter(description = "值")
    private String value;
    /**
     * 说明
     */
    @Parameter(description = "说明")
    private String remark;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间")
    private java.util.Date updateTime;
    /**
     * 更新时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     * 更新时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<Setting> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<Setting> toQueryWrapper(String columnPrefix) {
        QueryWrapper<Setting> wrapper = Wrappers.<Setting>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        if (this.getName() != null) {
            if (this.getName().startsWith("%") && this.getName().endsWith("%")) {
                wrapper.like(columnPrefix + "name", this.getName().substring(1, this.getName().length() - 1));
            } else if (this.getName().startsWith("%") && !this.getName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "name", this.getName().substring(1));
            } else if (this.getName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "name", this.getName().substring(0, this.getName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "name", this.getName());
            }
        }
        if (this.getCode() != null) {
            if (this.getCode().startsWith("%") && this.getCode().endsWith("%")) {
                wrapper.like(columnPrefix + "code", this.getCode().substring(1, this.getCode().length() - 1));
            } else if (this.getCode().startsWith("%") && !this.getCode().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "code", this.getCode().substring(1));
            } else if (this.getCode().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "code", this.getCode().substring(0, this.getCode().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "code", this.getCode());
            }
        }
        if (this.getValue() != null) {
            if (this.getValue().startsWith("%") && this.getValue().endsWith("%")) {
                wrapper.like(columnPrefix + "value", this.getValue().substring(1, this.getValue().length() - 1));
            } else if (this.getValue().startsWith("%") && !this.getValue().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "value", this.getValue().substring(1));
            } else if (this.getValue().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "value", this.getValue().substring(0, this.getValue().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "value", this.getValue());
            }
        }
        if (this.getRemark() != null) {
            if (this.getRemark().startsWith("%") && this.getRemark().endsWith("%")) {
                wrapper.like(columnPrefix + "remark", this.getRemark().substring(1, this.getRemark().length() - 1));
            } else if (this.getRemark().startsWith("%") && !this.getRemark().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "remark", this.getRemark().substring(1));
            } else if (this.getRemark().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "remark", this.getRemark().substring(0, this.getRemark().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "remark", this.getRemark());
            }
        }
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
