/**
 * 项目：互联网医疗
 * 模型分组：系统管理
 * 模型名称：用户角色关系表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.domain.UserRole;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class UserRoleParam extends BaseParam<UserRole> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 用户Id
     */
    @Parameter(description = "用户Id")
    private Long userId;
    /**
     * 角色Id
     */
    @Parameter(description = "角色Id")
    private Long roleId;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<UserRole> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<UserRole> toQueryWrapper(String columnPrefix) {
        QueryWrapper<UserRole> wrapper = Wrappers.<UserRole>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        wrapper.eq(this.getUserId() != null, columnPrefix + "user_id", this.getUserId());
        wrapper.eq(this.getRoleId() != null, columnPrefix + "role_id", this.getRoleId());
        return wrapper;
    }

}
