/**
 * 项目：互联网医疗
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.res;

import lombok.Getter;

public enum ApiCode {
    SUCCESS(0, "success"),
    FAILED(-1, "fail"),
    UNAUTHC(401, "You haven't signed in yet!"),
    UNAUTHZ(403, "You are not authorized!"),
    SERVER_ERROR(500, "server error!"),
    ORDER_CREATE_FAIL(700,"订单创建失败");

    private int code = 0;
    private String message = "success";

    ApiCode(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public ApiException ex() {
        return new ApiException(this);
    }

    public ApiException ex(String message) {
        this.message = message;
        return new ApiException(this);
    }

    @Getter
    public static class ApiException extends RuntimeException {
        private int code;
        private String message;

        public ApiException(ApiCode apiCode) {
            this.code = apiCode.getCode();
            this.message = apiCode.getMessage();
        }

        public ApiException(int code, String message) {
            this.code = code;
            this.message = message;
        }
    }
}
