package com.xwd.hospital.server.service;

import com.google.gson.JsonObject;
import com.xwd.hospital.server.rest.thirdPartReq.BindNumberReq;
import com.xwd.hospital.server.rest.thirdPartReq.UnbindNumberReq;
import org.springframework.web.bind.annotation.RequestBody;
import retrofit2.Call;
import retrofit2.http.*;

import java.util.Map;

public interface CallApiService {


    /**
     * XB模式
     * @param headers
     * @param body
     * @param account
     * @param sig
     * @return
     */
    @POST("/v20160818/rlxh/midNumBind/{account}")
    Call<JsonObject> bindNumber(@HeaderMap Map<String, String> headers, @Body BindNumberReq body, @Path("account") String account, @Query("sig") String sig);

    /**
     * AXB模式
     * @param headers
     * @param body
     * @param account
     * @param sig
     * @return
     */
    @POST("/v20160818/rlxh/midNumUnBindForAXB/{account}")
    Call<JsonObject> bindNumberForAXB(@HeaderMap Map<String, String> headers, @Body BindNumberReq body, @Path("account") String account, @Query("sig") String sig);

    @FormUrlEncoded
    @POST("/v20160818/rlxh/midNumUnBinding/{account}")
    Call<JsonObject> unbindNumber(@HeaderMap Map<String, String> headers, @Body UnbindNumberReq body, @Path("account") String account, @Query("sig") String sig);
}
