package com.xwd.hospital.server.service;

import com.google.gson.JsonObject;
import com.xwd.hospital.server.rest.thirdPartReq.BindIMUserReq;
import com.xwd.hospital.server.rest.thirdPartReq.UpdateIMUserReq;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.POST;
import retrofit2.http.Query;

public interface IMApiService {

    /**
     * IM模式-添加用户
     * @param body
     * @param sdkappid
     * @param identifier
     * @param usersig
     * @param random
     * @param contenttype
     * @return
     */
    @POST("/v4/im_open_login_svc/account_import")
    Call<JsonObject> addUserToIMSystem(@Body BindIMUserReq body,
                                       @Query("sdkappid") Long sdkappid,
                                       @Query("identifier") String identifier,
                                       @Query("usersig") String usersig,
                                       @Query("random") String random,
                                       @Query("contenttype") String contenttype);

    /**
     * IM模式-修改用户信息
     * @param body
     * @param sdkappid
     * @param identifier
     * @param usersig
     * @param random
     * @param contenttype
     * @return
     */
    @POST("v4/profile/portrait_set")
    Call<JsonObject> updateUserProfile(@Body UpdateIMUserReq body,
                                       @Query("sdkappid") Long sdkappid,
                                       @Query("identifier") String identifier,
                                       @Query("usersig") String usersig,
                                       @Query("random") String random,
                                       @Query("contenttype") String contenttype);
}
