/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：订单表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xwd.hospital.server.base.BaseService;
import com.xwd.hospital.server.domain.Order;
import com.xwd.hospital.server.dto.*;
import com.xwd.hospital.server.enums.OrderStateEnum;

public interface OrderService extends BaseService<Order> {

    OrderDetailDto queryOrderById(Long id);

    IPage<OrderDto> queryOrderListForMiniApp(Page page, OrderStateEnum state);

    Order createOrder(CreateOrderDto createOrderDto);

    Order cancelOrder(String orderNo);

    Order rejectOrder(RejectOrderDto rejectOrderDto);

    Order acceptOrder(String orderNo);

    Order stratImChat(String orderNo);

    String callPhone(String orderNo);

    Order submitPrescriptionInfo(PrescriptionInfoDto prescriptionInfoDto);

    Order completeOrder(String orderNo);

    Order appraiseOrder(AppraiseDto appraiseDto);
}
