/**
 * 项目：互联网医疗
 * 模型分组：系统管理
 * 模型名称：用户表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.service;

import java.util.List;
import com.xwd.hospital.server.base.BaseService;
import com.xwd.hospital.server.domain.User;
import com.xwd.hospital.server.dto.*;
import com.xwd.hospital.server.rest.req.UserParam;

public interface UserService extends BaseService<User> {
    /**
     * 保存
     * @param entity
     * @return
     */
    boolean save(User entity);

    /**
     * 更新
     * @param entity
     * @return
     */
    boolean updateById(User entity);
    /**
     * 登录
     * @param username
     * @param password
     * @return
     */
    User login(String username, String password);

    /**
     * 用户注册
     * @param user
     * @param roleName
     * @return
     */
    User register(User user, String roleName);

    /**
     * 根据username查询
     * @param username
     * @return
     */
    User selectByUsername(String username);

    /**
     * 小程序登录
     * @return
     */
    UserDto miniAppLogin(LoginDto loginDto);

    /**
     * 小程序注册
     * @return
     */
    UserDto miniAppRegister(RegisterDto registserDto);

    /**
     * 更新用户信息
     * @return
     */
    UserDto updateUserInfo(UpdateUserInfoDto updateInfoDto);

    UserDto wxUpdate(UpdateInfoDto updateUserDto);

    /**
     * 微信获取手机号码
     * @return
     */
    String getPhoneNumber(LoginDto loginDto);

    /**
     * 获取IM用户签名
     * @return
     */
    String getIMSig(Long userId);

    public void addUserToIMSystem(String imUserId,String nickName,String headUrl);

}
