/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：优惠券信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.service.impl;

import java.util.ArrayList;
import java.util.Collection;

import com.xwd.hospital.server.domain.UserCouponInfo;
import com.xwd.hospital.server.dto.ConsumerCouponInfoDto;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.xwd.hospital.server.enums.CouponUseStateEnum;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.service.UserCouponInfoService;
import jakarta.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.xwd.hospital.server.service.CouponInfoService;
import com.xwd.hospital.server.repository.CouponInfoMapper;
import com.xwd.hospital.server.repository.base.CouponInfoBaseMapper;
import com.xwd.hospital.server.domain.CouponInfo;

@Service
public class CouponInfoServiceImpl extends ServiceImpl<CouponInfoMapper, CouponInfo> implements CouponInfoService {

    @Resource
    private UserCouponInfoService userCouponInfoService;

    @Override
    public int updateAllFieldsById(CouponInfo entity) {
        return this.getBaseMapper().updateAllFieldsById(entity);
    }

    /**
     * 批量插入
     *
     * @param entityList ignore
     * @param batchSize  ignore
     * @return ignore
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveBatch(Collection<CouponInfo> entityList, int batchSize) {
        String sqlStatement = SqlHelper.getSqlStatement(CouponInfoBaseMapper.class, SqlMethod.INSERT_ONE);
        return executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }

    @Override
    public boolean consumerCoupons(ConsumerCouponInfoDto dto) {
        CouponInfo couponInfo = this.getById(dto.getCouponId());
        //todo 全体发优惠券
        if(dto.getIsAll()){

        }else {
            if(null != dto.getConsumerList()
                    && dto.getConsumerList().size()>0){
                ArrayList<UserCouponInfo> list = new ArrayList<>(dto.getConsumerList().size());
                for (Long consumerId:dto.getConsumerList()) {
                    UserCouponInfo userCouponInfo = new UserCouponInfo();
                    userCouponInfo.setUserInfoId(consumerId);
                    userCouponInfo.setCouponId(dto.getCouponId());
                    userCouponInfo.setCouponName(couponInfo.getCouponName());
                    userCouponInfo.setCouponType(couponInfo.getCouponType());
                    userCouponInfo.setCouponDiscount(couponInfo.getCouponDiscount());
                    userCouponInfo.setCouponStartDate(couponInfo.getCouponStartDate());
                    userCouponInfo.setCouponEndDate(couponInfo.getCouponEndDate());
                    userCouponInfo.setCouponUseState(CouponUseStateEnum.USEABLE);
                    list.add(userCouponInfo);
                }
                userCouponInfoService.saveBatch(list);
            }
        }

        return true;
    }
}
