/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：科室信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.service.impl;

import java.io.Serializable;
import java.util.*;

import com.xwd.hospital.server.domain.User;
import com.xwd.hospital.server.dto.DepartmentDto;
import com.xwd.hospital.server.enums.DepartmentLevelEnum;
import com.xwd.hospital.server.enums.DepartmentLevelType;
import com.xwd.hospital.server.enums.YesNoEnum;
import jakarta.annotation.Resource;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.xwd.hospital.server.service.DepartmentInfoService;
import com.xwd.hospital.server.repository.DepartmentInfoMapper;
import com.xwd.hospital.server.repository.base.DepartmentInfoBaseMapper;
import com.xwd.hospital.server.domain.DepartmentInfo;
import com.xwd.hospital.server.rest.req.DepartmentInfoParam;

@Service
public class DepartmentInfoServiceImpl extends ServiceImpl<DepartmentInfoMapper, DepartmentInfo> implements DepartmentInfoService {

    @Override
    public int updateAllFieldsById(DepartmentInfo entity) {
        return this.getBaseMapper().updateAllFieldsById(entity);
    }

    /**
     * 批量插入
     *
     * @param entityList ignore
     * @param batchSize  ignore
     * @return ignore
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveBatch(Collection<DepartmentInfo> entityList, int batchSize) {
        String sqlStatement = SqlHelper.getSqlStatement(DepartmentInfoBaseMapper.class, SqlMethod.INSERT_ONE);
        return executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }

    @Override
    public List queryAllDepartment(YesNoEnum showHidden) {
        List<DepartmentDto> departmentDtos = this.getBaseMapper().queryAllDepartment(showHidden);

        return buildDepartmentDto(departmentDtos);
    }

    public static List<DepartmentDto> buildDepartmentDto(List<DepartmentDto> departmentList) {
        List<DepartmentDto> parentDepartmentList = new ArrayList<>();
        Map<Long, DepartmentDto> departmentMap = new HashMap<>();

        for (DepartmentDto departmentDto : departmentList) {
            departmentMap.put(departmentDto.getId(), departmentDto);
        }

        for (DepartmentDto departmentDto : departmentList) {
            if (departmentDto.getParentId() != null && departmentDto.getParentId() != 0) {
                DepartmentDto parent = departmentMap.get(departmentDto.getParentId());
                if (parent != null) {
                    parent.getChildList().add(departmentDto);
                }
            } else {
                parentDepartmentList.add(departmentDto);
            }
        }

        return parentDepartmentList;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean hiddenDepartment(YesNoEnum showHidden, Long departmentId) {
        DepartmentInfo departmentInfo = this.getById(departmentId);
        if (null == departmentInfo) {
            return false;
        }
        departmentInfo.setHiddenStatus(showHidden);
        this.updateById(departmentInfo);

        //如果是一级菜单，同时隐藏或取消下面的二级菜单
        if(departmentInfo.getDepartmentLevel() == DepartmentLevelEnum.FIRST_LEVEL){
            List<DepartmentInfo> departmentInfoList = this.list(Wrappers.<DepartmentInfo>query()
                    .eq("parent_id", departmentInfo.getId()));
            //从departmentInfoList中取出id生成新的list
            for (DepartmentInfo childDepartment : departmentInfoList) {
                childDepartment.setHiddenStatus(showHidden);
            }
            this.updateBatchById(departmentInfoList);
        }
        return true;
    }
}
