/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：家庭医生地址关系表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.service.impl;

import java.io.Serializable;
import java.util.List;
import java.util.ArrayList;
import java.util.Collection;

import jakarta.annotation.Resource;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.xwd.hospital.server.service.DoctorFamilyAddressInfoService;
import com.xwd.hospital.server.repository.DoctorFamilyAddressInfoMapper;
import com.xwd.hospital.server.repository.base.DoctorFamilyAddressInfoBaseMapper;
import com.xwd.hospital.server.domain.DoctorFamilyAddressInfo;
import com.xwd.hospital.server.rest.req.DoctorFamilyAddressInfoParam;

@Service
public class DoctorFamilyAddressInfoServiceImpl extends ServiceImpl<DoctorFamilyAddressInfoMapper, DoctorFamilyAddressInfo> implements DoctorFamilyAddressInfoService {

    @Override
    public int updateAllFieldsById(DoctorFamilyAddressInfo entity) {
        return this.getBaseMapper().updateAllFieldsById(entity);
    }

    /**
     * 批量插入
     *
     * @param entityList ignore
     * @param batchSize  ignore
     * @return ignore
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveBatch(Collection<DoctorFamilyAddressInfo> entityList, int batchSize) {
        String sqlStatement = SqlHelper.getSqlStatement(DoctorFamilyAddressInfoBaseMapper.class, SqlMethod.INSERT_ONE);
        return executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }


}
