/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：医生信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.service.impl;

import java.io.Serializable;
import java.util.List;
import java.util.ArrayList;
import java.util.Collection;

import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.xwd.hospital.server.domain.*;
import com.xwd.hospital.server.dto.DiseaseDto;
import com.xwd.hospital.server.dto.DoctorDto;
import com.xwd.hospital.server.dto.DoctorInfoDto;
import com.xwd.hospital.server.enums.DepartmentLevelEnum;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.rest.req.DoctorSearchParam;
import com.xwd.hospital.server.service.*;
import jakarta.annotation.Resource;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.xwd.hospital.server.repository.DoctorInfoMapper;
import com.xwd.hospital.server.repository.base.DoctorInfoBaseMapper;
import com.xwd.hospital.server.rest.req.DoctorInfoParam;

@Service
public class DoctorInfoServiceImpl extends ServiceImpl<DoctorInfoMapper, DoctorInfo> implements DoctorInfoService {
    @Resource
    private DepartmentInfoService departmentInfoService;
    @Resource
    private DoctorServiceInfoService doctorServiceInfoService;
    @Resource
    private UserAttentionInfoService userAttentionInfoService;
    @Resource
    private UserInfoService userInfoService;

    @Override
    public int updateAllFieldsById(DoctorInfo entity) {
        return this.getBaseMapper().updateAllFieldsById(entity);
    }

    /**
     * 批量插入
     *
     * @param entityList ignore
     * @param batchSize  ignore
     * @return ignore
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveBatch(Collection<DoctorInfo> entityList, int batchSize) {
        String sqlStatement = SqlHelper.getSqlStatement(DoctorInfoBaseMapper.class, SqlMethod.INSERT_ONE);
        return executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }

    @Override
    public List<DoctorDto> queryDoctorList(DoctorSearchParam param) {
        List<Long> departmentIdList = new ArrayList<>();
        if( null != param.getDepartmentId()){
            DepartmentInfo department = departmentInfoService.getById(param.getDepartmentId());
            if (null != department && department.getHiddenStatus() == YesNoEnum.NO ){
                if (department.getDepartmentLevel() == DepartmentLevelEnum.FIRST_LEVEL) {
                    //一级菜单id输入查询所以二级菜单列表
                    List<DepartmentInfo> departmentInfoList = departmentInfoService.list(Wrappers.<DepartmentInfo>query()
                                                                                    .eq("parent_id", param.getDepartmentId())
                                                                                    .eq("hidden_status", YesNoEnum.NO));
                    //从departmentInfoList中取出id生成新的list
                    for (DepartmentInfo departmentInfo : departmentInfoList) {
                        departmentIdList.add(departmentInfo.getId());
                    }
                }else {
                    departmentIdList.add(param.getDepartmentId());
                }
            }
        }
        //param传入一级菜单departmentId,同时此一级菜单下无二级菜单，此时应无医生可查询出
        if(departmentIdList.size() == 0){
            departmentIdList.add(0L);
        }

        return this.getBaseMapper().queryDoctorList(param.getSickness(),param.getDoctorName(),param.getDepartmentName(),departmentIdList);
    }

    @Override
    public DoctorInfoDto queryDoctorDetail(Long doctorId) {
        //当前用户
        Object userId = StpUtil.getExtra("userId");
        UserInfo userInfo = userInfoService.getOne(Wrappers.<UserInfo>query().eq("user_id", Long.valueOf(userId.toString())));
        if(null == userInfo){
            return null;
        }

        DoctorInfoDto doctorInfoDto = this.getBaseMapper().queryDoctorDetail(doctorId);
        List<DoctorServiceInfo> doctorServiceInfoList = doctorServiceInfoService.list(Wrappers.<DoctorServiceInfo>query().eq("doctor_id", doctorId));
        doctorInfoDto.setDoctorServiceInfoList(doctorServiceInfoList);

        UserAttentionInfo attentionInfo = userAttentionInfoService.getOne(Wrappers.<UserAttentionInfo>query().eq("doctor_id", doctorId)
                .eq("user_info_id", userInfo.getId()));
        if(null != attentionInfo){
            doctorInfoDto.setAttentionStatus(true);
            doctorInfoDto.setAttentionId(attentionInfo.getId());
        }else {
            doctorInfoDto.setAttentionStatus(false);
        }
        List<DiseaseDto> diseaseDtos = this.getBaseMapper().queryDiseaseList(doctorId);
        if (CollectionUtil.isEmpty(diseaseDtos)){
            doctorInfoDto.setDiseaseList(new ArrayList<>());
        }else {
            doctorInfoDto.setDiseaseList(diseaseDtos);
        }

        return doctorInfoDto;
    }
}
