/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：邀请信息记录表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.service.impl;

import java.io.Serializable;
import java.util.List;
import java.util.ArrayList;
import java.util.Collection;

import jakarta.annotation.Resource;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.xwd.hospital.server.service.InviteRegisterRecordService;
import com.xwd.hospital.server.repository.InviteRegisterRecordMapper;
import com.xwd.hospital.server.repository.base.InviteRegisterRecordBaseMapper;
import com.xwd.hospital.server.domain.InviteRegisterRecord;
import com.xwd.hospital.server.rest.req.InviteRegisterRecordParam;

@Service
public class InviteRegisterRecordServiceImpl extends ServiceImpl<InviteRegisterRecordMapper, InviteRegisterRecord> implements InviteRegisterRecordService {

    @Override
    public int updateAllFieldsById(InviteRegisterRecord entity) {
        return this.getBaseMapper().updateAllFieldsById(entity);
    }

    /**
     * 批量插入
     *
     * @param entityList ignore
     * @param batchSize  ignore
     * @return ignore
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveBatch(Collection<InviteRegisterRecord> entityList, int batchSize) {
        String sqlStatement = SqlHelper.getSqlStatement(InviteRegisterRecordBaseMapper.class, SqlMethod.INSERT_ONE);
        return executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }


}
