/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：医生医疗资质信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.service.impl;

import java.io.Serializable;
import java.util.List;
import java.util.ArrayList;
import java.util.Collection;

import cn.dev33.satoken.stp.StpUtil;
import com.xwd.hospital.server.domain.*;
import com.xwd.hospital.server.dto.MedicalQualificationDto;
import com.xwd.hospital.server.enums.AuditStateEnum;
import com.xwd.hospital.server.service.*;
import jakarta.annotation.Resource;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.xwd.hospital.server.repository.MedicalQualificationsMapper;
import com.xwd.hospital.server.repository.base.MedicalQualificationsBaseMapper;
import com.xwd.hospital.server.rest.req.MedicalQualificationsParam;

@Service
public class MedicalQualificationsServiceImpl extends ServiceImpl<MedicalQualificationsMapper, MedicalQualifications> implements MedicalQualificationsService {
    @Resource
    private DoctorInfoService doctorInfoService;
    @Resource
    private UserService userService;
    @Resource
    private MedicalQualificationsPictureService pictureService;

    @Override
    public int updateAllFieldsById(MedicalQualifications entity) {
        return this.getBaseMapper().updateAllFieldsById(entity);
    }

    /**
     * 批量插入
     *
     * @param entityList ignore
     * @param batchSize  ignore
     * @return ignore
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveBatch(Collection<MedicalQualifications> entityList, int batchSize) {
        String sqlStatement = SqlHelper.getSqlStatement(MedicalQualificationsBaseMapper.class, SqlMethod.INSERT_ONE);
        return executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }

    @Override
    public DoctorInfo uploadQualification(MedicalQualificationDto dto) {
        //当前用户
        Object userId = StpUtil.getExtra("userId");
        DoctorInfo doctorInfo = doctorInfoService.getOne(Wrappers.<DoctorInfo>query().eq("user_id", Long.valueOf(userId.toString())));
        if(null == doctorInfo){
            return null;
        }
        User sysUser = userService.getById(Long.valueOf(userId.toString()));

        //查询医生资质信息
        MedicalQualifications qualifications = this.getOne(Wrappers.<MedicalQualifications>query().eq("doctor_id", doctorInfo.getId()));
        if(null == qualifications){
            qualifications = new MedicalQualifications();
            qualifications.setDoctorId(doctorInfo.getId());
        }
        qualifications.setHospitalId(dto.getHospitalId());
        qualifications.setDepartmentId(dto.getDepartmentId());
        qualifications.setTitle(dto.getTitle());
        qualifications.setEditorId(sysUser.getId());
        qualifications.setEditorName(sysUser.getUsername());
        qualifications.setAuditState(AuditStateEnum.TO_AUDIT);
        this.saveOrUpdate(qualifications);

        if(null != dto.getPictureList()
            && dto.getPictureList().size()>0){
            //删除原有的照片
            pictureService.remove(Wrappers.<MedicalQualificationsPicture>query().eq("doctor_id", doctorInfo.getId()));

            //再插入新的图片
            ArrayList<MedicalQualificationsPicture> pictureList = new ArrayList<>();
            for (String picUrl:dto.getPictureList()) {
                MedicalQualificationsPicture picture = new MedicalQualificationsPicture();
                picture.setDoctorId(doctorInfo.getId());
                picture.setMedicalQualificationId(qualifications.getId());
                picture.setCertificatePicture(picUrl);
                picture.setEditorId(sysUser.getId());
                picture.setEditorName(sysUser.getUsername());
                pictureList.add(picture);
            }
            pictureService.saveBatch(pictureList);
        }
        doctorInfo.setMedicalQualificationId(qualifications.getId());
        doctorInfoService.saveOrUpdate(doctorInfo);
        return doctorInfo;
    }
}
