/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：就诊人处方信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.service.impl;

import java.io.Serializable;
import java.util.List;
import java.util.ArrayList;
import java.util.Collection;

import cn.dev33.satoken.stp.StpUtil;
import com.xwd.hospital.server.domain.PatientPrescriptionInfoPicture;
import com.xwd.hospital.server.domain.User;
import com.xwd.hospital.server.domain.UserInfo;
import com.xwd.hospital.server.dto.CreatePrescriptionDto;
import com.xwd.hospital.server.service.PatientPrescriptionInfoPictureService;
import com.xwd.hospital.server.service.UserInfoService;
import com.xwd.hospital.server.service.UserService;
import jakarta.annotation.Resource;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.xwd.hospital.server.service.PatientPrescriptionInfoService;
import com.xwd.hospital.server.repository.PatientPrescriptionInfoMapper;
import com.xwd.hospital.server.repository.base.PatientPrescriptionInfoBaseMapper;
import com.xwd.hospital.server.domain.PatientPrescriptionInfo;
import com.xwd.hospital.server.rest.req.PatientPrescriptionInfoParam;

@Service
public class PatientPrescriptionInfoServiceImpl extends ServiceImpl<PatientPrescriptionInfoMapper, PatientPrescriptionInfo> implements PatientPrescriptionInfoService {
    @Resource
    private UserInfoService userInfoService;
    @Resource
    private UserService userService;
    @Resource
    private PatientPrescriptionInfoPictureService pictureService;

    @Override
    public int updateAllFieldsById(PatientPrescriptionInfo entity) {
        return this.getBaseMapper().updateAllFieldsById(entity);
    }

    /**
     * 批量插入
     *
     * @param entityList ignore
     * @param batchSize  ignore
     * @return ignore
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveBatch(Collection<PatientPrescriptionInfo> entityList, int batchSize) {
        String sqlStatement = SqlHelper.getSqlStatement(PatientPrescriptionInfoBaseMapper.class, SqlMethod.INSERT_ONE);
        return executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }

    @Override
    public PatientPrescriptionInfo create(CreatePrescriptionDto dto) {
        Object userId = StpUtil.getExtra("userId");
        UserInfo userInfo = userInfoService.getOne(Wrappers.<UserInfo>query().eq("user_id", Long.valueOf(userId.toString())));
        if(null == userInfo){
            return null;
        }
        User sysUser = userService.getById(Long.valueOf(userId.toString()));

        PatientPrescriptionInfo patientPrescriptionInfo = new PatientPrescriptionInfo();
        patientPrescriptionInfo.setPatientId(dto.getPatientId());
        patientPrescriptionInfo.setHospitalName(dto.getHospitalName());
        patientPrescriptionInfo.setDepartmentName(dto.getDepartmentName());
        patientPrescriptionInfo.setPrescriptionTime(dto.getPrescriptionTime());
        patientPrescriptionInfo.setPrescriptionIntroduce(dto.getPrescriptionIntroduce());
        patientPrescriptionInfo.setEditorId(sysUser.getId());
        patientPrescriptionInfo.setEditorName(sysUser.getUsername());
        boolean save = this.save(patientPrescriptionInfo);

        if(null != dto.getPictureList()
            && dto.getPictureList().size()>0){
            ArrayList<PatientPrescriptionInfoPicture> pictureList = new ArrayList<>();
            for (String picUrl:dto.getPictureList()) {
                PatientPrescriptionInfoPicture infoPicture = new PatientPrescriptionInfoPicture();
                infoPicture.setPatientPrescriptionInfoId(patientPrescriptionInfo.getId());
                infoPicture.setPrescriptionPicture(picUrl);
                infoPicture.setEditorId(sysUser.getId());
                infoPicture.setEditorName(sysUser.getUsername());
                pictureList.add(infoPicture);
            }
            pictureService.saveBatch(pictureList);
        }

        return patientPrescriptionInfo;
    }
}
