/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：电话咨询订单记录信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.service.impl;

import java.io.Serializable;
import java.util.List;
import java.util.ArrayList;
import java.util.Collection;

import jakarta.annotation.Resource;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.xwd.hospital.server.service.PhoneOrderRecordService;
import com.xwd.hospital.server.repository.PhoneOrderRecordMapper;
import com.xwd.hospital.server.repository.base.PhoneOrderRecordBaseMapper;
import com.xwd.hospital.server.domain.PhoneOrderRecord;
import com.xwd.hospital.server.rest.req.PhoneOrderRecordParam;

@Service
public class PhoneOrderRecordServiceImpl extends ServiceImpl<PhoneOrderRecordMapper, PhoneOrderRecord> implements PhoneOrderRecordService {

    @Override
    public int updateAllFieldsById(PhoneOrderRecord entity) {
        return this.getBaseMapper().updateAllFieldsById(entity);
    }

    /**
     * 批量插入
     *
     * @param entityList ignore
     * @param batchSize  ignore
     * @return ignore
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveBatch(Collection<PhoneOrderRecord> entityList, int batchSize) {
        String sqlStatement = SqlHelper.getSqlStatement(PhoneOrderRecordBaseMapper.class, SqlMethod.INSERT_ONE);
        return executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }


}
