package com.xwd.hospital.server.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.gson.JsonObject;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.sms.v20210111.SmsClient;
import com.tencentcloudapi.sms.v20210111.models.SendSmsRequest;
import com.tencentcloudapi.sms.v20210111.models.SendSmsResponse;
import com.xwd.hospital.server.constants.Constant;
import com.xwd.hospital.server.domain.PhoneOrderRecord;
import com.xwd.hospital.server.domain.Setting;
import com.xwd.hospital.server.dto.CallDto;
import com.xwd.hospital.server.enums.SysSettingEnum;
import com.xwd.hospital.server.enums.UseStateEnum;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.rest.thirdPartReq.BindNumberReq;
import com.xwd.hospital.server.rest.thirdPartReq.UnbindNumberReq;
import com.xwd.hospital.server.service.*;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;

@Service
@Slf4j
public class SmsServiceImpl implements SmsService {
    @Resource
    private RedisService redisService;
    @Resource
    private PhoneOrderRecordService phoneOrderRecordService;
    @Resource
    private SettingService settingService;

    @Value("${tencent.cloud.secretId}")
    private String secretId;
    @Value("${tencent.cloud.secretKey}")
    private String secretKey;
    @Value("${tencent.cloud.sms.sdkAppId}")
    private String sdkAppId;
    @Value("${tencent.cloud.sms.templateId}")
    private String templateId;

    @Value("${ronglian.cloud.account}")
    public String account;//替换为您的账户
    @Value("${ronglian.cloud.secret}")
    public String secret;//替换为您的api密码
    @Value("${ronglian.cloud.host}")
    public String host;

    @Override
    public String sendSms(String phoneNumber) {
        //随机生成六位数字验证码
        Random random = new Random();
        // 生成一个100000到999999之间的随机整数
        int randomNumber = random.nextInt(900000) + 100000;
        //调用短信sdk发送短信
        //todo 暂时屏蔽短信接口
        sendAuth(String.valueOf(randomNumber),phoneNumber);
        //存入redis中，缓存默认5分钟失效
        redisService.setExpire(Constant.SMS_PREFIX+phoneNumber,String.valueOf(randomNumber),5, TimeUnit.MINUTES);
        return String.valueOf(randomNumber);
    }

    public void sendAuth(String authNumber,String phone) {
        try {
            Credential cred = new Credential(secretId, secretKey);
            // 实例化一个http选项，可选，没有特殊需求可以跳过
            HttpProfile httpProfile = new HttpProfile();
            httpProfile.setReqMethod("POST");
            httpProfile.setConnTimeout(60);
            httpProfile.setEndpoint("sms.tencentcloudapi.com");
            /* 非必要步骤:
             * 实例化一个客户端配置对象，可以指定超时时间等配置 */
            ClientProfile clientProfile = new ClientProfile();
            /* SDK默认用TC3-HMAC-SHA256进行签名
             * 非必要请不要修改这个字段 */
            clientProfile.setSignMethod("HmacSHA256");
            clientProfile.setHttpProfile(httpProfile);

            SmsClient client = new SmsClient(cred, "ap-nanjing",clientProfile);
            SendSmsRequest req = new SendSmsRequest();
            /* 短信应用ID: 短信SdkAppId在 [短信控制台] 添加应用后生成的实际SdkAppId，示例如1400006666 */
            req.setSmsSdkAppId(sdkAppId);

            /* 短信签名内容: 使用 UTF-8 编码，必须填写已审核通过的签名 */
            // 签名信息可前往 [国内短信](https://console.cloud.tencent.com/smsv2/csms-sign) 或 [国际/港澳台短信](https://console.cloud.tencent.com/smsv2/isms-sign) 的签名管理查看
            String signName = "海思临科";
            req.setSignName(signName);

            /* 模板 ID: 必须填写已审核通过的模板 ID */
            req.setTemplateId(templateId);

            /* 模板参数: 模板参数的个数需要与 TemplateId 对应模板的变量个数保持一致，若无模板参数，则设置为空 */
            String[] templateParamSet = {authNumber};
            req.setTemplateParamSet(templateParamSet);

            /* 下发手机号码，采用 E.164 标准，+[国家或地区码][手机号]
             * 示例如：+8613711112222， 其中前面有一个+号 ，86为国家码，13711112222为手机号，最多不要超过200个手机号 */
            String[] phoneNumberSet = {"+86"+phone};
            req.setPhoneNumberSet(phoneNumberSet);

            /* 用户的 session 内容（无需要可忽略）: 可以携带用户侧 ID 等上下文信息，server 会原样返回 */
//            String sessionContext = "";
//            req.setSessionContext(sessionContext);

            /* 短信码号扩展号（无需要可忽略）: 默认未开通，如需开通请联系 [腾讯云短信小助手] */
//            String extendCode = "";
//            req.setExtendCode(extendCode);

            /* 国内短信无需填写该项；国际/港澳台短信已申请独立 SenderId 需要填写该字段，默认使用公共 SenderId，无需填写该字段。注：月度使用量达到指定量级可申请独立 SenderId 使用，详情请联系 [腾讯云短信小助手](https://cloud.tencent.com/document/product/382/3773#.E6.8A.80.E6.9C.AF.E4.BA.A4.E6.B5.81)。*/
//            String senderid = "";
//            req.setSenderId(senderid);


            /* 通过 client 对象调用 SendSms 方法发起请求。注意请求方法名与请求对象是对应的
             * 返回的 res 是一个 SendSmsResponse 类的实例，与请求对象对应 */
            SendSmsResponse res = client.SendSms(req);
            // 输出json格式的字符串回包
            log.info(SendSmsResponse.toJsonString(res));

        } catch (TencentCloudSDKException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String bindPhone(String proxyNumber,String phoneNumber) {
        String mappingId = "";
        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(host)
                .addConverterFactory(GsonConverterFactory.create())
                .client(new OkHttpClient.Builder().build())
                .build();
        CallApiService service = retrofit.create(CallApiService.class);

        Map<String, String> sigAndAuth = getSigAndAuth();

        HashMap<String, String> headers = new HashMap<>();
        headers.put("Authorization",sigAndAuth.get("auth"));

        BindNumberReq bindNumberReq = new BindNumberReq();
        bindNumberReq.setMidNum(proxyNumber);//小号
        bindNumberReq.setCalled(phoneNumber);//被叫号码
        log.info("绑定消耗中，小号{},被叫号码{}",proxyNumber,phoneNumber);
        Call<JsonObject> call = service.bindNumber(headers, bindNumberReq, account, sigAndAuth.get("sig"));
        try {
            Response<JsonObject> execute = call.execute();
            log.info("返回结果{}",execute.toString());
            mappingId = execute.body().get("mappingId").getAsString();
            log.info("绑定成功---------");
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return mappingId;
    }

    @Override
    public void unbindPhone(String proxyNumber, String mappingId) {

        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(host)
                .addConverterFactory(GsonConverterFactory.create())
                .client(new OkHttpClient.Builder().build())
                .build();
        CallApiService service = retrofit.create(CallApiService.class);

        Map<String, String> sigAndAuth = getSigAndAuth();

        HashMap<String, String> headers = new HashMap<>();
        headers.put("Authorization",sigAndAuth.get("auth"));

        UnbindNumberReq req = new UnbindNumberReq();
        req.setMappingId(mappingId);
        req.setMidNum(proxyNumber);

        Call<JsonObject> call = service.unbindNumber(headers, req, account, sigAndAuth.get("sig"));
        try {
            Response<JsonObject> execute = call.execute();
            log.info(execute.body().toString());
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String,String> getSigAndAuth () {
        String time = getDateTime();
        String sig = md5(account + secret + time);
        String auth = base64(account + ":" + time);

        HashMap<String, String> map = new HashMap<>();
        map.put("sig",sig);
        map.put("auth",auth);
        return map;
    }

    public static String md5 (String text) {
        return DigestUtils.md5Hex(text).toUpperCase();
    }
    public static String base64 (String text) {
        byte[] b = text.getBytes();
        Base64 base64 = new Base64();
        b = base64.encode(b);
        String s = new String(b);
        return s;
    }
    public static String getDateTime(){
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return sdf.format(new Date());
    }

    @Override
    public boolean callback(String alertingTime, String called, String recorderId, String callerArea,
                            String beginTime, String calledArea, String caller, String calledShow, String connectTime,
                            String result, String releaseTime, String account, String mappingId, String appId,
                            String callDuration, String userData, String answerTime, String smallNumberType, String calldisplay) {
        CallDto callDto = new CallDto(alertingTime,called,recorderId,  callerArea, beginTime,
                calledArea, caller,calledShow,  connectTime,  result,
                releaseTime, account,  mappingId,  appId,  callDuration,
                userData,  answerTime,  smallNumberType,  calldisplay);

        log.info("容联通话回调处理：------------------start，mappingId{}",mappingId);
        log.info("被叫振铃时间{},被叫真实号码{},企业本次通话唯一标识id{},主叫归属地{},主叫拨通虚拟号码时刻{},被叫归属地{},主叫号码{},小号{},被叫接通时刻{},通话状态{},通话结束时刻{},帐号编号{},绑定关系唯一Id{},应用id{},本次通话的时长{},用户自定义数据{},接通{},小号类型{},显真实号{}"
                ,alertingTime, called,  recorderId,  callerArea,
                 beginTime,  calledArea,  caller,  calledShow,  connectTime,
                 result,  releaseTime,  account,  mappingId,  appId,
                 callDuration,  userData,  answerTime,  smallNumberType,  calldisplay);
        if(result.equals("0")){//通话成功
            //根据mappingId查询phone_order_record表
            PhoneOrderRecord record = phoneOrderRecordService.getOne(Wrappers.<PhoneOrderRecord>query().eq("mapping_id", mappingId));
            if(null != record){
                //解绑
                unbindPhone(calledShow,mappingId);
                //修改sys_setting表，小号状态
                Setting setting = settingService.getOne(Wrappers.<Setting>query().eq("code", SysSettingEnum.PROXY_PHONE)
                        .eq("remark", UseStateEnum.USED.getName())
                        .eq("value", calledShow));
                if(null != setting){
                    setting.setRemark(UseStateEnum.USEABLE.getName());
                    settingService.saveOrUpdate(setting);
                }
                //修改phone_order_record表状态
                record.setMappingState(YesNoEnum.YES);
                record.setPhoneContactTime(connectTime);
                record .setPhoneReleaseTime(releaseTime);
                phoneOrderRecordService.saveOrUpdate(record);
            }

        }
        log.info("容联通话回调处理：------------------end，mappingId{}",mappingId);
        return true;
    }
}
