/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：用户地址关系表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.service.impl;

import java.io.Serializable;
import java.util.List;
import java.util.ArrayList;
import java.util.Collection;

import jakarta.annotation.Resource;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.xwd.hospital.server.service.UserAddressInfoService;
import com.xwd.hospital.server.repository.UserAddressInfoMapper;
import com.xwd.hospital.server.repository.base.UserAddressInfoBaseMapper;
import com.xwd.hospital.server.domain.UserAddressInfo;
import com.xwd.hospital.server.rest.req.UserAddressInfoParam;

@Service
public class UserAddressInfoServiceImpl extends ServiceImpl<UserAddressInfoMapper, UserAddressInfo> implements UserAddressInfoService {

    @Override
    public int updateAllFieldsById(UserAddressInfo entity) {
        return this.getBaseMapper().updateAllFieldsById(entity);
    }

    /**
     * 批量插入
     *
     * @param entityList ignore
     * @param batchSize  ignore
     * @return ignore
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveBatch(Collection<UserAddressInfo> entityList, int batchSize) {
        String sqlStatement = SqlHelper.getSqlStatement(UserAddressInfoBaseMapper.class, SqlMethod.INSERT_ONE);
        return executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }


}
