/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：用户优惠券关系表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.service.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.util.Collection;

import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUtil;
import com.xwd.hospital.server.domain.User;
import com.xwd.hospital.server.domain.UserInfo;
import com.xwd.hospital.server.enums.CouponUseStateEnum;
import com.xwd.hospital.server.service.UserInfoService;
import com.xwd.hospital.server.service.UserService;
import jakarta.annotation.Resource;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.xwd.hospital.server.service.UserCouponInfoService;
import com.xwd.hospital.server.repository.UserCouponInfoMapper;
import com.xwd.hospital.server.repository.base.UserCouponInfoBaseMapper;
import com.xwd.hospital.server.domain.UserCouponInfo;
import com.xwd.hospital.server.rest.req.UserCouponInfoParam;

@Service
public class UserCouponInfoServiceImpl extends ServiceImpl<UserCouponInfoMapper, UserCouponInfo> implements UserCouponInfoService {

    @Resource
    private UserService userService;
    @Resource
    private UserInfoService userInfoService;

    @Override
    public int updateAllFieldsById(UserCouponInfo entity) {
        return this.getBaseMapper().updateAllFieldsById(entity);
    }

    /**
     * 批量插入
     *
     * @param entityList ignore
     * @param batchSize  ignore
     * @return ignore
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveBatch(Collection<UserCouponInfo> entityList, int batchSize) {
        String sqlStatement = SqlHelper.getSqlStatement(UserCouponInfoBaseMapper.class, SqlMethod.INSERT_ONE);
        return executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }

    @Override
    public List<UserCouponInfo> queryMyCouponList() {
        List<UserCouponInfo> userCouponInfoList;
        //当前用户
        Object userId = StpUtil.getExtra("userId");
        UserInfo userInfo = userInfoService.getOne(Wrappers.<UserInfo>query().eq("user_id", Long.valueOf(userId.toString())));
        if(null == userInfo){
            return null;
        }
        Date now = new Date();
            userCouponInfoList = this.list(Wrappers.<UserCouponInfo>query()
                    .eq("user_info_id",userInfo.getId())
                    .ge("coupon_end_date", now)
                    .le("coupon_start_date", now)
                    .eq("coupon_use_state", CouponUseStateEnum.USEABLE));


        return userCouponInfoList;
    }
}
