package com.xwd.hospital.server.task;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xwd.hospital.server.domain.UserCouponInfo;
import com.xwd.hospital.server.enums.CouponUseStateEnum;
import com.xwd.hospital.server.service.UserCouponInfoService;
import jakarta.annotation.Resource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

@Component
@Async
public class CouponTask {
    @Resource
    private UserCouponInfoService userCouponInfoService;

    /**
     * 每天0点清理过期优惠券
     */
    @Scheduled(cron = "0 0 0 * * ?")
    public void expireUserCoupon(){
        Date now = new Date();
        Date oneSecond = DateUtil.offsetSecond(now, 1);
        List<UserCouponInfo> list = userCouponInfoService.list(Wrappers.<UserCouponInfo>query()
                .le("coupon_end_date", oneSecond)
                .eq("coupon_use_state", CouponUseStateEnum.USEABLE));
        if(null != list
            && list.size()>0){
            for (UserCouponInfo userCouponInfo:list) {
                userCouponInfo.setCouponUseState(CouponUseStateEnum.EXPIRED);
            }
            userCouponInfoService.saveBatch(list);
        }
    }
}
