package com.xwd.hospital.server.task;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xwd.hospital.server.domain.UserCouponInfo;
import com.xwd.hospital.server.enums.CouponUseStateEnum;
import com.xwd.hospital.server.service.UserCouponInfoService;
import com.xwd.hospital.server.service.impl.DelayQueueService;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

@Component
@Async
@Slf4j
public class OrderTask {
    @Resource
    private DelayQueueService delayQueueService;

    /**
     * 每秒钟清理一次未支付订单
     */
    @Scheduled(cron = "* * * * * *")
    public void cancelUnpayOrder(){
        log.info("清理超时未支付订单--------------------start");
        delayQueueService.pollAndProcessDelayedMessages();
        log.info("清理超时未支付订单--------------------end");
    }
}
