CREATE TABLE `demo_olympiad_athlete` (
     `code` varchar(255) NOT NULL,
     `sort` int(255) DEFAULT NULL,
     `name` varchar(255) DEFAULT NULL,
     `country` varchar(255) DEFAULT NULL,
     `game` varchar(255) DEFAULT NULL,
     `hot_num` int(11) DEFAULT NULL,
     PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `demo_olympiad_audience_age` (
      `age` varchar(255) NOT NULL,
      `percent` float(255,2) DEFAULT NULL,
  PRIMARY KEY (`age`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `demo_olympiad_audience_sex` (
  `sex` varchar(255) NOT NULL,
  `percent` float(255,2) DEFAULT NULL,
  PRIMARY KEY (`sex`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `demo_olympiad_country` (
 `code` varchar(255) NOT NULL,
 `name` varchar(255) DEFAULT NULL,
 PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `demo_olympiad_data_update` (
    `update_date` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `demo_olympiad_gold_date` (
       `id` varchar(255) NOT NULL,
       `datekey` varchar(255) DEFAULT NULL,
       `game` varchar(255) DEFAULT NULL,
       `qty` varchar(255) DEFAULT NULL,
       PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `demo_olympiad_hot_game` (
      `code` varchar(255) NOT NULL,
      `sort` varchar(255) DEFAULT NULL,
      `name` varchar(255) DEFAULT NULL,
      PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `demo_olympiad_medal` (
       `code` int(11) NOT NULL,
       `name` varchar(50) NOT NULL,
       PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `demo_olympiad_medal_qty` (
       `id` varchar(255) DEFAULT NULL,
       `country` varchar(255) DEFAULT NULL,
       `medal` varchar(255) DEFAULT NULL,
       `qty` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `demo_sales_dashboard` (
    `year` int(11) unsigned DEFAULT NULL,
    `mounth` int(11) DEFAULT NULL,
    `sales_dept` varchar(255) DEFAULT NULL,
    `product_name` varchar(255) DEFAULT NULL,
    `sales_qty` int(11) DEFAULT NULL,
    `sales_amount` int(255) DEFAULT NULL,
    `target_qty` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


INSERT INTO `demo_olympiad_athlete` (`code`,`sort`,`name`,`country`,`game`,`hot_num`) VALUES ('1',1,'郑妮娜力','1','3',37770);
INSERT INTO `demo_olympiad_athlete` (`code`,`sort`,`name`,`country`,`game`,`hot_num`) VALUES ('10',10,'刘诗雯','1','2',4651);
INSERT INTO `demo_olympiad_athlete` (`code`,`sort`,`name`,`country`,`game`,`hot_num`) VALUES ('2',2,'马龙','1','2',13186);
INSERT INTO `demo_olympiad_athlete` (`code`,`sort`,`name`,`country`,`game`,`hot_num`) VALUES ('3',3,'苏炳添','1','3',11523);
INSERT INTO `demo_olympiad_athlete` (`code`,`sort`,`name`,`country`,`game`,`hot_num`) VALUES ('4',4,'韩莹','7','2',9586);
INSERT INTO `demo_olympiad_athlete` (`code`,`sort`,`name`,`country`,`game`,`hot_num`) VALUES ('5',5,'管晨辰','1','11',7941);
INSERT INTO `demo_olympiad_athlete` (`code`,`sort`,`name`,`country`,`game`,`hot_num`) VALUES ('6',6,'许昕','1','2',7183);
INSERT INTO `demo_olympiad_athlete` (`code`,`sort`,`name`,`country`,`game`,`hot_num`) VALUES ('7',7,'陈梦','1','2',6743);
INSERT INTO `demo_olympiad_athlete` (`code`,`sort`,`name`,`country`,`game`,`hot_num`) VALUES ('8',8,'孙颖莎','1','2',5008);
INSERT INTO `demo_olympiad_athlete` (`code`,`sort`,`name`,`country`,`game`,`hot_num`) VALUES ('9',9,'樊振东','1','2',4941);

INSERT INTO `demo_olympiad_audience_age` (`age`,`percent`) VALUES ('00后',14.00);
INSERT INTO `demo_olympiad_audience_age` (`age`,`percent`) VALUES ('60后',15.00);
INSERT INTO `demo_olympiad_audience_age` (`age`,`percent`) VALUES ('70后',20.00);
INSERT INTO `demo_olympiad_audience_age` (`age`,`percent`) VALUES ('80后',29.00);
INSERT INTO `demo_olympiad_audience_age` (`age`,`percent`) VALUES ('90后',22.00);


INSERT INTO `demo_olympiad_audience_sex` (`sex`,`percent`) VALUES ('女',29.00);
INSERT INTO `demo_olympiad_audience_sex` (`sex`,`percent`) VALUES ('男',71.00);


INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('1','中国');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('10','韩国');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('11','新西兰');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('12','意大利');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('13','匈牙利');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('14','巴西');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('15','古巴');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('16','捷克');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('17','加拿大');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('18','瑞士');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('19','克罗地亚');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('2','美国');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('20','中国台北');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('3','日本');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('4','澳大利亚');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('5','俄罗斯奥委会');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('6','英国');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('7','德国');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('8','法国');
INSERT INTO `demo_olympiad_country` (`code`,`name`) VALUES ('9','荷兰');

INSERT INTO `demo_olympiad_data_update` (`update_date`) VALUES ('2021-08-04 00:00:00');


INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('1','2021-07-24','射击','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('10','2021-07-28','举重','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('11','2021-07-28','跳水','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('12','2021-07-28','赛艇','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('13','2021-07-29','乒乓球','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('14','2021-07-29','游泳','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('15','2021-07-29','游泳','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('16','2021-07-30','乒乓球','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('17','2021-07-30','羽毛球','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('18','2021-07-30','蹦床','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('19','2021-07-30','游泳','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('2','2021-07-24','举重','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('20','2021-07-31','举重','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('21','2021-07-31','帆船','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('22','2021-08-01','羽毛球','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('23','2021-08-01','跳水','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('24','2021-08-01','田径','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('25','2021-08-02','举重','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('26','2021-08-02','举重','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('27','2021-08-02','自行车','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('28','2021-08-02','射击','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('29','2021-08-02','体操','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('3','2021-07-24','击剑','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('30','2021-08-03','体操','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('31','2021-08-03','体操','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('32','2021-08-03','跳水','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('4','2021-07-25','举重','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('5','2021-07-25','举重','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('6','2021-07-25','跳水','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('7','2021-07-27','射击','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('8','2021-07-27','射击','1');
INSERT INTO `demo_olympiad_gold_date` (`id`,`datekey`,`game`,`qty`) VALUES ('9','2021-07-27','跳水','1');

INSERT INTO `demo_olympiad_hot_game` (`code`,`sort`,`name`) VALUES ('1','1','排球');
INSERT INTO `demo_olympiad_hot_game` (`code`,`sort`,`name`) VALUES ('10','10','足球');
INSERT INTO `demo_olympiad_hot_game` (`code`,`sort`,`name`) VALUES ('11','11','竞技体操');
INSERT INTO `demo_olympiad_hot_game` (`code`,`sort`,`name`) VALUES ('2','2','乒乓球');
INSERT INTO `demo_olympiad_hot_game` (`code`,`sort`,`name`) VALUES ('3','3','田径');
INSERT INTO `demo_olympiad_hot_game` (`code`,`sort`,`name`) VALUES ('4','4','跆拳道');
INSERT INTO `demo_olympiad_hot_game` (`code`,`sort`,`name`) VALUES ('5','5','羽毛球');
INSERT INTO `demo_olympiad_hot_game` (`code`,`sort`,`name`) VALUES ('6','6','游泳');
INSERT INTO `demo_olympiad_hot_game` (`code`,`sort`,`name`) VALUES ('7','7','篮球');
INSERT INTO `demo_olympiad_hot_game` (`code`,`sort`,`name`) VALUES ('8','8','网球');
INSERT INTO `demo_olympiad_hot_game` (`code`,`sort`,`name`) VALUES ('9','9','柔道');


INSERT INTO `demo_olympiad_medal` (`code`,`name`) VALUES (1,'金牌');
INSERT INTO `demo_olympiad_medal` (`code`,`name`) VALUES (2,'银牌');
INSERT INTO `demo_olympiad_medal` (`code`,`name`) VALUES (3,'铜牌');


INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('1','1','1','32');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('2','1','2','21');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('3','1','3','16');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('4','2','1','25');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('5','2','2','29');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('6','2','3','21');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('7','3','1','19');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('8','3','2','6');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('9','3','3','11');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('10','4','1','14');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('11','4','2','4');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('12','4','3','16');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('13','5','1','13');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('14','5','2','21');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('15','5','3','18');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('16','6','1','13');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('17','6','2','17');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('18','6','3','13');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('19','7','1','8');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('20','7','2','8');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('21','7','3','14');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('22','8','1','6');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('23','8','2','10');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('24','8','3','8');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('25','9','1','6');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('26','9','2','8');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('27','9','3','8');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('28','10','1','6');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('29','10','2','4');
INSERT INTO `demo_olympiad_medal_qty` (`id`,`country`,`medal`,`qty`) VALUES ('30','10','3','9');

INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2021,1,'销售一部','睡袋',23,431,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2021,2,'销售二部','野餐垫',40,433,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2021,3,'销售三部','帐篷',67,445,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2021,4,'销售一部','睡袋',23,556,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2021,5,'销售四部','野餐垫',33,444,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2021,6,'销售二部','睡袋',18,344,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2021,7,'销售三部','帐篷',66,433,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2021,8,'销售一部','野营附件',112,556,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2021,9,'销售四部','野餐垫',23,541,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2021,10,'销售二部','野餐垫',40,612,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2021,11,'销售一部','野营附件',67,454,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2020,12,'销售四部','野餐垫',23,321,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2020,1,'销售四部','睡袋',44,556,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2020,2,'销售一部','野营附件',89,444,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2020,3,'销售四部','帐篷',34,666,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2020,4,'销售三部','野营附件',33,545,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2020,5,'销售一部','睡袋',40,556,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2020,6,'销售二部','帐篷',67,666,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2020,7,'销售一部','野餐垫',23,344,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2020,8,'销售一部','野营附件',22,545,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2020,9,'销售二部','帐篷',99,556,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2020,10,'销售四部','野营附件',23,444,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2020,11,'销售三部','睡袋',77,777,500);
INSERT INTO `demo_sales_dashboard` (`year`,`mounth`,`sales_dept`,`product_name`,`sales_qty`,`sales_amount`,`target_qty`) VALUES (2020,12,'销售一部','睡袋',67,545,500);



SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for demo_new_trend_of_diagnosis
-- ----------------------------
DROP TABLE IF EXISTS `demo_new_trend_of_diagnosis`;
CREATE TABLE `demo_new_trend_of_diagnosis` (
                                               `date` varchar(50) NOT NULL DEFAULT '' COMMENT '日期',
                                               `new_diagnosis` bigint(13) DEFAULT NULL COMMENT '新增确诊',
                                               `current_diagnosis` bigint(13) DEFAULT NULL COMMENT '现有确诊'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of demo_new_trend_of_diagnosis
-- ----------------------------
BEGIN;
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-10', 33, 505);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-11', 28, 506);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-12', 32, 512);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-13', 35, 523);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-14', 49, 542);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-15', 206, 727);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-16', 236, 935);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-17', 358, 1262);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-18', 258, 1497);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-19', 286, 1759);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-20', 317, 2097);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-21', 325, 2365);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-22', 743, 3098);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-23', 480, 3561);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-24', 612, 4143);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-25', 554, 4675);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-26', 655, 5036);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-27', 677, 5948);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-28', 570, 6480);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-29', 503, 6951);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-30', 381, 7303);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-5-31', 378, 7652);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-6-1', 362, 7983);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-6-2', 571, 8535);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-6-3', 610, 9110);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-6-4', 497, 9674);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-6-5', 541, 10049);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-6-6', 368, 10372);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-6-7', 233, 10552);
INSERT INTO `demo_new_trend_of_diagnosis` VALUES ('2021-6-8', 232, 10740);
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;


INSERT INTO `chart_group` (`id`, `name`, `pid`, `level`, `type`, `create_by`, `create_time`) VALUES ('3f551269-d985-4633-884d-d118704da2db', '示例数据', '0', '0', 'group', 'admin', '1628074869229');
delete from chart_group where id='5a8e8b0a-2f64-4d1b-aac1-d284b2b8436f';
delete from chart_group where id='4de97755-5d5a-4fe0-9af0-27601f967787';

INSERT INTO `chart_group` (`id`, `name`, `pid`, `level`, `type`, `create_by`, `create_time`) VALUES ('2c200620-f2f3-4224-a41d-381fa061591b', '某运动品牌销售数据分析', '3f551269-d985-4633-884d-d118704da2db', '0', 'group', 'admin', '1624266403268');
INSERT INTO `chart_group` (`id`, `name`, `pid`, `level`, `type`, `create_by`, `create_time`) VALUES ('5a8e8b0a-2f64-4d1b-aac1-d284b2b8436f', '新冠疫情', '3f551269-d985-4633-884d-d118704da2db', '0', 'group', 'admin', '1623212582950');
INSERT INTO `chart_group` (`id`, `name`, `pid`, `level`, `type`, `create_by`, `create_time`) VALUES ('bfa7d87f-c76f-4406-9f19-0adccb7c568d', '东京奥运会', '3f551269-d985-4633-884d-d118704da2db', '1', 'group', 'admin', '1628127614480');
INSERT INTO `chart_group` (`id`, `name`, `pid`, `level`, `type`, `create_by`, `create_time`) VALUES ('4de97755-5d5a-4fe0-9af0-27601f967787', '国内疫情分析', '5a8e8b0a-2f64-4d1b-aac1-d284b2b8436f', '1', 'group', 'admin', '1623212597088');



INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('95f8e3a2-62a5-48a7-a719-fcf53746da8d', '观众年龄', 'bfa7d87f-c76f-4406-9f19-0adccb7c568d', 'ab59c120-51d4-40d9-811b-c6c957302426', 'pie-rose', '观众年龄', '[{\"id\":\"c1fa4614-5356-4460-bb66-a9c072c2fa0f\",\"tableId\":\"ab59c120-51d4-40d9-811b-c6c957302426\",\"originName\":\"age\",\"name\":\"age\",\"dataeaseName\":\"C_7d637d275668ed6d41a9b97e6ad3a556\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1628071572184,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[]}]', '[{\"id\":\"47584c74-ad8a-4a53-9571-02e8f676bbee\",\"tableId\":\"ab59c120-51d4-40d9-811b-c6c957302426\",\"originName\":\"percent\",\"name\":\"percent\",\"dataeaseName\":\"C_354f047ba64552895b016bbdd60ab174\",\"groupType\":\"q\",\"type\":\"FLOAT\",\"size\":255,\"deType\":3,\"deTypeFormat\":null,\"deExtractType\":3,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1628071572184,\"summary\":\"sum\",\"sort\":\"desc\",\"filter\":[]}]', '{\"color\":{\"value\":\"future\",\"colors\":[\"#63b2ee\",\"#76da91\",\"#f8cb7f\",\"#f89588\",\"#7cd6cf\",\"#9192ab\",\"#7898e1\",\"#efa666\",\"#eddd86\"],\"alpha\":80,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"tableTitleHeight\":36,\"tableItemHeight\":36,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":true,\"position\":\"outside\",\"color\":\"#FEFEFE\",\"fontSize\":\"10\",\"formatter\":\"{c}%\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"16\",\"color\":\"#FEFEFE\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"isBolder\":false,\"title\":\"观众年龄\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#FFFFFF\",\"fontSize\":\"10\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"background\":{\"color\":\"#ffffff\",\"alpha\":10},\"split\":{\"name\":{\"show\":true,\"color\":\"#999999\",\"fontSize\":\"12\"},\"splitNumber\":5,\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisTick\":{\"show\":false,\"length\":5,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisLabel\":{\"show\":false,\"rotate\":0,\"margin\":8,\"color\":\"#999999\",\"fontSize\":\"12\",\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"splitArea\":{\"show\":true}}}', '[]', 'admin', 1628075157607, 1628141941915, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('8a26a936-89bf-45a8-b1ce-d5ef1719465d', '观众性别', 'bfa7d87f-c76f-4406-9f19-0adccb7c568d', 'c414e525-9c1d-4e16-9afd-ccb14a4efbbc', 'pie', '观众性别', '[{\"id\":\"c9edeb59-40a7-47dc-8ff7-efca1a0908fb\",\"tableId\":\"c414e525-9c1d-4e16-9afd-ccb14a4efbbc\",\"originName\":\"sex\",\"name\":\"sex\",\"dataeaseName\":\"C_3c3662bcb661d6de679c636744c66b62\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1628071572251,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[]}]', '[{\"id\":\"91afd224-da91-4fe1-bfb0-558926fdf244\",\"tableId\":\"c414e525-9c1d-4e16-9afd-ccb14a4efbbc\",\"originName\":\"percent\",\"name\":\"percent\",\"dataeaseName\":\"C_354f047ba64552895b016bbdd60ab174\",\"groupType\":\"q\",\"type\":\"FLOAT\",\"size\":255,\"deType\":3,\"deTypeFormat\":null,\"deExtractType\":3,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1628071572251,\"summary\":\"sum\",\"sort\":\"desc\",\"filter\":[]}]', '{\"color\":{\"value\":\"future\",\"colors\":[\"#63b2ee\",\"#76da91\",\"#f8cb7f\",\"#f89588\",\"#7cd6cf\",\"#9192ab\",\"#7898e1\",\"#efa666\",\"#eddd86\"],\"alpha\":80,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":43,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"tableTitleHeight\":36,\"tableItemHeight\":36,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":true,\"position\":\"outside\",\"color\":\"#FEFEFE\",\"fontSize\":\"10\",\"formatter\":\"{c}%\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"16\",\"color\":\"#FEFEFE\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"isBolder\":false,\"title\":\"观众性别\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#FFFFFF\",\"fontSize\":\"10\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"background\":{\"color\":\"#ffffff\",\"alpha\":10},\"split\":{\"name\":{\"show\":true,\"color\":\"#999999\",\"fontSize\":\"12\"},\"splitNumber\":5,\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisTick\":{\"show\":false,\"length\":5,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisLabel\":{\"show\":false,\"rotate\":0,\"margin\":8,\"color\":\"#999999\",\"fontSize\":\"12\",\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"splitArea\":{\"show\":true}}}', '[]', 'admin', 1628075157607, 1628141969100, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('8d1c3f30-0639-452e-9883-164f37353324', '中国奖牌总数', 'bfa7d87f-c76f-4406-9f19-0adccb7c568d', '89066550-db19-4235-b038-6c566702ca26', 'text', '中国奖牌总数', '[]', '[{\"id\":\"525fa05a-b46d-4e79-8574-0d92fa28b6d4\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_5f89cd4674cabeb744d96d20d817e354\",\"name\":\"中国-总奖牌\",\"dataeaseName\":\"C_7068b281c7ebde67b45ae8c3ecd398e2\",\"groupType\":\"q\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":3,\"lastSyncTime\":1628074414519,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[],\"index\":0,\"renameType\":\"quota\"}]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#BEBEBD\",\"quotaColor\":\"#55DC80\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":80,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"tableTitleHeight\":36,\"tableItemHeight\":36,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"14\",\"quotaFontSize\":\"28\",\"spaceSplit\":15,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"isBolder\":false,\"title\":\"中国金牌总数\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"background\":{\"color\":\"#ffffff\",\"alpha\":10},\"split\":{\"name\":{\"show\":true,\"color\":\"#999999\",\"fontSize\":\"12\"},\"splitNumber\":5,\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisTick\":{\"show\":false,\"length\":5,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisLabel\":{\"show\":false,\"rotate\":0,\"margin\":8,\"color\":\"#999999\",\"fontSize\":\"12\",\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"splitArea\":{\"show\":true}}}', '[{\"id\":\"786707bf-3086-46c4-a03b-90ad272a0126\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_1451c56f4194a9851e91156eb73b92b6\",\"name\":\"country\",\"dataeaseName\":\"C_0cbedf776b60d3b4ee8873f6b019822f\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1628074414519,\"filter\":[{\"fieldId\":\"786707bf-3086-46c4-a03b-90ad272a0126\",\"term\":\"eq\",\"value\":\"中国\"}],\"index\":0}]', 'admin', 1628127698484, 1628159611927, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('175b25df-1939-4582-a9c5-d9e8ed3ea2b1', '中国金牌总数', 'bfa7d87f-c76f-4406-9f19-0adccb7c568d', '89066550-db19-4235-b038-6c566702ca26', 'text', '中国金牌总数', '[]', '[{\"id\":\"525fa05a-b46d-4e79-8574-0d92fa28b6d4\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_5f89cd4674cabeb744d96d20d817e354\",\"name\":\"中国-金牌\",\"dataeaseName\":\"C_7068b281c7ebde67b45ae8c3ecd398e2\",\"groupType\":\"q\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":3,\"lastSyncTime\":1628074414519,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[],\"index\":0,\"renameType\":\"quota\"}]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#BEBEBD\",\"quotaColor\":\"#FFC125\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":80,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"tableTitleHeight\":36,\"tableItemHeight\":36,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"14\",\"quotaFontSize\":\"28\",\"spaceSplit\":15,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"isBolder\":false,\"title\":\"中国金牌总数\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"background\":{\"color\":\"#ffffff\",\"alpha\":10},\"split\":{\"name\":{\"show\":true,\"color\":\"#999999\",\"fontSize\":\"12\"},\"splitNumber\":5,\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisTick\":{\"show\":false,\"length\":5,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisLabel\":{\"show\":false,\"rotate\":0,\"margin\":8,\"color\":\"#999999\",\"fontSize\":\"12\",\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"splitArea\":{\"show\":true}}}', '[{\"id\":\"786707bf-3086-46c4-a03b-90ad272a0126\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_1451c56f4194a9851e91156eb73b92b6\",\"name\":\"country\",\"dataeaseName\":\"C_0cbedf776b60d3b4ee8873f6b019822f\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1628074414519,\"filter\":[{\"fieldId\":\"786707bf-3086-46c4-a03b-90ad272a0126\",\"term\":\"eq\",\"value\":\"中国\"}],\"index\":0},{\"id\":\"ac68cc14-8aa8-4951-bf5e-6b39cce0041f\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_7b95ef3dee6832fd45d6b6c97ad63a7b\",\"name\":\"medal\",\"dataeaseName\":\"C_c90b4b5dd3fbd8fd50294939462c8066\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":50,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1628074414519,\"filter\":[{\"fieldId\":\"ac68cc14-8aa8-4951-bf5e-6b39cce0041f\",\"term\":\"eq\",\"value\":\"金牌\"}],\"index\":1}]', 'admin', 1628127698484, 1628131816576, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('c3da496f-073c-413a-bebd-e7f1a4a00ba7', '中国银牌总数', 'bfa7d87f-c76f-4406-9f19-0adccb7c568d', '89066550-db19-4235-b038-6c566702ca26', 'text', '中国银牌总数', '[]', '[{\"id\":\"525fa05a-b46d-4e79-8574-0d92fa28b6d4\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_5f89cd4674cabeb744d96d20d817e354\",\"name\":\"中国-银牌\",\"dataeaseName\":\"C_7068b281c7ebde67b45ae8c3ecd398e2\",\"groupType\":\"q\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":3,\"lastSyncTime\":1628074414519,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[],\"index\":0,\"renameType\":\"quota\"}]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#BEBEBD\",\"quotaColor\":\"#CDCDCD\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":80,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"tableTitleHeight\":36,\"tableItemHeight\":36,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"14\",\"quotaFontSize\":\"28\",\"spaceSplit\":15,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"isBolder\":false,\"title\":\"中国金牌总数\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"background\":{\"color\":\"#ffffff\",\"alpha\":10},\"split\":{\"name\":{\"show\":true,\"color\":\"#999999\",\"fontSize\":\"12\"},\"splitNumber\":5,\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisTick\":{\"show\":false,\"length\":5,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisLabel\":{\"show\":false,\"rotate\":0,\"margin\":8,\"color\":\"#999999\",\"fontSize\":\"12\",\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"splitArea\":{\"show\":true}}}', '[{\"id\":\"786707bf-3086-46c4-a03b-90ad272a0126\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_1451c56f4194a9851e91156eb73b92b6\",\"name\":\"country\",\"dataeaseName\":\"C_0cbedf776b60d3b4ee8873f6b019822f\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1628074414519,\"filter\":[{\"fieldId\":\"786707bf-3086-46c4-a03b-90ad272a0126\",\"term\":\"eq\",\"value\":\"中国\"}],\"index\":0},{\"id\":\"ac68cc14-8aa8-4951-bf5e-6b39cce0041f\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_7b95ef3dee6832fd45d6b6c97ad63a7b\",\"name\":\"medal\",\"dataeaseName\":\"C_c90b4b5dd3fbd8fd50294939462c8066\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":50,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1628074414519,\"filter\":[{\"fieldId\":\"ac68cc14-8aa8-4951-bf5e-6b39cce0041f\",\"term\":\"eq\",\"value\":\"银牌\"}],\"index\":1}]', 'admin', 1628127698484, 1628159626260, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('da18eecd-feff-4140-a291-cce4abf1afaa', '中国铜牌总数', 'bfa7d87f-c76f-4406-9f19-0adccb7c568d', '89066550-db19-4235-b038-6c566702ca26', 'text', '中国铜牌总数', '[]', '[{\"id\":\"525fa05a-b46d-4e79-8574-0d92fa28b6d4\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_5f89cd4674cabeb744d96d20d817e354\",\"name\":\"中国-铜牌\",\"dataeaseName\":\"C_7068b281c7ebde67b45ae8c3ecd398e2\",\"groupType\":\"q\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":3,\"lastSyncTime\":1628074414519,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[],\"index\":0,\"renameType\":\"quota\"}]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#BEBEBD\",\"quotaColor\":\"#FFC125\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":80,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"tableTitleHeight\":36,\"tableItemHeight\":36,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"14\",\"quotaFontSize\":\"28\",\"spaceSplit\":15,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"isBolder\":false,\"title\":\"中国金牌总数\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"background\":{\"color\":\"#ffffff\",\"alpha\":10},\"split\":{\"name\":{\"show\":true,\"color\":\"#999999\",\"fontSize\":\"12\"},\"splitNumber\":5,\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisTick\":{\"show\":false,\"length\":5,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisLabel\":{\"show\":false,\"rotate\":0,\"margin\":8,\"color\":\"#999999\",\"fontSize\":\"12\",\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"splitArea\":{\"show\":true}}}', '[{\"id\":\"786707bf-3086-46c4-a03b-90ad272a0126\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_1451c56f4194a9851e91156eb73b92b6\",\"name\":\"country\",\"dataeaseName\":\"C_0cbedf776b60d3b4ee8873f6b019822f\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1628074414519,\"filter\":[{\"fieldId\":\"786707bf-3086-46c4-a03b-90ad272a0126\",\"term\":\"eq\",\"value\":\"中国\"}],\"index\":0},{\"id\":\"ac68cc14-8aa8-4951-bf5e-6b39cce0041f\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_7b95ef3dee6832fd45d6b6c97ad63a7b\",\"name\":\"medal\",\"dataeaseName\":\"C_c90b4b5dd3fbd8fd50294939462c8066\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":50,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1628074414519,\"filter\":[{\"fieldId\":\"ac68cc14-8aa8-4951-bf5e-6b39cce0041f\",\"term\":\"eq\",\"value\":\"铜牌\"}],\"index\":1}]', 'admin', 1628127698484, 1628159642372, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('3f201733-bbb3-485e-a1d6-0fe4f00b5304', '金牌榜', 'bfa7d87f-c76f-4406-9f19-0adccb7c568d', '89066550-db19-4235-b038-6c566702ca26', 'bar-horizontal', '金牌榜', '[{\"id\":\"786707bf-3086-46c4-a03b-90ad272a0126\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_1451c56f4194a9851e91156eb73b92b6\",\"name\":\"country\",\"dataeaseName\":\"C_0cbedf776b60d3b4ee8873f6b019822f\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1628074414519,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[],\"index\":0,\"renameType\":\"dimension\"}]', '[{\"id\":\"525fa05a-b46d-4e79-8574-0d92fa28b6d4\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_5f89cd4674cabeb744d96d20d817e354\",\"name\":\"奖牌数\",\"dataeaseName\":\"C_7068b281c7ebde67b45ae8c3ecd398e2\",\"groupType\":\"q\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":3,\"lastSyncTime\":1628074414519,\"summary\":\"sum\",\"sort\":\"asc\",\"filter\":[],\"index\":0,\"renameType\":\"quota\"}]', '{\"color\":{\"value\":\"future\",\"colors\":[\"#63b2ee\",\"#76da91\",\"#f8cb7f\",\"#f89588\",\"#7cd6cf\",\"#9192ab\",\"#7898e1\",\"#efa666\",\"#eddd86\"],\"alpha\":80,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":false,\"barWidth\":10,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":80,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"tableTitleHeight\":36,\"tableItemHeight\":36,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":true,\"position\":\"right\",\"color\":\"#FFFFFF\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"16\",\"color\":\"#FFFFFF\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"isBolder\":false,\"title\":\"金牌榜\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#FFFFFF\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#FFFFFF\",\"fontSize\":\"10\"},\"axisLabel\":{\"show\":true,\"color\":\"#FFFFFF\",\"fontSize\":\"10\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#FFFFFF\",\"fontSize\":\"10\"},\"axisLabel\":{\"show\":true,\"color\":\"#FFFFFF\",\"fontSize\":\"10\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#4D4B4B\",\"width\":1,\"style\":\"solid\"}}},\"background\":{\"color\":\"#ffffff\",\"alpha\":10},\"split\":{\"name\":{\"show\":true,\"color\":\"#999999\",\"fontSize\":\"12\"},\"splitNumber\":5,\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisTick\":{\"show\":false,\"length\":5,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisLabel\":{\"show\":false,\"rotate\":0,\"margin\":8,\"color\":\"#999999\",\"fontSize\":\"12\",\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"splitArea\":{\"show\":true}}}', '[{\"id\":\"ac68cc14-8aa8-4951-bf5e-6b39cce0041f\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_7b95ef3dee6832fd45d6b6c97ad63a7b\",\"name\":\"medal\",\"dataeaseName\":\"C_c90b4b5dd3fbd8fd50294939462c8066\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":50,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1628074414519,\"filter\":[{\"fieldId\":\"ac68cc14-8aa8-4951-bf5e-6b39cce0041f\",\"term\":\"eq\",\"value\":\"金牌\"}],\"index\":0}]', 'admin', 1628129923009, 1628141979188, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('692d5bdc-aa70-4fce-b830-b8d6620539c6', '银牌榜', 'bfa7d87f-c76f-4406-9f19-0adccb7c568d', '89066550-db19-4235-b038-6c566702ca26', 'bar-horizontal', '银牌榜', '[{\"id\":\"786707bf-3086-46c4-a03b-90ad272a0126\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_1451c56f4194a9851e91156eb73b92b6\",\"name\":\"country\",\"dataeaseName\":\"C_0cbedf776b60d3b4ee8873f6b019822f\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1628074414519,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[],\"index\":0,\"renameType\":\"dimension\"}]', '[{\"id\":\"525fa05a-b46d-4e79-8574-0d92fa28b6d4\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_5f89cd4674cabeb744d96d20d817e354\",\"name\":\"奖牌数\",\"dataeaseName\":\"C_7068b281c7ebde67b45ae8c3ecd398e2\",\"groupType\":\"q\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":3,\"lastSyncTime\":1628074414519,\"summary\":\"sum\",\"sort\":\"asc\",\"filter\":[],\"index\":0,\"renameType\":\"quota\"}]', '{\"color\":{\"value\":\"future\",\"colors\":[\"#63b2ee\",\"#76da91\",\"#f8cb7f\",\"#f89588\",\"#7cd6cf\",\"#9192ab\",\"#7898e1\",\"#efa666\",\"#eddd86\"],\"alpha\":80,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":false,\"barWidth\":10,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":80,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"tableTitleHeight\":36,\"tableItemHeight\":36,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":true,\"position\":\"right\",\"color\":\"#FFFFFF\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"16\",\"color\":\"#FFFFFF\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"isBolder\":false,\"title\":\"银牌榜\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#FFFFFF\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#FFFFFF\",\"fontSize\":\"10\"},\"axisLabel\":{\"show\":true,\"color\":\"#FFFFFF\",\"fontSize\":\"10\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#FFFFFF\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#FFFFFF\",\"fontSize\":\"10\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#4D4B4B\",\"width\":1,\"style\":\"solid\"}}},\"background\":{\"color\":\"#ffffff\",\"alpha\":10},\"split\":{\"name\":{\"show\":true,\"color\":\"#999999\",\"fontSize\":\"12\"},\"splitNumber\":5,\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisTick\":{\"show\":false,\"length\":5,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisLabel\":{\"show\":false,\"rotate\":0,\"margin\":8,\"color\":\"#999999\",\"fontSize\":\"12\",\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"splitArea\":{\"show\":true}}}', '[{\"id\":\"ac68cc14-8aa8-4951-bf5e-6b39cce0041f\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_7b95ef3dee6832fd45d6b6c97ad63a7b\",\"name\":\"medal\",\"dataeaseName\":\"C_c90b4b5dd3fbd8fd50294939462c8066\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":50,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1628074414519,\"filter\":[{\"fieldId\":\"ac68cc14-8aa8-4951-bf5e-6b39cce0041f\",\"term\":\"eq\",\"value\":\"银牌\"}],\"index\":0}]', 'admin', 1628129923009, 1628141787520, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('aff5be0c-f195-4fce-bd2b-b8d0e63764de', '铜牌榜', 'bfa7d87f-c76f-4406-9f19-0adccb7c568d', '89066550-db19-4235-b038-6c566702ca26', 'bar-horizontal', '铜牌榜', '[{\"id\":\"786707bf-3086-46c4-a03b-90ad272a0126\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_1451c56f4194a9851e91156eb73b92b6\",\"name\":\"country\",\"dataeaseName\":\"C_0cbedf776b60d3b4ee8873f6b019822f\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1628074414519,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[],\"index\":0,\"renameType\":\"dimension\"}]', '[{\"id\":\"525fa05a-b46d-4e79-8574-0d92fa28b6d4\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_5f89cd4674cabeb744d96d20d817e354\",\"name\":\"奖牌数\",\"dataeaseName\":\"C_7068b281c7ebde67b45ae8c3ecd398e2\",\"groupType\":\"q\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":3,\"lastSyncTime\":1628074414519,\"summary\":\"sum\",\"sort\":\"asc\",\"filter\":[],\"index\":0,\"renameType\":\"quota\"}]', '{\"color\":{\"value\":\"future\",\"colors\":[\"#63b2ee\",\"#76da91\",\"#f8cb7f\",\"#f89588\",\"#7cd6cf\",\"#9192ab\",\"#7898e1\",\"#efa666\",\"#eddd86\"],\"alpha\":80,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":false,\"barWidth\":10,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":80,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"tableTitleHeight\":36,\"tableItemHeight\":36,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":true,\"position\":\"right\",\"color\":\"#FFFFFF\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"16\",\"color\":\"#FFFFFF\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"isBolder\":false,\"title\":\"铜牌榜\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#FFFFFF\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#FFFFFF\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#FFFFFF\",\"fontSize\":\"10\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#FFFFFF\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#FFFFFF\",\"fontSize\":\"10\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#4D4B4B\",\"width\":1,\"style\":\"solid\"}}},\"background\":{\"color\":\"#ffffff\",\"alpha\":10},\"split\":{\"name\":{\"show\":true,\"color\":\"#999999\",\"fontSize\":\"12\"},\"splitNumber\":5,\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisTick\":{\"show\":false,\"length\":5,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisLabel\":{\"show\":false,\"rotate\":0,\"margin\":8,\"color\":\"#999999\",\"fontSize\":\"12\",\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"splitArea\":{\"show\":true}}}', '[{\"id\":\"ac68cc14-8aa8-4951-bf5e-6b39cce0041f\",\"tableId\":\"89066550-db19-4235-b038-6c566702ca26\",\"originName\":\"f_7b95ef3dee6832fd45d6b6c97ad63a7b\",\"name\":\"medal\",\"dataeaseName\":\"C_c90b4b5dd3fbd8fd50294939462c8066\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":50,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1628074414519,\"filter\":[{\"fieldId\":\"ac68cc14-8aa8-4951-bf5e-6b39cce0041f\",\"term\":\"eq\",\"value\":\"铜牌\"}],\"index\":0}]', 'admin', 1628129923009, 1628141811364, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('cb66836d-a34c-40c6-87e7-0db0375ec19e', '中国夺金趋势榜', 'bfa7d87f-c76f-4406-9f19-0adccb7c568d', '077e3af4-a544-43bc-ab48-a3a161b51ba8', 'line', '中国夺金趋势榜', '[{\"id\":\"950c893c-fda4-4d41-addc-49b7eec61779\",\"tableId\":\"077e3af4-a544-43bc-ab48-a3a161b51ba8\",\"originName\":\"datekey\",\"name\":\"datekey\",\"dataeaseName\":\"C_7d0ef745eae6e05fd40e008066923b30\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1628136405582,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[]}]', '[{\"id\":\"07ab49dd-a0f5-4f12-9d76-54e88b257bb8\",\"tableId\":\"077e3af4-a544-43bc-ab48-a3a161b51ba8\",\"originName\":\"qty\",\"name\":\"金牌数\",\"dataeaseName\":\"C_f44fc6cd274569fd327d9bccc761b066\",\"groupType\":\"q\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":3,\"lastSyncTime\":1628136405582,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[],\"index\":0,\"renameType\":\"quota\"}]', '{\"color\":{\"value\":\"future\",\"colors\":[\"#63b2ee\",\"#76da91\",\"#f8cb7f\",\"#f89588\",\"#7cd6cf\",\"#9192ab\",\"#7898e1\",\"#efa666\",\"#eddd86\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":80,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"tableTitleHeight\":36,\"tableItemHeight\":36,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#FFFFFF\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"16\",\"color\":\"#FFFFFF\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"isBolder\":false,\"title\":\"中国夺金趋势榜\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#FFFFFF\",\"fontSize\":\"10\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#FFFFFF\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#FFFFFF\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"background\":{\"color\":\"#ffffff\",\"alpha\":10},\"split\":{\"name\":{\"show\":true,\"color\":\"#999999\",\"fontSize\":\"12\"},\"splitNumber\":5,\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisTick\":{\"show\":false,\"length\":5,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisLabel\":{\"show\":false,\"rotate\":0,\"margin\":8,\"color\":\"#999999\",\"fontSize\":\"12\",\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"splitArea\":{\"show\":true}}}', '[]', 'admin', 1628136461370, 1628141956136, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('1d06e2a0-d936-4192-b523-2eb1e8cebd51', '夺金项目排行榜', 'bfa7d87f-c76f-4406-9f19-0adccb7c568d', '077e3af4-a544-43bc-ab48-a3a161b51ba8', 'bar', '夺金项目排行榜', '[{\"id\":\"a3929ad0-0f0d-41f3-a3dd-c5b4ce8b4bfd\",\"tableId\":\"077e3af4-a544-43bc-ab48-a3a161b51ba8\",\"originName\":\"game\",\"name\":\"game\",\"dataeaseName\":\"C_c8d46d341bea4fd5bff866a65ff8aea9\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":2,\"lastSyncTime\":1628136405582,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[]}]', '[{\"id\":\"07ab49dd-a0f5-4f12-9d76-54e88b257bb8\",\"tableId\":\"077e3af4-a544-43bc-ab48-a3a161b51ba8\",\"originName\":\"qty\",\"name\":\"金牌数\",\"dataeaseName\":\"C_f44fc6cd274569fd327d9bccc761b066\",\"groupType\":\"q\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":3,\"lastSyncTime\":1628136405582,\"summary\":\"sum\",\"sort\":\"desc\",\"filter\":[],\"index\":0,\"renameType\":\"quota\"}]', '{\"color\":{\"value\":\"future\",\"colors\":[\"#63b2ee\",\"#76da91\",\"#f8cb7f\",\"#f89588\",\"#7cd6cf\",\"#9192ab\",\"#7898e1\",\"#efa666\",\"#eddd86\"],\"alpha\":80,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":80,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"circle\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"tableTitleHeight\":36,\"tableItemHeight\":36,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#FFFFFF\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"16\",\"color\":\"#FFFFFF\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"isBolder\":false,\"title\":\"夺金项目排行榜\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#FFFFFF\",\"fontSize\":\"10\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#FFFFFF\",\"fontSize\":\"10\",\"rotate\":42,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"background\":{\"color\":\"#ffffff\",\"alpha\":10},\"split\":{\"name\":{\"show\":true,\"color\":\"#999999\",\"fontSize\":\"12\"},\"splitNumber\":5,\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#FFFFFF\",\"width\":1,\"type\":\"solid\"}},\"axisTick\":{\"show\":false,\"length\":5,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisLabel\":{\"show\":false,\"rotate\":0,\"margin\":8,\"color\":\"#FFFFFF\",\"fontSize\":\"12\",\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#FFFFFF\",\"width\":1,\"type\":\"solid\"}},\"splitArea\":{\"show\":true}}}', '[]', 'admin', 1628136691089, 1628141845016, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('0de1d446-8300-4ab3-a4ef-4e8f8579cb2e', '静态时间', 'bfa7d87f-c76f-4406-9f19-0adccb7c568d', '44e5d4c4-e4da-4007-84af-ac5f58c0ed51', 'text', '静态时间', '[{\"id\":\"c5055c91-f768-46b1-b11f-19c9a47e4d12\",\"tableId\":\"44e5d4c4-e4da-4007-84af-ac5f58c0ed51\",\"originName\":\"update_date\",\"name\":\"update_date\",\"dataeaseName\":\"C_41747ca060fc704c1c3f7c0ebacde6e7\",\"groupType\":\"d\",\"type\":\"DATETIME\",\"size\":50,\"deType\":1,\"deTypeFormat\":null,\"deExtractType\":1,\"extField\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1628142390856,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[]}]', '[]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#BEBEBD\",\"quotaColor\":\"#FFC125\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":80,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"tableTitleHeight\":36,\"tableItemHeight\":36,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"14\",\"quotaFontSize\":\"28\",\"spaceSplit\":15,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"isBolder\":false,\"title\":\"中国金牌总数\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"background\":{\"color\":\"#ffffff\",\"alpha\":10},\"split\":{\"name\":{\"show\":true,\"color\":\"#999999\",\"fontSize\":\"12\"},\"splitNumber\":5,\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisTick\":{\"show\":false,\"length\":5,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisLabel\":{\"show\":false,\"rotate\":0,\"margin\":8,\"color\":\"#999999\",\"fontSize\":\"12\",\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"splitArea\":{\"show\":true}}}', '[]', 'admin', 1628127698484, 1628159825981, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('ebac2821-d1a0-4f26-b5d9-cd5c60ac75ab', '各产品销售额分布', '2c200620-f2f3-4224-a41d-381fa061591b', '3bdd926e-e842-4359-beb9-438da019d937', 'line-stack', '各产品销售额分布', '[{\"id\":\"8c473925-a05c-4ddb-85f0-2356be415a6a\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"产品名称\",\"name\":\"产品名称\",\"dataeaseName\":\"C_ff6855279eeccc6d6f1ff32f40a8e4d4\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":3,\"lastSyncTime\":1627972000990,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[]}]', '[{\"id\":\"da7696ce-1704-4719-afa0-e97c14962c9e\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销售额\",\"name\":\"销售额\",\"dataeaseName\":\"C_9ae44464b750efab9276b55e3703dcdf\",\"groupType\":\"q\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":5,\"lastSyncTime\":1627972000990,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"technology\",\"colors\":[\"#05f8d6\",\"#0082fc\",\"#fdd845\",\"#22ed7c\",\"#09b0d3\",\"#1d27c9\",\"#f9e264\",\"#f47a75\",\"#009db2\"],\"alpha\":70,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":true,\"pieInnerRadius\":40,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true,\"tableTitleHeight\":36,\"tableItemHeight\":36},\"label\":{\"show\":true,\"position\":\"outside\",\"color\":\"#ffffff\",\"fontSize\":\"12\",\"formatter\":\"\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":false,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"18\",\"color\":\"#ffffff\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"各产品销售额分布\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#ffffff\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"color\":\"#ffffff\",\"fontSize\":\"12\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"color\":\"#ffffff\",\"fontSize\":\"12\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#CECCCC\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12}},\"background\":{\"color\":\"#ffffff\",\"alpha\":5}}', '[]', 'admin', 1624270453228, 1628142033100, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('5ad64afc-132c-40ea-8f69-2f8bfe6b31d4', '各部门销售额分布', '2c200620-f2f3-4224-a41d-381fa061591b', '3bdd926e-e842-4359-beb9-438da019d937', 'bar', '各部门销售额分布', '[{\"id\":\"9befc5e2-ba68-4e58-b73c-c1e049792aa4\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销售部门\",\"name\":\"销售部门\",\"dataeaseName\":\"C_8293760cb7ef39e6b56ac2c5fc1f0831\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":2,\"lastSyncTime\":1627972000990,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[]}]', '[{\"id\":\"da7696ce-1704-4719-afa0-e97c14962c9e\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销售额\",\"name\":\"销售额\",\"dataeaseName\":\"C_9ae44464b750efab9276b55e3703dcdf\",\"groupType\":\"q\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":5,\"lastSyncTime\":1627972000990,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"fast\",\"colors\":[\"#fae800\",\"#00c039\",\"#0482dc\",\"#bb9581\",\"#ff7701\",\"#9c5ec3\",\"#00ccdf\",\"#00c039\",\"#ff7701\"],\"alpha\":70,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":false,\"barWidth\":20,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":40,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true,\"tableTitleHeight\":36,\"tableItemHeight\":36},\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#ffffff\",\"fontSize\":\"12\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"18\",\"color\":\"#ffffff\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"各部门销售额分布\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#ffffff\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"color\":\"#ffffff\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#ffffff\",\"fontSize\":12}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"color\":\"#ffffff\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#ffffff\",\"fontSize\":12}},\"background\":{\"color\":\"#ffffff\",\"alpha\":5}}', '[]', 'admin', 1624269202219, 1627975080044, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('4242cbb0-fca4-4b27-b2a7-ca576a18815e', '当年各产品销量', '2c200620-f2f3-4224-a41d-381fa061591b', '3bdd926e-e842-4359-beb9-438da019d937', 'pie', '当年各产品销量', '[{\"id\":\"8c473925-a05c-4ddb-85f0-2356be415a6a\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"产品名称\",\"name\":\"产品名称\",\"dataeaseName\":\"C_ff6855279eeccc6d6f1ff32f40a8e4d4\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":3,\"lastSyncTime\":1627972000990,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[]}]', '[{\"id\":\"b03bf6df-4aad-411c-8c08-a9ae48da7908\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销量\",\"name\":\"销量\",\"dataeaseName\":\"C_44e7ebb4007104495dcb7afbbb6778fb\",\"groupType\":\"q\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":4,\"lastSyncTime\":1627972000990,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"fast\",\"colors\":[\"#fae800\",\"#00c039\",\"#0482dc\",\"#bb9581\",\"#ff7701\",\"#9c5ec3\",\"#00ccdf\",\"#00c039\",\"#ff7701\"],\"alpha\":70,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":false,\"barWidth\":37,\"barGap\":0.6,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":40,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true,\"tableTitleHeight\":36,\"tableItemHeight\":36},\"label\":{\"show\":true,\"position\":\"outside\",\"color\":\"#ffffff\",\"fontSize\":\"12\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"18\",\"color\":\"#ffffff\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"当年各产品销量\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#ffffff\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"color\":\"#ffffff\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#ffffff\",\"fontSize\":12}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"color\":\"#ffffff\",\"fontSize\":\"10\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#ffffff\",\"fontSize\":12}},\"background\":{\"color\":\"#ffffff\",\"alpha\":5}}', '[]', 'admin', 1624327987018, 1627975145312, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('c52b6d95-b404-4130-8635-5903cb8d0e84', '当年各部门销量', '2c200620-f2f3-4224-a41d-381fa061591b', '3bdd926e-e842-4359-beb9-438da019d937', 'funnel', '当年各部门销量', '[{\"id\":\"9befc5e2-ba68-4e58-b73c-c1e049792aa4\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销售部门\",\"name\":\"销售部门\",\"dataeaseName\":\"C_8293760cb7ef39e6b56ac2c5fc1f0831\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":2,\"lastSyncTime\":1627972000990,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[]}]', '[{\"id\":\"b03bf6df-4aad-411c-8c08-a9ae48da7908\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销量\",\"name\":\"销量\",\"dataeaseName\":\"C_44e7ebb4007104495dcb7afbbb6778fb\",\"groupType\":\"q\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":4,\"lastSyncTime\":1627972000990,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"fresh\",\"colors\":[\"#5f9b3c\",\"#75c24b\",\"#83d65f\",\"#aacf53\",\"#c7dc68\",\"#d8e698\",\"#e0ebaf\",\"#bbc8e6\",\"#e5e5e5\"],\"alpha\":70,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":18,\"barGap\":0.4,\"lineWidth\":2,\"lineType\":\"solid\",\"lineSymbol\":\"none\",\"lineSymbolSize\":4,\"lineSmooth\":true,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":25,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true,\"tableTitleHeight\":36,\"tableItemHeight\":36},\"label\":{\"show\":true,\"position\":\"right\",\"color\":\"#ffffff\",\"fontSize\":\"12\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"18\",\"color\":\"#ffffff\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"当年各部门销量\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#ffffff\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"color\":\"#ffffff\",\"fontSize\":\"12\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"fontSize\":\"12\",\"color\":\"#ffffff\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12}},\"background\":{\"color\":\"#ffffff\",\"alpha\":5}}', '[]', 'admin', 1624270550282, 1627975210544, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('2e6f8b45-116d-46c4-a287-f3054e798556', '销售额YTD-2', '2c200620-f2f3-4224-a41d-381fa061591b', '3bdd926e-e842-4359-beb9-438da019d937', 'text', '销售额YTD-2', '[]', '[{\"id\":\"da7696ce-1704-4719-afa0-e97c14962c9e\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销售额\",\"name\":\"销售额YTD\",\"dataeaseName\":\"C_9ae44464b750efab9276b55e3703dcdf\",\"groupType\":\"q\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":5,\"lastSyncTime\":1627972000990,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[],\"index\":0,\"renameType\":\"quota\"}]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#969696\",\"quotaColor\":\"#00afee\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":80,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"tableTitleHeight\":36,\"tableItemHeight\":36,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"16\",\"quotaFontSize\":\"32\",\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"isBolder\":false,\"title\":\"销售额YTD\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"background\":{\"color\":\"#ffffff\",\"alpha\":5},\"split\":{\"name\":{\"show\":true,\"color\":\"#999999\",\"fontSize\":\"12\"},\"splitNumber\":5,\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisTick\":{\"show\":false,\"length\":5,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisLabel\":{\"show\":false,\"rotate\":0,\"margin\":8,\"color\":\"#999999\",\"fontSize\":\"12\",\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"splitArea\":{\"show\":true}}}', '[{\"id\":\"1aae0554-d82d-4713-bd5d-c1df5b1269aa\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"年份\",\"name\":\"年份\",\"dataeaseName\":\"C_8f30e9f8678c24496921bebae6ca2ac6\",\"groupType\":\"d\",\"type\":\"INT UNSIGNED\",\"size\":10,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1627972000990,\"filter\":[{\"fieldId\":\"1aae0554-d82d-4713-bd5d-c1df5b1269aa\",\"term\":\"eq\",\"value\":\"2021\"}],\"index\":0}]', 'admin', 1625826467447, 1628159311936, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('504c0abd-7d31-4771-8ef9-a3494c7bb33c', '销售额YTD-4', '2c200620-f2f3-4224-a41d-381fa061591b', '3bdd926e-e842-4359-beb9-438da019d937', 'text', '销售额YTD-4', '[]', '[{\"id\":\"da7696ce-1704-4719-afa0-e97c14962c9e\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销售额\",\"name\":\"销售额MTD\",\"dataeaseName\":\"C_9ae44464b750efab9276b55e3703dcdf\",\"groupType\":\"q\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":5,\"lastSyncTime\":1627972000990,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[],\"index\":0,\"renameType\":\"quota\"}]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#969696\",\"quotaColor\":\"#f9974c\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":80,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"tableTitleHeight\":36,\"tableItemHeight\":36,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"16\",\"quotaFontSize\":\"32\",\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"isBolder\":false,\"title\":\"销售额YTD\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"background\":{\"color\":\"#ffffff\",\"alpha\":5},\"split\":{\"name\":{\"show\":true,\"color\":\"#999999\",\"fontSize\":\"12\"},\"splitNumber\":5,\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisTick\":{\"show\":false,\"length\":5,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisLabel\":{\"show\":false,\"rotate\":0,\"margin\":8,\"color\":\"#999999\",\"fontSize\":\"12\",\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"splitArea\":{\"show\":true}}}', '[{\"id\":\"1aae0554-d82d-4713-bd5d-c1df5b1269aa\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"年份\",\"name\":\"年份\",\"dataeaseName\":\"C_8f30e9f8678c24496921bebae6ca2ac6\",\"groupType\":\"d\",\"type\":\"INT UNSIGNED\",\"size\":10,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1627972000990,\"filter\":[{\"fieldId\":\"1aae0554-d82d-4713-bd5d-c1df5b1269aa\",\"term\":\"eq\",\"value\":\"2021\"}],\"index\":0},{\"id\":\"ce917ef4-fe7a-4be5-bfbf-f4250daefb5d\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"月\",\"name\":\"月\",\"dataeaseName\":\"C_e42b99d59954ce6437e66f416850425a\",\"groupType\":\"d\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1627972000990,\"filter\":[{\"fieldId\":\"ce917ef4-fe7a-4be5-bfbf-f4250daefb5d\",\"term\":\"eq\",\"value\":\"8\"}],\"index\":1}]', 'admin', 1625826467447, 1628159328136, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('02136575-effb-4a0c-b5be-9886d20259b3', '销售额YTD-1', '2c200620-f2f3-4224-a41d-381fa061591b', '3bdd926e-e842-4359-beb9-438da019d937', 'text', '销售额YTD-', '[]', '[{\"id\":\"da7696ce-1704-4719-afa0-e97c14962c9e\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销售额\",\"name\":\"今日销售额\",\"dataeaseName\":\"C_9ae44464b750efab9276b55e3703dcdf\",\"groupType\":\"q\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":5,\"lastSyncTime\":1627972000990,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[],\"index\":0,\"renameType\":\"quota\"}]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#969696\",\"quotaColor\":\"#ff1e02\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":80,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"tableTitleHeight\":36,\"tableItemHeight\":36,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"16\",\"quotaFontSize\":\"32\",\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"isBolder\":false,\"title\":\"销售额YTD\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"background\":{\"color\":\"#ffffff\",\"alpha\":5},\"split\":{\"name\":{\"show\":true,\"color\":\"#999999\",\"fontSize\":\"12\"},\"splitNumber\":5,\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisTick\":{\"show\":false,\"length\":5,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisLabel\":{\"show\":false,\"rotate\":0,\"margin\":8,\"color\":\"#999999\",\"fontSize\":\"12\",\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"splitArea\":{\"show\":true}}}', '[{\"id\":\"1aae0554-d82d-4713-bd5d-c1df5b1269aa\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"年份\",\"name\":\"年份\",\"dataeaseName\":\"C_8f30e9f8678c24496921bebae6ca2ac6\",\"groupType\":\"d\",\"type\":\"INT UNSIGNED\",\"size\":10,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1627972000990,\"filter\":[{\"fieldId\":\"1aae0554-d82d-4713-bd5d-c1df5b1269aa\",\"term\":\"eq\",\"value\":\"2021\"}],\"index\":0},{\"id\":\"ce917ef4-fe7a-4be5-bfbf-f4250daefb5d\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"月\",\"name\":\"月\",\"dataeaseName\":\"C_e42b99d59954ce6437e66f416850425a\",\"groupType\":\"d\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1627972000990,\"filter\":[{\"fieldId\":\"ce917ef4-fe7a-4be5-bfbf-f4250daefb5d\",\"term\":\"eq\",\"value\":\"8\"}],\"index\":1},{\"id\":\"1648165f-8dcd-4e8b-b2de-6fb0ba4160e4\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"1\",\"name\":\"日\",\"dataeaseName\":\"f_4bb7e6124994f7cfb9ae43830a19a981\",\"groupType\":\"d\",\"type\":\"0\",\"size\":0,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":2,\"checked\":true,\"columnIndex\":7,\"lastSyncTime\":1627975636862,\"filter\":[{\"fieldId\":\"1648165f-8dcd-4e8b-b2de-6fb0ba4160e4\",\"term\":\"eq\",\"value\":\"1\"}],\"index\":2}]', 'admin', 1625826467447, 1627975919878, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('8412d80d-1830-4128-bc6a-019cf32afc7f', '当年销量增长趋势', '2c200620-f2f3-4224-a41d-381fa061591b', '3bdd926e-e842-4359-beb9-438da019d937', 'line', '当年销量增长趋势', '[{\"id\":\"ce917ef4-fe7a-4be5-bfbf-f4250daefb5d\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"月\",\"name\":\"月\",\"dataeaseName\":\"C_e42b99d59954ce6437e66f416850425a\",\"groupType\":\"d\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1627972000990,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[]}]', '[{\"id\":\"b03bf6df-4aad-411c-8c08-a9ae48da7908\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销量\",\"name\":\"销量\",\"dataeaseName\":\"C_44e7ebb4007104495dcb7afbbb6778fb\",\"groupType\":\"q\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":4,\"lastSyncTime\":1627972000990,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"technology\",\"colors\":[\"#05f8d6\",\"#0082fc\",\"#fdd845\",\"#22ed7c\",\"#09b0d3\",\"#1d27c9\",\"#f9e264\",\"#f47a75\",\"#009db2\"],\"alpha\":60,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":2,\"lineType\":\"solid\",\"lineSymbol\":\"none\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":76,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true,\"tableTitleHeight\":36,\"tableItemHeight\":36},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#ffffff\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"18\",\"color\":\"#ffffff\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"当年销量增长趋势\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#ffffff\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"fontSize\":\"12\",\"color\":\"#ffffff\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"color\":\"#ffffff\",\"fontSize\":\"12\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#525252\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12}},\"background\":{\"color\":\"#ffffff\",\"alpha\":5}}', '[]', 'admin', 1624328468945, 1627978565311, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('0f9cd623-f319-4bb5-9751-7478abee3bd2', '当年销售额增长趋势', '2c200620-f2f3-4224-a41d-381fa061591b', '3bdd926e-e842-4359-beb9-438da019d937', 'line', '当年销售额增长趋势', '[{\"id\":\"ce917ef4-fe7a-4be5-bfbf-f4250daefb5d\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"月\",\"name\":\"月\",\"dataeaseName\":\"C_e42b99d59954ce6437e66f416850425a\",\"groupType\":\"d\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1627972000990,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[]}]', '[{\"id\":\"da7696ce-1704-4719-afa0-e97c14962c9e\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销售额\",\"name\":\"销售额\",\"dataeaseName\":\"C_9ae44464b750efab9276b55e3703dcdf\",\"groupType\":\"q\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":5,\"lastSyncTime\":1627972000990,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"gentle\",\"colors\":[\"#5b9bd5\",\"#ed7d31\",\"#70ad47\",\"#ffc000\",\"#4472c4\",\"#91d024\",\"#b235e6\",\"#02ae75\",\"#5b9bd5\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":2,\"lineType\":\"solid\",\"lineSymbol\":\"none\",\"lineSymbolSize\":4,\"lineSmooth\":true,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":122,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true,\"tableTitleHeight\":36,\"tableItemHeight\":36},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\"},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"18\",\"color\":\"#ffffff\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"当年销售额增长趋势\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#ffffff\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"月份\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"color\":\"#ffffff\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#ffffff\",\"fontSize\":12}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"color\":\"#ffffff\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#525252\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#ffffff\",\"fontSize\":12}},\"background\":{\"color\":\"#ffffff\",\"alpha\":5}}', '[]', 'admin', 1624268036781, 1627978377147, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('a1d7bfef-f20c-4739-bfe4-cc55ed0b3fc8', '销售额（销售一部）', '2c200620-f2f3-4224-a41d-381fa061591b', '3bdd926e-e842-4359-beb9-438da019d937', 'line', '销售额（销售一部）', '[{\"id\":\"ce917ef4-fe7a-4be5-bfbf-f4250daefb5d\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"月\",\"name\":\"月\",\"dataeaseName\":\"C_e42b99d59954ce6437e66f416850425a\",\"groupType\":\"d\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1627972000990,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[]}]', '[{\"id\":\"da7696ce-1704-4719-afa0-e97c14962c9e\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销售额\",\"name\":\"销售额\",\"dataeaseName\":\"C_9ae44464b750efab9276b55e3703dcdf\",\"groupType\":\"q\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":5,\"lastSyncTime\":1627972000990,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"fast\",\"colors\":[\"#fae800\",\"#00c039\",\"#0482dc\",\"#bb9581\",\"#ff7701\",\"#9c5ec3\",\"#00ccdf\",\"#00c039\",\"#ff7701\"],\"alpha\":70,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":2,\"lineType\":\"solid\",\"lineSymbol\":\"none\",\"lineSymbolSize\":4,\"lineSmooth\":true,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":122,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true,\"tableTitleHeight\":36,\"tableItemHeight\":36},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\"},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"18\",\"color\":\"#ffffff\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"销售额（销售一部）\"},\"legend\":{\"show\":false,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#ffffff\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":false,\"position\":\"bottom\",\"name\":\"月份\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"color\":\"#ffffff\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#ffffff\",\"fontSize\":12}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"color\":\"#ffffff\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#00afee\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#ffffff\",\"fontSize\":12}},\"background\":{\"color\":\"#ffffff\",\"alpha\":5}}', '[{\"id\":\"9befc5e2-ba68-4e58-b73c-c1e049792aa4\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销售部门\",\"name\":\"销售部门\",\"dataeaseName\":\"C_8293760cb7ef39e6b56ac2c5fc1f0831\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":2,\"lastSyncTime\":1627972000990,\"filter\":[{\"fieldId\":\"9befc5e2-ba68-4e58-b73c-c1e049792aa4\",\"term\":\"eq\",\"value\":\"销售一部\"}],\"index\":0}]', 'admin', 1624268036781, 1627978451224, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('68fc74f2-1790-427a-ac22-49fb20edbe9a', '销售额（销售二部）', '2c200620-f2f3-4224-a41d-381fa061591b', '3bdd926e-e842-4359-beb9-438da019d937', 'line', '销售额（销售二部）', '[{\"id\":\"ce917ef4-fe7a-4be5-bfbf-f4250daefb5d\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"月\",\"name\":\"月\",\"dataeaseName\":\"C_e42b99d59954ce6437e66f416850425a\",\"groupType\":\"d\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1627972000990,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[]}]', '[{\"id\":\"da7696ce-1704-4719-afa0-e97c14962c9e\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销售额\",\"name\":\"销售额\",\"dataeaseName\":\"C_9ae44464b750efab9276b55e3703dcdf\",\"groupType\":\"q\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":5,\"lastSyncTime\":1627972000990,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"simple\",\"colors\":[\"#929fff\",\"#9de0ff\",\"#ffa897\",\"#af87fe\",\"#7dc3fe\",\"#bb60b2\",\"#433e7c\",\"#f47a75\",\"#009db2\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":2,\"lineType\":\"solid\",\"lineSymbol\":\"none\",\"lineSymbolSize\":4,\"lineSmooth\":true,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":122,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true,\"tableTitleHeight\":36,\"tableItemHeight\":36},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\"},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"18\",\"color\":\"#ffffff\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"销售额（销售二部）\"},\"legend\":{\"show\":false,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#ffffff\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":false,\"position\":\"bottom\",\"name\":\"月份\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"color\":\"#ffffff\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#ffffff\",\"fontSize\":12}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"color\":\"#ffffff\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#00afee\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#ffffff\",\"fontSize\":12}},\"background\":{\"color\":\"#ffffff\",\"alpha\":5}}', '[{\"id\":\"9befc5e2-ba68-4e58-b73c-c1e049792aa4\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销售部门\",\"name\":\"销售部门\",\"dataeaseName\":\"C_8293760cb7ef39e6b56ac2c5fc1f0831\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":2,\"lastSyncTime\":1627972000990,\"filter\":[{\"fieldId\":\"9befc5e2-ba68-4e58-b73c-c1e049792aa4\",\"term\":\"eq\",\"value\":\"销售二部\"}],\"index\":0}]', 'admin', 1624268036781, 1627974664625, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('97400660-27a5-4502-a7cd-274190953a6c', '销售额（销售三部）', '2c200620-f2f3-4224-a41d-381fa061591b', '3bdd926e-e842-4359-beb9-438da019d937', 'line', '销售额（销售三部）', '[{\"id\":\"ce917ef4-fe7a-4be5-bfbf-f4250daefb5d\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"月\",\"name\":\"月\",\"dataeaseName\":\"C_e42b99d59954ce6437e66f416850425a\",\"groupType\":\"d\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1627972000990,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"asc\",\"filter\":[]}]', '[{\"id\":\"da7696ce-1704-4719-afa0-e97c14962c9e\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销售额\",\"name\":\"销售额\",\"dataeaseName\":\"C_9ae44464b750efab9276b55e3703dcdf\",\"groupType\":\"q\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":5,\"lastSyncTime\":1627972000990,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"fresh\",\"colors\":[\"#5f9b3c\",\"#75c24b\",\"#83d65f\",\"#aacf53\",\"#c7dc68\",\"#d8e698\",\"#e0ebaf\",\"#bbc8e6\",\"#e5e5e5\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":2,\"lineType\":\"solid\",\"lineSymbol\":\"none\",\"lineSymbolSize\":4,\"lineSmooth\":true,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":122,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true,\"tableTitleHeight\":36,\"tableItemHeight\":36},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\"},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"18\",\"color\":\"#ffffff\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"销售额（销售三部）\"},\"legend\":{\"show\":false,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#ffffff\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":false,\"position\":\"bottom\",\"name\":\"月份\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"color\":\"#ffffff\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#ffffff\",\"fontSize\":12}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"color\":\"#ffffff\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#00afee\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#ffffff\",\"fontSize\":12}},\"background\":{\"color\":\"#ffffff\",\"alpha\":5}}', '[{\"id\":\"9befc5e2-ba68-4e58-b73c-c1e049792aa4\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销售部门\",\"name\":\"销售部门\",\"dataeaseName\":\"C_8293760cb7ef39e6b56ac2c5fc1f0831\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":2,\"lastSyncTime\":1627972000990,\"filter\":[{\"fieldId\":\"9befc5e2-ba68-4e58-b73c-c1e049792aa4\",\"term\":\"eq\",\"value\":\"销售三部\"}],\"index\":0}]', 'admin', 1624268036781, 1627974757406, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('07ece816-f983-493e-b25d-7bfb467d787d', '销售额（销售四部）', '2c200620-f2f3-4224-a41d-381fa061591b', '3bdd926e-e842-4359-beb9-438da019d937', 'line', '销售额（销售四部）', '[{\"id\":\"ce917ef4-fe7a-4be5-bfbf-f4250daefb5d\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"月\",\"name\":\"月\",\"dataeaseName\":\"C_e42b99d59954ce6437e66f416850425a\",\"groupType\":\"d\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1627972000990,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[]}]', '[{\"id\":\"da7696ce-1704-4719-afa0-e97c14962c9e\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销售额\",\"name\":\"销售额\",\"dataeaseName\":\"C_9ae44464b750efab9276b55e3703dcdf\",\"groupType\":\"q\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":5,\"lastSyncTime\":1627972000990,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"energy\",\"colors\":[\"#ef8b07\",\"#2a83a2\",\"#f07474\",\"#c55784\",\"#274a78\",\"#7058a3\",\"#0095d9\",\"#75c24b\",\"#808080\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":2,\"lineType\":\"solid\",\"lineSymbol\":\"none\",\"lineSymbolSize\":4,\"lineSmooth\":true,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":122,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true,\"tableTitleHeight\":36,\"tableItemHeight\":36},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\"},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"18\",\"color\":\"#ffffff\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"销售额（销售四部）\"},\"legend\":{\"show\":false,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#ffffff\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":false,\"position\":\"bottom\",\"name\":\"月份\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"color\":\"#ffffff\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#ffffff\",\"fontSize\":12}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\",\"show\":true,\"color\":\"#ffffff\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#00afee\",\"width\":1,\"style\":\"solid\"}},\"nameTextStyle\":{\"color\":\"#ffffff\",\"fontSize\":12}},\"background\":{\"color\":\"#ffffff\",\"alpha\":5}}', '[{\"id\":\"9befc5e2-ba68-4e58-b73c-c1e049792aa4\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销售部门\",\"name\":\"销售部门\",\"dataeaseName\":\"C_8293760cb7ef39e6b56ac2c5fc1f0831\",\"groupType\":\"d\",\"type\":\"VARCHAR\",\"size\":255,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":2,\"lastSyncTime\":1627972000990,\"filter\":[{\"fieldId\":\"9befc5e2-ba68-4e58-b73c-c1e049792aa4\",\"term\":\"eq\",\"value\":\"销售四部\"}],\"index\":0}]', 'admin', 1624268036781, 1627974826918, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('c124c0f3-3f1f-4635-bac7-f3e1f5503099', '销售额YTD-3', '2c200620-f2f3-4224-a41d-381fa061591b', '3bdd926e-e842-4359-beb9-438da019d937', 'text', '销售额YTD-3', '[]', '[{\"id\":\"b03bf6df-4aad-411c-8c08-a9ae48da7908\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销量\",\"name\":\"今日销量\",\"dataeaseName\":\"C_44e7ebb4007104495dcb7afbbb6778fb\",\"groupType\":\"q\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":4,\"lastSyncTime\":1627972000990,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[],\"index\":0,\"renameType\":\"quota\"}]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#969696\",\"quotaColor\":\"#ff1e02\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":80,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"tableTitleHeight\":36,\"tableItemHeight\":36,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"16\",\"quotaFontSize\":\"32\",\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"isBolder\":false,\"title\":\"销售额YTD\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"background\":{\"color\":\"#ffffff\",\"alpha\":5},\"split\":{\"name\":{\"show\":true,\"color\":\"#999999\",\"fontSize\":\"12\"},\"splitNumber\":5,\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisTick\":{\"show\":false,\"length\":5,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisLabel\":{\"show\":false,\"rotate\":0,\"margin\":8,\"color\":\"#999999\",\"fontSize\":\"12\",\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"splitArea\":{\"show\":true}}}', '[{\"id\":\"1aae0554-d82d-4713-bd5d-c1df5b1269aa\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"年份\",\"name\":\"年份\",\"dataeaseName\":\"C_8f30e9f8678c24496921bebae6ca2ac6\",\"groupType\":\"d\",\"type\":\"INT UNSIGNED\",\"size\":10,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1627972000990,\"filter\":[{\"fieldId\":\"1aae0554-d82d-4713-bd5d-c1df5b1269aa\",\"term\":\"eq\",\"value\":\"2021\"}],\"index\":0},{\"id\":\"ce917ef4-fe7a-4be5-bfbf-f4250daefb5d\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"月\",\"name\":\"月\",\"dataeaseName\":\"C_e42b99d59954ce6437e66f416850425a\",\"groupType\":\"d\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1627972000990,\"filter\":[{\"fieldId\":\"ce917ef4-fe7a-4be5-bfbf-f4250daefb5d\",\"term\":\"eq\",\"value\":\"8\"}],\"index\":1},{\"id\":\"1648165f-8dcd-4e8b-b2de-6fb0ba4160e4\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"1\",\"name\":\"日\",\"dataeaseName\":\"f_4bb7e6124994f7cfb9ae43830a19a981\",\"groupType\":\"d\",\"type\":\"0\",\"size\":0,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":2,\"checked\":true,\"columnIndex\":7,\"lastSyncTime\":1627975636862,\"filter\":[{\"fieldId\":\"1648165f-8dcd-4e8b-b2de-6fb0ba4160e4\",\"term\":\"eq\",\"value\":\"1\"}],\"index\":2}]', 'admin', 1625826467447, 1628159320910, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('984059ca-3f9d-4ee4-9616-e409dd11991e', '销量YTD', '2c200620-f2f3-4224-a41d-381fa061591b', '3bdd926e-e842-4359-beb9-438da019d937', 'text', '销量YTD', '[]', '[{\"id\":\"b03bf6df-4aad-411c-8c08-a9ae48da7908\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销量\",\"name\":\"销量YTD\",\"dataeaseName\":\"C_44e7ebb4007104495dcb7afbbb6778fb\",\"groupType\":\"q\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":4,\"lastSyncTime\":1627972000990,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[],\"index\":0,\"renameType\":\"quota\"}]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#969696\",\"quotaColor\":\"#00afee\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":80,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"tableTitleHeight\":36,\"tableItemHeight\":36,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"16\",\"quotaFontSize\":\"32\",\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"isBolder\":false,\"title\":\"销量YTD\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"background\":{\"color\":\"#ffffff\",\"alpha\":5},\"split\":{\"name\":{\"show\":true,\"color\":\"#999999\",\"fontSize\":\"12\"},\"splitNumber\":5,\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisTick\":{\"show\":false,\"length\":5,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisLabel\":{\"show\":false,\"rotate\":0,\"margin\":8,\"color\":\"#999999\",\"fontSize\":\"12\",\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"splitArea\":{\"show\":true}}}', '[{\"id\":\"1aae0554-d82d-4713-bd5d-c1df5b1269aa\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"年份\",\"name\":\"年份\",\"dataeaseName\":\"C_8f30e9f8678c24496921bebae6ca2ac6\",\"groupType\":\"d\",\"type\":\"INT UNSIGNED\",\"size\":10,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1627972000990,\"filter\":[{\"fieldId\":\"1aae0554-d82d-4713-bd5d-c1df5b1269aa\",\"term\":\"eq\",\"value\":\"2021\"}],\"index\":0}]', 'admin', 1625826467447, 1627976226162, NULL, 'view');
INSERT INTO `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `snapshot`, `style_priority`) VALUES ('2de7c3d3-e642-4509-aff1-b2520ebfe85e', '销量MTD', '2c200620-f2f3-4224-a41d-381fa061591b', '3bdd926e-e842-4359-beb9-438da019d937', 'text', '销量MTD', '[]', '[{\"id\":\"b03bf6df-4aad-411c-8c08-a9ae48da7908\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"销量\",\"name\":\"销量MTD\",\"dataeaseName\":\"C_44e7ebb4007104495dcb7afbbb6778fb\",\"groupType\":\"q\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":4,\"lastSyncTime\":1627972000990,\"filter\":[],\"summary\":\"sum\",\"sort\":\"none\",\"index\":0,\"renameType\":\"quota\"}]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#969696\",\"quotaColor\":\"#f9974c\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":80,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"tableTitleHeight\":36,\"tableItemHeight\":36,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"16\",\"quotaFontSize\":\"32\",\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\",\"labelLine\":{\"show\":true}},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"isBolder\":false,\"title\":\"销量MTD\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"nameTextStyle\":{\"color\":\"#333333\",\"fontSize\":12},\"axisLabel\":{\"show\":true,\"color\":\"#333333\",\"fontSize\":\"12\",\"rotate\":0,\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#cccccc\",\"width\":1,\"style\":\"solid\"}}},\"background\":{\"color\":\"#ffffff\",\"alpha\":5},\"split\":{\"name\":{\"show\":true,\"color\":\"#999999\",\"fontSize\":\"12\"},\"splitNumber\":5,\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisTick\":{\"show\":false,\"length\":5,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"axisLabel\":{\"show\":false,\"rotate\":0,\"margin\":8,\"color\":\"#999999\",\"fontSize\":\"12\",\"formatter\":\"{value}\"},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#999999\",\"width\":1,\"type\":\"solid\"}},\"splitArea\":{\"show\":true}}}', '[{\"id\":\"1aae0554-d82d-4713-bd5d-c1df5b1269aa\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"年份\",\"name\":\"年份\",\"dataeaseName\":\"C_8f30e9f8678c24496921bebae6ca2ac6\",\"groupType\":\"d\",\"type\":\"INT UNSIGNED\",\"size\":10,\"deType\":0,\"deTypeFormat\":null,\"deExtractType\":0,\"extField\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1627972000990,\"filter\":[{\"fieldId\":\"1aae0554-d82d-4713-bd5d-c1df5b1269aa\",\"term\":\"eq\",\"value\":\"2021\"}],\"index\":0},{\"id\":\"ce917ef4-fe7a-4be5-bfbf-f4250daefb5d\",\"tableId\":\"3bdd926e-e842-4359-beb9-438da019d937\",\"originName\":\"月\",\"name\":\"月\",\"dataeaseName\":\"C_e42b99d59954ce6437e66f416850425a\",\"groupType\":\"d\",\"type\":\"INT\",\"size\":10,\"deType\":2,\"deTypeFormat\":null,\"deExtractType\":2,\"extField\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1627972000990,\"filter\":[{\"fieldId\":\"ce917ef4-fe7a-4be5-bfbf-f4250daefb5d\",\"term\":\"eq\",\"value\":\"8\"}],\"index\":1}]', 'admin', 1625826467447, 1627976242332, NULL, 'view');

UPDATE  `dataset_group` SET `name` = '示例数据' WHERE (`id` = 'f0728785-cc9a-4c9f-94ca-5bb106534916');

INSERT INTO  `dataset_group` (`id`, `name`, `pid`, `level`, `type`, `create_by`, `create_time`) VALUES ('dfe82631-0ca9-4bd9-a6bd-9a2531d37bf3', '东京奥运会', 'f0728785-cc9a-4c9f-94ca-5bb106534916', '1', 'group', 'admin', '1628068979310');
INSERT INTO  `dataset_group` (`id`, `name`, `pid`, `level`, `type`, `create_by`, `create_time`) VALUES ('fddb9093-fad8-4518-a4b5-61b51abf07f6', '某运动品牌销售数据', 'f0728785-cc9a-4c9f-94ca-5bb106534916', '1', 'group', 'admin', '1627971903966');

INSERT INTO  `dataset_table` (`id`, `name`, `scene_id`, `data_source_id`, `type`, `mode`, `info`, `create_by`, `create_time`, `qrtz_instance`, `sync_status`, `last_update_time`) VALUES ('077e3af4-a544-43bc-ab48-a3a161b51ba8', 'demo_demo_olympiad_gold_date', 'dfe82631-0ca9-4bd9-a6bd-9a2531d37bf3', '76026997-94f9-4a35-96ca-151084638969', 'db', '0', '{\"table\":\"demo_olympiad_gold_date\"}', 'admin', '1628136405549', '3420075446f916280724849991628072487409', 'Completed', '1628136420093');
INSERT INTO  `dataset_table` (`id`, `name`, `scene_id`, `data_source_id`, `type`, `mode`, `info`, `create_by`, `create_time`, `qrtz_instance`, `sync_status`) VALUES ('2008e6ad-9e38-4339-aeaf-b21a42454a29', 'demo_demo_olympiad_athlete', 'dfe82631-0ca9-4bd9-a6bd-9a2531d37bf3', '76026997-94f9-4a35-96ca-151084638969', 'db', '0', '{\"table\":\"demo_olympiad_athlete\"}', 'admin', '1628074119798', 'Iris-Mac.local16280677973871628067797489', 'Error');
INSERT INTO  `dataset_table` (`id`, `name`, `scene_id`, `data_source_id`, `type`, `mode`, `info`, `create_by`, `create_time`) VALUES ('2b6843c2-e15b-44ca-8fae-77e421565c3a', '运动员热搜榜', 'dfe82631-0ca9-4bd9-a6bd-9a2531d37bf3', '76026997-94f9-4a35-96ca-151084638969', 'custom', '0', '{\"list\":[{\"tableId\":\"2008e6ad-9e38-4339-aeaf-b21a42454a29\",\"checkedFields\":[\"ef8db435-eeb2-4f4d-959d-927974ba15f6\",\"a2026ff9-34ad-4115-a25d-364e6d0d9fd3\",\"81ed9143-a3bf-4d34-b758-ce215397ca7a\"]},{\"tableId\":\"bafd31e8-2f0b-47ad-a680-af20163c498c\",\"checkedFields\":[\"79dabe0c-5c35-437f-86ce-d476eb67e5d3\"]},{\"tableId\":\"9c7b85bc-2c84-41f8-9051-f4b093a5cffc\",\"checkedFields\":[\"a0cc4ac5-709a-43a6-92a2-308c3392c1fb\"]}]}', 'admin', '1628074286535');
INSERT INTO  `dataset_table` (`id`, `name`, `scene_id`, `data_source_id`, `type`, `mode`, `info`, `create_by`, `create_time`, `qrtz_instance`, `sync_status`) VALUES ('2d7c15d7-0460-461c-9f9a-67c3edd85286', 'demo_demo_olympiad_medal', 'dfe82631-0ca9-4bd9-a6bd-9a2531d37bf3', '76026997-94f9-4a35-96ca-151084638969', 'db', '0', '{\"table\":\"demo_olympiad_medal\"}', 'admin', '1628071572429', 'Iris-Mac.local16280677973871628067797444', 'Error');
INSERT INTO  `dataset_table` (`id`, `name`, `scene_id`, `data_source_id`, `type`, `mode`, `info`, `create_by`, `create_time`, `qrtz_instance`, `sync_status`, `last_update_time`) VALUES ('44e5d4c4-e4da-4007-84af-ac5f58c0ed51', 'demo_demo_olympiad_data_update', 'dfe82631-0ca9-4bd9-a6bd-9a2531d37bf3', '76026997-94f9-4a35-96ca-151084638969', 'db', '0', '{\"table\":\"demo_olympiad_data_update\"}', 'admin', '1628142390823', '3420075446f916280724849991628072487575', 'Completed', '1628142420081');
INSERT INTO  `dataset_table` (`id`, `name`, `scene_id`, `data_source_id`, `type`, `mode`, `info`, `create_by`, `create_time`) VALUES ('89066550-db19-4235-b038-6c566702ca26', '奖牌榜', 'dfe82631-0ca9-4bd9-a6bd-9a2531d37bf3', '76026997-94f9-4a35-96ca-151084638969', 'custom', '0', '{\"list\":[{\"tableId\":\"b1cd453f-738a-4454-9c70-bce7e849d5bb\",\"checkedFields\":[\"77723c1c-4b3c-4be6-b03f-8c4e3f09a11f\",\"cfe9a60a-04d2-479f-a7fd-ccd6a9a293d0\"]},{\"tableId\":\"2d7c15d7-0460-461c-9f9a-67c3edd85286\",\"checkedFields\":[\"0ba3ef23-f452-41f6-9b5c-c446f0cd6fc4\"]},{\"tableId\":\"bafd31e8-2f0b-47ad-a680-af20163c498c\",\"checkedFields\":[\"79dabe0c-5c35-437f-86ce-d476eb67e5d3\"]}]}', 'admin', '1628074414487');
INSERT INTO  `dataset_table` (`id`, `name`, `scene_id`, `data_source_id`, `type`, `mode`, `info`, `create_by`, `create_time`, `qrtz_instance`, `sync_status`) VALUES ('9c7b85bc-2c84-41f8-9051-f4b093a5cffc', 'demo_demo_olympiad_hot_game', 'dfe82631-0ca9-4bd9-a6bd-9a2531d37bf3', '76026997-94f9-4a35-96ca-151084638969', 'db', '0', '{\"table\":\"demo_olympiad_hot_game\"}', 'admin', '1628071572345', 'Iris-Mac.local16280677973871628067797443', 'Error');
INSERT INTO  `dataset_table` (`id`, `name`, `scene_id`, `data_source_id`, `type`, `mode`, `info`, `create_by`, `create_time`, `qrtz_instance`, `sync_status`) VALUES ('ab59c120-51d4-40d9-811b-c6c957302426', 'demo_demo_olympiad_audience_age', 'dfe82631-0ca9-4bd9-a6bd-9a2531d37bf3', '76026997-94f9-4a35-96ca-151084638969', 'db', '0', '{\"table\":\"demo_olympiad_audience_age\"}', 'admin', '1628071572152', 'Iris-Mac.local16280677973871628067797440', 'Error');
INSERT INTO  `dataset_table` (`id`, `name`, `scene_id`, `data_source_id`, `type`, `mode`, `info`, `create_by`, `create_time`, `qrtz_instance`, `sync_status`) VALUES ('b1cd453f-738a-4454-9c70-bce7e849d5bb', 'demo_demo_olympiad_medal_qty', 'dfe82631-0ca9-4bd9-a6bd-9a2531d37bf3', '76026997-94f9-4a35-96ca-151084638969', 'db', '0', '{\"table\":\"demo_olympiad_medal_qty\"}', 'admin', '1628071572504', 'Iris-Mac.local16280677973871628067797445', 'Error');
INSERT INTO  `dataset_table` (`id`, `name`, `scene_id`, `data_source_id`, `type`, `mode`, `info`, `create_by`, `create_time`, `qrtz_instance`, `sync_status`) VALUES ('bafd31e8-2f0b-47ad-a680-af20163c498c', 'demo_demo_olympiad_country', 'dfe82631-0ca9-4bd9-a6bd-9a2531d37bf3', '76026997-94f9-4a35-96ca-151084638969', 'db', '0', '{\"table\":\"demo_olympiad_country\"}', 'admin', '1628071572280', 'Iris-Mac.local16280677973871628067797442', 'Error');
INSERT INTO  `dataset_table` (`id`, `name`, `scene_id`, `data_source_id`, `type`, `mode`, `info`, `create_by`, `create_time`, `qrtz_instance`, `sync_status`) VALUES ('c414e525-9c1d-4e16-9afd-ccb14a4efbbc', 'demo_demo_olympiad_audience_sex', 'dfe82631-0ca9-4bd9-a6bd-9a2531d37bf3', '76026997-94f9-4a35-96ca-151084638969', 'db', '0', '{\"table\":\"demo_olympiad_audience_sex\"}', 'admin', '1628071572219', 'Iris-Mac.local16280677973871628067797441', 'Error');
INSERT INTO  `dataset_table` (`id`, `name`, `scene_id`, `data_source_id`, `type`, `mode`, `info`, `create_by`, `create_time`, `qrtz_instance`, `sync_status`, `last_update_time`) VALUES ('3bdd926e-e842-4359-beb9-438da019d937', 'sales_dashboard', 'fddb9093-fad8-4518-a4b5-61b51abf07f6', '76026997-94f9-4a35-96ca-151084638969', 'sql', '0', '{\"sql\":\"select \\n`year` as \'年份\',\\n`mounth` as \'月\',\\n`sales_dept` as \'销售部门\',\\n`product_name` as \'产品名称\',\\n`sales_qty` as \'销量\',\\n`sales_amount` as \'销售额\',\\n`target_qty` as \'目标销售额\'\\n from demo_sales_dashboard\"}', 'admin', '1627972000955', '3cddfc0ce92a16279717972961627971797257', 'Completed', '1627972001137');

INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('1aae0554-d82d-4713-bd5d-c1df5b1269aa', '3bdd926e-e842-4359-beb9-438da019d937', '年份', '年份', 'C_8f30e9f8678c24496921bebae6ca2ac6', 'd', 'INT UNSIGNED', '10', '0', '0', '0', '1', '0', '1627972000990');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('8c473925-a05c-4ddb-85f0-2356be415a6a', '3bdd926e-e842-4359-beb9-438da019d937', '产品名称', '产品名称', 'C_ff6855279eeccc6d6f1ff32f40a8e4d4', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '3', '1627972000990');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('9befc5e2-ba68-4e58-b73c-c1e049792aa4', '3bdd926e-e842-4359-beb9-438da019d937', '销售部门', '销售部门', 'C_8293760cb7ef39e6b56ac2c5fc1f0831', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '2', '1627972000990');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('aef3ba56-c5ea-4dfb-8e14-782b9e3be33a', '3bdd926e-e842-4359-beb9-438da019d937', '目标销售额', '目标销售额', 'C_e652ac2ae588792c7dfd675ddfeee14e', 'q', 'INT', '10', '2', '2', '0', '1', '6', '1627972000990');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('b03bf6df-4aad-411c-8c08-a9ae48da7908', '3bdd926e-e842-4359-beb9-438da019d937', '销量', '销量', 'C_44e7ebb4007104495dcb7afbbb6778fb', 'q', 'INT', '10', '2', '2', '0', '1', '4', '1627972000990');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('ce917ef4-fe7a-4be5-bfbf-f4250daefb5d', '3bdd926e-e842-4359-beb9-438da019d937', '月', '月', 'C_e42b99d59954ce6437e66f416850425a', 'd', 'INT', '10', '2', '2', '0', '1', '1', '1627972000990');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('da7696ce-1704-4719-afa0-e97c14962c9e', '3bdd926e-e842-4359-beb9-438da019d937', '销售额', '销售额', 'C_9ae44464b750efab9276b55e3703dcdf', 'q', 'INT', '10', '2', '2', '0', '1', '5', '1627972000990');

INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('07ab49dd-a0f5-4f12-9d76-54e88b257bb8', '077e3af4-a544-43bc-ab48-a3a161b51ba8', 'qty', 'qty', 'C_f44fc6cd274569fd327d9bccc761b066', 'q', 'VARCHAR', '255', '2', '0', '0', '1', '3', '1628136405582');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('950c893c-fda4-4d41-addc-49b7eec61779', '077e3af4-a544-43bc-ab48-a3a161b51ba8', 'datekey', 'datekey', 'C_7d0ef745eae6e05fd40e008066923b30', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '1', '1628136405582');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('a3929ad0-0f0d-41f3-a3dd-c5b4ce8b4bfd', '077e3af4-a544-43bc-ab48-a3a161b51ba8', 'game', 'game', 'C_c8d46d341bea4fd5bff866a65ff8aea9', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '2', '1628136405582');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('de59457e-ee09-47b1-af1e-a3ad5b560260', '077e3af4-a544-43bc-ab48-a3a161b51ba8', 'id', 'id', 'C_b80bb7740288fda1f201890375a60c8f', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '0', '1628136405582');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('76990c6c-6e2e-4bcd-992c-279c5d97ef2a', '2008e6ad-9e38-4339-aeaf-b21a42454a29', 'hot_num', 'hot_num', 'C_a94fdf9c93542efe260028210758d3a6', 'q', 'INT', '10', '2', '2', '0', '1', '5', '1628074119837');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('81ed9143-a3bf-4d34-b758-ce215397ca7a', '2008e6ad-9e38-4339-aeaf-b21a42454a29', 'name', 'name', 'C_b068931cc450442b63f5b3d276ea4297', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '2', '1628074119837');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('a2026ff9-34ad-4115-a25d-364e6d0d9fd3', '2008e6ad-9e38-4339-aeaf-b21a42454a29', 'sort', 'sort', 'C_cadc8c8db42409733582cb3e2298ef87', 'q', 'INT', '10', '2', '2', '0', '1', '1', '1628074119837');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('c22e3b14-a052-4f58-97b5-ae5cb96cc7fb', '2008e6ad-9e38-4339-aeaf-b21a42454a29', 'game', 'game', 'C_c8d46d341bea4fd5bff866a65ff8aea9', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '4', '1628074119837');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('ef8db435-eeb2-4f4d-959d-927974ba15f6', '2008e6ad-9e38-4339-aeaf-b21a42454a29', 'code', 'code', 'C_c13367945d5d4c91047b3b50234aa7ab', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '0', '1628074119837');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('f100f6fa-8a43-490e-860d-9f602141ed1e', '2008e6ad-9e38-4339-aeaf-b21a42454a29', 'country', 'country', 'C_e909c2d7067ea37437cf97fe11d91bd0', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '3', '1628074119837');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('2b762183-5b35-4335-8e3d-b27f8ae6f7b8', '2b6843c2-e15b-44ca-8fae-77e421565c3a', 'f_efb97a99716d5e8314d0db8c2167bb3e', 'sort', 'C_2d1ef6cbb5ec1af1d7149efa28bdea22', 'q', 'INT', '10', '2', '2', '0', '1', '1', '1628074286568');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('5085fa8b-1705-44df-b489-6887612c8ab2', '2b6843c2-e15b-44ca-8fae-77e421565c3a', 'f_6e9a07c45d0c88a8adec12667eff5802', 'game', 'C_a6614dfb5f9d84263537d1d62d3a5275', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '4', '1628074286568');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('50abc8aa-bd43-4bd5-b7ac-b302aba83c49', '2b6843c2-e15b-44ca-8fae-77e421565c3a', 'f_bfc54814b214e0124416ddf51786bde9', 'name', 'C_9e5bd79ce4539ef816365f554fa38c0a', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '2', '1628074286568');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('8b27f9f0-7e3d-4796-a319-f8a51374d8b9', '2b6843c2-e15b-44ca-8fae-77e421565c3a', 'f_1451c56f4194a9851e91156eb73b92b6', 'country', 'C_0cbedf776b60d3b4ee8873f6b019822f', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '3', '1628074286568');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('c6b48009-456d-4958-ad83-01ad21da5385', '2b6843c2-e15b-44ca-8fae-77e421565c3a', 'f_fe03e7f7fdd7cab6fafcd58f655fe7c5', 'code', 'C_7dfc24d41fd6ca026700f40e12cf46b4', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '0', '1628074286568');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('0ba3ef23-f452-41f6-9b5c-c446f0cd6fc4', '2d7c15d7-0460-461c-9f9a-67c3edd85286', 'name', 'name', 'C_b068931cc450442b63f5b3d276ea4297', 'd', 'VARCHAR', '50', '0', '0', '0', '1', '1', '1628071572464');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('d70b257c-bb6c-4f3c-8209-5b45e8d0bbcd', '2d7c15d7-0460-461c-9f9a-67c3edd85286', 'code', 'code', 'C_c13367945d5d4c91047b3b50234aa7ab', 'q', 'INT', '10', '2', '2', '0', '1', '0', '1628071572464');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('c5055c91-f768-46b1-b11f-19c9a47e4d12', '44e5d4c4-e4da-4007-84af-ac5f58c0ed51', 'update_date', 'update_date', 'C_41747ca060fc704c1c3f7c0ebacde6e7', 'd', 'DATETIME', '50', '1', '1', '0', '1', '0', '1628142390856');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('525fa05a-b46d-4e79-8574-0d92fa28b6d4', '89066550-db19-4235-b038-6c566702ca26', 'f_5f89cd4674cabeb744d96d20d817e354', 'qty', 'C_7068b281c7ebde67b45ae8c3ecd398e2', 'q', 'VARCHAR', '255', '2', '0', '0', '1', '3', '1628074414519');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('786707bf-3086-46c4-a03b-90ad272a0126', '89066550-db19-4235-b038-6c566702ca26', 'f_1451c56f4194a9851e91156eb73b92b6', 'country', 'C_0cbedf776b60d3b4ee8873f6b019822f', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '0', '1628074414519');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('ac68cc14-8aa8-4951-bf5e-6b39cce0041f', '89066550-db19-4235-b038-6c566702ca26', 'f_7b95ef3dee6832fd45d6b6c97ad63a7b', 'medal', 'C_c90b4b5dd3fbd8fd50294939462c8066', 'd', 'VARCHAR', '50', '0', '0', '0', '1', '1', '1628074414519');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('ddd96e8b-66c7-480d-ab70-2d6589db2504', '89066550-db19-4235-b038-6c566702ca26', 'f_98abace770330b8c18e5f6a4dee1ff07', 'id', 'C_3e7536025504bd230d800c726e96ff3f', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '2', '1628074414519');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('32504142-f44c-429a-939f-c8becc8d8553', '9c7b85bc-2c84-41f8-9051-f4b093a5cffc', 'sort', 'sort', 'C_cadc8c8db42409733582cb3e2298ef87', 'q', 'VARCHAR', '255', '2', '0', '0', '1', '1', '1628071572399');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('a0cc4ac5-709a-43a6-92a2-308c3392c1fb', '9c7b85bc-2c84-41f8-9051-f4b093a5cffc', 'name', 'name', 'C_b068931cc450442b63f5b3d276ea4297', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '2', '1628071572399');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('a4bad9cd-853d-4cf6-9196-1dd4c1b775a0', '9c7b85bc-2c84-41f8-9051-f4b093a5cffc', 'code', 'code', 'C_c13367945d5d4c91047b3b50234aa7ab', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '0', '1628071572399');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('47584c74-ad8a-4a53-9571-02e8f676bbee', 'ab59c120-51d4-40d9-811b-c6c957302426', 'percent', 'percent', 'C_354f047ba64552895b016bbdd60ab174', 'q', 'FLOAT', '255', '3', '3', '0', '1', '1', '1628071572184');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('c1fa4614-5356-4460-bb66-a9c072c2fa0f', 'ab59c120-51d4-40d9-811b-c6c957302426', 'age', 'age', 'C_7d637d275668ed6d41a9b97e6ad3a556', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '0', '1628071572184');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('3f0df945-6f95-43b1-9839-87b84c753a3b', 'b1cd453f-738a-4454-9c70-bce7e849d5bb', 'medal', 'medal', 'C_3522cfa43d8651bd28165e7aa79dee56', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '2', '1628071572538');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('77723c1c-4b3c-4be6-b03f-8c4e3f09a11f', 'b1cd453f-738a-4454-9c70-bce7e849d5bb', 'id', 'id', 'C_b80bb7740288fda1f201890375a60c8f', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '0', '1628071572538');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('cfe9a60a-04d2-479f-a7fd-ccd6a9a293d0', 'b1cd453f-738a-4454-9c70-bce7e849d5bb', 'qty', 'qty', 'C_f44fc6cd274569fd327d9bccc761b066', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '3', '1628071572538');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('e271c15e-4cac-432e-8d7c-d2ad0658703f', 'b1cd453f-738a-4454-9c70-bce7e849d5bb', 'country', 'country', 'C_e909c2d7067ea37437cf97fe11d91bd0', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '1', '1628071572538');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('79dabe0c-5c35-437f-86ce-d476eb67e5d3', 'bafd31e8-2f0b-47ad-a680-af20163c498c', 'name', 'name', 'C_b068931cc450442b63f5b3d276ea4297', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '1', '1628071572315');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('a16d9734-4450-4332-8778-b2e8aca58bfa', 'bafd31e8-2f0b-47ad-a680-af20163c498c', 'code', 'code', 'C_c13367945d5d4c91047b3b50234aa7ab', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '0', '1628071572315');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('91afd224-da91-4fe1-bfb0-558926fdf244', 'c414e525-9c1d-4e16-9afd-ccb14a4efbbc', 'percent', 'percent', 'C_354f047ba64552895b016bbdd60ab174', 'q', 'FLOAT', '255', '3', '3', '0', '1', '1', '1628071572251');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `group_type`, `type`, `size`, `de_type`, `de_extract_type`, `ext_field`, `checked`, `column_index`, `last_sync_time`) VALUES ('c9edeb59-40a7-47dc-8ff7-efca1a0908fb', 'c414e525-9c1d-4e16-9afd-ccb14a4efbbc', 'sex', 'sex', 'C_3c3662bcb661d6de679c636744c66b62', 'd', 'VARCHAR', '255', '0', '0', '0', '1', '0', '1628071572251');


INSERT INTO     `dataset_table_union` (`id`, `source_table_id`, `source_table_field_id`, `source_union_relation`, `target_table_id`, `target_table_field_id`, `target_union_relation`, `create_by`, `create_time`) VALUES ('0a360073-0495-4b0b-90e3-c173cc8ee8b4', '2008e6ad-9e38-4339-aeaf-b21a42454a29', 'c22e3b14-a052-4f58-97b5-ae5cb96cc7fb', '1:N', '9c7b85bc-2c84-41f8-9051-f4b093a5cffc', 'a4bad9cd-853d-4cf6-9196-1dd4c1b775a0', 'N:1', 'admin', '1628074173145');
INSERT INTO     `dataset_table_union` (`id`, `source_table_id`, `source_table_field_id`, `source_union_relation`, `target_table_id`, `target_table_field_id`, `target_union_relation`, `create_by`, `create_time`) VALUES ('0d786261-3eaa-4d9e-b95e-3fdbbd73d359', '0c89f567-a42c-4da6-b816-133474a9c84f', '9cc6ad5c-b48b-4905-bfa7-a8c08df02068', '1:1', '112e93cd-2e49-4dea-a9d8-76f80dda5b58', '839e3094-0b76-4d3c-b594-06ed29a4a533', '1:1', 'admin', '1622690948305');
INSERT INTO     `dataset_table_union` (`id`, `source_table_id`, `source_table_field_id`, `source_union_relation`, `target_table_id`, `target_table_field_id`, `target_union_relation`, `create_by`, `create_time`) VALUES ('2334bdcf-6b0c-4912-8deb-960bdfa97081', '2008e6ad-9e38-4339-aeaf-b21a42454a29', 'f100f6fa-8a43-490e-860d-9f602141ed1e', '1:N', 'bafd31e8-2f0b-47ad-a680-af20163c498c', 'a16d9734-4450-4332-8778-b2e8aca58bfa', 'N:1', 'admin', '1628074153978');
INSERT INTO     `dataset_table_union` (`id`, `source_table_id`, `source_table_field_id`, `source_union_relation`, `target_table_id`, `target_table_field_id`, `target_union_relation`, `create_by`, `create_time`) VALUES ('3089552a-32ba-4188-aeef-275aead37b4d', '90dbbec6-51cc-42de-9a78-5f8ebac4003a', 'a4782fec-2f36-428e-9404-68bb534ff15b', '1:1', 'c43123db-c5e1-4d98-b0e2-6e95eb772be7', '8ce292bb-5022-429b-b3f8-fd8f5c9a31dc', '1:1', 'admin', '1625469454728');
INSERT INTO     `dataset_table_union` (`id`, `source_table_id`, `source_table_field_id`, `source_union_relation`, `target_table_id`, `target_table_field_id`, `target_union_relation`, `create_by`, `create_time`) VALUES ('4d67067f-ad10-4e75-a79b-506717273a33', '4552d90d-d8d6-4979-8272-82cd495dcca0', 'f7920881-f39f-49e4-8557-5cebe30fc846', 'N:1', '3e826ce2-1ad5-4a2c-90d8-d60cedb2b20b', '496f2a86-8a40-428d-81d1-d3cfff145c39', '1:N', 'admin', '1622702899724');
INSERT INTO     `dataset_table_union` (`id`, `source_table_id`, `source_table_field_id`, `source_union_relation`, `target_table_id`, `target_table_field_id`, `target_union_relation`, `create_by`, `create_time`) VALUES ('57fad52e-cfbf-4d53-b93c-5033ffe56fc0', '5900ef37-625f-420c-b336-4251b16cced2', 'f130d3cf-e537-4f0a-a71e-0d39cc51e2ea', 'N:1', '8c67b347-ed5d-461d-b966-a0e9edcfb90b', '35f69ad9-a097-4ece-8c04-f0b2b0bed8bb', '1:N', 'admin', '1623837385329');
INSERT INTO     `dataset_table_union` (`id`, `source_table_id`, `source_table_field_id`, `source_union_relation`, `target_table_id`, `target_table_field_id`, `target_union_relation`, `create_by`, `create_time`) VALUES ('5ad7dc37-54ca-4931-afb7-35ba9d7589b1', '0f2a8ab6-3563-456c-ac05-1ac2b969ad18', '5ab6214e-b26e-457a-acd8-bedcce4b80b1', '1:1', '7ff39fd8-ec0e-4420-ab49-9f2e2bda7af2', '52e3b053-f04c-4f29-bf0d-2431f57f7be0', '1:1', 'admin', '1625209161968');
INSERT INTO     `dataset_table_union` (`id`, `source_table_id`, `source_table_field_id`, `source_union_relation`, `target_table_id`, `target_table_field_id`, `target_union_relation`, `create_by`, `create_time`) VALUES ('7c9a6127-5421-4636-81b9-19ecc498c128', '5b41ee36-8d1c-4cae-af5f-7556d5043ebe', '1db5a917-4fa8-4dbd-b7a0-d24a77c1476e', '1:N', 'f50f3649-75f7-4886-9b0c-a28994904080', 'b67a89e7-63ef-4c7e-bf99-ac3433c79fbe', 'N:1', 'admin', '1627480838431');
INSERT INTO     `dataset_table_union` (`id`, `source_table_id`, `source_table_field_id`, `source_union_relation`, `target_table_id`, `target_table_field_id`, `target_union_relation`, `create_by`, `create_time`) VALUES ('949f511d-916f-4116-9a7c-1551b1cdf67b', '4552d90d-d8d6-4979-8272-82cd495dcca0', 'a6195419-0f97-449e-93b8-10ff0358076a', 'N:1', '6408190b-6a99-47da-85fe-7762bcb7ca48', '3d82e900-6442-478c-8e07-bbfcd808c31d', '1:N', 'admin', '1622702915119');
INSERT INTO     `dataset_table_union` (`id`, `source_table_id`, `source_table_field_id`, `source_union_relation`, `target_table_id`, `target_table_field_id`, `target_union_relation`, `create_by`, `create_time`) VALUES ('98c35a7b-1910-4e89-b8f9-fd719487049f', '5fd0f4d8-b8ec-4aab-b909-6887d6a56e26', '04fc8ce1-8c40-4f2f-ab33-e84f866606f8', 'N:1', 'fbab377c-6ca0-4d04-95ed-15eacf9913a6', 'c552f0f9-39aa-4d3c-952f-bc5f253c5498', '1:N', 'admin', '1623038392639');
INSERT INTO     `dataset_table_union` (`id`, `source_table_id`, `source_table_field_id`, `source_union_relation`, `target_table_id`, `target_table_field_id`, `target_union_relation`, `create_by`, `create_time`) VALUES ('99f4984a-bde6-4b86-a2a5-3f43ad01aa92', '5b6176bd-3eb8-4adf-bfe9-4bd7fbc3c98e', '0afa8643-a8ed-405f-a0ff-bd74db350f7c', '1:N', 'ffa8571c-aa67-4909-bb92-a22caeffe9de', '5fd5004c-3e4e-4e45-b611-22228d078029', 'N:1', 'admin', '1626326922524');
INSERT INTO     `dataset_table_union` (`id`, `source_table_id`, `source_table_field_id`, `source_union_relation`, `target_table_id`, `target_table_field_id`, `target_union_relation`, `create_by`, `create_time`) VALUES ('a35aa4c2-d45e-4e28-9223-8def0c43d433', '3e826ce2-1ad5-4a2c-90d8-d60cedb2b20b', 'dc6cf386-dc15-4e29-855a-484ba31e345c', 'N:1', '6408190b-6a99-47da-85fe-7762bcb7ca48', '3d82e900-6442-478c-8e07-bbfcd808c31d', '1:N', 'admin', '1622693017247');
INSERT INTO     `dataset_table_union` (`id`, `source_table_id`, `source_table_field_id`, `source_union_relation`, `target_table_id`, `target_table_field_id`, `target_union_relation`, `create_by`, `create_time`) VALUES ('a7085615-8f64-41a8-8a02-72e37323c9dc', 'b1cd453f-738a-4454-9c70-bce7e849d5bb', '3f0df945-6f95-43b1-9839-87b84c753a3b', '1:N', '2d7c15d7-0460-461c-9f9a-67c3edd85286', 'd70b257c-bb6c-4f3c-8209-5b45e8d0bbcd', 'N:1', 'admin', '1628072305907');
INSERT INTO     `dataset_table_union` (`id`, `source_table_id`, `source_table_field_id`, `source_union_relation`, `target_table_id`, `target_table_field_id`, `target_union_relation`, `create_by`, `create_time`) VALUES ('b8fc2de7-064f-4abd-a737-a9914d80cde0', '3b01011b-bd91-44af-a027-3688df8a0d48', 'df1f269e-6ad4-48d4-9f95-1923824dbd31', '1:N', 'dda1abad-c36e-40df-bb44-06dac4dd95af', 'c11c0c8f-5a80-4cce-954e-938f10ce50eb', 'N:1', 'admin', '1627012075265');
INSERT INTO     `dataset_table_union` (`id`, `source_table_id`, `source_table_field_id`, `source_union_relation`, `target_table_id`, `target_table_field_id`, `target_union_relation`, `create_by`, `create_time`) VALUES ('ee228435-52b7-470f-b0d2-4bf0f6988919', 'b1cd453f-738a-4454-9c70-bce7e849d5bb', 'e271c15e-4cac-432e-8d7c-d2ad0658703f', '1:N', 'bafd31e8-2f0b-47ad-a680-af20163c498c', 'a16d9734-4450-4332-8778-b2e8aca58bfa', 'N:1', 'admin', '1628072289239');
INSERT INTO     `dataset_table_union` (`id`, `source_table_id`, `source_table_field_id`, `source_union_relation`, `target_table_id`, `target_table_field_id`, `target_union_relation`, `create_by`, `create_time`) VALUES ('fc1a8ac9-75c2-40ec-92df-8e77b82c5a73', 'a773a557-397b-4cf8-bb53-d06ce9f3c0c0', '82be29a7-9855-450a-90ed-7d2e0905c13d', '1:N', '4b74640a-0c40-4d4c-9c79-63059df67c7b', '74a93491-d099-4844-9624-3dcaaba51970', 'N:1', 'admin', '1626945492361');



INSERT INTO `panel_group` (`id`, `name`, `pid`, `level`, `node_type`, `create_by`, `create_time`, `panel_type`, `panel_style`, `panel_data`) VALUES ('c8d4c4b4-2293-417f-b76d-3632cc217bb1', '东京奥运会数据大屏', '308b5d60-ceb4-465d-9bad-cf901f2d38f1', '1', 'panel', 'admin', '1628074781602', 'self', '{\"width\":1600,\"height\":900,\"scale\":100,\"scaleWidth\":100,\"scaleHeight\":100,\"selfAdaption\":true,\"auxiliaryMatrix\":false,\"openCommonStyle\":true,\"panel\":{\"color\":\"#100F0F\",\"imageUrl\":{},\"backgroundType\":\"color\",\"gap\":\"yes\"},\"chart\":{\"stylePriority\":\"panel\",\"xaxis\":\"[]\",\"yaxis\":\"[]\",\"show\":true,\"type\":\"panel\",\"title\":\"\",\"customAttr\":\"{\\\"color\\\":{\\\"value\\\":\\\"future\\\",\\\"colors\\\":[\\\"#63b2ee\\\",\\\"#76da91\\\",\\\"#f8cb7f\\\",\\\"#f89588\\\",\\\"#7cd6cf\\\",\\\"#9192ab\\\",\\\"#7898e1\\\",\\\"#efa666\\\",\\\"#eddd86\\\"],\\\"alpha\\\":100,\\\"tableHeaderBgColor\\\":\\\"#4e81bb\\\",\\\"tableItemBgColor\\\":\\\"#c6d9f0\\\",\\\"tableFontColor\\\":\\\"#000000\\\",\\\"tableStripe\\\":true,\\\"dimensionColor\\\":\\\"#000000\\\",\\\"quotaColor\\\":\\\"#000000\\\"},\\\"tableColor\\\":{\\\"value\\\":\\\"default\\\",\\\"colors\\\":[\\\"#5470c6\\\",\\\"#91cc75\\\",\\\"#fac858\\\",\\\"#ee6666\\\",\\\"#73c0de\\\",\\\"#3ba272\\\",\\\"#fc8452\\\",\\\"#9a60b4\\\",\\\"#ea7ccc\\\"],\\\"alpha\\\":100,\\\"tableHeaderBgColor\\\":\\\"#4e81bb\\\",\\\"tableItemBgColor\\\":\\\"#c6d9f0\\\",\\\"tableFontColor\\\":\\\"#000000\\\",\\\"tableStripe\\\":true,\\\"dimensionColor\\\":\\\"#000000\\\",\\\"quotaColor\\\":\\\"#000000\\\"},\\\"size\\\":{\\\"barDefault\\\":true,\\\"barWidth\\\":40,\\\"barGap\\\":0.4,\\\"lineWidth\\\":1,\\\"lineType\\\":\\\"solid\\\",\\\"lineSymbol\\\":\\\"emptyCircle\\\",\\\"lineSymbolSize\\\":4,\\\"lineSmooth\\\":false,\\\"lineArea\\\":false,\\\"pieInnerRadius\\\":0,\\\"pieOuterRadius\\\":60,\\\"pieRoseType\\\":\\\"radius\\\",\\\"pieRoseRadius\\\":5,\\\"funnelWidth\\\":80,\\\"radarShape\\\":\\\"polygon\\\",\\\"tableTitleFontSize\\\":12,\\\"tableItemFontSize\\\":12,\\\"gaugeMin\\\":0,\\\"gaugeMax\\\":100,\\\"gaugeStartAngle\\\":225,\\\"gaugeEndAngle\\\":-45,\\\"dimensionFontSize\\\":18,\\\"quotaFontSize\\\":18,\\\"spaceSplit\\\":10,\\\"dimensionShow\\\":true,\\\"quotaShow\\\":true},\\\"label\\\":{\\\"show\\\":false,\\\"position\\\":\\\"top\\\",\\\"color\\\":\\\"#909399\\\",\\\"fontSize\\\":\\\"10\\\",\\\"formatter\\\":\\\"{c}\\\",\\\"gaugeFormatter\\\":\\\"{value}\\\"},\\\"tooltip\\\":{\\\"show\\\":true,\\\"trigger\\\":\\\"item\\\",\\\"confine\\\":true,\\\"textStyle\\\":{\\\"fontSize\\\":\\\"10\\\",\\\"color\\\":\\\"#909399\\\"},\\\"formatter\\\":\\\"\\\"}}\",\"customStyle\":\"{\\\"text\\\":{\\\"show\\\":true,\\\"fontSize\\\":\\\"18\\\",\\\"color\\\":\\\"#303133\\\",\\\"hPosition\\\":\\\"center\\\",\\\"vPosition\\\":\\\"top\\\",\\\"isItalic\\\":false},\\\"legend\\\":{\\\"show\\\":true,\\\"hPosition\\\":\\\"center\\\",\\\"vPosition\\\":\\\"bottom\\\",\\\"orient\\\":\\\"horizontal\\\",\\\"icon\\\":\\\"rect\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#333333\\\",\\\"fontSize\\\":\\\"12\\\"}},\\\"xAxis\\\":{\\\"show\\\":true,\\\"position\\\":\\\"bottom\\\",\\\"name\\\":\\\"\\\",\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"formatter\\\":\\\"{value}\\\"}},\\\"yAxis\\\":{\\\"show\\\":true,\\\"position\\\":\\\"left\\\",\\\"name\\\":\\\"\\\",\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"formatter\\\":\\\"{value}\\\"}},\\\"background\\\":{\\\"color\\\":\\\"#ffffff\\\",\\\"alpha\\\":10}}\",\"customFilter\":\"[]\"}}', '[{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"612f7a10-f5b1-11eb-8171-d3f7965fc856\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"ebb42390-f58c-11eb-8e9a-7fab6038d1ae\",\"viewId\":\"95f8e3a2-62a5-48a7-a719-fcf53746da8d\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":400,\"height\":387.5,\"borderRadius\":\"\",\"top\":135.38681948424068,\"left\":0},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"612f7a11-f5b1-11eb-8171-d3f7965fc856\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"ed56fe20-f58c-11eb-8e9a-7fab6038d1ae\",\"viewId\":\"8a26a936-89bf-45a8-b1ce-d5ef1719465d\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":400,\"height\":375,\"borderRadius\":\"\",\"top\":523.4957020057307,\"left\":0},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"612f7a12-f5b1-11eb-8171-d3f7965fc856\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"dcc46900-f58f-11eb-8e9a-7fab6038d1ae\",\"viewId\":\"8d1c3f30-0639-452e-9883-164f37353324\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":266.6666666666667,\"height\":137.5,\"borderRadius\":\"\",\"top\":0,\"left\":266.6666666666667},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"612f7a13-f5b1-11eb-8171-d3f7965fc856\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"dcc46900-f58f-11eb-8e9a-7fab6038d1ae\",\"viewId\":\"175b25df-1939-4582-a9c5-d9e8ed3ea2b1\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":266.6666666666667,\"height\":137.5,\"borderRadius\":\"\",\"top\":0.8918336676217781,\"left\":533.3333333333334},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"612f7a14-f5b1-11eb-8171-d3f7965fc856\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"dcc46900-f58f-11eb-8e9a-7fab6038d1ae\",\"viewId\":\"c3da496f-073c-413a-bebd-e7f1a4a00ba7\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":266.6666666666667,\"height\":137.5,\"borderRadius\":\"\",\"top\":0.8918336676217781,\"left\":800},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"612f7a15-f5b1-11eb-8171-d3f7965fc856\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"dcc46900-f58f-11eb-8e9a-7fab6038d1ae\",\"viewId\":\"da18eecd-feff-4140-a291-cce4abf1afaa\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":266.6666666666667,\"height\":137.5,\"borderRadius\":\"\",\"top\":0,\"left\":1066.6666666666667},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"612f7a16-f5b1-11eb-8171-d3f7965fc856\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"4d596040-f594-11eb-8e9a-7fab6038d1ae\",\"viewId\":\"3f201733-bbb3-485e-a1d6-0fe4f00b5304\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":400,\"height\":375,\"borderRadius\":\"\",\"top\":523.4957020057307,\"left\":400},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"612f7a17-f5b1-11eb-8171-d3f7965fc856\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"4d596040-f594-11eb-8e9a-7fab6038d1ae\",\"viewId\":\"692d5bdc-aa70-4fce-b830-b8d6620539c6\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":400,\"height\":375,\"borderRadius\":\"\",\"top\":523.4957020057307,\"left\":800},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"612f7a18-f5b1-11eb-8171-d3f7965fc856\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"4d596040-f594-11eb-8e9a-7fab6038d1ae\",\"viewId\":\"aff5be0c-f195-4fce-bd2b-b8d0e63764de\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":400,\"height\":375,\"borderRadius\":\"\",\"top\":525,\"left\":1200},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"612f7a19-f5b1-11eb-8171-d3f7965fc856\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"a9752340-f5a4-11eb-ba92-3f452d0e8eaa\",\"viewId\":\"cb66836d-a34c-40c6-87e7-0db0375ec19e\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":800,\"height\":387.5,\"borderRadius\":\"\",\"top\":135.38681948424068,\"left\":400},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"612f7a1a-f5b1-11eb-8171-d3f7965fc856\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"b4edb110-f5a4-11eb-ba92-3f452d0e8eaa\",\"viewId\":\"1d06e2a0-d936-4192-b523-2eb1e8cebd51\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":400,\"height\":387.5,\"borderRadius\":\"\",\"top\":135.38681948424068,\"left\":1200},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"612f7a1b-f5b1-11eb-8171-d3f7965fc856\",\"component\":\"Picture\",\"label\":\"图片\",\"icon\":\"\",\"propValue\":\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAA5YAAAHiCAIAAAAcRcTXAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA39pVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTQyIDc5LjE2MDkyNCwgMjAxNy8wNy8xMy0wMTowNjozOSAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpmNWYzNDAyNy0yNzMxLTRmNDAtODJlZS1jYmIxMzU0NDNjYmQiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6Q0RBQjBENEVGNUFDMTFFQjg1NEFBMjFDNUMyOTI1OTQiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6Q0RBQjBENERGNUFDMTFFQjg1NEFBMjFDNUMyOTI1OTQiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIChXaW5kb3dzKSI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSJ4bXAuaWlkOmM3NGNlODhjLWZiNWMtMDM0My04NGE2LWNlNTY1OTg5ZjY0NSIgc3RSZWY6ZG9jdW1lbnRJRD0iYWRvYmU6ZG9jaWQ6cGhvdG9zaG9wOjFkODg4NWRiLTJiMDAtNDU0Ny05OTg3LTNjMTNjZWE2MjM0ZCIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PjebIuoAAisHSURBVHja7L0JtHTZVR52xjtV1Zv/WeputbrVQkKDCSDEZEDYJBgTgwnBrOWVZQhxEryErSAzmMFykBlswAbZLAI2NnFY8bRWRMBOEAiEZcQgM0XIILVarVYP//imqrrTmbL3Prfq1fuH7lZP/3S+rn7/fTW/c8895zv7fPvb/NUPPcQSEhISEhISEhISbh+I1AQJCQkJCQkJCQmJwiYkJCQkJCQkJCQkCpuQkJCQkJCQkJCQKGxCQkJCQkJCQkKisAkJCQkJCQkJCQmJwiYkJCQkJCQkJCQkCpuQkJCQkJCQkJAobEJCQkJCQkJCQkKisAkJCQkJCQkJCQmJwiYkJCQkJCQkJCQKm5CQkJCQkJCQkJAobEJCQkJCQkJCQkKisAkJCQkJCQkJCYnCJiQkJCQkJCQkJCQKm5CQkJCQkJCQkJAobEJCQkJCQkJCQqKwCQkJCQkJCQkJCYnCJiQkJCQkJCQkJCQKm5CQkJCQkJCQkChsQkJCQkJCQkJCQqKwCQkJCQkJCQkJCYnCJiQkJCQkJCQkJAqbkJCQkJCQkJCQkChsQkJCQkJCQkJCQqKwCQkJCQkJCQkJicImJCQkJCQkJCQkJAqbkJCQkJCQkJCQkChsQkJCQkJCQkJCorAJCQkJCQkJCQkJicImJCQkJCQkJCQkJAqbkJCQkJCQkJCQkChsQkJCQkJCQkJCorAJCQkJCQkJCQkJLz5UaoKEFwobX/HXQoBFUYD/IkJYHHEmONv/xXelVkq421CUo7quu7Y11j79M6WUmdZFUThnUrsl3CX44Xv/tDfWOx+85z7wYFmwMHc4mkACZzB5cCG4FHDwnU/9bmqxhCX4qx96KLVCwrOE+OK/AmOKdc56GHCcC57DQMNpMSQroccBxxvGw/IV8Sg4fL6Xqz2Pngg/4R28a3joizwTv/6zqZETbl98/NFHg2cr3T8sr4FhQXe0qnumoTlicSSEuO/el6cWTrh98bd2Pr2dzW3bZ0KVOgO2Kl3gnknOZQCCKiSHG/e+99YEj5OJg8uFKCwDCks/e9Nb64IERsu5kkLC6wS+hZBe8O/a/XBq50RhExIQszd/PayNmVBZVuS64Fo5GE5oVg34L44pYrE+9l53RvAgr3kbmLQDjDIw2uCSGsYlWl5zHKJwuscD3wnfwQEcce9k8HATzLH3/Uw6Cwm3LD72yCPe+0hKF9SUX5ei8sWiDebbeHDd5yitl8T3aAlIv8LH9H0P1xHO2Did45UnlTx39kw6EQm3IP66PCcYDONMMei0UgmhhcyYVNBvPePAQj0KGYG8wj0KnyA19WrXG2/7QFeSx7km4CXDkbMChbXeOucDTA9AdilKCz/xAGcTNq2bziHBZVrJolCj8nv3/iidi0RhE+4KlH/2f2hU5riCsYXDyMFxhGG4QsZ1boAhA2ZoDrMpzauoDeDEZTnFXvMQMgfL4cAijSWeik9DzmqtMSaGXbHbiSG+JCIfdq21taTxij4SfsLNS+5VcBl8NjzkLHOm/tV/lk5Twk1B3TTOOTg4PDyEzhwWIHbKRWSWnPe9OZLPLMOoi59PH4KlNR0bYrXLoO2CHePFxI/4L3wkCg8yrXUmJWY1wPHaZJLOVMJNwQ++7E2ht9JhGCM4413LSBsAPznFUlUISFgDL7MsV5mA+y3OEUBFBTwBGS3OCJzRVIMXAvV8ga8O+ADHWQFmEwx2MHhTf4y/4guKvNBC9T703nfMG856xa2WRgmjxTvO/2E6TYnCJtxRWPvytza9tdZZH4zMeVU53KGRggvHBIw5qE1ywSAxFbAIDouJOPAYi40HMLpoxnQcb47P1CHSWUH3STzGn54vHw2aWw43Govgw+AeCR+MK3i8OWuC6ZHUUmgWPkkJnis1/fc/nk5fwos7Pgqxu7s7m836HuZEH6lqlmXwEPzqMRwUIrOM/BX+7boOOvKw+08PDAcYSeJwpd1ISoD7pVJGqkpzsveLg0AEGD53+QgAV5FCKKW0UvBi+Fz6BA68Ns/zyWQyqqp0BhNeVHzfmTeGeSday62XziuHgVWYNkQpVC4DDPbYeWHoRuYqudBcKLgarAu9Ex66LbJYegm+kNPsguHXlTxznF8GYouzhccZBq+wGKalGwZKgo8sWWjHHSoQmBGh58yw0PHQSd5L1jJmlfSF5mUhR9X3ffQD6QwmCptwm2H7K97autAY31lmAnfAJ5WGSRZjrjrLyrHz3uJujbdIMyVu7+ANltBAJz1bsE/c34Fxgy8JK5BdLSgeK68KLa1snMKLYICzR+wWbk6JoKVHVkCDkhrW3jCOAZENfd8F2ysptAJujV/C2N728MMEb06N5YlJ9vi/+dF0ZhNeKFzZ3Z3P50dskkjq8lFgjbgqA/6KJNYNwdEBgsjlCi0d9AVDIJY9rRQ2XI/XhoUOAbjpwF/psyMVhjsVyQFRhMPZKveFz0SCq/XOzk5OtDsh4QVirq+3h7Wb1kXgZZAVVzmXWRACOqa1MECHsRDrmUeRWIghWBj2FWoGUO0K/DUYKz2X+BBGN3D64bjlh1fB4hKC1Z9nA3PFyYCOfZw2jmQGRzMQvInsjOrhvSRGW5R0nBv4NOCyjPUCKGxwcKeUVoo2hD44+DXL83fsfiid00RhE251FG/5pmlrZD62TBouPa6HM69yJlA54EioB1MdDkHGdpbmRKEynedZKXQO79D1Ni6L4YelsKhHARIcewHjV6AF8jGpH20q4RI5WO9olDk2ZUcGnAGRFsuhCe8RpFIQUXRLvFZQZNjHjSMfn8wUd6I74O0+cFygtpmS4X3/PJ3ohOcyFApx8eLF2WwWuWkMZwIFXCoEcKeBWKOFFd4K4suXz6Fuy9lCZBAinxwIKr4nvzF/ddYuGa9YqBOGtC5Y+JGMYUlSkQ3TU1Yp7JJqr4ocMLnbuSzLNjc3x6NROtcJzwHftvVAO52J3pdcVlJNZDZROcwc2rLMs4wJDIQ4xrFzeqNtn3sargNztGMAc0zwQFthCsBErID8lQInLFLYGH+FX2FRiMYEeBXxgbkSVY0HKCSIUwIf4q/DWg+fy1mPkWCucPaAi83BN6KIrCWbg6Y3wF+F0kEqmLNaY43DeK6AZ5b5LFffdZiUBonCJtx6mP+prw6qkNmIFZXUpRXaiZzpXOhCAjeFX5mwMMi09Wx2mEmgrVmmcFBinvfW9Z3tYNEsVVGNIoUlIolCJ0c/cecIxUk8oxnYD/NoDKYem7JVFAiSFlbwGLRlqMvn1scwL9kdMO/tghyUVVUVOX2Y66yJu7c4RElZSGZmF1izqwXL4PsJpnlQ3Oc8HP67n0jnPeHZ4OOPPmqMWXJW+Nn3fcxBXLoCLBlhvJ8t8reW+tQoGIB/UUgQokR8IS8Y3octH73+WMyZUkM618B9j2thaaJeftDAdCUBnljXNeZVEpa0O35t4NxN0+R5Dg8Bl4Vf4c+8795706lPeEa8o7wPM7Gk1NDzcJ5wvu5CZ7bGkzNb22Zazw8O7azlLpRaT8rR+mRSFvm+ObxUXwFCiiJXUrhiRgUj/gpXkMftP1zqOdSMsRipdaSZwZ0/smCM/Z0OPPFXtL+Ba4LCGz4sxGwiPo3FhAz8mkO3Z2EIeDAM6lIoF8gvXSFaqwwOYPay8JG4jxJqyWeT4qKwe838oKvfpZ5Ipz5R2ISbjOIt/+OsMw74XlaqcqSKEZNFx4Tx3DpOKgLhucSgLF3rMphc4gpWSw38FSgm8EpglPAexnoJQ5jOJPFPHERoeLEsSp2QfbIV2yxxdawJJa5qaS8Us7ho/mcUou1DjNFiKIlGMPhiXNEQZnrTOUv7pbg9JCgM60jFL4KbSJtLI1mAV3lnvOm8aVnfcdsKbya56lIGWML1sLe/3xuDMnBidY5UqsDtsiwnC7gY6PRL8rrgkCzmTi3uC8fStRgpumNOVtTbBMaPXnr0z/UQKF0svs3whvG/KCiAR5eaWzZ8Bl4pgr5P33eMgsEEchpiYREpxussqg/ggJLAMAss8vWN9fXUGRKuxduK+8d7+2PPc7gkiqyEXgODMHY1oH6O91Z4nwmRcQ1rIy0UjsDG2b63XW+UDwWjuGiIGxMYoEU2imM/ehRwQVFYWpUhP/U8hljJmCZ6wbJlwi/xV0+zAz2KWw5sQV4ZG8TmcGC9NUPwFzcIBeoWtIL/pKYNEJhcJMf5KrRN37aN7R3ck5cFG5VP+uaScD2jPDAtwyjXayO1tf7tf/SrqTMkCpvw0iG85W90XjucwODKB06aIfVUOVc5rIR73NEXBocPYReRHT/oUw1jFgcNtOgjvhhNCYbn4BATySU9gVhsCCbqnLyDVa1c9cS8ZrKmpbMPQ6ZLvAefaCIfXTyfyDF+Yiy8YSNFXpLjMDyBUlSRtsJ3lxQnwOkZV9ZIZJ1phO2lN6ViG4Xc/4Uklk2I3VIcHh7W83lv+piOFXcFaPN/iHrSQulYKhWaVsL8rZAa1nUdlQYxRStSyaUY1hqzEAMcVflY2ruyFX3tcO3xowl4adHFVinz4oVHH3rM3CDEj4LvN4hg6TuLwfNuKW/gA5ldfG4YMtJ8URanT59WMlVqTED8r9tvDK3NLVtzdgO4HCycqBvhLdA04GJg02EIRHAlhMKpAr1oYJmFu2TWk/XAkXkGdlB/NC1g2hba2ays5yi1ix116ZVFo8BUrbhmjOKBayaXoyhsiKFXTJmIq8g42WB2MrqFGIOOW7Tqw6lNRMEaXi5WhE7zRgUbYBb0fQi9YEaKXnKgs10mv+dicpxNFDbhxYT+uu++Mm3aDpjcJIScfFvhKkXHvYBzL7pHo7ukuapEEIlKadQw0jPlRXAdjBnELhmZ+eEWvVRwj7HWc6ExdiuIy6KGyRKt1A5e3fPgb8BfY7QVHWEl445GFHInoI0efCsZCbE8ClZFj9lAS/FAy/QYeY2zPip3YSTsLJtjrqvEN6Q9JIEjGIxCFvirdL2wHTMzbuqJCifWq/Pv/pHUVe5OzJt2b3/foLsq5o0MyViD7FXFWKajkOxgH7AkpsuN+cE2qx/296lDRjlspLnwJtaalXl7sUZcUEm0liMN67XPYQvNa1hRKSyftupXwFaowUoEGANUS54avzV9Jbn6tnGO90saTc+M2oPxeHzm7Nm2maeucnfiH4xfzQ+avAtjUYy5LqTPueHeDn3RDz2G0VAel0g3eivStvLYr8PKjLA4PrKt8cM9iwshkKPisy0ActUcEyhd2B//rKPj3qJcDb+3VDrDZSmFZjADzXlTFFqQRMEFjKqY6MzFectYo8QMGmJUftf0kdRPEoVNeIHh3vJNV2aNF0qP1rJiM4RR4BhwJRaLeZ/IZRlFT4GG0mblUQ+IUxsNNTDj5YU2OImjzxZlTcWZEPVD+Azr4otilNQPW5wYLkUzLEzYOhp6PL96GKIAEfm0D1FY7of9HunloEHQK0+PFJZoq19Yxq/WTkDxgRNo5oXv49CKEI23ONdIcLnmHigsQwpb866Woa8Un5RyY1w9+i+/P3WbuwVCPfbYJwyKuXFRBx0bWGyWZXCMegHckuRRPoqXUrTK8h51e3JQllJKYWSrDv7T8FoKapL+wB35W9GzrbM0I/NlOYMVvwLUwrLFdv8yRWzpIiClXN6zZLHLrKzohLD02lpSa9LCMvgDl1Hk1Q8dapEQz76OUwIbbGhjyJikFHpzc3NtkrK+7ha88543NBcuy2k79nqnmGxkIw1duDXM4pgpcJQV+B/2q4GzoqyVRYHA01NYdgMKy66isEsW+/wp7DKae53PFRSwFYPE1tEFHa9r9HbEOM9inwSluXBjsN41gndSzAXbd+bAWzMqfrj+ROo2icImvAAwn/3f7nemnGysbZ/IitJx0RrV9ipS2MhiB938oN7ji1wrvhhrjryxBPr2SdS/YnxqsPQbCCtJjqKfgA/+aKjCYCrZ+SFbvnpEW43FomrWBzsEfSOLxRWwJylC5LuLKOyQDabi4AN8gogpHwQGVN8LRRKYTcpV7mUOzzGU6RXdDIB2aCmUCMJb5nsgstx2wnbcGeWN5E7xkAU7/7V/krrQnY2HH3kUpZ85Sj/hAkCrja6Fn0or3EaIpj9HW/mLZRYRvsgOI7WNIVtH+6TwVjxmdMWQZ7xGsEQdlruE9yfN3vGdzpXd/GP88mh1F1bVtUv+unQ8uHrgXrw2slia+qNCgLOVN1+GdIfPveqz6Sea6BkDvLwoCvi97w3wbNTIbmxsbSaZ7B2OHzj7GjHr+KwvrK94NhF5yTUzMFJbbloVDI9hy4XaZpmMG/Olbswmo06AXzfyel0Kywb/GSYWJuKfOmiP7sYUlmYZEf8EF61tYg4GuXp40w8sF/+JTrXCSW656KXINzdm3l1q5pf6Zs69XJ/80O6fpP6TKGzCc8Tal/21PSymF2RWjjY2ytGIdtVt2/EaeBrLQhStLvhrHG2wErUctK3Ly355sQcbmtZSWjPwP5QKKZqnnceIrFKyKgoKR7lYJzaGmahGF3kKoE6AL0KwVw8usYzKwqZAkFgPRQhoPjAsi/GhPCxf6yOFdc4K50Vc9ceHPNkTYAIZQ9sEkcVxyvPl3wKvxRFKcK+4z6jWF5BXjm9lgrfcWuk7ZaZbGTv/3uTDdQfiqfMX6qaJik+qNTCsuICrAUxvKHcqLHb1jznBxY62Ul3gKK6JwRuMs5I6liy3FjFTP5RzR9J7TPMaY5xsJea6fGO2cBUQx30Glrz2ujXAVg0Hlt5eXdcvSijw1fjuqqnBMjB8jASTuUeMKMciR8uKCfDFNjc3iyJ5yt5p+Nv3vKG7sivrrnRhQ5frWVEGKWBo7GwwPhMqF1pLOG6HcX5RT5EtU6xwDPY3prCDOPWqcMa1tJJdQ2SfD4Wlz/U3+lzjHbo+iqhiiyVpcQtGIaSBxadzg1SX+CtmLTMBFBZmqJBnPs+MVjUPu119qZnNvBdlVqxN8u2t7/3P70udKlHYhGcF/4X/k2MqG43zsmI6A4bZNE3XtRiYhKtfVUJPLKykkbnG6xGNnhd0lrmj2Zov+Wskf9yIrvMaiKuSmHwaaSVunlq4waszrTgNXVRjC/f0+ZBWxQ1TvccqWzcaXDoyT4kOr1FHhYFYTCNDEUBcDa8COSjFXHM+7PtEoouy2CjVjUnjDB0U4mOYzRqX0GRYC++paNdIoj6BorneMvTscsx5HfoqdNrOguszxQ/e+09T17ozcDid7u7tWWMH3spZVIUSq2PRRGdI9x9mt+FgsKKMTnDEDt1KHazhTYSIDlyKLLgosAqc1g3PZAH48SqFXSpT4/Umj4sB2JGHQHQV6K+N0S5ZbCxvO/DXRbD2yDAhDK6wfGEPe5TvFY4XTQjxL10YwguRae1XCHu0UYgBXXi0KIqtrS2tUr7XHUFez77RXNktrJswkTsm2nYkVCmzQijJZNykw30svFpMMN3QTcTiWlpcKcw/LbE4TmGXh8+GwsohYvsCUNhrPpfmj+Fv4H5hK8spjwJmOu4X2WYx0xLLimGTOC7q3gYlPRHZTrA62CZ4g2XQpS20Xxt956O/kXpXorAJTxt5/arvvLDXNoblo3WRl1pnuHcfrOlb3zfeWw7TnCxCseYYFRCisQf4qyNvAbhQUVTgrx06hns8FhnQWOJgII1kIIACU6SYHG8W7pFUFUVgweq4CYvjW88zuF1VmWsZi40jhUVJANmhUBSWPnGoVbA6iImVAUwdOcuG6OGFW0VLS85Yn4j+WCpNizlf9P6LuDL9FbHoC3ohOEf5XsjlNXNufiW3NfBX+LtgRJqU6vCX/rfUzW5TTNbWHn300el0Cl2yGo3qugGuSQHOmAW1rNeKHG3JAq87+8asldWcqtUisahXWbhbLfioj+FNXM8d2WixVYeB1SDrMjNslaR6rIpn+XEcxYcpWHsUFl5qXhd+tEhwj6wQjj6Rr07h4Tr/KqWKPHck7XXHStdKzAGlUg7QkmVZnj1z5saVGRJudfzgfW9uL+2qppkEscbFmInSM4VVYT2wOUnBeC4p9kFKrYC7DSb2HR7Y6sZd4Ffdc52L6LqPhuPMkl0jJxALSetzprDXJdfD+0X9T7w0B4348s+BeY0sF6KRLSlzBQZFSKWD8SCqksA5lqjNMHnDSGFD6IKruT/gviulOrH2HR/7zdTTEoVNuGZ6/spvuTI1wF1Zvi7zMVd5CytkY4D8acnLTGW48Y9+UrXHgKhF9zsWY64DeSXrE/TVC9dd/UaJKnDiPJpBO++Ct4LIJbxIY7oz3GcU97hK5rhHzxfFU+CzHM89yxwT144ocaJFzuoHLUH0VIkUloLHGN+KT3TEghcJqiQ28AujoPiWcURdZJIBf+UhZtsgzzaczLmi5xZ+Im6OUsIZp8AtvjlZaaqch/rgUu67qlSS+2a63873SxXOnli//PPvSl3u9sLB4eHe3h7QuGh6OplMZvM57q1HJStlaR1FWVl0VmXsSJ63lMLSvOaOIq9RAciO7+kvIznRPJYMt6TSGn52fbtqGnAVhY3pXMsaCmxVZYtaHXUdCrsAPBppbnwyW6h1qfAsvHO/ykz58ViuP25xsHpMVu86focjKwMZw9aDDhg+VCvVw4Dj/cmTJyfjKnW52wg/dv8XTi9fsfN55cNWVmzqrHBetj2c9UJITtkPg9JEoNtMpLAUA1nm0S7WRYsBPvhn4hY3prDXZbErL3zuFJZe7m/8oeS2RQRWLLIraKeRSpbQHl4MwS4KhsGBiJEYmRcBi3+h2Y2B+U4KD9MGTFiSd5LVOd9j/aHvOy2+P7kWJAqbsMSJr3nrJ8/vNT5Xo01dbfFs4kUG4w/MJpYqXQoeKsW1Fhqjob4P/LCzYRhphtImRE9FFLOvlMvyV62NaXNfUZUsi7sqIaoFvBIYe5I4olmksKR9xXAn2WQFKmoAi3nrFGM32G3EVBfhfDjKhF5stuJrgV1LtRgl416oiINJwMgx/uPYspggH1LBOLwMV8nSs2jXhTmmPFgsdItGXZKzjurf0t8uFakPBBwIdLrOBK9yYduDw70r9XxaZXxrvZoUsMRu+sPL7fSye/+/Tt3v1kfbdY899hh0pDzPi6IAngdUDPir1lnc9Md9f+j/GiHQ1sp2fSeXVlNEbAdj2IUBADpt0bprucW/qmEdwrfLkC4VO1BKZxpN1KPEdpUmDhW8SJw6n8+X1WuX77zkjqPRKD7tKvIaeWTTNPGZ14oQSJJzdYxVrDgSHEsLO+49G9Oy4cnQRMD+8yzDNqSP69rWU8PCkmB/f9+YvqpG62tr8NDJkzup790W+Hb/8nUuxllWKVUxDuRV91Ybpx2mBLDOKNyiU1yQ5SsO62SYqmRU0xxnmJyvlKd5mnQuxtjTVvE4xmLD1a95XhT2aSQOMX3Tx7QKQT54kcX6xXUK84bDnRRMhYaVKc4nUbxGHBcDJjpIrFjZOWvgnkxmeeEr3YzUrq33u+awb2cwe07KH5gl14JEYe962C/9htaEcrKTr213Vs1aX/fMMjWu1o1j0TQAiCSqQXHis8FbJHxZQRZawxa8WORRxcoC6uhqP1qdRvsqC3OZ6YGi5uRUrdCaisT1zAKR7fu6me4DpZQUl0ULLWesNY6sACTLtBhdf/MIKSiKDfzwHdhy/IDfbAhK5yovFwIqES1Z4MByUtti+BjJsR14LU3YPLoSCvTuc2Gw1pYoIbCU7YWK1+AxzxT9wGSUSHkXgwdYuAEG7tA3mWajMpciNPPDrj7grs14n/k2mPl6Idr3/LPUCW9ZZHn+iU98wlBocHC5IrUoUK619fXDw2nf90hbgciikRYW0MDwOxalUuQt4K91JKD0qABcNBpphUFvveKOxWLFD1IMUrAq7r+HZXbjYpF4bTIWAD580LAu3nlVCwt/y6qX1lUJXmj1tQi7xpeE1YyzuDtxFPQdvAnYMq9rlb6usNj4aJbBV4vFOX0sWBZCrIUXKLYtyrKib4j1INbX18fjcdd1KRx7K+MHTr65fuqpNe93qnJSlgpO5bzuDw4YnDidbRRlobMAA74lKQz17ID24QyLimPCA9Na3pA6hGckqc+sOQn8Bne/OBRWUIGuKMEZ9OWxYA9WXgia+v+gBnYolSUiG4v6CFi2IdPPcpVp4PeYu+xw8oUpp8vYnm9r7eD6NJx3zM+cdXk2PnfmbY/8VuqHicLejRh99bdcblxv4WrWOh+pbGQ5BV/RaUpTlWnh41VEpEwJ8rZEyon7QmJwDIk8NajB/3XQsEoqqTIEoVAy4MigCp5gFCrXPckDvMDwKkzPluP+vOm7pqunuRZlrstCVUU+ffdPPf+/tPqyb7SW96iSxX0ZzyJPlUFiGUKPudG5F9q60Hgqpk0ygOHGJbFSMch20QAm9Pwougx/lNQ60znw2XbeGM+qrCyyAppoNq+xkq3kWEhXBg1Dl+u864Svs9BrbkQ/E67ZLtXlX0yZXrccemP29/eBpMaN9aUB1pIvRl4ZaVz08l/ma8WgLPpJuVi0cmGbhasefHmR50pKJH/eU0UftwjbDOUP2EJOEGskS2TGOpZsnc0O4WdVVUDyMq2f55/ZtO10Oq3rGv7MoijYcd4Z+WWMsMq4jzFkqi0UsWFRJTdqyhd0NqoFeKzoiS4NOiys9JYh4egRRs53qFlSSpIxLaavwV9OxiYBvtK5s2d6Ukck3FL4weJ1etbnzE4kK2nAx2AEzCimh4Eden+Oq34ylxpqWVEEAfMbaGaJSVzPwEL5p0pPr+WmVz3tuZLXxWXB2XUl7gtfBbHysF9s6w2WyZj3G7M8/VD5VoSYE41E1tFgQnnDIn5tTLxAest7FRppDVzrCktawgzaODv3rtHSlPl37P1x6o2Jwt5d2Piv3/pEJ2ayRK9JrmCKwY0ergPHeKsPsjfeRtcPkrdKml7ZEBwKYSgxEJ1WvRiSpTDUKhkKRinlkyzxKP0JGbDEoKt0tWn2GLOUthUkD5kUZaaAs+7+6x9+yf78c//Nt9Ut8GVbG9/BdKk0k5ljSGeDzAUGVTEo66PDAeZySRLLovEW/pEkXop2XSg3xH0idDfw6PWHFb1i1im0rUXlAWPUlkDNNUcTWe5aHtpKeu07M9t1zcFEMfPr/2fqlrcIgEk99dRTWOZqIdMErKpLgYQZY5HOsah4pZAkubGTNzH+h2yMD+lW0ShyoSPA6QnZ20KrbYHCLiq7xlkSKSPV4gLammfZaDxeX1uDL/LS/Plr6+t7e3tA32ezWYxARy1EzFpji3SxoZRXTM/iDNZxKx5bLOZsRRKCz40+CQuHrrD4A2PhBEEVGQLG5DTwWHg4KnozEmbAqLO5uVmVZeqZtwh+6PTnhPO74z7s8LxCC+6GRkRa4FPVAM4c/YzZ92whHyX2F7OYnl0M9VMPrz5PhvrsKCz3134b/ky1EoZ460Lre0RhF7YmYvAqWFS4XY4WWJPd98o5DLngfA3P7UNorT0M/tC5meKje8596yd/O/XMRGHvfDz49d/xxKUrF1rm108aFfflBSmQePQWIOomMIWU7rHoyRzjkcKh7x3KWMlJKkQzKYFaVYssjTkVc7McOoHw4ARVs46b6xTA5RnrctZmKuz/4j+6ddpk66v+5rQ2JnCLpl0wkkjUFdDfi9lZQjumooW7hEWwxkqhyDysg0Ekz3NPmS6KybIaM/SQ6fq2l1KP1zac9a2FBkLyoVEMBpzeMN9JZkoRMt5z2/j5QT/fz1x339mTT7z7J1IXvenB1yeeeMLSmV2KB5ZR2CWFtZSeH46sT8VS7Rr33Sl9kEfStlrpKkZtHYrM/dJRdcVDAAnfuXPnbimHKWDYs9n80qVLq0UZMDMsKg2oxn1ZlkhDsfgWEn1ooabBtDMgpdByvTXkjDnQeocRbMeplLykUB26fQUWrWKxSHWH5l/0WhhF0K9gMpk88MAD08PD1EVvLt659fpx7arOjZ1cF1kGw303Ezyur0KMHl5lDCAGSUCslxgT8dmq7PW5Udhw44Dt6jtfxXWfH8UlNetxU1ms3RP4MhB748+lXGfK5RCDpm14Gl8WDYnL3KNwL40muCyAacPix2DEBAOxlvPeo49ky/ic82lwo9OnvuXiB1P/TBT2Tsbal38LcDUnlCnXm2ytkwVVfF5WWB1UPMjgZG6BeXkyeRWKo8ZcmWEHxGYSmSttqmNWqQiGOQNDGfAz4a0MJpNcS3SORS2Q6Q1wOoOS1vK3b/VqVeGL/mrdmj5whbknhchyaC4bNOoLaC9XZRmOIM63nen6XkQ1AoavYS7WGLW1HoUWUmV55bxoPU7aVFyXgnoBy3dBo2XQ4qaudBgrzvp6dukpUx/srFXdr/+L1FFvFlF78skn46Z5ZK4xjymSUL7ickUSNz8kOQ0Uli8sBwYWm1GRWPJzHWpukecFqlTyLDd9vyyjBawty/KyKEajUZ7rW7yVLl660jaNIXOuZboYHGdaz+sa/viqqsqqgr/uYH8f2gGoLVwZwIChQeDqieZcKHBHXR+avpM2A9UUSGHJZwt1BT2GwOFXFM6aPhoawAft7OxsrKeCXjcHb197UO3OT2XVmXws6443tmA8J2kr5t3i/IFZijSHhNVUqsGjg8ykYhlG4ReM9rkyygWFPSppzK8Xjr1urPb5MOfrU9gFXV+yWH6dDyUrBi7ic8Qxshtu9AUx8zMuDOCKY1RKR6KeOFrJOlwRCJihssnaI+fPX+jq0ctOf8/8w6mvJgp7p+HUX/y2Jy8dtNDZy3E1WQ+jzfMwDTEdK+aRGAC3gSgpCUNKWufOM+NgqmaWMpw83UiQb4Ntme/hJbngWvNSCw1c1/Vwvwx2XGg7nzXzqe3m6J/6mz97mzaa+qJvPGxaw/OQV5qy0Tnuh0rPODoycOWFrOsOmInKCiSyxiGXRWQeM9Od4LmJDgw4gsXCuSi0gAbPuM8zAatraRoZ+gwW2W3NuhkQ2vVxeeUX/mHqtC8lprPZdDqN2VpSSuBh8GvUElxrvBrvweQkdJsKgyacLXWwjEgwEleYgYB+jaoKXouFVfsOXqyzDBY8MVMKCNzZM6du00b7yEce5ovgNNHNgOSUAswxTIv0lJi7VORkz4YQrCO16yB+5Uhq4U4WC4/hqiAsf1XoS836vsOLilYFcLCzvZ167EuMb69eUdX2pCxPleMxk93BYT+vpWOw5sqj7zVFV/3CJSscC5QKOhQLFsu5H0jn86GwboXqxcII/GkpLD+ims+RxcaKkUsKy2/MYvnxD6UHicKSr3nkr37549jXGRR6UXBAogIvaXUg0EGd9gaJvwZB+6Awkng569rR1k4r+RPzg8fmhz8yuph6bKKwdw5Gf+5tl6edzCeiWgtcN8bPjGPlyEtFF2PIQrw8h7IB0RNVog0KLLGxKCByM9Ti4Zovl2y9zDhFXk3X2nbmmin3ZqTFOJcq2Ga6uz4q9t/zk3dOA37126wPmEXb295hPFaqIi9GKq9645veGZL2aV1ITK/h6LvgHDzNkzyYMtKjBWIsnRCdV8yozL1p7fxQOLNR6hEwWtebpoYbN4fiAz+buu5LgCzP9/b25oToYBoJ2Ww2s9aupu0fs4qiXfCYj0XaTh93E4e6cJSilOksL9B7o2s76ywm9Um84Ezfb2xsbK6v3Snsv758+fLSuCCyTCohho5jfd9Dy+SxtEHMDAuD5dAyLYzHFK5F6w1q4Ci/xeeFtm3hHaIjGBzD2z7wwAOGKo0lvNj42y9/o3ny8mldbYl8BEy1NazrYOUBKxANpyc4KhLrI5EMQxR2KDoTjlicYMu9cn/EOJ8zhfWUgIDv6tlKUPOIyK5S2Ks+5VoRwnOjsFez2Gso7OrnYgIxeS+uhlr9MQob2ykcj8v6IcxE74YzCPk5xg2dpZpPyIxLVYtwYPoLppkV8h3+46nrJgp72+OV/933PHlpdnFqepFXazu6WjdezJp+2jbFqPJy2AfNhpEmRmFRmW6do7rOGDuxwLaMsWQspAQMW6zMBLNdsD2wWIkp9j3cpG24bSeF2n/PT9+Rjbn9tW/d3zvssHx9xlVpmbJOqGIkZGHJIAXbRmksB8+YNRbbDIcZHcgilGrm4hrADjE6S3aBVnlbiFAqjMgy0wDBkZyNpA31BfO+n0l9+MUdnoR49NFHI/Ei4yckXrGE1TJ3PrKsEK6R3iHX4mERhiXTR04FYvF/jUUEopdq6E0P51tpvbW5de+99xzs7d6RjQkNsLu3V8/nMHpEy9jAjoo9RP4aDWthbIE2AloPwMINFJNexOX4sm5ZVG1wcjGLWgIciOjsjAjlioVCwouBv3PyNfb87mlRnFDFmMmstb3pXNfhUJdlKpMyONc3Ymmpxq6KdA5MkhitWBRnHQje8yj0ShSWPnU1t0owtlQUXEthl2Xkng+F9QKp89Wihfjpnl1LYY8KjmEsA1isCtEElu5bpbAhhqbRam4o9hgDTJwtlbL4bEcUll6DkVjuYSUN15P2LjTct7Ck5H6X2bZU1amdb3k8WW4lCnvbYv3L/+pBA326NKL0ahSyUdAVla2WHu35O7wc0NJ/ILLDdR5EVMeSfRbVpaKsLMrH55o8cLzrfFfbvhVAv1RYL/XWKL/wr955N7Tqy77+W6ezfgbDeM9RmJGPVDFRujCBN70FHpvlRZblxrn5dIaBbVQSK7i/G9LjpCdPGUNWTVqwXIpMY/Ta1zPb1oqHyag8uZ5/8uHfXdPdK+4599F/8cOpM78YaNp2b28PWdTCmT+mcLVtzEMaCkpdn8LyY7K3MMSe+FCqjigs8K22Q+VAnhcnTuyMq7sip17r/IknnjicTvGYVDXQLr0lb11y5iJnMA1Eo6cgLRBbjOWtsIFwnBdDe47HI+C9TdPEUxNXGvCG29vbyangxcP3jh/IDuabTJ8qRqruhHE5J2mH8J0xQL+4EjlWLDAial8HDnd8934heQ1D7JD0JGxBaZ8riz2isMtg5bOjsPG1z5PCsqskCs+CwuJ2HMMyPjilRg15bInYyxea1yHTi/tlCQaUwMbg68pHxYIiWMKSRb9nOBfKK2WlqLmfBtvCackVq4q37v5B6smJwt5+2Plz3/T47txna7LadHqtD1ljWMfzIh/lo/WqkPXBeeZbTpfM4BQSN0KpNhCW0QqUPs+w0ACWEGFYpguFaR4m5lmwve877kwp3eg/3o22pltf9Z0iH105aFons2JkuKybzgSmi6IoSxipYcIV1mZMABvCMgouGDSjzYLEmiyGfJowsO2xWkuOgVkjDawrfCXFKPfd7Ak3v5Axt705vvzzP5W69AuL8xcu1HUtKJUemGvf97PZLEoIovETHERH2BvOZ9EvioKuSxa7LCbrHSxVeJ7lZ0+fvDtbeG//sGvb6HpLTRNT4qhUbqx862LRhiGt7dhKYPGrxJQv6RamZnBnT4BWH4/HMevunnvucdamLv3C4m+pl5XT7pyqTlUT3dlmfz94Ny7L8fpEZHJ/uj9vargECilyXIKEwa6fnF5pRhFL9hhpK22jo46T4orccRgN/fOnsEck0j9bCrvUOTwfCrv6hs+SwjKisGzhRkmyBD/YZw2hWceHR3hsGfLiC8Bfe8WN5OQWhOOO9NHWQdLEzequ11Upi9wp1TrbWFTx2+B75y5Niu9u/yT150Rhb6v465d9w14bsrWTvSybkBuvOq8s054DodJSaiWcYjXDTFJOKnuUmceKVXCBqFjY0lsejBQwlzO0IGDW9U3XNX190Bxc3poUxW/876mpcQX8ed88s7AILsq1DS/krLe9sXlZndw5OZ/OYZJGpwLGO8xQUVxljvzbe9qlhqVziR73wdpeelfwIENwfdc3+zubirvpbO/S/GC3FL763Z9PTf2CoCirD33oQ3AwmYypqlYP3GgymTSEGOSrqmof5mzc477a3GoZkUX5K1HYWEs2pmdFUDBS33fPy1Nrf/zRx3rTy5j3FmsgXFMz7IjCLtS0y19jnSOPFh/o5ABL8Fj5LEZkR1UFK5BLly7v7Gxvbmyk1n5B8K0v/zT72KWX55PTqljvmWj6InDf9VwENJXIFQxjXd8bLFoIh8CVMFmeLPpJh7YQufLlxh5nSwpLpcNZDMRG6exzo7BXpXOxazK6rqKtq7/6F1oLy/2Ss/Jj94fl00I0WWeelrtDrw+rooL4K49VzEJ8bSAKy6F9jeZWkCmXw/C3pLIHpC6QTImNza2D+fywqXsfsjLPihLOTtt2Xd9d0OKptUy/4uXf/+FfS307UdjbAO5zv75hebV9pmOFFYUTWeCZY4qqbWFWPHq7MsNEKzmyq0xmgitrmeuwnKzEeuzMd22WyVwHuGXCSxTENraru25e+Lp/TwoKXo1Lr/0L460TazunmcxnTd/2VhWTBlpVlWVeQAv3XecdVwImABTLYnRKCY3VVlARG/oORqVciBxYEZAg06oCltctLBt8X8u+XsuFuYMy5G4if/3YI490bSsx5Qid81dtX1ddYKMcNmYpWWuXlCvW6ILpISYkYRy3KHWm63kNpAoe3dza3FhbS029iieefCrGYoegNY/V+nCWJjcCOxlPekz96qWQZVVCM87nc2MMltzUmh85Jg2B7pgQFkvUFnl+OJ0Ci52MRqmpnye+62UPisNmW+RbPKsMy1rLOwM3cvRFizM4cTBk4VUAPIpjcioerjBFvlzrHXMAGCpOLcSyfMEJn+P3DDcOo171ni+sr9bTfOOn/1xit3z17pW3Cld9KXrkKFLsJUZrLY/LA4zF8lgOb/gcrnJtreupnC1WIsJ41OApeyjZedZfDEZvb75jN9XxShT2FsYrvvbtj+/OD63sZNnzgheTIAsmMiYUZS9ShVSUtToujK6U9b2xXjjmgtQYaVUUiIXFspPejktdKufMrJ1eqee7ufLrk3xjc/TUz/1Aaurr4vTX/PXdWddaAcsGLPclS5uvz3luOyNcyGEqhtWCZ7R1CmsFYbh3iuqdeduaXnlfCFGhURM8x01NF7QoNZDaELppf7hbSfvAme1Hf+7vpqZ+jtOPkPt7+9E+vG6a4Kla+TL/PZbL8kMxgqi2jIwpVjqIHBd5FRFZuFMpVRQFeg50Hdy/vr6eYoFPA2jNCxcuANGPnrLLiDWWeM7zpmmiQgCOMQeOouMCTZcpFo7mD1iidngJJYUB2dVKHx4eNG2bZ9mZs2czKVI7P2f86In7moNpwdVWNsoD1zbATQFl7S2MaOiQjO7eRgSm81yQvUYIIaSGe5Zk6PmMXU//zoId01QwvhzQehFmzF5op4daZOdO/41LicV+apA7OzupFV4CnP3Kb370/C7LJvn6tlPV3qxV+ShwJK+BOjh5fmAGo4ruWTLaNHJP1WEzrlBhIJjGqlpdKVwugIvNXb3Xz3eFnZ7cqGb/zz+a/X/vT019I8w+/Jvu4Q9uvf4L0KkP7dm7LC9g7nVd612fYZVe5EsmYJ0VqXUgeyEZOPyuYRlBNWk5zdaOcSC1MH/nWmdK4YradDB5eNM/8Ll/9vIf/ofU2p8qzl+6vLu7m2WoVbZoB9dR5SfkRFGaGQvJYmEtEgbYhXt/JLIx0yvGZTVhaSIL91RVdfrUqZQg/wxTOOeT8RjaH9hqdHuIbRg9ZTHUzWEY0tDmwF/hoegaiydlmeYVwrLyZjwpkft6DJzLtgNyLPNMp6Z+Dvjxk/f7pteBl0wq53nvhPUwSGEIRIgMVm00NklBqmQ09ZVUbY75RGJffAr7TAyXpvfBl5rHQivDLgeakCsnuVOiteaLds69d345nYtEYW8tPPB13/bwJy+0IdejDZGvGZ45IFEKJl3tKXsRE3tjwiOHzhwcC4fzuQPmJHWu80JlEhXiXjiD9liuc+00tIe+PchCd2Kt6N/3k93Dv5Pa+dmg/eMP2I/+1uZr37y/v0c0SFSZKmEQQQuh3qCOSTApOjTCxFK2sb72YMlENikOpm2qQe/RmIlEl8CJOYOJhDk3nx9uvuoz6od/NzX1s8f+dLa/vw9EE2bfej7f3d0DhlQUuUe7DRfzhGLyVrQ1jRQ2mvNHaUEsNrtUykbuFSOCW1tbwMxSIz9LaKXW19eXbg+RyMbVAiwMgOBCC8e2pYdwjTEY7i7MH6iGr49FvOCqWltfB8prrIlGXVd297Z2doJ3qamfPb67Ol32tuCyhBnBc9E7ZQMsLBQZmSosf4NexyxWmIu2vjFVK8VhbwEKG/gy7roiusErhVmB9kMW1h86g0ll3nafUW5+oD9IpyNR2FsFO1/5tocfv6iqrfHOWSvKaRdg8VyubUVffUEiHDJe9sCAPJrPoSYWQ67oW4kJjcJZ17e2q2XoRxkfZ2zvwieUa7YqUb/3H9Qf/Y3UyJ8qmj/5gH7898XZ17iuLzIBSwTvsCqCzmGKQB/evmmpOrykur6UpktuTFh/RQgvuNQZniDnjbEwn2up8kxLiXbx9bzefvV/0Tzy+6mdnw0uXdk7IP46Go1guu26DjiQUjLGAuWibGzko8sco0UJLtzjjmW6KgLcP5vN2rYFsgVU7OSJE5oYcMKnBGhJaL2G1MNAQDUJXmHZECUZcGdZlvAcIK5d1y+8yhhbcKZAmkvgt/Baa4xSwH1zWJ948o6t63oyWeMsUatnxttf/aZPuzg9o4pNoUuhlGOi98Bfc65KWFMAWUUZpmcO1hOU5cuGJDtc/vlonMxTM95cCjvYxkat8bIUC41ilvvG9TZ4pXVVYKpXM69fJ0a/E2bpjCQKewvw1697xxNX5nNYZFXrLF/reW6DdgwW0vBTkfnGYBduUR7uyGMODcazojLWc2OVEJMyL7XkpnbNNDQHwsxy3zx4z8kLv/BDqYWfD8Qnf+/ez/iS5nBvf+8yF76scp0j3TEemRNtwy3MEnGKRstYy4VBsz9Rt710QUiVKU3OmhglhJFIKuDAxe6VKyc//U3NI7+XGvkZ1hIdJgnN53VPrvh9Bw0ZxazomUVngcf4a6yJyhYm/LFuaqS24/F4c3MTjoEbAccCUptl2cvOnSvyPLXw88FkMhmNx4eHh550BZyqnUVFRwyHL3Pp+FCOdDA04IP5LiwfJJxhTuXQ+q6DE4klD8pyb29ve3vHuWS29XT47oc+p3vy4rlsNLZuZJmCAae3QGFhxBnBOCNlFmBJHYuQD1vUQmLlDraoXDDUjk24qRSWatqRrn+ojkbCArpQHGeGO6mV7dFSCK6T9WoSevPZ1Yn/aPbSSUkU9mZi7c+//WInelWxbNyy3LAs6JHMJl7ktQlSKE+DjaMNH8ksGSljgWWGvqQ+YE68qIpsnGveN+3Brqv3M9admOju1358/8O/nlr4+WP2J+8Pn/jgide/uYcWdm1joeHR5FKTTBZWGJRTxBmwJQHkVXRweqQE6soM1gHTGKlVfvCrQeoFkwg803nc+D7zujdPP/rB1Mg3wsXLuwcHB+QzgG2O9jRYNI0Er0hYNaakEGeKnFWgwWWIitjInzDhvShg5gbmGjWXk7W1hx56KKfN7oQXYJnH+dbmptI65nLB2iAuJAKV/4iFJ+IGKUWWFvwVt7JJ+kcnyHmU6cBvwGkZBdqBy85ms9NnTqc6tE+Dz5yyDS/uHa3peVMFNK8B8pp7nnOpA2YBcwsDjRfRjoAqA+PGHlY6pVC4oHsShb3pFJak4khifbSiiysMPDkeNYJcl0XobT9vuPEn1jayIPu2+/zRmfeZpItNFPZm4bO/9rLVJt/U+YTpygVlgxa6YqrwXPWOyhMM5fcCbVd7SyoCT92cWacZKyXLmQvNtN2/4OuD7Uref2bjwruT58ALjO7h37nvTV9cz2Z9V6OekvzdORoT4H4c+kVIBSfMUAmWOENrmkU8uhPgXehnoHMUyKIzoK9wT5zP6/nOp31m/bGki70OLly+AqwIhvOodpUkLOYUao0i10hYgd1GCUGMuYaFQUG0Mo0CTaBE8/kcjk+dPr2+tta1bWreFxZ5np84eXJpAYHnC7o6KWEHK6FFNtdizh7MY9HmHZceUmdaonAZLSM8STbhrO3t7m5tbwXvUwtfi/9Fnp44diYfb3CR9baCn1zCTWM5QSohaLH9YX4gITj58NNaAotFBRQyU2EczpOS4GZT2OH6WJa2I2+t4QHBcSMPphvjYeZQTIx0gbXNHawR3VtO3vcr8/Pp1CQK+1Lj7Ff+z09Ne752qs/WHcu8yFQ2crLwXnYWxheYdwscfVDPTUZZGMLD8loOZflOslAKOZZCe9PND+or5+187/RG5X71xw4+nLLdXxQc/tEH+Md/f/31nwODf3De9oYLOZR0wU1TzYSweKKCo9SWXCiPCw1kWBLmFZXBUAQPOCrKmJcVPMcY9Hg/9brPnadY7HE88dSFup6PRmMYya110acpkJlAVZZZlsV0ImtN9Gxaeu/DqVgWghpcaQhVVd13772KaG7CiwE4Hfe94hV7e3uHh4d4mqoKt0FxpmUL8hp/LOJOHLPj4Wpo6mY0Gk3WJhR5ncIjeEyAM7y/vw9PT2YRV+Gt3cZOkPeMtzZ5Fqb1RCoN/Maj+Cwjm5RgbEAVfoBWFlJ4WkxgzJzsGS0lmTKJHr8iJAp7sylsWFRu4IvSdstHYH2Y6b7rlOeTvBjpvJvVrjO50qOyhIc/u9z6tTbFYhOFfQkx/tJv/NjjF88++Omh2jro2LTuXJCjyaZSxbzuZvM6ODaqRk3fY8gV7cSDxKJ1aKwhsY6sB6qbuT4zXWimrJlmrJt88Kfdx38rte2LPk9/5IMnX/95u1d25/OaElAwEMiwiqawAn3CMWmC84IL2/Uwa2DCl0RntNZYPKEu6CwfjccNmmuKPM9gFt/b39t+6LPajydd7JK/ngdmv7Gx0bRNPa/hEtBZFlOFPAlduxZVAVgXk8J1cfM62jzF/C0sajpwXGuMgUkB+GvKvH6xMZtOi6K4fPmy9z66ZZHOdYiOX8UG+CL3DlYmUkk4T23bwgvLspxMJmjORdurcA+cd6DFG+vrqYUj/vtLYieoh06e28xyNm/tbFZx6ZrO0AWCm3c0DgnBNLRjNuR0MUnyDYmlbjz6h+NqTwkqQJ7a9GZS2OCXBT8CH0isIGkBZm6zXOuDS1fgFK5V4zzLL5+/6Gw/mYzXqhEMbxcvXfrirZe/r7uSTlCisC8Fzv7Ftz+1O2XVhp5sTY3seaZVpmUG829nvYRhBuZjrT3QWJisMXnLopGW4plCB/3edjAErWUy7+t+76Kv97dGOrz/H6eGfcnQ/PFv5Y//4fjTPhsZFQmVWm+DhIkag7Mw/pQKSxPlmKqCYk0hZIjZXjBbwDHj3ru6aTSe+MwFNz2cTWez+970Z6Z/khYhbO9wOq/rUVUZTH9zGqbgLDM9ENE+KjRitBWoakb2rtCwfQ+rBcdJVxALdEVuFAWyp06dOnP6dGrYlwzbgJ2d3d1dOB2wFM+LfF7PNdY2RStlOD9ZnlEt+miGCUQWLp2AGmdchGD6HYmb0VQLLiFgtHVdb21t7Zw40SddLGPvzO47JbKXTTZK4/28E8aUSkmPujJFogxOpg/DxUK2r2hFQPE8JxgdU9oQljvFp6Yo7M2msHzBW/nKZ9HvOK3wYK1mUuMMg9VBqlExKku4Urq2btpWcQ6X1pecuu+Xp0+lc5Qo7IvMX7/qbY9fnrMc6xcc9Nwy7YXiQlou46DiGRlQ0+DCBcuAAkksX62CASJrg1XBcu7KYPzepXXenzuxduWX/mFq2JswnH38P51585dO57PWGViFeE7ml3jmHG+79WoE84IdErA5hj+U8ngumXG+NVYr2VvbdB28VTUeweze9t29b/6v9j90VyfhNV2/t7cHzD7L8xhAjSb4ljLTibIq8swavEUdZr6zWGELqE9UFPBIar0H7vvggw9KkQo+vdSAc4NmBaNR27Y9lj3bwLNJzq9wbnGdgedv0OAQ0wpUVM0variQjyzN6nA3vAm8IXDitcnkbm7Vd73hLV80V6OD9pSqTmRlbpyANR6smaXicByupkFsYdMUFvyVJpljd8K1gavqRGJvJoVlV5WuPaK2JPNAfUiIjh6oVEOdOZAD7zzZNZZZLrAYnv3S0/e/5/DJdJoShX2xcPIrvvnJ/caqESvXnCxriyWeAu6yYQ0uLFxNCy8H/RS6KQtlmXFnvG0l6wU3wdYF67V00nV2enndt688tfGx/+tHUsPeNL71ofefefNb+ra23nhjtOCFlMpZ13VlkXvrHO7oeaosT4lIxLywPjCsqrXqrAEKppUaTcbwOpjq523/ss//84d/8N67sz3rttvd24vZ6o5cBdDGksKqHi0IJBBYTOoSmJsSdQJYM0LKWGoLEBUFhrC9vX3q5ElnkyvTTQOsKLZ2toF6jsbj+XwOjGlRdcKgumbYOxUL0huGXGxUbKINF9nvs+jPtaxbcTeLYr+g1cVhs+3lli4q4DbWBIcV0TT6T1t+nLlGUhTicWzhJU1aYaxEYXkisDebwt74IqJQLCepAdWDHEpS0K+waGdFpmGUc8Gb3v7pk/e+d5qyuxKFfXHwCXV2fOJlarzdOHnQ+qxaI8HLUFPOL9ZhAvNEg+BhXBXT+aFvDwW3pWa+OxSsKzgQoJpP9/h/+OeXPvyB1Ko3mcX+4fvVw79j7nttsH0Oq2PO8hByIdp5DbzVYr4X1ecKzNEWN6d5BDOvg9PoGZtptHMPPRBfxnvGp0239YY3t//5rjuzxoXzF86TMEC0DSJmtcNDmNfIIq1BeSTtNaPGBv7LqAE7Ajw51oUC/rq1tbW9tZX6500HTK7rGxuXL18GDoqeA1LCaZMkr+GxQFQYDIRi3dlIYRcR2IHZxuS8nALzs/n87iyl9t3VfdVBs+nkCZlNhJLGuZY873EVF3PY2dFtkTUXFseeHT3EV1gszEAiUdhbnMJiZXOOIikRndHi6fMC7uAMRklvsD4znOPpfP6nRtu/2Se/2ERhX2jsvf6ryo3TO+de0fFib97Xlu/snO6tWWY5iIHF4kiOJbiC9bYVtpGsy7nJeJ+F1jf7rJ+OVZC/8k9Sk946yB/5veo1n8Wd7es6E/zE+tqly5dVXgadUyApOGt608JPtC7IdFUUddeOiryqShfC3sFBZ1xWlllRtdZfunC+euIP7qoGPJzNr1y5XFUV0JS+75u6hoaC4+i8JDBQhwVJHcpcnackd4F5cmJUVfAzGmbBy6P5wIkTJzY3NlK3vFUQwtp4DGuOHmUzfHNzczKe7O/voc2cFNa6BedajIWxzh1ZHFjnBHlKQGcYjUZwlmezGbv7YrHfsfbApDZbTG3xfJ2j47HtO9t0cEXA5aEoYW5JsI7I6yqXXVR9WvLXeJMhUdhbmsKiKBZV/ljZCFd4YhFJD7FkMHPGwp0ZlWsBfjudzr707IPvm6VYbKKwLxz6z/1L66fuOXXvqx67dLg7MzqfVBsnYSK2ztDyeDGeoIqABLHMy9BfufLUiY3R1lou3LyfXSlF7+f7pbDhlxJ/vfXw0f9U3f86b3rfNQd7uy+75+UWK1OooW6gx7JqJD0LWqJ/gVIyeNd2rTEG98fzgjPZeRinVJlre+p+/ck/vEtabmNr67HHPqmU6o2Zz+bW2iLPq9GIocCrx5xcSSM4aQo8WYbyRUgW73QeRu/t7e2Yun7u3LkR2jkl3FqoyqJummqEp6ZtW60zA+u6vmdHBU4HV0w+lJGihT0hVqyNiXpwMJ1OY8WKu6Tp/t79n2Ofugz8dd2J0ofMBWD3LHoeZ5jUiFU86Lo4WjXwq4kXMiGKdxNnHW58wV8Thb1lKSwSVaxmxL0ksbOIisOARTopHwBlOTrjCmvrUPEc2Uzrrzj70HumT6RTlijsC9Hvv+QvtyHL10/VVl7ab3g2yUebTBZN02J2Dx+CEJ64jmB+cbO5Yjr0ws6Eq7N+xtvDE2Pd/vLPpia9NWE/9nvbr/2sw4M9Z/usqmyQPdcieB68xOpdUiiZcW4oJquE6ND40jjOMRsJZnQfeg/kTOe5FtyPH3yjffiuMIu9cPEiOlRKVdc10Bog9EVeBEriiblZfulsT2m6OEpThhbGY7EEGsoJYq76q171Kpacs25VTMbjed3M63lTN1mmPdlH0M7oYlt7wREif0WV86KGRSSyURcLD8W1yt1QuOtdr/0S99SlSe82vBpZmBEYNByOJ7FoL+mFFyLi6/DXJfeKMRIxZAjFammY7Z746y1OYYG/Wi48LUAoWQ+90gTFZGN2F9ylc20sBkScDUVW+MbYefN15173f08fS2ctUdjnhbUv/ytzy2W10Vhxea9R5Vo5OcFEXreYykNjSaSwPG7mxI6JCyzhT26Op3sX5oeXi9Bvj7OJdrv//mdSk97KaD/6uyff+HlwEg/mjVcFzDg2oH6JSa4UKgBhfjEOE+2HZBaYpKWMG0I4GgnhYREd/CiXh1curz/0WeaRO7xwV9O2e/sH0WQAGEospgVTM/BX4CtlUcJVYbCKBKd6pPivpGAD2ss4u1rX4JWvfGVT16kT3sqoygJYLM7D6EWKumZ03B8qRPElkaWDEAWxcGZjYYslhS3LEkWxs9n999+PWWJ3NL6gKSat35ZFFVgemIphVInXQyAfh4DF6TwT/GmoFvEcit4xJhbHpIK9edQsUdhnBwcUVgjHowAEyav0ASMjWBTSY90jWJdksnOu7S0MiFpnCjqIDaHufpGlkgcs+dE8L+zVvR6vy3y0V3e1Y6PNnbwYwVKp7RzuMi+Wx54vA7H4L3RPyVyRQXft/HxfmPmpzdHlX/ynqT1vfez+u58+d2bbmsYYIGF9sL13hjvLvMXaatxrwXIpjLfAvHBu1rozrobRByYUmUGvmJnQwhNVNa/tfX/hW+/gtqqbhhJ9TNM0uLmsFOZjBdQ+RuIipQhs6bLEj4J0fCjtTub3OA8Dm0n89bbA2VMnd7Z30GLL2dXwIR8qdi3yuCjKblBr0MesvsVZx44RRbEf+chH7uy2+juT1/D9+diGTZVVXOZcwEKYK2QtLlCVD5hG4EYFHK/PuoY43ZDILo5uQdJNpE2LWxueCyd5r/BnZAghKkJQbYhlj+BcWuekEnmugDLwptuQ+nQ2Wmv9O9fekBowRWGfO5581Z+pts/ycruxyony1Jn7lCxns7Y1doxbpTbax3iylcH9ZlxYWc6MDr1mnZ1emagwUW5dhyf/7btSe94uOPzQbxaPfyi77w3OwSThYuVTykbCbC6u87womVBBKUwoJYNMhzuqTnnsBcq76f7e+mRSZGXTduaRO7PewcVLV4C/orYrsK7vncMAW6wZC3dubGyMx5O2bfquE2iqKwchLHm2i2iSSLXrgN+cPHkyBZJuI2gl0ZO9baNP1hFzXaxShsQjWp848vdFXzXGlFRZnhVlCUsekhagFqcqyzuyld4+up9f3Bsbt+HlWCplnfQxRytEfg9XA+1aZDJTOIAsV3hs4TwQVu5ZGhIc/RM9YnmqzfUscZOEBHiOBLpvYvVHHC4xxoUWLYxLz4Sx8Dsvi6ooRzKIvq7X8tFaXkjjLrbTz/20N/z6lU8kCpvwqfe8L/wGpzfl+ISTa0yMRDaxXnW9iyXjFPOwnu57I/JSZtoE07u+yoXzNZpn+WZnpA6eerRw9QOnt55690+k9rz9xruPf5CfflWeqQpm4KyQuvQ864MyTFmpDZcWltfohYMVg2H1nAMbYyELXmMek9O60Erj8vrca/1jd6Cc4Pz5S1U1pgJaajweZ1RCFq6OPMvLqoThuetazOJCc102Ho3ruoaHihKrGGBkTkjrbJ5lr3/965P5622HyXhcFEU9n2utsbIaeQOh2AaWMdaurU2oQJcn2bMA/kqFuzBmCwfAX4GxwSMKNSdiXjd3XgLf27dewS/t3ru2/rLJemHdwaWLWL+Aynz4hUEoX9QlcFjU+jr1e6+mX/yotAHxVx75a4rD3uK8Gc478FXpPLHYqLhBTosBWFRES3qQhd5CV8jhwvDB2154Z1W4vH/ly177xl+9ePey2ERhnwvOfs237zUylBsh23BiZFkRWGbR7BVtXyWMG8GhT5DQDhZXIigtOTfzfppLUxW8EH2zd37EzH07k0f/1Y+l9rxN8co3fbFpWtMZJTPrRRdUEJlRQGS5iZMIzD0MxhkvMQTrMu9g3JGBZ1nJucbCCCw0fbf20GeaR+6o1K4ru9M8L5u2ESQSpiqjgkoVhJilAsfGWErj4VEHWRQ5lm/CoRpnb+cs8NrPedObLl26mHra7YhM6/X19StXsLZ7TjUpPMbgLdUT7mO4fVBvRrXBEC0cku+xyAXjvcEr6b77XnGHyUjewop1y3ZkPg5M9VZYmysl2JKZkioytg+KigPjnxoRXeWyCbc4hQWuKinytch5BP66uNEyBhYzuJnr8ZmKAbf1NI94K3xjOjjPv9LcvaLYpIV9LrhweU+NRkxmqKvGjK1gY0FMOCZTb8rgCUUBg3U7nx1a31ejooS7nZG2E7YLXXPfuTOf/Lf/ODXm7YtH/82Pnju15brplYtPMNcVEtbQXeibSvEC1jDeYkVNT2EV/BeGIJSowUUns9wLhUYqQuu83N2f3knN0nX+YH9/ULMyjKt1fYcht8EN1Pd937btUF2WqirGYG00Do3PAS77uk//9Mcf/2TqZrdxgESI7e1tRhawwFxjWh7JBlw4Mtu6IdBmCy3Yio898sid1Czfd+9rKqk2RmPJfN/1QDjRjEzEiGlY7P6HND8nPMP1xXmlMzur/+65u1cUmy6RTxnjt3xjC6wEZlwuHCYNonbJxuozKH5dpm0x660LxrvOmU7zUOUKKGw3P3RdvbU2evzn/n5qzNsdD/8f71yv9OzKeRmAwnrletfN4URLVDPhrpBmXDFYQqNbLApMGDBX1dsgpOJCB6FUUal8pD//L98ho6rMnzr/FPDReT3TOoNlXd91wFYxqzomNWISD2bxWKox68kCMyahS9xrVvFp586du3w5xV9ve2yi6HkcZQNFUYxGIzioqgqrDT2tP5onNaiQEoju/t7edN7cGQ3yjgdfV+8e5EJNcljzwjoXF3KZxrJzsVoszSc+sBRDTXjmJeI4y4W10wuX/t6Dn5MobMIz4+R/+Y1dEHq83jvG8gLTCZnokbZy/BlQQOCGfZywd+VSVaiTOxulYnuXn3Km1txkwq3n0v7CT6XGvDMw++Wf3FkrRD9n3VT7thROh14x1LyiiIkLxWTGNRMZ3IIs4OesM0wXQufGc8/V1qkzrefV5/+lO4HTf+xjMB9vbm066wVWnRnMQYGqBjpYBSVdI00ZA7NxLqf6sUB3tre3q6pIXevOwOlTp2CJcnBwoLU+ffp00zTr6+tw/PRb47DMcR5jt/W8VkpfvnKZS327N8UPvO6zuov7sulzx7LAFQkeOboPeLJaxLnDcSyH4yOjZezo34SE44D+U0o15jK3fvb4U4nCJjwzLh3Oexh5hHYyq8Zrlgsby7vjjVusG0uW3pwJyatKaRUkM3CrpBd97ev9MSya3v2TqSXvJBS/9y9L2ddXnuB2fnKcdQdXpO3y4ArvpWeWcXTUCooxTcOOLooxE8pxaYOY9r4PgqlqvzW3ezvs7U+RlAYvhTpz5kzbtpzzDAvJisDQGsbhlREze6A1MO0aqxvAC/f21tbXe2Oaut7c3NhYn6ROdSfh3NmzwFnhLF+4cOGee+6Bn1I+Q/2tsLDrr+sa69sJ+clP3vaqkv7CbmXDutCqc6HuciZLVcDc0Zme1EbIYrHyDVYXDYm8Jjw9OKz/+35T56eLatTa7x3dfxc2Qkrn+hQwe82XZesnRLVuVMWLSedFa0OPNVAEpRBGKQHqshm5+41GedPOmnpf8m6Us/7wUuab/P9N9bfuQNiP/fb41W9uuy7AqUdnfo+GQYGyVtCjGtNL0bI6SPhNV1WLO+lGKsmCa+sZ5yzTcu3BN3SP/P5t2gK7u4d9byhlB7iqK8uqrueSTNoxsxEWeGgUCuxWUqY5j8pXRfBUbBZetb6xsbW5nrrTnYfNrS0yCbaUyWdieN7fWBFL/QSuJCwyjOUtlCRzOlYW+W3aAn9z476q6ddlNmJK91Z3rpIqh9EC0xktl9LT5IEm4iJaYZHBXGSxPHHZ/5+9N4GSdbvKw84+0///VdXDnd78hCYEiAgtgYwtMDhAQECMZcWsBCewAFtMK7CcGJwFiXGWjYdAEFhESGKQl1kkyys2CpPAEnIwhsQDgeXYCcGQsNDwBt67797bQ1X9w5my9z5/Vfe9796+T+9197t9++xXt151dXV3DWf49j7f/r4Sz9t0IPbBYSrYaGsitH3/ltkDvz7cOFdvQqnCvtBYvuErWzB6dkFWs6hsAL3EDXvsPyEurF8lzRFyRu3bdh9CV+vQCDfsXhXd/qc+9mB5J+/XGD7yI9tV9HvP1TCY2OswqOhVDKTzl7W1kvSCmCcJ1HxwvRegra5nXVTCNmZ2YUh28oX/2Rl9+Ts7OyTyyooDXd/t7NzApRWxB7Ngx6rB6CELh3wMOFgCP21szC5d3C4D6b4MRKyvfe1rlVL7+/uYtLBC8FFaaSy3JakptqrxodS4rfRisXDhrII5M++nXmxEuZGg8UK7KD2bjQNZ0qUVfh2rr+zMdIhQUCBsidugNxOTDWEa4wXQ21GGZ66dtzehVGFfUFx5+3/x3O5yduURNd0eZNUl3QXhpHFCsSYGrTBqbOciBiSzYd3uztVZDZsTLf1yfu3pxy5Pb/zDIkFwP0f4g99Ur3hD9rqWgs2uqYuLGrkk9Y+qCHgtyQfBuygS7uWV1RK4GKkghtgu5o+96fP3f/+3z9YLf+7abjYI1WTBRe5K+/N9hLCIX8nDjH1iueTG5u98m+RC2QKeqnEh1E195fKlMoTuaxibbFVhqmOt5RKsWOlq3SbWlgg4opx3uVobU1wulpsbszP30r8LHn1I6QsgST7aicoJG4WOowAsYthApqJc/KACLL1wFrrPJrGpmMSWuC2GJYpNjNoLS05KgGvwW+pL/yztnSscX+Lu8YdPXXv41Z/24OOvXgaY92ExhL1lP53OrKYOA9qPUwgpkKMBMfI9JIcXI70GJ/r92O09dHHW/sL7yzt538fjD2wurj5hfFsJp5PXKRhImiotdKJOcFXKdujBWql0N3gn5OzCZWmaNkinajO99P/8wRNn7lVfv34txGzFBFVdbW5sKKn39nd9cMBNXRnFSgb3acQzKft1IfZVWm9sbJbBc99Hg2lN0+AnjsDUGC1GFf8s5y5yrTEX6D3LVpB+hXckENsPy2UbfMBU75mrZ0wF8wce+xPp+t7larKBkGOIxsUKpwlIMfjQu+Qjvigx1lrT6Gww1l/zdCkl2BK3CSPlRt3IIaRlJ/t+KsQjsy3bub/+8DnS2CpV2LtH/bbvhnpjSHq/D33UgbrLjTb14BMdkSIuARpM1EgaHF5SdCqFSqcHtpv9nT/ae+6pyzMbfqlIEJyL2P/df9ldfHxztpGE9B5xHW7Jqm6mvQvtMHghZtOm94NRylhS/e/7ruvaCGBIT0pEH4xW26/7nP4Pz4xl142dfdxkK1tpoxFz9H0/9K6qyLVMArFhEcXiq6zrOpJXImRxpbZts4RWXVWvfc1rZGH7nY/Y2tzc3dvDAaCk6vo+eI+LKaY9CFyd9wjhqqoiiW0pcegkLtLj6OKGWVJ/zx7F21tniTD9ebvysenmzMfKeROTCcJE0qg3fCYhuA84rL21ZCRRey4vKVazF8WkoMTtQtKuoeY7O27ZWZBVM8GltgshVvafdFfPy5tQxsHdQYmXg7BdwuTZRtJFskJbwIvUavRzjyI6Hb1MCFGCIUPRZCF0ix2b+ke3p/6DRYLgPG3Sv/OPrXAqdBtWTa1qF3vz3etaw6SpEajNlwuyPBhp00SQHZIksVgwDqpBVdBs4WA7Ky/W2mZvb3elkpWYFBBYu16w3XdggoGrmwahrVK0Z7ftcm93d3t7m9p0lHrk0Uf7vi3D5vzEW97yFrIRdjQqiEGjFaZxw+Awi6vrhnoieXu+uQQ5Ug7yQFt23Vl5sT/w8OdsJTULwvpoQjQ+2Zg0YVOyc8x+H4clcpk0ENcqsSzPWIZMidsELriubTEXaqgvUJlIA2wShVn23//KP14gbAmK7bf/1S6oAfGrMJ6E/AxIvGgtFRsCCpMPfaLXBF5TnfGrTCoNw+7VTSte+ymlhevcxeIjPz4Br0JvxdDo1GMyI2NTgUwOwqCz/iMLpRKKJXVh5QjF2qhqWW94WV/50//lmXilTzz5BGLUsEKuRHEkIJvWXyqtq6rCG1ubmzUV2Ciqus4PeODKFdbBLHGO4qknn7x8+TIOGQRwzWSC18H7rDwg2Y6Yx8hRv+Hac9dAnoHN6wc//QvEzmJb2SokQ4okxIsnv1hu+oUjDcpgvE5jh3CJErdEjH5wVqtqUoFVIYbofSWE7Xx67rzQYQuEvUtcW/Q+VYhfEbxGUqcnaU8llGcKrGQrA0ss2KBkqpUwKhlCJz0MSzEsH9qsf//H/1Z5G89hbNbStzvkN2tFUykIHabMWkZrQEHEkcO1WEHe12ACtXbQAaOTdTJTp+pnd89AYXKxbOf7+yQBRIJHbKiUxQXSCsKmqJWqLAkhIWzN/Vtam8pa5wa8s65tGSrnMBCzbm1t+xAwq8FhQ9RYTQ7D3vvpdAoCVicVt72Ivu+ffPLJe/9lLp94xrb9Jqg6JBVxu8UtA+d+yuBV3hmYAp9iYJYLYytXwbAlnh9UxTeWmoFxSIXghXdWQBNTtey//4E3nYe3oHBhj3x3/tQ3tzDxegOkkQhepaYGc1KkxyWGak24JCncpFNAUNIosJDwNoGVoUvd/lYtdn7+veVtPJ+x/3u/KR95fRIqJrjy8MP7y2XbL01lqtok6lChZibemBL3euG4goBjKyWlVXCubxcbr3lT+Ng9zYh99tmr+AoUg4+sjMV1IzgoIa2wSFPXOzs7MQRjDHEJum4ymU4mk7Mr81niJUZd2b39faXUcrGcTid4o2dt4MtXrrTtEtOfW5TXbkJ4knSFm6bBBOmefYF/86E36RvzC0lvgdIxKtwaIJFAdG5g4761mF2XZXY0yKiEH5N1TEYuLJBYARQ+bImbAieBNuTAHIRwIrooaISxirIG7VL4wkuv+NX5fe7aVaqwR4adCjMRskrKJjC4qoS8JcdA3u7eqxgh+Jh8TZpJUUYnXOuW82FvN3bz/sOlhetcR/jnP93Orxvww/LGpJJGxa7bVTIo4XXykDyXZGhHzg5eXuggTOthSEbbWRvUpS/9lnv21X3iiSeGYeBdN8Fa+pV6t+TBGS++SOfatotcYMt2snjBH0T8cWG7qBCc63jkkUeu37jhvcMhgfMA8Suhuqy2RqV9cYdLYpp1fO65e1qaoH/q2iWoNpQWvWsQVMBKcOB5WJRKrXHs2pJxTAHpRlqJapUocbtUDmeK827phx4HkFUKLwA2pk0ht7yEa/c/naBA2DvG/ud8DUw2lGmAyANsDZoUsOQ0KfaN9TPcmZ0OXisEIIPvFqFfpr5T0V3enJb3sMSDl7eW+zduXH1mYsXm1CS/bBc7MTncrzMLhZQsIFcrqfLiMHsOmAxZNdtS1fT63vLe3aH7nlCp91lnIGV9JOAOR+qoZtkskrwk8kDfdxcvXsyCSh1rEUwndRke5zwUmdJZY2zXdhjGmM3NzevXr2OWkyW37hQ4fjBPwh/52Mc/fm++tO/Rr7HdsAWmCQCDs0qT0RbEtMKkTHFdIZGRICtz81bmGMDIN8hcgoJiS9waODIGXE6dG2LwBF2NrCxuJjrEekhNH6rlUCDsOY3Hvvq7ojR0jDNK00tSoSYT60S9W+z+Z0AYHC8xQAiVlMn3vlsmNxgNFzZn+//4fyhvY4ndD72n6/YrA8tunqKbNHax2EXwyr1cfM12kk7ki4ygg1CSyKKNsk2S96g0wY2dnbpuRvl5mQHrga+9WHWOC96u8QFN3VDJlndl/JGtreIiW4LiVZ/y+Pb2Vgg+hsjqBLrrexJRlkcxBDAv0lTXhO5elSYYdva3TUPsbx8hkHcsl2AhjrXY26i9rjCrWHV6pYJcSxwRxB13dHIRlHCK5OgD89N0lJVPNohJkD88e0OBsOcxnrx6bePildZHRwBD8RvFDPvIC03KntVABSaEsCkY8oB3oe+kiLOm6j/8zvIelshx4f/8RwriYn9nGJZWCy0C0d4YvwrywhiDsqUkJV4po6paKAumqieb08/7unvwRe3t7c2mU6WUYWOxxAovdDm0vKZ8asrUArzVti2iWLyB+PXihQJhS4xx6dJl8lhV5Cnbd701hsfPUe1cwQdBgm7UC3j9xj1nCv+9G29ognhk60ITaV9QAEQ8E1yFxVemVnJZt/vZDF7lapdhXFuAbInbB+4iUhlhDOLXZew7tpKxWtegpkJd0PXimef++uNvLhD2fMXGV/znez1MLzzUOrL2BukleCFI85U0qPM5DwlsqYgJD2jPx6bUPeq7iRwe3jTlPSxxONT/+m7o5zB0vus3JjO58tVk0EcdyiqltVKs1japisRiZaWm23vunns5i2W7ZrVqYxS11MS0Dioy4VYd8IKvTmlEJnD92jVEugOpEKRCgS1xU0TfNDV1Vce0WCym01kiX+JwBBeW7DMGp7Wxtlou7zmyTf/UM1dsdbmZmOQhOtBhcJ0gEgEdW7DMACnJRdKTywcTtBPLmLKXgcwIl0u2Tkrq0SkOsyVut7FIqIxtKmmVl6kLsRvIA9JKgbC2klvTSva9e/rZAmHPV1xvldp4oA2IJOpIbiktpE7CIGSgzVpKp3DAmAHsIshoGyHNYrm0RlnhNnX86P/8t8t7WOKWuDjVlUzbVZMGH51H3FdpjeA19B0EX2vVWGPJjwi0bXb3lrvzvhc26EkrbPzcr72nXsszzz5bVfV8sSCHWLIA9QKRtyFhJCCpDkSuQbLtB95g6VvK8LhFRzz66CNlMJS4JV75Ka+MIbZta40JwQ/9ELm1604XDM9x5coDiGV3du6htpUffODNj9j64apZPvNHcbmwWggdlsMcJ4NKSkbFFRCJsyKQ1ACdyCSuySqSL8HHgqKzPvwPwStuNHgtiztXidviN9wtUjQqmGmsZ7KZqApi6EI3h2UXWh+6h7Zms6X/kYfu20JsgbC3xuSrvmcBFdRbUdZK1yzs4hKwDixkIU/uFqUSrBpClMpqa3EXX+zvTSp57Vd+vLyHJZ4f7kPvk0PnMdUBpbQmTnUIuJtZo/EiEfjhhhwDJkg40JSpwTZ9hP0BF6ftVM1e8TX/zT3yQuZthygC4arIx7pE6mU/g7FGJkaDIaK8prELO40CSVeuXJFFG6jE86Jdzl/xildgEqSUwnmBQJaorneEsDyFtMHRxiVYaO8lRqzcXc58miZqDDeQjBbGYIInSYExSEgj2TWO+HVkCWTxgXw5/JjAYLdUYUs8P5hpQr06MimdpCFQkph1HT3ECC4Fd3Ey3cbB88z1AmHPS+ztzSWoytQkPAB88iOyYfVhLxU6CGLY4SotrIY0LLvF7oWiQlDizlHL5Jb7UjitpE/RsyORxa3YIKKNvRtwOEkQQ/BGSaN0iKHt+slsZprpczd275UJsrurFK0b5CKbvQwOkQhW0rB5ugBLI0WyuefHP/roo2UYlLhDQSnNNja8c5nnmtv+7nTJGRGOqMViYS0VbuO9YfH2A49/fnQDkWfUKI1MvRSgDKkvlN22xInE2ibjUC+gEJ4MZjYn09pU/XL5/VfuT6eDMqluiktv+64hRK2soH5YSYtpFLc7xcIRk1Gs1yBUCsPQQhiufvDd5T0scae4vL2hhY+uZzZcCrjrxhi48YmsAiPuw17gHZGNWblh0IWgq9o2zc7injDrurG3Pzintfbe4Y3RiSuNnlwr0c4V+hjl28f78Kf29/bKMChxp8AMxyGEjZzdHYlJKS1i+7dhGIwmk++n/+iP7oWX0O7s4NZgtQIqsgaaHJ5o4TC2A5cocazBTY8QD+lbxLHpnJbdEBXIxlqVYLFzf669BcLeFHuL1tZT0Nb5mEB3Q3AJAotqhbEWu9aajjYFC1HFIQ0LcO3mrOhcljgqnviHP3Bpo3LL3eQ7HD9cykTcOnjfR/IopkEVAxVi+74NrPculfaksVUPQQ6f9w0v+0uYz+eaT3s7FoVlv1gR47oQe4AxVpkfrOOBBx4oY6DEEdF3SxxaOIwcu2ActXEjzOVEj3gpXO9v23Z//vL3dUHnLEijFDHC8b/k2QQnilg+3hLHH6RbQWqfrP1CNZFsnZEyyQCzqaFtjZAbtqnu0wSqQNib19Ag7XQjgZp3jh0N9EoUVh2iE+DIQPyKa5K3Mvph7pd7NeZBv/73yhtY4ujY+aV3ufn16Dqtpa2M0NL7YXCDklBbbTS19hujhm7hvbMYTbPohz7JZJu5f5n5cMtuQHihicib3OCUlMYYYDwhRKbBjlTYw6slWx3ILL9VBkCJo+OBBx8MrD8l4ajImZGUsqoqnD8Zy+7uvsxkm++99IZGyIbMPCAwTYgPWBK4pGLhgJc4gZSJpWzINCPFTHkE7gVE/KqVrI1Z7OymwW3VzYa237Px6QXC3s/Rfs5/EnAwgPFJBsxrAEHGBIEsV2HJsBqS9ARhk6YRQx6hOrnY7UvfXbkwKW9giRcSE4ODDPFfMloaqsQmcjogTwNZ0z1QaclN/aRaZap62bsOt8B6Kupp/WXf+jI+8+s3rg9933UdXuOGbEi/E4joypoDMBJgxQrFZp1YOvCVEl79qleVj77EXWM2bcjjnUVij1AkwDzKcuCN7BKHj0fU+PI+ed25Bq8j8dxJUYH8GXBCkzGXJfmRAmJLHG9kElrKkoZsuURwloTaWMHNKhPckIbBJGEF+J39AmHv5/BRJmkdbsfKGtP0Q1DGAuh1LTasjeBTVCIghJWxV6GbmbT3wXeVN7DECwn7Wz9T42gKPYQBR5FRAnFsIo83T3BWEX6tFBVyaF0COUTRBlyNpmayNfcv52lQ27Y+BOeo6GUsTg3pg8drrfSqz2a1sIp0ODY2NsrnXuIFxuXLl7VSbPV2x3YunB34GLwQmYBbCrkglZ586umX62l/u37cDqEmbdcAkU5MEGEr6qkAmYQGMicvH26JY0exo1cxeWEQ6xHIJSdmglf0rjHWCMAxWYVkffie7c8oEPb+jM23fqtpNoWpEMLaalZPZvO2ZyPZkQjLXFhejGjEBEheJafjUCW3PSleBiU+iZhQA2A3DMsYnFGgcWT5wQ8tfom3/dAbqxHDOk/67hGUTzKaWk62nK7FW97+sjznTzz5lFhVWbXWTd0I1uY0xlR1tT7fFdm3Lol1d5eU8sqVK+VDL/ECY2tzZqu7MPcyaEUsOwwDOdoR5E345cbs5UuW5os6EIQ1IeFuoZlmI5WiwwjPlMUSJU4Sy7IfBgklMYpNKfi+7bam01prFZNNcdtU/sZOgbD3Z9zYb+1kA3SdML23lcQPe6CersDvUsqnpLw55xKsEl6nAVw7UeHqz/9weQNLvPBYfPCHk299N4fQaaBzR1IjCC4ER75EQ48YUbJAZohRa+sQxYJOphGmeebG/GV5zm3bZgt7+meMNjpLEZA+JzFiIRdeYRTSWoldpjSdTYe+Lx96iU+ioLC5mfWDcTocrunzTk2LMQkSYH4X8MorpbODMQ68pmmeevqZl+U511FUUdiQTBQ4H5QgK4+s1uETTuVUeAQlTgbBZfDK6sGQTYlznhe9G2ptGm1sEk2S27ZSnfvBV72lQNj7cdG8+KDD1EUabZthCO2i1daCVHjBJVOxvJ9nIRfiwkIyImjh3Pz6VlXewxKf/HizILolJCej6+Z7SkJTVVbJfuhCDEYRlwWxosARaCshde/T4EXUtZ1un/6z3V8scqGLC0uy7/u93V3nHN1GfErUWHCY8jlHHl1a40Rh8XmFa+krX1lYsCU+uZg0VV3XCExZuI1QYGB2qeD6KzMIFAJYHHg4IEm3ynuuOvmPf+ITL4vf7F/b/vQLVdMIhLDepGhIUst3iwVOCdxBpNQuhvKxljjeyEptuWoggTHKimqDX1qtN5rmxrWrcegn2kyUgmU/CaAW3f30JhT4RXHpz35n61IATYSBmIYYHZOrcO1RVINPuJIifq0qUxNLK0IKUrg4LGXsixZsiRcR4YPvbHQ0yddWTWpq9lB00YYsjPkBgk4AArVmk+lsBO3wWtaq2bzwVafd1DWfL9Z68jdFyh1bJEtYN7UyOrdx4YMRZOCsmTST+d5u+bhLfLLx6KOP9l0nWXcgBOKASyaIY+K0Ms04tJHfvK9vbJ52mgfLdiJEFZNOwgic1yRhwyLz9Oyikln3qESJEwjWrk8H9deVAjGra+Fq7AN4jyNzZsym0aYbCoS93+L63rL3UUibQLmYXCB9NZYCIoU/XH4wmcaNuqLKGOY3xCIwKcR2MSkyQSVebEyMCN1CJmfJXzaILHLJckJiZTiZjVdWF53AmMn2vDvt3bBtl9ktiQ93D7Sz+IyXziYwzauqSivNgoTCEBQnOtYjjz5SPugSLyK8H9hE1hBJINGkwBEFdHutP3wIuB7OrgCefPLJ03yqf+OVnyP7YYbPlcRqIs4BhZc4zl/cSMhLVhVBghLHHnktTnAoPxpRbFzdkLREixBMjI3Wm6ZSg3vfo3+sQNj7KhadH3CR1AxhWWDei0xdGrMZXDhJmIDWycAl2KiS9/08/PN/UN69Ei8uLm3UMCxiv5SSmH2s5U5qbrjsBJGVUvIyhFkTaW4xJ9tou7HXicf+/Pec2vNkF4Ow6tYal06WI6QabMwGsjECH1lQ/xap0VnEspjxUfWpRIkXFZcvXUIQK1iKmPArh1qpENyMYW/CtDs3bpwq2r6xr51HCFsJMNTvixdQLJtAk0YSfo0qG3+WKHFyWDaOpsaHFmoahLgIk+JNrEHMlDaD65+7XiDs/RPTr/iOAEooA9okoCzfs/IrybpQbYy0Bo2WWoMLg/cDGynhnQ7iUN69Ei86nvnA3zUQhnZh8kjDaykZs44+cEQBpBSbqjhcmiVBTGGmywGefe70FP729vb4j8NoX7C+zm02oy9X8s6PBTPuxXbObW5tlU+5xIuOzc0ZTggfQlVVigjWNNSstcSLzdTSXHs9XIDlewbnprPN04MPbWuFqBBmE17lEmyKilkEZPwB0inwCCQKgi1x3Lh1Jf4ixOj/Nhbd8hEAlz/oQqWG4GSMOFAVTqTl8r55EwqEFX0Qsp4o20hlomTyFZOjs9uncz0OAKIQGNV3Cz90MlIhVnhX/9Y/Ku9eiZcSF2d1HFpJDYKgSAZdJUU+PgRkuRVbEq0UR6OSkJ3hFA7WIOq9xSmpuDeTSdd1hAzSuvKaxE1u74ltkqjHK2VIy8vo0A+XtguELfGSAieFGwaErTj0cS3Gnbiua67CpjVoHTHsIS4B3rz67LOn8wx/6LV/0oZUS+KwyxQxh8NrHUnVSPI0CSC8hABQ+rlKHD+KHcsd6TB+XS/QdAagJNmAxxBx+vSDisEykC0Q9v6JCMrWE9DWk5g8mXJpyac/RPJzMXj6yigcDa7rONeJ3vVsc1+ixEuKnQ/9pBZxGLpEhj6+H1xeeZhLADByYYVcqUoGothpO9n04pRY2FevXkXosEr2VyXX1fo4Pj2C2Nxzw98KIThW6yyfb4mXGNsXtsVKmoqEtGJcN2/dsZ2LqNh6f/+Ujinioq2EbLRJzrFJfQA2SVq11FAq6iF58gAtn2eJ4wex6Wb8ur5/NRuYASZZ4DCE5IJOqVHybz30WQXC3g/RfNm3hChIOYvOclkwm9IayAe52edTMKmApVtcbQxpzvdt8IVFUOIYYlpXjmVTg/eLroVssM4OcDHljRCUyCVYArUhyqqeAZit//CvnMLTm8/nuARqrTPrNfFpLif5o5mBWLV4AUj8LqkJBdKzvXy52BmUeKlRV3Y6nXrnRvNYFofRhpoF79jOhfNFayrZngpmHBbLClRtreDZkbjGAQGBbGRES6cSDoSHVBQJSpwarMtNXnyDhqTMDZFJkG9cTEaA74f75bWe75gvWheix1UmxD5kwEopS85jZGJGLIFbXIw8btFVZaWCoe/g195fZkqJlx7dR95H7aKMEXvncPdNzBkgb1ne9BQvRrnoGhO4IJSdRKl356fBZxqGwRhjbTVWwg5VYVcZPnF2EbayNW5iwgPVZS9sFVPZEscQ29tbniUvSM8QoO97a0h8+IgfATZn3tvbO+nn9t8+/OawWBopG0TVBJlxm0D8GrkKK5hIkEiCMQEVQko7V4lTicO5G2EX8utiQ2Y+GsPMCrFs6AqEvS9iEFWQzZAan6yPxkcrk0qUtUSFmTPgxkz/QnTBddaISvrK7depsAhKHFtUsbWxVTi0VAT2B8QhF8EEYSlhjmR5TctQ8nRKL5ITEGy1DCde1kFIjeBBSnI/eh5MyN0qfIo7EmSFZs15QSZJk/KxljgeCLu1neXaEbYSm8sNI73v0IadzwXWO3eWyFi27Uk/t3Bjx/owAUFyWolE7ySiVZAxyiCF52KYCqmOoYpJiqLOUeKkMCvtHJBVLxC24BCUwI3ApEaQkmfZLWqqALACbBBN779pej+YzpxrCOs/7xsm2w+q5mJSM7xIvECV8LMPSQWnk0c8q63GpD/F0HeLy5uT1O70O88+MDNl2pQ4rjBu0e8+2+iwsVHPu/lA/R8qSI0olsTcolQ+AWLX2AdMq6y+sVyYycxubos/9RdO9Int7u7jmth2/WKxzP4vhy/rhyly4jKILTa3NplykC5f3C4fa4njWaX90DQNlV256I/g1WFmFWMehmnVvZLGvIou5EQT/LI98WMK03ZXTD0DHZe9lYrN9Ei8NmiSIKBKCAgr0jSkJgpTEGyJ445MBM96WiQ/zECWmrgijkKILpLVsVBeREd+zFFLVUs9leoCqMvufngHzjeEFdol5YQOAtMSQ4pFmDMLmQ9wNRViY3QDOSQp8NFpqtC6Wgx7v/ITZfKUOLZazr/4nyoIkjTaqM7K4n650VRxK5dkPR7WKyYtDHLYxBEZAPoT3hSHgQ6bqOQFRy4U2d8QwW7bIryo6qp8piWOMeq6StyTgNcbGxvs8x3uMh6lFCd8cP99F95gkyAjrhhwp9Dc/52l5QODicilL9IUj3QpNIISx45f15X9dQl23DJGm1ktSa+beLB4E29glmUAr2Ei5Ga6H+DfuYawkWghCQ7OY5O4yQWQBkTvyZxbMhlRYaIzuKNpWCVKvIjQmCP5IaUgRy2e25MEJPsdIKikYyIcueFkMexAwgLqNiyCmyPzY43ROFdCDAgyygda4hhjNp0KpgfgMJvNZnH0ND5qb+dxCx9/4gRtuoa2IwsDHP7ZzVHBoY3jYMoU6Fri9GMkXsv1SIQDxCdZnRHIefS/mr2uQNiz/OIl5cZhvRHDGsiOSw+bJJG0FpCkto7R931XV6XIVOKYw2oZvCO2AFdbjxq0KWmui+L49CfJhv3oJ55wjhI2lrw86i9FNhcjC3umKG5vFRZBiePO8bQOIXCmZOBuoDBRLyTggMzHCCcUYejZ/VawWMfY5Mh6WqPjZ75RosRp41cYUWzuwKXRCQceNPkGJlwWpGvPfFfP+YWw0y/9FmlsuumEdKx+ZZu2wIkLNfEFL2KYNrXrWzd08w//aJkkJY43mkrL6JPvJUTNujyHUeMtGyFuzoI1UvjGSUXXdom9PfEvHV30SnyyS9Zh1POqUnDlAy1xzMv1dJqrsN6TCZw8EsYmHq5aqRNteAQXKhzw1ErDFgbep1XyufatP3wpUeJEIt4EXpM4SKVGDZmYjcD5/2G8R0ZWuXH+rL/68wthF21X1TVIoj/fDiswqwnAas3+9X5WV327xNS7TJkSxx47v/RuLXB77tWIX+Ph04Cb4CslXTJSmclIU6sv+NoT26L5j7FUVjiSsQDMhSVNTBBKq/Jpljj2uHTpUmJ3g/l8TiQBddQwy2AXH4YJ2B/84cdO6ClZkLXU2bIAIfUwuNHAbn0BnsZQyrElThrA3TS8bsmXDg8/4muP1seIYpM9+2rF5xfCDiGpqo5ylMhOo0D7+ImSEjWMkIEOpiIJpLiunda2TJsSJxGzSgk/GPKoXEPYdJsVSbJXF+JF3MaruvUnRYclHUGlSVbwboxbfCLW2Jji0PeTpikfZYljj+C9MaQDs1gsaBs+2vuNDb1w1cYBzH1gxx9/+8E3N0obqSAmLUBL1Q991kWgA9zDXII7AIsSJY6l0iDFTUcSKxYBq2hpwAvTwslBkZledFF4dwLEr405840955gLix+ptpBl5G/Cr+ulhu+NkXq5UmzbfUQYl7dLq0qJE4nNaS1CL4RTIlpu6pLp1o0PhyIuQzElUhWS0tranYw67LWdXVwYrbU++BgjHI0Y+HniE+uH4coDD5SPssRJxJSburz3d60csXeXcM4jppQnQ7Zx8/nUWCtZKB7AGN13PR3UwgGFoESJk4Uw6VZ35ec/ZPw+M28OLriPpIQZ4VSZ73v4jQXCnr24/FXfHjEV0SaBSjfnMIffGVyMXPAGCDq0830p4tWf/6Eyc0qcRDz3M9+volMkSnBLFfbmnBuTLjI+jlT91HYIJ/Jkdnd2qHXGmuADw9Mjz23JnCsootwE17XloyxxEjGZTLKPbGRC3xGP1EqBYPlYH5Q6kT0uzNsG518iTg83dxs/OKIZsqjWyEQsQLbEKaDY1eUAxMDtuLArc0X6fiQIaxNMtQ7Ls93RdU4h7HLwSdqu9wGyAMqtdFhq9855S4xaSSlSv5hXRU2rxEkGDjDXL9mFKyox5la4WYdVPh3HVSmQ5wqdHmACppov+6ZjfybOedx+GbkmMdJp7hiJITUTbspnWOKkYnt7m1qrAVaVhnTHCz0GxyQmVtSt0vbH318onauklD4C5niB3PNsbZNcc9JunSKlp6vEicPZ2ww7Mv2IcKBGsLoViQgrRJ1A+rPd0XVOIewQcKHRz1y7QZ0xUoabFpq8Bo0Vd6OU1UrjIHD9tCqmXCVOMC5uNPMb12IiLoGEEcPmNJonKyJJcKSPkSkubG2g6wjHn1oZsqFXmLnnc9h4tJI8PTHpqFW8NK2UOKnwzmXnWDJ7J7aruNOFbIgi4klJCgYh7O3vHe8z+b7Ln1UBVJhAekdzo+8H31+8eIGotwcIu0SJ04CtcEAXeL4Ixi3fX7khkHGcqIRQMTRSfd9rPrdA2DMWLoqEW7SppDKZDrvOW9TB+qOCAEzlIZBTGyQvUyhzpsTJxeID7zQQNQ2zm4gEh+s6OCKlUiB1IB6/lFXdHzcddrq5hZi0qio3OKIeEkg9aqEgfS+cTFq/9tWvKh9iiRPcrjCjUiqXko54WCQF2Ui6BVrjI/u+P2bc4HwFQgavQ7LcLBOdh5t1xTOd4PAGW9K7EseOX+8UB/rEqwelW5FflDFKH2QI4iwXYs8phPVUXbLGVIIlNsVtPmXI+TRLAgdIUYNY/pP3lWlT4mRXpYR7IdFhgS5CUYmTxmHgPTEm4djnWmhDDpYJs7CmP26Hg729PcQKddMMwxCpnRHuatAFZY8ucfKhtQZWKY5HQtjAoloq492Yhv64lRAHVyuNQBafiiUZOfDO5YaZ9PycU9xKVSxR4vj2i4PRdVgR9jBz5RZNt/x4mRJxYMhPJ+J4LhD2jEXEF65M1IbqrIfuVzfVvQjFJirS0mDQssyXEicepAtL3SrjJh0P2knp6EeyRCuQY5ZJSfoEppr0Ea589Xce43NYzBcIFKwhOQJ22r4LPyDxszratr5EiZcebM3FRht3pV1nsWIB1GsYj3lkKu8akMQiSMFweocQds0XvwkuxIxiD4trlShxUrEGrzhD8iXdYargxIAYVIgq+HjcxxQFwp5sXPiqvxQxO1dKghwYKmRuoTp0BLRGD7SFc0nMFAhb4jQmZOQq7JpLsOrqEiMvVsQIrO1HjgMxKVtHkHuL49QByAevwOKakpu7jy56sfeBLxC2xEnHY48+mlOmo/EgnRuM2gXscQDHfD6Ac88ghHVe+MC/PHofDm2nN5uRlBJsiZMMWA+zQ1CWhiJfblFFXutwcXdwVIxtoj/Dhk3nEZf5mJgCqz0VvKK/KT8m/JrTaL8iQSdMU7yjrbxEiRMOq4FYA6RIcKsmj6dCbOJci9efJAb8Z2xSuj3Wo1IfPC1r3gOJJ5MowV3cDZicCFAmSIkTj9xQfXTHVFZwTyxKgA/UWk83t47xORj8nYnmCYRE8zAbd4rDVp8svpkOIYYCZEucHH69paZwuKNLivVkWcNcuhES4lfNtZDChT1zEJZc5kmTKIl1s15cNZKmsdt7nbVE54YwDJUqzpklTjw2mkohHEy090oWJD7sfzwOycwxSCJQMqaVtu5YPbqC9yHGYRhhMUsK3sVgFp/Eq1/5ivLxlTjxHUve4kZ0hxEJozENXkml+u7YxC/f+ehnKyCpIinI1CAlFk5WpNZ8V6hRosTxo9h0CMu+4DQJCPKkilxAcCM5w9nVeYSwIZDDPCXPuPVqq49sVaFjXIITcfi1Hy+zpcRJx+bWhmAZP3nosBQXG7Vm58vxWB9HJufO0hjrj1WR1YcArMXBk4V2aPJTOGI1JJ+wYrxc4jSC6LDiLrJVkbMuohNQ3YG4s3t7+8f1BJJzEvcO79iUS5ETuQSj7Z3215tPeEuUOGbw+iJ+KjOzcRgbpXMN76996psLhD0z4ammRDz7CFLj1nszhIV0OGdOmlWyZTkEKnEqsfOBd/FwTDclUcQtiJlFYCFDWLbpomFMeVhIx7ZLgtKJpDdHZjhBWAB15BEEVWFNsf0ocRrx+GOPcTKX7gJhMQmUkhS9gU4V9vePDcIieAWi1gScgForTipBW33E5lp2jxInh2KpWTC9qB8kjo0i0Zu7KX/fy3EeN57eK68rIS2VYakxLwgZJDnSZ/YSqCgCtX+T6YqRKQB+NZTZUuKU5mRMmo4IkiM9DFLtk3hThEholhj4uDcirvR0QqqDUEPE68lx/fW2m+OuL5X0xH/VUpICZkye2lsJN/AJLbd7ixFJ0PKpdYGwJU6rBjFy/LjYcKgkC2K0A6ESBfBKzsUIn8K8nz8oLh1TBWQIWgxGOFCBGisRQIDFp+DItzOrG42MHy50KfbQI7dPAKfY2zNvNIeg7dhIfki2ANadN9xtHNmuVh4I2K8Pjm8BLyPhJ60ZkEkeVrb/ZFFOiXs5sokxrDyN1yOHxskBreWAdkOPSXQN2egRuGIhoIkidmeVDnseq7DLAT9fYwzt+oOnttJBIVqlA1NS4oxgIvDsTUoEXAUlYojYlQlT4pTmpCdLWS61RgfOy97LAcen4tMACV6ZNCQXUlCm6pNcDiD0xvaf+zvH8teD72lbTqLvnZS2qqYgbQy42qk02tYhvsXs3WpdKapyqZCSssW4rsQpxUow6EA56LCTAKJETUcJCmgeRcl9hi4em2xQiH3CwT6x3kJHMs4MTr0InRvdO+MIJKk2kvKFmsMRMXhMPhVpPBOmHb+1gqWEXxM+XRKFXrGIYPUAnH8Ilz3kG3SEGLJ96EEJbuW5hD8r6XYEvsgXz5JPhQBxj0PYjGIPCcGKA80BWF1uEo7NGrH4Iy4JwkESjFCTKNVwVot057N2ovgCmspLVFsKWUf+IPuEvBTQJ++HGJyWoigGlTglCBtYFiOxBAGpAwG1dqWxx9nHaBPZz+I/z86uCRNpKWM8ppqJ209+Sb5GQkkjauVrpZzU3iXWGOS/EnGXdrRPsugmPq1KFwhb4pRiUtWuH1YtKAd79/oBRmkau5AozdNKqBiPrxf3uvWYVg5SdkF2AiZJmETiRGSmoDUrIVDpk6qtkiED3cb/EOwGelTWtCUcQccqLD0+vowgRywik1iVWqlkxocxAFzBzduUXL1g4EfDujobxx+m+ktaH5Kk0k52H6PY58cR5fP1dxKxuKlbWAOYJNSZ7eg6dxC2eetf3lvk01DKRTBNDUfy7V0gnXlNJgglSpzKqsQSPTLm4k3OuDSRX6newjWetJ69KYhQyWQQ9objkYa9OA2pIwrsEH0KfVjOY8A1UTe6oq7GUZqAWmWYIY4AmvLAuhAJSpxWzKTeSwMTwu+whfP6znLF0VCjoVsBu2OIJ7fEhhebQWw4sRzSrEs2CDMQ/Uyb7OjIMDRypSQQKYjOL3CSRISVlIuqXB8Rq24vQq6IUUUuo4wVNUmZa3ZRSlRtEZQqZlybbgLsdDBzAOLTWGvJNAt254kFv5a4Hcxl3Q6ukdzRAKFA2HsSH+RPjXMQcDEe7Z2Z2ChJV7ovo77E6QzRSKJaVGlN+RSRWqUkaa9KPj+UDGGzGRDiWS9k0CrQjeOIN/97n7K7u+w6v1z0ODm6ru86t5iHvb2FSpKPJkBIgrAiSrKi5wNNFWP54EqcTkyEWibh79zRRUs2c8fx/7UxmI/hOj/Mop0fA3Hu6mXTOui87B0MHQyDqIdU+aQ8m+AIqpVmXXnFHtBEV4/CpGSc0HgPpKwKBqNgrBRj8TXGm6DmSI0gbWZCGBBHFg+zfSOsOYCQ4m0gahjvG0+ZC4gt8XwUKw4oBykWCHtGgiiGUnJuSmJAuG54eXe2e+lWKXF6K8tvvAs+/3sjkeIE9VXjDsjLC26EkdtH5KpvhHyuw6BEUDLA7dh+P/tjn82sONwm5Z97x2/d9U//6H/9mfNF37ZusRiWy16B3l+0i3n73HPtU0/f6PvYtl2LoLaPgxchkJ4gIoXeiSotBlF0tUqcRiijcsHxThGIBUr0MMSFUrHOsot7e3tvfduX//Yv/kt8wMPf8MZA1c1I8I58EKgIOpomMBGcT/mTFlJL+ez7/836N7/u7Z96Y/C9h2WAfS9nTkycsD5ZTwXXMLgRsyZhgrAhao/XSUdReVEFYTyYSLYIJgE/jAqraqyXjmcuK14BCc+GtHqda8h6qN46PvLWtwIOs1hLR1aJOyCh3CrIRX12eiwQ9oyUuEgnK3ONkpJS+ijTUTxXMvOUsPvL7yljvsTpbdKkyZ48HwR6oENBRcIZJBCklCB0K7gaSuI+TienxSBT/8e//s/+q5/6uXf/5L8/DXszv4egNvVPiORAKhzrv/CjDykfZEi8do2EAFAKqG9bamObZgbSNM0lxKbtchiGWFWTYfDLZbe3jwgg7O11z1699uzVG9eu7+7sLvcXrhtIJXNnv60n4ZlShy1xOrNDy6MhLLU3ED6NuR0/M0vn7eLjH//4H/u6L7hql8/qeVi1XRETRmbhgtyNRQdvpGFHvS7SSGm++bWKTu0AU8kdL9qIPwxVhDqIKgrrEJUybMWZ1QflkwnJBqgxr3OpwWsGuLUXxkW8jUAWv2REm6xj7ZGYOa9UYE2w7rwBYrgpepaSezMOwOx46HtYd+/mPesmkaVSgC1xByiU+Sa5xSEWCHtWSly0XUvPVViEsPFuE1wy7b5EidMMTK00BHLIpEYu3FxpB5WEY7lHJAafsyu8O3pGtPjAPoX27/zkf2zhY7XqJqnVqkNci1szHV4q0CSGnEb6AdsoQ5Zlp3Mk2S2Hp57cu/LAg3rYpPJq7yHiJKlrqZWJm5ea5vEL2jxk7WdE0G0bnru+97GPP/sHH33q6aevP/3MrjTTZ36vfG4lTiNa5Tyfot1x+rAcLAkWKGJ1E4Fb0jY9n8/3u2XX+K6hviqf5wAzVclMOSW+h6dGID0DA9w1AeAAEGuSdKYXPoieKK1CJ7pTB6b7pKQwxQzaRMasQ5p4aIZUu1TjNaFVUB3iXfpu5UQzRMS4dR+MF5bOWUi+bq1OAEylBe7Hkor/BL+cEcVKyNNXjKp28hbH3cPvS2ERlLj9HOHcDtaOzYULe5ZQbBZKi1G+gDZqWupSwbAlTjWs6gfwjhRhwY2bE/HrFJPbfGRjOZCUg1G5KQA1JToROh2nWg2VGGo12DQo0ZN8CjPvJJ8b6XwgSSVdebDdJaFUNDO4UAc/3MDfPpUSlHJDq8i0AH9wkbrr3RJaajNDJG03bPX619Sve/Wn4e78xJPXP/H09V/9vSfKB1fiFGIuvSdWjRK3VYXENE9JlsxMoGDwZGVDBBwtfQpRQjQiVnlWsCIVkbqFH1d7ZpetHMYDS4IE/iOeBcRTT0T1foUSV0f59D9EwlbQH659yuB1MkDTJ/yyohIsSAfGAyFaxK89TLpUdwhnCcsikK2IUZCILEtNYEIB8Q0Ue0hGyXZ9Y4fWWkR2JVtAcDZGOJCMlYdBawGwJW6LgiTrE1Odggk1BcKenY9OrCRIVlj2yMAU/uwmKCXOYlz84rftpN7DIKniQ8Tt1T408u+pqMRyWkqq/DWQB7IXvk9+AWkp01KnpYLeiKUQQ5aZlcEgylVJsUjPakgD9TfiGlbFpCFAt9PuLUHpjemGtfXefKGCltryKalT9FhNh6uqBtUIaOgoNVnzKFy+cOFXf/wzvvibP1I+vhInWz163Wz4vWeDkZjb3bY5KwoxcmwQCwJ4z1wxRYwwArMyOZweynu2uyNRGpnbIXByRFI4TimsilKGnBulyEJVMRoEo5IEZ4mlCjQ/WcZ1pRIvwKpkEhBJwInpICZDavqx8moimGQ0Qdho+zjpwrRN9VI0Pd4T8PF1ZPqsTxYfKfGaj2C4UIbzkuErrCDsQdE1ixhkzQFeJKRY2xus9jhZJAlKPB8HJa5qwMoAubRznbF1kOe5p5MhuAuXgPLbsgKUOMH42ff9iT6Jr/k2ajR5x9/4+l/4jadl6qUcQDpKkumYUfK5D5sAck2JyrEJAvtoauD9ObI2OhNm1WgLhDss7tRD7m2GOChhcr3pkBhR3hoDG8ojDO5kahXu1HHA7VHDACkoPmUllU2m5uKMwCeSJP7aZaBDTl2banKpGeJTv/wjn9YPKeAzUfarv/P/Kp9siZcer/z2L9rf3wWXaqFj7/7dv/63sVZCKyluXbn5VJ1oo6xIQAbMNC2izxoaCEydd5KmzhAZHo7+CGx4l6uYCuEioVgxgMhdVpGaurgJOGXFK1YKYcwqIYPFscFKky4HkQrZ3AAnMDVgeiu0FpZECaDGxwS5dMI0sOjl7jTYHqgKOygixSKQ9SITDxD7TohskKoAVUgVGdpSUfagDCMOyRDETI7NCgdw8IizjEtKnHwpj5QRgWUwFLnVqDP6Qs4jhE1pJBINbqDzJTpVvWOEGK1WZcSXOMb4wI+8vtJL0nQdBqqKhqe0tv/gp79wLi//v9dwz1vq0CmEsOC0VIF3SUnq6JFrLMlIQztviN57OgiltmnqSSFqAUlVKyOVjUTLI6MvKrKGKLwWldErIXXajP1qE/QrAIB3+Gpzwp4/XepdY9jLgHCwxFUu+eh87z2p1tL6ZyttK2MsomhPRgvJCtKzJSUFUB/8kW1lrVTVW7/pE+UTL/Eion7HG01TfXT+rFZQUcOhVg3OjRgrysWAu5bS4WSMxi2rvMXI8JWNQRLdoHJpil3fS+LFsHMNj/vIQDbjQMU8caENzshplm1dCbga/pKMCxyjWaptJnYdICDLBRGyAQsp4KTDxJIPPpKjLkpBsgZ4SWB9UgGnJSJdYSc4Z8BG0iuwniq1sOxrqs7SZWOZNjqxKcXEx+hWEiTh0FkMv9Lxq7EfGX+tPFxtSWl0NCgFmBK3R7GsGIpj1xgc9AXClihR4gXE//JDr6/lXlMNiAeH0EfJdpCpEr6JoINDeEgE1tFzndirwrOHJadaxMejHRdyBzOdaybWmiQ+QCSOAcsBZedNJuzHOIpPCi7pcl4mVqeSCdxhB20GuJ73QUMV3XHHFAhLcSul4iqC48rwX6N9NaQ2uj54UiYiizADlVF80OlD6pPYjx6x7FbvJtpuvO07fr98+iXuGv6rX9ElV21O9YakYQhaK0MdVZK0DZtJ3St5JwOi3NHPHgC50ZqnAqn7AxP/WBec/K7IOEvnngi+GMGcQADjx3N4OfJMD65ZqovKH3S6wYVYRMrD6ploIGzK9Fn23pICn7LLHHZIJqVWEsrUMWVkjLlp7gbTkfgDykLl5LQT0w6WDXRt6jpiIywHum56X7ux3wsnmBIjCmexAhaoj2Nj5vhGxCz0mZG4LIOqxO2CzWnO+GsoELZEidOIX3nX5wbfpuAh7to0r0RPdVUYAkFLzIC9E0tILVCJybHZ5MronNuwEngNXI0ls0wYz4GSyiWmyM7oIUIIEBWQpHqkJukUDbA2V97ceIcN8iY5Ir/+IneoJja0XJdvclmH27apZ5oKW7Rz4o5J+zWQNoJT1O9NZl0gVZb/oRcVkw8xxCHFXsR9cLsffvdFZabKbH7RX/idMh5K3BKXv/1zb8xvLIdOVDDZ3BZGtXJIEKShoYeDycehStoC+KE/QsZy7V2VaHCnkLWDMvqDTBcFnSXqUjKcLOZv0P0CHEl85F6uyFiTmQl5s4zZzjVikkciIDINIL0cwS7+VM2FYUaxzDfINHOu1HrMRSnVJNKCYAUDlszCXx5VZLHYSlov2kEue9F1cdmm/S5OeuoM21rCxn6ctfhIojroFHWkgxidpA0Er6nknEvLaWTCppHgCNTzlkpPV4lbI1Ngs27HmZYPLhD2rnlKeQ9KvKT4tXd/dgqtTNeVipqKMIOLO+CditGIQYKhcowUFpyV3uCGJlgkizquEX6mlY8B7keeGlRwVybIm1UGSBmdCj6sjB5W9R0q0zAhli+WHdYtEFoNK3EeAq8CDnAAk+fWHINEwBdWSwQR/6XWcmyTYT1NBBJUleXtORGCzSrsMQVq9WYyLpCCrRSVhWTxVfko2hh2fbz2kfddEHImzNaXfuP/XYbHeY4L3/0ly9AK14for8Z910TfSKiVnkIvwoD5kUeUqWplUxqcpxMIOu8cnHCBRv7zwOuYeUHeo1PK2zNkz9l8/M6aGhFzMTrrD9ToRZJVCAE9mxqQYzIr2RGz4JCVK4u20kz0VPGkWi7jV8aPY40WEW2qcgV47CcDVnwlkwKEnk5GsbaHHa/pHrZeEDZKG8XSU8217eWyQwgb6j5WfVxafDfAK1CBqAiGLBJChYiZnkeyJKnAdeKYf2HWzaN2HWawp2KNXuKoGLk4pZ3r/k1XSjtXiRcRH/rRN8jY69hDeEYnT90e5CKAG2oXfE+yk1TJBAaCGMpLo8FqWeEmKqiHRMWUYSgfgLKJikzS09ad1SGpipvE2FwSsiWlpGooXQTvnBJylYa20mTEYc1z8KsvfNYlWI/y8Qj18OJAGDYEMuyM3KzC36cKsCYsQD9KrSykZBtHqiCdT1FVi3G2Amo+S8kjwA3Ox30v91PY/aUfe0jZC1/+jb9bRss5jNm3vOnJvadwjCgapyHqCDYZpYNEMLugXkLEfR6Htkkk80+HFjioDJDFgEsrE6s7rNkijerHI7LNrFW+I6ZxGjDWpYQvSIZ++dRdHLRFUcd2BqJ8LkETkycZDvABBONXcGoUDs8VWge5WZgOMyLngoEAMjVbavqawCsd/ae0bs/yrJ/l6WyFOjNwmnorBptsLcwAxkFfiV7LdoGQOSrn7ZCqITVBTkOceEmmCUlUEHGyGU5h6fcrBrAyI/kiClnidhHjfSC2VCDsXQFseQ9KfHLxwfe8Trh9MTyhIFgZDJUpI5Upk6fjSdFDHLRBIErn/qRhSbub0kkpYMGeRLS6jGLlaKie1XPwEhRT+gR3Q9uDXZzrLQQWFV4SKD6lZBiaBtJlVx6CjkGtjCoDbZWrA9LVWWM+cxUjPBC5ysUtZDBQr7YI2ZNznBpUPyILz+wTQn0z9Mzzj1M/NuQKFcEE3Mc9/7mAqARhtpZdlIuoaud2f+HHLml7+Su/sVgjnJeQ/9Erq83JAgFaI2ylU/R9N0RM85TUtY4iLpf7WlXCGGByDJU/qTpKTVGI9Awod2ST0liLXbd6reqyoyMda8qtm/UjH/aTx2xWpVoldit11fEOmcRhd9dIRxsiKuho0NMjKxY38FmnQBKzlh1jEYjTHMc520Wfpzr+Zst1U2BzBAxHc4Tg76DxYWJh8G0hKVmNc8WLjg5o1HKetAuyh7oNTRdnA/RODC5NINakEQIVJpd0QIOTi1g+khNJyB1rJUo8L0bSeIGw9/nHzB5I5X0o8ULiQ+9/U/Q7MlwHmFvtLCQjvRF0AojbC/6XPHFEqdyKuzcVYHxMNkRDNRpP1LjoJNVTqP2DgGwQyq8UzWMm+MGaf0+mG5hHe2IekMM6be+0fUkYWU7AGj+SlSFVysWhsf0aIa8fseyYqqWRZkBFKyXWZ518Foq7oPcDd5EgkFipqJOiOm6eWaVLU0WWdk1NeoMIPOj1Bvp+8omFW0BHBK+KlDgDaXLiC5V9DP0wzHvX/dx7H5H64p/5pkItuJ/j2S+oLjx05eJDFwbhEY4hMOQWqyG4pRfRVraZTq0VoYoBZwoEHFbMqHaaR5ggeWInD0l6wx2InmldgFhD1RVLNt20nt/6wzShGLDqTKjh22wmzwTW1cPxThPBeZgyFzawK4ENwHRVJsyy3QDiV/LZs2AxBewym5YKpdxQSWqvuZsS3wTHJFn6u3SIAhUfzmgltJa0LhjdNaD7YPrQLGWzjEOXfCdCv2IdOZq9NpesE6PYceeSB5ygEiXuuygQtkSJY4if+9E3g9iP7tlKLY3uQXZkLkAboc+H/dRFrSWXZ6oeIVyseDOzVGcVRpIUq6WHB9w6CfoCQ1igTpZASgNjgwqbGjApTzIp1aWoucs68wf4SD/l1qxAjdiONS7ZHYE9MkkRfozAerFOrnK13NpFZ5AkN0QdLyzYM5qyMwGXT1LpESRJFCJLKXCxlktVJC7LFVmqHDNdN7BbJ27BZsUpp+YWsjtCeJvwCSaDW7aJLs4DYpaw/Pn3PGbM1ld+U+n3ut+i+fOfaremF6a2C8OOWwZFWlOW8B839zMH3OLsCH3qMXULXfQ4qpSuRO9dwGzQIKbDMbLse49jJ92skvo8/Lq27hj1UvMPHEA5yb2SuSuShnQuVOIAHlZCWnHUgc0DekS/TDMgkdeKJiAmZYkZAnSUT1JZAbLLUWRFLZrsSgyV9BWla9DlU/7xeYRV52SG4J6fD87ljk5XiL6AqL3iOu6ioaOcXSsap2onZ43xkxDnMS0iriMpEx9wqRiIeu5Jq5meDyJf6hVLOX8sUeLIUl2BsGc0Dms/s+6mOvxp5vy7RIkj4oPv+aLgd0S4ruRcszOWir3VXuJm5H0KQ3S4I0mdjKKyiFFSS6e4VVhKcmVHFKsV7ea1ig01hBBp1QD1H8ssQZ1ZsBFwI6PdaoVfaeXRaTTrYc+tvFnREWgYZQVG7xVuERuoFrvCr1wGcvkWcAOzHLd4x8tCRrpK5JotQVJNpVVBBgsh+yPQFkyS2CSLALmjJHBBONu30/cU22IG2mcVA98QYDy9kiz8pcjoKNgkfexC7ENqRdj78E9c0aZJevs/+Np/WwbYWY/LX/dZ14f5kljhAwIt0ShZW4cINQ06sOcrDnfD6Q8iv3bZC1LuoIFuqkrroaX6qVYYRgykhcxwcq2RenAgeiAPl56PaTO2JLYLA0ca8Yp5qJlKvj5t00J6Us0ajRP40Zx4pbG1N9d9qQErjYwbHTALIzhrAqVrAw3piOlqS7VV8EoOOL8jlUgF03nhEAtWUlvYmKB6Ig+xri3eBqiIZU5z2WmxZ4Ku1SyoJoBrwLV6MM6pgAmoxyXASET+Na4rXTSOZBY86ZZgwgmWlBBG74PbbmVwFzBTCrj3KWYdNZTP/Ad97iCsj30yk6SSCwGXHSPIAanK32IlIk3a1EQIlLjo4LJFdtylp7PEbeLD734j2UymT4DFbasVYinjUrgWx5it1qftRHvD3TEwqKNjdMAdTydwuE3HGCVufzFSQTLZr/mWX/zLf/XrPW2Fwischn2QuUZruOvYW5Jojwbwe9nkHTSLrFvqBllA6C0+OCIC1qTkSkoBJhtgU0GLSLkg06EVi90NaEsmoiEhzmXbambQcXlIaW2yvCSLCA1Afgr42Ax/Izen5cNZ8jmIRL/TnrSyqc0r+GBMwye+Q1IuKX/YIFOz9BCLLuB+r9mmO3mceskl/A1hAN8F1X7op9745V//b8pIO6Mxe8eb97r9q5MktmZOuA4/dI/YzlCBEHDMk2KVj4H6FjOCjXGIosMkTZqBJI0RtCKMtWGJXxgNhlQK+uQGHIfkvgW5UCpG+vaKvcoyWCT9SnYGnCiRNIdOdCJiAWemZ7J4usUYnuuZiSq/MGoRyFzCXLEHdGI9jxg9JK8UbiJE8pFgWSE5dNwfmVUH+ASfUK+Xk54MZhUpIYBnczy79k2AzMLlQw1WgM40d5aexQlOrwtzXFImIdZsxK2oi9Ap2Fei1nFSp8mGnHVxo02by7SxZE+EZZy1YkZ/VNSO6spayQzTo1jh9RVgIW1awTyjsTx88FbyH5fpptSgxH1VvhNEzAlKkzkXjq8CYc9GdKEnFiJC2MFLZaXQtI7G5GXwMmaevoagydlPkikLOWwXCFvi1vjQDz9ohn+njDRGISKl3mncX2LLR6BdUpZIq4l268xehciK/3lnwOElnfdkxi5V49wwJPvW7/gNfNgP/c2fesUX/WkSnoTgVZfAilQDt15poXUKOE4rLXvqciFjQCrqMl1BprkInQWrYoWjOQbthaazWTpqxG2QhF2Z1zo2aXEpKuYqLZ+VSoSsDvM5a4n4x3Kaxk4QU8aAiLrnJmxHHANC4cS1IxjLKDwQoEAgnvC9SIF2Wy2bPjhtau4ExyfaEReYk35gTS+IWjFmoXeHGsUIQBgmSETgMnB0Pg2d637mvQ+b5tLbvqFwZM9SNN/xeU/uX7sq5/ahqcf8ik3kcJApxH+hN55P6zX0Emh9FaGmTIlJ3CAR41LKFoL3CHWVaSbt7p7nlMoPQ8TUr6fze3L0WBUNM9Zcfwkj4yXRyKS7FHdGKhm0QQibOiZ8kzRsfras/Eq+svhoLvZmOSqqhio4qF5mamnESUwTilLFXgVKIqkikrx3NBMjl3j5TETis8fvO0ooI/k7g5M0k5kbLniaEUX8gNvO8h0SsuoBq3RxTZaZtcACJn4/Et3CKFHVstqAxsNmq+p9t70Ul/bTRYsLRDRRTBxRCCYDvgBFcg/A6Fphuig9V6Dl2NpGYgj4uzXVkrOuLPvu8msnOu8a2Za4v4KmmqJTDaktzcsza3FwDokEtJk6WhrwE6RMmNcvyOlzyM7Xq1YBaurGrdbD41/9Vz7xM/99GfclPvL+L3TDDemvN7g9I55LHnevwTk6uicyKrVqSTOl9T8L+uQ257ju8Sft865vqypQs4akli3X9X2q1n/i4//0g/ZL3iFo3wkkNsT9JXZUbcXfy53TuNFHmc3fgZQNEA7jNim//R0//fff92VDJEFJQCQrsvEkIU0jrNU1i8iuqk7jQSibrHuqgKnmgWZjipB6f76PW7KcTF1yy3aOr2I2mQDOmwxDSU7LEIcA/76iU4re4VPF1E/2ITJaxv3Se+gUNXBxBghk4cXHtllGHndSJQW706+U4RMJzlMJl70/+VTX0XEzAoBf+snPaCYPfPF/+s/KCLzHY/qNb3hif+f64mp1eStVqhMuZgNUCRUVVgk54sxAuIpodB4cZjKNxiTQKu6e70lzg+aS1dopQr2IWnvnHXl/BI07rVRVVXdqSC4zCMbTDuB+rZWy8bhJ0+Ak7TfeoZO0qiJZ1x5BHqFMvWrtggPf5fF0Vee0k9shmYvOOrFJ1Ji6peQ0OCucERVVOzD1ioj/bFCVT5UXCFUFySZIkuEgviz1eAlymiWWTRxpCcQ052E/Um91JtHyBuS4YhrzEQm/GMU7lOMeL8LBSuBEsxF6I72EBv+CznpaVJyWbLDrF/h7kgnBsmYfF18la4uxHSDrNeDjA29+gV/zuioNKZXa6/kAQykkoob5WCDsWUk+kvCeGkeVNCTXJ9aKRbSxqrRKTnOpSIBVFhOVbhjKcC/xgb/7mTs3PmaVm2qPu4hGdIjYMXoSs6ECRyRiqNJaEqbMPVTrfulMAM06AQE3DtVLWcmo2JlHpOB/9r1/8u3f9r/hYx75kq94lnVUeWeJq2vSZMUfxE3Zk3el8sAbm1YDguGQcMv81x/4bfzxb/jWX8Hrn33XGwneEvQlKi7/LNPkMu2OgjbmyMf6+OcROFbW4F8azJasRGN7fES9uVXFULneL68Pi6v4q9i9lvZZSdIEaux7pj026orMh6JyqgKoo/BtnxYq69aSwJZmTYWxkAWCOQzgBDP3qA+bZxyC2ji2z5BpdyWpVYbEaLtF567+yvu/4Mv+4m+UcXjPxuzrX9+pePnRy0st5mJIHtRqxCk+2SfOtBwzO6n1lOWDLY0IQXPGO5xLJHKsFdSVArVYttJ1rh+gBmOttAFHzHLoRQxKmHFBZ+WAw6CLHVczvRXzJEXjp8cZYiZNYxOo/WgpD2S2OIySsVwAZUNnksrgYU1oVVBuSJ1W9DtsCFugNjDBshJR7FAJurChMv4Nm6QeEMuKTpP8B/HRE45v5r9zUZa161a+ItwySQeAYpSk5SyXGA84qZXECYlznGY6onn8C7gcKKa05qMTz0/X8XNuLf6IaqWYs3gXnbpIj3fu2ThtxFYrt52ofVppOEBu8GD33dymSTWcwAp5XMzmVLKwB85NkBIcSduc1Za/cwdhcW3qAxWlVspDuZ8V/KiEsiYL5uYWXAAxi5a9K1yCcx2/+BOfm/wexH2puhR613cE/kgTnSsbSo61ScSLBGqzJqRflWB1bm1e7a/J1IRcQ3AuDQZqWUstTKviD73z7f/0dxb/6qOeza7CCsXi2CQYpxjO9kCNMMSdVZq+Qa5ZehA66ubwE377X3oxFNL3fvcl/9G9uraTyQQRrZ0vjTIbG9uTyYYRW+ypyYiXdCgjAo7BD5jBSxkQXQQyN2o9gQeP+DNi3ud7BAEm4attWOY2ENuc3hTGr7mbBbJKPfl0RgKyCE3UWtGzIqEugyus97130bnwy+9981d+22+VAXmvxSu+7bN3utYZoadWTCojPHEGRCAxYZJPjSGlntQzqHlL8gdM9GyNy2uMvCDTvAl0PuZZNKudL3Es1brZvrBNsDBUbdf1uzuLrrWVHbRLTqz9CMQ6TWQgG9lsIDI8ZGRKtcxpM3nNK1/1f/yPv/yiX2MnxBv+zGfY/UWqlFeir8A1cimJHYuTujGIZwkVGswmq8R9Y0x1JbCMd8Se6qSr85gMHmAUKMhKBXq09Rp1XL0kuRCcQhVmn6zVFSHDXCohO8l4lhIDyieBMwSiN6g4aLFfQTNJky4+uJfUPuBTpxSCslbmAcUD0kXM4s7ZjSFSjVnm3rVCILj/0SubfGC+xGd4BcKejaiUbkkuG1NmOof1Y81VsIZ8zA0BctRm5+ZRyoF1CL4M+PNbfH33a93yo7WJtQ2kWtN33i8gKJaOSiwxlVNYlqkiLdSIe4pclWBzez6VV2iD4hqmIS5oHwbMjCzmwLqRuhLKuLlYuj6QhXvMlVfGr5mNTef+gUR/aJsSsiZSHHkG4F4ziLQB9hiG6Lf9d9e+9I3PKSUvXrg4m83IvtKahx588PErFy9WD9QGqspUhnCH0A50B2EJvk2i92ogZmyULZEdQfrUBZOA99bcKJCEOLR7Z97feOCb7TgJ1TBEhiErHeFmzQclgMBXpgG3Zp+GKJYfes/rodp661/8F2Vk3gvx8Dd/ptdpLoe0oYPCz4kSm45ETUm3ONAJRSQ3WKr4U/9T9uNA0OoD8aYDF//IuYo0+WnVNUy4HsgoWdRJzpTBoVRxB26/7Hw/kDTxYePvXFQcQSz7fxBHG38+S8yQe4BS6vL2xf/v13/zJb7Y//0XfvdrPutRTMvwlTor40TjBHDUmQaTBjMtmqjzKlUOyJvAJmsSi4BQAtpp8KtSVxyrJPQ9x4pemAEOpKdMmnmR3G5psstVN5XMjZj0XslRIWE1pXrKBgirR3ZG6LVcVrqayIrNaX1FVFinCAT//+y9CZRtWVkmuMcz3Hsj4k05kIBiawGClgqOpaUyKiqiLNuGbhsZBAREa7Wryl49VA9rVfdyrS6blqGYcapyWU4FyCRD4YAo4jwrJYJkJpn5Ml5E3OGcs8f+v3+fGy+YEjIzXryMl3fnfTfjRdx349x99vD9//7+7zMBiWTo17LSgi6BNtdV5nJEohkd40dJrT34Nu2abIcHhBli5XEjqnVqmn/Xq9U3/nAAWUimtUKKymO4LI6UteJoS7KnktIxb85V7o/tLa/9iuQu5nCblivL9la0gRgT2gYq5SayRist97IcjvJOwHXNkqlFI3lgXTNd/pqU8tnTP/OF9JZog4k4MQQ01fReUIFVxQSTIidkXlMGf5D2FS9oQFZeGC3qKBoCBrW0UbiUptIcz1z+jQ9eWi7Szval7e1tSLdmceHCxS8kFHvu7FZTndmZnDkz2dmxs1k1mVZNM6mnQ0pL7/eS7JUFn2AgoOJyH3LTNqqqwFDEIcYRAIualsK3WwvTF0GwDFHLy165BD9o76WoQQYDfzMR8EZdzH0Oi7e/9mHZnnnS9//eZpRexdY+46G3x7mprWpqGrpdCn10qxhkZaS2KHlOSY+lRICwquTeGbYGpF8j3WwrWD5KQoPN0GKLV8ozFXQq4hC6/YVcJRZlM6B9E/J1HrQaobQY5a54ygl5WD2fimYQZxdLvZdUZn91PJB9F6rOMNyrRWrTSkWfAsHlZgLgHKVoasKv0tISUallXaRkczCpNoTvMdaLsh0OcVjQxCg5GABcrwkZy87A6Iv5A5n2nRrG0OLI2WA+gkLgWkC/GoYPyMtikVpWop7oapDaq4quS6caWBietLClpYeH/YESqmLkC4+xCNWDNHZgCbORu0b0KDeyktcyji33FtWGG1GtU3bjmPpRyPqyOHYeSceWw53I9V4Bha8EYTfi0Pe79gv/z+d3+x+dNQRYASmD60JcGZXqqppOmjRAFAojCDkfJ8d0IlsYSJyOMkAza9111EQzKtW0a8y7zphWGKhceT1deOWiWlq5GMTK08CDvmTkcwAain70PUdOS7GAVULAhd2HdkZWzsKWaqv6WD71wk9vvji/bS9Mp5fo46xWSav9D8j/0gS5PRHnzs1uvP7cTQ86++AHX/j8z7/w4Aefu/7CWWsnDubuy+0t09qZ65d9WHbZ19U2GLDBJ0hksok8GHeHiah1tfMReULIvHAJucTnZrkXofloE0ckkeCCTC4PLi5SrIOfv/E1D3/Kc/96M1avTvu+LwozuX3+7MKt5sPCpRAJjlWmsjWFXi65WBQxGGWi9F6VtB48Nmh6WMKsnKqtGBNq4ChAJwOVmGx1M6R8sNxf+aidzHWlozYhCxfEwFZUa98Nscavh4lYY+H5GsABD0j9hiCO7xht2kvC3jj3b1V2qadPivI0UfUBuncKELZp5KRK01p3lWIxAOVMGirRcwo6ctRL0Vlg7dZy8bY4geHchbqFYD3hV1GnMf8K6RJG5XLMs4yzKDHS9cyaoH/qlCCUbKIk9Gxipl6dRlmz3mzTJdjSrvJOj5WqlHQxYQBEnhD5HeSRwxLJYiobUuy1CoKKV2PZZEBMZ723DYQ9LZ+Zd35R1gK/nqfrSFey27sqZSd8smli2kzk+1F7++u+clh+XOe5Sb1yXXJemzg10latEENKQ79cNmqKGmuAyHxo01oKSVBFkgrFE0QU/oFm8UcMsSCsg/PqTMiapTFnMEI32895znvodY/87scG7Fw1j1OGrLlw+dg6UpbYKwrjYWqZOha1WuXU7/38TxzLZ5+de7Dd+/sAna+J1srlZRiw//c5L/fF7fP5h26et3/1EUKr589Pr79udu5s/eAHnnnIQ87PpuKRj/yC2eystAfDwcf7FJ2YeDfUIUxl2ajB7eVTjnxo3lmsFfg3j24LnFEbUFGTg1aGd1qZdUpgqgfucBUDgQCbZB9C/yuv/EJhr3vqc353M25PrMmnf34vo9lSeqb34zKYpDTdDyOg0k/gyCutp7X1YLfCs00LcAlGsVUWHADgMqbRBrfXhRA9hYIQWoWdFGRZu9Xcu9hGeX7rXBvtmVjLPRcWKxPE1mSnC8658Elb8loJC7QBmG1k8FI0AUIfKI46tsRztgTPq5wb+lj0xjQamXeGGos0ZmHbSs0asVXl3irFIje9FV0rVnUiiBkM0q5dhTnBLHplRndn7Da1OJQFkJYPY0CHZ66NXAvKyrJ9ceVGPPTOZafZoKTmYJnVXuV0WxovnSXwKmedcHD9i7IDpb+i4KH0d8LyRIg5QI6aCUyK7Wop2NjUgFzL07hoKXLyXW0UCU7VZy65oMxyRYdHMyxdRIFrkbBGSg3rAOpTWcdwM+LvH+1Nr/hC3324Nf1ESxU97ZW0/xmZm0pbA1Us54YhDEkZOQaxgpXSY6kmSakk9w2nMDSXcGjBXlxFGjMJq+smiAm98TAILaai2fq+Z/9Z+e1/8avvaZ7wNDZEoC0GjutF9A3qATxmay1X0CUINIY7+g+nlwQXh+P6+KraSlB1pXfFMUTMddXWdPXDahWZMEEwcrl0e1247dL+P9xyMGnEmR1z041bD3zgmcmZBz7nfwZF9Y2v+OIhDkOcDX2aJl+jujyUY6uSczqU9FyThePhKXBJNEmB0JKihRxyEbEV2tO/goiQ0ga2pNlJ3cfQuTj0/S++8tH/9Q/+wWb0nkBrn/VFK5Pq6cRXYik67we4tSlljNbWGouYbXB+2fU4Cte64nMtwDv2iFKMUCnCoxd1IlSgSksL1w8NW9TxkD43qh5EXOzPfb+47uwNH3npb9Lbft33Pe6WP/zb+a17vk+f1ja1DCLwE5DoBbSrDKqkQjy2Y7Sa9gfv25S3CRxDQIG1vVCCiHJDQs2EX6dVWlnd1XGwhAaVTmpV5dVML+u8qiR9c1mXuuGSdS0oluXHGAyzkzOmPG9CmVDpoEcnaHXUWTePVgWFxuTk2COjVB6/0s7wir5SO23eWmYPYKvhWy1kk6B3B0IUaDwgv7L9NTK7CRolTFgWm43vWs3CsiwNH3AVA4wNhD01TbGtPC2TXQ7W1G4tBFtYsDaPGaFiPc3K0yjTrDaj/lpvb3ndV7vuY8nf1uq+1clCbgdWsLSKW9qGPZ/VicageNOWEq7I7gBgxivLMpIqpBADrwjSMnnAsDIrS9YkTTvrIAm/tlmdkdY87cV/LMTeJy8ualuomUC1FtdgCG1YYUqyhU9EbUY0ir7MdQ41NC+9PD4I2x/sEdaobT1ppwcHBwmWmAYlIdqIsYom8zkktGj9Kq+GdOnA33rb7u273a++fyyxesoL/4r/f+lXX/EoEXddXuk8jN5AMlCXJpSvRBBcOYfNXrV8XMq/IQs+HeW0HUos8fqiJsQ7Psx5QZnNyYMIpAaIGIS9N7/6q5/8vA9shvGVaw970dfcNuwtq6xbs5J+Hp0RAfztYhcMzWKc3tMfH6INMBNG/hVMGyDXmi3dIFYIsrcaXFAxVk2zVbeQGO4dwkUX4KIsdWPr83V12y98KIvbbhZ/Wy7g/T/37tj1YUGRG41GffRoLMs1gGWnNy50gDAWIr+Ytmdbx9UJgQIoARGRVlTCOzhuCbB+tDLO4Wy2punt5NSmHo66CiIMWfQ2L1dp1eSukl0tFo1aNmrexlVN6FYMVYZQl1JRslMWy3uJkasoI2T4WISL6bOjdfTI82X2wchXZcndy9Ji0JFdVXp3Gy4MvhX9RFFonOrkbRxA4U2Eb3ecBpZlooJO0q4jgVz68DD3+6kpvHUEumn3XZwq86e/WZixFMdAshsaIBKZug2EPTUNNCPw71AoQ8sRLTE975bmkyRaOBEbcW9BZNSPfWF8zys2s+JabW97/aPC8DErL1a2b5VrCF65QLdfZzachBg/kvZcSN9Uuk5goMVDk3bOvMIbnUBngmJqnVmtNSHRomFyg20CZL8oZ9/xw38vxMc+05UkuSMV7biEUtl6k8s5EuhxGIgh+Ay7IxsS/ci39AWtQuo4D/wIXtiq2pptH+wtkAQioGhU0jYV90wknjVsw3QpgYy9Wy36FBef96lv9d0v/EN6/s8vf0QSK9Re50BRQQSKpf3aG9Sjh7IR8zHqeh2F3naVU9lXy+pLW7sfoQo0jBx89Wg7FlWlq4lJQ1p6F37t5V/yHS/a+HhdkXbd077oH3dvkecm1U57ELu563oZp4QkrRrjfwo73JCYmmnZ7M3y8XQZUyzOryyOuTJ01GlMCUszy2SrglYernayoyBPz5rJrJl9+CWfnhni7jyoE4087cexejn5Ko7kICXjV8BXaL+5rens2GCBhSerheSAEb23bNtAE9RqGbymQTsJYjBicMibegXHcpNSb/LCxhXjV4KtizbPJ3k6kYtGzBvRVzI0YrAZ/0SjNiPyEU8RJWFiW75skLJOuIRSEynSEZ0DdjFZJ2XoeV7nZOVQq87JrTZFC/zqZHSoFaVnNtlzqsZFMqphc3UAYS3uelHJm0qv+36m9dPdrNEsEqYzYGWhNBKHbxuD2dPTKiM9dCQ8rbExhzB2RFqvhGMFTuZzmoQ1F6x35zclXddse8/PPMoPd1ZioZWrRLIqGYCmIMZyC/ZhReGU5mNumKL3rtM2VlUjTZVS7gbvUyRgR+jPVJOsaoKYQ5A+iIAtppKmsba2tnnCD/zxXcVX3/DsmJsIwYEio6OYRVAYtUxtAR0BmxuNXUUAwXvlfaPVMcr61baOLrhVb6Um9M5l4Im20ShGHawEiYToYjZFPkFKa3Q6uEVt3/Rp3/AxL/pLen7XSx8d00rklVKD0Y7eXGiPqusYinydGo0PTFF2yNAm40T2EZ/LQqtQfIRqwd6gLXuABVKkqdx72b/tpV9Qt9uP/YE/2YzqY2wPesYj7uj3exujW6bV4CvRTpq61TaEOHTsAsN3B+M010LC3QouxKo22hiaUtnRBBk8CqHYlD35uG3axjR+sbq4vyc6Vwt1ZrK1+LkP0dvd8ZmvZFZNtdUHPhACu5xsOJKIlaPDFhsgp1TW9bZpcjyeME+1kyxWOeCsn1aIGlzfnCi+zb7i+pjx5C4WXinMOUwWEy8bGp2O+kESVO06sVilZSvnDGHpsWrzshadFTTrPET3JCRKFFYd5F+p39SISj8JRyIxzHJYBcUexa/UMQP9Swp7KUawogPFIrsshqycylEbN89xnvo+T72aeIqYQeOXOD+S47qT02bwXwPtU4MNjiQjjzElGvs/3f5HGwh7alprJS3CFILaeuKRWGN1+pFjlDnklVwyM2qvJ2m0IjgSJ5upcM21d77+YYSBUn+zip3JPe0ElWKzxsTu5JAaqMbD82JbA11LA0JoNhGDRLIfJsSwAjRwGi0nQk1cNCHqIYEGECnCNZPv+KE//VyuZ0HAeNrmXEs+kFVCqcs1HBnGPdJYJHhxDk9QQBFsG8J2Ve8dX59MqmZvudcvYTNkjXUeCp7ScrFOLiXLcCUUFAWy15gBm0od9OHM9l297eNfDK7qW1/x1T7tB7mkpRPkWvqUyBzRNOPjLLjOWgVbZ1aG106ontNP7FcPr08+Nx2VmwUMbFHBMwjBRkixT2kZ0947XvFPvuWFf7cZ3sczHr7n8w7kYM60RvlBBocUHqKbiNotjAg+qIKECxffFZClwDuhuwXjYmQJVJQ22+JrQf/Y6FZ5lQZPaLBNzdkz5/df/6cLcdtnvZiw9BG+V5fzSvJTUk9w2KK5Q3As5IAiq3Rc+JXaj33og/9X/QUpsIBqYNgH54Y09F7Xtvjj4AIhjMtOuTHbgFCvGhjUKhFNHqzsCcjWeb/OB43Ya8XeNNLzvJXUMUMthwYnP5gW0NUCdRhy06wYEFnDNclSQc59Dmte7FlGHMWvgkvr6E3SSoMaN0DMRPSaljkVaJlrjW9jr12/EturfEZCzrZOYERR2GihqUUfK23IsNcEfj0iaYioJAed+gzKG41JVddiOK2f7n4JYSuTO1o+AwhZJaskWXB+lCwpBKNcCEbFDl7oaiMNe0221H9U4SQObuG6fJF444UkamQT1FLvSyPFlK0DpVoq2no72QNCWNlHcDdNbWwdQV2tBl91QQcYZ05UPfuuF/z+5349LtUSigRVFEHlsE49Xs5BVpys5GNZGFcK1yvv9t57nBQXQtw4f2VvOnjIsnbYCBiKjDzSwbRzj4aU2B0JVnTpzOfw5t/2QtBVf/0Nj3bhTgdbJqtx3CqMNAZ1PiiZBuBJRe2nUDWyGhdiU9As5isrmJWzU6bQJrpWeqOYB8g5h/TOV3/VE573+5sRfi/b9JkPD9LrrUZWcIACuKE/tR1ydEvnUpxqixBmVGWFNlbRnUBhVkzBheQdzY1JMzXWOhe75YoCoKau8jKELl2Yntn9mQ/sf+5J0ILjVPGG/ZTkklwLNDOTQOC4HAnSY140CEn7UXnRQHURfDOgSOBqpWPKmg9MMpRsa4LsWEhEwzquvJaAY0DQobdih1Bsk2ctRK/qqagmyrjcTVQfZF+LjPMgHLlEMDNonoA27nn0O7Cb0hrIlv1LOKb6HMnUcoANjTLRaTFwv3mjIkXltUgTGW3sRIwWCl804aa92Bog2VexoIEofmB5Qxc4rdhV5k8b5fGdTVh2vZKOxk5dbSDsaWoffctL1Ne/qFjPJ5SGHBVEu6y3x1RopNmwaCsT5SYavdbaO17xYBs+isQmu6JLpg2wMSULUyD/YEaWJjAbaw7wmp5yqCobzNSjekswAGuzapOwPlcumaCabLa+6+5boSrb4BCvnOGxJyREx/FLIzSpJGivGIkpAkxYwgcLLVbH2y11Qztyz/LntEEHnDqiiCoUF8qiOidRUAXhc9RfpRRgFnI3tronPgsZ2Te/9hEx7ItUV+jeRMGiKjIgMSeoMHn2NCtVO7m4IMiizrWWNBhpDTCN12WCon4Ikmb9cnHrW//d13/bC963Gef3rD3gxV972+LOuXK6NcEghB8QsxhDuExrA9dTsEiKLhTUq4q60yjQiky5G1Ic0s5suzFN6EPf9xRatKq1FBr1Ymp37nz9+3fvziWt7twP4IVydCOFvJxWGMuYSr4pH93E0/ELIkapPQ/5mhOWGLt0LdZE5vhENcLskihmT9eSDGGyDKDueEU6icZx9WLMdkjbnTjbivlSLNu8nOSu1r5Og1XLWrVT3dk84M3lQNhXS6MzdUXgTSp84o6eLm9m+eh3aLNzPJlgiS1BlkpZddFEk70VXqctA3mE6ZAnMTXyrgDQpp0WFPsZwzAJzbmoxMBGJKf3E5r7543lmBNpNto0UZUzbokctrKxSxoTsesDMqk3EPYaa2/6yYeacBuOM3ESKFm+kXdCJFSMSIElBzi1hMVcjXsRQCSUZwKqg1HoRT8MycRkM+xe2yRbUU2f8rw/vIdLTtVEeUhsLQcC5QwUxBbOeHp2r030m63yDtTS7njzJNOZUgYKVgRCYOqhosbm61ApzT6gqBBhfC+RZjKJybH3YKN78g+AI/ur/+6Lk3BR+oCEdzkvDYnd8RTjVzV6m/EELPIPeaQBQgSiHCvTbi6VxVFpER2lq74zruR7XvOoxz73Dzej/e62G/7F1926uHNlQ7ZS2hTheIqzeaUhJgd+d5aNqQnGBRT7qSI1oMrhVWbPKJwSCK1VJWsdje9cWAx0S9vWnN05c8tL3tvf/avany+LcEWUl0tvi27yodHbIXrLbMqFTc7Y4+0cVVUxee/jFPNfBYbJpq5xxK/zoTuAXD8KdVsyTxZej7JYQkJ4bwLTV9n6vCVh0LVCsZc4mOT5JIEgS49a1q0ekppXebCC8Ct9Gg1ia9HQkmFtQZbWfcJmkyWM4ATtujA9iNxLin0ha0CbX68U/Jqz8TYHw4WWzDQHC91Rp8IN12xqtq7Btt7llAxG9s63tT29H+Z+CmGtVt1o3VlqSNZh8Ro3lBxYScdKTvLQBqkf+9z4ntdsZsBpb2951dcMq10VDyqd6lzLy3tfZLYn7y8QwxpPRwFdS70KzNoS6/TIIdRZ1spUxujg6SE9OLK1bc58y7Puoevp5Nv+l26lGaRB0kZJrhVF9oYGaWB4QHAZKd8R1yoDBQRl/bH2z3LQUiOUg4EASsoVtG9ZPUyC/VgosalI1APeF7krJS/uri6cu9uM8e9+ARS43vGar3T+YIhLnaJRyUAmVBXwiiwXuBqyEC1LIpZFIIpaLtTf+bA4sZkRcnR07yrTh3TJrfyvv+Khpr3w2Gf9zmbkf64xzDMf+ZE7bq7OTUVFI96z5JLwmiIETQGG8zH6QMO+tbXTeeX7HoraotwfNZqgwiRrazJNMd9xyx0U/pydnjk/PUdvtnjDH3b39MJ6kL8+OVaSo03Gke8wQzrFqBBhysnkmKsYqukkqZUPFMPWsEWGSkiq2sYHisRiQc/ychqsMB4I3bIAlxj1orH7hjFrTe9kBcT2KjhyUUAs6iCaIfcrsapkO01LoU0jOgNxLlMjUIP7qxU9GOKyJNVwYbw8iUPfO063hTwWufHxkRi4VFLxqYeulJyiZpLWER0hZWcRD7LPbMpNwoomP0Nsinfd1HqdRgBbeNJscUxf+xT/x5tPcfHr/RTC1pXBPkyRZgoRmQXNtedibUKd1mJ7stKjf3fWJsZNQHrq29te+3XD8nYj5q2ONtMuYqFOI9njBgn3yLw+mMRCzzXj8A9YSbIyI8UyYmCbdxtiDsoa6F3aTJt7VVV6SlDpm7/vnkOlg+VC1Gcj2LiBpSGjYd5fLjsgXDIJwtKVVTk6NjyocjJVNfHH3UtStQEnpeA1InxjMipjSanGnSvxMSV4qPCyg8NP3lvOL5x7yD37jd/y3A++89Vf61MKdDuUNzqhlhuWQQCpY3qpxJly7THP0CWtJyzX28HYl/ULwqS2Ife99261dGH49df/syc+e4NiP3u7/jlfMScgY80tq71msjWZzbrQK0NoBxWL2bkYgdNokMbkUVXI5+IORxkUcqDMiYcK7En3F4vs4gNveKDyot+d0z9c/fQf35tra7e2QdKm24zBOSb+86GIzGGWFBCWcGGwxlLbObNzvF30Y7d+8P/VX9gPXk2mEvnY1EdfV7NEHQJoKAU7BejxoABp0cikVa9Y3Yagb+YvMrMeFCy+VI5sqQMQquBrIlqXg87OiDu93hVOTKSt8KCogkn5goe6jLqcjoy+IYqJ6oUFN+7xeczRCjmeJGr4OEvCsiuTVS1VVCZAcAQqgHzIBEUF9sKro1CbTe/UtlHHOx1V18qHQBbSdkqEQ2vmDYQ9TVlYQrADykMTdF9tSe5EFmIpJz9c3ZkCyPmWa0WsthVFqhsywalub33dN2R/R1v1JvsK8t5RRPBOU4GwOIwuzAHFsapmLmxh1wXAN846JuWRdcw7Lk062mGUUWZiJ+e++Rl/JNYa7PesxRyrpk6jqnhab0KXF5gInij9xMQUUDUCHqpYvvvlx99TysYYD49A2YVwPNMfiRV8eexJBrlbDQeIGNy9Kgp4wvMgBfru1z8yxwOXlj4MIFziV4NhUKCzOgQtku1HVCqXlFiwl+uzZTnLrU2upRfJxdAPqCKSb3vD1z/pWRtq7F3i16c/4tJqL+3UZqvZ0TZVqguDS4EQ1QBXjVgh5Fd1W9MQdJ6wbZIWtmkVUzgioBg8nwhbxSQa3Rgrhv1+y7ThZ//qXnqwy3o7iH0XAp9SpHUuSRxmPA+BLOqrEmTWqkoSiJ3NZjEcswF8sHqQTliQ5z2hWLoqrYqSq1hLe+GS1kRcOEtnOM1B7USwpytsXYt7B0K0IimQWZCLQusmKk+DlzVisfHQJHMgFaxqVTnCmsrSL0z4B87IZNhM60gyel2XzKCWHSVA9y9LWSHl8hweStfVWVP3EJD12YQs14hX93ni8KNDOdpPSHYf4RyPWrwbsHvyIPXIDrG+C6PXcvm6aLeUisa1hvJIzubIB7Iwpzqbfj+FsLe//SXpn/2AzucMDnOMF03NyJV3RbAaDXOdNQWisGaHCIxqZt1qOd1MmlPbfu01Xx27m63Yg8Wj8kZ1QseAxZpXdSQpjGLh1eIHW5J7XJeiIuEiZbOk3bnJsvVytjds9eKcspOnvugvhLgoxEfu/RVGipiQ90y66ALBiR1y4xJ13oJd5nFQqGSL6gvhVepkmF+RdcHQ/pVo++dcLBKuakzzrMlxOZdlMnPgR51GrzT6GDhVj3s29ad406seFf1eI3ZbuWdpd+W5yRw/yNXTzg4tEYi7B04swAcKpu4JUFuUahoPgqxVYlIRblgFcTEP/l0//ZWP//4PbubCp23n//uHXXQHoQb+MbqZ1GYeOhlDU2kFzitEtJGChU4cqpgSfVeLAF+JoHVda00wK7pkvJxko7yQK2+TefC5Gz/00nfe+8vbu3hbcMu6st4HUEfEYbFROrqjM6FkLKaKgbBrOHb8Sm1uYlWpFQ08NxitzjazuBp0LFVlTMXmFYSjKelZugP2yExcUyyxAUYsI8kCGEEbTrlC58LEBFodHtMda1MkZBlmvRisHCp5MFH7Xb40k7sobZOLGjV1QaP4kTYrVZQQ+PfSPTJ5HfThmLEU3hXhHUSfQUnkfmvof9Ev0szK8SatrFwRcF6KZoWSdfq+DUx+j4UYwf+csLsYib8lthxzwGte8ulO7p2GpsZKwULq4nyrQmiEgZcK800UB+Og1mw5dmLjxL3ShHy8CvJ0g0Bz/739sRfRa4ppYarX0EYc4E5C+DWwyg9cEpNUfVQBRANtq3bobP3455l3vXozeU5de9tPfbVf3qzjrqHdBzrfBIN80ikYWtk15EgT4Veti5VBOXVDOicAvCJBq5KsPZ8GRjEbxNZCnnPVA57xgvce1xVuP+VfLg+8Tz5rw6flkPFSUJji9A5D6VTSjLmCI32kodmZvLwS3TWbTg7295SiXwQ5dHh0yk8X/h+ChgjOQV3XQwi1OYZV5TufjxqsX3vFQ1PyPjsFGwcU2Qnsyl4Ix3LOtD4PLCvCAhLCYItOWkfDDvGD0N7qbAzt0WmAy9gq9d27f/oRj/v+v9zMiE9q0+c9bDcOatpYMCx9TtSxSgfnU2yhuSHqDGHeRKCHNUkJkAUtCb9G2JJKxo2pyaqm4RqEcbl2epraO/79Bz8kjscvbT6/FH3f1hZYOrEg7egBfjgUZRmQhLM11myaItE7fyW6a2HSxOZVjsq7Ruutpt3d36XpovUIFRhGlFOMImuD/Ksec2Mj7Mjj9Y7FX4atzBGUhTUK5j+VF20fz9XZWepwvT/Lu32aeaUTjo3ofYaKB74s4gsspMNmKBp/B0FOltq2yz4FOTAPcpBckMnCIkjY0CtM8vS5KtHXslJ5h8BrznQBRmODtIC5/GEUOLWg+TAWT/zeTNkXpbKvOHxt2pVOweqRJSLTqLyIfLwOxYNnrHKkuw7bOI7rNcf7mu3XVKrgWVM3wp/iTrj/QthpXS2Cs+2W45lGN7Fel5CyC5EoWvYEX2P5G8IWM4RkNlPntLW3/8xjwupmhVKhQUkPUcUELgA8rWRRNx0XdphFFd3wLNnuFOVMUZqA8zTlaM/I2lNgk6dP+5G/EeJvjvEiYV2UpGaMymmS4mwsD7looSRACSnEWHExYvCD1TJegR6btG2EJnw0BuXmEYAhfyaJloRXQkmenhfzRX32zHFdxne88G/f9coHZb9y8O6M1P2j5awMrEUAzmXORaaI7xb4gZFVt2hJpw4jZF2kjbTG2TJ1cR/9/F0//ejHf/8fbObF5b3waQ/eGw6mOzvtbBIVAcVF73slCQRKq3RHnS/hGWspODHc5yzDkXKwCUakTTONCxeGQeWm1Y2ifu786j/85fGKvQXvCWT1fYfLkiX5Kj+TahBKlazthySvjPn7T6w+/H+IB0FyFvGv9JiLzpgais2Ft50uH6znEVl+8lH7p2Yp5RrVsqTt+M1KyaYILETwn5pOzZR0MgNEJmG8aoSe1HJlxMrmAiAVq/MyCZLiPxydGCjwjIyAUCwSxqMMyYJosN9DbQDLLVNkkq3aCv6OlctBtSJPwM1XKhZqLzPQGRdjQVKsQQnlkrzWXthMqZPLxZWhlDnpzmUDRa27DLBPFvVlWWJsNImP9bLRk+2pWGwg7Clss2m77wY7QxFon5MdpXtQ21zM+iKf8dAGvpYCzZWxfhU2k+Z0tV951Td1iztUXJg8GAmNIA24U3TxLEMfzQ7vdOdVYkUCrgqC6A1K/rXJqGNRfYDma5BW6Oa7f/hDx36dfe9ot9LKsJqXiuvNuWRWLgNZiLW7hnVjh6Hfrm13xbouhNC2LYpjcIL8GQlThWdlDHWtXCyW548PwlLT9oaQ9qNfxtzhcEyiwNqCdknbrVI0ffl+gW6BwstydDbw/k+xStQsgaZl0DgLRTVcTJ3z8ze+6uue8vz3b2YHtYe+4Bs+0t8qauqfsByWBMiUhujOwO6ERskw7n0FHilVhIFBu9F1OzFttXvbnat5N1XVkGXse7kI9S9/7Jg3Kms1yAp113U0JumWx89suIVro1cbk/v+n3zRF16hfktKDtCogg0s8DwXSowGIIdPI264V5iOCQnaonBDBLin5NrJKVw8og6ydWIni61W7LfqoJU9LXMqcbibWTckF/IP13ytjdPB0c2QmGXhyCYlxRXLVea1EZVlKps061W1QBaPEDNrKWTDXAHNQJZiRITRbMEWOayhaRYjx5QbKdmTij0LlSAX+8g1ikVSlvP4GAKFPMKpkMTEaOZnI1XTB5+nk//tlj891V1w/4Wwd77t5f6fP79CWWvS43xUayVOUSpZkJHNSC/RiAjOtxaMoO2nvPjgjS/dzJ7T0uKwa8XCyqHGATxAqxHscJW0TkZKi4O+cUGAZhZqrfnwJUmIoqJeWBqXKp+boGaq2n7SC46fTHnT9/zYh29fSAPQjLRGqZ2Q8lC8PY0FGhmH5dCshfNR9kP3Wz9zhfqtoAQE7PKzbEiw8CKoQ/9Tauj7472MxzwH6dL3vu6rvLskwzyIBQJK6DNQXyUclUJCi66SFUBBJy6AgW6l5xeWRAXcRlmKLILVmbqQ9zdTg9oXPf1rb9m9fevBZ1eqX64oAFnJSlfTpqppaUS1DwHVVjUBxfY5xWBg5UGdCde2WlnRhcX+Unfxptl57UU8cK2owi//w7Ff53w+19wS6rTiXRtu0cukUp/1ZfcWPlTV4GNggRLYXTV1cfdAulIc5yk6FHbZyLa4SDbw5kKWtw6gNM1cXoQ4m8p2S9okl7VcVGrQwoGtikSMBAmKTyNGJQ9RJJchkcf1ZhTKdzjIkCsGPPQdp8G1n6yk2aK+FKEjvAPoy71Ps4ynEhPkcUkUb6uiUHKonZ7Fhgh75du62ldmeQTFMiM2pU94zSh0l0dRQtr+aEYvos9mdto74f59Ku57emiI4wX2mh1veyqUnlItiriS9ThDUJXVVTtfrDaT59SkYF/+5Sru1VjYe6tCheJdyQdhYA9xFbtkif7RPRW1QDTPNY0EC1UZKTxkncSQ62i2TXXDk57/G1fiOherAUfxKIfSESlYxXoIan0qty45JfxN2CGzwldy8oqQCMb28Ic97O8+9CEa9kyRu6sNSYF2qEFAhJJSEQc95g3sm58Dq9j//FNfGgft/FyxuQJkIVSAhhYoeUoUeYTRHYkNQAXMfxUyEgnXxvccXBFBva1/6WX/9Ht+6E/vz7PjS1/8xA/f8rGF6p1TuVUJVE7FhhU4KA6gXwjkM40OLnCFEdcHcKLHaEM/SX2yi3j97BzNkND7B2xfd9tLr4ip78HBQQmo6HkY3F1jU2MMvWAYBrrCKwggatuHMBhVdK6UtRkk1hKAHmcaEif9KPTMVeRUKFj58Kf1XfY6b/d50YXZTDXOVEEcTKWdwgfBKrXUFLHHyJQo1lAaEaaX66gY5/+SLb7AbWXbCIr8xADjA1FvQ92O4LOzKWi4TEtU9IlGqzqwW+BI0kiHx9lc/L520tu0k0Cxh/hVlY7PvFqnI0OQV0ouWlDFRw52PI4gbHBNVW0g7CluVonoelm1Fer3Is/DNSuST8owpWnZVLHC2o1iPls1/WpVb6bOaWi/+JNfouOlRq8qiIIPlXQme5VdKQDCkg5JU1OcY8dUHVsYcOKdgI4lBNQF4ZJOqq2aG5703N+4QpfauSiVEbqBPZwoel7jaFwT6cY9G0UXKcjoVPRVpa9oB8K7jgmI0JW7i1ws/ySGWMyQ5vPFztYVke54zDP/7J0/9QifkwpMWQahi+JPd0R/nc1mUaaS1moJOG9VkJhIVo/Lec4+qiGl/f/4sn/6vfdXFPuwH37crQcXY0NgSHXdgbWNtMrYKqCgkS1+0b3MoUyKuZWygtsEfzcWI2BZZ9PkplkRnPLXz87+40s/cEVSDSF0Xcf8nqS1ZlbXZxm3kdvZM2euYA/WdlgFr6AppjH4xVhgtqa9HieKy5KFZqEXW43aSCzCpcT2UizaNFuJ2iUbZBVkqeNYVNJrqFhn7F3Ix8SRXSuPPvsiSoc1EWwDilt6nFbJmuAvfTZRUSwfLKo5ZciGIhgW/tUJAtp59HkqmT8E1Hk81N5sPieCXwt4XQPUvNa0l2BQSciLc+0E6OqFQ8JeNMgvZBVF6EX617f80WnvBH3hwoX77QiYPPSrBpq4uhKqYhMgrgjJh2FkYiJBMVCJmkX6Gvrf0D/gy79h9Te/t5lC9+X25lc+Krs7Wt21amnFYHJH+FVmaMECpsJ2MWvUYjCEFWudcQhq6aRVVHVQzSDqPk+92NHtjU9+3pUSxn/AU37kYMjJTnS1FXUdWfakRM7yMn6FIAFIL1idgvBLERbnJnr4uw9cuT5cLBYEYUvGCw5dn2FTLstnynzKCAkyNZtOrtAl/ex/uuO//e7PA4LF0WelWAQ28wmmKka4bAnBj2K7V8wpuN4LBrSqKGIWRVv6/1O//fN+6a233Q8nyMdvcLGSaquRE+m0jwZLYFAEVaE0x7IcuY8RFUMUFsRE88SaamLqmqAuF4PoKLZiteXMwS27wy9+5OD3b75Cl7q7uzsMqJ4nVNo0DQxjebwV243L43D9NcFceiWN2BtvvP7KdeBvrG5/TH1dC3EiKbxn87ziT36IXwvvVNxLbijF2ow9gWJNBFug8rIOIHeD2QaxaKBb5jvKQ2ErrRQXpGaW6E2W2f088vOavo4e1KyjzFJcLEidRwhKX1mha8iiM3MHjgxZx/IZ8YuwW8rxsxWdJjVKickNgj2ZxvcA/gSZ61hHzTRmvhYkIw9VYGVROxfjkijkrs53Gvk+deqPlO/XWVj37teqb36ejE7Co4mWZR0vb8qSOwcnIyl6o3M7mQ6L3cmk0dX0YNlt5s99ub3p1V+Vh49P7bKRQy1WhFx18jI5nsOaaQNKFqnT7MUonShZAwcCFJ62JGn7TCi2Vc25pr7x259xBSOWS/vzKLeNbaOpgKvz4WpziF8Tmx3glJxGY0XxtV9WORy89eVXtBvbFh5dd1E3M26xkHfIdVWtuo4QIszjkUy+UmS4b3/OX7719V8RuzuDdCoji2Qkyq01VIzSehlf0xGxxjO9AQ5rtM4HDTKJQ+W1QeYsOP8fX/nl3/uDf3y/miD5ex8SZJDbVs6soSejF93cJ+/YkY1wCi10ylgVvPPAOZEgrJKon4PPi0iOBf2TWu33ciHCr916Ra+273sD2gLOHKy1ChoZUXzmURlDoBdMpldcxTs2tusjGKJgqlAMlQ7xqzxOGi5r/MGWDzawhqAkCutYJkmlAh9Z/zXD9IsFZ+nb9E0oZ1Xs+qXX7g9sxRQY6GL7T4xc5VjpZTBbgGtRDaZUn9U+dNRQs0Yf0RBujprmWiWhQ1lFmkCYWmpkOh0C17xxOji5xryV0ZApwsRYHMnIjoJtGYK+YmR38TkU/Qtb6aYR3R0bCHu6m4U2jKuzD1k5bIXIdJWSW+Yjosw0BJeUbNrJ/NJFoRpdT7r5cmPTdZ9tv/rKr/LLWxp10FauEisTO5m8okAFR14aHAGRi0Y/lyDw6RdydzrieCX7pF22Xlcrb7PdqWc3PfHpV7Z0/aBzYgILz6xsTIrdbNWReoi8xq8oI8b5j8kp9EZecTW/6y5cGIYBKDbdlX8LVzvLtp10qOUCFWu5WGzPriCA+LZn4/zrHa/+Yh8ONE62PQS8s+R7K48kI3JZ4niXhZSoKl4l7BGfUzQqtabp/aVfec3XPPW595tzlf/m87xJW9edczovwiJEl6R3cWgn7cxq591evyTYst3WFMUMyhtIm2ZOyAYKTqRPaRViiDqbm7bOf/Q/XHF5MhqBVVUVesByuQSX4C7J2fR6mtzTE4GwSxeQvKbIuK4Ja4tCSlrz1znleTiX72F2ksaxZiU5G1WdcvEMlKw2EGlBo1HtcYwvUKvKpTzlmEGwO/RUxNZINQrpZDAHIAWrwabH38M6V8dyE0VIsJxUSCfEnABtLfIEUnWVp99O0ylVQtY0DFymFRP1frFUmpZy+FHRdlSH3bQrn4otbolchyc5ADnipna5hEsWUTUUBRYjvUrLWStOfy7u/o7EVBiU620cRHTBrdjoL668G1Ksq4o1OGnWagr9aRuvq6br/OBS0u35J//oZvbcF/Ovr/tGGS7Vumu1QwlX7nUaTPZaQHUJOaQxFtUop8VRWkoqR0VrvA6yiWI7yLMu76zctmkf9OTnfuxK49cbvvNFtA8JU0kDwwIkCg8J2Ws5ybWkEW080PCpVUjD0uqTyHJYFKmUU8eseG9jXdpYLLuYZQOOAXWsD54mj4bMbtrbP4l6/2953l8FNQu6CbS36jrbJus2ydaneiCMhlXdiFFuAqGLgfRP0ikZwh5aNNrDpE3SCDkI3Z1vfP033R8myNnnPNLLqLfrVMtBR6dCJBBkCdenkDytfkqr1lZgSQ7eu2CgrEqjs6qFraPWXphBmKDO2a0Hn33AR191xfHrbbffTuPNOVp202QygVuB94FPBlCWwgVepXahhCk8RDFmt7a2rvS1/e+3/tGloXNaTM+eWQ1D5mP0wwfQA5/08kPe4yJ98ASQfGXkKgrNmxkzbD/L1oIU+xLEFM0qTxZh+yCcveTP7/ob7gxnD/IOBchBNZgh2ghli3c1v4lmqxTFrgoVs5fKalMWRi/ToPPK5mUl5hM539IH22Z/yx5M5EGTO9jD8NTKyMjalE2pgFalVnbDiL3y6HUsQkZatfhJAp+uYati+UidIWehC7kEoZB2IVIYI5rm39zxF9cChLu/j4L3/XudnAyDjEMOg0a9OozVUbplLDQQRbYGTi/eR1M1vU8uamkbioc3U+i+1v7Tax6Xh12rllPjWk3IdaVTZ2C3BvyqBSv+XtYZFxHmWzGgOkUFZV2uh9QOcRbEuaSu/9Zn/dUJXPOlZa/rWYZ7AjLBGen/4l69TuTI0Xdds4hNY7LOXiUX3v2aE7i8uq4TGlfQFNcd/lsB2MVtUjK09c6v7Q/AJfjYLR8/gcvTk3Oy3k62pdvnBT0MtHtzk+gBq3mkJ3JZ1rFTF+2CQFO+kh4P2qDFysiVzgepv/j2n3n8tT1BbvzBr9jzS7PTVlt1L5wTbiCIWmFsaQth3QDBtuQVPE4peo94EDQRU1PX2Wgva6/abGe5umF2/uafeN8JXHPPMm3sxpXXARXX2gK5qcLUPJrhXP+M0O1JaHgvVeopNGqqIbhcNFgZTY/x8mVGwT0POMFpowWCFikWK0H2lw1FYy6i0UJLRei29nLi8laXzizSuYN4/V68cTedPwjTVZoEOYmqIqATIc01GihkltoC0GErLxZlKonUKKLP0QsoHvQmL2q538r9qdrb0nhM1UEDGwXPUXQpMiNkzLQE4OMk84ZEcJIolqnMiEDASI4gVGmuToBaC0FYrWmWJ1eKILWDQloSdXVt9MDGakrUiibrIBmnogJTGQuXP0gR0IrpSk0XL4eZ8xEMfUTn46br7nPzOV7SeV4rwiXeCAfya4o6r00d4RwO+gB70MAQMSkF6h9mNrbpIdV9bIKequbCk5//OydzzUuX6p3tOe0GzguCEMYoqGPkglkPubCaC9CUyLWRctVPqxMKPre2ti5dugSXedrwRo8uFEZx4pXNfURxQx81E0IIdVO3thmG4QQu74nPeP97f/6f06I8dCnEnkC0lZlCTGNpftIW3ImSfgC5uEQCbIcp2KkhQ13GEvygDVvSAr8Sbvcanh1f/KPf+OGLNyeT7cSK2jg3DARCJKR1e+8a6rOmojvc0bddjJUxFLKjq7IKspLwY5YOik5TVbeT5sP/9jdP4JoP5nPnXGERFH0MBrJGytFPkw/QFRcowWhKsS4AvbI6KbUgtTNdHfT7Q0ebxVgcnriK6/gcVjm7VgrNmei6Nl4S65r0Q3xM47yOYuKF6GSb5bbPweZFRaDGxloO7KwVdK7p7qNuj6AqcA9XLst1QivLtXws+COsEQvbLiEPuACSImzjFUWK2odqSIbTw5bpd2I0zi3GMPKyd+6mXcE2Bkg8H3JhyI0/SMl535qGVmoKRUEPD7Q0ykGpXuTYNtfG599QOsXEShmGSqYaaYisjdTW0NLoWCRIc0FzwOkp6p61qYVtoqxWIZvHvXjTe/ed9pZXPVqFS1bMK9FXykHbm4BXGi1zSgqRK3fNaGFCq7nSQeuojRN2SLYL7ZC3k7nhSSeFX81jnjlE0cx2aNh1IfTRCwt36zSSXwv/lVBHLosUDcbGyOhXW5MT2qG1UnVdjzKcbIRVgILCzGBDOxYiiCmWl0TWkW2ahtDGnXsnQSf45qf/lm6vi3a7T00XaVdtk9qS9dmsmyiwe8dCJcaeGsEVAyksiOAlFJ99JUOjU6tiJbvs99/+6i+7VifIR++8dZBe1ipaEWQwldaW8GsaSrkeTpwUfZ1p4Yu51rZRlcXRs65Utdw9sNluyUbSwnfg/+Hl7zuZa76dWQQVNxpqBGcFy76CLUC7cgh8OIDgCuRceBmIwjE4ARZBaS+54687mfe6pa4tEHUc1eNlOs5MG819DdYqGFGDSr3OMC+AQRcf+mdWBeXNnGLx1okzQ75ukR60L67fzzuXws4ibS3FrJetI4yrrFBGmkIa91KWB1f5lOTsyCQPfGwB4wMjwSVo5f5EXZrSQ1yayv1WLKxY0ZWYHBjsZpZjy8xDyBtrgxNAr+t4Ro7nTXkUVONKP9AgAzOTISusEIrS7Vay13opxYs+8rsbCHuNtN13vMqmUGlB4DWEwUdvlbTG0NY8BE97Mwer4FglqZOimW8j7JpUt8nD3mfaO1/3aOl3TaKNtrO0yOdepaSxtBb8aiBlmOEBDhoY8kqou3Aie0kotvWyWYU66K1q9sAnv+i3Tuyy5zSM7CQRlKhbaUyC47pkNT9wBgpn7bJ9IFhxIQen/HBue3piF3mGxTVZVIuXSylLSqyIJhNuAHYAmGAfL1lUfAAt9i7tncwVPu77fqfdeqCd3iCqc0FteUU3tA2qYQEim0D/o5mbykovwSUASVbnbEWuhKqVqFSoIFuxEH7vza+4BlGs/d7PJ4Qu20q3hEszrJtgT4fsNC13VVVHHw6Wq9gN4FBpa6UltB99El2QfXzghZt0F/rd1Q3TC7f//Mkp6SY+CpMFpK7FMdbkbGa+soRWUXwrtBa4yoXwgBtvPLmLrMzCDcpW4yUwnhTHl4GUfBDIE4tWtBgBLrG0sbo1YrI1MQoZOBrrTRAzJ8524vp5uv5A3DCXO7tha89vreS2N7NktMvIqdNE1nY8pRj9Dli3T8ryAGIWiUCzN6Kv5LwWBxOxP5WEYvdmBGH1XpMXtegq6SoRzOWlqgS7m13pJFCsKjn/NJZwHUn9K63qphFFyFkZQ+OzqnqCsEr4ybVDg9wQCTjVJAKtkPS8cJ3SIlaTuq6US94jbsk6MbMJCz5N+IhhQoC3sqI++5QfvfTGf7vpwKvbfv01XyrcnSYfaNEb0ak0gNQHRFUrYD9T8q+Jdxa2b4I8d0RAQq9raM1HwYOemeb6b33+u07ssne+60e73blsJ8shKtuoFF1KHuVHRSwch3YSTqr5cGsgXO76pcnhH3/pJSd2nRcuXPjYx26WqpRZl+oRLv1Plzeqwk80xoQgQvB991nMEI69Peb7fpue3/XqR4dh0cchpKEStlK1TARYPTvSxLK5sgEtCCUaGAhPCspEIYF4EFP24ZqL6x/0/EffsrwzF2NQK5OhXS0M9B/heKtpd6Pgad8H8OcIvZrKwk87NDR/6NW0E7oco1NO3nTuhr975W+f2GXfcfGiWh8COOegM8D1hSWOKhpbmtW2imSsWEvDGmuWy/nJbaLTtr+0ZMvWdRk4lFNHs8cs5eVj/nuE67Io0WE5p4c8rBoZkNiashptDooOKDS2EirADEVoWV5Y5gfVhHn9apqHs6bVljY4FwZX58pYur2BKXIFxUYQlg61/KC9pdltyx3WeSlw9quJrIKqu2R7VIQYFluuIn0BX9PCKTq83k27gvi1lDHi3G4kEpSQalyQja515Vb9ACs3wrN1smqR/JLu1vZM3HGNdMImC4s2sZqgQQguB9+FgQZAZbGW048ciD2l+hVlplGogJNoWghqUTV37h1seu/qz+Thdh33atU3uqtovc29iAEsWFTwVJxuQ70BP+sA91hdnM2jrjz8C5ogJ3py4Uk/+Bsnedl37HeqmQnbLHuXaRsm/Ceyjz7BaqHo8x/i1/GD5hSH5f6kOtHIc7Vc1k0t1jwCMfpnjmU0CvayumTCCE4Qekgp9T2E6Ku6vnQwP8lLffzz/kDaM71oVl568DarpAzFB1y4rdYIAweemqkkimBtyFzU51XsdO60XFq5ePtPPfpamiB3LPbtpBa1yYZpUXDLdtF71G6JRIOJIngdCfiYum7aqjVC+9VAKLY19dQ0oYur3cWNO9edJH6l1nUgmFLjLH8o1lyFUcAL8trXQI6NByj273Pnzp/kdf74rX+etCSIfXh6fszWXBy/plELMLOTIBa1UoQu14hTMoo17EPbhDxxYjakc11+4IG+6WK6bjdetyfOLdVOL5s+2SHXNDdoIztCWk1jwZgqbIjCJRh04kfuLXKuB608aMUeuAT0LPcmar9hRoHNDrYr7GKqNizYE9n4ZBFWE7y+5cOCBJSwsiQBBXg+JUfTh6KLSnst5zH2lfof7rh2ZLA3EBbt0rtfFd1ADwjaZS6/lmABKq1ofY9c7kfwIpTQF1GPztoobVfO3/jUH9504FVsb3ntl6m4NHLV6KHSFGf6Iq4jIJWoSr1sXuNX5sKyLxO7BURRQ0hLtabZ+bbnnSg3qH7yv+p9VrYRwgy0+WVIENPKT6sN62elNR328ukcy/qloVvtv+cNJ9zJ5wkT5Dya+xy6hZUCV5oGyISZokwAniIk3hH10TdPjEtw2L7lB39P2NpL5TnaREIKaSvFEuAhj8wSPnRNECvILAUM6/dYzC8GLX0Y9t78s4+5NibIme9/pCMoUimQNY3yFKY7N3hfwnKDjx5zgPR5Y6uqaa2tILTr6IWpktYS7O2D//n/8ncv+82TvOxV16UYkSBmskrRdCvxUuFfs0gGOAPB+7RuMSJfub01PeFOtnXdDz3vG4ew8ti0/QmOBEMPsF0trVk+N140FKIF/l1FChSeKLTSyTohIWrZSYuuZzKIC3Nx01LfOJcXDtLOQZgt0lYvoEUHB0IIHRjCshATkBBQy9JiuVQMbQFhvZIOKh7CaTkYOVjZNWpZq2WrFq3Eo1GLRqwMzRyW2cK2ycc0m3bFs7CQf0Bdaolw5JqLzNEOfZ/CPg9NkcR2FarLaUVwZtJeS52wIRKsRwPutZ9Nmn2QjIIbOpVQ1JWhUpACc05KnGowPwkSoaZZ6eqO3d1N713FRmhjqrpaxcoQPoWVIt1KpgRpCTkgzedpRXUENC/wQBCVSLqVPoqomro988Rnn3RU2rlom0kSJmRsy47lYK3RiSkEYlQkAM+J6fk8V/nbKV4FCvZsOrldFmefUbSdYQRXyaHmUSNoiIlxBk54oaYMa3sPLXqvpjad5NW2W2cHORBeTXCR0oqV55OIbKd5OYMhixAm1NYUhg3k8hPTAYcY5r67Fub1A5/9lXf6A9NYl6Oi6MLAocxFdkOtjIYuPsIlpY0mrKoUzYzEhItKW5WV652g+/cL/3jyV37x4sVCbB2GgZ5LCRcHp8CpI7YrsJWzs5KlCeibTXMVeH6T6ayf70LcYt0+Eb+me5Mt4vMijnsDONx2NMMWvmTg1mBGswcsxJVYGAG/lQL3QZzpc93aqVF3zNNKD02SZ85V1KMBjJlYsXttZokuzanXtZyfDEjvcaIeiyl7etHtQMJVVJUgCDudmgWot6F2yAdYlgOsNAFiWZIEm+3pSrfRkCIfTcGKothN+LWPHd07munZ6CHHFYxGVX12R+xfOz2wgbDrMFpSlOtmE+M7sT/4HKLKFdJLyMOmkPIgYg3+O63zBC1MCrTRCdu08/n+ZNN9V6n93Mu+VMZba50qlWw5+OIqqCxNIQqxyohIo3BemeVYWSGpKMzSVaLdefKz//wqTLxqQvHPipAFLfqTaWBTWVprKDYi5KdGCmw6ZBHwFiZp5LX66mwMTD2MCPBlqXaFqPzadAjgFsiCNkZpLHuB9l3fdV1d15d2d6c3nDnJS33CM95Lz+985cND7zU26JCYEp3xBc1rxVDVSGWlqvBALxMYYAoHtoRBxjkBhre84au//VkfOL2z48LTvuSOfl/OjKhlUMGHHoPMUkQxgSehH2KKdK9sVVW2otvpnY8+EJRtKZiaTGjTG3YXZ+32/MSvfNl1FPzQKAohsqhWDf6AyG4YvAejAAszqxEHj6jJUvCn2YZNyRtvuP7ku/pf7f75j4ubBoU6UU7vX64WXzOuccB+z+ihY6k5twJei6KYwqjN60Qtfx91WKM3WGJVL+3pRel8U5ugxWKYh2GVdD2ZtlObu7infahlZ1hshzN5YkSxOXDZo5PjL6WgR3NJKYWD9Hpdi7qRdqosfThoMkf6vXWQlqKJKGvuAFaP/vQGB0y0yJ82rXj4ks3u9tnxq7jsGVvG2qEEMcU8NIMGl7QxtmkkBLN9l2Os63/5D++/ljpBX7hwYTMU0D76J+66L9DK1nUrs+ldDMnUkwln5ml7gxAJk/RR2S5TLCCjrqwLcfbQL4t//0ebLjzh9gsv+5KJ3t+Sqzr3SCUgHRNwu1JaO4JjEUX9PCiAApVSKGA2EgDXDHk7Ng/57h/866tw6Y/5oV5Nkm6iroRpsrSek62CZcYrgXPcDGUM0Rgaij19NGsJbCnjLpnffu1V6e0IhmtP6IHAhFYaCp3Izs5oo3Le5UNf9JKeTUmMGu8EMnw7O2PVSSPvn/21i//dt56HRQ1ySIRtkubKFSXYoROKDzbCy1dwIQ4y9UplrTzq0pRKYen7/ge+5+E/+6ZbT+kEWX7ZVpxKN1Xe5mgSUykKNJBF0FfTf2y5HFTsuiWhQJ0V/LeymaVKL9M5s7P3mj85+Su/7bbbfYglC8u1URw1FX+NNfe1UAvOnz83OFequ2i00bDc2dm+Kr39qDzdriatqSAiPjgacU3bJILdMtJuAeeIiMP6z8QSvUxJ/ZRHHmErs6AYaNIjstxVlIcARqm01g4s32GbhWCMtyYoWPLaIVdBzKKeAWiyMktCincs5yryg2ysNWgxGOG1JCREKFazkotJ2cDnAqfSkZX0I61Qii1pKQ73soW3gpp6NfFw6OIDbjlK5Uq8VR4/y0i3UKLkjMvax3hMjwoyG03Zz6mB96HpHqA6J41gNmpI/zrFZQoUoNaNc5hKnTUXvRumzW+4O66lPthkYS+3SVx2F2/eqbdqCfPOIFWyjXCeidG84hfwKhIHwQYFu9rUW9f1w+4NT/2RO37l/9v04Ym1d7z2K1eLj2yZvpHOsEx9Gu2hS9EO+0bnIKFe6ugveAnmdCVghQi4K/SZpzz/6jjsDRQjJRpjBp6d0gyJczSYjZIGHbaz6HOOKmFXkijwUlFA83JLpaul5Hb+7JlLl/ZoKSwl4bHDskhwNnQhhkDop8gUsBYhUrXQOeK/EvRY7l9sz5+7Cit8fUaEBXjRiRPzOA7VSUYkpmhHZo+SNOqB40ROIaslIbtpku+71C1P7wTJz/wi38rUqr6ORqy96wspJRZzUct5G+mD79OgG518oMC8Us00VWLfnZWzW1/zByd/5bffuetYXZgPohG4sdprIQ+UsCizrUbJv9rRL44VoOur5zkkrzu/u0xbWk+SMYDT2RZ6Is1ktu8tZmKHOca7COmKCPMh+QahRxo5r8WXS35izhK2fuKIMfWRtwpaDRYd2HT5fBCT3l7fi0s+WpeyV3JHDKyiRRfWAfTkAo4hpAUNfKh30cCpeLYwigV7yGnZa5G06pDdB2jSQU677BcyR2FoKDmIe9GvZgcZVunSrN8r2SgvCi5EywXCltwh1MH0Wt9ErX1INu2zNPgX02zQFFrQDmFopLGyhJTeYMmrFQUdwvde0d+ticb8n4u/vNa6YDMKDpv+g7eEfuWHlUrBsFyiVeMBbnFG4Vh5jClZNk/RutpOtqVtbr719k0HnugOHbvtiVXRowoHalNire093rCCYhU4cspn7wn7KS1Mk0Q9hGqI0yf80D9elSufPPa5UsHvNgrm3rMeCqtejJs0oyoKrfGCoR9oF6yMSr6Lwzy+/SeuYp8j/2rgYjemx5AYi6wuqQ8zJkVR6OhfFW2i3E7+gp/wgj/V1Rmf64F11KJk1qv0SOcVnyOuQEMqiT3sy8DiEgiH/JBCEu39r3/UaZwgBD7spMmawZIqupFcfocfpsuZPzaSzb0/M92RnvpGtLKuhQ0rf+tr/+CqXLkbHCtlmbvcukEeoDDpYH5QxLYCaiLzDddff7U6/Mcv/cVKxoPovFHUhT6lVd/nkLi8UQTnoeJ6tzJsn7A950/CuJ/joQY7Foz0g6LKp0OuhtAuwmzPzebhXC92BtmGopjN85q9tVQCH8BEOQ0o8zL50H4WcJlGjpNxkLEzYlkLVHS18qDO8yrPbVyYNIic5RHX31F1/9OC9bUh2Kbd491QXDb15X0QnnuGYYofvDCGopUVrdVtfe199g2E/UQUS3Enzm29MZJWSPD7xuhWjomacU1gtWn+QhpLfw7m3ab3Tqy98aVfIUI3bSqBast4GbNy2X6xlynPrOucWBI9ZQ2he5crwjTCXJ3Txhu/9Vme9hFrstZKskc5Li1ybTwkLyKPKwcp6kppG0NAtl+LOCxV6K9ut3/eg24ibBFRIB7LiWBi2/qK87KfGW2oGMMtt16d4/hvfP4fSjv10rgsk4pZM16VnoeL1qX8TFkY2IgCygPy+ZGWAlmjhCj2/fzdr/nGU7aOPf2/oo9ra8tagPkoWjgUjyy4Ac6g2ABV7mgQGptN6uOw6Lea6VW58mU/9H3PDsZ3dY6cWRCTXrRcLg95BU1zlT0z//Xwt/MAWoNqGq9ENwywJFewjIYYxue8235CPHjvmoQbIWjgxYmXnk1O2se6C9MDP5v7nU7MBtGwLoFkjjuNf53ENCoblWZ97VGvII8uUAJEHBS8+5whtlWrrlHzRh1MxF6d9gjF6uQ0F6hyWoGrwi6jWLUOn/Lh8yexYDcp2M+1AbgWW+B86OaYpI6wX9LQYSkkEdXlsMqhObt97XXBBsJ+QnvgDddBTmZY1Sq3VmbXyU8oAC9YlgVi+TlLveicz3KyfbZ/1FM2HXhCEzcslHDC9yyOGLmmNhbwymaM8pALGzOtswM966pRtobTkLe5Ovv4H/77q3Lle31QzVSaWijDluPASwn4FYsNjrrp8rURBKpsLataaVMBRznpV1vN1Z+tk7b1zsEzaawBypGruMSoGpuPaNiOf03s1EVId75YXJVrfuyL/lpV20GaPsqB8LcKyjA5tphiZsVClgonLrmo0eCeGBoxDX1GmULnhtMk//wFL/56l722NDlCiigNlCOQRel5vOyUkVgoMBtTn51s7915sGMnrazdfMhD3n3Dn12Vi//4xz8uxGdXVQ0xsO8MUFnbtoXfctNNN131zl9pcZCchxqKpTjUGnDSdBRTWn/y3cCjh+j1Xs55xYba9NCFL6xxANQEOR3ymVU+s8w7i7CzyoRiocbFrwSxNUgbRB0yQds6FukuMSp4CLHO9wmvkjNyaNRyZpYzfTBVe1M5nwh69KxALAqzi2tpgePTmP4Rl8OpnORlPHaYi9jscXcn1IGgWqn/ZWqB0HAQRe4/+zSZzIac9v0QavMvbv3da68TNhD2E9rBW18laQGa7+voppZWyl4VNdh14Mh20qMFX5DaC+lCCgSQJtuymm468ATam1725Y0ebB7C6sDIULR25FgnUULSy9JJLji4BEthm0k29SrqXkyf+KK/uipX/pCn/Wg0jVM26pqdilXJajBhLHMRMeBekqAZgKevCcjSVhBDv6izV2/+v69651+Pg9ox40X4juCp9z4Gtv0cMwHr4tjCMS1fcM7s0qVL569S8aiZXpf0bIhi5YOLUMrLqmTsRZEOZsVgBVmiohJOQFdmCh4M4cDU5Xjwjld/w6lZxPqDZntia+O9g9evllbLgl8PZYbFaChaNj3V2Mm2mdlYyT5PZNP/9F9flStfdjh/rihyk59lY+KiwVjsZyHiltJsNnNXg6zySS1uNbth2E8uWgoNGi1N8okip6ltj0ql3p2D83ulsAqnrhCLImTmAU/rTpvEjpMXOnFhmc7txXMHcbvLUyfYkRmpOxNxVlUFUcXCIhh5dPHyVkjrkaDFd6jlstXzqTrY0pe29f62uTSTBxPVNSzCtQYZPMvYOewIneBIClbmtUKB3ODXuw/gisNsHuUjoPVL906FHPo4abcWPuxTTHtu+xrugU273Ga1jcMqu2WNahpI7x3Ot6KflwFe8aAvHBJoRmiKecx0+/zk8c/ZdOAVbb/8skepdNBqZ8UQhkUFCnsp0i26WXR7TPm6JGsovvDJZzjBV0HXQU5lff5qXfztB6tg20UQZV8QcMEZA+dDF1mXhUehBTQKaHRpiqWDS8Pq7NTeF/qfunMyaSPzDjl2yHJdYjPuRaK4fMrD08Fi3eWco68//OEPX5XL/qZnfVDWW9SrfVQDaBDy0BhXsjBReaC+RCYjUmZtVK0FysjzSsZVDnunYoKcfebDB+Gm261stEuAsPD/1CqIQwvKFMW4qKWiQBdS7tKNOzeKVRIr0b3h6gR4WztnL955sWlaGLxxhdZd7VuMcelOKpog/HzDDTfcF/r/f93/i5XJu773liKDKhLUpjHnUiW4uOnu0FjFkVyszPcQ2OGcwScoYIcYUFeWNeCp2OrzhVU+PycIG87O49YyTYbUBNjAVEnVAWpclU9NpL+CV/AJ8QPPnqhy0NJbsWzkfCL3pmpvpi9tyf0tfTCVfSXTeIw9yioUXUNm5RaFaTmi2BF78ULC9ZUbDHu37q9k2jHrVHA/UiieEIpoL5OPSpsVbSGV/aFbP3BN9sAGwn5yG97x8glFnW5pYm/TICEkud6/x4FSZE3AKHC0j5sq63pIqtk+txzSzhOevenDK9j8rhbzSq507nUa2LCmCMvky0dQowUT3SMToRuDAKOnlTxb0577zhe+7+rs0N/5Q3t9dKruEyFXXTivZRHnslKIgwBkpORDsLT+JFp4BtTaDCsr3PDWn7yP3IEbb3wA9e0wAApCmIPbkcINebScC1xxbgRh67o+ODjQ5uqooDzueR+R9fVZz3yeDKFowBfuXxDC8Yk6FNyVqP9/9t4EzNLsLA87+7/craq6qrtn0UhiNMRWSIDHiEUsiRFISCaYsBliLBYJCSkBSyAriQj4cUJ4gmwHwiI0CMssIY8hPJDYQgRhGcWsUhQI2qURs0+v1VV1l387a77vnP9WVY9mWrN0d3V33aNfNbduV3f99/xneb/vvN/7MloAgqJRwoAGzWCk0Yq4vd+794tu/Pmx1y0MDywXXDJPw9KpOESmNYpSLRNpqYgwetR13sy69WzCmjAUR3aU9MAD98NgR0mBgNpY7ooWHgyZ5DT9DAyt4XDYNjdKNUKYDHe9bTh1UraotOs4THlzNFIiSYGVoSoHunVF1g8KnShLyo6OG7I2t2szsz6z6wu/VodRR0vAr2juRfZpQQllolIWQ83bmMQh0feHoF+XiFVcWZgXZF6yWcnga62SLFdwPXdliciXNWHJ+SCeZ/Yb6yHcvoIlT/HhLo0ScfGiy3w2jdrdPMoEs7kxNSd8c+1W7YTVWHmCdvv6UNiWdTNmm0gk6AeKSKe9y4hHR2MiR5BbR1XpRN4SdW6nWnXgNWrvfsfn5aKSoQp2zn07kIwFEwMKy3pFrf3Go+eeCFxSkcGWXjWudervvOaDR3XzlxZdHWRDJM+GlvL9m+Voq0FlRLNJggpNMpUChNW0rbWd7ZpRzm+cp+BMNyhLpCJilZzDohr+ZJXTPaZN1qDJF/Ts2SOTWc3Hd4nyNs8HnRM2jhA0awg6eI3TGjd7xmjGWQYBRdQogP3aUoSwLfMzry/97ttffCNPkOJ7XhByZiWpXQvxkFDMEttaeFI6YtnHl8mkrBiHtawl9Xa1pibTdx6NvnWgDMKbmFL1KNIW/Qs+y1+Jw8nGUXjnnXfeOE/hn+x+bM5DI7mRrNIahlUGW8O8DlfMK/dh91Xf4AORBIKxqEK2ZJLAapl5ZA6MWzJZhI2ZT9ek8oM2FJoo5NFEo4TQ525cRK6GoRKXTUwh+JZTzXzN3EK4eeZnRZiVYVbAC1+roHmwDDX2o19UD7loTx/oXQ961LUsxN1X/lnRYZ8yiu1T3W6ZWetlYCxD529VbM/nNs/+0eyjt2oPrCDsE7TZu3+6oCY0M9YumDfL1d+TtNGRvpIXpQm4rDtYbtlobbOF7YIpALL5175+1YfXZJ+zO6XsOKm9nlHXFJkQuBy7ZZ1EYmSSWD4hoho3pzyjsoTnMm38y7/vE0d15/6rX9144XimiczHG4RJlBWPh/CJIddHzSE4/DiuzCRKNRpNbMd8q9/zizfUg9jaOtkryWvddoCRDFnWbx1GGEl4KyHdsiwXiwWAk7quAZofyW1/1d//UDa8k8pNEzLUaEdxeBfdhg3cZpzg8KEyRpUEIBs/IfyIYC7jRrCG+rm/sekENqP5eOABbjcLS71UeCJvdBshLFmuWvuQgUUzB1ry8kS+fuZTD52/98hse86cPRsdfj0MJxQBQznnK4EYFxtKrkYTr7q6sRIHbSE7xTrBK5jQXKqirNouHIVyFFr+SSEFFwz5PFRg9hp1CTzNCB04Mu7IWkXW5/7E1K0vwqQGaEszm6gLUWQUnWYhkqO4MOGU2TdWwDkDT6uJKLbifiHCIguLnMzhqwIQH9qUiGXpKDOQAyDbR7sBLQ9oOKD7shUmeVpbYqIGYeYjARQa4w4f1ZOE4IPyQrXwg+IW7oLVcHnitl7K2flHJzkfSnRLYh6CHOcpBqdIJMCV0xo0LuWe8s76Ra1tEPlwjRdrC80m3/jfrvrw6rbfffvdzM6Yn+fCFhlTPPiu9TZmYbHYNTntYXF5YIJgqiAzRBhSGK9MKLPBkVHl2Ete5UQpBmtUDRyDm2EW8SqOHBKlYWlIrrcBdu2M09Gg0M3CtzWjPqd+fZjfaM8CNp28KGAOFEUZnT9xIS2KHH2JUKQzwG4JEySSThHLGgNYV6MKfQQf0+l0OBodyZ1/xd///4jcagzs3Tny/ZzuXONDgxLCiJoEJQoegpQ5jCtjmuC14rDJYuG1ikemN+wEEd/5PMe9F4FBaKeEtl2lW8AtAF8AHaK0mbGYk4M3hETSIWE5h1BJukp3uxV914NHdecXLu3AIBFCwOAxOE5EFvUuIvLCSMlH7wKsvUP+ALGRPxBDDIQ+N1QKNrWf7h4639RnF3M2HPDRyHDGs9y6KNiWZKVYNL6mvSDJfuz3hInYZ5Wdxao364Ndap8El7aw6L0tAoWIZ9SF8cJu7NrJrp7M3KgOhYVdD0tKDTIPsMZU09ARvBwJEPuh3jAK0SFw8vGg0gnqcuZy2Ra0ykidkQYu6WvqG+IMWibGYoXL1SYOpWAP63qv2tOJUmJRKmbapeRKwnYI0ZJhrGN8zxi+vv6W+hO38MdfDZonbpf+r7fl1DBTc9tB2BmPFWElsCQlZWMkiqKeDPYIBXtha+DPBFFDmg01zy4tzKoPr2L7vXd8PnNT5ubM1YAkMh44rpod9f1ZV3I1jSU50XIiYAo20MyFTJMi8PE3vPZTR3Xzs8Y6UXhRBlkGnkVSHKZcRZ9yiB6nJFHEAGoEGGzBoieoDJa6LvzBvTfgE7nj9tutdQApMBNmXXT7TO46IZVQY70Xi4aSMR0L6ARgSZYhOAFEe1R1XdC++tWf8nxNB4lFXYCC0NsNNuoOpSCIgO73DrNV+BFQ/haTRIxoQRpBWxnqd//M596gCZmMWYGUGhj4XhAN0MVZGWu5UHsKAJ+QFumQ6AWHHFgTFOHKc+n4RI2O6rZlXsxmM8y89ioESDtJoY6ztq/qSvTqmD6MirEoDwUREQwn+CrFjegxqQu153Urhcm4hk+gZLSZWFIXH59MC4cB6+OuZ5emCykAiPrZkTSZjhQjioVVcuDpSNP1KmzO7MbMr83duPGFYSJKKMNvd0srH5geHQ0t85b1idWY1EdpNkOd58FKWJoBubJFjn4HsFLXisCc0cIb9MINYb8ANBzAj55VQA7pyqxYBE/58aKJI09rFU54LEdlzDJ0Kam8v2S12lq/tbtgBWGftN21NWln27aZS+IEB9Dh0eoTI04L3YbWMMiYY0JwxVF3D5O06C5eBJFrysVL37Dqw6s2U82cuJZFIZd4TBKFYAlPp40APly6MLGBlVKGCI2phJEOQ0fXuToyz57Nb3mLGpzQQWiPan0MAh7rE/MhHtUxF03EUsWxQGKi822dU1cwmwFetzeoZQY8Bamki/qc3iOEhZew9aTcmMfQgqa0a4gJs8QrSMgDQEjTNO3RSSCpwe0mDHVQTA64yiEw1a6z8ClwM2UGETntpdlwmw7Mo1+jDJ2AHZnU/+6XbjhG7Pg7Pxcp1TiOsGBrv4AdvUOT8y+hZZbDp9HGUUcVU9R40nnf2okoz/3KkVEIzp45E70yEF2zuJxiWg/T9p3WWNSVzIppcmqNBNl9izgYS1tbWzfmBPnJ6ScaKXacnnnfKKEFhhDRrwE/RUq70ojIr0yZeLYr55J8GljyDMByKhclkWNJFmrJZZ4ODBm3dFKHtZrANWnDuAulJVngMIch2GZLUiyi80OwGkJYESULsF6M+Y4DhA1VQRYFmeVkAa+RUUA1j9lfjJz20TpiD3+A25fwnZCVV9dTfrgoLZcceq23rTEdIFmIVDM1l2yXuD0Wvu+xP1pB2GPaHv79X/L1lJgYdmLy1eaCCrhwtmqAUUqJZAbPuWCUo24JpqIUkaVhamZXE/HqNVsx1wqsDYCFF0urCdpBo0Fo1B2NK2E81rK9dq+0JGrC0CHlJ1723e8/kru+7e/9yHZteTFxJKMB9l0lmEKsHctoYoky4tclA4wmNE4aWPm1dI0A1P6H996wz+T5dz0nRI9WIVDwy1l0gcdDaoCwUecoU71hfVLuBNhaVVViFBRFcf78+aquj+TOX/79fxX42IbcsxwAEUxcg3JDJkRzX+v8YT+rSIB3DPBr6CRAWFo31bkb7VnMuoUXzOL0wDInG2CQ4aRgCGGRr2I1/AlXgUkqc1mMipH03Cxav9A79x6Z2s6Z8xd29/aitgAeeEdEx7GcC3muWFvHcXVlMSjq6SjW2FQqD9/Cf/fH2A3YzCDbdnqPWJ1Jlyn0e6SoDRAL0WLxYCx0xFOLa4piI2w9XGiJouYwVLA8GS0PFEBYjfh1Uvu1hZ9UYVyFYUNyQ1SgCnlDROz/YySh2PQ6xHJAz5Foh5WPWvo6C/MBXZR0VpC5IghhYeZwbyOKDWQ/6XqZ3EEyvIx6W6sU7NNoPmkBUnSgNN7D9ucl7zhfMDITtBvlt3wPrCDsFXvno7+bw+DQtY11XWWpykLBKmSsJt5mGcARazDhBOsAd55Y2Dhgj1AFzwZBZIOvf+OqD599+4N7Pz/i1yA5ETGhhNJAPuYFGEOmF3rHMqkAi0BsgdFG4MLSrLLC88krXvtXR7ZDby8aTXWQhGVM5oRJJKEExg6qblHz20UIG63FggheBEvaOWkXmwN+gz+a8WisMpXlGaANeAqsP7ZG8iLszlIp2KF119V13SdlQ2jbFoAs4I+u66IV09G0V/zAg5YNOstbwxxRTHKA3/FM0/fCP/vF2N4hbRmZy1ZSLWkbut3fv/cLbpyncPpVnyeHivGooYB2dOGQrGp/MmsJqZuWUpGJXPGs4Lkk0iy6PByZ3nCgrK4qNChWWbIqSEUGutMww6XC92H8+IT4MGrdhzmYkoW3Tt8YWrBP1v6n3Y/Oqd823ZyTUCrAFom8m8ivPTGCUboU17s2+JV4jovlUrWq5xEArrXRCYai5SzNPC0MLVsyrMN4jigWBbYaUlqae1J4rPlI+hWpOaRwJVwbyb2RqeARwoY6Z4sClWLnOakiL7aRwXCKEuuB9GDak2XQ/oS0gRWKfWoNJQt5Km3E9SsH7KFq4mfB7lHXDbMf7z5xy/fBCsJ+llZKaps62E5QWGF1sC3M10wymM3Gds50zLlo1y1gVbCedGiBwonMWTbsqGpf9K2rPny2q7CtJQ2KE8VhE5DMo8u3X+roW58CBywit9TDI8HKBZ4FOWht9vWv/8hR3Xb2sh+2JPOs6GBMYIlNCeDVdYCHDjDSMgUL4Bu3A3hTBVcKqve2M9/UN4wW7JO1tfFQKWUtKrhEoiLdz9Tsa2mRxBqP3woh4Cv8PABZeAf+7rPzHnp267/cbExWtbEoX5VEches9R1DS3gflpLr0a8YdYHQuwv24qAZaai7Ueq6nv/6F1WuyUcldnGyL4AoLp1TR9qhwyy4HA3HVls8qnCkW7TNtBaWqSDDLx/ZJnf27FmBVFYZ6dI+sVyRwGsNjSfu1lltjDUmDZU8z7MsE0hE4da5rSNyentaTW6ubwd9tp3bInMwF1gPVcNS8//JNmH65Pju6S2erKcNhANBAHK4pgrp4HiYhZZOuSGDNoxrv77wW1O/VpOhpgVclowtyx0DLLvEwcsPGPAS8VNp5lsR5hnZiwZdmIstaJOxVpJOEsvJ0gR1eRsJxobDxg0rIuzTWcFg51DC4rmRgwUY5ojnbNo12109ZYGf3DgWecbVOLhym/7bt4lgJXFSkK6eLRZ7jPrBIC8Eb5sqWBOrffHAC2sqA8XaEOhVJoMq55aJ0ab4mtesuvEZt39779+itpXMQdQgKccSqLB/NsZRQyTlAdBIkTnibPCGEselZ7nnR6bTLv7T769gI84nXpS1JYznnEnvqNEWBgys5HExp9HgoCcSxNAHcJITvgvN9EQpbooHtDaZACTF4+pUVpDKbyLBo2fECqki/9XhaXHkMnIOWBawC/zpuXPnirI8kjt/2Wvvc3SorQo05yKDKNQhyVrTFGREKB4LTKLqD05vh6VeBOtzuF+879e++Ebo/3PTizXpaB41wmIUhCtS6NOccVxhri/PS4dZcoCwtKthJaul5ydHR4YC96ZT3XUUxj8gVqQEoNoA4zwV//Xq7CFRBigMlgybgoETtWANfJLRcHjjz4637nxYF/KcbirmDcNkMukpsMuTeB+I/+xI5Rk3T/virc+wb12aY5E+TpMwDSwdtmGtIRtzf2Lm1ys/asnA0NLQzJHcJ3o49ZTFyjQf43AqIh0WtkUHsZ3AQq5pQaclmReswrqu0Cosh7Ss/6BxTh26jcvwK1lB2KcD33AkYR0XBCno8cgN8VPdzpkzo/K/fvD/XkHYVcM2GuTIxee0a+u6nkMwWaBsZzBt41MlTvS8wS0cd3FmAkITmNqeiWxyooVV5KteuerGZ9asbrHglZCeL4aBPPS3JEufQ8ok1hahmZUBFEuwtI7ZQD1T3/bGjx/Vbc8qTWUuVIHDIMSBgT5QjqDqUTqPC3yZdXDL3ENMSPjQ1qNcbL/752+KByQ5K4oCxXhjzRaWF9D02huNJ8JsCVg9uja4VNSllIrCW66qqkcfffTIbl6uUQZIqHBExhNWG5hGbyLSI4s46jh+oJ6z5ygxCj2Mu669ITRiG9sgFTHYhASW/AEWq7hY8pxEYSRtZayCwqgCQj3tMpHt/OLRsGB3dnebphVSOGe7TjvrIh2U0d6rmCaBguhMjMYZ8T9RuwNztNhObp28WVaw8W2nOkH3mqqL1lg4x7E6DT1WE6PAB39Nb+BQBVUq64rspYCnCkj9DlHVBY2V8RxFeZJ3ftj4tYUb1B5e5yYUNuSO5oHlSKcmMtbSphaNC1DQKUZ5eEhRqwAotlXoMdspaiQ1Aqm3nsUzp3TswiJ0PZQMZkv8ukrDPq1ni0OoD0OIC66D8A4eymAwvvPUMemCFYR9Cijq935SYOWmk0vDRnSQMR10Xoa1BgTpmA5mqJBcMY62lGlLUaP1mXYhG2TDtVU3PoP2nrd/ObEtyragnGLUzcKLRXFFAQEooNWYzGN129ZNDWuwzGTgAsvL6ZGR/MgXf2cxmMhipAEQ2SBEDquKMah5oqK+OFk6hh9kJXoUiwrEtq3pn/7Lm+gxPec5zwF4ijVbsWacRlNZeFJt1/nYAHPAOyiBhCiKJY2tBGfh/bZt54vFkdz5S1/3ibzYCEQZE6u4qCXMetJ6YlLx9n4yM6JYTpMUA2Y8O9MdPZdg/F33sBxXncYclndIHEsWZapQeNhos7c3LYuB5BJWKBQ3Y3KQHU3yG0b9bDZD4VcpXRweiE9j/OMw/qGCo2Ie3H2kneBxBYyVLppoaI11RHD7ZXHT1Kn8xCMfGJ7aPL+3Cx8B0SpLB/fRTNrF9Swua0/ga3eVejsd1EfRPvwvi+B1iRRj3R+LYn6MctizAKpqP6r92twPa1dqrzRWxQ7gfU9VoFnPYSXx2BH/RU5YqkazjBhOaol+s4BiO7gk05JqLDSkaE6bilefAKTSPppflUA/nYaYFXEI5VzAo+iMaa2lmVq7/eSbPvEHKwi7aoe6yTbUtOMymxQZC76tq7ZpRkVJlUIlYUc0slEghpVcYMURLs0uNJqw8oTPxlPH/d9+1aobn/YUNXMWOoYF1iYA4kHOj4tJCxdXO7RP4gIrcdq2wmoVnnE1dKxorXzFqz50JPcsvuQf8HJjcupOrspK29oYninYkzW8IKFQKcjBVIjpAZLnsBZRzYmWRAvfCl/fZI9Jd0l5PsREK+pRoV4sZmERoOCWTS3WmVupsnKA9NkW4G3XAUYZj8dZlp87d/7c+fNH87zK200Yt0Zo1OaN5UO+Rfn2PrXB46EvPECR8rDME2TCE0Ns9X++7QVH2/Mt0cW4EIOsc7qvTk4FQpFB4LHACyXojDV7s+moLAXMl8AGLCuoevR/ed+R3PP9998P0c7edK9aVBDSAJQtilwgQ8AB1IYh1AtcOCQMaBQh6OqqqhYLWHIhqhgOh6dOnry5JsiPX/zLRxZ7FR5CUEfhuSCkQ4MrigbHDI9pIhMqEEoOXO/DVQK1Eb4e1E7RlOlEodclmIxDHfFrYJlDdYJhE0a1G9eAZcOoC7lGBVkRc+Tw91BEHy1kSCRwIYRwlKH/B6cdrGLxRa3IrCCL3HeoI9MT/wmeYqAdl4svUoSIPorICcM/Tzj7uOFY2j+UxK/o4X2vhrYsm7j86skX1FLbwlACBCsd5bXzFTzp9fEbHv6TY4TNVjjpqTT/np9l3TQ0e7m3AGB920mVW8YtYZpjGSBcDqvjncaUIRryOaS35w0ZLOiw5cOOD+lXv3rVk0+9/f4v/q2gL0lSKw6RfGDJBZoGjkEnYCT0/fbR4oYTlYlhMVgjvFxoXtmclqeP5J6HX/VfVmGYrd851WQOkQ3nRZkDanDeCMx+UItsgoDMMVUAXtIOYJyX0lAzDXaP213m9tj7f/Wme1h3P++5gEVgXZVCJPHLyWQsBE+KSCi7jUL1DvBI27ZaA3rHddcY27XaRgX7um64OILE+Vd97/s12zJkTPiQceW9cbalQWMVV4jZJTyOhxuDXVtykjMYgBhxtCp0Q9n9wa9+6VH1Of+O5xgRXMYAJQDixiR/cCEKgAX0Uooqf4AWWChydXpzo6trCoHUXlVf3Fv8ytHIdFy6tKtkhiA1UqWjzkAAqOoc6ogg0QGT9MgrQMFho+Gd4WCQBlUS2IKRVGTqppsga3/zBbUQlQ8d5b7I+Wg4966xJsuyQVG4upU+KB9EIsUn+y4WXZd6dgVZSu89vQsJGslKC78iVIaxgldErf1rQM+GCEsyG0rHhoaPDVvr0O9gY2FHC5Nphzxe2NVYPGgJXnikHChLZCzVtIx2sJpxphk3KMtNKkWnI7oY0ragTkRFWIvCaeiDIDAvq3FBx3M0+KcQH0cEjzoJLLm4Hyf8ikuKxAeUHnmsIA3RMN1Soonr0IUSqcaexR0E/UnQb825wAwbqzXGi46IBeczJX54+iFynNoKwj7VdmoEe0Ulnc6cg5Ug4zJa+HBHRceF5lzDaMOp6qOHH1oJaicaOtRi7LINV260otz8z//hqiefcnLvIidztERCBUMUNtpn+9M+po+lXR7duxm6BhQ2yNZLzYbf9Ooj2KHv+Pp/fKkVWp7QYlQ50aIfMXKoYUVyxBDmkesXWZaOiQ5trJkUzNqahUaJjvkZN3v2vb9wkz6uarGInEWU2wbcOihLuGi0WepzSohaoouM86mkBb5t2haA7Hg8ZpQ9+uhja+snrv+dv+IHP2zomqMFYQJlhYnmHtNLHIWPeuog8lKCQmE3uBxVzhfUFKx1zfmj6vBdM3cltypmuTiNPMt4wotQw8HVUQtfUV2BB8CGrmlCa6QlG+JoKARV3e5Np4hbkXbFkjbW0lnPJ/OmpJmXEvkiBkBSirIsijyH7/Isu/220zfj7Pjn5z/sx0NNuZFSSzUFeA4YNS+QS9CYcVYoiJM8SUf8IZJNUw0WPShyeiZXWnX6CirMvAI8gl8SsSzp32RRMw4grHIoPjCwZNSRccvGtVub242WDDB3ChDUaZjBSXrEoU12ZinDQxeKdqactZw1EWbBVSuyMwjTkmiFJxoxD4wBC+AwzeDnCaBYF9dDYaOIt8cfgI9suffHiQyLztaOx8BYUC/Sc4FRAEtkr4aWCkBYtA5MiZwQkqSwYmqUj5q9LsDSlA9qKXc5OW5tBWGfanv4N39qJLm0Wngrgkk2ewFzrlijk8o/IFCN3o04j+E1bM4w4JTEahYuMpUPtveq2/7ua1ed+ZQy385IgcRResVhihQ6XBspBKYGDWeklEewQ7/w7/0Pe4uGqkIVRYuyA4QsZbrjiVtC3TS9gBXJmQZ1RiWBF87UkrmMmDK/iVegO++4oygKFqmuAFuNMSVAWEzBuj6T9EQtxA0rz4uAFVLd/fffv7l1BIUIlMuopAXANSMsB/ja15tgKsRH8bNUc9PLajJBuGAksjSPbPNjVOWKohCHj7k7JKVAb7oe8cQfSdpNABEN8vVdp3Mut3/9w0dxu/zSpUuYjIeRgRIWqULryXPMscVZRFPxHyyjp07dxEUqb5x9uFsrFoLOTNeg33IhCNNYf+NVWabj9YTe4rF+4hWQy1w2nuFKGkeDTyndA0WtlOt83Ds07OPfIGxQrRs4NrKs0EF2ThmCAtcUsJVHogf+ND0410aWbRx/cQiiARgj6GgX67oaRbVEsqyjdP9D4SkavCOIjbyGY2hrgA5b8bn7fRLJUmcwPgsktWM5MB47xs0wbi3wKPHEIsvYcHCuWSxglS1kyOU/rT913DpwBWGfThbhPb+UAfpoa9I1wmmBorBWergiJ77XssHDkaiURAGEwZaeCQmjru0M4XkX+CPndlc9+Vnbu+79G+jwLlENfH+gPmGxakgyToQ7x4xzhEqprreW1t/45jd/+pHHKuuKwagYDHUUCTqcNSa9i2y8UXSYNKgwSqxivoDtwDS2XZQZr373F27qp3by5EkV3ZKaptnZ2UlAhF5R+VUqJaSsKyQKwuOuquojHz4CgMVk4YIysJ1SxTgy/Xzah/utPhkKubTloO4wEtCwGMYafSRdrf7B57BMAarrd/0k1xG/LJNYPX71CZcEppg0nVHsCMIk6/xDDz2ExmwC695jCRe9MoSNrrO9fgWA3rZtR6MRZzf3hsVu25gSc3E+g1ViOBg0dQ2gpCyHDXxCRo2I0VLEgvtrXaDPFtixJX4l5FBwEw6+XhZoLBEtd4TjqZYrDSksyw3NAMU6UqS6RgeLGN6YRch6cH+xSpUmA+2AqVas6Goz1im4eKeiOiw6lPWLgo8aH570GO54tp4BTMPhHogAIvYnjQT3pYlZ6FcjTomAWdTAsCnknPiKBbU+Poa9t4KwT6/dsTHmtvVzWIgaGZwKFpOy3mfxzCdOXfTx4ahUzzOOloJYf63NznShAxueOC1GJ+iLv33Vk1duHWruOhWLXeOJI+lDdxThPlh3Q4QVeOImlA3UBkFF9g2v/OD1vNV7vu1NH33w0b1W06zMRiOW5/agIIEuM6/0EJb1wXaZCJxoYptxKUgzb/a2u3/9Mzf9akLpxsYG5lZDyPP80qVLaAGaZZ8F31hbN81oPOZRO3ZRVefOX7zOd/7y1/2FY6qz3AQZeE4o7/NXMacU6SopueSi9ZhOEQlEWcF1/+qnj6Coy1gzmYxb03VWL4GO77e5A9CD570sYMo453KYlcTADLneEBZCgkceQd208XgMT1kIiVQC11vgPjnqxQYREQwniIgA462v3fS6Lt/90J/ucBdGZUfDrK4BvKqsaJ3tUFcMi6J8UpxKhNgEBK9CeRNlT1Ty/zg51sM52vQ1c7TUNK9svjCDNgwtHzjGIDy30R83rmqRJNCPt6SyIj0SZHGIIiinbUabjNYFrwvaStZxag+ZyIaDNGSv/9HnjI8Pfo1YP6Vgo0hN2E978N6/ESkYxMCu4WnU4iExkPMhLJw7V80Hd56eMb/nzRse/tMVhF21z9Ie/I23np6UVNekmg54UHgGgheLbnvJkZxR2AUVRdmaXHdNs1jAjM6KoaMZyydifBKru170bavOvFLzmid0igDQLZEg2w9b99MISO3igFyxKoAwpbLrGol+7vf82H3nLjWiEJMToSybQBrrAkfPBXfZUkwPxdw+g5sNDXrZ+I7qRTu/dGKgbo3nJmLadTgcRhUCPLyO+Io+GVkPfqbr8Cwe8WuUWELN1ba9uL1zvfcSXrZWtA4mbxGojEZKoYeD6M/q4qhDFOu9jTau8OmaSIBvr/Otjl/5H7JMjSbjpm06bVzc9vwSxR5gkj4xRpmlprXU04zwc+/4y+u8xTz4wAMAQNPAcJEKjUGcRaOLK/y16NslkzsGBEIvetGLbo0Jkt91uhLk7HR30WlYrgiXXfBwAeBDDy3azxQWrprI1FMxDOi9svzBX4GrCGxieTbVatqOm7Dm5NgJWVvWWsyhcxhWMQu7dK+Fe1ZIIg9JXQE+jhbozlUVvCrYomB1zoykMXHbf7D9/Ktbitfy4ycLGyIDA68lHyN5N7JoewYrEY/51ygcgSrbnElKoZtpE/wu93sZq4eZuv0kOZZtBWGfdrv0rp9Zy6irZlRjdZdEaizsezEcjYKM6DNDBWDZTEldV21VcSm3tk5Tkc80DLsslCc6Md79gm9ZdeYTtn/zS18kAJey4GwXaxDY43MKZEkbSkE8Z54JzxQVxUtfeV3rMe+7sDcNKts8qdY3Oi73uq7uOiqkP8Bs7HFu4FFaiwVbUVcr2ulqd8g9fe87b5nH98IXvpBEYmtSqAKoQp+8kWjFJISo6homT55nUilUfXduvriu4mIve+0nHSuiD1HmLlsYXb+xJLMDfJHo7wBeteRekOvNJZi3tciVLHLtUEAB9fEp+n/4ZQp2SWJhDMucebChW7S+NmvFdQ3winL4yCOPGGuVlHCPbds2TeMjN4AxdmWGSXInBuy7WCzuuOOO2XR6a8yOt9z3/q6QF+pZyAQ8PgCvDpcv7lKkTghZVl/FLCxdrnJXA8VezoJ93A8ko5h93Az4KXcIYcu5zadmWPuJpkNNRWuJcQA0BcScDKXBIpBNhsaodptBpISQNhgWAMK2ii5KuPiiZGg2K4jhsGLvo7dI01mO256Me5xUtUJvBJhy7YEsD1ESLxFd01AzmSWRAlwqqRRcYsqGUS2ZGeZnbaPuOPWGT/y7FYRdtafa3B+9cySdXexwV4nQ0aDhEqhm01vomSQuDqPOauR0cjkYrZsg92pXG0HKE3LttM823Fd+36ozn2DBdV0OkxRgnm7xqIosHQkPDqBSRS16QjnK0VqJ5pjkFtd1h7b/2ZunHReDdTXaotnIeACkrnWeIEOx9288WKeoT5enVgonXC1sBV+VrUcf+I1b6fFN9/ZOnDihtc6yLJV2HehRPtEVzbpk17UEy89R8V6pbDKZ7O7szBfVdb11MfF0YnxvpZl2khibuhCliENMx8agBBOxJNhMUsnd7/zC513X9Qd2M8DOJEglYM+z3kdvKx/TxjDA/D4siaJFmN/zrTOL9tI7rx/PeDReu++++5x3BcQlWWada1F9wqSIBT0urghhw9KL1XufKXUrTZCf2PlkO8jqXM4E3bO6tl4OBkn0CnmPLoqvLnmRz5Ihug8Hnwy/Po5awPwBkUB5MjBs2NJB48val20ou5AbjPBkQEGVuKzRCGRpnzmM3h807oNw5wBY64zVGV8UbJHDRVtJsaLr4LdfZk22n34+bnlYQg7sylL+NRnWwwsey7nijIDeQoURBwEPfEV1C2EmZTXK3/Sx9x5btLCCsM+w3X3nlqt2iKm4q5nvmNc+mGgYiPFUnNzEG1NKDss3DMq6M7UO2nEjSp+tuWzjxF3/Qc1GZoViL2+//QtfQn2XK9ZDWIAQLLr4Lqv6H7+dB6oJN0Q4kn3t937yut2nf9k/3K0JKdblcEsTWVuiYVkREvErEgno0tqpB69IXgIkhC8sMU3OLTUL3+xtTfJb7yECDh2NRokF6694XozaWtFDVAiZxGPh2zzPhRRZnu3u7p6/cOH6rYbZRhBrnc98kP3guqyoy/Vabix6XyG41YUimbDezK7bTZ569YtErixx87YuRkPP4ddbPLOI+DUcKothIU0dJoIYsMw17rrd5O2333n//fd3XSeFVLAAAiRb1malii6aBN0/G4QtiuK5d911602Qn2EXZ4pVku05veg6VZSYdo6cKZYKzyMG7E2DnzWKvUL+lTxemiC6EkcmAAyyogsTyyeaDSqfzU3e+KETOREctzmU6W7RcyulUcMyWse1z6E6OnEcNRHrnNYFmxesylmCsJ5dVpvrD90nC8fToyv0KdiQAuckDxuBqiNx90AzWesAZHjjvEHJWOhbvlD8Jx/+IDnGbQVhn2F78Dfeyn0jbC18K33SQjfwFVle6Iga4Gunm1FZjIdDY+yZs+fmVUvzUT7ecnK4Pde0WC837+ho2X7Zd636c791zZSHLudEMJipLQoFkmVJ+GfiSBoMQFjPTFA2FNdv2nzV92zvdTxbLwabXpQ7826v6jyTeTnMiiHmMnr8il/i4o741VNUTSBEt83OGPYBV+v5zvbv/Nwt+RzvuP12a23Kul0p7wmAhpLZfA7IxsDPWwtbI0CfB+5/YDgcbm5uAgJ+8MEHr889/51Xvz+IsfEq+iWRg2R/rO3vz0qp5Vhl6KNkEOBXKpkj9vpxHnSwqsyMs4u6Go1HUnBA/ozTJYwIS9BDbczCcs9yJtfLNfebD163m/zz979/vpjDo+90bMaESG+FqAaCFbS00B0Mjyv8C/CTMDZuO336Vl3ofmT28fumF2eUZCfWp22Ldic++cD1YDJcs82ZksvEZsln5mKjJAeAJ2XIyMuRFWXr1MJktR0FMaQKVbpd0Ah3k5XGYZzt95dry9DIoM5YpegiR7HYRgaNFV0HMmFsiUKWKdhjqKzlU66D7ePXA3UzH+saMQDsfGidq5xZeFhufMPJnIX//pH/55gDhhWEfRappg/+1kAGoquM2Vw4zizjXnKUdiZY44ULkkuqsYxJoVReMCrmna07B1j2oXOXOiJHW3dkw03zou9Y9WdqOZY66a6dedsWufJeR0sXhIKY407nTr2EHorzBKY8K2CbLoZb1+cOb/umH6q9KsYnGR9UHWlaLxhstxnMJjRNsaYxWnLZWN20DSxPBcqWW+O6EFDVm/gaMHq3d3GtlPLPf+sWfpSAP06cOJEKzwHNGKPha7RfQu9ZVEuWwmPi1eZ5Hqt28H3Ar3h2nOe7O7tVVQHugZ977MyZ63PPX//qv5w3tDVou9CnlQJF0bwQbYiwZJNxznFjAXQeHIxSSVwm7Lve9rnX5w5rp1unCaeLerE93S0H5XAwXFRVLGf2JtV9kBQ8oVGuCAJ2v9nF66flt72zZ6yJFT9YnKMN2m9HSZEAr9su2hFH/eCkXJGUB/KiSLCVRCJs27anb138mtronufOFL3Q1mjQ56PlB2BHLikXxjsdv4/yuM9qm6bkqR7N08MZWUIlLKxB4GVo3vis8WVHBpblUW8rzWtArhCUdxDPpbmC0yZJpAe0MUEvLjTObjMAsrzOWSPRhNah9xiuCTzKReFFo2MtBl3HC5Psm0In8SzoEHSeiMVdWBLn3PbONuMiGw1kWfBhOdzaIoNyL7hdb9+8+MgKMKwg7LNqzXvuzUjXzXd8NwcUG3RlbaskyctMBxO89c4gAvPogUKYMIByHOlgBosiG286XrSOd0RpWoQvWSltkX/9818siaa+C66jsPpxF7NhSTqQpMIadC7pnb0xYHeBG+T7lV/z3dcjHj35jT/06PaMDdZINvK0NE7a6LbIYMGPVaIxB+HrrhkU5Wg8hHve3d0OwYoc4pjgSMuZsdVOyc303e+45R/oXXfdNRgOYRMGnDocjuAFoBkAN6PRCDO0xkZxpYCHqNEYPlo34YkzvKONqRaLZJEAoPav77//+tyzI2WybU+J2OX+0su60eWaiUpuMBK9RYsKZkRorkdU8PqvMMitoV7gKTMgfizuRpEdPKNPoR6e0mOHMk4jGoK+9Lzg1+mMomq6RbVARWfMr2O3JVRDaG/P5pfBAVa9Rhm1wWCAQmV9utbExHxUZ7vVZ8ePPfiB4o5TNWeXqgqelZAZLG7aWgCvTCoKAR6ub55e7bxkuPz6TFCVLo4KWSxzFCBsoSng17INhQ6ZoQpDo34iuGScgASpRLvpD8RJXJ87RhpBa0WrnDSKdABho91iOJR5RfQWa5X6LOzxosMmjpzvC34RuXq2pMNCl+DRxaAkUnQQvgbfKb7nzYw6unEcVWBXEPbqt9u3RsxVrp4K3wa9ILYW1KJqkuuchy0aHQR9PGxJczu9gI0xU5k2oYLliueDzdOs2Mi/8rs+55uOtQMtDS0NHcdLcxQWhP3Y0gNjpIOW1ANxF/dUexX48Drc3tY3vfn+s5fmTrB8RJkKgX1mjiMd5krBM4G2DMGaYDtBnQwddRX3TS4sDJU7t9aOwwNdzOf33HNPiLIDAKtiFQ8n8XWe5+gNgBKTJCXkkgvt4W/N5VSEpr0e8lVcTQjL49ooI35FHEhRyIZF1yQaHIw7jhiNCdTDIE4RL4h737/4/Gven6bFmh+JCU6qJABCbdD1M5MS7oahfz1CWBV7TFGeMcU8hE68+lcfvw5dp50/d/4cLHhJz/VQrU64DCvFgICj5RCD2AbwrkWRLcQ/eGjqPYyN8Wh0HCbIjzz6Abo1Oa/rhSA2VyaTDQsNhLpYJyghmIN+uQ4n6/u/4vK1DJYvz1zAcy4LF6BYmiOKpaVjmac5UmYZD5f9O4bGJCvtUw6wfGtGNA+tII1EjVg06xJUL226kBOdasiiV0I0MSTHjw0byWYY3bmk/oqdgDOdq8HAKtEIVvEwpe5cV13i3m9OXrN33CkEKwh7ddojv/FTd51ck6Exi10RIMLUgGJdt4jzN51/p5wDxpo84i4R14rpdNa2HYFwe7BWTk4NTtwWyhNnZ3rj615/bDuTB1jAMf/K+pXQJqtDmkL9Q9OdRPUHiFSt55bkL3/1/3vNE2Df9pYHzu3UsLcM1gIrXBQCjhUzj6tMwLsbD4ddWy/2dmAYnNxcU8y29Z5tpzTUIrS3nRh+/H/7uWPyTBfzmZSqyPP5bAawJo8mtFVVTdbW8izxB+L5I2LZJX5N38bqH/gB+GE0dpLywvnzFy5eHI2vbfrh29/wFxBgksB7LmyvLsJ6NTes+QeYyCTnEv7jDQ1WMCuppuaaM2Jb08LyESTzgqpMwVbnjLHeYwqPc+NRFMUjpxIPBAThqItuPPfXw87ABnLmzBl4alECliFDxPVr4OPU+XudYGwo29K2LcQ2WZYB8E1asKdOHiORyzdf+KAdFufrak68yxUr86CEZngUBQ/Uh6sJ55INwWdelz+d/R/GuUhtkA7QKisNK7qQNT7TIXesQC3Dy+y49n+FPfg3A9Z1MSRuNpLUAGElihJ0HJ1m06jsk77LUsPAyfFqS9u0aNDl4tIXkocsSlMzZgSd264hQaOEBXmsreza4E07f7GCXisIe9Xaud/+2ZPjot09P+BuIDxt53p+ab1UmUBzYxpFYjPO4GK96zqKkARrYNUuipEn4uKs2WsCKdfJ8OSOzeiLX3lcISxAASuoiaG7jeIs7slquZahK/R4eR3u7WN//XDIhlt3Pq84cXuL+FX0oDWGJYHu41e8qb3pbtfUhRTro0HGiJ7vCteOFSmJrrbPXPo3//JYPdbbTp9kHEBVqKsK1ugxtMnk/PnzKssGgwFC1njtk0/7b2NND6DYxWKRcnVciNls9pGPfCTLr7GMA80AFnqfNMcxJYKSWlFeCzOLAGEJmpYzeOUs9Z0gACk9cdecS2DhN/JkWIcQVjDRRRcrEeXPBUQBiGLxJwUW3GBVqeu8vPb8wkXdnD17Fp7XeDQCYBpJIjZxBp4Mg2HCmNE8z5um2draKooC/tJoNDp16tRxW/f+sbvv0Wb2WDOvFRVrYzEZznU3bxuDQTrFROz1vZ+loBfB3+xhWYb5wDJLsy6oxhedH1iEsMJRBaF8D2Sf+B5hEe8oZmGRBYtOXQw+I6BYzalZChinHACaVLEDj4Pj0yIjzicRI4eieMFBWEyZhaCU0YXVU9vNuZ/zsEvdjnA/enGFX1cQ9mq33Xe9/cQo464J3ZzaOqNmlAsu0OYAj0Fhx0N5Gy+8EVYz0zFnCiUFuo3ipuRYNjP0/Mxut5wMTw1uu5t/5fcctz7843/xZZJZwRynTiDjFSaywwKV4Bh5Aj0gXPJg5RSZkNecRbD3hf8FycZqdCKosSWSijygUee+2kDYT7rH+nXfVotcyUGRC2tdU03yLDed2buU+bb4k98+hhPk1MnN4XAgJPSHbdsWgGlZlov5vKoqumQO9NlsevBtBEIojA/4Rncd/MWEc8+cObN3LbXuA1UhSvg6RxxmhNm+qG9wPOyr/sIfGfgJQI2Gozh0d0370H/rPUTyAHs/xL/BY+VTLH5CDzRnA0BGrDrz0XYh6hIYZ1tNjNv+pQ9c0xsTKpvOUFYMMGuntfdYogfLnxTiSntP1HyFR3z33XfDMNjb24PXSqmyKI7hBPlnGzsXhHu0nV2CLsx4bY1F22zFpNTGPluE9HSufRS71Nln3ANU5bmluSZZ41QbsMDLkcJS5Unmw5K72Yf0++oErv+Kx2qWE0CurULL2VaRTgQUiF1WNaT55CKE9ccpEZuIw7HaA50JYXZ7vIjjqHhiOCWDzOTikm0ea6ZTRd5mH1nBrRWEvSbN/OGvDhVh7VyYOqemrabMuxBTIT5EIz2IrJwOtoULXjBY57VujYUoV2UjWa5rOaxIPnP5IpSNGIq//arjNRY9GmgLCpMX4L6JWVgXNVvoE878dNbCef6N339tWUHuy79XDNaLtS3PylnrZp3XRFpK+0PSiF99UvSOiJZRsrmxnkvp28Y0VQaox7aumQ+59+9+57GdILffdrooSoApAEYXiwU60Ea1mJ5LEPmyqLlK+m+XuqFUSFRppdEZPHFq67q+cOHC7t7eNbrVl/7ARwE/AHJ1saw6odh9M3hUPkIV1likGTBvwryl3sAAvrYTRAqAsJTBkuIs4EQS0AMw1vZHRV0jsYsYFrL7oCgPFs27FL+2vgAAcSCioKTHo9BBkStC0QiT8yfL8qHZbDSPHQ6HXdfBA4WPcNtttw0Hg2M7QeRztrapPVPt7XYthPI8VyLLCOXJpvlqP7UnoBAcWlr75xSiUwELTAaWeZbrkLUOL+MxKeuCcoSjHdfj9Vzh0SZBfhtXSEBjnYCLNoo0qucS2KUz7QGYI2nRP0YPPeVcPQnIDI5CDSHieEMgIPYaJlCZT63e1k03UBv3PHcFtFYQ9hq2xbvvnQxzCVsMIJfpjnWwh8Qq3FTCBeGlt8QbjpflDN4J3tlOm8bC9xnLx0GOqqB2OzLcvH2qw+KLvn30da87Jr3nnEbAChOZ2aiRiGmay4L5NOcv92/hqGZ1DdvgJa9tDRmtnVD5SHtatbbRXrukvhmiVUFCrjHLvkwolEWB9kPopuL0YlFf2l7PVXjfrx/zCfLCF76wKEsXNQe6rkVTAyEOJO6T5ezy2971AF2caCpUlxJAWtwXrS3Lcjqdnr9wYXht6n5wC4aoyrMlLzcWm0RSLJb8x+R7QAUKQaMfbnA2eH9Ne08qxVkf0AG09gatZUWcJ5j/dIBWeYavMWiWXCaBzkFxDc8oRuPJww8/rLVOnsAAV+AZ5Uj/EIlf8wRV79HVIM4S1J1QSu3s7MAjRvGKsjzOs+PHznwwO7k+DXanXXjBoB/RohAr1p/VNn1l8uuTMWJJ707HEkqI6gQQuAehHddOGq9MEI5IF+B9VOfAY6lewDsG8/0/iMpQJKDNAYReghrBdGIRMMwyImJbIt9U8eD4VTDUvYka9bGMC7cKwAd4bIsbCWcA5Q0hLXUNcXNnQqlOPPfOf/JX71uhrBWEvbat+t2fHxdSL6amrVFUKwQTEr4hsb4+KDwn8YqFQqEuJmw/2ti66VoNoWoW5MCyUhPFynVWTBoiz+7ORy8/FijW2QYT1XjihAJGjPlkg0QPonv3uDxBIJxdyyTTHd/wgwBbs+EakaUlwgbuKUpoJcX7KACMp82pyGf/LA6Wo2o+Zz4MskwwMtvZdk2l3/fLq9lx4fzZe+65J4uVO8ZAFMeStcESNUYQewAiE85BGSbArDRa0bKoJwrvlLE1TfOhD33o4vb2NVgZOU0WOckxx/NYfMQ5xTphzCzBZuthr4Hvo0Kx7bzV7/6p511LDMujhny8nRBq01mPkR7cQoKwsJ6g6UIkJwHgxwQ25Ts/98fX6HYma2sf+/jH4aHACqc7zEALlEVg1jn46vCO3JILGx6PX+MPw99NrrNbW1u3mIvsM2s/8thfyPXxtGtcrHfTzjriZS6vz2//DOAYVZ44plcBoUpPpSNce6VDpgOA19zhaogmCD65oSKQPfz3NU0uP7gmOkaiRmyUIxBBCwS1/lB4g4dZ/DIewnFoMd6MNVzJhRszWxwJFRx7r3H2UjUnA7X5vDvf8pE/Wk2QFYS9Hm3+rp8V7e5WTopglLfK+yyEjDKFGaVopQm7i5So/2c1PIFiWE7WJlKJtmnaagGjWZbDRy/sziw/cecLbr/nP6po/tgLXnrrx6OmCU6jIDueX3GPFSpR1JJKggaaUc4B8aIL1KJiIlGOZC95zbWSd15/2WvPV4aPN8V4faFd61E9IsuKTAqApli/QE1ErpikEB5iEzQm5fiC7Z694Nsa+QPzHWHmgw/91mpepDbd27nrrrvm8/n6+pqPXgZL3l2IidcEXftvO921bRcdXdmiqrpOcy6yPIevs/m8bhqYTEVZAgx65NFHr3JAJYXj3C/39WgYjBLzFGAhZQQ2a7TS5JTBSBCAGZ03PrSEXCsuQf0Nd3nuOmZ9qgOH32gMsSiyG2Er7oSwwACEFNG9PmciC6Ig4to9yo997GOw+Uopu65LNFb4/YtFdQkjihB3Zn8IDB36T2zxOfJLly6toTZFtpoaqb1l+yO7gu5xOmN0Zn0buMwHcVYEeoizGosMlzHz5df+D/iDn4kAEfUBkJiFV3zdi7OGg2sfTSZSv+PJ9RVHHGDWwoRSh1x7JMXaCF6TCNblqGxpNovkm0Svwpwi95oHI3ynAL+GeBYZKeSo4xPQIIQG5oiwlN/89Vz0Sa7D0cI+Lyna+cYFBgI/zowQneAVZwvB9mh4pJqNn/+cN37sT1ZT4wkb39zcXPXC1e/Ws5+Up57vYM8xTEbLeMZY02gDoEwqInPrvQ7RlyPyuIO3wTvGghAUZQyChfE8mGzYwLan86rpJidPked+weTzvlR/6gO3ZI/94T+9U5K5YC2Sh6lGO1bMbXHvBSWKBeV8JxUKtXe+7ZwLLKdiMq3LX/+DxTV5gl/9qpkXXTZqaNax3PPMMRHwRC8wTC91cJ/WQZxMJM8ZUV0XFClKOchZZqpma21EmrmenhuJjr7/11Yz4vItzt1+x+1nzpwdDgeAQV2U5ogHpiRm7tBjFt4BVIQEWUYxQ8EiPONY9xzdELDUXULYxzkWfEX55abrJmvrV+s0/3u/ccNTFwKAZl9kmYJ91XqnzVK1kuE4iMpunsVNHBPE3PLif/29ayKtxb50yw+ZFc4x5/GAIkiWiBdR1QjhNABa2AEFD0gjH7CCNp7Vwf3VhWtxP+cvbkMIkTLi8dPzqCyBJeYCZmncnWMNQBiUKDoBDwkAKzxWiEd018EL6wzEHpPJ5MTGxmpSHG5/Tquve87frBatBbzI8kJIbjXRHRLHORFKwkRwHgUfUO6Gx7JWsq/tR3sZQpZO82msssJ8Jx7/xar//pSfRVXCqBWHxVjLYsp9gIXyrvCPyxRTwhYF08GjgFzOW0mrjCwK3qBPAes48tddiCzs5ARCI36GVTL+u1ieG0JuQ+HCwLNx60e1y5GQEPCTcGojX0g6j+/4eGpJyTO4jjyBe9izl/ZuvUQpaYyGlYpTrnKFVIE0NzASxViUO8alpIzDzgeTqmFsTskODfNMFM+784fv+/PVpFhlYa9303/2m0PXlE4X3rKu8W07gI1Q5saRBv6flZQJAK0OfX9gPFtCjKQoKSWDRosiIowYGFFqMXTFBh+fqsXogZ3OveQ1t2R3qVBJ3yVZlagSSPGQivEY5+MhVWQiokM9QgnSWCT+DzS9JjzI7BWv3/FyoUYLMahZ3lFluYJFZpmhQEIzfBUK1h3hUACcZmzAfOFb7jVdy8cAzVSwYxma9/3iai58Zmub5gUvuDuWcAHwL9qu7cEQpUqposiN7tBZNp6Go+0mZfulcyjVFLcJB3Fg9D5wcT9fLBZ/ff/9VXt18qBf/trHgso8xzNSD7uzt6iwRUWUqhURNwp0kk/kVI7WbBQQLL1WWdggnBEWLoSwNFLGsaysz5z5iEMQ4kSvTgUd2VplyVhcE/Wx7Z3dRVVxPFASqdaIJh0JnAwxqR4lETKpMpXBs04Wa0WeY7Jam/gCQhW3tra+eeLEajp8Zvvhh/5MnD6ti8HMhp15A0GcwuIuxTnDKmDTQfjEJWNLZb9DigJ+X536Ms4r6xUG0h/7PhDrk69JFWvfYBZTthEBe+5SuhdewkpXGDo0BJbdAayJGoZ8zM/GBGL6XZE20NcGpCIBjgRyggYJ1AFSw/yrAhzsXawI0cx1AlfNRuGvE57mJnAf6DNNxB4tifaABBUO5WKXojXJO9dZjyZ0sMMTtN5CCQ5R5BzP7iA8xeNZLnac2WWkHuT0ts3/7qGVhNYKwh5Ra/7oHeMSBua8XWw7PVeSZjwk+RuB9ZqSIatSOqTW4ZYUhXtQDwfN/QhD7RzPFM+LbMBZLnA3knu1oV/72lPf/IZbrK9oMhb8DAlYmvxaEp8O1UJd7B7p8SSX/d033XfV7+T0t7zxws6UyQy2CI9ghQMqsGjeTe2+yShBiSVYgRhXgBgA0grUkTfE18RWiulmtl1I9/y7Tq9mwZPGeF33/Oc/H/OvycKgpxH0OvhCSiwJYiy9G3qhraV6bPxpH+mWWHglUNpfCOmsPX/u/M50BtjpKqBGOrQhd14Zx4wVFgYoiya4FE3iKXPRGdLCROXUY8YKadz+XW//j69Fdzm/LGd88k066elywmH1aJsW+ufiO6+BWAcXyX4CnpqIr0lYfrm8sQhydeQYQAvRfAteZDn0ql9bW/vCL/yC1UR4svbGh96X3ba5J8hZXS1YgI4jWeY47yJnRYpMwhpFeeuMEdTGwYdlsH0RFXJVM3Ql8DwST7hPCftljvAJF+HDwMv37q80oVvfa+3DvyY8AWQr4sXit/skBIjq9pkr+xpbh5FGgs5Y2sWizCQ7RIY9IJvcdLBkSd64nObRkyhYqNq6s5YKxjMBOzo2hjs8rFddZ1iWaRJa51saKkrm1M0p6UoJT/9H719ZcK0g7JG255weKtYQM6e+se3cOw1bcyaUgYGLjgeSE4FHkoHb6Cvn+yiSATbChUrjtimo9I4KWQ5Ha3k5aQ159MIO/Ypvv7UgbBLbRFpFKts6oHZhSscjhkT3EszcpXXQX5tTo8fObzPMkUOAIZCMi0k4XNIjioU7W67wLhiLfE0swUaRew1QRgknSLvYO1fPL2xM8o//2o+upsAV2nw2AxTrvR8Oh6g+EEu1tAZw25VlmRJ7/YFiOqWOGC3m+ei+9lbyrQVglOeAh3P4s+3t7Y9+7GNnz517lrdnXGFsYUkOSMBiyokY7+qu8cTiOQEzlBmkaqMYDkE9uLSeuqvvgrvxui+0n8WlKeoSRBjbW141TVKHvbrNuHD27NmkDgG/xe9D16jacNCijoOL7gZFUQwGAwCvXSz5KvIcoo2yLF74whc++MADq1lwhfZfPfhednq9ydgsuMqHBouDAUxyPP0RkmDlnNfWRxNXigsQ6onSBB+lJ1mUC4iGHGQfv1JypXVz/xCcxXAd/5bz6e9CKM9DyvYjhEUejUMXONy9PFIFZDiAx/Iyga0UEPakWd9LR6HoTER8/fvhpockmN2OOSi/r7FoOfKAW2fRcQQ2fMUh4GYSs6+cUmPNvK47mBohdIzA893V7SWj7Sgb3nH6zZ9c8V9XEPao2yd++Uf1e39uayIK2u1dfNR1i41BvjYetvM5B/STTiSjgno844nqJTHzlzEZ8Mw8oBKXgw0J9susHG9NNk5no01Wrrc0b774W+iLv/kW6KU/evsXxuPivgsSfmU9rmX7y5tHJSHUBCDI+Mc18+pH0y/+dk3lcONkkIVjimHFbTpKTglyXMDjiguPLEAAbS2WgcNubvWChiaXRpDq0rlPn1xTj/7mj63G/2dtuztY3UWjyr2Pib08zwGPAtyJilp8PzN7kIiNowHejywyZBLoTrddCy/hr6DagZTwc9Pp9FOf/OS5s2efOVzzhUXK9YDJgktJIEAhvmprG7rAbBycaS/Grxxpg0yghZe96r3UGv04aaqDyhuaNIxoQBHW5NOJQ7SrW3q1IawL9OGHH0qxxGRtDXobwo0D3azQ+wP75QUPMam9GmPqukZhQc7miwXs4Hd/zt1nzzy2Gv+ftf2js388uue5Z1z7qFlse90qwUcDqrK61XXVBUfigUN/lO+XxVwpLSrQupD0VFe4PO3Lti4fP49T1GJLvBtFhnH9TZkVLCP0iFNRSAsuSxS+wNguOcUC6k1asJFbg3GUQEosdRS/xt9CowUXdZw5gTRZz5flZvFXHC5Pu/nwK1vOA0p7RV3WB5cbWyfGk0kQdL6oLu5sb+9tN7qlUmR5IYtsr234ZEwG5ZS6baNnsJSc2nzDx/79avCvIOyN0pr3vC00l9YHvBS+mu9Ody+uT8YybjkhLTyexiwsQ61YDNaERWI8RY63zAnLGh3aLjSGLDSbamrFcHjyrvU772GjU/rF32G/7Ftv6v4JANJpAqyJhYWyA/GsmB1kDDBkd0vL8AwtzehVhrDF13wPLSchG+4uOjWYcFlECS0MM1joBTlZz/TA7APjGfxJ2zW6WyhhmZ01s7O2On/qRFa955+vhv1TbIBBN9bXkzA+ANDNzc2NjY2maaQELHqlRwwAV8aG1S3Wtdgao010RcDseDkYAMy6ePH8M7uxl7/ug7JYo1npuQRwzaQQuchLjgKYmJSPfOxgcQvHi3OHpVSC+t/75f/kKneR94yLK+zryIvFo0mBXNjIvfPGtb/y8at4D6ood3Z2ILqYL+Y7O5cELl8BQriDWUwezyVQWQYB3tkzZ+DJoj8w4/Dz1tqiLKtqvhr5T7H9wIN/bE6vX8rZReKmnJo8N4ztzatq0QgmJsNJXDvZknjZO8el6qZl8rU30OL+Mvx62bNL1VwH1FgCEZvA5Gu8XJKGhQUR35cmCONhl+LOwzv4ftjPv0ar1EgJs49PxPYWsg7NuiKQTbmK/cQwEiHYzYhKIsUolmxgd/tDvORDoULSvkUfEo8VqYwyJViZk9FgRklTSDMsmzIrnnv7f3Pfn62G/VNsYtUF16fRP/m1jW980/nZTuuzICdB5ozy4DnEtQZ3HST9Ib0Pizkx54cnNQEluADpxpMc2WJJCarlW5rTIt9p57CzCVrysWqaBfnKV25tbrS/89M3JYSFz0TRYy9cLtDS8yOxdpNzygxWYhtCs0gqECRczdFrv+Rbai9IOQpBWkMtU44BSEHwaqOaEkvSNKEve4XHVxQDScNituO66tS4MIuZnl9cK2n49+9YDfin2z7n+c+fLxbJaBRw52233TabzbuuS/wyclAuTfvHEHMdNBZYJVOEVBof7aIQvxZ5DpMFUK1zVms9GAzX1tafdoivSt1VDi30rOIuUywTGXUIXlMtWioER06fY8yj8IjAIOcqcwks8YAFLemDqCdcYCDeRe2xqDMJ8wTZ9le1/fWn/xpgvBCARDsIJOExQZ/nWQaQdKnOdHmiOBakw1vwCKRSg7I0FssANk+c4KvMydNsP7b7yZ96wRdPHz0HATPsFetKZcWQWkdR9MYxx3w8+w/pyAJF33w4vIgmbBpFeRFf0sPINWZtD5bckIBsYreG5JwdGauIgFFbgGLy1RDArxC2SxtLGZf/BNprIR028VldFCfAlCSLks9xomApoos2jHBhFjalLJfIO9yU7rL+8uG/BOQh5sV9mO7tYT5KiSzPZJZ3puNCoSlXQP5rK/nUNHOIBseDH68fJA88uBrwKwh7I7bd/+OfrX/9D7lFDbM+aMrkwKFcFJ7CRG9N5BphBIrpWDyIi2zQRJBlgWcsWv2h7CNh8w5iOYXn6QLrUvNiYrp6uzbiFW88PWB7//tNlgKMENaTvpwL8zpseZrE0vIQD6aCR7/PuMRK6LqXff9VSzKpl7y60c7ygtGMZoOszCvto5i36Em5faSNaXOMt2GZhieBVlEWD459R5yTvhoMQnjvvauh/szaaDgUQpw7dy7Pc4t11x3Co6XNbF/tFTfZ0J89+qgVhJiV9NEOsk1iOh8QLe6gAJ4ylgeEXNOdnd3JZPyCF9y9uzt9irfkKG+1Ft5QzBkhZEiEXRKLY6KXMEGvkqCoV8TlDIJKGDJOX+UdMngmRTqwSSvG5QAX1/EIFxARoGKDp5m8mk4BDzz0cISpkgs6GAygr6vFAqICkUtXVZGrHJ9NCIdsR7B4KwIqpiJxFuKKrc1NpVabzjNpb/w0yin+yOQFpDVcZOO1seiMqbWZN1Kgz2PcM1JOE3cKy6LAx77sK9Yi4grLPSZB9zO1h3OE++VcaZr5aKGBGf6Yu0WLA49a3CoWimWGZCYoi6W1PC3V1Mf0Y1qj8ed7W0UshY17GUrSUlgxDdp0wQs06HL0cXq0+6IIN8/+hbmnsA9b8bMmzkYU5whocSaMs8FEjizAd3g6qZJNcK34jJDzzppcvnXvo6tx/rSzDKsuuJ6tetf/fMfJQSk0MXvBzolbYAxGHZIuGY/UWBG8jJrQODGsJwBWbaBCZETkHlODReCDaROCHPPBiaDW6lBoOSlO3CUmt+0Z+fEHL6qXvuY53/qDNxWE1bjK0UPm2GiUbXtWVtzEl+XqUceQZleRCBte8rqdjhRrpw0vaqJ4Ni4nm4326FsQecnxFuhBcW6k/AF+1V3nTDsqs7VSttOLGW/De1cSWs+qFXl+xx13AIS9cOFClL1kodcgSBh2ad4Vi7sitgvaoP+Bsy4xZR3KNWFpUdt21jmFJV551CsFOCuNtZ/81KfOnH2qLMyXf/efdPDPMU6VDLDfeN20tfXR0DzEcMarALDVwSTOGUSVTuKpv72a0lqnXv1FFu5fPD49tb/xx+QzEl8Ty4VEElKpiqt1A4+dPQd9mOWZtUg7hjAjQ4aASloR8aGw/skcMldD7IKKvQ6eqZDSGLM2mazw67Ns/+P00/NCnTdtpwRVBQzrru24Y8JyCWFOiGgRGaiwejLNcUk9fLCV2AUHdILP0FBO7/fc2SgSk76lkU4gE7/WBmUIgFe8XLTsin+6PyxZOMilImhjvcIXYFmEsKgCS3VEsS55cbHlYE688pvTnWuJvJPIXs/BQJYFISfG41Ll3rq2hv+1rTWNdy0lWrIulzuCmM3RW+tPr4b3Kgt7E7Sd3/yJrW978/lL87jbZAHQGM0pZ4xKG6s0/3/23gTcsusqD9zzOedOb6pXg6SSPGPjAcwQw5eGBAh2MHbazdCENgGcGEPAHULSDGEMhAYc0oDDBzgQzBT4cDB8IQbHhm5CQ8BpiJmMJ1mWJZdLpap68x3OsKdea+1zq55mS3Vlqcp71dXVq1f33XfvuXv419r/+n9Hq44XYSn5SJxYpWCLTpszE3Iw2vQsWAtbm4M1ANaUxjrJlB5sCiHuObz04fN3x0982db6xPzxr1wHkz9QFZZROwqeLLm+EkALWkipLBWkUSKAGbQfWhGELf7et10+mLJy0ogCJZHUwElDAn6yL8GSQg1VXhN+Rclu8lzks+m+NPHU9kQW5QfvuXjb2a29PL6vOYzWc1iYUI9JIwQid4MevCaYhBUnpF0OBpUgh1JnrSAzYjzc971Shdb443t7ewCFDUAnhfJP8/nCeQfPd/sHbodvnjixNRqOH6nEAruPqgat8k09dYvFdDKoWFLvRyU8xWPBoqYWax2lDJ45F1Z4QWZtYyUKVAXuH6oSAauBwrMbRgoaXHpWKbOSUvC9l3dg6G9ubOzu7EACAAlC0zZSyo31jfliDojWaJXIxzFVYROwpf9HyhxG4/Hu7i6ZCuftZgXx/Qfv+0Z+s/fxlCjGBnMnVLdJHhuI/3Ds+eRznU4nPM2MK1RXmkIiXIWv6Sg/3lepQKTvpE81UN0A0/iQ1l+NUnOCRLsiyneTlYXAAkwSlMIFFE8MKLmRPKl9JboN4VcZWh27pAImUAWd9/VarPnG69Cda8nHWFqNpPtETGeiUKVA1awInxQvjDSq4bHmoenqXc/3K/Njl/86D+wMYa8jFPuvAX8Nv+ifHc3r1qoohqbkpqggcwMg2nneModFJm8D9mRrpgSM/tajLgdXutAaUR2AV49bm+VYFUJNccmlLgpldDWS2zdH13m4fd5rS83t2378SXs13v5Tn87ac6RDuCwZwKJH7tkodh+cEAbwQdfWsDqXg2LqZWNDkCuAsKe/6JvvnAc12iAVWKTYeiZntRVdYwYTeB2NRR4lPHKETUN4ohZdRMwCa1DbDBXTrr78kcvGzz79uc/48H/4gTy2VxIb6+ubm5vnz5/vukBIKAoliCSAcgSp4kfyW5YLBFVYdPVOor4WThj0EPLeOQtjSVGQsgEPoZd8D6SxCgnh7t7+bDYfjYYPA2QjH+0dXLStXat0UZ3gvPKuhd+nULY9MKk5bOKpUQW2KICRqPa/0tMtjoZMqAvbn0cweR/FogQyYrNo4H4ymIiWddO6WoVL2f7hUdd1gPVn0xnkFMPBIElnEcO1xjxBYZoHFzh146EiBGQOpJ8Fl70sB3DZAb9ub29PxsM8sFcVr4/nv2P83KOLezep6szmZDadYxaFQFaiSam3Dp0NkR8Ni1Z0TiN1H/8SWa+CBpMmELWAq2TczXrbOWTIxHT8JYm96rFlDwAvTC1soDScQ2qoWq86VnpeAJwNS/lYyLEkHZOhxSL8BYYgt4JZjl2xjrSmushazq0WvuDOOCscWe2lfiicoV0I4v7V/OsAv8IyJCQS0BW8e4fvnfemEMgNbKYLwvPSCVjKdLG1friY7sxnneL6pjM/9sE/yUP6MUc2mH3Cwr73HVsv/IxhWcDMPtg7mk/nEjZcUcDO2LmFHgiOvZ0w5xGgRuSTFVJpWBU665REVel0zqNSosslrFIsNUs7gLMFJykDwACz1omnvWj0/P9p+1M/d/auP3yyXYev/MJTyh8ZPsfuqaQSiNUmWl5JsCitrZ4hhOeFaoNsvHz5Pzm89l9d3/Ipcz6MukKSBteWK4vttigOI4SCxZXsElmBtFeuyTNcIM8jSlzTLbNN6I50aG45Mbzwqz+Uh/RKt4U4Ho9hc6vrGmBpolQuybBICUCabO8oycXy35L2VqIcoHq4EGkvDGRcSwiYdhLYiU06ChfwPEdH09lsCs904sQWwOL7vZBff9u9r/7yTxqUkLaULEgLmzDXHAWDNR4VBhkicWF5IWXFzKBB3yLzprddXNWV4J+87dAChSd3e2IlLtu/kxFo6nkkOauhLDnkXAvX/uK1un7Adry3t29tB5cRrl8idFy1ME3aTJjXxbbtUGegqiDRS5Xa9bU1wNwAf+Exa2tr62vjPKJXG3/YXH75s16IF9mhBEdVlUIpSNvmi7rz1qDfk7EsApo1SpEBcVI6C3SEQQscOlOIZb9X3ynZ60GlKiw1YXlspyWMiTBYeskaEWoRpgMxH8pFyZtC1KY/O8PfIqgeG2nfIrtFJ1CkNskT4sG6Y0MrBh2vFmE494M26sBNECq1muExIxPXoPn9sQe/8K5hU4arg1RAmCo1bA2wayhYZHCnDmzv6NCMRsXGeqyKg2D3fHvEId0cjm459S23Z/PYXIW9bmP/za9/6iu/tT08GgF2lQMeakhaNR+OK+l407LOwXKD/2m0pi1gMnDr2sZaKn5giF52Cj38qMskWABXXqA1K/ybNrS/iqlrupk/ambFi79B+GZ7fXTh11//pAErfqn7Snbdqdmcp1MsvkxzA3G4cPumbF88CI3rUcb4c/7hrpOhLBGdInKVaQ0XaKCA5AYbPEAVgxzEKD2WugG8GoWvAJYsb+eym1WiO71e7bz5dXkwPx5xYmtzNB7v7OwsFgvsRAEwK3B79M6R+Ct+YpIcvFBIP6TtGcaJVARfEzfWEXhldNiNGh/0hxGPtu8LYxx2oJ3dvcOj6QCi1J/4rKfe9ZGd9Bp++F/8zQv3hs3JaFyJSm3owRaPDYsW7kNog3fkiMxFKEQwXhY+FCEMVngRkDQhOYm9HnMyekAhFlW3rLM2yC6IcK3tMI110909bCOTMmULVwpO/f9oaqIIAteJiAwvk2iyJllRlGXFeVuWxebGWh7Jj0d8850oHfoD2y/cubw3Y3Ei4OLLKNEC0sHHAvkaHszLgMYrkFbQGX9SeJUcb6RZ4eIxWTSekkBigiBLtTeRoRoC7jTEUuAyomOCRjmtiBk/kT5t6hhYChnwJR3WE7Ql3cikO4N2dgBqOwm36JZatgl7ojBPIs5Gdl0RYtHjA3dchTg/SAa5RO29E3CZldXSxcIPq6bQO/XirqP9utKj285897m/YJfyKM4Q9jqPD/0yop+bX/bNkMTVbdM6zEFVqQ7cvGOtR5EtqRVaeMFmif0tnA+Ugk1ZctLfItAn05zHai2eXHSypLoslZ+U8CjOVXjWtQKeo6lni2lzOPi8V0+G5vA//+QTP/vJi5u0AntY2huU0cKW8nkWFRXaYuJlBXatEHb0OV+1gHVYV0yYyI3jsBRz2qi5JUofgB40aZRCSTxLi66V0SutSonIyLddmO+V0t+8CclArr8+jlEa/bSnP/3222+3XceQJkBypN4XRYHY1Hs8K0UGCG0jafwgVJVs6UgbYu/8mOS4kpY6GkclU3h6cCrWwvMdHB4d7Iede/eGZbm1zk6fKn7t13//KbesPeWW9ZtPbZzYgPSyLEucglK0QjRMOY46GXATPmjLCq7HX/zaVZ51YJOjwD6YY1OG369lW2JZTXQ8eOu5DRqNPx97CKV37rnQNA22bSnVtO2x+tbSBnRpuYRZhFJ0SI2XHCtPSk2nU631eDy+6aab9vd28jB+/OLbL//5N609czFr13y3rcu10QTAZTtfhM4WXCpjIBXn/ekWE1TzwM8MubD+yufIjjFiAXt6jzgVKyLUGRaTXgyy13BgkccsdnEpF1EvNvTtXzhWe00u/hDVSqzIWsFgMW0BxQpyZOZXtBHw96M/sr/+PgWtMHOz2M4idVHC9eta21grZeRFJUdrRzxemh+eXxwdKP56cZGdu5iHboawN05c/q0f1p/56qjWymKjDfZgZ87GRilWGKO1kULXXTufzSDpLYrBcFjVdcOSewrWYEKytsPNDtUL0MAWntNi4xE+iqtCatRdKdA7xZrBBIBs29X3HtXss18F4HhYFt3bnjApKJJVCX296fgm3TvOeiqVeexSEUv9FWy0euweSO4zv3y3ZusnT3ahbMhCVtBWLJacfBGRxqUhl8CiQAD82tkGfrnWSNfgzrp2GprDk6cmGb9+DKKrF085e8ulnb2OeMnwcW1OJnXTcHLzIlDV+3XRuXaiyjLqhveJZsCOKZF6CqznstQfiSBYSUVPhU2DPgZZDOsu3PWRvXPn2fsrdnKTndzip7bWtzcnG2vD5zznGRsbg8EgjkbVsNKlkdrA71UiKBXLz3n1b6327ZNYpkCiIL+S2oX71WJhqhdSBqGwsQs5Ro9dXVOX1bv/+t3j8UjQBUn8hGMl2Ptg41R/hXwAVqVBVcEHdM8998CidfrU6dl8nvHrxyZ+9BBJI986eoZDeriaaAXQUDgBW0iUvPGdFFjyUIpLar1CkTacBLCECm10PCYT2+ujEYpNpYUg0ZUN5QnCVRst+BkYHBIQmw88WWxdWc8jyhjfr0yBs5gzg+dqSVeLoVoCfRFSHklzFqkLHg3X2XWFYuHFrwNIrefz2aLlcm1tragGsW3nXTdH1nyc2vrybG9fOL659vr6Qh6xGcLegGHf8e/h/uB5r2RmfOLmm4qN8dx1c5TfmDqujar0oOxsrJvFYjatBkPasnFVkbG3ZsVDId7XMWmdoeYVdLiCtJajR7n3BRdlucb9gOmWWUDLbQ2/pXbsb/1jeHDpm/K//fzHvArr+PEl70pKvkzo08aZzGapBHusdPDoo/3srz6YduPJRisGjmk8iCZBokBNDIGOyTyu0Q5ADuzfwtvgbYkQgaMbUdPaxbyb7p1cK3be+m/zuP2YxckTm1zpO+64A7Bp27awTwDutNbiVuyxJwSPOGWv7oQHp4GoNUnOXaQ2eQJk1M9Slhq+bTv845G92Ql6ECE2gS1hsDaqSojacnZpn13aie9h+5XeHw6Y/C/vGY749nZ1y80bZ89u33LzqTOntrbWT0yGa6YYrfyNR3r59riM57G5chU5cKGVxq5vwBTiMULYyfrGe9/7Prh60+l068SJBpebeQL3Pe2i7+ZKCkJEYOBcKvwgGswfUFACLn3TtpPJJOPXj2W8bnbHt24/5+L5CxMnzlTjCewXPjau4wqPrUISxhLoO4DHWTjQe2eO/sM8DmQZoth0+p86KLG3lhNPh/QuJKJhgJp0I+uZ48lNKtgun5E7omsregb4gijdwslIJdiYHoWnBgRisf3peqvCwvWtFwtmozGlhEWJ8SZi3tAMC6dko8UH7t1tSjU+e8v33vvneaBmCHsjx+ivf3n7f/4/duc7uwcXy43NcTUOUk8X7aJuCjM0shJGtgI+tpC2EDwOgoWFe4nZcaB7bJt3dAKPpSFixns6OYqkUy14AQ9ynnVYv9VSRVFAvo5lKGGn88/6WgVrDoloDgfF4jc/BnZfqboU4gN8D+9jRERdBiSXi1jlMa41X/C1XSMn26e5Gh0sotQIelzsdVySdIziUaEaEEN5JJQZtSoGPFBFonHbNAtvW6Pi/PeyhcHHOqKzT3/KbRd3duez2fToqCgKgf3XRPuIpFSwLMEiDk21dUJc8DEytkSz1OPVWZeYBjDw4SMnbVPR/yyTHarVecEBClalwqJQCI1r+LyOB3N0ijOH8uJB86EL947ft7s2vnM4hARzWJqq0OarXnL2F95+bpUbJAAIeX/mDFZlab44mj86YvFVCaHJsl7yxyKJMByv3X77BwCMKuQZY22VpBtIKYi08dkyn7yigamlLMvSGHN0dFTX9WQ8nqyt7excbpomt3A9ASj28nuZYd8+euruooURvg45nxFFpVBDw+IoxoI+LHtMKKW0EGHZoxevZERJHismcQKqLoieruoBufKl7ilSPwFrBoG+HvehtQQiwoZjC3h536QL6bASDWYdihDch+Edr6zw1xuIhTlRFRWsQW3wB20dvGbDYiHYbru4dzovzp76kYP3sHszeSBD2I+DuPyb/+a2f/Cdsw9diDATBOa6zHpkzQenlFcSLeFtkgVKFghoAYDHPoLo+pxSZzJlRXsVx1O/Nu7PgTZ1tGll5PnOCxQ7obB4YI/mYHEQO9d4Z0Prp20nP++1RkIebb1tKh7XR+XeW1et3h9jX1qN/IEotl8hyFYmuXqS0N5jgbDiJa86aoMeniirzdrK1naKoTQXp7JrSAfSvMfUihZlyAWCs0rx0hSha9p2Dih2rSrd7/xfeaA+UXHqxJY5e/Yj5875pBuVgGvPfEUP4vRNQd/zxOjrN+olhsUBby1qdZEIF5qsxSVzlgAastk00q49jx3jhShFUWqYHhbGC+Q83lpWH9V781ZcaoRoFGSVfBfvJdua3PnUYSXLtTv2V7C6rr/q0w5Yw0gc6WGKU3ic76xAseSlCe+jjzvuuKPtWpn6F5VqmhbWEUhlQ1hy1HuS41XqYtLibVvYuNFFAq4tKkhwcfrUdh6oT1T8QPehHzr5gnbvaO7YUEGWjkMH7S5CwCMmzjUXJFyFeZG/nznw0id2eYoXE34NV9xoaSpJ8vimskOyekm+FldWdM4ebCVfqhbQmRqKFSQTq+WvFtS3y68/VVjcOCzMFNgnCsj8DhZuahvfxqaUR4W05fB1gF9zZAj78RN3/9L3DxibfMn37O4f1q2XuhqVk+SwCqDUKG27NNNhCUH0RRp0KEOXPINSq2kisKFKP64sEt02IwKzGtJxLM1i1TWpxqPksg/e+YKFstIiWoDL3nXYQMZQY8oU0RRj18wu7ByWL/pS5eqtcXXv7//ait6u5/fpsJZsKYF5bI0QtFJ6PLbCd/Wo9+jBS7/qcu3lYEuUay0rLFOmqsg3wkWsTNDroAsn+ipTpNNbD3AFcQ5n1jVdPTdSnD69/ZE8Rp/Q6OrFyRNb1sfd3R3Sz8IOEJQk8HgWQTYHIoTl9ox9wTz0LdVUzExFItFXZKmMS6oF6WxDCFXBD8VgufOxtg7yPS0KKUdCDBnT7aL1eC7bMldz3rHYMuxRQbkuHe3+3rwQ8yB3Rmc/4drfqXUOJoQgGs3DJ4IW5q9QqQb2GDSJzt970XZdUZSoa+kAacCygFKXeH38Mdu8npTRgx5OuqFN08AUMeQlAf9266235CH6xMa37f3Vzzz1s7t79uZuQRDTk91sIBCLlQ4cwKgaiPsAiw9gEfCEJvv6a6qOJBIJbjzJ3IsO0Fnqiby/kGt4oENsWD4iqX871ITE3QlVCJY/FPmScXu9BSpPo/wYnv6wQs+bdm7rOFkb3nTqe973h3lAZgj78RhHb/5ezZj71L9v+NpI6xZ2ik4yVQo5kBFrpjZpYXLuyAS17+4iixRYsNzyHIe8sz35T+JpUhLeQn1JKkFp0n4v0VGdK26M8hqfJXRd2zYL37UozFLqQaH1ZKNdTFh91BxcmnVudW8U9VeD9MdcWSShjN7VOxJLFc+cghKw4jql9aMbt+Xnv/KO83vbZ59lRidmnZjO5wBHNje2mnrmbZfYWiwJ0iKoSUWniNoDyPNyPHbCOl7vG3d4cjT5yC9+Ux6cT4bQkp8+ub2ztw8QKrVZOx9cjDA8tNSdB0iKguwEU0VqVAkUgMmw+JqECFLjNdFYUP6D+rrcosYNFgl6wvuwiJYnWg4OkKJzlni3HvvwpSGrAU98heiYG5QiepiqbrSaueEoKb2CCZA/4JK+3JIoLrB8TG1oicwbHjUGuOODd5bVQMFlIxtbuETz+XxtbQ0S2bZpiPEqkK9EfAuyR4uYALPefkkbvOSLxaIaVKdPn8oj88kQX/OhP0hf/GvxNPhQjeSl0AC1FIziwIXtYuPgw6y4JkIq9mch10wer7bGJBBLyzCmgB4yeh69TGSDoH0sHKRNXhKOdUhMSJV6+EboBOJd/CfLC8+0T1SUJKrVCx2QNzH9P2WYZMAoifDAH9qk60HSOR4TRMbpcV843TcAX/06Hiue3udZA09DfOl1G46XWe8jx/GAGozkk+El62bNrBGsKeWiHH97ezs7uocd5ZGYIezHd1Tv/FW433nBy4rJ1trmqaDZYT0LokDXOllYWIAit9i6IqibBVYo72xNxFGelFSoJINd13A3FAgCUXU6iWgiidB1tnN45IqOX8I72JgN6tRKZcZaj1BCytt2Zg13lRwUY7mYHQVhV/UGneukRHYD5vxB4dpFRppIkqAWFs3hBStng1QK3qYKqng07rJbr/j6cztTvXbGjLaFmfimq5tWiyauwTsHnON1UaAeCiAeZbiQHkmALdwb7k2ly7LU3Xy+d15106efmtzzlh/PY/JJFSc2Nz5wxwerqhqNhm3XHR4cdjGsr60DILMWEy1P7V9IcZUk5i7QziApxfZ7V0wZEp5NCOosqaKSgYSEBOq5uVRWgtwvLqKba5W0MdCDJ1mDRdafqcJzHAbF2WhVK6vSDPI167ElZlmu4igSTzsuFbeiSRrK1UAgiMDOnYNffPdH/yt2Lu8mPSMA76k9joy1ysStIPQfB4PBdDqFa6c18goWzXx9fd05b20Hq87Gxvru7h5c3TMZvz754luO7vzu9acG35SdtUoVphrKwhSewxrovIHp4C1kSsyTCAuKFzALj47O2FhGVGcUDusdWC4tOJZxIa2DXM77wgbjmfLo/W0jr/GsIxRBGSYbETqFB4PoZRB5SQ9Ds1vIC5Vw9Fs4mUgbjhMGU0yHxt0k/x2k9w8BXukEcVntiMs5HJZSb4HE3UhPkp7zimVDUrsNnocrynssnSmkBwQA1rDyi4irBLwETByJh4SuYss6a2LbR3LaSr8XrcVCI+KRs4elPrL+oFssLHs9ywd1GcLmOBbDv/qtzb/7D3YOzlkAr8VoPNyufTf33gbthOGqksJ4VLuMsD2PpCmFRzQrhEfOfUS/WjqHbxwaQabKDU1bXAdQOgo7RuEbKI+afFbRbh2VsGHVsXg8C5MZpreCdSx6gUaGq4plEczHZcsI+Reg271PRaYrht2wvHgNi58Mj2LcHjilJqdKUc5bHrsuRDkerTGm60WNEvdCwaZtUQhGsM620XIRBkZvjMbTvYuFFMNChKZeLHZvPQn49afyUHwSxjOf8XS43z846NoWgCwEjmX4WCFFIdUnwF4AXpEv2lkYZFVZEnEgpN763mCTpZos0gmkk0VAxR8vhesdsHD+EEsBhyvvHYuYJFnMQIKbsN3DrHHMoOQ/W9UxBdbIJJp5UJ2JL5sf+XFPe/xakzguo1z2oxeF1RGAvu8JwTD96LKw/mgYxWad4La1i8ViPB53Xdc0NTxyY3MTwG4I3hgNjzk4OBgOBy94wQsuXcwNK0/G+L6DD8H9/3n6+TuXDg53Lm1EdVIPt4tBWYrQtkJxHYnhHVCVq5MBQSW6g3CVbDLo5MIyFJj1ivkSD+xg1zAhGIcGByR9wzqUdIH9iaceDDzRwqEbsQQbUHk7CBTLSqIEiQ7Llt2CRIJjpFmb/JPv39PV7wT8QWfI8gFXoS0+GAayXMraJBQrqTHkPp2RcZkXMmwPoazU0ckbucXCHSrRUI25cyE1NPbtv0lJAV9Tq9SF2B1Cere99YPnb8/jLUPYHA8Se2/7JZguJ//ePz6o22b/XqaGAzOICjdVFxbWt1g/goVFYS8xisSSThStCqhuKhDI4mEjbNwqAUfqPE12gInihvpbGk+ZKAOlHpHkiR57ZR+XVImofXuFby2d3fSsiGPErCvdI1eWKPr/o/jVk5f/k8Ogi2oseHFQex9arYdVNQQ8Pl8sCoMVZ0A5AkEHKsAWKLIFaCCEZm4AhdRdu6hlM7v15Il7fzvj1yd1bKyvw63tOkBUsBNb61AZSyFhgBQLcBQTqYDEgWBsCZZ2JEa0WL6syIbgUlMX2hsFVK8Mx7q2cZbRT8uYrIjQnIglb2em0lkmEnaQyFNd+5vyvXGs8PfBrA82ibDji97nRy855/i5C+ccMoORJolECAybilRJSwsrr0Zjt5Y2aGHftvA6lFKL+ZzjyQ4yZeFaP/e5z8349Uke33HpXT/4jM+Y3nVhflTXsW4CHsqJ0GlY8dAJR5KxAC+IqgLAUKNemqAOBOZTSyRVLgRyrFIxtF+WOQFTJJqL2MpeYFbH3rgLWy5iMqlJ3DYYyzLVTPsCKQkesOXCTkBZihgeIqU7Bmr7L45RtZM+1zHmwBLfJtKuohIulUh617EEe/E/1HcOwnqPitKAZTlPlRyGjCLsQSHpSnwHjgg7KFiD0tPhEN7hqa3vu/Q/2DyPsgxhczxsHP7nn4KZWH7uqwKiPYGCr8GhcDXuzioKIwRSiRwmk9YxK1AzCFkBjPYb+KmiF6gWEvmm2L9Nh48pEUb5HpjrNomkpomOltXws5CMUpE3manIlUFYfgymXunrSpKFvVhLr+BzdUULH123yuBzX3U4b0NVwRKNjvYR3R6wwJz0ZSOzngy9AXzAngxvD9vIYDVHckV9sL9Wivbo6GC6c/N6tfPbb8hj77qIwphTJ08eHB7OpvOAmlm4WbYoHYu1Rm0MDJ3OXqHBJHsp1iNYUuPCvVpQi1cSDO4ZBeQez/uHp0FIgu9YfKWGwCT37lnsIAEKEX7FxrW/nStZJBoxPPSwJwoDT71cV9h8jzTv9D0XznVN67GxBnX40A/C459U1g0kVwIQtixK2NYBp8J7N0UBLwhVMAn3Y6cX52fPnp3PZnnsPfnjX9zx3+H+B5/96fPdo3OztrRhKNiQywGXJYBOZXo1tc4Fb6MSodQBm67w7Bw2APQ5VmTs5bAPliZGf4BBJFeW1GdppoTUicF7Jw5xrJyKRwpL5BqX+mzpgCHNLKLMUlPyMQ4re5Da7H2xbGLuynjcIuf4w0SymQ4EZ2NqLAuJsYbV4kGUmiBrF9EYCB0jWUC06qOD9aEs0IsB/hW+GWJi9kQ6u2jK4p8Dfs2RIWyOjxb2/d7Pwfwevfx/3zs4AExWDtbGxdCji9TCeTmZbM0a65oW9qVWiCoWkFpjKsnxjJOlAiryArxYLglyCRI9zf9AqxOyibA8hTk3wD4EgAHbuDxWa1ej3fe2n/wU3t39QDicAEXE1FyxPoNe9hlQVv+Izyxf9KVd1LwYBVYsWkz8tSyxIMdE21lYYo3WDbo9RWXM0BTwHuu2FgH26VCiTllXMNnWR8Y1i9/9xTzkrq9YX1u76aab77334owCCy/UtgiIFouIEcuNJF7JrwbVZAXJuDNmAk+lGipscrLaTEQ4mkCROrRJwoC0hbBca6nSBNlkiKGLvrXWPdq+wweFsPGY0OZDjna89ZxdlM97pKc9f89FPFIFTK91cCiDS7ogPScYSTyQzhGpCB0eNB+Uw4P9fXhw8vWdHh2tr69j3da7ra2tEtnkOa4fIPvhP4X7f3XTC+e7h23gXRRwGzJeCoH8VUSn1nc0CoL0KFTHFPqcK6kErIzON65xXjhZorehRr9Zqlcy3qD5FuK/xL3B7grJNVlIOkh40FGWnLpU7CTrZGwV3HyrWIs9Zlg34X2h9ao2XBrNV7qyHrj0XxntYikse2UTicfUMxgj27BASgt01pf48EmJFnLEubOapNOZMRqPNDlyHki2BrJSCdsBY9PQzaKrYZ8sS7M2/JYLZFXQ5DGVIWyORx+zt/w4QFLz2V/Ba6v8IsAEXbRtLLY2N6NRkoWWOu0FWg25NHFDgoXLOgyZZmMtSXNU7rHRWecCtpAKjdR42hxJS9NyL4NFT2xY14RYFZEgoH9hfEBu7dkxh8HUrBJT9RQLAtQ9+7Bx4sWvtmpYh4KryrPCOgELqDLI4fKBOawzAYQ1llmy5o3wTZSadW1dzxSz1ai46eTWzrkPbhju3/Ef80i7HmMxn03GQ7h98M4a+5OKIoRQ1zWWYCF/I/bn0o62l7VMdFjcc0PBvGGpXgO72FX9SurdxipTmkgx9rfkj4fj1MA+Hz3ON4SU17rAkpTR6u02AYwcHR2tjcZIEcaG6iQvhtyBSKCd3jj13zi38F6SDD7gfkHtMtQYp3zXbW9vF0bnwXY9xncR/PqXZ17YLdqjWWNaO3BxzNXYFINyvVyXTeyOsOEicBdLmieSfJlRTcAFYaMKSjmpvNRwi4ljiv+IRuc8tHg4yHRAOGvxkALRbauCiaLR8EVsVGhkbHQsFKs1CZMz7PrCkzFPk3GJXEV/QBf5A2qr98n3EmFdXFW67TeWkEhqMdEhYmoBSc2aiUZHeetRXcMT6KgKLcuy0kojPzb6CCuGtdO2mcZwyOwUwPdQ/8jidrbIgyhD2BzXHn/wH2D6DT7/VaHp1qQa6GL/wl2dHFBrJVIIkJYvgqfD0kC9074nIFGNiVadDkVRIemkxmuqSZFGiUx8JViPNK0haLCADxdxZVzY1PYt6Hd5dsXw/j5wVsTEa0g02SjYw1rAr3/uVx42QQ7MrGUAt6MphDaSaesBU6BUktS46bbBm7JSAqYAMvwc95WS1aBgbWePdg8XQdq5/6M35vF1vcfTn/YUuL+8s1s3jTamLMtFvej1oZIcAe9NLfjVc0sZhCbp9kByP+gEH3tlKxR/xDPGJJpJOhoR5QlYLwJCs4dUg8IKpkeM7KMQyqScL/Y4/JEef/HSXtuhAWxwHnZ1LWWHR6MR+1ZEEp1HPeTesxd9+9TRdDpAHWVI/xxgGq3NfD6fjCcZv17v8S8v9Jan31ncdmibBYuOKctV64OTzBfaE/sbFlIXmMZdRGhRDDQrYX10HhAnag4EoSIzgTXYdhGCkA7VPVCgwArU1SJlrmCxfRb9abCvS6A+l5P4ACtRJhbSJ+77czbW41cujukJIPGckjnxUBCWnsffH+ESpZWgKmafIcmKJ1UBkTgNBGF5KAqPumFYLbbeK/QaD5Dyztr20HW1FH5cllub37HzTlbngZMhbI6VxuHv/lz64uTLv/H8dB6j8ygMKwUqNpZcaYkTEgtKqKwa+uNPotr1Jgi4JwMy1FiUFcvENa0MPpHxmTCwNmHnNfa4rOiFx9SPyuKyeSstNqHnUqV/QvJr3z0jQ2qgeYg49YVfc+mw5cW4CSrqyvOCR8NEBcuYs7hPK1ivlAzkZqS01mUJC/X0aCG7+WS9GpTGxjg9PFj4+fOefssdeWDdKLF9YgtuIcSLly5JiiTa79GglqUiJLV6RBc76oF0VNRJxZrQ53y9exd9wZN8D+8Z44kj3rP6+j7oFb12qkvRmebDzCNGbZqPGEezGpYGSS1uhUamo7eYtAYSzRX0PgNZPbCU70lpCgCsMzUawxUC/OoBikg5WZtsTLKF7I0T3+/vZhUA2adfOjwaebNWVgXW5BlsICXjDpWzeB3Qmw6SHqUrDTtFrCU5PQL0K7zQqEYX08m7Iq3ZVAYl/Ip1CA1DBzYReALHjUfIa3ykGy9c+hrP2sh5RPQFjqWegEi9k4LqKPGhEjkcvOGBU6N/NirsykTVxQMYlvAr0mPpyBGmA74Jsl6P3rraMd4pZrVuVaE31/7Zxf+P7eSRkiFsjsczdt7y+gKA7Jd8997R0aKeh06EqjKxdByQK6wvoiyGsA50nJMeNZ53LrujeGocJbYSriLJkye1Y7dIp+Uef0guG0xXAWDjUjYrgdewXHMeavdHVCHCQ/z2s1/y9ZcOOl6uez1sIacebDonPWDZoBw2bPegHMtoDGWKWmtlwUqjFYtd16BmN3fc1UVsNifFHb/6ujycbrCAQZC0S5NwAcA2h3lNUipI4zFgOzKy4KhCI/p2FUHyWz1pICaroXQacNUhk+AtKiwni6HVQNikOXR/96MHTgvEnUnm8mGaubrOHxwcaqWM0fPZ3JQyWezKZEkde5CeOsh4ci+DdcB7bYz3TlBvXLpcz3vu886fuzuPqBsNyLYfZCX79u3nN9brthNtvSYLYYwMEvmxKCDrJZdCQQaoSKCYa89NQKtyAIAy5VkCm6Lo2D8mhQ4ZoqSlvogBf8SJ0gHqjToArmXpHrYo43iiIzhSjetLsH31gid1RZEY6Z7zB5w2pN3EL9UO+vnDrn7Be9lG0e8EjvWW5vB8irecdSgkpuBH552dW+uUUpPh8MTmN9/x+yzrbWQIm+NjFodv/j6YyGOY83/na1A9tlvAnA8OlfI4d7DyaCY9rDPwhSBZWPTgFFaEDo9iYGrDA3qOnyS8mHRQEnfIs0faUR8lhF0S8fvNeClg5Iimi/s39s8IRb0zCUM/SBV28uKvOHfpkJXrTlWdl7IY83Is2th26MtLLbVaoHet98Gl06q2rXUDi7NRwjtu7eLgyE5le3BivTx6+0/nUXQDRxIuwJRvd7eu66S6xQiuwddcptINKanz9DefykqpGERAMW2pvfQkiswmX3lscU7IcwVpHolkocOYP0aIDfz4Ci56Bg6p4BG//cHn5mIKf2pyn0OXEKnkYrEo0FlLe3R0joH8TtCfFgmvERYF2MHhetT1bDweN02dbFLKsjx95kzGrzdw/MDld135+nurZ7ogKhuEJ6lGjt0LMFoOma+V6JRyy8YFOu6PgWy6r2h8J5MtQd51WONHTy9uPABfpkJUnviv1KKLBLWAp2xBRRJ1xP3nikkB+UKnZ6Vvqqu12GS2DuDZU1dW4g3gS+zRac9BoBqNWNrikmQkiXikk5aW8b3QNkLrQsNdy3TH+Hdd/kt2wPCWI0PYHE9IhP/7ZxKnlX3G/4r2maZiFnYxjQp5SANVyA7AwitZ1PJYKpR11oHZGLE2yRUdYgpYXhRyYGNldBN8Yap2FS/P2k5HF3HNooPYZeFqeSBLzoEOULWoqsEM5RaSSt/9IezGS796f96Ntk4fNmLWRlEOhusnpnNfN67zwkhYlwzqxKDzEDOF8UgeOFyvBk74xeEOC836uODNfjvd26ri0dt/No+cj5M4sbXFkCm7c3h46BxkTaQbJSQdTXji19FOFxzqxOLuB8mepvNIFNJCH5De/ZhKtGR7hx5ZcDNmBROka9VoqOGpmhYQZWLsiqut1qn/GgumUqv6aKblsCz1mdf8jQ//9J8cf56PnPsIZLCeGjgBEAN4xfbyEvF303V120zWJxaiQTWhoig1V11nEc1TvtqSHCzM1uFg+JznPOfoYC+PnI+T+J7pB+D+6w4mJZOnN09sn9j20R0208vBzkV0pZ56GDWIQjHR8sFoE6XEAz/fEb4MdFQRdVLXgjkTEngV0pIWnVBaoCMXTp0uSkEWx6IXOEYoK3gv/ZpqJ6HfGoiKHtPhQUocUWhSoNZ3IA9kmLEkhd63gwktsUtZ4uz0LDrnO+ss5G2kTNJIvqfZAbfwb68/eE/+3DOEzfHkiuq//8ektL77Ka/gqlRmoMuR0hVRWyUe7wCqdd4nVZ3AVUQ3V4knRTIxh3yog2+4Mhxmv1uNwSynE9oerTLJ4tVmlCtfoaZtwI4TaWALN7APv+zr/vx+z7NfeyerhhdWCq+RnbWw7HDRKvTKNbDQuYDKnthqYF3LRWHEcFhqLfx87tvp9saw4N3OzsHGQPrf//d5tHy8xfYJ2JtPMCQYtJcu73SBLOO858Hi+QNH0wLM88g+CIZ/iNb3XAJGlpiULqJpkaDOLviR1TBtkmvRIwaMbU1NivO6Vl5/+Gf+8vi/rm1MPnx3SC0yCWgHsmeISfk5BCllvah7lwfkG5JRAnpRI/yA9wvftG0Hfz179mzGrx+H8Yb1I7j/vu1nvPdo1/rOC99UwRWy07xBBZuIIqkSx77rDzSQlZWO6QPve3UpA8OKqObSoLK4t7Zd1FbWXFo+iLI02LrhpYsytWgQg4AkmmXsD+qwqHJcCTYxfJa9jG3wrgvoqyUVZJrpKATLu4J7LlpPbn3YZ8asYFZxL0nlRvC24N/b3I3yWFkhK0PYHE/m2Pqz/9TXn77s246OFvPpUecYSphLBUuLUslrQEHSCrcKO7ggq0Y5FY91KDc2ZSOjcN1KXswr/un73/4ja9SGCmuJT06DVzmEvRggpOuQ6ceyKqUqWHv/JujxF3zNfhNEOXEMlj/YZ8uoyzYyG6I2Gl67bVpYx2B1DNhq6tDSQCqjuApNGevIW9bAY9sTY+V+5yfzCPl4jsIUZ2++Gb4w1almcbiY7bXzA9fNOOplUk8JWtQxH2H8t6gUhG5uqElF8nQAYSELhA09JEuFaw/UOiB3A/YIdh5YIUbZYxIUOf4Pw/XyjjvukEljpOf7kmVo4ryS5pFSsulaAMFGY+U4kiIBPMQ5p5Quy8JaZ4x5ylOfGlY08XNcj/HdF//06l8a9o+e+0K/zhfhYC5iDSgWD+swHGV2Do8vkldcTO2/gbooDAlvWXiYEp1RXcksky1kUU5Kr2CGdYxKp1RwJe4BT83HAjNDhmy4paFW6B22llZbUQTYrYQJClW5HD24ZaELwUYGsPuoaSw8k1GiKNSwKAaD4Xj0de/7PXyujFwzhM1xfcXOm34I7jXd1l76T1sLU711LaSmnBJmwyV2aAq8F7g9xs5EN+BWR0sWB6sJzu+vV40YFjU1WdITZAxgAWvbrijXsDqk1H/6d5/5iq99R3rw6b/zv1ysEb/KYtRxgLBFQAsD4+EVFyVswMGjRpCCv8NbSaSqiG3VIgQebcXryOpmf1ZUPOPXHFeiqy/CtjsaDz7l2c/avXRudnCxnk9tG62LRpKIVYCcDiV4kqRW79zFo0rMVO5XNDskIVg8jX0YjS4X4rypAUQXxpS8esa3vuRdr3s7fH9y2/r73/nuZtZoWdAJR29dEBKBEF0yAyBwKRXib3IvA+TaNA2LZLlM9VpTGOf82VtvjSs6e8lxY8TP/jc8DXv+lz13Jufz4NuISjWQDhVSdBHF1xw1QqYTNbLRQaVlB8suOiXGTnBrZFvwmkkjFLfKt2xB5jmkF0AMWoapY4g9eYbkBnqHkZgSvN6VHB+JJrdCRSE9ujLENnpAwy1DhRGP8Fi4asKN/p6dv0RVLLjt588wQ9gcN0QcvvXH0hcJS26+9DXW1k23aFywcPPRRbSeHQ2LaLow3/dOrupXUxf1soMr9h2pjNYv33enIAUA1sMWfUE7wNPwkn7iR1/+Dd/0lts+81MuHi34+Kwpxlbo1sMaKiwae2MhyQxKEbi3brncodAhCmqhCENwzawU1oTGt0e8m7k//OU8DHI8MG4//xEYnl/wN595+dI9B3uXZ1PbdMxCTuVYa7F8D6MSjdIDT82JypBdx4p+O/ILE8H2YYuwMfhFuyiDqsphwct6sXj2//ai8+/64O3vfG/bNsju7RJq7ctXfRdlTGRCroUoTCHJ7gH1OtAfng+HQ2ttZ633fnNzU8SQB0OOB8a73vTu0Vc8pfHOegSe5HohpYsNbB1CSOJTJ0kBTm1bCquqRBfnAlDmNARPRq4NGn0BYHVaMq01p3UaWayyN63tVWuwnsKTuB2ZbEWyHiELvSjqEG1wgXqBvWBBKVZqUZXfdu+fsnx+kCFsjo+T2Htr349PxpWshLz4U7/Idp1tY+2n9nDHDsyqfhd1xlCqvmxR4cuNth+jWgtuFo1v2tp2yg02XQwXL+9++t9+yp0HrRhWuhharhcdNgM4zS0sbK6zLE4GhUPNJFdpYWDV8zb6RihvDFqRta3TvglHF4VrzJ9kC64cDxf/5S+mb/rBL1nMjuaL+jff8vYLFw4ayxYta1rWdXhzPqI9nmB6yCxaAKwIwkpp04bPHlkDxKGWgoJ5tL+//+E/e//F99zVHcyH0mipF01N5pp4wiF6RsEVTzIU8jSF6boOlRmIM6u0Go8ndb1o2xYePRkN8hjI8VARpEBzZtTu4MJ5hjQUbwLCiw6bLYIKvaa3IiJqIXVZGGlcx91B18wWYe70hA+G6EEjtEJTLE711yumBlRewQE7nU3rtonkHcIk/tYEdSMZ7ohyRPQ38107/wN/xjPWMnaYP6IMYXN8fId852+kuuucsRFbpeMlqcpL7PxmtO1f3axt39FFFvGQz8PiZoPQujRiyIWfLxpTbPtiuBDGBolK9NJIWAS5agIe8TaQ0HsPS5zW8A/c1o23dQzBmBKlhCpjL55fi+0i49ccjxR//Asvg7zIb+quZc967Rc3VkwXfv+w3d2f7+/PDw5ms+msnjcLZ99z110zD4iWr0SyQyvVIHc7sIft6pJSba4PmsMmemy+CshyAOgbkUjThLpbJHWuVMpNnS89esXaVXTOCoU/FXqAy6218/msadDEa3trMw+AHA8TgCOlUlxpa71rOu+9lFxLSSV+Ap+9OXMafGLvaGoPnOlGa8PBGy/dBd/6hs1nzIO2uFo7kjEggkBIurBLkdfkBbs24mqNS/FdD9QNiKxnCOTIEDZHjo9NYCfZwylo4jmmc1geGg4r3xVeAIo1g5GuqsFhp7hQ5K2Nki5OSEfOgVLjoSj8nIxBJyulyJVkXtCZq+tQzyXYSsbFH70pfwQ5Hj5+9yc/y80/YjQrlNXcC1l6JicTceKEus2udd0Ed27ng/N1MO//yLPnsaxr9ou/9t4VpI5KYQtijA/vG4tUGzzAVQ5fiYMMbXPrRDs5XMwPQ+iCwzlxTLGO8Gvvp0v8gBCctcmirNfHhfdS14Ph8MTGeh4AOR4hfJCopMUKj8rbIqCjXSdih46v2IO14NEIpgIe7qNjrZFyc/BHv3D7lSf4ib3shJgjQ9gc1yWE5awXRXmIFB8rS1giqsph7WPdWVgWR6Px2vrGPZeYg0UT1kZGfqGBNdYCJjZKw9iu69ZhQ6tnrdVKlorJQmOXge0WfiGaw2dvb2R99hyPGHZ+QYojYV0UMPhaodCHSIiyUmVVGiEK9I0nEaqOj07ctm3N6b//1T+3mgVaSrQVgUHMH45JAGnefL6AVBC1XT0bmOL0yZPT4aU5O8RarNaR+sNJbZ4n34UrlNjEPu+sLYsS28mdQ5mCiPYHT3/a0w73s4RWjkeIYB2zXFhIoYLiWGOY6zAX3gkWJK9lLIiv2nH0zIAvlRHnfvb2fN1yZAib47qPyLHBynNq6o6k/IPMfI29pUu1FCY7FKgVU/ibtYWT60JuDicjv2NtdJZbfBImfCpXBS0HqGItbIuN1pG3zrHQVuWg0qqtw3xx6EM3CPO7fz1bGOR45DB6Idxe7JzzTde2o7V1LkxAreF5tOhC66MAyOeD6Nio0OuFFL/+xi/54n/45hX8biHQS5N88sjAKDFrknd84tzgCUYACLtYlMVARtYIMTFcjkorYxe85qJQhfcOHm45C/3BLE/2CKhPQN58HnM/PLCgRwZjzNlbbsn4NccjxsnXvPDifAdVX6KNSlgRTSUVDFznVeAtjwXjJEeARiARXUNwoZb5wuXIEDbHjZDBc9l6OnwSFp0BEcRKFg3KBiCDP/rYCMOHmu/u3xnleDLePmJu/9Jly5wZVPCgNsCKqGOIsFtrbgLTHL2EHOrcRiQQaO6b2Z6LqoRH2Wk73dmcVPz3M37N8cjxX9/4gjj7UKmnOiqjRdBV3Sy6Zh5gixYujWDsJfFauiqIfT1aOLkQcWMlvz21X6GaRgiAAxxpwoVkFk+wQEQi4QhejCpmHWBPoXTbsUvTnf1uxgulmsB8qFTRdd6T1kCU+CzoXM+ikkLiAQbTVWk7COvRe8/ccsvNIUto5fgoolFCjMsgo9ByMKnOXTgneaFVoT0nm1gUUxbUcSXIJdzA953I1y1HhrA5bggISw0kXpCHNllgJqcDHlQMZA2PatlWSq+1jbJz6AgTB5UaDpk0ElZOL2Pn2ggIQw4AxFrkYXnLWSnQ57BrGh7bM2e2m/munR0OpHvGbaf23/y6fOVzfDRh/VyGBYtzyQrJBGzDlZYFQFbJvHQEIh1gTGm1kLwTfMoOycxdr+S3777hnfxrng2TwhjToVhyDFd7WyLhV5SLDzxqQSpC0bfCD2FWlEoNSmdqjn5JaFLAPeq/osMYzC080HXBo+UyDwBkeVkOBRqEwixTt956q+A8f/Q5PioIG4OTMB1QJhmNAwrlFUoFoOwLYlbksMBoVRxPyrAnAYepiPnC5cgQNscNE5SnJ43qtEMj6R9PPTmaWMOuKwUvVOnQYZspwYelmgylFpahCGAUPAkGRToXBeiLcBif1pN+Nnfd4qBgXT0/YEXcf+u/yxc8x0cZznbce7IHir1zHZ6FwoYshVCRA35VJBiE7rMSC094PC/l6lTn0JsIPQs6lxBzohPcR2ZLoXoyTiLmyY6TxaIoh4Nh0DPGuxDwe1woQUcbZM8VSW45ovgyOnqhMAjAXLg/c+ZMxq85HkWO5ywvheDBQf7jgzbGCXKDxSFJ6zh6GMekfaFRCguHqs8XLscqItfzczzBQQKAaHBwHw1AEq5Gc02UwI4B0vsIsEBj6wls5NGXRg0rozhk/l2MaCurlISVEv1jWVRKaLQzQvxaymCE8+2Rrw8Lbm/eHOdrnuNRjE8UXo+pnb93BMDB2TsF9cbtS7mAnrLKldbFyl4Bjn9vlL5SbxAP5nMgGU8CdYRhoypMOaiUlmQi68kehJ6MKrLeeU6is1phABpvmgb+6dSpU4CV84ee46OPznWAVuEWkKjitSm4QKYrIVg6IiB/OU8usQhlId/jmQqbI0PYHDcIhFWxx68RyX7MUYrukfIXYzKJZ0HCPiyRI+tDZ5ltCxnGJdfcMoCwIUohAMWiRxLKCjohsWuAx0bxrpC2FG3FWj+9fOv25Nyv/Zt8zXM8mgGKJVdOm25CjsnTCgZroPs0cKkuGohjCo8zn/eV71jV7+foMOclumpyOn9dGoAkyc2k+o4vKBh0ukMM61GFQJqygIkBSZ4jtg4pw0eWNOqcBQguuTBSGa1g9sxms/F4XJVl/sBzPKqwwUWiU7sAmZGFhEj0qsPHTglwDUedC8ioROBaZAibI0PYHDfIGFTUan1la47kceAByFJ9NmXzLHgFOy6POtgu2tYwPynlUAWjEDy0aISJq6cyEqCFtYtgF0rBmrrQrB4V0c931wt24Td+NF/vHI9ueHImlSDzVZ6SK9TPIjsOKVT6WkgqPEnJ0b8Y0OYqCVoGhj2KFgXy52THUOzVcCRKgC9KCCx6wddS6EJx9EKKFIlvA68WXiwhXULnEauyxJTlfGM9S8DmeHSx+OJbPTrFYmUVUifrHdJr2NLDgB8bn+TOFagkoWVmMObIEDbHDREvec27mSCif/TL5S4NzST6E5XUShZU4YKVj4vguWsL4daHan2khqUGYLuo5/NmboyqqkLI2NbTppkWmqlYt7Pd+vDSQPn2//2lfLVzPHoIGxWqwKr+JD4hP0YnojH034ikCUcVWB847NErfAGDooJszjUdysrFB67YhBUiOc33LwbNuaSSpiq5kUxxhu4INjBsETdGlqUpjEFerPNd17VtA0jjRS96Uf6sczza4FjBJ+UYFETEPIqFflL4NE84NtyoK4wCDwM1mBXSbHJkCJsjxxMbnmsfucd+rKW1PHckwE6+2xLtu1BiwEWJ3dQR/qK526jY1kgVChZN1ChQIsboYrAhOsC5gjsRaiM966Y61Pa//kK+zjkebbztpz8JWQIYIkFV6kqBYeaYd9g2iHVMgTfYnVmwOARh814lnXT3DX9muLSt5dTumFAs1WKv9D6iBbP3vWisjagyoApdjQfFoFCQ4xm0sPcJUSBjNnVyRaSbM7Y2mXzSC16wt7ubP+4cjzo0BxQbRGrf4p0nm7oYsSyLCR2C18Blf24RkgZ4GGQIm2NFkev5OZ74iCjmSmdMfZ+KIxdMLK/iySeCBpRejwa/IYITvlGsHRZ+bQBrYhN8V1UDrkxjF7zrgtBVBZiWdd2Md4cba8b+9k/li5zjMURwrQyWicDIsIqKSjINWcyz8IxepQbEdLyPbFUhI9OrfRmFMHXnpEYyQyR8cPw1QqKHApzENSQPBMS1ojTFsDKDUlUmtDB/fHDwLhy+ZMGxPy0gx1drdfbs2YPDg/xZ53gMIbSImhQt8C8oH9MhgsVSBI5JWs5RWwsP2jABIyZOvOvf/kG+dDlWMwLzJcjxxAMFWfpYhKhckCEtexFLWrRhh0jN04AOvOPUgxIlrJBuId1ifQg4t2O+KXSsCsls3SwOpKsnA7UxNK6ZKmYzfs3xmIOHlkfPkxJBgq14MgAjMPLl4omglhStEFoi96V42av/dLUvwwhFXFixLMT25QfktpIRCCMuQaqtYjEWiblclLocD/WojFpI5IhH622HUrAOW8e9r8ryzJnTi67OH3SOxzhBFKPJgHreApUPufCBBqdAXgukSkiNlYnAjbVY+I7Lly1HhrA5bqR1UI+jqADFduiCqVDGsuus67jSDv2CnJR6UI3p6DYOjRkWAF8Pp3vnt9f0ifXC8K5dHES/KAxs6jaGxnA3rqSCL373Z/LlzfHY4v9544sEs0oy6rEWBF4FRzOrJE+F1AGPNx9Im4BufFWmBsej4DI6T4RDlpSJFEloMdJKSHII8KVRCkEsAAatals77jdObQ021hzzvNAOksKAknOoQCdRw+DkqZNBZwnYHI8xui8/67gVyO0KjgejtSkKloRgqV2w875QGmdNxKFa6gLzLBfypcuRIWyOGyde9pV/3vnCMxO4QR8DctJmVG7ikOIzj0KXjHJ7PJuygjnFbalcpV0p7UDYStjQHK5X4rbTG+OCX/jwBz74nr+8eXstX9scj31xjI0MVuJJfUgLZey13gJJtjMRqFWK6chkunk81189hOWBn5isS5gNSy2tB6lkATZACM2FFAFeureAKriRvJAeZkt0mApqZSDj47xpm9F45HkGEzkeewQVIa/yghoZWFzeWJKDTV8nIdgQk9I3Zlta6nzpcmQIm+OGCutLJoaMV+ihzTRLm2tEvyMGyIAqXGQY78l7y0luC+WGxp9aNyfXZMnm9vDe5uDe9vCiPboku9lTz2wc/OoP5wub47EDx9hw5jgpAl3FeqRCwJdcWM6SRJUIeHKKD+Ni9Tv05Tf+RVt3kknJBKojo88tD8dIsYFeBAse+Q0IYdnMtZ1gcliYQQlQY1EvguQmnVN4OxwNT53azh9xjmuJKOEWvAiWB4/cr+McbTwrSDZvNFBp/bZBBTY0Vb50OTKEzXFDhQsVl2Mhq8hMZArVA5H8H7iQkZwJEcziAS6abvFgZWyN6AbSrg/ipLDaTwHFiu7QT3cq1n3CracO3/z6fFVzXNPi6GuBEDZA4iRQqJh0tFItliUvuX5MBurfAhSLJhvqcem2rg9nVIWVV0wNElBI/0tuSC7g+W2UOGVq1wG2UIPCjCtZaLSpN8JG19kO8OtNp0/nzzfHtYaMpH2YlDH8sSoslV1xzC354mg1w6Lz8MXuG/8sX7kcGcLmuLEgbBxINeZyFNDpQESuIWn3EZUwsYE6+R+laheqAzkWrQidFnas/bpuKjYdy2YsFhPZPuXk6OKbMn7NcU3xhz/31BhqnuziELhK3lsfO+rrSiKs1GyN94yIBLCT81e89q8ej9cDo17hcp24BL3HQd/33cvIk1sYQljA3aHxHeAFVelyXJnxgA0l17K1nS7N9uaJ/PnmuMY48Q0vYIpHCWs0ZE64InuSeHNLA2QR+3bDRCTH2oMPgmfudY4MYXPcWPH13/jJNlRMTZgcRG4QDXBJSpaOurypIVyQyzuuhD7GNvqWhVaEemskzqzrDd3I+nLpDm/ZLO/6lZ/MlzTHNYbvZiw2gluemK/ou5E4A4RluRAMOS6cDlPhlkQLgnhcVtTRS247sb4lhFJIJOilENP5rGdXRb0iVYwdSmfRTYRolB4Pxhtrw811B4818jnPfXb+cHNce8ybBVfk/M2jXRJhw5JKkNI9hdNBJOUMPCoIXIms45kjQ9gcN1B8wuc/88Pnd+cNbMkF42VgGhtiBEJXF9zSej7g6W3qESBiAarI+477en0gTq/pkWgOLtzJmr33vulN+ZLmuPaIbs5iK4gImywASJSYRxFQHYjsBAi8YomW9mtIusTjsaJe2pzfc+48YFGJpxPkPk9GR8dfbEK0MGs8INcAcyNQLZYh/xWlYYv59JB1/nnPf9708lH+cHNce3S+i8SjIUeN6FA5mQwOlgbIgRxBCM7it0hOmZXa5EuXI0PYHDdIfPIXv/Ro4RvLpzPXWebR6EjCTizQ2525gKQBH5zz3qNiETXV4NmuRxekCDt165tD3u6PtX/qmfXLf/y+fElzrCRCaGFf5kgYWLYSwnYt6J5IsT14pDPTGGX/91Wfk+7r6f7uvu26erFITPD4gN+QDmcBuVLRi3XB+eiZ0vTqgyx0NRzASn/mmbe5nSZ/sjlWk+PBpECKV4KwIRFaeDw+LPGsAhWI0bcOAS7MnP03vDNfuhwZwua4QeKu85eYqoIop/Ou7Zjz3EfUy0bqFPq+R3LVjg5gLKlv4sFp3wwOKAIPSzWzYx1u2qzufsfFfD1zrG6L7viyBJuYr4k/QGRUBJOC6kqRUGzozV7l333tpRW+BGfC7qVdGPSSi2AdssGJd9uv3fcpxCLojpI8kry3IXCFTV2Q6gkt1zbXzz7rmWt1mT/VHCuJm77qOQGt6DB9ImYArMX3GY2Y6iVP5oA6GcETwM1E2BwZwua4YYJ/2kt37XptnnIQN84v2G4sjljRsNKzKrJK+ErBng2bcewYazzzNoouGh9LFisRpY5dFQ63xP7Tx7NPO5uFWnKsLN7yU2ckmysWdSwUq3gYRl8GFIf1eAjAsZvQR5twrQveA4oVRRSjFb6GEP3+zq5E82Uea+fnnQlCO+TZoNF8TA3gLsTO8TYowLkyxMRkQGVag5oerouNlW50ejI8lyVgc6wsDkLtNfpyUSGWk/MWfuEFcW5QiyB4XL5Z1zYwLosoTcdNm69cjhVH5lbneILw62e9sgtSD8dTbj88OxoPZs/3SnMjeFFEW3jADc4I6aJ1wmuBaiw2iBCVjCXHewAQDTJigxxU4sX//P35kuZYVUh2UMhGs4HkJZaZQhNC62KrYovtVNE4PBoVQsMmrdq2DdprORFqyNjhSl5AwdWHzp3bPLUVu3jUNtNL+3sXLp952i3zwIpEco2B4Rfe+oYrPjIlgARvAaeKUgJ8FYLqwrVdxMi3N8b5M82xqqhe+YxDNmcVagzDH8CxVHJFHQIekeYFg1MJrhRSx5vp4WhteyBMd1S3P59X6RwrjlyFzfFELIIv/sqOa7N+So1OtnJtwQbTUOx1vJFlUEPHCutkCFzgcS1T6DfkBKq6S64M/o1ja4sEKMHaki0qf/COn31Rvqo5VhK/8bNPk7Hh0WGl06O5QcS2reUZaCT5IDwWdcjzix7GI+PKRxX5ao4CTm9s333Xh+rF4t4LF2Dwn1zbKlW5c8/lbtGaKIw0iiuBLkdCKwlzQkq0qg/8OE02EHEcueWQAdYhl79yrCxmvmGVUqVZjjex7N/qRyAKKbPEAQtFUaLRYuuVzVcuR4awOa7/GL/4lfMmiBIy88JhAi8DVwvLdg5qz0sGEDbqFsBDVI7ENwmxKkzrBZd04+QWTzf4C6yW1rlFvrA5VhLRdqiBEUmLOJIUBusYWmgyPMBHJavAeWBc+ujgJrDcJJBmwFdganBisnX33XePx+PTp04pqer54vDgcD6d2bqd7h7wEBVBZlJHSJRxVJvz2Al+hSqwbDUj+A2vq/EZPuRYWUDiprWR+vgRbnzgw7roO2tNUcK0aRY1/FS+dDkyhM1xfcfwb3/pdOFNOS4Hk876WQ1gVnJVzDt2cXfqWRnVwHJtyeXIks275ELRDXACChvhfu15Lz3oybqrtTZD2BwrgrC+wy7raEiJwKLwBfZ1wb2HLwjCwlikUwBSd5Ok1uq5/Fv/6C+v/be/573v3tndadrWe18opAR0ddsuatvZvZ1d7oIkEzD0/2AAUREW4Iuz3rEk2RGpGBbJDQQ7aADC+hhOvOq5+ZPNsZJQRolj+DW5bNwf5qLRBmutA7DrbWjqRmWwkSND2BzXdZz6wtfsTAM36+VkW5nxvAt1YwHCMj2YW33PXjvzZcNHHRt6WXJTddZhwYvoBIJFEbzA1q5Aulq2F5znHSyVzs9/5w2fmq9wjmuMt/7835DBybQrI5sUIGyHgw2rsIASRdIf4EJzKaPkxHbRURSRraDff3Y46yyAVTudzuAGKBZAMrwS6Vho7OHl/dgGGPuAlxOXoOlsauGCHC6pGgV8deiWRCgW/esRworYhC5/uDmuPcove3o5HEjBMWm6H5i4qpXBFFILBHMokdjBKLV+8Su356uXI0PYHNdr3PZF37xzGGSxpYcnmAacqgNTUWoulBXlwheXj/x+LWe26HgV1VjoYedgB47cB+bxnkePVknYyGUjFsqSwBbs2W0MtXOzfJFzXGt0c8MCybArLGtyG3nLuOXCcvKHI3aBCKR5ySWkVzziab4RanCNv/nS5Z3OO12VpiylUjDSF7NFs2gALBdCh0W72Dt0s4a3gLBFSQVaD8gVlY0AK/gWS7CpCptugF8Z4lfJnOLw9eYrPzF/vDmuMSBjqkYDWIVRx/sBcVXxrRfVwsQqdt7w3Die43GJPLByfCziKa/4zrvu2eXlRlUOOlbM58jOU4OJkYAGOuu0Z8OZnZ7fbTYUH5ghKyaOByZljF0gCSGOddhIxdcIgcVXFJxHUReBbMU2+swlyHHN4eYlZ1oIETUR/Cz2qpCQVhILgpEXiIYdBPIJYlDOi6iKz3/NNbEI7vzQXc45UxRlUerCCG04jO0Wfk8EpAxQlTW2m3fT3cPxSJWV8Yq3fia40krDK/GsBbBg0e62xxJJcB6mh48IZK1kvssTJMc1xdZXPH8mahhU1jobregtt+6j15ZqsXg4wNFOFrsfA1sbTnKBIcfjEbkKm+Nxj0/4sh+6d7dt2YTpzWDW21DWVrSw8XMtpIlcdcx4OfZy/c57phePYifGwYznlqti5IMMaJCUWsJdpD5rLhxH3SBM9JUIUnkpOh7q3/3pT8tXO8djjt/5iRcouyhkUNgxqBGoRo8yQSII0bdwwS0wb0kLNgoFY7H2kGBdkxbBdLYAaKyU9t4LKeFmvZvOZm3bOet85wDSDsaj2Njdey7aaTPghebKNb6SBQDc8P+z9+bxtl1Vmejs51q7O+3t0gcoktBHFEFURKAsOhEsFCxFQhBCoNSyflWv+e+9X71/tHyvQAiBJDQlxfNVo1RJ34rYCypQNNKEhOTm3nNPv/de3WzfGHPtm0QJIbkQcu7N/LLuzj7n7HPW3mvNteY3xhzj+4BKc346BQuXB7yfgEXiyTnJ8eh56IjzKgvLZ3x38V20MLqqroaoiUm+kIA9zVyTohbrn3s0pImCSQihNBXzt38hH72MTGEzzj488mf/3W0n5x0ZyfKQoSOYdj0fRTkKTLU2NMY5KgIrLR8HvXrrqWa7Yh0bOT6qDFDYYYwEKCzcHLHAL3WnLLQIsLWLMeC2nAjuBXOMNNHN8gHPOHN0Ux5aTSOwVxoFRQ94hxuzaeBxVAAg6CDgYIIOQBCZxzpU8lO/8qUz3qexfjqdFmXJk7KBddY6Z1GPKEgpS10QT0zd+saG1u2d2HazVkaI2phrrUwSsPA+OOeuNwgjQcJbTBpHHju6sBzW0QgRHivkoVdcmU9yxpnhUb/+LOCkjmBJC5NCl1j8fXdLWXe3clgYv956SSUQWU1kPnoZmcJmnJW49eRu5XiQo1hMHC8ckZ5KyjSlEkJ24AGweSKpGPNibWvfbc1C5ZShg9rzyAYBu2Q4iXATFDGy/qaJ0f6CyOJkzWgQQGSZj67KBzzjzPDJ657AQi1jJ4hbmFwtVNsW66TJSzZVXlFFuAhUWs9bw2w88xRs25qTJ0/CPmRq8WaCd852xnhURQZOKwWXQBJs67p5F2pT783tvIutD62Fi0dzBfzVOh8iFcmUiwFpRdEE/OM89raf0dEQBBFDvddM84nOODOc2ts0xEvNUZE4+XKhekfsN6yCFTB+FwIFkfqIBopchdYPi2E+ehmZwmacfSif+i89H7JiybNB6wVVoyjhCa1MMEQMypHSpXfBOMb4mOqVJpQnds3mvquDImLUmEi5YqxEj4O+xAqFjbxP3u8x5WSDdySgDWghYfaev/93Ls+HPeNMEGaStYo54jrqPHpkEpJW6XHk9eMNn1HJOZeqZEJ0js5bz+QZ+souLa2cOHHCdB0QVlx4jQHrASjtv4QXWOOatoueKNgZocHE2PlmWnW7c2AGikoRmQxUuOitF4s13IAdNCHw2CdlI/y+pZ4qLgZq31TLv/iYfKozzozCzmytxoPJ0thF17ZtMuKKKWSKfXIhYMMjqncIwguhC6ZN1e29+TP56GVkCptxluHQs36dqGFQJbDVljBHhSUikD7DxWhkATcsavWBNYa0lh8+7xHHN+sv33Ky8uKiRzx6WnsfYe7WMeqArYciVSKSmLK3WBebygpQ3p0AQfacGBZyIjbjfuOT11/JwrwQQcLQ6uoYFt3Wd1WPJpFVEkUkMNzgkbggfJRMTn72V796Zjv9zGc+A9O/lLLruqapy8GA0oXLEfZj9QsNi/0yydSR1UOhMrsb2928megB6dxse18xNRkuCcx/4bVATi/mMiQW/duPuPjru8q3g5UxH6l8ujPuL9aveoIYSFGIedf0WnKeeEZ75YFFdRfvs7Bp9HLs+QrV3ozbmI9eRqawGWcZln7ilXtdIOU4CBWlikIEBsF5as1Kd700PffTLUMbeuzr0nec2m+9JHpSe358EyW4pB5xlCuShMILmEfGe7oAK+AzFgSa0BLGgcUSw0PzieuzeFDG/YNpt2ispXCSRu9aEm3qhlooX8IYI1hCoBIz5JQrCL2cY44UQi2f2R63tnexeQsmfiEKrTkXTdP4EOJpwoyMdCEbj8Uy0cdmVgORrXdnp247aefdhYcvUJE3+3Nbd2OuMTpMASE2OsY7b+xYgsM406W2JMihqkN78Wt/JJ/xjPuFuWvUsJAD3drW016+DVsTeAq6sPya0J7OwlOOpTaMOdrtV0t6lI9eRqawGWcTDj/7NVWQrJw4oRvCnJBRSrTVSm4ESfEHp+iQ3I36hJFz1Fo6WTvPxuKOrfmJrblnGrZUOwuzs4zwhAgshO2rEqmPfY9XJDxgmYGIgRPLY0Xc/p/97lPzWci4j/jgGy+PYc5Yw6llxJCQXDPSJM2iSx4HlERNIo8RWWyylqXWw0/Uz/zq18+EEFTNfDabLC0prRnDolfOuTEmAoWNMZ7O+Z5GUon3pJ7WignfuOmp3fnW/tpwMilHpPOuagm2PDJ2J+ddPAl9EQQwC6m4pR6CvCbYkzsb+aRn3HcMr3qUF4GXElUI4JKI2CAYUgoWS7ZpCrHScE1rYjGFX0y4yExo35W1CDIyhc04e3Doeb+23zI2WGbl2ITUI40KmsEz9DeicAOknqGAZeTIYftKAA6vq1uztLIeuL7j1M43bt+YG2C20kfmcfVWBcLhhTGxWFxjxUneoyZswG4urEUgXhLPI0znU9du5xORcR8Rw0wIw5lJIsSO8ZQAxZZBj2v6mH/F0UoSf4WIKaYfeNQrOJMM02xebW6eAl6qpFRKkRidcyEEIUTqGIsL2nqn+gYqIif5IriaHDZ6N7N6e2NrvjsdymKsSuGpa016KeZfT7PYvq6g70XzJnofnI0uiGhFOHTV4/J5z7gvuPR/+wnDPNMC7q2eeqmlRVHvKBi7O4ug/9BmlmKQFwe8yAcwI1PYjLMnXv9n//r4TmfEKKpx42kDE6hWQDpx7uwtOnHzidYmaQG88VEJ90Wpm9bszVrCdWvpbRtbN99ynIiCyjJSFaKMsFEJQX9vAZ8yTbTv6CIePTQ5dl17SS0LdTB7n3pn9pvN+M74w9+5XNKuUFFyG2DkhFZKyVhIjrKEhqQHBOQ16j6zGWCDoYzjV3Nxvyns8TtO7OxsA1ullFV1DYTVeY+dMdaWZRljXFDYlNNKDVm0X3aglA/KgTch2gCEdXdj69av3Aqse2m4NNZlND5VESTunVhsqisgPYuNIXS2wz61aNhAFKvjoLNGbMZ9womdDVEIqmGsWRMsL1XnDLbQ8kX7IF0MswVCH24Zx2yMv/f3+QBmZAqbcdZga+bFeJ0Wk8qEraohQo4nS1HCfO8ZDZ442Dj2ASQPzLRuCrNzofSoHAQfv/iFLwXCl1YPmcD+/uu3qHKsihGQ2hCFh0kZGa9IW2p3QeXOtOaaZF1QOAjzsZaTNri5aXfz6cj4jvB2xrlVML6Yi0APY5BJFZYS1zdSYRYWTa8ElpVGTiP3yfmKcflT137+fu3r1OZWXVecc41Qzrnd3d2u67CW4B8WEpBUaJiywTGJx+MXQshhUcLAr2b1fG9m2s7UbWgN+s3qoqcRp1ksvXtWjDI2KBTX0tLo4Acpzjvy6ifks5/xHVG1DQwYNHgLzsHwgft4DH0jV0iKWiFpt4Wk5pbu53B5YGSmMrvIyBQ24yxC+yO/WkwOFeNDgZfYtsoEzLoOyCpLZYSLLCySTbgNchLZaTUW07Z1VZdFeeHFl85mzWxef/p/fOW//pdtpQfzum07i1UE8CfSpJwm9DuXrDiawWM5Acz0lDMqsMPA0FC5bvqBt2b9oIzvAEqAOBrvG5T/Z+iUQfpOKlwrWIwx9ArAQoKFmEbquWJc3L9FUviF2XQ6HI5iqhwQXJRlmZpf+KAsldZd24aUwuq1u8jp/Gvo300I8/m8KAZa6kOraxfsrcRPbmsum1nlOyuZSJyVYc0OdnT1fV2LRKxgTA0GXAqphHF2d74/66pp1+Szn3HvCC+9VA5U64wNlkkulGy6hgq40TIgsj76sNAhjikdm+IvLB2LnIm1yUo+gBmZwmacJSPpqS/vgqblsqOFQWfBQg1HXQy7sz3nOo7zKvBXS6PlSGTTpJySTjDFwuTtTLe2vOKtg29tfPST/d987ss/1LrYGrhXoj5narlejNh4p95RXGR0GbZzRYHk2CU1zNrZbNaVcW94/3VP5Mx5XznX+GhgZuZcRNQedqRnsac1rchpMTgsJIiYEr1fFBao523fvI0yTLWidGaMbYfFA+PJBIgs0FNrrdYFXeRcE4VNZnQpnZq+xHEerTFKqtV23L/otrf+bSEKRbmt2tMKYAtdrZ68njasD87CVeSVVkDFG9s5IB6SLF2dtTsyvi0uedXTOtcNJqPOdnA/lVqJQlddC7FQysXeqQgb++exL+3CJt1YcnnHGz6Vj2FGprAZZwHET/zC8TbapeVKyHkIDdzLGMf7nAUG2lDbcQjig6XeYgqW43/wS9iCFTgjQtM4pK3yM7t36uL11bv/5ef82lcawWvpOixBFCSo6AvihiwOGOeYs2JAbrHzJvWQpy5yRiVs1CpffeRtP5DPTsY94sPXP1GSzZJ1PNq0NqBYWjcI6AWvHIpgaBjHaVruPGkDdVgNI4qOTaw88rRrvnwfdzSeLN9y663GOSEFAQKbMr3GWuMsY/D3CfBXYw1cLgwJNAkhACsQ2OuN9Fmm7KmnUZXlvOseecU/4J1HB4dVXXAjqYerSqZl3SAJR+MurD8PAv9YtG3XeQuxHlWclCLAptnc5kRsxrfF1vwUH0oiGJEM+xmIc9RxCeMyOOIwL0ujVBLrCmCYEa6Y4oFHFADnR8r1fAAzMoXNOAtAn3vNCVqywxfE5dVpZPNADKEmhM4YFrwSwDR9dIZFuOVhEVWkMI3DPRG95oNHUdeB4gPWuf2NJRFPvf+Gf/T3/aBspO+wHxZifkm8Zm4oYB4WGkUNgMcKT5K6ATocYS6WaUEHIsLEHupTH74xs9iMe0L3dRW3Ct5oBrEUcElF0TmWeM49CsBpzyTEWyjdRmwglWMGRqvjuo2TZ1x7633fzxe/9CW4FrRWQE+LEt1oXTLfiqiuVbVtG/pyGmMSx0WBTc5RqghVYxnTWnDFKafFaLh2+PDeLf9AEusLr/84342rcpl7IMAyABf3QMaFBjZsHPokYWtXNN7DxdPYDi6gcjLkpTTw3aFQr3hEHggZ34qLX/3EOamGS6PatWJQEEHnXV2ZZjAZhOhcMHBjhoGqikRvA/ycFVyytAbGLbv1t/8oH8OMTGEzDjrMj/7Szbdv6tHa0uFjBuUBYlIMoL2YZaSoUMRRAhbbtpaWJpyQ6XxmmkpyVkgevBXRm+leN926+Oha+Ov//K27UMOlKEoUiMWKWmypIVgy0C+b+tPbXQWyrO+TRYEtJ2JHXS4nyPjH+Nj1FwsUgu2wuTC1a0Ws6gupnwpiLJmW+wOW+6GGG9JKYJ2dJ7Uhe5W97zva2tntTJeW9ymQ1Lqqqrpu2gaee48kgEMopnVZlqoonEMzhdXV1bWVlbZpgvejYdl1XVXNi6KAtzXm8lt3wR0vuC6YcnUHYRwQWSCzbdPCBVFoDeQcdpYkPEmquInJYQT7uoC5G5HNkzLuAVM7YwVzbKFTvCjXSrf3fpMC5Yxn+1MF5FUV8K123obOKc80OilmZGQKm3GwEX/kF7b35hdf8vCiHHZ1AzNjDIsmGFSCZdxR2ARsEK0ToTe292DuHENMT3w735HEHVka+Gavq/dWhsXn3/l/3uNenveyT3M+jlHBjH96vvXYBUv8XbWCCfRujqCn77Teu+591+dEbMZd+PiNPxitZckSk6Z2raQDtKjpI9ELRtBEM6AQK1aSEu4ZgwjKeNKYUIzuqyPX1u4e8FXOIVTzQGSVUgyAJkbpgSRVDhih3lnnLKDrjhw+DMx5a2cbeC2EfEB54cuyKI8dPbo2vmcNr5Pv+9uTt93BKTedkZQXugRy0ZgWfcS0wk8CgSJDIyVk5agum3gsSc4HnK1efWUeEhl3x9orHlVHx7Q6nSRIBVrJfIstZGSwoQFTFJQJIbDwGi4PTxgEeZ2zb/1iPoYZmcJmHGic99xrGxOXVw8RLD3FHlURYE4MZOG/Bfc3ESnM/cLCT5gwhM0bXDMttSzgN3wbzZT7ipn50eXh7offfC/7knKZsoGPEhtgKUOt9wWL7e+lqdsl3WzhEUWFeqlY1EVyMRhrcs1fxl1o6xnyVMJob96aDI8xLgqYhYWBA4NHoKMAjqukXww8VjiU3RKW8Bf+2n3S0tqbzXd2djhno+FIKgXkUSudjLgE/JeoLP51HwIQWGtQs0hI2XVd0zRAFcbjUYtPULLg2LGjKQv8bbE6Xk5lA1Ex3AFJOgZUYBUETdW3eNEknp4abiDQDA6VPGgQdGqq0fMvy6Mio8f6yx89dY1XNCocP6lTC9Vk+nUvs1DOot6jkMdkOOZMEOu5JZLAk6iZzMcwI1PYjAONI89+7fHdZnzkwmJyaFZ1PjAtNa5M4hZhcvYMyatnyjDVMVV72vk4GI1wxdYZzeNEkTDbrjZvWy9D/dHfuvfdPevlf83lCqFlQKuknnAA23Bo0LV4ib9TpCCxWJ+WvODRohsR6f7bG3KqKQPxoTf/ELE1jNJkwpVGLKpeoq4wqlwif4UIDIcQJmJpcpaj3GGOqYh8+KJ/e/y+7EUW5XR/H0dqjEIANZXAk713faUCuXPlgPYqcYtvSSHnswqejkZDzjhwWe/9kSOHUY3jXrHxnz4TG6sjF4RHF7B1TGkiOKrQ0yhKzZInCE81NimphpoFEe1AohFhP9Z5YGQsxlK960oOm+chXRUwYDwuSWB5GOnFB3wqLICQSXIlouCBcRtp6wrP3I1fyccwI1PYjIOLyTNeeetORUfrxXi99ay1MOPzpGkdFhoruITPHOOOSdgClbWLnSdrh44wzru6Yr4byRibHTc7UX/k392Xnf7Uqz9L+cijR1dagwXS6n0SOuJ3Kh6R04UE6UuPNbPRcOoU3I1j9/tv+tF87h7i+MhNPx7djBObxNpJcrRKTyjqZvWmrH3iiUaDNsgMR5vHFKwKbMCKyX27rYpbb73Vh1AOBp0xwESBtnLO67q2xjrvfEBJ+H644lpssjagnCeduYC+B1LBi9PzQsj75KTVvP1LAyqAVdim61ojlKSCV6ZzJAzKMtB4eoUEIkz0F/MsOI4RHhvJ4siSe/5FeXhk0H9xqS05HWmvucUO3OiT+mEaNlglnmRfUbJN4jqCsPNGeDIUJXWk22/GvMzHMCNT2IwDjVs3Z3LpCB0u37Y5rS07dORC78j+zn7ir3emi2gyg2WWUIs6VxzXTwlRgsE065t9O9saCTP83H+87/vlatkTFYkgnAfCUUM2ff/OXSYVTEf7DROxlhEnqdXMwg052mk+dw9lfPQdP+baTermkmN4g/quwTEf0DYDl9mxCjbl8nnvNYSDmAHFE30KlsiRGKx9x73A/P6NW74x3dsHJryyvAyP0+m+6TqtVOxdtuiCtVK6KFVIQhoh+mCaejQawZPtra35fAbXzNFj90OcqGSa2GAbYzuTRD+otw6uEiFx8SOlYNGhIWB3WuwNRywPalIevvjYnpn6n74gD5KHMsZXP8aIOFhfsop2HCKctE6Rhqa/28t8ujJKoRVXu1u70USgsNJSPze778hVsBmZwmYcYExe+G8HRy/asfTkfsf0ZLRypLPUGZIyWVGiphXW4QFrDdgETT1lHr5Ukksx290WNAxEJO2Mdnvsr955v3b9jFf/lY+Fp5pwGRlzcFulvDc7CIQviPPC14imWlgvqGOo+tkI0ha8e++bn5zP4EMWpt0IdoeTVnOXPFaBvyZBILwP3uXyzqgkqaQgaRRQH4WnReBDViz/5Mv/5DuGWbu7u4xSIQWAC1EOBkopmvKs49FIiNTJLeArlEfuy2FDCD4Jwqmi9M63bQt/aWV19WEPu3+Z0WU90p7xyICRextYchuDj4GKBIvlkZisQfFDOpaM7ShqdnTMDQ8tzUl3+DU/mMfJQxMXvu4p2+2UT4pY8CZ0HSNBcZcc4hzEezQ6hqIWPlWgMFy04IpwwRSzxM06HcQlh87PhzEjU9iMgwv/41fNg/LFJBTLQY2jGgWiHXBFplNRVO+IuSj0Q3HN0+VTJJVUMU65N66eUjs/unQmS06O6kB1ZDpSYfHvAoXlfRHs3asFFwb3WM6IK8LEVUBhtTDMzz7wlqfm8/gQxIdvehyxmzAABK0164tMAoHwJhUSLIDdKwLtDLDrCc0zHREuSke0F8Onv+LT34G+FqOTJzequk5lA8KHsLm52bUoREAprZvGOe9cKiRAwpoKCbDVivfFsvCy5cmkz8mORqPD6/fbn/OW/+fPFZWaqZJr2AknXEsdIrFt15cwJq0j2rNYICVw4QKLrWx9Yro1OroyPLJ8YrqZh8pDExuzTScCLVgVzTQYuDyY5KlJFgdqOC38kgYSLlFAjBQ8Pbp6mHuyv7UnAzv+jr/LhzEjU9iMA4rymVc7NZxbYqLkeigH48iL2vjOESo0l4r0ErDep5kyeKz7M6NCSuKka3S0BXF2vsNtc8nR1RMfuP4M3sPz/9WXPR3VRrReUjUMvAwE14HR2pDADZgkiaSeRPtU5ghvxrBoaKhFaHiYB7P94RtyLvahhY+/48mh26G+lqyTwF+pw8Am+WqkhqsFoYTBA0ER0EvrRWQqcN1a0XnF1BJVq/e+i2KycvPNNwNV9f3qQJIFqOsaOGtfLYCyA9YCWY29lTylyYoj9AlaxpPYFuPR+ULrR11xxZl90rVyWeDnIzoKa4KMTBAOwR7v9RV6no7+uTEVSmBe1gVbtXM11OPlYWBevvTiPGAealh79ROqYMRA81JTzKwy45yxhnEkrw7LYXsKS0XS8EA1D0+Fp2M59I1jXdz+3S/lw5iRKWzGAcXkmb+820a1dLglugrci1KoIdzKagsTMdzPhKAC7TCTi0GaIOGu51h0gkVOg2ShoM43U1/Pji0P7viD//uM3wlVk8YChRVcLxNZBioC7BTTsX1SNk3RsOGbQaYC87lkTsSW+UrEiru5bzY/9tYsUPAQgq1PRbMvSKW5U8ywgBtNy6NskXNduMZh6IMUlEVauqBrwxwtqF551iv/4l7+/tKho1/9yle99+kK6Du0kogm8lLqnEM3ecZCCDIBOWsSh/V9OXckSUAeKG8FP7roogu3tzbO7JN+9fWfKqIItZNRRBOAq8InKYhIsndYDYsudigN26+WBE6JQ48830UTkasPgPauv/LRecw8dHDR6560OdsOIkIYwyVnUnApvHeV6bCEGvsMGabt0xDlVCgYS5FhLVeg8CJf+0Oj1XwYMzKFzTigWH3mVTMryuUjPirCYJOWMBtRiFWkvlRPmA8UJYN8GBZFNCY6szYarI7L7ePfGFCzNpTcVnb/1LGJ3nrPb343b+aZr/qMKNepXHF84FkZeJFSA6jSnla4FiteFM1s+6eYlZIcK7uAvghacz8nZj+f1ocIPnnjldRXkphFYXQw0XeUWMEc56hnQXs6yQTDuZpHpsrxakfkXuUdGxbjo234DkUvt3zjFriTRu+nu3vAU0lM663pH1bQpNqA3j5hNp+VRQEsFi6VyWTC+kqb4IH3FmU5n80PHz7sTPvdfN6tmz4bam/22zFcGjbE1lOPdJ3Fvkq8N8+72xwQow3WmDowX0zKcmXUEnvslY/NI+chgqmpaMHZQHoaZm3V1DW6aUg0NtieT4HRDodDILUBQjTrFAcKK2gXUAI2iOn2/lDoU7/7+XwYMzKFzTiIWH7ay7fnwYmJ5aWJPAhNhUSbH+/gTocLpgLzrz4Qzzjj6MwJPyLOyGiGMpYiKNJJM5Pd7oS2s/f+1nf/lp55zZeJXrV03MXSkSJwFYkMUYTEYtGElgCpTUuz0cO7QV0t5jSyWKNox+I82r2P/s7D88k95/GpG3/QmR0eWyCsisLc66jvAsQw0VHqFtbEiwpurCJIlhx8a6+lcnmydmEXiju262e/6k/vZRc7+/NmPnfWwgSf0lX491IjdyKxPYNF06+FFgEuFgiutcYXpyoCeA6RYDWfHzlyWPLvxTWrxmavUU6ooGTEhZCUfF2oLCBpTu8SLluOSyhUcwrvvraNJT5oZkW8ffdkHjwPBaxc/ah5aGkpOYoKhK7rrLOCcMUVDE00XKQB2wPhOYxRGMXOUwjymCgIJ61v96v5u/4+H8aMTGEzDiLWn/HqE7vG6xVSLANZNEHgOhP6r0SPQu0epmHBuE8FUpIXgkvbdQon59jM93yzf8mRZd7ttTvHx6wTf3Lj9+ydqTVDR3WQNgBzFR7mYiZQh4CqiBW5vcInahn2j8BiGekEpuKMJIaHmvissXWO42PXPcq2G8RNGWkl9YIFTiLDImlDoomxxfxjdClRSl2EZ9FH4mDS5rp2qnZSjQ+/5H+9+d746+4cxn/y7wploTC/mfKvffq1t9tIta+YiAUKOxgMkCIIMRgM5/NqPBrDj72HUJCNJ5Ol8fB78sF33/W5kmg7NyrKIS8FFcDN05pErxPCxGnpDiAlgjGtFZO0M8202p+ZKmhKh3r0yznGO8dx9JrHz2LjJIkFC5iIQBEOdJBjHO6qkrHxsITh2jUtDO9CCMV5NI4ZP4BbfeCmapfUMB/GjExhMw4iHv7i/33XyDBYb8jQ8TGTQ59ssdHNKNW5suiTQE//csoo94EF66WUQ8Giqcx0c8A6Vu+UdvbwQ5Pv4Xt75lV/bNkISEYbhI88iW1jDy28vVSjxe9URkAui0WxgYSGBCNIp5iR3EjafvxNj8hn+RyGtyeC2yGh5sShCBBMyjB6F/pZngBZRSKLMpc4dROshwloWMxkudyGYmr4s1/7hXv5+1Xl6nllWojZuFaS9n1bpJfSTPw11cOS1Mcd+wYqCL4kOnACM+CcwyP8AkSD4/F4fWXpe/jZ4x98g1RWdEEToYjAvi0UWFgw157FSszC4jUjOYd3BS+Zm2ZmGitpsTZpJRm+/JF5FJ2ruOjaJ241+15RrxmRFH0uMNrnigtJGbHo1K3LInhXdegSB6GO4hKT+dZxDzGgIzY0v/e1fCQzMoXNOHC44Gd+4+aT+3r1fL16QeVVG0oqRoRAqI7FczLxV4l93MEjAcA7W+ei7SxhvBSiVHzIva92pxvfHLj5pYfHX37X//W9fYcvuOavDB3YqFB5vmexwF95EkUi8CWw1oUBEsPixCY4Q0LHCfDXUIiouYl2+8PXPfJT73xaPt3nHj543XmUblE6YxROehAkpigHBYtT839HqcHMZMrZB3ykhGIiP1IRxMCJsaGje+WvoZpWWqhqOgXWWkjJksBrn3Tt27NYAj2diQW0baO1htdV80pKMZ/NgfJOJuPxcPA9PwITVrI2sA4uD0Y9XKFpITgtTwgU7uDAX1VIjNt7yinQcKq4oaEBrjuSYaT2Qzd55WPyWDr38IhfffJGvWtEcAXzmlhBLPVuoUzIMGdvA3cexy4jqWwMBlCAi0RB7OOJqdvQupVynI9kRqawGQcRt5zYMryk5UqQoyhHJojGwawsApAAmKeJR4tO6kNEJ20gihamZ+Pqzha6hBkbovVxIXV0W7d+7djK4Jb/9voH4k3KYily7SPF/BnMy0SQPh3bFySSJEpALCrVYzGghQ39urjHjcFmiN2t5yfy6T6X8KGbnvYHr780+B3Ba86xCpZRl1qZ0IKLEs6Yx5pVTlORH0kVqhR4HeOMpG/NOw9jvhx/W2esweBwPau6plGCC8aaqvLOjsej6NxdFBa1V7HclaQ1/JiiKWudsTZ9k+zs7gLBFUKsLE0eiOOw/e7PSSJtA7v0MaIWgcP8K7B13uvfpRIbQn3E92RtWerR0kQNitp3+66NheDL5cy1y1fl1q5zCpdc/cTbd05Z5mLB0YWLxo4Af42psS/AGEaVmUCc83XXSSGkkoQEYx3xvkSrN2rntSBs68bP5YOZkSlsxoGDf/LPy+FyubR+cq+uWjJaPkKYhikbZnfqffBOxiBoWqP31gWHlBG9hoSSWnDuTFfP901bjQr2yEvOu+M9b3qA3ucLX/WnqhiiRxeqBVHXKxKkjUaBTqFJYSslngLFOkiHiVr0+/YktBL5zZzY/Q+9MasInTuw3Q6PUwEnV7SCG85sEgOAISAIjIpeSAvHRbuw5EK1KZ5EYZFmBgK8smi9eO4rPvpt7pqjnZ3dpckEuPB8NhuURaElwRSsGwxKoKTIhxcirCSlYNMvAXfkQkphOuOc43ApETpZmpx35PADdyim//HzMvKuNn0RA9rmYYCHRBYOg8DLBjk8zAP1bGqtEaWSQGGDnbeVE0SMB7GUG/Pd9Zf/QB5X5wy25ntRUjbSbKAcDzV1hvqQ/LdwkPgQfMT1CBwt2O4nRXKSA4JrUS0WBlApdfeOXEKQkSlsxgEcE099EVVDOVwyRE5b1wDlk4VnIuBNjaGiZAjor86SU2XwuBGiOCsKNZmMvOts18z3dvZP3TFRdO8DNzyg7/aZv/I5RyUWMka0C4U7cYg9Y4l9GSLK1PYVsYm7cNI7zrjgGxobQWGrgMV++LpsrXku4INveSL1+5J3ihqG+dfQt/Sl/GtfCprYXN/FhSpwyQMejWSpDVgeC8Ol9fxnr/3Lb7eL2287vrO9U1V1URQBHTyMRiggprTXgk0Dj6Ragn5nNBlxCcGXlpY45x3QWPitQl94wYUP9AEZ6bFrrfCMo65Wb3DA05MFeZdcDIoCYtUZ6iqYyJHR4oIFj4ZHp2go5Vaz/7BrfjyPrnMAKy+9wilCNI+KB1y4YliqnWquJENNWJIEhGHIQjCmdBFQSssLwiUVcIW004pbsjbOQrAZBwJ8fX09H4WMOzF+9qsbuRLLNUvLGmufpNA6EVcvsQwWG7dxOuYwHSvCuHfeBqz0lyyiCxftQrfPzH4Z66NLsvrAm78P7/kXXnBBwEYc5gPMzz41mfmUgO3l620vN58qC1jSK+DoDY9Gm54D0UmMA27iL3/ho9753tvzGDh78ZG3PDHaTUH2NWs4sammBKu3IW7hseOkY7ihbVt0kXgVfWGddKTwQndMtDE0lFm98vzX3PLtdvH1W04ksSysIE3eBJjxZxwiKGKcD72d8mlVreRsgGktgon/RT4W/u+t5ZxdcsnFwH8f6GNSf/r4eU97zLxrgUJj6xpF3TvnTHAOaTdxDVzBgjsShEzdkAH1nblUUghccPG+r4dojHnYTzx+5y9vzsPsLL69v+wxlXBhKJ2mWEJAAo7OVHqFnQQBawloLx7MsPEBCC4MGWaxnHrgRWE4mbojannjus/mg5lxEEAvv+yyfBQyekye95otN1JLx4wNVQcTMlPliHFtbZrH+hRsct4SmM/ExSVnWucc8FnNqYBZsd737Z5m9vxVfer3//337Z1/6KbHhXbG7FyTpqQN+ojGBvtSMAPXYmsXlWhGhI+6zz2hZqyfU+IiG3ky7tzIxHWijj7j2j/NI+Gs5K/X/VA0d1CyJ/kMKBmFMCXAOHUcNuJE0tDAWgG0HqDecEZ04IMuKsOEV6rltKXesvDCa7p7/PuXPuLCv/iLv53PGiF0SlSRlNE8XXfdqxqQ6J1B2hoCkD9ggcD+rDGoBcv7DGiUCtnh0WPHSG/N9X0B++XHhxFrqEHGLuBNu0DdQArg0K2zVHBZaHh7HpeK4VpnGivaaWd9NBELCuCqmTvRxPPL1duuzxfI2YdL/80zbt88UVMjhpJoZgicZpd8lT1NesVpSTa4flgzFrjAcAajPbhCUK1j2HHdRNWQ3Xd/NR/PjAOCXEiQscDh573s5uOnPC9azxwVkUvsTE2NqCR1VWOHCkMpdqCvMM+1bWu6VkoxHBSSU0V9AWF9s1/vbZbUfT/5K0ANDwVgonTgiY6sZHzAuKI80dbI0XA2YkdLeq0HmkFQ8wjNGNCSIQSGejI2hrk3Ox99y9PzYDjr8LG3/jhxUxobFg31PlpLUWUg8iTgf6cbVcRTn2oKKDpl8nIwGI3hSWVC6+E7E6YPfbtd/M3f/d1sNtVoWhR88Kc3LElJm8MvvMdHGFGUquQlK3gPlCaAr4qi8M4dOnTo+8lfAeGdn9WeDZmKJnRVW+pyfWm1ms3hQh4OUdqTxbvNCjEmN9EUr+JyRSAlF+PCK3Jytn3Jrzw1j7ezC4/+P553arZVx9aJ4Hl01EMwF1KSNfC+l7GPyVLlFe2dL0JAubfYzbuCFyMxjF00szbz14xMYTMOHM5/3tUbO7PJ8jphwlosFpAc/Tat9xbmM85TNSkuMhlrcOKOMFs7Zzp4QIdZTrGQILbdfGeiufvEm7/P7//pL/kY5WMXCthsUC5IG7X13BNgsbAB7UAxTuzpCp56LOftH0NQpG//oqh47920bTbe+6Zc9nc24UNv+XHbbZEwRydhyhmcay/Ra4tC1BKTpBrtz7LHxnwGj7xQMA6qetp4q4Zjroc2aBtGw9FF97iLjZ3b63l1aP1QVVXWGo8L7Hff+u9YILWDYQnMlQsBj845eD38utYayCsMMvhyNBpx9iDceBUR1MSS6YEsfGOii4NyKLn01uGVkQyaTxNZ+NKHBYvFSiEfHJGUlLJl/va9jYtf8ZQ86s4ifPP4N+ftHGJ5iNq8IEBhCVZYYXkNxbYGzMJitMdQswOX29KGwYulQ17KwF1lfGNHOhsZZGQKm3HAcPHzX1MbMpocLkbLjCuYh22E+xqHzSV3TIL+6hiYY+WAs/A9JUVZaiV58JY4w4I31XR/88RExeKv3/GgfIrnvOrPZLkW+djGsnWi89wS6aIMVMQFe00asfhJgMhg8pUShVuUQMIFJ0o4wTsapt5t/sEbfigPjLMC77/+qa47Sf0Op10hohJcMSWpRMksrCKIqdaZkyhiRCNiR6gjzAbXOlt7X2MHE8zfAypXhD78zBf/2bfuYmd2whkH42V/f388HqHRZnLbSo8+RpdsCzAkgieC876pSyklhMCrJsF733Xd2tra+trag3KgZtf/5YgrbiN8VGpDtTct1UBy5VpDehHllBgWhIrkMJZWlT18GilY29bzrvIy6qVSjIsdN7/s15+Rx95ZgfHLH924BsI64KJMw109oDgWQRUC7GrERDveCpP3Ba5LBYjmkcNiz18RxdpghTTezcxSOdn93S/n45mRKWzGwcLXT2w7PqRy2UcVmAT+ive2JGmJEtdxkZnxaWFRoZEPB6JQwqZEIRjxzrVVu3fKV5uXXXT4Qfwgz77mz/ToaBQrHbBYr4DLeqocFYFpQgpcO04fKnWoG4q6CsDJ0ZqGkSiByQpXiFrzuSBbNG689y1X5rFxwPG+6344dqeo2WWhUsxoFgvOFOOCMGCsye7CQ3yVTLNw+GK7FaHw9awxhlE1mhA52JmZuRGiOPK8q/78W3exsXvL3t7UOBjlrm1blGhLy6zJ38unv5e203++7Vpgq73gK7DY4XCILlwJ8Hx1ZeVBPFz7b/qrwjEyNwVRoQ2+cczBNaAEWbDy1HaWJgY8ekEB6+eMS2Z8Z2wTmGcjSZb0XNpvzjbP+5c/mkfgAUf5c5c3zDod4X7N0EWWOBrQxYAF2ODaCOhoEC0KcpBEZO/KwioiNISETfRzOxHD/RuyCmxGprAZBwzNE3/OyeTU6oSnOlLs1MJUZVywWAaMNqVnsHgA9c+LQgoSbLCdIHGoJY+uq2fU1eevlN/4L7/54H6cp1/9R7RY9WzchcIEZWGqprDxwHhM5V6pbcHx6GmIDGZuAhRW8Aif1AvaCV5LMdVsR7Et193636/PNvEHFx+87oeY2eAOVWAlqQVpU9tWAPKKFm0RTrRnyd8i9VxhZUEg0nHuGG+jJ0oX46Uoi/3WdXH4vKv/+Ft3cdvG14DhcY69/CFEeAIsFrUIEpHFjfV2V73WKj5BmotlNxQ4awihLEv4Eugv8NejR4486AfN3Ph52nhhyYgqO++oJVoV+A5TQu7OitiFR27PyxleM5YHL4hRsdOxFn6H1CfM/rFrM4s9oLjwFU8pXnx5pzzRhGm04HI8GGLRFpbHwAmHGzdS2JDyr8BiQ6B3/Tq6y0ahHJ+d2JMtrW76fD6kGZnCZhwgrL7wtdWTXrJ20T9ZOnLRbhMrK2S5hErWQlhKHXr5EHgOM7PB4tfova+auiyUZLGtp9V0N5paUcd9y019wdpo92NvOwif6ydf+cdBLFkyaILGilhSOCSySFOTFgEO+kQ2PKdJKJak9bRgKeou1ZJUgs4U2RNxL3Yb73njRX94w5PyaDlo+B//4dG+3RBIXitFnIwwDi11Nvomho72lAzVr1LfXopdYAx4zgKTnksxXKbFpCO6Dpqo1Zf8q3uYoefdrjWhnjeFKrUulVJFUThrUXug568L8krufESXAEbhlTHG+Xw+m80synlgy9Tll19+QA7dkeFK2O9GYqg8hyMiUHcMa2FZuuQXE0Pq6ILNofBtyyUtB5pr6omrfVNR06jgSrrj5uOXPD6PxoOG9auecNvsRKccGzMDZ0p4R10buzZAAAZBHOGS4+JTKn1F2QFcWcCoTyRZODjN0UVuI6/j7OT+epFVYDMyhc04SDjy87++WRt16Lyaqobowdp5erTeOWYj5ULBwDAeO1K51ChG4Fwq/4/BG1x0D5a4jvoO7orN/lZs5+etj3c/8PqD8+n+2Ws/HYsVx4eWDiwtPU0sNt2f0WwWU2oGP8VC6x5YDi6vATPnse5ZrKT1gFcFmzK34+o73nt9Nj44KPjw23/4vW98GPMnNNsreVNwVzDgoUHACfU2uo74lsaWpUR738WVivxi4NEnb1nHhZ6sWaE3576y6qX/5hvfupdjF6yb1gZH6tppPRiNxozyummWl5dThWsqTKB3liekVrHULViWZV/56hKAxcJ3rrzyyu2trQNyAE++9dNLcsQ7MpZDEbhvTG92kBy8aBKBpWFRV4AVsd52qJqnZeSkjbaOptPED3hXhKYkMwh4X/hP8rA8OLjwdT9UscYNKVnicSwNdx2Ed6eNXzoerICrBZPuuDwhsBtXpP7CEJPhh/PR4BZqrzr6yMOXnHzbn+ejmnEwka0NHqLYv/Ax8yiDGDVWtEEKPohBNwHLBrmUuAIaIqdMSZUmYwvzWgH3OhpGQ01so4gba1bKON0+pZnvPvSbB+0Dvvv9p37pZy5GNS3qcH0MaUxgBAWCkjJoAEbDuIoM+LpFcUTmCXWMdihNQDtOoxAMiyqAAOE8Hn7xBVe8+33Z+OBBxgff/njfnhRxt2BVyW3BnKTIX9GtFdfB0dgCQi5G++RrSi+mku6AVQWYiHUUTnNhqaqdMmTyotfds1b/1vY2pQJY3GAwQLP4qu46GBusKAoU5YihZ66JvMZUPU76iIhz0XUGrhp4JfyuMebSSy/d39s7UIex+buN8tFHnLV4eQCzTyWS2IGeSn3xA8HW29Ci3pKQAsI/9BdtvYEPKQopJLohwMsY4xARsivWjv3oZfPP3JaH6IML8fMX8JWST1RLrcMWAGqiJQpttQPWv0bGqZQcBi3EVz4QKQVlKBTMQ7po4KQ64LpwnZCyEWt0fOJdf5GPakamsBkHCMWLfnXueceHkWqHDVolYYXzzMFUJNLqElpukjslNdE/ngbBYyFZM9tVBKiD576LzWzAg/ujNx7Mj/mf3rf5Cz9zoUdbht5zFv8J7L8BLmOcCyRp3ybOCh/UMiQlNtknpb4WItFQlwKb5ZjO8/5lP33ZuzKLffDwoZuuJHZLxLmmjWaGk5ZFI6JNylmBI0ftV/bhDLLOmLSMUMDPLEzOUnhBLeEdjAU5mnfS08kLr731Hnc0a9umblKfPlpTOeudR6W53mFr4RmbegMh6Ou7txmEQTCgKNobAYvlSZdACHHhhReiuPLBQ/vZjYt+9IqqamrXclQmkB4TcB7et1YaIli4QuBjCKkE40Bbgb82QHm9B/bD4Ptwo8BWTlzRWF1fpYrvzPYmV55vPruRB+qDgkf/xo+ZKwonQ82MgbCioFi7TCyXlEnWett5NN0oygLGcbRw+4MbO7DaUDIp8PKAc0y4ZyVVOgpuyTG9dvyGbGORcaCRCwkecnBP/+X9jgQ1JnLYUB043PUGjgq4fdm0mOhCCDD7MoZimgENjoRAncjogDS4aOrYzYlruK1kqLpPvOkgf9jnvOoLjg4NgU1bIj1RlgpPKDxBS9rTTeV0kam1qUzWJWNSw0LHY6epKwRQ9kbGWTSbH7kuyxQ8OHjvdY8N7SYPU80axRvJahbq6CvYaGx4bNE5FjegWNh7RYkKQRqLxQNMaXg0qENBnSg6WgSxxMtj97ij27f3ZrMmeNq16K5qDBaCM4a0FKIbA8w4eM4ZcrjUtkWTiBZhTPJFaTU6GsA1Q+lkMiExHthD+vU3/vGqHgNZiW1ALxO40IkAYhOQe0vBBE4QAeWTrUuus5QAM8f/Ee/gPkEDUKVOBTugdFmaQTzZbhe/dHkeq99/HLnq0bdsHacDUaxPpq7a7fatilb52jeWeiuSzxbE4hzlA7EgzDlJqMTG3AjBPEUlxcAdUZ4VUY5YuSTHd7wp89eMgw6RD8FDCpPnvHbTBMfKQHSgGsJzIHMUV436BBN1ztG+Ho4lg3fMQ0YXPdwGDdDWzq2vDNvtDd9UQ832P/7Wg/+RvVxFUhoj6oT6yruOwZ06Ml1M4B7evyb268IxicbSvkBWJW7CPGZtHeVA8TsfGfX+j657VFDLP/nKP8vD6fuDT9z0tK7dCXbKSSM4hBlYJ8CwVQtOTodSA1i4CWeuF3+lJHA4ncVwVHdmv5mVajAcTOZNPTMh8kKV67NG/vNrbiPkHla9T83mtjMi2dGF9HfTfyHpI+PyOsAZKwYFXB9AZ3kyq7PeCcZVIa31gqOjAVw6y8vLWqkDfmxvv/Evzrv2KV/bv4OHOBwNotIWrvTGFIUaDXTVVk3VMLgiBEerBiGBv5aEGB+9QysHyoQs1C1btw8In0zKcjQijSuvelTz9i/mcft9w6W/9pRbNm4LMhZUQABHJOZfgZoGdNeye3U34WOpJWpfoziGt53FHzKmiVRS2tq0ndNB8MCFQzW6pfHoxOv/JB/YjIOPXEjwEMLhF/zGrVtTUi5HMXS8dFRRIiOTgikU0MRsEWYlk/8mPkP9KfQ3gujdwaaAOsDk1ewX1Plqr/vk286KT/3//eHxl/7sI11SOEpCWrTX7BRc9dbgyTo39GUGyOJjqqtkrJcuACLLaDJhTB1BNMLfaawzL3nBI9793jvyoHqg8bHrHxe67WD2eWgFtSrNzrhAGhxNAxKTr3gWMfRKdalIZENUHfBbIeRo6BmvjLVUelE6Mm7c4MWvvudqkL262tnZW1BVbGgKSdKg/xd6bVn4GUrNJcNYQNO1aFCXzIx61S3GeNu2k8lkDHzubED117eTK1ZRtrYYFHoAn3U6nfkQlFIeLfiwZhwuB84Elk4k3YWe3YfYfxGDM3CJSKUEZ50zs9k+f8z64ac8vP6bE3kAP+BT+M9dbLiHjQ1FLIXn2GwLVwjcrQwEGhGra0qtsRYkoOcanjZ0fCGCCfgl1xhJ1JgVBdHSwoCOQ1puXvdX+cBmnBWgl192WT4KDwUcfcG/vmOv8YNJSxWRQGF1QwXmq6iUTCJX85FFy1kIHi1kDVb+RcHQ5kiwVGvoa24qAQRub+P8leGpD9xwFn3899zww64+VZB6JMyAB/gUvp0rnJYZpiuiJclgiVBsXMMaA8Z7h00Ch4vimpuHAwC/hzSYG1JUsfRyVQ+Wn/OKvNz2QOHjNzyWmU3iDfHAVgnnWJAtaEdJR2NFIvDXOSMKS2DRRVbToKKX0WsfxdQYCqRsaVw5s9+2RI+CKmyYWDr5+av/5lv31Vl/cnNTl6WzznUmpv78uKCtC/6KEgTAkQWWDvTVrrPpDMhdbx4Lvwi0r+u60XB0+NChs+tQl1c/vnEdLxXRdO4bTyw8932xDSO98QHFvPdC/Z4kbQdgSx6CW4HtQtIGIE3CEuU5MyR2YciK5h1fyMP4AYJ48aVkICdrk7mpiGaJvNouWgcnBcMNgs1blEqBnVq+NcZ0MJA15mMlx/tY6gLwbKSGwnEyd7QJEz7YuDHz14xMYTMOGMLTr7VyqEfrU0s818BcLZUMdYBYartHf0yY/wtOnWlRlR3LCZHCchYlB5oQpK9DO2XddL1kO+9/y1l3BP7gLU9iZqdkdcmA5jSxqwsaJMWV4QWLRV1PRwQeEXjuA3yTpmIbVMXH5ofI+zwfTNOVFYYXTAxlMfmnv/I/8wD7HpPXm57kuj0V9jWdkuD75vhkrQZnx2LjSewIaVIiFuVLaZQRW6olygV56SNvGGsF0CwRpDZENEF7Pvq5a75yzwROFbfcdkfTtUzKsizreeWtT55bZKGfRe58Dv+iEIIxlpK0EQgBZiOTGUBE72X5uMc9bvPUqbPumE9e9oS9bs5HSi2VNTFdNBC+YfVNQLe+ED3tWT0q7OIJgXOBbqUsoIKsx9Y3FVF3V3hO4fyYQGovibzw0Hnf/O1P5CH9vcXyq5/QUAsk1TH0+FZDbaM1rm2D1VpQJV3yimMou6I8sNcOzifc0EgpVFGUHO5mFi4cXqgRbb3b7+COuK4mGzf+ZT62GZnCZhwsxGdcY9mADVaJHGF5PzY2iUhFb42NBBeL/ckgRg1hedcatEfvJXbgZ5bDLRItDGrWzoas6z5641l6HN731h8JzYbwtea2ZFYHK4PBBraYVtcoMB+g9HDfp8k03qGCLHJWlqiLoKRveeeRicZTg9S2iFhRNhZ6/elX/20ead89/vx3n2TbfdfOgp0VrClFlXKsnKTF+p44JY9YiLIcEKXku5XS5chfIRSTSGEJi+NyGuJe44gcMr1Su8HPv+6eCzRdG+qmg0HQtE3VVGtrq1VVWevpXRQ2nJaATdGg91JJeCfAWcuiZJy38OvOcS7gennsYx69t7tzlh78lV/8gRnp9OqgYbZyDRnCB2V1V7OF7yhJBk5hUWcR0xKFInVbA4XVUpdcA5H1nScOKJKkJroa7ht0IobNTZ/NY/t7FGlc0RDDxmXQtCW+SbS1HBQQhLfOEOLLQcmlSDUgaFUROPBc1MRgkUJsh4lYVSimoosiioEYzLfnfmpW1GT3HX+TD29GprAZBwvuaS9rOdyp1oNcClHBHcwF7tFFiCVFitARdMqG54NIJPACY1B8CgV1gL0FZ5roGhqNDs2AmfChN53VR+O//87jbL01EmF9pJiZS9MEJK8hUgvEKHCXnEkD7cU+++VTrIRkSVgWDhnHo8YYWj+hB1Thguh84ciI6FVRHnnW1Z/MQ+7M8Kfv+jHf7RKzD8QHpmbqK0WNhkgBy1xQ3QyDKnSM7VksMEgTME+Otqioe9m7vCOHgrNDw3jSCFkZNmuZpcv/4je+cY871aL82tduWV5ellLVdb073S8KbZ1JlZ7hdAo23i0j20unwpvgAluclHWuqVvvQ1kOjh49Ink8q8/CoVc+ZcfNZrG1KpSrY6V5Vc+R/qQIoufw/cpFiF6IEGXsbMcgkpNaclyh7oyLyJ2kgjjZ0XavNtNmyIvzV47svDUn+c4cqy9+WEPD5NiaL8RXjn+j8t3kyPrKodWNrVNcS0G8Q4m3qLWGM2VsF3A1zVmURKSjcjiUOvpg5g2cTC0LFng00TYhVnZVr+y/LfPXjLMPuZ3rHId4+kvmQbDBiiXowsUpChFEXO9DUUBsuybBR99XwuIyufMUvbgitm9wXFEPWInYwVw0gpve+//D2X5Afu8DG1e98OGCUi1EtI45F5MCQS++QBJTBdofU+4NJTBxQ9KKydjYdwyhT5lkLVBgnqqEsQ4zdf8C7fmlFz3mXX94Sx549xcfu/HJZr4Zuh3m9nmsk/KrFbFlwTAC49Wj8Dp1faTRK7MG9HqXJCoWNdZ7AIvFUwkvMxCSzb0NhS7G660rXBz+/gc374GurZ7393//9eFgBL/Yd2UBD5tXFZbA0nhXCcFdz1GRoCgKIKwwYLQurHF11cCXo9H4YZc+goT2bD8R9d/cXlx5wd58SiTnhaQcwl0UwcXK8BB8anGjicYLxm201LUFECIJ5DUYoPPBU7iyKLXeO0qB1q8dOnToyGEmxO7uTnfJSH5lmkf7GWDt5y4drS/zkd6qdk/OduD5yrFDfKgr2zKU7o1wm+dSaM4huHAOC2KJD5aksqhAS6UKqVAItnHRRxXhjh6bWVvvzI+sHJnemPlrxlmJnIU9l3H+i151cua3GhIGq2p4KLCBsVzywjtMLyJn49Fj7G4D1oCi1JTwBBemoleCS0mRN9iaha5gLr7vN8+lg/ORN1yu7Xzga8o8ZQ4escaVwT3fRAKbT6nXkCpjJQs0GdOmpq8IjBbzT/BKT5SPhaOlIUNHh5YuOTaxZPTca7MkzX3Fh972k8TshXaHuj0RK02tFk4zL1gI1kZnUFmfY/8Q8NdUoCqxHpPCI9BWSaNkJKn6puK/GE2M1jK6Fwf7rKRi9Z9fe8/6AxdecPkXv/jFzY0NKWUvScEYBxgLpxWrSkgvVYEtXKfTsaheQRRKZWHpJzwKIdu2g3DvssuuMN25Q85Gr3lyTdp5bCGuVUPtqMdudjQ/Cw5LjLCwgCGztyyatFiNF0qIDLOzEMuhsqxWXEsq8DKyIbSeNJZ1UXo2EGr69lx1cz9w+KVXtLz1cB/SnAwUGciWx8p3M9eZ4AdaOmvgEpHJJxa+B9dBgZZqKANLldzb3y8IL5TSkbuqE5ErKl3rQu1LMazenkv5MzKFzThgWHrOr3RBBr10amosKcvxGlBYC4RLD2psTcUZOsXnAfUCYZaBKapPLsEE5A2LtgitCJ2w1fpY7b/nt8+9Q/SBNzy2NKfgozNuOesEs6h/j7JiBhirtz55kmmeDBg9AhVkk2gucBlsYMGDSFVAU5sC6KwjhSWFi0VjJZWT5/1anqe/Az58w+OInXJXMw+RkhGxE8RLlORNue7oIJygDBhSb3tKsGQ54GoB/C5jGlis81jfwbCniqXMOVYAGKp26NpPv/b4vey6mvvpdNY0HcPcetKV5Sg0BDtxvrW+g3PN0WgrGX0FdEjgKNiR8q9KCSlJSkfOZ/Njx84bDvQ5dmoe9b/89FeO3zx39Wh9HBW2QDpqu2DqiEnuILkSTEXCA7ZzcZI8EHzAAsxAFBdCFXB5OGwhgmgDwpDkDBE52tF6OG1kPQ5O3fTpfAncCy76xSc3bWuUVWtF5SsDt2hgqZo7QVuP4q6RUwoDlBIsfYnYecrwTuUgvsaAjODNHQbrflUDhR2qYkR1bJyvOmWp8vzQeP2rb/xUPs4ZmcJmHLDz+qxXzipfjtfL4frO1Nog9GApMGm9k4VqugbTqyK1ZnjPuJBcwHxTB9vRwCUfUkdsLeptXu2sSG8/8c5zNgX4xoexUNNYc9JK1kre4so06uCS4DzFelc4TDxVAia7MmRRyS80YI8X5uXown8JVR0o91R6Il3QnpaRjghf+snXfi4PyG/F+970MOr2JGkVBA8R/YMgduKBpcJWlB/A+lPuIjOEoUUcJQ6LPKJBqYyQUqAwC2NtAfNUMVUCTbKBGU98pFat/tPXnLyXvdd1vbdbAftK5R8ps56MYjkKvhJja+eaxGuBG8Ol4WNcVMEChYVXYA2sUvBqbPSO5Pzzjp2rp2n5pVe6gsYBNTq2vKuoqbglcLYU0iVpycBS1ocbceEQkjrv8EB2xpkOTh9am2FGEEJBTBOih4qAi2TqB/MwksWpd+Ys4D/G4at/YFbPIErGxsGB8ENRE4PdpSnpYL3tXMc4LQrNtXTOouYrlnlgkx0EDOkgY5TXQajmnVLFkCkVuGjhLu8Ly5Z5ucpHX3hrLtzPOLuR3bnOTezWhtDSEnSEDTALy5JJ5QM1IbiuM94WhZKFhMmmrZvQGYtymwL1ieDOCDO0ZgJied8R2xw+vHb83D1QP/W6mz9+w2Ntt+uxPwsTSZQ7znGVGqZc9GG0wTuLpAVmCy4J9dZ5ax3KguJ83FMbkiwhsMWo1ygth8oF19h527Xv+62LCR8/9zfyPL3Ae97wmOD2XLMtQyOklxwLAnrDLYYKTQT7T2JfcWlgRC5s4pLlBGpmRBeAuAJz9fBTRqSmXEAcFmjRBdGi86lk+jAh35bCOlfPZ/N05no7tjuRZLJIhLHfk1mDYprdYDBA2VcYC9bC94G/eti3MVpreM3RI0fO4ZO19//+7aFXPBkdHKyx0nFNxlISyTvqrDfMBuOj6FvdGNNCAFtNItNpRUcQxTRNwQGWGSQLiiQxi8sX5UByRnb2pvZ564NiaP/rrfnSACy94nH7s/1TzU4xKnWhGWeOo2wWFtvDNcBiuhwwbIDQriOu8P8/e+8CbllWlYfO53rsx3lUnap+AnKBKGnkol4NURIFEQNyyW3DxRiI0C0I8tRAQJMYv0+Tq1zDNRi0QRHwSvsF9NpKVEQU1MSEoBLkpYGm6Xe967z2Y601X3eMMffedbqqz+mmq7uoOjX+3rV77b3X3mfvueZa859j/uMfgrK44PzByxGcPgEtAHHJwGqjQhpNXR84bDJu3DTrE9mEleHatQev+vP/+3e4tRmXfLSOo7D7D93T/okrl2y5rHTPp9IHY6oloW3jIgxFxsigRFEaGECwhMG0RcqgChnSJE6Ecv1hOZC+2z4dt04c7qnJ7//ivm+xP3rn13fNSeU3rEK/rVKHUkXfdEiqkKCqeYFRTI3HIUSj6DJIyvPJUORfg1ZlKUJzml5MtouF88BlTUhVkrU0hVL1s17555dtz/zNtz5RxqZQvjaxV4rKwIxqEtuJFA6LbImoUZ4RzjBKgWvWOB7LQgCFTVToPTmMRYnQ+ikcHlnUQF6DhPul1vdcqLVZ+c5X/eVu32Fz88iJE1vWVAbLLOeCXnQUZY6zIq9tu8lwCMS11zTN9vY2UFXYp0M5QVxdXYWN6XQKXPbgwYOXSgmu88TKDd9w2m2JnpJD64o07saddLIyFs4G5KrCZDlyQjkBSQrIZFlp9CiATZSBZDsuzA/FWGFItVODZPumhPdNR5Pp1lS46H/z8iWyyzc+pcGLTtClrfqVsgYmAk3XNLG1pfHJ46QOq7/JgJ0fTeWixuWhtm21LVD8qgzKaBzKOeAQqAjX+d7KysHbb72t2Z6u9odXLx3qJXPvz/03HiUZTGEZFyPUU69v6gNm+Qqpa+/01AHfqnU5gAuawzXTKAvUTsHlz3eta4C/yuWlVaPtdHvcdhvLK1aJttteV25y7Wpv/Td+5jJpt4/+yt8NzYkUTps41mJKPrjeYuknK5VJ3gFxwQU7iVb2trSoS5vZ3Qs5dwzFPHbUFWiH9NZI3RO6lgqNt3yQnUudF5ggUw2e/6q/uXz65O+84wkqtWTpEHTyRiSjqE4sygUaEbFUATkUY31jlXUaGIz1mFGN8mytRAlvytUlkCzpmDTMFKQTsQmyDdrJXhQHk1x7zis/t8c3OXDQfvHWO0+f2laYxV2hS9csCJuryqKTGqVsxaLA4gUtwZB7Vq5lQJpcLD1b1/XjHve40fb2ZXIQV7//G06066JUeqmIhYS+3AnvgW9ZqYE7SaCyzjVwRWlViECoyrKCJ4GvKhTCSjHjuOhsoMhX1jhM7SptWdgS5s9AykIbVBCVKnumvPMdlxHNWnrp15/exra1vRJdIAx07IBtJNEZBnqcD10kFYFC8asKKnYBLbSyy9sELvQSphOaYuAa1ytIcCw8miWaZPpFT3Y+TlxPFZu/zLomBlNYxsV5Kfz2f3pyGrtqpRiuRWG6DkYaXfWWYaSgC57E2phGx+Dg1qJxoLdJDofAW8100iR/emUYt0/fEybbjzp8YPu3//3l1oB/+MtfE9p12W3IOBlWtsB4R1LB0wgciOmgZQ2mXJcm4Vwg0Vp0yESWEiqy95JMohBYxMjCk14o5FxJopZDyO2ui7Yui0FZLT/7JftZYHDL259k02YpRzZ5XE5GEuNlRBsMEYKIngq/AckJimqXJunnbw1U1bSTIQdla6SwyVBqEIziEhWXZdHGsNlEnyphDgRx6Lkv//QeX6ao2uNHT6dkNjfGKHOVBp0O5EJHgIF1irZjgiOZ9yda+Ybj74uyzHabW1tbwF+rqnrCE54wnUwuq7Pjmlc/7e71o175erWvKtOmbiSA4DtbKOBWIobWwSwPj2C/qGxVJx/btilImonloIjCUik1jNGSpYEM6P0E8xINl6ACjmuUoo2+C8OiV9v6rp/fz8lGaz/41MY3U1QIBI9XCFQvwX1ANRKuN2iNDBbmbXC5xqwFQcXSsHis9GSHiEJsoawxwcEMAp6Bk8QUuqg0xrZRWT4NbnNSJD0s6sOra5//mT/iUZLBFJZxUfLX57xic+JiOdwKRtcrwJZckEqX1WDVhTRpO7zYFVZrOZlM0AEbNoVOnUO2pSxM+K04pePJrZN3HBzU4SO/cnk244fe+bf99ITsRv1KWoFVGzFTXsjCoDo2JRilm9Y526+iNiqfRdlaVnhyJ6VnKDs+RLTm8hhN0UIZRQq1oNRmM0XxmqzxpnpKLX3ny27bP9OA9zzJu0kMTYydSK4QkzJNrPSowSDfXZUiZZ9QNTSsFSFnjQitpYi8zjPkdGykgA8pKXJnYYCGrgoEM2q0D3BKTrwbdVZXa9Xg2me9cC9vy14/fv7ztwUnra07qrRJju/EYGWWNFN0Fb3TIrBV5xxSsX6/KIrNzU0k0XVtjDl16hS8+qhHPUpJeXmeIPZ7n9DGroAZXq8YV25LT2B2FsllS1DMMOIBxamb82jrYQQJNwVNPhLVpshHF6YuGteD0Gw2CBOAtklDchGbTOiib5xwUSezurRyeh8VPr3inz1ta7SNlgJKBI0LDh4uxHURhHdYEyJC99boIiehbVwMMIUaSo0zZ5xQYbsFtB7AeLbHsr+yV/dCE+CqJDwavgKFLRXMsLFouB35sD5dMfXpm1mLz2AKy7hYYZ71A6M2qnpJlMMJXBptLyZy6jdlUfbHnZuiZiDBfB2ea7a3gMuuDgc9WzbjyXhjQyugZL2ePNlt3tpTk/ZP3n85N+aHfvnrQrsp3LaNnRXeSBgyoE1bXO/GEAlQUy8LTeMJCf1msViNlePFrJB8QmfRiGQtuxZg9pfOLA4L1+JIZYCyea98MFFUQvWlHjznNV+4RBvt999xXQxjESYiNTI6YDIGzbCSiZ2OLYbgEtpRoU8ZZf8jVUE2CwwG43ZprsbI6XFZoqGlQ7c3bE8Lw3HAqgYmKBsl3m+2cQwv2oPf+8PHHmB2t2K+8IXbphMnknJdUNoSb8VpRD5+SF+xRAWqOGGzrntoDg9vXFoCwgq0tWkarTXQ2el0+oQnPEGkdDmfIOp/f0yQYXBgKR7UW9V0O2GBP/TULUtTWkyEb6aTpgW2WhhDnDUbTagcf7XUeB2Wrk69sra2iA4rRLhJGwJGcPt1vx01vvGDsgef2DWumUyBr5n33XpJt1u48QmzmhClRamrTm0Ckt92wcvKAPP3KpJdt6T6f8Bpfeed8aHGZoTzByvGorAAZn40ffaUgAr9GWYDMLHTUZmA6xx40rgI/LfXiJVgT/4aiwcYTGEZFyu2n/qPvelVy4eAuTZOmWIgbAUkAViUS3Q1w+oFOCSXEitNdZOxNXpYV5UywG276VQLVWjd80fqcO/4j9/LTQr4rbd+jfLjQZFqE2WY+nYjhpFWXVmmqqwdplNEHJIjDSYYiMUapxItMkXbNYIsmrShhUCtyPHdBzTNFFVZwc4hps7HzgXnsb5tlIVQtVA9pQdJ95UePvMVH7/4W+n3bnpydKPgt7TsTOrQW1cGhTlYVNgMfqwxlS5E8CH4hO5UDqgLBuWQO86IaxZgRKGJ4WjMqMbax0D+W6maBHQXBmj0EjU+6Q43yk5W66MY9NKL3nDX3t/wqqsPfOITn0RjOVPAl0JJM8aziL+KednYnbW4hBgMh8FHoK1AZ621yLe6LoQAx7OqqmuvuYbPDoH1Tp84WYntQTEWLRY+wAkKOg94UmemrtXaViXZ5eaCzRFDsIbyuuAAT2I3Ts5iSamitDC5LgymSQoMPLrQrwfDovbOA3/tptD8LqKWP2KZC+hZ7/rrS6WVlr73iSG4KVxDlsqx7KaubaEvQs8v9KBfV4OeGfTgKrG+tRHRC1miwsa5DuvCxoJk96VWzWhsaJqXAVNDuLjAOeQjXETitPXL1WBoh1ZY0aZ2e+onnfJw2thH18t3v+PPuK8ymMIyLlK4b3vR0fXm4KOeUAwPTpzaHDXG1FVRS2O7EKddCxTJFmVRlYZs21UCKuUT5nJNYf7fU+rgyqoRafP0et3eKf7bL3KT3oeivfVvmzC2srF6CjctGyEakRzJ1cgqFgOxQNjQZRdXRinCFCJVcpJUx4g2EoWhMGYilJWod3O+7VwLLBaT7m1hqmFZ96TunVqfhFQK2RdqICXcht/+6otOEfihm77J+63oRyKMrA5VAU3gNcaqnUwepQIJXXTpRxcYfsNmQj2xRrVroHpXXmTpBTZZdvfTgaQClMyFFDaIaRSdsjANKJO0XpouFV2wbarbVAW1+t2v/KsH/Kr33Hs3EIHJZArMtVf3Dxxcu+fue3NiFhHWGX+VJAfJlBrolLUFcNYJqV37/X4kJ9oDBw70ez0+KRaovud/2V7uYg2MSrUxNr4FzgmTmLrfL3o1HHV4rChijcb7pN6wqKqhoDv0G5NapGvQK7BklzG4QO7grGh9kShMHjAqXmhbmlIbayRpZ12snSw6zHKCG7DmjV/59EXVLAdf/GTs+oUWFqvGwJkAjLK1cZpaT3oA+K0WzhkpocUmzXTi2mGvBmIKO2MEFoXYoaMlHE0SF5TR0AJOzOF/9JIzKmK2XGjhI9xStTQ0fdXJbmvabk6NtFesHNp4BzsPMJjCMi5iHPye133pyKa3S2a4lnS/jaYNopSlUAbJVUwOLWyiMHD9RzEm8VenQqi0jM3UN9OBNSuD/nRzyzeN/s//lpv0XHzgLU+WfqNXNv3KGdOkOI5uYoQ3lGkkE6ZjS6GpNhSZNCF/pcgsjcKUuoJFc2D08cJjOVtaY8dCU5TTlLJCECYYGtOVxo3Hcl+iTqJKCQhTnVJFq68FvO85r/uKeXL97n/4upl1gESJqk5w3yrRWR1RVRE7+DUpuBS8DGmuD4afXsCNYq4KKImUHrPfkkP+ikSGsrVQK2wFxV+xOZLBe+L9UXc+oU4S7r3sCdVLxYosVp/x4gdV2On4iZOT8eTgwbXNzS1gsWXVWzu4tr5+2jkfk0c9QK4fi0vdaMcPh9A5lzDHcbksy9FoNB6P67qG7cOHD0s+Gc7Bodd87VQ5tI2NHm06oI2sVqVVhYX29REONBGviD09oKBG6OwCUSphJMyxyZZaAYHVlmyhgJYh8cUMsESr7uQKgpNDeKkDxtv5XrJ1sqT7oHJsESaFAqW4pOcZvfuTF7gR/tbrnt76bmu83SYXZtYbMuJaAnR3oKKoKooFFjHD36Ep+22WwIjyay8WuhS06rOLz42kFMaKgCjchnMJ46/YFpquJiiGlQ5rKgN/rUQlmhjGXjXp0PLakV/kslsMprCMixhX/+PX3nZsa6oHdnCoUT0frceho6QaOUhgfV4bxYqxszwaG6Lr2p412nXWd4USA6snW+vSu6vWDh75zR/lVt017vhzjzdq06iJUmMrmjJ2JrQ4fObSpEJnIYHAUTUn34uc0C4UDLAaxzCaUSiP5WxNtEJ7kUOzygfRYeoXVqCC46QjsNxUAm3Fe9zASqpAclHnljB/m7ziNSkV0PNLSfutNz7Mgag//oWvj9GTz1T0cezCthI+J5loFZRyGsZT6Yyk+Cv6fXpUtTpgsYLqmMkZizWVMKXIPRAorCAWi300IIuNWE0AC/aqAiksMn2TqMATDv9adMK7oFw0yOn1UFer3/6y//kgf0KI+s4777SmWFlZAQo7nU6tLZaWhtvbowBUGwNa6AePRyx6aFFDBkbAbosSK39IiVWFgdHC/aFDhzj+uieRffLWZATEU9elrm0r0iSg4wl0BFvgdBpdUOCgKxQsCawu4SLZEBC7RWqrzqiLSWkgcWZIOXNUKBUdorD8VKBJnw3KJoMnAC6o47wRDjYqDTqPNl5oaGeMBO5bVLYoTXHkP/zpw/hjr33NtwKP7pzDL4TF4FAYAX+VKh8DB404S0M9OND2hCsOkqp56wiXAbS9whoE+KPxEqFRbwQ/1HUdaY0w2I+TOaFmJDaRg4PRbXCKrHaNsUZI4PF4qghTi0IHlaZRTmIR7EoxPPpLH+MOyWAKy7io8TXf/yNfuOf0qWkU5YoZHmpkRRf2yig0WCFFH1JYLCQrklc4j8crIwoy3VJpx6dP1jKu9kvt22N3funxj7n26O/8FLfq3vi9//D4ENaNnvZ021Nt4SeBAikCYy64zqeQyAoybEppLrQUFN/DcTbJmNPwvVVoHEup96iD9VQ30uN6odQwXBET1nSzMwEhbuOSLGbTI0FW6GmK2UhkDoWjvgEq2GEePQWkaAdFpXEp5YyixSh4II1popqqKXughvxltYyUpYQlBvKrFBWi2LIJugR2nedGkZio01jxNaLgNVEl3igpcccI3MZiWlhvFP4w/Bxr8GWSFuDgniuZ5a+CQ3SgtWUdsxOmwEqkyEysnYQ4AUqc6qQG2q6Y6tC33fBgh+d6+co7bv38aHtUVuiHNR6PQ4hlie5Y6+vrRF7RFl4bPDDed0BHYFJgKJi+snJgOmngLbBzXdfAna677roTx4/zKbA3Dr/sa4MWodRtCtPQNhH9CIDU4iwHZiJwxGGGXRbQHbsWy6gBeSss+plCj2t8F5zHeteY92g0aT0T0VZ0sSbxMpxKBidsKjo07yqojC2wugK1tThlgrkTkt3JFBke+hvQOkheeyf1NUxYEpy0CaUt5EdBn4r3eI4okS0qsjlF9MCXcYpFftromiCWlpeEMWi6GkOaVTuJ9EdEzHVQFFWeJm9WDDjTM/CTjAh47c1rYnSFiDKflUhSPUkFFs1o6OydjdAJK9Foq8dwake0ia2UBTrfTlub9KDo9YHEwnRh1Fqnx7/619wJGUxhGZcA1DNv2GhEawdF/6CuV6cYsdNelWht7UKcMahIeeCBruJoDW9lqpSabJ3WrjlQmlL59XvvqHUIf/Fr3KQPBr//zqd07UnZnV4pup4Y0yiGnvw5y17SqEul4gWZjFIacSZkFJdFm/4gjTeZu8lEy6t4OCOJ4JAPijnXy8JMJK80CEcapGMge3+y/o9insWP3FRm5oqL8rMNMt+ceT9hKD6SOXr+evhWGk2poAAxURzNIxVcjTlPf/4VoGcFdKIXLgeGZqElqqRFPQvmRQJlENIquJG5On0w/q1QhFSgjVbCBdVImT3wLkMjuCaNrCIXLaSwmLBDhBvjstpuezNOVqplYw9+5yu+jGIQozg4ceSu0EyMMUVRAOFxXaeNqiro/nJzY0PrmSmWMbhCCy8DKcFomsEytmVZeR9yOS54+xOf+MTJeMyd/8Hgqu978pHNU6YuiuWe6Fk4MbyMTexa37bQ2aFjGm0NBhmhR2JlVHJaxg6K8zLUggoSTsPhQQ+pgB7+VI8WI67wDyiv1rZBFWykcrXYoYjwSU03DOCGlOU5dI8zsjw3ojMO+6vO/VjmP4SnSsodUWLaYb54phmJjERRMf8KzxZagMhfL19UaYELlTF4EllFLDZhPqPKim6Z53xwBtTwls5RVS1cpqGYv/JAlNFLN1iszTub7EbSHeCVAOPQGi4RG5OxqatB1SuMQf66PWkmjQmqp0vr5Ik7jz3h2seefM+nufsxmMIyLgX++vQbR1F3pifKJVUtJ91ro8JqmwIXpUwU2YGFGA4u6+LlNSWbgDikWqvNE0evWKqsb6frR1W3FT/xfm7SLy8c+/avrsLpMm5KikrCWISFpnAg8yhsi55KOKFyAJUGQmNNHWkTDbVAYXFZPSCDzGNrrsWZKSyOf9ETpSNRqMqGU5S2L51KQBBrhSI7lP+JbIQwD5Vm23ghc2qUyh8rMiOgCC5SgXTGyR/9vmieg5w5s8ZZfDTOLw/41+nZELVHKW+OaGH4FoP7JKIAnqETiifgVxZEYTEfSxB1wFQ161LlcL01qixbzDGohCExbBelCoE8ErspGhbA78dFZ4zqOrMSqxVlDn/HS/7iwR+dqRjce9e9rhkXVpRlCa08nU7gqxQwZ8ME+dQ0U2AMGGbzDg+M1Tnqlqh1aHKBvlrwUtM0V1xxRa+uuc9/WXj0S79xoxvHQolKbbuJQ4GBiUa50E3aBihkv+7B0XZdzmZEJqswXUtbmAdRCWdUpWCnStQTEvQuk40NcuAUCzormj8S46SlCmK0mZVqtGBOeTkeA6u5yC0R3ITx4DjzccvQO0fE2WdQ0FfkCaAitgrPp3ZhZiFnZmx5NijRJi+gzhWvCJEYLbJbR9NMlLfGNACK6lEJ4XZQWPh5qFMJpB8w0BONpZJmwWHtAuC0VltZWFPVXecm41EzmdogV/tLy3XfjbuNo6dE49VvH+Mux2AKy7hE8LQbYjHobB1MnexA6MpJ03qFxVmkskIRhcEomcELaCAuG9F9HN3hfRF8IXwV2277VE9Mx//1PdyiDw1/ctPjYoTxCP1ijeiU9ArX1lsZu8JKZKgwCvusK8hRG9TKwaBc6ISkj+ht5qckDZBIZEnXl3KRVYxDweSDClZJioAmK5yWudRqZpNUQ2FOUpEMUAgWh788Hi9mPRKY5sKNnzLOMmGlWGzmrPQw/+lZKTJJ9RpEUuhdTzSYYrvzmrr542RWvgoz+5m5DCxGozGeFHRMhc8hZNIKZ4MGgyN8Ns9CNzGdpIHJFlaCCCqkzHKtWbr2GTf81Zd3RTPVqZPbW5sjH1oL3NjYruvatjEaKRK2AioVhbUWDo/rHLYp2WalXF8WfnmICiGB71599dXBe+7qDw2HX/KUE6P1cqWXSjVNXUS7alsOei76jc0N4HJA2gqjyYhAdKSlhg6DEz6jBZ1aebk/KLym5dV2VE/TsgXd8ik0gyE5Aa0lJDl/PgdoFw8DHm4t58LbmX+I2PEpJBjQZ2K0mf7mqLD0ZBe8s6qFmsVosXNTYYJZXNbjnyCOmj8HnY3xIjw/wfA8ofgx/C4FX7h1rjLoLDajsC0m4sK2tUVRVP3+cGtzuxtPUJoRRYJ+24a13vL6e/6GuxmDKSzjkoH+1pdPRaH6K0nVnS6iKpK0LqlAIjBctMbrNU79VTbXn8kJSKkF5Cl4611fp3b9aE+56X/9JW7S88SHbvpfgxvJONaiM2qqZaeFq0ulYEQLSCkxFInpHppy35VIrTFezSqpamKxZraeLnKlBDWvXxSIJAYKMfn89ujsfCGUbKooaYoIpT5TGmBHSGnHdiCpQJjtQ2n4FIkKc8IazozMWQi7eDT7PoZ8p4i8ynif6wiZEC86KTmKiXzvdQiK+DfGmbEal0AqbxLV0/RRB9gQMC4bnwwyb2C02pqyfMYPfNnCvrXDq3/1Pz4nI4aBuwicCX6yIoeBWFqLPx4XbTv057AW4+QBdwB2Gwn5hwiafEDDXnvttVop7uHniYM3PmXbjb1NotaqMtB5nYgeuzLqWqCFFZonw9mCFVOpUFfuUShX9blwG/bamMOlOczqZ/O/GZuMMi89kCiV2KEQWaCDwhwK1i4obDRGnjmBqMjIvBhc9nhb9Hk5D9BmmQGR2picmFFSSsWciQ1mZ16cSXuoChmqXSUJCWiimYJzWNEYzUnwWg07exR3YQVZ2BNmU4XGKCydqcJ3QGETdFmLNhnGjdrS1jDT8k3XjafGxfib93DXYjCYwl5S/PVpN4ydWb7q0dNkO2GxKCPGruAm42z1S1FB7bCgsDrLYTEWhiy2SqGEHcebYXRS/cU7uUkfLvzOzz9FpZEWUyvQO7YyQSWPK4owTmGek5ktMWK8plGmkbqlkW02lqq4kARIWtCfj7HnFIFKs+XueRBJ3mcPpcw5p7iQi09J8b6v5YQtOY+8+h1v2hGkIpKtktkxVksxo+DkfZvrbKFMAd4Q5kyaiDW6/6iYDXLxlyFpocoFGCeOyTqvXIAOXEVRRIGeWaZY+o5XPkQ/y6NH7rbKjramRVG20TtiEVieAJ0bDEbFMY+8Q9oKRAZXiZUh8av3mMkO3zA/77w7dGiNLQgeRiy9/DoPp0dsNibbsjArB1eh5bsWff5hWqG0gkmFKYymKUfbtRKjswongLReEWa8kJwBSUIqQ17DoD5HNDRSwiP0ywKNCnLW/1xmM+epSUZy/gqZ3frZ0gLC5VipQSXDzhNu57kUs3CGJDuYXJXOUF4949NpFsuVZ51m+Bx9f0VUWPgsgZgVnta5Bi8JYYHSojeBnsWSlWjj9tHTh5fXerYUPmy+izWvDAZT2EsNw2d8//pUFsPDvdUrtto4TRrLk0p0TKQFKUyxyQtc0TlagIskL8Q1Xbgiqogs1qbYN7I5eVT9t7dykz7s+KN3fYPw68qPkt/WsVUiGsxONkZYLbUkMWhI46S3hJnMlyjPRC8TmQthBVYccXO0NS/K6/maOwz2TRYYnE1tpadEsLDrqZ4Tt86G3zlWy1nCFgYj5Q5yrEWpU01fJs4rwYY0F+xS2pgidyEf0exWzuk1WiqhqW3sYeQVs8SCmGehIYUVuguFx/XSJVmsPvMHP3c+jX/3XbfD+G+VKaSetE2bkstSW8paJ45D+e0RS6QpynunBCED5wrwKPyZSGgN8IfllaWl4YD788MO/6Jr69WhLPTmaAt9YMtiPB03TQtstajrfl3DTAPmGKO2wap2RlNlA3JXkdmBQ5LTFmlT44yYUvgWI6AUmqVQOh3zRejUUEfM8dpERVyDCursyWHKcy+r1E72STQ3LbbJb1vmyK6OZwKxJr9X66yLTeRWECnZM9AahkONus7WhvlknOnkSfkAU6fClt4H8mRAt7GS5qLJp+h86fU1w0Prdx1vfo0NBxiM+8BwE1wSKL/lezcmrl6+SvaXNyZdtL0UdaRS8zizR+1AkHiLtJSmZzwkUX0bEUxyKnkdO901063xNQeHR7lNHwF8+41/mTf+vzevKQ/DYSp0LLWurBVEmkhTWkRpadRDxymytcrpX5IYbYTDqeI8BjqjuNkMC+M3AX0vvVhoUmfVerIy1Uitzoqf3udsx1fNfcmrPqujkXoBy2XdRyrgTeiQRczSvOkPRNI5UA0D+IouZ5Xnf2lWOdbiwqmoku5n94VAFWZDih75K4kHRC/p3ne99k4hjpxPy29vb0HfD50DZlFUdVWXqN+gJoZWB2bgvYNta01pbYv11bKXFpoj5QYjTSY2jusc89dHarx5792oPn7hV/XLAvuNkqvDg+VaAXSuaZvJtPHbE2kknC/oqOoxUTJpCzM4QwFOMvoHqur1rG7GXKuK+hRt5axDZ/lpVrgqirZSJBbZJGpxKE1yYXm3mOLp2cxL6vm5k02ztNihrxE71TqJziK0DnCkKwjRyfvIG7KmGplvQR4FYR4YzjRbZ8OviEmb+JZp8NM2uKCV1QVa2zoXummrG3nkF/6EOw+DcT+hGY7CXvwYPPMlJ7a6avmKVC1NRdlFo+uhx4QY9Dck+yK8uKsstJS2C3A5L0uTfDdW3daBlUo2m9ON49aPVyp1sF/c8ds/z616AfBbP/dEHSdKNIWMhfFWqwIGY+WayTrKDChqTpI5KmggArnsY4iJ/Kcoc5/S9gUJDBIG3UlXqtLOySdxWb1I7pLRSJHu/2yfE1Zces1rrBRPzSO4UGcG9XTfOlQ6SBWopK7IYdT8Fp/OjMaaxmIY9FWgRC7SD2rkC2YYdR/LgvqEYaZkgcEnU0s7EKr37Jc/DIWUjp04ARS1nTbww/t1b9DvbW+PWmDLGIOFxkrOOeDP6PqgNcVcO00SjpwZZK2FHeC+3+sPBsOqstx1LwCWbnzK6ThSFbqeKY1RSR+8R68sdIfTBkOpEUUo2b4iZa+ILNOOFAddkEU1t8SK80Qr8upKs3C/OENJsVytlIvd9Gzn+3T3mRg35/btVNPIGLXI8VskrGecEPBrREpmpIgv3CtKOyMlbpbOStlizQ8srGUoF03HmZhGQsf0ohs3/bLumQrOqnY0HW9uF1IfWF7ZeDfLBhgMprCXLK54wRu+cMeRcvlQMTw4FUXjgO9YU/Qj+g3QZTpioqvBwEIEPtTKQSMHwpSp2zaiGZqmSqM4OlaLUZ221wbmtt/+VW7VC4n/9M6nqLClxMjIRktfwPHCYlPkZoUrnOiuqgQRWUxfwbEPVzUTcUaJ2fECA0NICr3AnZIyefCV9yWmVD0gUsg2L5rqswhsHo3TGQmsIOlq3jcudLQzncCO4BOQW5My691hjzBLfsr707onWreh28Bc/IDlFTptWqVg3hWA3QqbdF+YZVWsPPul/+Vhad6m83feeSfQIGCx8LPruu73+1tbWzHMhLspLf7tiKZlryWE6jpHigK9tLwM18N77rmLO+0Fw+o//3tNM226FuhrgN5uNSpiC+hx0WEhN6p6hbM9PF9yx/UU+/RzuziRaxEKLGEnUNKaNK31BzKtMyJmm4wZGYVLpTDmvqfGOefJGUODnb0mkALBo7eLzBQ5zWsuoL4BJawizjy/ZJz5tKWAohysKNvh0kauNI0KcePhnJNVUmUyMEXsNsalwIldlbSJ6siv/g/uGwwGU9hLG1e94A33Hj+VykE5XHOybJJt0WIepvFloHl8prDAXCxV7ERBgeonO+yCCNONXinW6njq3i8UYeuqJX14KL/wvl/gVr3w+KObnxbadd9thzBWvutrjSF0QYZbaDXgNS0zYkF1GGo9kMU201BMV1bzBC/ip8R5zRklHzJNjIDSGn/Ig/x8ANbzKrezsFKuJJB2JHWlmTYgkCRPibnR7FnBKay/ldyZKFU2ssV71LNS7Xp04Zz7DKBMApUPSHDNJIoJjOXASkxl7ECXS8+88b8/XA0LZOCOO+5o2qau6kDQRldV1bUdlUmLARqTqCrQjGw7gI6cxuSwK+wZ4ZBMJr26hicf85jHTCYj7q5fEQxe9hQgstAbTVXY0nTJw02RiQVwwIB9HKWhHi0Lgsu1r3LnJO9YRdVZc1UCSyH2/JDUp1LNna0STv31onzrrBPtmNyE7E5332WMnC6GszM0bz6jM4izWK/EfCwpO9dRehZqhjwFfbMNHXkOKKo3Rl8H5qc+SriOA5FFTxlVRK1cVF2qhDn+3r/izsBgMIW95HHw/3jN8dNbth4M164etWmrFdHU0fQCXP2klZjonS1jMn/FNS6Nrvowje91ISxhIcLGbR2bnrr7imXTk5OtD/0yt+pXFr/3i9cFNzKpU8IpNNxCCgsDtJHCKJ8rwGL4KWKJBEUuV+T/Tw5VVMpLan1m5EXFaa4EJtFAPZvCz5L6xEIocMYaSMuzvk+cOwaFHDJC+wKV73d4ewkqcORmn4deBKgPjBgeVikXA5MGi8PF7H1JN6CwaJIlO2G9KaQtn/uqzz7MranNF2+91ftgjC7LCn1enQ/Bk/G8RKkABcJoR5OtCRJRWHjYtW1/MCiL4sTJk8Bf4ZW1tbW6LrmLfmWx9tJvOL29Pumaoi7KQQ1nhcQbViyOZMUVou9g1l5IrPKxcG9FKolVvNBNViT0n6AyGXiSqFyZlsSpxClVmrtknZmrndluvM85kWepCzIKLB0zk+FKJKK5/h6SZGCuTdOilsAUaKaQ9bhIcpHlSlR8afRdwL5IqtjW+cbFphNtKIJs3/9FPvoMBlPY/YPmaf90de1wNVgdt/Huo+uyGFZLB2PRbxuvdOHJ2VvlyqMi5CgsRQbktI1rBw+sDqutE/ecuvsLT3j0wXtv++zgE7/BTXrx4Hfffh0xUhiOKdMOs+eDlt7KQObmwGKDRL2sIJlBTi3B8ZAYbJgXCMglpZCqURmiZIwVZwQGmekuzvWzVkyzBiBQoQSksG4mbVWzCgVUQT5HWykxcGb9j6FNSvWaafngyyYqbowh2CKiBQE8LMg5C2O0z/nhzzwSDTht3ZEj92JI1drcAhhnBVbh8D+jDfEWTKfBX4dZZImsljTaboaA5QyofhqqeInaPupR13C3vIgm8Dd+3dQ1QaIpHcn84UhjRSuN9m5qIl0jXa4KG2H6J3L6FAkFoEPKNK9bi14ZWK2LKovEbIZ130Sus+ispiSrTGqlPJvpdq2DHj/nzTM9LhaPJj14vz/ApRCP1m2+cy6gu7AlE+JSFn7cCUfVG7A6bqqk7pX1+i+xYIDBYAq779B+0/OrQ9fWg5VpF4+dHk2d6i+vVb1lJ0u4NHplTC5OQxVJBcZfZ1UM0LfJx7WVpXa0LtzYpsn2sTuGf/kfuUkvWvynX/g7wY1FGIvYmNRiWQTRAqlVwmkqKUsWaYkKuqJoRMdFPlbIRPYMbT0TN/VnhZdm7gE7MDO1RA5sUIQQ8+5ZZauo1IIm81SYKmEBUHTJQjEDGrMH9MdSVLzYOC+mDvaplOkr09Om/5wf/PNHtMU6H+6+5x7XdQWi7LrOe4/1SYGPxuRcZ20B7J6yZpCheucwLVzlxVwBO5dlSYWWxOrKysbm5qOZv17EOPwD/9vENR4z8lBWEIxwpWhs9l7FlXosjaDJSUvj2TKFWb53iygs1W2ekdFIFb/iOYYdi5grzH+QM8vZKYW2cGKRIgaX3VKROVaeVJI5B6rPLc36xpMJfA5yVqxHQLKc+RmlvWqPb1ZeFqbsldXx9zBzZTCYwu5TLH/Hi0e6r5evaL3YGjWjNg6WDiVdtV55YWxRdSFR6mvKpixG+CgDcdlYybhU2unm6dCNrAxLJk5/7//hJr1U8Lu/8LUyTFQcq9QgkYXxWgUq5RUpWyoWEihsrg17ZhiWs1BS2EFhkart3CctHFtnj+Xc1sDkzO1ZJlaWJcxsEGZhWy91iCZhwBUHdUzukhq6YpQ2KhuE9aKQuv6Hr/rUBWiiuj/8wq1fQJcsh2lYWMWgaz1pW40xFIh1QGzzbxazyPFZ6VxUx0lr4Ly9fn9lecgd75LAtS//u6PpeBraUCtfS0x7xDouCVcKsIgVLtLDTCVQlS/yc8UCYGjNpVDvgkZdWNcg6XOclReTvXCmmyAH1TLNS38hF07RGOz28/JfZNyGvoYSWezm1jY8LI2FG0wBY4iobMGitGHQyauL5SPv/ks+iAwGU9j9jKu/62VfOrG18lVfPZX11qRtXKzrldWDV25sTk9vjoE0rCyvTtqWImXog0/Or14RhfUiDIRbK9X6vXdZFUod3Yc5f+vSwx/80jemOJFxkmIrhUuhi1hUyKvoe0DUqL6AmvkOxBl/JQ1srkk0J6q5YOxitI4xdfNtoqoiJ6foXJyWNAmaFANSZNd2+mDMO4vWBUrYQmkh3Ap0RdDAX8uk7He94sKFlOrB8DOf/vRgOIRvNplOgasYa4MPARpHY0oNchfvC2glbXIJWUGrw8j6I+wecjpXDsQuYQUDLsF1SeLAa/+Oj7hcj2v2mOOF9ls55lpWpaSyCFlsnmsiJBJ0o2kXzvzvQ2F3xmRzL1pEYemNSH9pNUKPxi0xYjl7F0kSgMIaiRoV1zjSgM9ORy2xdvH45/+cDxaD8QiBSxtcZGGG7/6hu4+fDPXSyKltGIujLeq6Xj4odOVSF+HCjHkzGBnQlHGd7e8zkSVj0RC78frm6UMD3U2nh5aX2B/oUsSzXnafYe9D73xicFPvOoWp2OgolCmpyMK+NBOmwsBa4OCaKWycL4TOWSzWFJjbb5F+jyQElIyFVQYE6Wnzw5mKAHO26GEAzqqrpAos8a7tM1/xFQsmffrTn7bGAgGtqgp4akcyVnKQt2TOgaYEiVisnBXsTfP/YdNQvhsC+GtVlsxfL12c/rkzvhbQR1du+LoOEB2cHdCblc1Gx5gRKclWltIeyTgDJl9qV0cCH1ycq2UVqamlJENXqvchJlg+y5JJVpYKUPUOZZUxSvVQrpu2bpp9MS9Ey8eJwXgkwVHYiwhXPO91d504LctedfCq9U6OUyHh2qgLgXJDBWS2sJWIqum6BCM0hsngUh0L6ST6dHo0Lkyu7raK0Ynu9L2Pe+yj7/qtd3Cr7mP8/tuehHGlRNElvGHdKznLYiGB7IzdwmCLtatSCjtHZ8rkNkTtstEsOhUJLLiqJY3L/+A1n7uofu9oMh2NRpubW/Cdl5aXgg9NM3UO7WCtLVDsi65ZGI0m/wEq3ZTTubIvASkHsPJywIXmJ1133Wi0xb1oPw9vL/hq4q04r4voyYVx+bJnlT1DYfV9ZbEOHQliLpSQ8xkxESznbwkznbRIj5VR2gCR7X6FDbAYDKawDIy//vN7NkZeFqLqx6I3FmUjrcJC3NpFpYLUwGWNLTAKGymvFVWSQF5TamWYWpusFjG0avNId/RL1z36irs/+F5uVcZZ+J23X/fcV3z2Uvzmpze2tkfbkvwEXNf1ej1gq5i1A2wUWcosvDrLIscYrMwFC+CZtm0jmQ/0e73hcHjvkSPf/M3ffPTIPdwfGAwGgyks47zw+Bf8iy8eWw+2p+qB09XEC2/rVhUUPtOYQIsLwloqnP4LkdrpZHlQS+Uwk91PqlLK1HTtGOjsih/3m5Pbf3ILtypj32Bje7S5uQkbhS2AiU6nUxS5opZG5IIFQmRnI3SVp3dgwI1EjVhgFmguSg2MMaiR1XVd93oVtyqDwWBc0lDcBBcD7jy+2clS9pZlueRk0QTZRhmz56DSUZs0s9TGEVtEb7D+Yqt8Y2NXqVgrr31julHRTQ72NPNXxn7CYGnlxIkTOYxKHFVqk08HkU0HaDKO/9FdJrCz5+D/znl03ipLpTUVoZXMXxkMBmMfgNO5vvIovu0VpyauPLCqqmWvCkyuFpiHE3CwVhpvqNfyMRkMNwXgr4Ol/sbJe1Vql3umX4pm+7SK02EhrdAnbrmJm5Sxb7A9nhw/dTqrBNCeyOHJAedIv9933nXtzGOBhIszGUEWNxpjC2ME6QoGgwGcOpPJpCrLAwdWuFUZDAZjH0Cvra1xK3wFMXz2a0+MneotFcODrbRNl6ZBCWmxaD3RV6E0FUfCZJUkyBkm+ugm/coUwsVmK3WjgY1iul0k1/z+L3GTMvYTjhw9ipW0MDMtJ2vFXLxAURUDkhCkbHmkck0x4rJoD6aUc65tmqqqNjc2bIEKhEOHDnKTMhgMBlNYxvmi/M4fPDX2seiXwzVv6+0mTNsYpS3qnieXQ1S/0tJowKzzlGQ0aKjdxWZUF3K1bwelFO1o8/jdNrbhT3+Nm5SxnzCdNkBVx+NJ27VKqSx7RTGB0jM6O69YkIWwlEGOD7GUmXfe+2yqtbS83LbtVVce5iZlMBiMfQMWEnzFYL/zB05OumB6uh7GeuCj9dGhMbepyqLnffY/QttL0hXguGzQpjNaIYpeMd1e7wuzWqvCihMbJwe3/Qk3KWM/4cTRU63vlNG5PAEQVCzEBFM5hbM7YKxwaixKbsm5lIBWK/BJa2zEQgfRWGO0vvaaq7hJGQwGgyks43xR/IMbN11IZS2Kgar6SZogtDRKaG1MSYW9yYkQ63lioSTKT8Ea9VHGUqa6sM1WO9kclZ2sZVhj/srYX7jrrlNd2yYRlHFlWYYYlFImpeydFXwwZPh6ppyuXPxHpXOTsNbqqsr0d2VliZuUwWAwmMIyzhdXfc+r/uauE9XqFaZYiqoXZNHhgqcyxhqho5DdtFFoCYSVl1TCUuA5IitEMFhLJgTvV5f64xP3nNjcHHzifdykjP2EL91xGiZutuiH2GgT6rpuuzahxAZVsTGlruuES5iqNXcekGfeLYnQYiy2IPTZf4DBYDD2I9hU64Lz1+9+9efvOFkM1lKxJE0vqKIJadR0HaZaJxHDZDI5tbHRpuTPVAjNzkFURDR5LUKlo01dmbrVnuUmZewnnDzdeu9iilKJuq601qdPn9ra3ESnDueapvHOFxY9XtUO4ppFBGpe2UCgl1a3ubHB/JXBYDD2Kzid64Li2u9+w9GtIPuHOj0IetDJ0iUdhdZSYy2hJGRKVkhrdVGVjevaELEql9GwqVOotahlVN04jNdVs33tar31YbYgYOwfdF6unz7Z79VdO3G+DaGLMWC5XKUwRYuskmfqAawfi/+JlIDd1nVdFEVKqe3aGCLQXXjycY9/3EJrwGAwGIx9BhYSXFDcdaIdy0pVq8JWTiiXMAoeyQ/IROCvQSZZYP16BQOwqXsyeBe8iGGprqKbpmacpB+YMB1trh2oj33grdykjH2Doqhuv+MLQD8LK5PoaujzMXofcpZWTtKalS4gEK9NEZUFyGJzmBaeHw4Hm5tbT3ziVwfvuVUZDAZjv4KFBBcOvaf/YJRGF1WAwVfbNNPsSToKKsrFNukHgMIaXVptRZKhNTIUKmrhhBuLbjqo9KnfYf7K2D84cPDQnXfe6b2TSnXOAXkty9KavebY5KuF7gTW2sxWbVGURQFn0NraGvNXBoPB2N/gKOyFmit84wuaIIsh6V+T8SnFhFkoJHVF8uoFbCud5l4EUoS2sUrWhVadRAutUg8q5Se+HW2Y//KL3KSMfYPVA2uf+MQnnHNVVRpju65LKXnvQ4zzWrFy5/5Z8RpCgP8ZaxWw3q4b9npFUbRN03bdYS5hwGAwGExhGeeP4u++oJW9arCSyr6XRYrahSTIOUsl2UmlRPZkxxs5aiUlk5tOlFF1qYVOTbMNtLaolJW+Y/7K2F/45Cc/2bbtcAgstJdVAUrK0Wibym3NJnln8Vc8rQprbQF7rG9swHPAYuFDgPKyBSyDwWBcDmAhwSMO/fdeOJH18KpHd8qeHk83py1W2UrSC+WFhptKanHLQgKVkuu6XllUOvlmHJvt1Vr70fpk/cihoeYmZewnnDh5Gno7OgwoCSR0MpkE76u61upMV0chbDo7MYsWMoQmscHhQ4dpt3gN81cGg8FgCss4f5hnvXzDmVitOt2bJOtUIU3hpJo0XZwRVrVTEZtQWoBBJhMD8NdBoftGGD8F/lrE8dWrvXt+/We4VRn7BuNJMx6Py6qyxjjnJ1OE995igLXQeq8JW4ix67oQwsEDBzrniqL4+q/7em5SBoPBYArLOF+sPO+fnepM6B+I1XCzTY0wuh7ATSobQ5wzV+St2Yt9xy3I1KnY1ir0bLJ+msanrzkwOHbLz3KrMvYNJtP22NGjSsm6rqHTu64D8poIeF5kxUC6f1csdIFVKqaECtq6mkwmV1555fHjR7lVGQwG4zIBa2EfKTz2//yXf31y7KsDRVm3STddEKooTSlMmVLQZU9JFef8Vc2G6cVoHUXsdFAqKNGNUrs9rOTJ//Rz3KqMfYNp0x0/dizEWMCUzhjvXAghR16D93DL6VwJ5eHpftO5jNbwKuw2nTZXHD7sXcutymAwGJcPOAr7iOBv/aN/8Ref+eI0FaJcjsVQlP1k66lPp7dGm9vjKNXBgweF0sRfgcVi5JXuI92CTG1stgc6imZz4+jd3fZJ8We/yq3K2Dc4eWr97rvvjilpjKRGIWcOWdaauq7RJCtGtNYKYT6xy6awi1yuRCS4adtWSTmdTntchYvBYDAuM3B1rocff/t7f+LWO4+Fatn1VlvbF7owRVX2htKWKUkXk8Cgkgrew+irKcgE/FVr4LJRRZ+Sr6Vb66swOjXZOLFUSf3f38utytg3iEmePHnyiiuu6LoOiKsxFu2x4FwwBuZxjsKx8Pxskq2U0do5jxsWyyk7eFdKvV4vawyuuPLKtYOr3KoMBoPBFJZxvhgfekorClmvxsFqo+suCocFuIxRRpGRVkgpwciNJbiiDAGe0jAae2dELLQsjChSo7tNv31iuVbNR7mELGP/YHl59d577xUkdXXeU+wVXbRwYjf3zpIE4KzWWq11JHVsUaB/FmzAC1VVxRjKqrz22mut4aUkBoPBuBzBV/+HGcUzfmjkhKyXRNXTRU9J7XzsmrZp2y5FpRWNuEhYIwzbWEAoVVoalWK7Ldy4UF3PBBXG7eYJILKTjzB/ZewfVHX/ti/dhj0/xq3tbaCnhlSwKHsNWUowS+QC/qo1TPsMmW0hlzXEZeFmjAY66zp3xRVXShG5VRkMBuPyBKdzPZzQ3/rKsVeqN/S256SNVDZWo81rghEayGwnkoxRSyGVdF2nkiiNLbUKvu1ih1UNQpQwSk83pdu65vDwTm5Txj7CrbfeGkIorG1JQlBVFdDTHH3F8Op8t+zWIRIqxLOQgGK0uA9wX3SdS2kwHIgUuEkZDAaDKSzjfDH5+u9VTg7XDulysN3GSetT0wlgqNZqCe2cnGuS9zAA16YsCjvuxpWxRibXTqKbDmtb6BjcaHu8KScnH3ugf+fvvpNblbFvsLGx5aH/h9CmhHW1rO3a1odgqDZBjr/GMyUMUv6Xg69oVmCRywKD9c6pfn9t7QA3KYPBYDCFZZwvet/5qkL1neo10KQ+RVUIpWKIRiVtpVYyxKBSDCIaeEEKI8Wwrkqtu+lotLVhY3fwypUUJltbG36yfsXQnvjQu7hVGfsGMYpc/ZWiqLLs97XW06bBdC7yxlqw2DQHbFuL0dj8xqIo8keVVcX8lcFgMBhMYR8GDJ/9qiMb7cramigGXSfbqUtaF3UvxBREkp6StkRSWhba0hppaLtggjBGK6tTYaTrQrM92jwZus0r1wbtB9/OrcrYN5g23YkTJ4C9Kq2NlImqagGFRRUByVsX/BUZqyTjrDTbFKSLNcY4KsQ1GAy+5olPPH3qBLcqg8FgXObgdK7zxVf9k3/ZRB1ksT5pQ1JRmU7IJgRlrcIq70nE4L1TwRUyWatLo+HJ6DrfNc511qiVQa9f29HmRjfZWBnWzF8Z+wkwkVtfP900jcQMLQ2sNAsDAAoLcCGjTXMLLSSsyFk1JnNhdVnUFWCtWWt9CEVZPu7xj2f+ymAwGAzBUdjzxDXX/9CJ9VGyPVOHcReUi7KoLQzSEQu4pxgMDNYiSpFCQgd33JQqyUSDc+yacVGayirl1dZ0e7lX+j/8RW5Vxr4BsNF7774L+roxBmhoTDPPAYHSgqgQCesXzDO55qHXGZ2FcwhOFyC+iYogXHvNNdtbG9yqDAaDwWAKe75Y7+ypqetEMNXS0qDfuKSCrOpercz29pbwnTTKWA3ENgVKZIlOK23gVlhT2vHG+qhtVaFsmAyNk//5/+UmZewbTKbT48dPAFXV2pRlmUTyPmRVgPe+67qlpSE8jHFmLDAnt/M6ywntCOD/ufbs6oEDgi20GAwGg8EU9vwx/fZ/1sae6NdG6KCsT1ponaJoJ40QWHZLGOUlDtBRioBlhpTEUlzJYW0DeNYPesa4JjXrKk30x5i/MvYPfAjHjx9PREOBvMq51ys+o1Wv7MNED4gp1uKKabcPGfZ6UsqNjY1Da2swR+RWZTAYDAZT2PPC33r1z992bHv93vWq7CfTl0mRqliqHEmif0hWZQoKM7roVRWl8kIW+CqGnepeGSdNN90u4/jw2uAublbGfkFZVXfdeuvq6upoNGpazNy6j0ZAkuI16bAHeyWMxuO6qh772McqmbhVGQwGg7ETnM71UHDPkWMxYKXLzE0TDsx4i3MR32JPm5LKjHa2Opr3hBFd+SSjUOVw6eqvetxdt/x7blXG/sBVV1992223GWOqqgKyinlbMYaABbgW8FiPC59Ie5LYlOLKygrzVwaDwWAwhX0YMHjOqzc2tmRR6rIUKoeXMosVmcUSkcV/WtzP0OuJxQYhR6OpE/rg2pVHfvVHuVUZ+wNXXHnlJz/5SSCodV1PJhPM2QIW67GIrHN45+n/ruvw5l2Me8lbq7I6fPgQtyqDwWAwmMKeL67+rpfde/R40zmjba83SFpn8gqU1Et5pkTmHDIljWUy4YY8V9EewGJjUuPxNPgkbc2tytg3+NznPgfM1VoL96dOndJaV3WN0plI0dgQESHmGCxsJrFXhFUbDbs849ufyQ3LYDAYjLPAWtgvD1vAO6OIPm2OJtJUKikgr05KtUimxoytHIjFjfxw9ug+MgMli2p9PBn/za39Z/zo0kd+Cp96+ktN6upSbn7oV7ipGZcikLNWFfBXKglr0QhWYTlZkZcpSFUjyf4V/keWWsRjd8FoNPr85//n8WPHirKcwJyvmcLOxhj4WOccpYftOglPrD7Yv6CCGA9gT0HdQzdNk3MK19bWlJTcdA8e3/b0p7/61a9+MHu+7W1v++OPfvTc55/85Ce//BWv+Nqv/dpDh3AtBS4LH/vYx37913/9fnc+6y/+6Z/+6c+99a07X73++utf+KIXLR6+5tWvPnLkCGz8qx/7sac85Sn5yZvf+95bbrnlrO/wr3/8x/P2sWPHXvXKV577d1/7utf9/b//96+77rr88I7bb/8vf/Zn/+Ynf5L7AFPY/YYo9WDpQCiHTdvFokjSeJlVsDJfWfWcxc7oapq1sqcnabzFnaWShw5d5bupm2y4brT1zB8dFKLQIcV23E78t7406n5Qxa5fY/fxWUddCE0ZZvePPYSF8M0TX+UfeVCm315HYfeXXEidVAH7GFoM+yi8Cp3xrfFT92e/9RX/aUA64R5YLLCHruum0ylV20JTAjGrvyWpFFecl+GSYvdALLyx69wxcjZIZzy3Ug7mSinlHt01MYndzyR2j26j5iiKIqtZoJ/A9sryMjfcg8fqysqC1T3gnuc+CczyhS984c5ner3eMwg333zz/RLEnX/xk5/85FnsFj4QPiE/vOmmmzJ/BXz2M59Z/CHguGdR2Of9w3+4+EygxeeS5h9505se81VftfNJeAi3p33Lt/z0m9+8G9tmMIW9RC+cqjcc+mI4msAAiSMokddZFBa2dS6WKc/mKDkimyNQChO5xKTp0Gio6murRWiD8U7H6Ewjwtj5fm8lyXo3ipP9Mu+fwiYkOHp3HhT3HNkDM9hHHnpPbrUHLUvSC+GiCmSAAdOUoJMTsVHdVIXiYvhpuXIsjDTW2qZpQohKYzenmgYx/7ZEQTSYxWW/rb1OtxR9SN572DLWGo0tF7Bac8r1afdqq52sl7HPJoF5YWv3zoNB2jiro5FLYzjnuN0uGM7lrzsBLw2Hwze98Y0P8tOuuuoqIJoL/vqBD3xgZ4AWOCsw18xT4f7JT37ypz71qcUbr7/++rx94sSJs8K68Opb3vKWxceeBWCx8OoNL3nJ4tMYTGEvfQqblNGFVxrG1sIWbTRZGBBxlMbLZSC7AWIbUZzNYjFwlu0L4OK6vjWqq6KqCqt1dGriJ9MAL5tg+rGng13djcLinxMp7MYhgBvE+TX+3PgE8ohdr/tB8JB/YUZg6CS7zxWUFLu8miQc9i7CAVY4E9LCq9jKqFBtHcLF8MuAuQJdANKZySXwTKn0Yuo065WJIqTZek7s1ecS7WAMJk1q5LuCeEkEUmJJnLAHSaU/wf15355Bey8XRSqHAf0QukFRFDyfeQj44he/ePPNN+8kfM94xjPy9mc/+9mdUVLYc+cbgUTu5K8f+chH/vDDH4aNZ37Hdyw+4XnPe94HP/jBBxnj/Ok3v3kRKP34xz9+Lve9+b3v/b9+6qfy9stf8YqFWuD7X/rSBUP9jd/4jXN59uJVILiww1133vmoRz/6+c9/flY+wKuvf8MbXvx938edgSnsPkFIwnVd4xsX1KAo226ue6XasSqdc6G9zy0TWUGFD1Rd9XqlVUal6Fo/adtojSirQW+4uqSr1umY7G40tO26XUdumYIWuxGDvWkOGdBzGPaRR0x7zhbS7ocPJj8F5Q0mCkEp7HUyeAHdSF8MR67f7zdNs729DbyhrmvgECh1lThnUyIpYueZTMishUVFwa5NYbQ2xih6e3YyCGRxYEpji6IjW4M9GpEp7D4OJuwxB4TpDXQtMnOL+SFc1nDOw/hy8CnC4uH111+/IKDAX/eQiu5UrO7UDNxyyy07o7PPfvazHwyFhbd80zd9U96+4/bbf+RNbzp3n52BWPiSi0Dss571rAVDPTcEu/g58Or3vOAFC2XCr7///e97//szi4U/DXsuXmIwhb3EodR00gSgn/3heDpVoqCCBmegF+wV1agxlzy4v6CaNEq3PiqgHyIGU2GOisBKXltt1KKJSat0/8NzhCG80HrXQF2KD5nLyCQ4EHthoki7N/Me7FYnOGEt9bKIbFY6K2C0lkZEHcPFUH11a2sLeAPwV6CejiJhuXxB/jcrZZDvkvDY+fecMaKJQVhIK+AzTRZaSAnkFagwPbE7hWXsYwq7l4RaZiEs0FaYRE2nUw7BXkg87nGPW2yfxXThIVDhHPvcudtueMkNNywo72QyeeMb37gbm3zb295200035e0ciH3t616Xaai4vxDsU5/61MX2H/zBH+z8WNiGZxZ/F/Y8S1/LYAp76VIPXMpNEpc1Pdpj3e+FdXZ5DbnMLLrAqqyXpevoziIIqAlEmisx1OTxs2PEhWEKWe0WM42ia3cNPiGjNjKxG/x+hEuFiwomMQo6iQQ+G3EVIGDN4tBdFGLYOE+0SnPM06rk/fDKB+qk+c1ZbDBL3ZIyh1cTSwUuZwKb9rJjk3IR6d/RDxkXCocPH84bd9x++7mvfulLX1roVvf+nG97+tNf85rXLB6+/vWv30OW+scf/ehHPvKRHFgF0nnVVVc9//nPzy+dG4IFPOrRj15s33333We9+tnPfGaxfd2TnsQUlinsfmGwgkpjYtqTzHHQjq6kWUKg7mtEAEzX47ZeaAn0LMaGNrFRLnK8EF6Qz9Asaks77HLZRZeuEMPuV3eJgdjIB+sSxR6RSZWCijGk6GTU2MmiTMGQ36qOF8URTzsweyiSEA91XWAWr12cVxK795z6MjW5fBls2isKu7P77eS13HAXBovY52g8fsgfMhwOf+InfmKhVb355psfUHXwjre/PVNYeNdPv/nNe4RgAUtLS4vtzY0NPmpMYS8LKIkh0ySpChcNsQvaChv6zAIxjbRkopVkrnkgd3DQJOb6gzg3USKbAq2QemJyjiQiuuthU+VuRy4oHzB8y9frS7aP7U7LcGKjZBnRBwPYq5FKJwzI7p2b/5WisPMo7MPUGdPMU5ZOqExQ4t71aRn7OZbwIMwoFhT2AfzXGBcfnve85+18uHB+3QOf+tSnFoHYnfLZc0OwDKawl+uVU9JKphSGIqxhfokkIptX72fhAYqwShpu86A7b/HZW2brYF6gRYCieJrB7fxRmj5T3+93APasjd6NFygZFNoScBT2UsUelhFCkhZUAW9N0GE09JmEClkdhNEXxZc/i79SLlf2gn2YPn+HkWxKLHi9bEMJklIDd+2EOZGLKey+wXXXXffa173uAcnoIhB75pl3vINbjyksYwfBmKtd9SzBf3aV1HOFwJxoIn/tqAwRPGmoosG8ONGcxdK7NBldzRfGkJqQikDrXcr/KkyL2b0oEYoRCskLrJdsB5NYjni34VbGREIDGTSuBHh4aGInohPh4rK9fBiX+HcjH1kayz3m8kPau4OxvGTf4I7bb1/Yab34xS/+9fe/f29zgJ2BWEHmXyxjZQrL2HlxjJnFppnB6kwIO5cQzNhtNiOgQVblzC2P8dc5yUyLC/GcuJ6xApiRYKC/YffyBHJvR6Yo9hKK8ah/UUPC9MXvMgajzgT7B9pOKJj8IJENKB4R0FkurqoUck/T1gffGHIXgiJZ3XgZnyNUYDZ9uXMexiXHX2+44YYf+uEfzqKCXq/3/S996QPWff3DD394p/kXNyNTWMZO4KVTpgX7jDkcu4N9JpXVrqg0kFGqRVw2iJ1VX5OeRV1FRNfL2fKxEtkSKykZgrr/a7SmEO/u3zAozPXaNd1Ls0z24kZAvetuY3MyeOgjhupJkq1FgO4DnUyri2hVfW4egP8/z2+V0u7zMWYql3U0YS8Ku+iB3FAXHidOnFikUj1kTCaTn37zm48cOfLvf/Znn/nMZ+a8rhe+8IUf+O3ffljKZW1tbfGRYgp7ORJYjADk1V5isWaufF3EXzPBVfNQ0eKSu1NCsFDEJrLQyvqBHKBVmcaIuIuOAL26xO46MIuOBLvaxWs+hBc/dhWJ5MOHfUNjT0tSeCnD/HZRrJ6eIzo8Pw6Rdi1PkHZwZcblRl/3PvR5BeA+O7B5xQXE8ePHM4W9X9usxz72sXnjfi23FrjllluyBQGwWKxcMHdp/dc//uPP/0f/6Py/5F133rnYPtc2C55ZbJ9rucVgCnvJsosQlPBAW0PyQWqTgFDo+VA9I7UUYcU0FjO3cheUg2UpU0cRUXXzeG0WC/iZMkAutANwDda7XHKBvu6RrIXiWqXk7iIExYP+JYsggg80vRExooo6AIsVEW4hxXDRnSxKzevUy4daamCvlK0H6siSs732J2SubiH3nkft5KzcES4kvvjFLy7I67/6sR/bufT/khtuWPhkffG22x7kB8InPOtZz1rQYviQ97z73ef5JT/2sY8ttuHDf/md79ypsn3at3zLYvsTf/mXfEyZwu4T+Kape72iKsYhWCNaHxvkn3Ax1Qovq1GjhIDytND1SJpsmJUvo6QQOEexmK+uaqeHgCRxrdntupv2isIqoDad223ghyt7UIqP46VKYWVw0SeNUVgpokk+Rie9S86LcFFQWKoZiwGwtm3X1tZGo1HoOvnQe9xeied7khM5o85MXvYh0twa9v5hrYVXw44zghwM+Lp3gfDBD35wYYmVo6e5UsB1T3rS9ddfv9jtDz/84Qf/me9617veNC8te+ONN54/hQXC+vGPfzx7bwE5fve73/0f3/e+zY2N5ZWV5z73uYscss9+9rMPi26BwRT2IiERrZ+OpNn00YoqpgjXRUMcVQUpDWkMSOQag1RlUUZJLfxlBj5RpeCDirvR0Jnr7G7vFXvUnU8YQObDeKkCyKuOSQVNWmqsK0uKWCOTUbK9CL4gkNeCkIt85lDZV4Q9UOUQyXrZfUlhcWoiH6C0gda61+vlvgd0loUEFwx//NGPfuADHziLxZ6Fj3zkI1+WVwBwVmCWObgLjPOs4O5Dw1v+3b9793vek6PCwFkXFHmByWTytre9jQ8oU9h91F5x6l2MjRai1CYhUcU2pCgsGnRi9VkMxAq0m+9aGR5SAEoTA909qjZzPdwNlHG26ydHHtQv4aE7kilsPoZwmH0MnQqd8E30zUXBsbX23nddB6Rh4c0Jz5wPJ35ILSXSQ5g7Mi6dU2EPdYC1VlCt46ZpoCtmRltVFbfaBcOb3vjGwWBwlkXrTv76qle+8sv9TGCTN910U96+/vrrzz+vC97++te//i1vectC23AWf4VXH7AkGIMp7KWE1aHZdimpFmf5EcUCehaFpWgTWh1FlZ0Kgiqkjg8pgQprc+ld5YOohXygygW7UVh4XivO6bpUkUPsSqLq2mBlOK8po0uroHW8GIxh+/0+XPrh7DDGAJOAh5lPXGgKK8SeJUgZlz6F3b1fAFuFHuicg06YJ1FKqZ0FRRkXAEBSgWi+8EUv2pnUdcftt//H973vockAgE0uPF+BdL7+DW948fd933l+SfjM537Xd33/S18KX3VBZOEK9rGPfezf/ORP7u1By7goxsSv+eqv5lZgMBgMBoPxSODbnv70zBcv5i951VVXPfWpTwXyysyVKSyDwWAwGAwGg/FIgZM0GQwGg8FgMBhMYRkMBoPBYDAYDKawDAaDwWAwGAwGU1gGg8FgMBgMBlNYBoPBYDAYDAaDKSyDwWAwGAwGg8EUlsFgMBgMBoPBFJbBYDAYDAaDwWAKy2AwGAwGg8FgMIVlMBgMBoPBYDCFZTAYDAaDwWAwmMIyGAwGg8FgMBhMYRkMBoPBYDAYTGEZDAaDwWAwGAymsAwGg8FgMBgMBlNYBoPBYDAYDAZTWAaDwWAwGAwGgyksg8FgMBgMBoPBFJbBYDAYDAaDwRSWwWAwGAwGg8FgCstgMBgMBoPBYDCFZTAYDAaD8f+zWwckAAAAAIL+v25HoCsEhQUAAIUFAACFBQBAYQEAQGEBAEBhAQBQWAAAUFgAAFBYAABQWAAAFBYAABQWAAAUFgCAuQQYAA+ZyZQKimMtAAAAAElFTkSuQmCC\",\"style\":{\"rotate\":0,\"opacity\":1,\"top\":1.1776383954154765,\"left\":0,\"width\":266.6666666666667,\"height\":133.6318051575932},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"612f7a1c-f5b1-11eb-8171-d3f7965fc856\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"dcc46900-f58f-11eb-8e9a-7fab6038d1ae\",\"viewId\":\"0de1d446-8300-4ab3-a4ef-4e8f8579cb2e\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":266.6666666666667,\"height\":137.5,\"borderRadius\":\"\",\"top\":0,\"left\":1333.3333333333333},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"612f7a1d-f5b1-11eb-8171-d3f7965fc856\",\"component\":\"v-text\",\"label\":\"文字\",\"propValue\":\"统计时间\",\"icon\":\"wenben\",\"type\":\"v-text\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":97.10144927536233,\"height\":29.08309455587391,\"fontSize\":\"14\",\"fontWeight\":400,\"lineHeight\":\"\",\"letterSpacing\":0,\"textAlign\":\"left\",\"color\":\"#CDCDCD\",\"top\":94.69914040114614,\"left\":1431.2727272727273},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":2,\"component\":\"v-text\",\"label\":\"文字\",\"propValue\":\"2021/8/4\",\"icon\":\"wenben\",\"type\":\"v-text\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":148.11594202898561,\"height\":52.29226361031517,\"fontSize\":\"24\",\"fontWeight\":400,\"lineHeight\":\"\",\"letterSpacing\":0,\"textAlign\":\"left\",\"color\":\"#F71A1A\",\"top\":15.415472779369617,\"left\":1398.055140495868},\"filters\":[]}]');

INSERT INTO `panel_group` (`id`, `name`, `pid`, `level`, `node_type`, `create_by`, `create_time`, `panel_type`, `panel_style`, `panel_data`) VALUES ('d2bda4c3-3c25-40c6-bed3-994ffe2949df', '某运动品牌销售看板', '308b5d60-ceb4-465d-9bad-cf901f2d38f1', '1', 'panel', 'admin', '1627973811870', 'self', '{\"width\":1600,\"height\":900,\"scale\":100,\"scaleWidth\":100,\"scaleHeight\":100,\"selfAdaption\":true,\"auxiliaryMatrix\":false,\"openCommonStyle\":true,\"panel\":{\"color\":\"#eaf1de\",\"imageUrl\":\"data:image/png;base64,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