package io.dataease.datasource.dto;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class PgConfigration extends JdbcDTO {

    private String driver = "org.postgresql.Driver";

    public String getJdbc() {
        // 连接参数先写死，后边要把编码、时区等参数放到数据源的设置中
        return "jdbc:postgresql://HOSTNAME:PORT/DATABASE"
                .replace("HOSTNAME", getHost())
                .replace("PORT", getPort().toString())
                .replace("DATABASE", getDataBase());
    }
}