ALTER TABLE `chart_view` ADD COLUMN `ext_stack` LONGTEXT COMMENT '堆叠项' AFTER `y_axis`;
UPDATE `chart_view` SET `ext_stack` = '[]';
ALTER TABLE `chart_view` ADD COLUMN `ext_bubble` LONGTEXT COMMENT '气泡大小' AFTER `ext_stack`;
UPDATE `chart_view` SET `ext_bubble` = '[]';

ALTER TABLE `dataset_table_field` MODIFY COLUMN `origin_name` LONGTEXT;


SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for dataset_table_function
-- ----------------------------
DROP TABLE IF EXISTS `dataset_table_function`;
CREATE TABLE `dataset_table_function` (
                                          `id` bigint(20) NOT NULL COMMENT 'ID',
                                          `name` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '函数名称',
                                          `func` varchar(500) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '函数表达式',
                                          `db_type` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '所属数据库',
                                          `func_type` int(10) DEFAULT NULL COMMENT '函数类型：0-聚合函数；1-快速计算函数；2-数学和三角函数；3-日期函数；4-文本函数；5-逻辑函数；6-其它函数',
                                          `desc` longtext COLLATE utf8mb4_bin COMMENT '描述',
                                          PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

-- ----------------------------
-- Records of dataset_table_function
-- ----------------------------
BEGIN;
INSERT INTO `dataset_table_function` VALUES (1, 'ABS', 'ABS(x)', 'mysql', 2, '返回x的绝对值');
INSERT INTO `dataset_table_function` VALUES (2, 'PI', 'PI()', 'mysql', 2, '返回圆周率π，默认显示6位小数');
INSERT INTO `dataset_table_function` VALUES (3, 'SQRT', 'SQRT(x)', 'mysql', 2, '返回非负数的x的二次方根');
INSERT INTO `dataset_table_function` VALUES (4, 'MOD', 'MOD(x,y)', 'mysql', 2, '返回x被y除后的余数');
INSERT INTO `dataset_table_function` VALUES (5, 'CEIL', 'CEIL(x)', 'mysql', 2, '返回不小于x的最小整数');
INSERT INTO `dataset_table_function` VALUES (6, 'FLOOR', 'FLOOR(x)', 'mysql', 2, '返回不大于x的最大整数');
INSERT INTO `dataset_table_function` VALUES (7, 'ROUND', 'ROUND(x)', 'mysql', 2, '返回离x最近的整数');
INSERT INTO `dataset_table_function` VALUES (8, 'ROUND', 'ROUND(x,y)', 'mysql', 2, '保留x小数点后y位的值，但截断时要进行四舍五入');
INSERT INTO `dataset_table_function` VALUES (9, 'SIGN', 'SIGN(x)', 'mysql', 2, '返回参数x的符号，-1表示负数，0表示0，1表示正数');
INSERT INTO `dataset_table_function` VALUES (10, 'POW', 'POW(x,y)', 'mysql', 2, '返回x的y次乘方的值');
INSERT INTO `dataset_table_function` VALUES (11, 'EXP', 'EXP(x)', 'mysql', 2, '返回e的x乘方后的值');
INSERT INTO `dataset_table_function` VALUES (12, 'LOG', 'LOG(x)', 'mysql', 2, '返回x的自然对数，x相对于基数e的对数');
INSERT INTO `dataset_table_function` VALUES (13, 'LOG10', 'LOG10(x)', 'mysql', 2, '返回x的基数为10的对数');
INSERT INTO `dataset_table_function` VALUES (14, 'RADIANS', 'RADIANS(x)', 'mysql', 2, '返回x由角度转化为弧度的值');
INSERT INTO `dataset_table_function` VALUES (15, 'DEGREES', 'DEGREES(x)', 'mysql', 2, '返回x由弧度转化为角度的值');
INSERT INTO `dataset_table_function` VALUES (16, 'SIN', 'SIN(x)', 'mysql', 2, '返回x的正弦，其中x为给定的弧度值');
INSERT INTO `dataset_table_function` VALUES (17, 'ASIN', 'ASIN(x)', 'mysql', 2, '返回x的反正弦值');
INSERT INTO `dataset_table_function` VALUES (18, 'COS', 'COS(x)', 'mysql', 2, '返回x的余弦，其中x为给定的弧度值');
INSERT INTO `dataset_table_function` VALUES (19, 'ACOS', 'ACOS(x)', 'mysql', 2, '返回x的反余弦值');
INSERT INTO `dataset_table_function` VALUES (20, 'TAN', 'TAN(x)', 'mysql', 2, '返回x的正切，其中x为给定的弧度值');
INSERT INTO `dataset_table_function` VALUES (21, 'ATAN', 'ATAN(x)', 'mysql', 2, '返回x的反正切值');
INSERT INTO `dataset_table_function` VALUES (22, 'COT', 'COT(x)', 'mysql', 2, '返回给定弧度值x的余切');
INSERT INTO `dataset_table_function` VALUES (23, 'CHAR_LENGTH', 'CHAR_LENGTH(str)', 'mysql', 4, '计算字符串字符个数');
INSERT INTO `dataset_table_function` VALUES (24, 'TRIM', 'TRIM(s)', 'mysql', 4, '返回字符串s删除了两边空格之后的字符串');
INSERT INTO `dataset_table_function` VALUES (25, 'LTRIM', 'LTRIM(s)', 'mysql', 4, '返回字符串s，其左边所有空格被删除');
INSERT INTO `dataset_table_function` VALUES (26, 'RTRIM', 'RTRIM(s)', 'mysql', 4, '返回字符串s，其右边所有空格被删除');
INSERT INTO `dataset_table_function` VALUES (27, 'REPLACE', 'REPLACE(s,s1,s2)', 'mysql', 4, '返回一个字符串，用字符串s2替代字符串s中所有的字符串s1');
INSERT INTO `dataset_table_function` VALUES (28, 'SUBSTRING', 'SUBSTRING(s,n,len)', 'mysql', 4, '获取从字符串s中的第n个位置开始长度为len的字符串');
INSERT INTO `dataset_table_function` VALUES (29, 'CONCAT', 'CONCAT(s1,s2，...)', 'mysql', 4, '返回连接参数产生的字符串，一个或多个待拼接的内容，任意一个为NULL则返回值为NULL');
INSERT INTO `dataset_table_function` VALUES (30, 'INSERT', 'INSERT(s1,x,len,s2)', 'mysql', 4, '返回字符串s1，其子字符串起始于位置x，被字符串s2取代len个字符');
INSERT INTO `dataset_table_function` VALUES (31, 'LOWER', 'LOWER(str)', 'mysql', 4, '将str中的字母全部转换成小写');
INSERT INTO `dataset_table_function` VALUES (32, 'UPPER', 'UPPER(str)', 'mysql', 4, '将字符串中的字母全部转换成大写');
INSERT INTO `dataset_table_function` VALUES (33, 'LEFT', 'LEFT(s,n)', 'mysql', 4, '返回字符串s从最左边开始的n个字符');
INSERT INTO `dataset_table_function` VALUES (34, 'RIGHT', 'RIGHT(s,n)', 'mysql', 4, '返回字符串s从最右边开始的n个字符');
INSERT INTO `dataset_table_function` VALUES (35, 'REPEAT', 'REPEAT(s,n)', 'mysql', 4, '返回一个由重复字符串s组成的字符串，字符串s的数目等于n');
INSERT INTO `dataset_table_function` VALUES (36, 'SPACE', 'SPACE(n)', 'mysql', 4, '返回一个由n个空格组成的字符串');
INSERT INTO `dataset_table_function` VALUES (37, 'REVERSE', 'REVERSE(s)', 'mysql', 4, '将字符串s反转');
INSERT INTO `dataset_table_function` VALUES (38, 'CURDATE', 'CURDATE()', 'mysql', 3, '将当前日期按照\"YYYY-MM-DD\"或者\"YYYYMMDD\"格式的值返回，具体格式根据函数用在字符串或是数字语境中而定');
INSERT INTO `dataset_table_function` VALUES (39, 'CURRENT_DATE', 'CURRENT_DATE()', 'mysql', 3, '将当前日期按照\"YYYY-MM-DD\"或者\"YYYYMMDD\"格式的值返回，具体格式根据函数用在字符串或是数字语境中而定');
INSERT INTO `dataset_table_function` VALUES (40, 'NOW', 'NOW()', 'mysql', 3, '返回当前日期和时间值，格式为\"YYYY_MM-DD HH:MM:SS\"或\"YYYYMMDDHHMMSS\"，具体格式根据函数用在字符串或数字语境中而定');
INSERT INTO `dataset_table_function` VALUES (41, 'SYSDATE', 'SYSDATE()', 'mysql', 3, '返回当前日期和时间值，格式为\"YYYY_MM-DD HH:MM:SS\"或\"YYYYMMDDHHMMSS\"，具体格式根据函数用在字符串或数字语境中而定');
INSERT INTO `dataset_table_function` VALUES (42, 'LOCALTIME', 'LOCALTIME()', 'mysql', 3, '返回当前日期和时间值，格式为\"YYYY_MM-DD HH:MM:SS\"或\"YYYYMMDDHHMMSS\"，具体格式根据函数用在字符串或数字语境中而定');
INSERT INTO `dataset_table_function` VALUES (43, 'CURRENT_TIMESTAMP', 'CURRENT_TIMESTAMP()', 'mysql', 3, '返回当前日期和时间值，格式为\"YYYY_MM-DD HH:MM:SS\"或\"YYYYMMDDHHMMSS\"，具体格式根据函数用在字符串或数字语境中而定');
INSERT INTO `dataset_table_function` VALUES (44, 'UNIX_TIMESTAMP', 'UNIX_TIMESTAMP()', 'mysql', 3, '返回一个格林尼治标准时间1970-01-01 00:00:00到现在的秒数');
INSERT INTO `dataset_table_function` VALUES (45, 'UNIX_TIMESTAMP', 'UNIX_TIMESTAMP(date)', 'mysql', 3, '返回一个格林尼治标准时间1970-01-01 00:00:00到指定时间的秒数');
INSERT INTO `dataset_table_function` VALUES (46, 'FROM_UNIXTIME', 'FROM_UNIXTIME(date)', 'mysql', 3, '把UNIX时间戳转换为普通格式的时间');
INSERT INTO `dataset_table_function` VALUES (47, 'CASE', 'CASE expr WHEN v1 THEN r1 [WHEN v2 THEN v2] [ELSE rn] END', 'mysql', 5, '如果expr等于某个vn，则返回对应位置THEN后面的结果，如果与所有值都不想等，则返回ELSE后面的rn');
INSERT INTO `dataset_table_function` VALUES (48, 'IF', 'IF(expr,v1,v2)', 'mysql', 5, '如果expr是TRUE则返回v1，否则返回v2');
INSERT INTO `dataset_table_function` VALUES (49, 'IFNULL', 'IFNULL(v1,v2)', 'mysql', 5, '如果v1不为NULL，则返回v1，否则返回v2');
INSERT INTO `dataset_table_function` VALUES (50, 'ABS', 'ABS(x)', 'doris', 2, '返回x的绝对值');
INSERT INTO `dataset_table_function` VALUES (51, 'PI', 'PI()', 'doris', 2, '返回圆周率π，默认显示6位小数');
INSERT INTO `dataset_table_function` VALUES (52, 'SQRT', 'SQRT(x)', 'doris', 2, '返回非负数的x的二次方根');
INSERT INTO `dataset_table_function` VALUES (53, 'MOD', 'MOD(x,y)', 'doris', 2, '返回x被y除后的余数');
INSERT INTO `dataset_table_function` VALUES (54, 'CEIL', 'CEIL(x)', 'doris', 2, '返回不小于x的最小整数');
INSERT INTO `dataset_table_function` VALUES (55, 'FLOOR', 'FLOOR(x)', 'doris', 2, '返回不大于x的最大整数');
INSERT INTO `dataset_table_function` VALUES (56, 'ROUND', 'ROUND(x)', 'doris', 2, '返回离x最近的整数');
INSERT INTO `dataset_table_function` VALUES (57, 'ROUND', 'ROUND(x,y)', 'doris', 2, '保留x小数点后y位的值，但截断时要进行四舍五入');
INSERT INTO `dataset_table_function` VALUES (58, 'SIGN', 'SIGN(x)', 'doris', 2, '返回参数x的符号，-1表示负数，0表示0，1表示正数');
INSERT INTO `dataset_table_function` VALUES (59, 'POW', 'POW(x,y)', 'doris', 2, '返回x的y次乘方的值');
INSERT INTO `dataset_table_function` VALUES (60, 'EXP', 'EXP(x)', 'doris', 2, '返回e的x乘方后的值');
INSERT INTO `dataset_table_function` VALUES (63, 'RADIANS', 'RADIANS(x)', 'doris', 2, '返回x由角度转化为弧度的值');
INSERT INTO `dataset_table_function` VALUES (64, 'DEGREES', 'DEGREES(x)', 'doris', 2, '返回x由弧度转化为角度的值');
INSERT INTO `dataset_table_function` VALUES (65, 'SIN', 'SIN(x)', 'doris', 2, '返回x的正弦，其中x为给定的弧度值');
INSERT INTO `dataset_table_function` VALUES (66, 'ASIN', 'ASIN(x)', 'doris', 2, '返回x的反正弦值');
INSERT INTO `dataset_table_function` VALUES (67, 'COS', 'COS(x)', 'doris', 2, '返回x的余弦，其中x为给定的弧度值');
INSERT INTO `dataset_table_function` VALUES (68, 'ACOS', 'ACOS(x)', 'doris', 2, '返回x的反余弦值');
INSERT INTO `dataset_table_function` VALUES (69, 'TAN', 'TAN(x)', 'doris', 2, '返回x的正切，其中x为给定的弧度值');
INSERT INTO `dataset_table_function` VALUES (70, 'ATAN', 'ATAN(x)', 'doris', 2, '返回x的反正切值');
INSERT INTO `dataset_table_function` VALUES (71, 'COT', 'COT(x)', 'doris', 2, '返回给定弧度值x的余切');
INSERT INTO `dataset_table_function` VALUES (72, 'CHAR_LENGTH', 'CHAR_LENGTH(str)', 'doris', 4, '计算字符串字符个数');
INSERT INTO `dataset_table_function` VALUES (73, 'TRIM', 'TRIM(s)', 'doris', 4, '返回字符串s删除了两边空格之后的字符串');
INSERT INTO `dataset_table_function` VALUES (74, 'LTRIM', 'LTRIM(s)', 'doris', 4, '返回字符串s，其左边所有空格被删除');
INSERT INTO `dataset_table_function` VALUES (75, 'RTRIM', 'RTRIM(s)', 'doris', 4, '返回字符串s，其右边所有空格被删除');
INSERT INTO `dataset_table_function` VALUES (76, 'REPLACE', 'REPLACE(s,s1,s2)', 'doris', 4, '返回一个字符串，用字符串s2替代字符串s中所有的字符串s1');
INSERT INTO `dataset_table_function` VALUES (77, 'SUBSTRING', 'SUBSTRING(s,n,len)', 'doris', 4, '获取从字符串s中的第n个位置开始长度为len的字符串');
INSERT INTO `dataset_table_function` VALUES (78, 'CONCAT', 'CONCAT(s1,s2，...)', 'doris', 4, '返回连接参数产生的字符串，一个或多个待拼接的内容，任意一个为NULL则返回值为NULL');
INSERT INTO `dataset_table_function` VALUES (80, 'LOWER', 'LOWER(str)', 'doris', 4, '将str中的字母全部转换成小写');
INSERT INTO `dataset_table_function` VALUES (81, 'UPPER', 'UPPER(str)', 'doris', 4, '将字符串中的字母全部转换成大写');
INSERT INTO `dataset_table_function` VALUES (87, 'CURDATE', 'CURDATE()', 'doris', 3, '将当前日期按照\"YYYY-MM-DD\"或者\"YYYYMMDD\"格式的值返回，具体格式根据函数用在字符串或是数字语境中而定');
INSERT INTO `dataset_table_function` VALUES (88, 'CURRENT_DATE', 'CURRENT_DATE()', 'doris', 3, '将当前日期按照\"YYYY-MM-DD\"或者\"YYYYMMDD\"格式的值返回，具体格式根据函数用在字符串或是数字语境中而定');
INSERT INTO `dataset_table_function` VALUES (89, 'NOW', 'NOW()', 'doris', 3, '返回当前日期和时间值，格式为\"YYYY_MM-DD HH:MM:SS\"或\"YYYYMMDDHHMMSS\"，具体格式根据函数用在字符串或数字语境中而定');
INSERT INTO `dataset_table_function` VALUES (91, 'LOCALTIME', 'LOCALTIME()', 'doris', 3, '返回当前日期和时间值，格式为\"YYYY_MM-DD HH:MM:SS\"或\"YYYYMMDDHHMMSS\"，具体格式根据函数用在字符串或数字语境中而定');
INSERT INTO `dataset_table_function` VALUES (92, 'CURRENT_TIMESTAMP', 'CURRENT_TIMESTAMP()', 'doris', 3, '返回当前日期和时间值，格式为\"YYYY_MM-DD HH:MM:SS\"或\"YYYYMMDDHHMMSS\"，具体格式根据函数用在字符串或数字语境中而定');
INSERT INTO `dataset_table_function` VALUES (93, 'UNIX_TIMESTAMP', 'UNIX_TIMESTAMP()', 'doris', 3, '返回一个格林尼治标准时间1970-01-01 00:00:00到现在的秒数');
INSERT INTO `dataset_table_function` VALUES (94, 'UNIX_TIMESTAMP', 'UNIX_TIMESTAMP(date)', 'doris', 3, '返回一个格林尼治标准时间1970-01-01 00:00:00到指定时间的秒数');
INSERT INTO `dataset_table_function` VALUES (95, 'FROM_UNIXTIME', 'FROM_UNIXTIME(date)', 'doris', 3, '把UNIX时间戳转换为普通格式的时间');
INSERT INTO `dataset_table_function` VALUES (96, 'CASE', 'CASE expr WHEN v1 THEN r1 [WHEN v2 THEN v2] [ELSE rn] END', 'doris', 3, '如果expr等于某个vn，则返回对应位置THEN后面的结果，如果与所有值都不想等，则返回ELSE后面的rn');
INSERT INTO `dataset_table_function` VALUES (97, 'IF', 'IF(expr,v1,v2)', 'doris', 5, '如果expr是TRUE则返回v1，否则返回v2');
INSERT INTO `dataset_table_function` VALUES (98, 'IFNULL', 'IFNULL(v1,v2)', 'doris', 5, '如果v1不为NULL，则返回v1，否则返回v2');
INSERT INTO `dataset_table_function` VALUES (99, 'SUBSTR', 'SUBSTR(char, position, substring_length)', 'oracle', 4, '获取从字符串char中的第position个位置开始长度为substring_lenght的字符串');
INSERT INTO `dataset_table_function` VALUES (100, 'REPLACE', 'REPLACE(X,old,new)', 'oracle', 4, '在X中查找old，并替换成new');
INSERT INTO `dataset_table_function` VALUES (101, 'TRIM', 'TRIM([TRIM_STR  FROM]X)', 'oracle', 4, '把X的两边截去trim_str字符串，缺省截去空格');
INSERT INTO `dataset_table_function` VALUES (102, 'LOWER', 'LOWER(X)', 'oracle', 4, 'X转换成小写');
INSERT INTO `dataset_table_function` VALUES (103, 'UPPER', 'UPPER(X)', 'oracle', 4, 'X转换成大写');
INSERT INTO `dataset_table_function` VALUES (104, 'LENGTH', 'LENGTH(X)', 'oracle', 4, '返回X的长度');
INSERT INTO `dataset_table_function` VALUES (105, 'ABS', 'ABS(value)', 'oracle', 2, '返回value的绝对值');
INSERT INTO `dataset_table_function` VALUES (106, 'CEIL', 'CEIL(value)', 'oracle', 2, '返回大于等于value的最小整数');
INSERT INTO `dataset_table_function` VALUES (107, 'FLOOR', 'FLOOR(value)', 'oracle', 2, '返回小于等于value的最大整数');
INSERT INTO `dataset_table_function` VALUES (108, 'ROUND', 'ROUND(value,n)', 'oracle', 2, '对value进行四舍五入，保存小数点右侧的n位。如果n省略的话，相当于n=0的情况');
INSERT INTO `dataset_table_function` VALUES (109, 'datalength', 'datalength(s)', 'sqlServer', 4, '返回字符串包含字符数,但不包含后面的空格');
INSERT INTO `dataset_table_function` VALUES (110, 'substring', 'substring(expression,start,length)', 'sqlServer', 4, '取子串');
INSERT INTO `dataset_table_function` VALUES (111, 'ltrim', 'ltrim(expression)', 'sqlServer', 4, '把字符串头部的空格去掉');
INSERT INTO `dataset_table_function` VALUES (112, 'rtrim', 'rtrim(expression)', 'sqlServer', 4, '把字符串尾部的空格去掉');
INSERT INTO `dataset_table_function` VALUES (113, 'upper', 'substring(expression)', 'sqlServer', 4, '转为大写');
INSERT INTO `dataset_table_function` VALUES (114, 'lower', 'substring(expression)', 'sqlServer', 4, '转为小写');
INSERT INTO `dataset_table_function` VALUES (115, 'reverse', 'reverse(expression)', 'sqlServer', 4, '反转字符串');
INSERT INTO `dataset_table_function` VALUES (116, 'pi', 'pi()', 'sqlServer', 2, 'π');
INSERT INTO `dataset_table_function` VALUES (117, 'abs', 'abs(numeric_expr)', 'sqlServer', 2, '求绝对值');
INSERT INTO `dataset_table_function` VALUES (118, 'sqrt', 'sqrt(float_expr)', 'sqlServer', 2, '平方根');
INSERT INTO `dataset_table_function` VALUES (119, 'power', 'power(numeric_expr,power) ', 'sqlServer', 2, '返回power次方');
INSERT INTO `dataset_table_function` VALUES (120, 'getdate', 'getdate() ', 'sqlServer', 3, '返回日期');
INSERT INTO `dataset_table_function` VALUES (121, 'getutcdate', 'getutcdate() ', 'sqlServer', 3, '获取utc时间');
INSERT INTO `dataset_table_function` VALUES (122, 'day', 'day(getdate()) ', 'sqlServer', 3, '取出天');
INSERT INTO `dataset_table_function` VALUES (123, 'abs', 'abs(x)', 'pg', 2, '绝对值');
INSERT INTO `dataset_table_function` VALUES (124, 'sin', 'sin(x)', 'pg', 2, '正弦');
INSERT INTO `dataset_table_function` VALUES (125, 'sqrt', 'sqrt(double/numeric)', 'pg', 2, '平方根');
INSERT INTO `dataset_table_function` VALUES (126, 'lower', 'lower(string)', 'pg', 4, '把字串转化为小写');
INSERT INTO `dataset_table_function` VALUES (127, 'length', 'length(string text)', 'pg', 4, 'string中字符的数目');
INSERT INTO `dataset_table_function` VALUES (128, 'md5', 'md5(string text)', 'pg', 4, '计算给出string的MD5散列，以十六进制返回结果');
INSERT INTO `dataset_table_function` VALUES (129, 'strpos', 'strpos(string, substring)', 'pg', 4, '声明的子字串的位置');
INSERT INTO `dataset_table_function` VALUES (130, 'to_char', 'to_char(timestamp, text)', 'pg', 3, '将时间戳转换为字符串');
INSERT INTO `dataset_table_function` VALUES (131, 'to_timestamp', 'to_timestamp(double precision)', 'pg', 3, '把UNIX纪元转换成时间戳');
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;

ALTER TABLE `chart_view` ADD COLUMN `drill_fields` LONGTEXT COMMENT '钻取字段' AFTER `custom_filter`;
UPDATE `chart_view` SET `drill_fields` = '[]';





SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for area_mapping
-- ----------------------------
DROP TABLE IF EXISTS `area_mapping`;
CREATE TABLE `area_mapping` (
                                `id` bigint(20) NOT NULL COMMENT 'id',
                                `province_name` varchar(255) DEFAULT NULL COMMENT '省名称',
                                `province_code` varchar(255) DEFAULT NULL COMMENT '省代码',
                                `city_name` varchar(255) DEFAULT NULL COMMENT '市名称',
                                `city_code` varchar(255) DEFAULT NULL COMMENT '市代码',
                                `county_name` varchar(255) DEFAULT NULL COMMENT '县名称',
                                `county_code` varchar(255) DEFAULT NULL COMMENT '县代码',
                                PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of area_mapping
-- ----------------------------
BEGIN;
INSERT INTO `area_mapping` VALUES (1, '北京市', '110000', '北京市', '110100', '东城区', '110101');
INSERT INTO `area_mapping` VALUES (2, '北京市', '110000', '北京市', '110100', '西城区', '110102');
INSERT INTO `area_mapping` VALUES (3, '北京市', '110000', '北京市', '110100', '朝阳区', '110105');
INSERT INTO `area_mapping` VALUES (4, '北京市', '110000', '北京市', '110100', '丰台区', '110106');
INSERT INTO `area_mapping` VALUES (5, '北京市', '110000', '北京市', '110100', '石景山区', '110107');
INSERT INTO `area_mapping` VALUES (6, '北京市', '110000', '北京市', '110100', '海淀区', '110108');
INSERT INTO `area_mapping` VALUES (7, '北京市', '110000', '北京市', '110100', '门头沟区', '110109');
INSERT INTO `area_mapping` VALUES (8, '北京市', '110000', '北京市', '110100', '房山区', '110111');
INSERT INTO `area_mapping` VALUES (9, '北京市', '110000', '北京市', '110100', '通州区', '110112');
INSERT INTO `area_mapping` VALUES (10, '北京市', '110000', '北京市', '110100', '顺义区', '110113');
INSERT INTO `area_mapping` VALUES (11, '北京市', '110000', '北京市', '110100', '昌平区', '110114');
INSERT INTO `area_mapping` VALUES (12, '北京市', '110000', '北京市', '110100', '大兴区', '110115');
INSERT INTO `area_mapping` VALUES (13, '北京市', '110000', '北京市', '110100', '怀柔区', '110116');
INSERT INTO `area_mapping` VALUES (14, '北京市', '110000', '北京市', '110100', '平谷区', '110117');
INSERT INTO `area_mapping` VALUES (15, '北京市', '110000', '北京市', '110100', '密云区', '110118');
INSERT INTO `area_mapping` VALUES (16, '北京市', '110000', '北京市', '110100', '延庆区', '110119');
INSERT INTO `area_mapping` VALUES (17, '天津市', '120000', '天津市', '120100', '和平区', '120101');
INSERT INTO `area_mapping` VALUES (18, '天津市', '120000', '天津市', '120100', '河东区', '120102');
INSERT INTO `area_mapping` VALUES (19, '天津市', '120000', '天津市', '120100', '河西区', '120103');
INSERT INTO `area_mapping` VALUES (20, '天津市', '120000', '天津市', '120100', '南开区', '120104');
INSERT INTO `area_mapping` VALUES (21, '天津市', '120000', '天津市', '120100', '河北区', '120105');
INSERT INTO `area_mapping` VALUES (22, '天津市', '120000', '天津市', '120100', '红桥区', '120106');
INSERT INTO `area_mapping` VALUES (23, '天津市', '120000', '天津市', '120100', '东丽区', '120110');
INSERT INTO `area_mapping` VALUES (24, '天津市', '120000', '天津市', '120100', '西青区', '120111');
INSERT INTO `area_mapping` VALUES (25, '天津市', '120000', '天津市', '120100', '津南区', '120112');
INSERT INTO `area_mapping` VALUES (26, '天津市', '120000', '天津市', '120100', '北辰区', '120113');
INSERT INTO `area_mapping` VALUES (27, '天津市', '120000', '天津市', '120100', '武清区', '120114');
INSERT INTO `area_mapping` VALUES (28, '天津市', '120000', '天津市', '120100', '宝坻区', '120115');
INSERT INTO `area_mapping` VALUES (29, '天津市', '120000', '天津市', '120100', '滨海新区', '120116');
INSERT INTO `area_mapping` VALUES (30, '天津市', '120000', '天津市', '120100', '宁河区', '120117');
INSERT INTO `area_mapping` VALUES (31, '天津市', '120000', '天津市', '120100', '静海区', '120118');
INSERT INTO `area_mapping` VALUES (32, '天津市', '120000', '天津市', '120100', '蓟州区', '120119');
INSERT INTO `area_mapping` VALUES (33, '河北省', '130000', '石家庄市', '130100', '长安区', '130102');
INSERT INTO `area_mapping` VALUES (34, '河北省', '130000', '石家庄市', '130100', '桥西区', '130104');
INSERT INTO `area_mapping` VALUES (35, '河北省', '130000', '石家庄市', '130100', '新华区', '130105');
INSERT INTO `area_mapping` VALUES (36, '河北省', '130000', '石家庄市', '130100', '井陉矿区', '130107');
INSERT INTO `area_mapping` VALUES (37, '河北省', '130000', '石家庄市', '130100', '裕华区', '130108');
INSERT INTO `area_mapping` VALUES (38, '河北省', '130000', '石家庄市', '130100', '藁城区', '130109');
INSERT INTO `area_mapping` VALUES (39, '河北省', '130000', '石家庄市', '130100', '鹿泉区', '130110');
INSERT INTO `area_mapping` VALUES (40, '河北省', '130000', '石家庄市', '130100', '栾城区', '130111');
INSERT INTO `area_mapping` VALUES (41, '河北省', '130000', '石家庄市', '130100', '井陉县', '130121');
INSERT INTO `area_mapping` VALUES (42, '河北省', '130000', '石家庄市', '130100', '正定县', '130123');
INSERT INTO `area_mapping` VALUES (43, '河北省', '130000', '石家庄市', '130100', '行唐县', '130125');
INSERT INTO `area_mapping` VALUES (44, '河北省', '130000', '石家庄市', '130100', '灵寿县', '130126');
INSERT INTO `area_mapping` VALUES (45, '河北省', '130000', '石家庄市', '130100', '高邑县', '130127');
INSERT INTO `area_mapping` VALUES (46, '河北省', '130000', '石家庄市', '130100', '深泽县', '130128');
INSERT INTO `area_mapping` VALUES (47, '河北省', '130000', '石家庄市', '130100', '赞皇县', '130129');
INSERT INTO `area_mapping` VALUES (48, '河北省', '130000', '石家庄市', '130100', '无极县', '130130');
INSERT INTO `area_mapping` VALUES (49, '河北省', '130000', '石家庄市', '130100', '平山县', '130131');
INSERT INTO `area_mapping` VALUES (50, '河北省', '130000', '石家庄市', '130100', '元氏县', '130132');
INSERT INTO `area_mapping` VALUES (51, '河北省', '130000', '石家庄市', '130100', '赵县', '130133');
INSERT INTO `area_mapping` VALUES (52, '河北省', '130000', '石家庄市', '130100', '石家庄高新技术产业开发区', '130171');
INSERT INTO `area_mapping` VALUES (53, '河北省', '130000', '石家庄市', '130100', '石家庄循环化工园区', '130172');
INSERT INTO `area_mapping` VALUES (54, '河北省', '130000', '石家庄市', '130100', '辛集市', '130181');
INSERT INTO `area_mapping` VALUES (55, '河北省', '130000', '石家庄市', '130100', '晋州市', '130183');
INSERT INTO `area_mapping` VALUES (56, '河北省', '130000', '石家庄市', '130100', '新乐市', '130184');
INSERT INTO `area_mapping` VALUES (57, '河北省', '130000', '唐山市', '130200', '路南区', '130202');
INSERT INTO `area_mapping` VALUES (58, '河北省', '130000', '唐山市', '130200', '路北区', '130203');
INSERT INTO `area_mapping` VALUES (59, '河北省', '130000', '唐山市', '130200', '古冶区', '130204');
INSERT INTO `area_mapping` VALUES (60, '河北省', '130000', '唐山市', '130200', '开平区', '130205');
INSERT INTO `area_mapping` VALUES (61, '河北省', '130000', '唐山市', '130200', '丰南区', '130207');
INSERT INTO `area_mapping` VALUES (62, '河北省', '130000', '唐山市', '130200', '丰润区', '130208');
INSERT INTO `area_mapping` VALUES (63, '河北省', '130000', '唐山市', '130200', '曹妃甸区', '130209');
INSERT INTO `area_mapping` VALUES (64, '河北省', '130000', '唐山市', '130200', '滦南县', '130224');
INSERT INTO `area_mapping` VALUES (65, '河北省', '130000', '唐山市', '130200', '乐亭县', '130225');
INSERT INTO `area_mapping` VALUES (66, '河北省', '130000', '唐山市', '130200', '迁西县', '130227');
INSERT INTO `area_mapping` VALUES (67, '河北省', '130000', '唐山市', '130200', '玉田县', '130229');
INSERT INTO `area_mapping` VALUES (68, '河北省', '130000', '唐山市', '130200', '河北唐山芦台经济开发区', '130271');
INSERT INTO `area_mapping` VALUES (69, '河北省', '130000', '唐山市', '130200', '唐山市汉沽管理区', '130272');
INSERT INTO `area_mapping` VALUES (70, '河北省', '130000', '唐山市', '130200', '唐山高新技术产业开发区', '130273');
INSERT INTO `area_mapping` VALUES (71, '河北省', '130000', '唐山市', '130200', '河北唐山海港经济开发区', '130274');
INSERT INTO `area_mapping` VALUES (72, '河北省', '130000', '唐山市', '130200', '遵化市', '130281');
INSERT INTO `area_mapping` VALUES (73, '河北省', '130000', '唐山市', '130200', '迁安市', '130283');
INSERT INTO `area_mapping` VALUES (74, '河北省', '130000', '唐山市', '130200', '滦州市', '130284');
INSERT INTO `area_mapping` VALUES (75, '河北省', '130000', '秦皇岛市', '130300', '海港区', '130302');
INSERT INTO `area_mapping` VALUES (76, '河北省', '130000', '秦皇岛市', '130300', '山海关区', '130303');
INSERT INTO `area_mapping` VALUES (77, '河北省', '130000', '秦皇岛市', '130300', '北戴河区', '130304');
INSERT INTO `area_mapping` VALUES (78, '河北省', '130000', '秦皇岛市', '130300', '抚宁区', '130306');
INSERT INTO `area_mapping` VALUES (79, '河北省', '130000', '秦皇岛市', '130300', '青龙满族自治县', '130321');
INSERT INTO `area_mapping` VALUES (80, '河北省', '130000', '秦皇岛市', '130300', '昌黎县', '130322');
INSERT INTO `area_mapping` VALUES (81, '河北省', '130000', '秦皇岛市', '130300', '卢龙县', '130324');
INSERT INTO `area_mapping` VALUES (82, '河北省', '130000', '秦皇岛市', '130300', '秦皇岛市经济技术开发区', '130371');
INSERT INTO `area_mapping` VALUES (83, '河北省', '130000', '秦皇岛市', '130300', '北戴河新区', '130372');
INSERT INTO `area_mapping` VALUES (84, '河北省', '130000', '邯郸市', '130400', '邯山区', '130402');
INSERT INTO `area_mapping` VALUES (85, '河北省', '130000', '邯郸市', '130400', '丛台区', '130403');
INSERT INTO `area_mapping` VALUES (86, '河北省', '130000', '邯郸市', '130400', '复兴区', '130404');
INSERT INTO `area_mapping` VALUES (87, '河北省', '130000', '邯郸市', '130400', '峰峰矿区', '130406');
INSERT INTO `area_mapping` VALUES (88, '河北省', '130000', '邯郸市', '130400', '肥乡区', '130407');
INSERT INTO `area_mapping` VALUES (89, '河北省', '130000', '邯郸市', '130400', '永年区', '130408');
INSERT INTO `area_mapping` VALUES (90, '河北省', '130000', '邯郸市', '130400', '临漳县', '130423');
INSERT INTO `area_mapping` VALUES (91, '河北省', '130000', '邯郸市', '130400', '成安县', '130424');
INSERT INTO `area_mapping` VALUES (92, '河北省', '130000', '邯郸市', '130400', '大名县', '130425');
INSERT INTO `area_mapping` VALUES (93, '河北省', '130000', '邯郸市', '130400', '涉县', '130426');
INSERT INTO `area_mapping` VALUES (94, '河北省', '130000', '邯郸市', '130400', '磁县', '130427');
INSERT INTO `area_mapping` VALUES (95, '河北省', '130000', '邯郸市', '130400', '邱县', '130430');
INSERT INTO `area_mapping` VALUES (96, '河北省', '130000', '邯郸市', '130400', '鸡泽县', '130431');
INSERT INTO `area_mapping` VALUES (97, '河北省', '130000', '邯郸市', '130400', '广平县', '130432');
INSERT INTO `area_mapping` VALUES (98, '河北省', '130000', '邯郸市', '130400', '馆陶县', '130433');
INSERT INTO `area_mapping` VALUES (99, '河北省', '130000', '邯郸市', '130400', '魏县', '130434');
INSERT INTO `area_mapping` VALUES (100, '河北省', '130000', '邯郸市', '130400', '曲周县', '130435');
INSERT INTO `area_mapping` VALUES (101, '河北省', '130000', '邯郸市', '130400', '邯郸经济技术开发区', '130471');
INSERT INTO `area_mapping` VALUES (102, '河北省', '130000', '邯郸市', '130400', '邯郸冀南新区', '130473');
INSERT INTO `area_mapping` VALUES (103, '河北省', '130000', '邯郸市', '130400', '武安市', '130481');
INSERT INTO `area_mapping` VALUES (104, '河北省', '130000', '邢台市', '130500', '襄都区', '130502');
INSERT INTO `area_mapping` VALUES (105, '河北省', '130000', '邢台市', '130500', '信都区', '130503');
INSERT INTO `area_mapping` VALUES (106, '河北省', '130000', '邢台市', '130500', '任泽区', '130505');
INSERT INTO `area_mapping` VALUES (107, '河北省', '130000', '邢台市', '130500', '南和区', '130506');
INSERT INTO `area_mapping` VALUES (108, '河北省', '130000', '邢台市', '130500', '临城县', '130522');
INSERT INTO `area_mapping` VALUES (109, '河北省', '130000', '邢台市', '130500', '内丘县', '130523');
INSERT INTO `area_mapping` VALUES (110, '河北省', '130000', '邢台市', '130500', '柏乡县', '130524');
INSERT INTO `area_mapping` VALUES (111, '河北省', '130000', '邢台市', '130500', '隆尧县', '130525');
INSERT INTO `area_mapping` VALUES (112, '河北省', '130000', '邢台市', '130500', '宁晋县', '130528');
INSERT INTO `area_mapping` VALUES (113, '河北省', '130000', '邢台市', '130500', '巨鹿县', '130529');
INSERT INTO `area_mapping` VALUES (114, '河北省', '130000', '邢台市', '130500', '新河县', '130530');
INSERT INTO `area_mapping` VALUES (115, '河北省', '130000', '邢台市', '130500', '广宗县', '130531');
INSERT INTO `area_mapping` VALUES (116, '河北省', '130000', '邢台市', '130500', '平乡县', '130532');
INSERT INTO `area_mapping` VALUES (117, '河北省', '130000', '邢台市', '130500', '威县', '130533');
INSERT INTO `area_mapping` VALUES (118, '河北省', '130000', '邢台市', '130500', '清河县', '130534');
INSERT INTO `area_mapping` VALUES (119, '河北省', '130000', '邢台市', '130500', '临西县', '130535');
INSERT INTO `area_mapping` VALUES (120, '河北省', '130000', '邢台市', '130500', '河北邢台经济开发区', '130571');
INSERT INTO `area_mapping` VALUES (121, '河北省', '130000', '邢台市', '130500', '南宫市', '130581');
INSERT INTO `area_mapping` VALUES (122, '河北省', '130000', '邢台市', '130500', '沙河市', '130582');
INSERT INTO `area_mapping` VALUES (123, '河北省', '130000', '保定市', '130600', '竞秀区', '130602');
INSERT INTO `area_mapping` VALUES (124, '河北省', '130000', '保定市', '130600', '莲池区', '130606');
INSERT INTO `area_mapping` VALUES (125, '河北省', '130000', '保定市', '130600', '满城区', '130607');
INSERT INTO `area_mapping` VALUES (126, '河北省', '130000', '保定市', '130600', '清苑区', '130608');
INSERT INTO `area_mapping` VALUES (127, '河北省', '130000', '保定市', '130600', '徐水区', '130609');
INSERT INTO `area_mapping` VALUES (128, '河北省', '130000', '保定市', '130600', '涞水县', '130623');
INSERT INTO `area_mapping` VALUES (129, '河北省', '130000', '保定市', '130600', '阜平县', '130624');
INSERT INTO `area_mapping` VALUES (130, '河北省', '130000', '保定市', '130600', '定兴县', '130626');
INSERT INTO `area_mapping` VALUES (131, '河北省', '130000', '保定市', '130600', '唐县', '130627');
INSERT INTO `area_mapping` VALUES (132, '河北省', '130000', '保定市', '130600', '高阳县', '130628');
INSERT INTO `area_mapping` VALUES (133, '河北省', '130000', '保定市', '130600', '容城县', '130629');
INSERT INTO `area_mapping` VALUES (134, '河北省', '130000', '保定市', '130600', '涞源县', '130630');
INSERT INTO `area_mapping` VALUES (135, '河北省', '130000', '保定市', '130600', '望都县', '130631');
INSERT INTO `area_mapping` VALUES (136, '河北省', '130000', '保定市', '130600', '安新县', '130632');
INSERT INTO `area_mapping` VALUES (137, '河北省', '130000', '保定市', '130600', '易县', '130633');
INSERT INTO `area_mapping` VALUES (138, '河北省', '130000', '保定市', '130600', '曲阳县', '130634');
INSERT INTO `area_mapping` VALUES (139, '河北省', '130000', '保定市', '130600', '蠡县', '130635');
INSERT INTO `area_mapping` VALUES (140, '河北省', '130000', '保定市', '130600', '顺平县', '130636');
INSERT INTO `area_mapping` VALUES (141, '河北省', '130000', '保定市', '130600', '博野县', '130637');
INSERT INTO `area_mapping` VALUES (142, '河北省', '130000', '保定市', '130600', '雄县', '130638');
INSERT INTO `area_mapping` VALUES (143, '河北省', '130000', '保定市', '130600', '保定高新技术产业开发区', '130671');
INSERT INTO `area_mapping` VALUES (144, '河北省', '130000', '保定市', '130600', '保定白沟新城', '130672');
INSERT INTO `area_mapping` VALUES (145, '河北省', '130000', '保定市', '130600', '涿州市', '130681');
INSERT INTO `area_mapping` VALUES (146, '河北省', '130000', '保定市', '130600', '定州市', '130682');
INSERT INTO `area_mapping` VALUES (147, '河北省', '130000', '保定市', '130600', '安国市', '130683');
INSERT INTO `area_mapping` VALUES (148, '河北省', '130000', '保定市', '130600', '高碑店市', '130684');
INSERT INTO `area_mapping` VALUES (149, '河北省', '130000', '张家口市', '130700', '桥东区', '130702');
INSERT INTO `area_mapping` VALUES (150, '河北省', '130000', '张家口市', '130700', '桥西区', '130703');
INSERT INTO `area_mapping` VALUES (151, '河北省', '130000', '张家口市', '130700', '宣化区', '130705');
INSERT INTO `area_mapping` VALUES (152, '河北省', '130000', '张家口市', '130700', '下花园区', '130706');
INSERT INTO `area_mapping` VALUES (153, '河北省', '130000', '张家口市', '130700', '万全区', '130708');
INSERT INTO `area_mapping` VALUES (154, '河北省', '130000', '张家口市', '130700', '崇礼区', '130709');
INSERT INTO `area_mapping` VALUES (155, '河北省', '130000', '张家口市', '130700', '张北县', '130722');
INSERT INTO `area_mapping` VALUES (156, '河北省', '130000', '张家口市', '130700', '康保县', '130723');
INSERT INTO `area_mapping` VALUES (157, '河北省', '130000', '张家口市', '130700', '沽源县', '130724');
INSERT INTO `area_mapping` VALUES (158, '河北省', '130000', '张家口市', '130700', '尚义县', '130725');
INSERT INTO `area_mapping` VALUES (159, '河北省', '130000', '张家口市', '130700', '蔚县', '130726');
INSERT INTO `area_mapping` VALUES (160, '河北省', '130000', '张家口市', '130700', '阳原县', '130727');
INSERT INTO `area_mapping` VALUES (161, '河北省', '130000', '张家口市', '130700', '怀安县', '130728');
INSERT INTO `area_mapping` VALUES (162, '河北省', '130000', '张家口市', '130700', '怀来县', '130730');
INSERT INTO `area_mapping` VALUES (163, '河北省', '130000', '张家口市', '130700', '涿鹿县', '130731');
INSERT INTO `area_mapping` VALUES (164, '河北省', '130000', '张家口市', '130700', '赤城县', '130732');
INSERT INTO `area_mapping` VALUES (165, '河北省', '130000', '张家口市', '130700', '张家口经济开发区', '130771');
INSERT INTO `area_mapping` VALUES (166, '河北省', '130000', '张家口市', '130700', '张家口市察北管理区', '130772');
INSERT INTO `area_mapping` VALUES (167, '河北省', '130000', '张家口市', '130700', '张家口市塞北管理区', '130773');
INSERT INTO `area_mapping` VALUES (168, '河北省', '130000', '承德市', '130800', '双桥区', '130802');
INSERT INTO `area_mapping` VALUES (169, '河北省', '130000', '承德市', '130800', '双滦区', '130803');
INSERT INTO `area_mapping` VALUES (170, '河北省', '130000', '承德市', '130800', '鹰手营子矿区', '130804');
INSERT INTO `area_mapping` VALUES (171, '河北省', '130000', '承德市', '130800', '承德县', '130821');
INSERT INTO `area_mapping` VALUES (172, '河北省', '130000', '承德市', '130800', '兴隆县', '130822');
INSERT INTO `area_mapping` VALUES (173, '河北省', '130000', '承德市', '130800', '滦平县', '130824');
INSERT INTO `area_mapping` VALUES (174, '河北省', '130000', '承德市', '130800', '隆化县', '130825');
INSERT INTO `area_mapping` VALUES (175, '河北省', '130000', '承德市', '130800', '丰宁满族自治县', '130826');
INSERT INTO `area_mapping` VALUES (176, '河北省', '130000', '承德市', '130800', '宽城满族自治县', '130827');
INSERT INTO `area_mapping` VALUES (177, '河北省', '130000', '承德市', '130800', '围场满族蒙古族自治县', '130828');
INSERT INTO `area_mapping` VALUES (178, '河北省', '130000', '承德市', '130800', '承德高新技术产业开发区', '130871');
INSERT INTO `area_mapping` VALUES (179, '河北省', '130000', '承德市', '130800', '平泉市', '130881');
INSERT INTO `area_mapping` VALUES (180, '河北省', '130000', '沧州市', '130900', '新华区', '130902');
INSERT INTO `area_mapping` VALUES (181, '河北省', '130000', '沧州市', '130900', '运河区', '130903');
INSERT INTO `area_mapping` VALUES (182, '河北省', '130000', '沧州市', '130900', '沧县', '130921');
INSERT INTO `area_mapping` VALUES (183, '河北省', '130000', '沧州市', '130900', '青县', '130922');
INSERT INTO `area_mapping` VALUES (184, '河北省', '130000', '沧州市', '130900', '东光县', '130923');
INSERT INTO `area_mapping` VALUES (185, '河北省', '130000', '沧州市', '130900', '海兴县', '130924');
INSERT INTO `area_mapping` VALUES (186, '河北省', '130000', '沧州市', '130900', '盐山县', '130925');
INSERT INTO `area_mapping` VALUES (187, '河北省', '130000', '沧州市', '130900', '肃宁县', '130926');
INSERT INTO `area_mapping` VALUES (188, '河北省', '130000', '沧州市', '130900', '南皮县', '130927');
INSERT INTO `area_mapping` VALUES (189, '河北省', '130000', '沧州市', '130900', '吴桥县', '130928');
INSERT INTO `area_mapping` VALUES (190, '河北省', '130000', '沧州市', '130900', '献县', '130929');
INSERT INTO `area_mapping` VALUES (191, '河北省', '130000', '沧州市', '130900', '孟村回族自治县', '130930');
INSERT INTO `area_mapping` VALUES (192, '河北省', '130000', '沧州市', '130900', '河北沧州经济开发区', '130971');
INSERT INTO `area_mapping` VALUES (193, '河北省', '130000', '沧州市', '130900', '沧州高新技术产业开发区', '130972');
INSERT INTO `area_mapping` VALUES (194, '河北省', '130000', '沧州市', '130900', '沧州渤海新区', '130973');
INSERT INTO `area_mapping` VALUES (195, '河北省', '130000', '沧州市', '130900', '泊头市', '130981');
INSERT INTO `area_mapping` VALUES (196, '河北省', '130000', '沧州市', '130900', '任丘市', '130982');
INSERT INTO `area_mapping` VALUES (197, '河北省', '130000', '沧州市', '130900', '黄骅市', '130983');
INSERT INTO `area_mapping` VALUES (198, '河北省', '130000', '沧州市', '130900', '河间市', '130984');
INSERT INTO `area_mapping` VALUES (199, '河北省', '130000', '廊坊市', '131000', '安次区', '131002');
INSERT INTO `area_mapping` VALUES (200, '河北省', '130000', '廊坊市', '131000', '广阳区', '131003');
INSERT INTO `area_mapping` VALUES (201, '河北省', '130000', '廊坊市', '131000', '固安县', '131022');
INSERT INTO `area_mapping` VALUES (202, '河北省', '130000', '廊坊市', '131000', '永清县', '131023');
INSERT INTO `area_mapping` VALUES (203, '河北省', '130000', '廊坊市', '131000', '香河县', '131024');
INSERT INTO `area_mapping` VALUES (204, '河北省', '130000', '廊坊市', '131000', '大城县', '131025');
INSERT INTO `area_mapping` VALUES (205, '河北省', '130000', '廊坊市', '131000', '文安县', '131026');
INSERT INTO `area_mapping` VALUES (206, '河北省', '130000', '廊坊市', '131000', '大厂回族自治县', '131028');
INSERT INTO `area_mapping` VALUES (207, '河北省', '130000', '廊坊市', '131000', '廊坊经济技术开发区', '131071');
INSERT INTO `area_mapping` VALUES (208, '河北省', '130000', '廊坊市', '131000', '霸州市', '131081');
INSERT INTO `area_mapping` VALUES (209, '河北省', '130000', '廊坊市', '131000', '三河市', '131082');
INSERT INTO `area_mapping` VALUES (210, '河北省', '130000', '衡水市', '131100', '桃城区', '131102');
INSERT INTO `area_mapping` VALUES (211, '河北省', '130000', '衡水市', '131100', '冀州区', '131103');
INSERT INTO `area_mapping` VALUES (212, '河北省', '130000', '衡水市', '131100', '枣强县', '131121');
INSERT INTO `area_mapping` VALUES (213, '河北省', '130000', '衡水市', '131100', '武邑县', '131122');
INSERT INTO `area_mapping` VALUES (214, '河北省', '130000', '衡水市', '131100', '武强县', '131123');
INSERT INTO `area_mapping` VALUES (215, '河北省', '130000', '衡水市', '131100', '饶阳县', '131124');
INSERT INTO `area_mapping` VALUES (216, '河北省', '130000', '衡水市', '131100', '安平县', '131125');
INSERT INTO `area_mapping` VALUES (217, '河北省', '130000', '衡水市', '131100', '故城县', '131126');
INSERT INTO `area_mapping` VALUES (218, '河北省', '130000', '衡水市', '131100', '景县', '131127');
INSERT INTO `area_mapping` VALUES (219, '河北省', '130000', '衡水市', '131100', '阜城县', '131128');
INSERT INTO `area_mapping` VALUES (220, '河北省', '130000', '衡水市', '131100', '河北衡水高新技术产业开发区', '131171');
INSERT INTO `area_mapping` VALUES (221, '河北省', '130000', '衡水市', '131100', '衡水滨湖新区', '131172');
INSERT INTO `area_mapping` VALUES (222, '河北省', '130000', '衡水市', '131100', '深州市', '131182');
INSERT INTO `area_mapping` VALUES (223, '山西省', '140000', '太原市', '140100', '小店区', '140105');
INSERT INTO `area_mapping` VALUES (224, '山西省', '140000', '太原市', '140100', '迎泽区', '140106');
INSERT INTO `area_mapping` VALUES (225, '山西省', '140000', '太原市', '140100', '杏花岭区', '140107');
INSERT INTO `area_mapping` VALUES (226, '山西省', '140000', '太原市', '140100', '尖草坪区', '140108');
INSERT INTO `area_mapping` VALUES (227, '山西省', '140000', '太原市', '140100', '万柏林区', '140109');
INSERT INTO `area_mapping` VALUES (228, '山西省', '140000', '太原市', '140100', '晋源区', '140110');
INSERT INTO `area_mapping` VALUES (229, '山西省', '140000', '太原市', '140100', '清徐县', '140121');
INSERT INTO `area_mapping` VALUES (230, '山西省', '140000', '太原市', '140100', '阳曲县', '140122');
INSERT INTO `area_mapping` VALUES (231, '山西省', '140000', '太原市', '140100', '娄烦县', '140123');
INSERT INTO `area_mapping` VALUES (232, '山西省', '140000', '太原市', '140100', '山西转型综合改革示范区', '140171');
INSERT INTO `area_mapping` VALUES (233, '山西省', '140000', '太原市', '140100', '古交市', '140181');
INSERT INTO `area_mapping` VALUES (234, '山西省', '140000', '大同市', '140200', '新荣区', '140212');
INSERT INTO `area_mapping` VALUES (235, '山西省', '140000', '大同市', '140200', '平城区', '140213');
INSERT INTO `area_mapping` VALUES (236, '山西省', '140000', '大同市', '140200', '云冈区', '140214');
INSERT INTO `area_mapping` VALUES (237, '山西省', '140000', '大同市', '140200', '云州区', '140215');
INSERT INTO `area_mapping` VALUES (238, '山西省', '140000', '大同市', '140200', '阳高县', '140221');
INSERT INTO `area_mapping` VALUES (239, '山西省', '140000', '大同市', '140200', '天镇县', '140222');
INSERT INTO `area_mapping` VALUES (240, '山西省', '140000', '大同市', '140200', '广灵县', '140223');
INSERT INTO `area_mapping` VALUES (241, '山西省', '140000', '大同市', '140200', '灵丘县', '140224');
INSERT INTO `area_mapping` VALUES (242, '山西省', '140000', '大同市', '140200', '浑源县', '140225');
INSERT INTO `area_mapping` VALUES (243, '山西省', '140000', '大同市', '140200', '左云县', '140226');
INSERT INTO `area_mapping` VALUES (244, '山西省', '140000', '大同市', '140200', '山西大同经济开发区', '140271');
INSERT INTO `area_mapping` VALUES (245, '山西省', '140000', '阳泉市', '140300', '城区', '140302');
INSERT INTO `area_mapping` VALUES (246, '山西省', '140000', '阳泉市', '140300', '矿区', '140303');
INSERT INTO `area_mapping` VALUES (247, '山西省', '140000', '阳泉市', '140300', '郊区', '140311');
INSERT INTO `area_mapping` VALUES (248, '山西省', '140000', '阳泉市', '140300', '平定县', '140321');
INSERT INTO `area_mapping` VALUES (249, '山西省', '140000', '阳泉市', '140300', '盂县', '140322');
INSERT INTO `area_mapping` VALUES (250, '山西省', '140000', '长治市', '140400', '潞州区', '140403');
INSERT INTO `area_mapping` VALUES (251, '山西省', '140000', '长治市', '140400', '上党区', '140404');
INSERT INTO `area_mapping` VALUES (252, '山西省', '140000', '长治市', '140400', '屯留区', '140405');
INSERT INTO `area_mapping` VALUES (253, '山西省', '140000', '长治市', '140400', '潞城区', '140406');
INSERT INTO `area_mapping` VALUES (254, '山西省', '140000', '长治市', '140400', '襄垣县', '140423');
INSERT INTO `area_mapping` VALUES (255, '山西省', '140000', '长治市', '140400', '平顺县', '140425');
INSERT INTO `area_mapping` VALUES (256, '山西省', '140000', '长治市', '140400', '黎城县', '140426');
INSERT INTO `area_mapping` VALUES (257, '山西省', '140000', '长治市', '140400', '壶关县', '140427');
INSERT INTO `area_mapping` VALUES (258, '山西省', '140000', '长治市', '140400', '长子县', '140428');
INSERT INTO `area_mapping` VALUES (259, '山西省', '140000', '长治市', '140400', '武乡县', '140429');
INSERT INTO `area_mapping` VALUES (260, '山西省', '140000', '长治市', '140400', '沁县', '140430');
INSERT INTO `area_mapping` VALUES (261, '山西省', '140000', '长治市', '140400', '沁源县', '140431');
INSERT INTO `area_mapping` VALUES (262, '山西省', '140000', '长治市', '140400', '山西长治高新技术产业园区', '140471');
INSERT INTO `area_mapping` VALUES (263, '山西省', '140000', '晋城市', '140500', '城区', '140502');
INSERT INTO `area_mapping` VALUES (264, '山西省', '140000', '晋城市', '140500', '沁水县', '140521');
INSERT INTO `area_mapping` VALUES (265, '山西省', '140000', '晋城市', '140500', '阳城县', '140522');
INSERT INTO `area_mapping` VALUES (266, '山西省', '140000', '晋城市', '140500', '陵川县', '140524');
INSERT INTO `area_mapping` VALUES (267, '山西省', '140000', '晋城市', '140500', '泽州县', '140525');
INSERT INTO `area_mapping` VALUES (268, '山西省', '140000', '晋城市', '140500', '高平市', '140581');
INSERT INTO `area_mapping` VALUES (269, '山西省', '140000', '朔州市', '140600', '朔城区', '140602');
INSERT INTO `area_mapping` VALUES (270, '山西省', '140000', '朔州市', '140600', '平鲁区', '140603');
INSERT INTO `area_mapping` VALUES (271, '山西省', '140000', '朔州市', '140600', '山阴县', '140621');
INSERT INTO `area_mapping` VALUES (272, '山西省', '140000', '朔州市', '140600', '应县', '140622');
INSERT INTO `area_mapping` VALUES (273, '山西省', '140000', '朔州市', '140600', '右玉县', '140623');
INSERT INTO `area_mapping` VALUES (274, '山西省', '140000', '朔州市', '140600', '山西朔州经济开发区', '140671');
INSERT INTO `area_mapping` VALUES (275, '山西省', '140000', '朔州市', '140600', '怀仁市', '140681');
INSERT INTO `area_mapping` VALUES (276, '山西省', '140000', '晋中市', '140700', '榆次区', '140702');
INSERT INTO `area_mapping` VALUES (277, '山西省', '140000', '晋中市', '140700', '太谷区', '140703');
INSERT INTO `area_mapping` VALUES (278, '山西省', '140000', '晋中市', '140700', '榆社县', '140721');
INSERT INTO `area_mapping` VALUES (279, '山西省', '140000', '晋中市', '140700', '左权县', '140722');
INSERT INTO `area_mapping` VALUES (280, '山西省', '140000', '晋中市', '140700', '和顺县', '140723');
INSERT INTO `area_mapping` VALUES (281, '山西省', '140000', '晋中市', '140700', '昔阳县', '140724');
INSERT INTO `area_mapping` VALUES (282, '山西省', '140000', '晋中市', '140700', '寿阳县', '140725');
INSERT INTO `area_mapping` VALUES (283, '山西省', '140000', '晋中市', '140700', '祁县', '140727');
INSERT INTO `area_mapping` VALUES (284, '山西省', '140000', '晋中市', '140700', '平遥县', '140728');
INSERT INTO `area_mapping` VALUES (285, '山西省', '140000', '晋中市', '140700', '灵石县', '140729');
INSERT INTO `area_mapping` VALUES (286, '山西省', '140000', '晋中市', '140700', '介休市', '140781');
INSERT INTO `area_mapping` VALUES (287, '山西省', '140000', '运城市', '140800', '盐湖区', '140802');
INSERT INTO `area_mapping` VALUES (288, '山西省', '140000', '运城市', '140800', '临猗县', '140821');
INSERT INTO `area_mapping` VALUES (289, '山西省', '140000', '运城市', '140800', '万荣县', '140822');
INSERT INTO `area_mapping` VALUES (290, '山西省', '140000', '运城市', '140800', '闻喜县', '140823');
INSERT INTO `area_mapping` VALUES (291, '山西省', '140000', '运城市', '140800', '稷山县', '140824');
INSERT INTO `area_mapping` VALUES (292, '山西省', '140000', '运城市', '140800', '新绛县', '140825');
INSERT INTO `area_mapping` VALUES (293, '山西省', '140000', '运城市', '140800', '绛县', '140826');
INSERT INTO `area_mapping` VALUES (294, '山西省', '140000', '运城市', '140800', '垣曲县', '140827');
INSERT INTO `area_mapping` VALUES (295, '山西省', '140000', '运城市', '140800', '夏县', '140828');
INSERT INTO `area_mapping` VALUES (296, '山西省', '140000', '运城市', '140800', '平陆县', '140829');
INSERT INTO `area_mapping` VALUES (297, '山西省', '140000', '运城市', '140800', '芮城县', '140830');
INSERT INTO `area_mapping` VALUES (298, '山西省', '140000', '运城市', '140800', '永济市', '140881');
INSERT INTO `area_mapping` VALUES (299, '山西省', '140000', '运城市', '140800', '河津市', '140882');
INSERT INTO `area_mapping` VALUES (300, '山西省', '140000', '忻州市', '140900', '忻府区', '140902');
INSERT INTO `area_mapping` VALUES (301, '山西省', '140000', '忻州市', '140900', '定襄县', '140921');
INSERT INTO `area_mapping` VALUES (302, '山西省', '140000', '忻州市', '140900', '五台县', '140922');
INSERT INTO `area_mapping` VALUES (303, '山西省', '140000', '忻州市', '140900', '代县', '140923');
INSERT INTO `area_mapping` VALUES (304, '山西省', '140000', '忻州市', '140900', '繁峙县', '140924');
INSERT INTO `area_mapping` VALUES (305, '山西省', '140000', '忻州市', '140900', '宁武县', '140925');
INSERT INTO `area_mapping` VALUES (306, '山西省', '140000', '忻州市', '140900', '静乐县', '140926');
INSERT INTO `area_mapping` VALUES (307, '山西省', '140000', '忻州市', '140900', '神池县', '140927');
INSERT INTO `area_mapping` VALUES (308, '山西省', '140000', '忻州市', '140900', '五寨县', '140928');
INSERT INTO `area_mapping` VALUES (309, '山西省', '140000', '忻州市', '140900', '岢岚县', '140929');
INSERT INTO `area_mapping` VALUES (310, '山西省', '140000', '忻州市', '140900', '河曲县', '140930');
INSERT INTO `area_mapping` VALUES (311, '山西省', '140000', '忻州市', '140900', '保德县', '140931');
INSERT INTO `area_mapping` VALUES (312, '山西省', '140000', '忻州市', '140900', '偏关县', '140932');
INSERT INTO `area_mapping` VALUES (313, '山西省', '140000', '忻州市', '140900', '五台山风景名胜区', '140971');
INSERT INTO `area_mapping` VALUES (314, '山西省', '140000', '忻州市', '140900', '原平市', '140981');
INSERT INTO `area_mapping` VALUES (315, '山西省', '140000', '临汾市', '141000', '尧都区', '141002');
INSERT INTO `area_mapping` VALUES (316, '山西省', '140000', '临汾市', '141000', '曲沃县', '141021');
INSERT INTO `area_mapping` VALUES (317, '山西省', '140000', '临汾市', '141000', '翼城县', '141022');
INSERT INTO `area_mapping` VALUES (318, '山西省', '140000', '临汾市', '141000', '襄汾县', '141023');
INSERT INTO `area_mapping` VALUES (319, '山西省', '140000', '临汾市', '141000', '洪洞县', '141024');
INSERT INTO `area_mapping` VALUES (320, '山西省', '140000', '临汾市', '141000', '古县', '141025');
INSERT INTO `area_mapping` VALUES (321, '山西省', '140000', '临汾市', '141000', '安泽县', '141026');
INSERT INTO `area_mapping` VALUES (322, '山西省', '140000', '临汾市', '141000', '浮山县', '141027');
INSERT INTO `area_mapping` VALUES (323, '山西省', '140000', '临汾市', '141000', '吉县', '141028');
INSERT INTO `area_mapping` VALUES (324, '山西省', '140000', '临汾市', '141000', '乡宁县', '141029');
INSERT INTO `area_mapping` VALUES (325, '山西省', '140000', '临汾市', '141000', '大宁县', '141030');
INSERT INTO `area_mapping` VALUES (326, '山西省', '140000', '临汾市', '141000', '隰县', '141031');
INSERT INTO `area_mapping` VALUES (327, '山西省', '140000', '临汾市', '141000', '永和县', '141032');
INSERT INTO `area_mapping` VALUES (328, '山西省', '140000', '临汾市', '141000', '蒲县', '141033');
INSERT INTO `area_mapping` VALUES (329, '山西省', '140000', '临汾市', '141000', '汾西县', '141034');
INSERT INTO `area_mapping` VALUES (330, '山西省', '140000', '临汾市', '141000', '侯马市', '141081');
INSERT INTO `area_mapping` VALUES (331, '山西省', '140000', '临汾市', '141000', '霍州市', '141082');
INSERT INTO `area_mapping` VALUES (332, '山西省', '140000', '吕梁市', '141100', '离石区', '141102');
INSERT INTO `area_mapping` VALUES (333, '山西省', '140000', '吕梁市', '141100', '文水县', '141121');
INSERT INTO `area_mapping` VALUES (334, '山西省', '140000', '吕梁市', '141100', '交城县', '141122');
INSERT INTO `area_mapping` VALUES (335, '山西省', '140000', '吕梁市', '141100', '兴县', '141123');
INSERT INTO `area_mapping` VALUES (336, '山西省', '140000', '吕梁市', '141100', '临县', '141124');
INSERT INTO `area_mapping` VALUES (337, '山西省', '140000', '吕梁市', '141100', '柳林县', '141125');
INSERT INTO `area_mapping` VALUES (338, '山西省', '140000', '吕梁市', '141100', '石楼县', '141126');
INSERT INTO `area_mapping` VALUES (339, '山西省', '140000', '吕梁市', '141100', '岚县', '141127');
INSERT INTO `area_mapping` VALUES (340, '山西省', '140000', '吕梁市', '141100', '方山县', '141128');
INSERT INTO `area_mapping` VALUES (341, '山西省', '140000', '吕梁市', '141100', '中阳县', '141129');
INSERT INTO `area_mapping` VALUES (342, '山西省', '140000', '吕梁市', '141100', '交口县', '141130');
INSERT INTO `area_mapping` VALUES (343, '山西省', '140000', '吕梁市', '141100', '孝义市', '141181');
INSERT INTO `area_mapping` VALUES (344, '山西省', '140000', '吕梁市', '141100', '汾阳市', '141182');
INSERT INTO `area_mapping` VALUES (345, '内蒙古自治区', '150000', '呼和浩特市', '150100', '新城区', '150102');
INSERT INTO `area_mapping` VALUES (346, '内蒙古自治区', '150000', '呼和浩特市', '150100', '回民区', '150103');
INSERT INTO `area_mapping` VALUES (347, '内蒙古自治区', '150000', '呼和浩特市', '150100', '玉泉区', '150104');
INSERT INTO `area_mapping` VALUES (348, '内蒙古自治区', '150000', '呼和浩特市', '150100', '赛罕区', '150105');
INSERT INTO `area_mapping` VALUES (349, '内蒙古自治区', '150000', '呼和浩特市', '150100', '土默特左旗', '150121');
INSERT INTO `area_mapping` VALUES (350, '内蒙古自治区', '150000', '呼和浩特市', '150100', '托克托县', '150122');
INSERT INTO `area_mapping` VALUES (351, '内蒙古自治区', '150000', '呼和浩特市', '150100', '和林格尔县', '150123');
INSERT INTO `area_mapping` VALUES (352, '内蒙古自治区', '150000', '呼和浩特市', '150100', '清水河县', '150124');
INSERT INTO `area_mapping` VALUES (353, '内蒙古自治区', '150000', '呼和浩特市', '150100', '武川县', '150125');
INSERT INTO `area_mapping` VALUES (354, '内蒙古自治区', '150000', '呼和浩特市', '150100', '呼和浩特经济技术开发区', '150172');
INSERT INTO `area_mapping` VALUES (355, '内蒙古自治区', '150000', '包头市', '150200', '东河区', '150202');
INSERT INTO `area_mapping` VALUES (356, '内蒙古自治区', '150000', '包头市', '150200', '昆都仑区', '150203');
INSERT INTO `area_mapping` VALUES (357, '内蒙古自治区', '150000', '包头市', '150200', '青山区', '150204');
INSERT INTO `area_mapping` VALUES (358, '内蒙古自治区', '150000', '包头市', '150200', '石拐区', '150205');
INSERT INTO `area_mapping` VALUES (359, '内蒙古自治区', '150000', '包头市', '150200', '白云鄂博矿区', '150206');
INSERT INTO `area_mapping` VALUES (360, '内蒙古自治区', '150000', '包头市', '150200', '九原区', '150207');
INSERT INTO `area_mapping` VALUES (361, '内蒙古自治区', '150000', '包头市', '150200', '土默特右旗', '150221');
INSERT INTO `area_mapping` VALUES (362, '内蒙古自治区', '150000', '包头市', '150200', '固阳县', '150222');
INSERT INTO `area_mapping` VALUES (363, '内蒙古自治区', '150000', '包头市', '150200', '达尔罕茂明安联合旗', '150223');
INSERT INTO `area_mapping` VALUES (364, '内蒙古自治区', '150000', '包头市', '150200', '包头稀土高新技术产业开发区', '150271');
INSERT INTO `area_mapping` VALUES (365, '内蒙古自治区', '150000', '乌海市', '150300', '海勃湾区', '150302');
INSERT INTO `area_mapping` VALUES (366, '内蒙古自治区', '150000', '乌海市', '150300', '海南区', '150303');
INSERT INTO `area_mapping` VALUES (367, '内蒙古自治区', '150000', '乌海市', '150300', '乌达区', '150304');
INSERT INTO `area_mapping` VALUES (368, '内蒙古自治区', '150000', '赤峰市', '150400', '红山区', '150402');
INSERT INTO `area_mapping` VALUES (369, '内蒙古自治区', '150000', '赤峰市', '150400', '元宝山区', '150403');
INSERT INTO `area_mapping` VALUES (370, '内蒙古自治区', '150000', '赤峰市', '150400', '松山区', '150404');
INSERT INTO `area_mapping` VALUES (371, '内蒙古自治区', '150000', '赤峰市', '150400', '阿鲁科尔沁旗', '150421');
INSERT INTO `area_mapping` VALUES (372, '内蒙古自治区', '150000', '赤峰市', '150400', '巴林左旗', '150422');
INSERT INTO `area_mapping` VALUES (373, '内蒙古自治区', '150000', '赤峰市', '150400', '巴林右旗', '150423');
INSERT INTO `area_mapping` VALUES (374, '内蒙古自治区', '150000', '赤峰市', '150400', '林西县', '150424');
INSERT INTO `area_mapping` VALUES (375, '内蒙古自治区', '150000', '赤峰市', '150400', '克什克腾旗', '150425');
INSERT INTO `area_mapping` VALUES (376, '内蒙古自治区', '150000', '赤峰市', '150400', '翁牛特旗', '150426');
INSERT INTO `area_mapping` VALUES (377, '内蒙古自治区', '150000', '赤峰市', '150400', '喀喇沁旗', '150428');
INSERT INTO `area_mapping` VALUES (378, '内蒙古自治区', '150000', '赤峰市', '150400', '宁城县', '150429');
INSERT INTO `area_mapping` VALUES (379, '内蒙古自治区', '150000', '赤峰市', '150400', '敖汉旗', '150430');
INSERT INTO `area_mapping` VALUES (380, '内蒙古自治区', '150000', '通辽市', '150500', '科尔沁区', '150502');
INSERT INTO `area_mapping` VALUES (381, '内蒙古自治区', '150000', '通辽市', '150500', '科尔沁左翼中旗', '150521');
INSERT INTO `area_mapping` VALUES (382, '内蒙古自治区', '150000', '通辽市', '150500', '科尔沁左翼后旗', '150522');
INSERT INTO `area_mapping` VALUES (383, '内蒙古自治区', '150000', '通辽市', '150500', '开鲁县', '150523');
INSERT INTO `area_mapping` VALUES (384, '内蒙古自治区', '150000', '通辽市', '150500', '库伦旗', '150524');
INSERT INTO `area_mapping` VALUES (385, '内蒙古自治区', '150000', '通辽市', '150500', '奈曼旗', '150525');
INSERT INTO `area_mapping` VALUES (386, '内蒙古自治区', '150000', '通辽市', '150500', '扎鲁特旗', '150526');
INSERT INTO `area_mapping` VALUES (387, '内蒙古自治区', '150000', '通辽市', '150500', '通辽经济技术开发区', '150571');
INSERT INTO `area_mapping` VALUES (388, '内蒙古自治区', '150000', '通辽市', '150500', '霍林郭勒市', '150581');
INSERT INTO `area_mapping` VALUES (389, '内蒙古自治区', '150000', '鄂尔多斯市', '150600', '东胜区', '150602');
INSERT INTO `area_mapping` VALUES (390, '内蒙古自治区', '150000', '鄂尔多斯市', '150600', '康巴什区', '150603');
INSERT INTO `area_mapping` VALUES (391, '内蒙古自治区', '150000', '鄂尔多斯市', '150600', '达拉特旗', '150621');
INSERT INTO `area_mapping` VALUES (392, '内蒙古自治区', '150000', '鄂尔多斯市', '150600', '准格尔旗', '150622');
INSERT INTO `area_mapping` VALUES (393, '内蒙古自治区', '150000', '鄂尔多斯市', '150600', '鄂托克前旗', '150623');
INSERT INTO `area_mapping` VALUES (394, '内蒙古自治区', '150000', '鄂尔多斯市', '150600', '鄂托克旗', '150624');
INSERT INTO `area_mapping` VALUES (395, '内蒙古自治区', '150000', '鄂尔多斯市', '150600', '杭锦旗', '150625');
INSERT INTO `area_mapping` VALUES (396, '内蒙古自治区', '150000', '鄂尔多斯市', '150600', '乌审旗', '150626');
INSERT INTO `area_mapping` VALUES (397, '内蒙古自治区', '150000', '鄂尔多斯市', '150600', '伊金霍洛旗', '150627');
INSERT INTO `area_mapping` VALUES (398, '内蒙古自治区', '150000', '呼伦贝尔市', '150700', '海拉尔区', '150702');
INSERT INTO `area_mapping` VALUES (399, '内蒙古自治区', '150000', '呼伦贝尔市', '150700', '扎赉诺尔区', '150703');
INSERT INTO `area_mapping` VALUES (400, '内蒙古自治区', '150000', '呼伦贝尔市', '150700', '阿荣旗', '150721');
INSERT INTO `area_mapping` VALUES (401, '内蒙古自治区', '150000', '呼伦贝尔市', '150700', '莫力达瓦达斡尔族自治旗', '150722');
INSERT INTO `area_mapping` VALUES (402, '内蒙古自治区', '150000', '呼伦贝尔市', '150700', '鄂伦春自治旗', '150723');
INSERT INTO `area_mapping` VALUES (403, '内蒙古自治区', '150000', '呼伦贝尔市', '150700', '鄂温克族自治旗', '150724');
INSERT INTO `area_mapping` VALUES (404, '内蒙古自治区', '150000', '呼伦贝尔市', '150700', '陈巴尔虎旗', '150725');
INSERT INTO `area_mapping` VALUES (405, '内蒙古自治区', '150000', '呼伦贝尔市', '150700', '新巴尔虎左旗', '150726');
INSERT INTO `area_mapping` VALUES (406, '内蒙古自治区', '150000', '呼伦贝尔市', '150700', '新巴尔虎右旗', '150727');
INSERT INTO `area_mapping` VALUES (407, '内蒙古自治区', '150000', '呼伦贝尔市', '150700', '满洲里市', '150781');
INSERT INTO `area_mapping` VALUES (408, '内蒙古自治区', '150000', '呼伦贝尔市', '150700', '牙克石市', '150782');
INSERT INTO `area_mapping` VALUES (409, '内蒙古自治区', '150000', '呼伦贝尔市', '150700', '扎兰屯市', '150783');
INSERT INTO `area_mapping` VALUES (410, '内蒙古自治区', '150000', '呼伦贝尔市', '150700', '额尔古纳市', '150784');
INSERT INTO `area_mapping` VALUES (411, '内蒙古自治区', '150000', '呼伦贝尔市', '150700', '根河市', '150785');
INSERT INTO `area_mapping` VALUES (412, '内蒙古自治区', '150000', '巴彦淖尔市', '150800', '临河区', '150802');
INSERT INTO `area_mapping` VALUES (413, '内蒙古自治区', '150000', '巴彦淖尔市', '150800', '五原县', '150821');
INSERT INTO `area_mapping` VALUES (414, '内蒙古自治区', '150000', '巴彦淖尔市', '150800', '磴口县', '150822');
INSERT INTO `area_mapping` VALUES (415, '内蒙古自治区', '150000', '巴彦淖尔市', '150800', '乌拉特前旗', '150823');
INSERT INTO `area_mapping` VALUES (416, '内蒙古自治区', '150000', '巴彦淖尔市', '150800', '乌拉特中旗', '150824');
INSERT INTO `area_mapping` VALUES (417, '内蒙古自治区', '150000', '巴彦淖尔市', '150800', '乌拉特后旗', '150825');
INSERT INTO `area_mapping` VALUES (418, '内蒙古自治区', '150000', '巴彦淖尔市', '150800', '杭锦后旗', '150826');
INSERT INTO `area_mapping` VALUES (419, '内蒙古自治区', '150000', '乌兰察布市', '150900', '集宁区', '150902');
INSERT INTO `area_mapping` VALUES (420, '内蒙古自治区', '150000', '乌兰察布市', '150900', '卓资县', '150921');
INSERT INTO `area_mapping` VALUES (421, '内蒙古自治区', '150000', '乌兰察布市', '150900', '化德县', '150922');
INSERT INTO `area_mapping` VALUES (422, '内蒙古自治区', '150000', '乌兰察布市', '150900', '商都县', '150923');
INSERT INTO `area_mapping` VALUES (423, '内蒙古自治区', '150000', '乌兰察布市', '150900', '兴和县', '150924');
INSERT INTO `area_mapping` VALUES (424, '内蒙古自治区', '150000', '乌兰察布市', '150900', '凉城县', '150925');
INSERT INTO `area_mapping` VALUES (425, '内蒙古自治区', '150000', '乌兰察布市', '150900', '察哈尔右翼前旗', '150926');
INSERT INTO `area_mapping` VALUES (426, '内蒙古自治区', '150000', '乌兰察布市', '150900', '察哈尔右翼中旗', '150927');
INSERT INTO `area_mapping` VALUES (427, '内蒙古自治区', '150000', '乌兰察布市', '150900', '察哈尔右翼后旗', '150928');
INSERT INTO `area_mapping` VALUES (428, '内蒙古自治区', '150000', '乌兰察布市', '150900', '四子王旗', '150929');
INSERT INTO `area_mapping` VALUES (429, '内蒙古自治区', '150000', '乌兰察布市', '150900', '丰镇市', '150981');
INSERT INTO `area_mapping` VALUES (430, '内蒙古自治区', '150000', '兴安盟', '152200', '乌兰浩特市', '152201');
INSERT INTO `area_mapping` VALUES (431, '内蒙古自治区', '150000', '兴安盟', '152200', '阿尔山市', '152202');
INSERT INTO `area_mapping` VALUES (432, '内蒙古自治区', '150000', '兴安盟', '152200', '科尔沁右翼前旗', '152221');
INSERT INTO `area_mapping` VALUES (433, '内蒙古自治区', '150000', '兴安盟', '152200', '科尔沁右翼中旗', '152222');
INSERT INTO `area_mapping` VALUES (434, '内蒙古自治区', '150000', '兴安盟', '152200', '扎赉特旗', '152223');
INSERT INTO `area_mapping` VALUES (435, '内蒙古自治区', '150000', '兴安盟', '152200', '突泉县', '152224');
INSERT INTO `area_mapping` VALUES (436, '内蒙古自治区', '150000', '锡林郭勒盟', '152500', '二连浩特市', '152501');
INSERT INTO `area_mapping` VALUES (437, '内蒙古自治区', '150000', '锡林郭勒盟', '152500', '锡林浩特市', '152502');
INSERT INTO `area_mapping` VALUES (438, '内蒙古自治区', '150000', '锡林郭勒盟', '152500', '阿巴嘎旗', '152522');
INSERT INTO `area_mapping` VALUES (439, '内蒙古自治区', '150000', '锡林郭勒盟', '152500', '苏尼特左旗', '152523');
INSERT INTO `area_mapping` VALUES (440, '内蒙古自治区', '150000', '锡林郭勒盟', '152500', '苏尼特右旗', '152524');
INSERT INTO `area_mapping` VALUES (441, '内蒙古自治区', '150000', '锡林郭勒盟', '152500', '东乌珠穆沁旗', '152525');
INSERT INTO `area_mapping` VALUES (442, '内蒙古自治区', '150000', '锡林郭勒盟', '152500', '西乌珠穆沁旗', '152526');
INSERT INTO `area_mapping` VALUES (443, '内蒙古自治区', '150000', '锡林郭勒盟', '152500', '太仆寺旗', '152527');
INSERT INTO `area_mapping` VALUES (444, '内蒙古自治区', '150000', '锡林郭勒盟', '152500', '镶黄旗', '152528');
INSERT INTO `area_mapping` VALUES (445, '内蒙古自治区', '150000', '锡林郭勒盟', '152500', '正镶白旗', '152529');
INSERT INTO `area_mapping` VALUES (446, '内蒙古自治区', '150000', '锡林郭勒盟', '152500', '正蓝旗', '152530');
INSERT INTO `area_mapping` VALUES (447, '内蒙古自治区', '150000', '锡林郭勒盟', '152500', '多伦县', '152531');
INSERT INTO `area_mapping` VALUES (448, '内蒙古自治区', '150000', '锡林郭勒盟', '152500', '乌拉盖管委会', '152571');
INSERT INTO `area_mapping` VALUES (449, '内蒙古自治区', '150000', '阿拉善盟', '152900', '阿拉善左旗', '152921');
INSERT INTO `area_mapping` VALUES (450, '内蒙古自治区', '150000', '阿拉善盟', '152900', '阿拉善右旗', '152922');
INSERT INTO `area_mapping` VALUES (451, '内蒙古自治区', '150000', '阿拉善盟', '152900', '额济纳旗', '152923');
INSERT INTO `area_mapping` VALUES (452, '内蒙古自治区', '150000', '阿拉善盟', '152900', '内蒙古阿拉善经济开发区', '152971');
INSERT INTO `area_mapping` VALUES (453, '辽宁省', '210000', '沈阳市', '210100', '和平区', '210102');
INSERT INTO `area_mapping` VALUES (454, '辽宁省', '210000', '沈阳市', '210100', '沈河区', '210103');
INSERT INTO `area_mapping` VALUES (455, '辽宁省', '210000', '沈阳市', '210100', '大东区', '210104');
INSERT INTO `area_mapping` VALUES (456, '辽宁省', '210000', '沈阳市', '210100', '皇姑区', '210105');
INSERT INTO `area_mapping` VALUES (457, '辽宁省', '210000', '沈阳市', '210100', '铁西区', '210106');
INSERT INTO `area_mapping` VALUES (458, '辽宁省', '210000', '沈阳市', '210100', '苏家屯区', '210111');
INSERT INTO `area_mapping` VALUES (459, '辽宁省', '210000', '沈阳市', '210100', '浑南区', '210112');
INSERT INTO `area_mapping` VALUES (460, '辽宁省', '210000', '沈阳市', '210100', '沈北新区', '210113');
INSERT INTO `area_mapping` VALUES (461, '辽宁省', '210000', '沈阳市', '210100', '于洪区', '210114');
INSERT INTO `area_mapping` VALUES (462, '辽宁省', '210000', '沈阳市', '210100', '辽中区', '210115');
INSERT INTO `area_mapping` VALUES (463, '辽宁省', '210000', '沈阳市', '210100', '康平县', '210123');
INSERT INTO `area_mapping` VALUES (464, '辽宁省', '210000', '沈阳市', '210100', '法库县', '210124');
INSERT INTO `area_mapping` VALUES (465, '辽宁省', '210000', '沈阳市', '210100', '新民市', '210181');
INSERT INTO `area_mapping` VALUES (466, '辽宁省', '210000', '大连市', '210200', '中山区', '210202');
INSERT INTO `area_mapping` VALUES (467, '辽宁省', '210000', '大连市', '210200', '西岗区', '210203');
INSERT INTO `area_mapping` VALUES (468, '辽宁省', '210000', '大连市', '210200', '沙河口区', '210204');
INSERT INTO `area_mapping` VALUES (469, '辽宁省', '210000', '大连市', '210200', '甘井子区', '210211');
INSERT INTO `area_mapping` VALUES (470, '辽宁省', '210000', '大连市', '210200', '旅顺口区', '210212');
INSERT INTO `area_mapping` VALUES (471, '辽宁省', '210000', '大连市', '210200', '金州区', '210213');
INSERT INTO `area_mapping` VALUES (472, '辽宁省', '210000', '大连市', '210200', '普兰店区', '210214');
INSERT INTO `area_mapping` VALUES (473, '辽宁省', '210000', '大连市', '210200', '长海县', '210224');
INSERT INTO `area_mapping` VALUES (474, '辽宁省', '210000', '大连市', '210200', '瓦房店市', '210281');
INSERT INTO `area_mapping` VALUES (475, '辽宁省', '210000', '大连市', '210200', '庄河市', '210283');
INSERT INTO `area_mapping` VALUES (476, '辽宁省', '210000', '鞍山市', '210300', '铁东区', '210302');
INSERT INTO `area_mapping` VALUES (477, '辽宁省', '210000', '鞍山市', '210300', '铁西区', '210303');
INSERT INTO `area_mapping` VALUES (478, '辽宁省', '210000', '鞍山市', '210300', '立山区', '210304');
INSERT INTO `area_mapping` VALUES (479, '辽宁省', '210000', '鞍山市', '210300', '千山区', '210311');
INSERT INTO `area_mapping` VALUES (480, '辽宁省', '210000', '鞍山市', '210300', '台安县', '210321');
INSERT INTO `area_mapping` VALUES (481, '辽宁省', '210000', '鞍山市', '210300', '岫岩满族自治县', '210323');
INSERT INTO `area_mapping` VALUES (482, '辽宁省', '210000', '鞍山市', '210300', '海城市', '210381');
INSERT INTO `area_mapping` VALUES (483, '辽宁省', '210000', '抚顺市', '210400', '新抚区', '210402');
INSERT INTO `area_mapping` VALUES (484, '辽宁省', '210000', '抚顺市', '210400', '东洲区', '210403');
INSERT INTO `area_mapping` VALUES (485, '辽宁省', '210000', '抚顺市', '210400', '望花区', '210404');
INSERT INTO `area_mapping` VALUES (486, '辽宁省', '210000', '抚顺市', '210400', '顺城区', '210411');
INSERT INTO `area_mapping` VALUES (487, '辽宁省', '210000', '抚顺市', '210400', '抚顺县', '210421');
INSERT INTO `area_mapping` VALUES (488, '辽宁省', '210000', '抚顺市', '210400', '新宾满族自治县', '210422');
INSERT INTO `area_mapping` VALUES (489, '辽宁省', '210000', '抚顺市', '210400', '清原满族自治县', '210423');
INSERT INTO `area_mapping` VALUES (490, '辽宁省', '210000', '本溪市', '210500', '平山区', '210502');
INSERT INTO `area_mapping` VALUES (491, '辽宁省', '210000', '本溪市', '210500', '溪湖区', '210503');
INSERT INTO `area_mapping` VALUES (492, '辽宁省', '210000', '本溪市', '210500', '明山区', '210504');
INSERT INTO `area_mapping` VALUES (493, '辽宁省', '210000', '本溪市', '210500', '南芬区', '210505');
INSERT INTO `area_mapping` VALUES (494, '辽宁省', '210000', '本溪市', '210500', '本溪满族自治县', '210521');
INSERT INTO `area_mapping` VALUES (495, '辽宁省', '210000', '本溪市', '210500', '桓仁满族自治县', '210522');
INSERT INTO `area_mapping` VALUES (496, '辽宁省', '210000', '丹东市', '210600', '元宝区', '210602');
INSERT INTO `area_mapping` VALUES (497, '辽宁省', '210000', '丹东市', '210600', '振兴区', '210603');
INSERT INTO `area_mapping` VALUES (498, '辽宁省', '210000', '丹东市', '210600', '振安区', '210604');
INSERT INTO `area_mapping` VALUES (499, '辽宁省', '210000', '丹东市', '210600', '宽甸满族自治县', '210624');
INSERT INTO `area_mapping` VALUES (500, '辽宁省', '210000', '丹东市', '210600', '东港市', '210681');
INSERT INTO `area_mapping` VALUES (501, '辽宁省', '210000', '丹东市', '210600', '凤城市', '210682');
INSERT INTO `area_mapping` VALUES (502, '辽宁省', '210000', '锦州市', '210700', '古塔区', '210702');
INSERT INTO `area_mapping` VALUES (503, '辽宁省', '210000', '锦州市', '210700', '凌河区', '210703');
INSERT INTO `area_mapping` VALUES (504, '辽宁省', '210000', '锦州市', '210700', '太和区', '210711');
INSERT INTO `area_mapping` VALUES (505, '辽宁省', '210000', '锦州市', '210700', '黑山县', '210726');
INSERT INTO `area_mapping` VALUES (506, '辽宁省', '210000', '锦州市', '210700', '义县', '210727');
INSERT INTO `area_mapping` VALUES (507, '辽宁省', '210000', '锦州市', '210700', '凌海市', '210781');
INSERT INTO `area_mapping` VALUES (508, '辽宁省', '210000', '锦州市', '210700', '北镇市', '210782');
INSERT INTO `area_mapping` VALUES (509, '辽宁省', '210000', '营口市', '210800', '站前区', '210802');
INSERT INTO `area_mapping` VALUES (510, '辽宁省', '210000', '营口市', '210800', '西市区', '210803');
INSERT INTO `area_mapping` VALUES (511, '辽宁省', '210000', '营口市', '210800', '鲅鱼圈区', '210804');
INSERT INTO `area_mapping` VALUES (512, '辽宁省', '210000', '营口市', '210800', '老边区', '210811');
INSERT INTO `area_mapping` VALUES (513, '辽宁省', '210000', '营口市', '210800', '盖州市', '210881');
INSERT INTO `area_mapping` VALUES (514, '辽宁省', '210000', '营口市', '210800', '大石桥市', '210882');
INSERT INTO `area_mapping` VALUES (515, '辽宁省', '210000', '阜新市', '210900', '海州区', '210902');
INSERT INTO `area_mapping` VALUES (516, '辽宁省', '210000', '阜新市', '210900', '新邱区', '210903');
INSERT INTO `area_mapping` VALUES (517, '辽宁省', '210000', '阜新市', '210900', '太平区', '210904');
INSERT INTO `area_mapping` VALUES (518, '辽宁省', '210000', '阜新市', '210900', '清河门区', '210905');
INSERT INTO `area_mapping` VALUES (519, '辽宁省', '210000', '阜新市', '210900', '细河区', '210911');
INSERT INTO `area_mapping` VALUES (520, '辽宁省', '210000', '阜新市', '210900', '阜新蒙古族自治县', '210921');
INSERT INTO `area_mapping` VALUES (521, '辽宁省', '210000', '阜新市', '210900', '彰武县', '210922');
INSERT INTO `area_mapping` VALUES (522, '辽宁省', '210000', '辽阳市', '211000', '白塔区', '211002');
INSERT INTO `area_mapping` VALUES (523, '辽宁省', '210000', '辽阳市', '211000', '文圣区', '211003');
INSERT INTO `area_mapping` VALUES (524, '辽宁省', '210000', '辽阳市', '211000', '宏伟区', '211004');
INSERT INTO `area_mapping` VALUES (525, '辽宁省', '210000', '辽阳市', '211000', '弓长岭区', '211005');
INSERT INTO `area_mapping` VALUES (526, '辽宁省', '210000', '辽阳市', '211000', '太子河区', '211011');
INSERT INTO `area_mapping` VALUES (527, '辽宁省', '210000', '辽阳市', '211000', '辽阳县', '211021');
INSERT INTO `area_mapping` VALUES (528, '辽宁省', '210000', '辽阳市', '211000', '灯塔市', '211081');
INSERT INTO `area_mapping` VALUES (529, '辽宁省', '210000', '盘锦市', '211100', '双台子区', '211102');
INSERT INTO `area_mapping` VALUES (530, '辽宁省', '210000', '盘锦市', '211100', '兴隆台区', '211103');
INSERT INTO `area_mapping` VALUES (531, '辽宁省', '210000', '盘锦市', '211100', '大洼区', '211104');
INSERT INTO `area_mapping` VALUES (532, '辽宁省', '210000', '盘锦市', '211100', '盘山县', '211122');
INSERT INTO `area_mapping` VALUES (533, '辽宁省', '210000', '铁岭市', '211200', '银州区', '211202');
INSERT INTO `area_mapping` VALUES (534, '辽宁省', '210000', '铁岭市', '211200', '清河区', '211204');
INSERT INTO `area_mapping` VALUES (535, '辽宁省', '210000', '铁岭市', '211200', '铁岭县', '211221');
INSERT INTO `area_mapping` VALUES (536, '辽宁省', '210000', '铁岭市', '211200', '西丰县', '211223');
INSERT INTO `area_mapping` VALUES (537, '辽宁省', '210000', '铁岭市', '211200', '昌图县', '211224');
INSERT INTO `area_mapping` VALUES (538, '辽宁省', '210000', '铁岭市', '211200', '调兵山市', '211281');
INSERT INTO `area_mapping` VALUES (539, '辽宁省', '210000', '铁岭市', '211200', '开原市', '211282');
INSERT INTO `area_mapping` VALUES (540, '辽宁省', '210000', '朝阳市', '211300', '双塔区', '211302');
INSERT INTO `area_mapping` VALUES (541, '辽宁省', '210000', '朝阳市', '211300', '龙城区', '211303');
INSERT INTO `area_mapping` VALUES (542, '辽宁省', '210000', '朝阳市', '211300', '朝阳县', '211321');
INSERT INTO `area_mapping` VALUES (543, '辽宁省', '210000', '朝阳市', '211300', '建平县', '211322');
INSERT INTO `area_mapping` VALUES (544, '辽宁省', '210000', '朝阳市', '211300', '喀喇沁左翼蒙古族自治县', '211324');
INSERT INTO `area_mapping` VALUES (545, '辽宁省', '210000', '朝阳市', '211300', '北票市', '211381');
INSERT INTO `area_mapping` VALUES (546, '辽宁省', '210000', '朝阳市', '211300', '凌源市', '211382');
INSERT INTO `area_mapping` VALUES (547, '辽宁省', '210000', '葫芦岛市', '211400', '连山区', '211402');
INSERT INTO `area_mapping` VALUES (548, '辽宁省', '210000', '葫芦岛市', '211400', '龙港区', '211403');
INSERT INTO `area_mapping` VALUES (549, '辽宁省', '210000', '葫芦岛市', '211400', '南票区', '211404');
INSERT INTO `area_mapping` VALUES (550, '辽宁省', '210000', '葫芦岛市', '211400', '绥中县', '211421');
INSERT INTO `area_mapping` VALUES (551, '辽宁省', '210000', '葫芦岛市', '211400', '建昌县', '211422');
INSERT INTO `area_mapping` VALUES (552, '辽宁省', '210000', '葫芦岛市', '211400', '兴城市', '211481');
INSERT INTO `area_mapping` VALUES (553, '吉林省', '220000', '长春市', '220100', '南关区', '220102');
INSERT INTO `area_mapping` VALUES (554, '吉林省', '220000', '长春市', '220100', '宽城区', '220103');
INSERT INTO `area_mapping` VALUES (555, '吉林省', '220000', '长春市', '220100', '朝阳区', '220104');
INSERT INTO `area_mapping` VALUES (556, '吉林省', '220000', '长春市', '220100', '二道区', '220105');
INSERT INTO `area_mapping` VALUES (557, '吉林省', '220000', '长春市', '220100', '绿园区', '220106');
INSERT INTO `area_mapping` VALUES (558, '吉林省', '220000', '长春市', '220100', '双阳区', '220112');
INSERT INTO `area_mapping` VALUES (559, '吉林省', '220000', '长春市', '220100', '九台区', '220113');
INSERT INTO `area_mapping` VALUES (560, '吉林省', '220000', '长春市', '220100', '农安县', '220122');
INSERT INTO `area_mapping` VALUES (561, '吉林省', '220000', '长春市', '220100', '长春经济技术开发区', '220171');
INSERT INTO `area_mapping` VALUES (562, '吉林省', '220000', '长春市', '220100', '长春净月高新技术产业开发区', '220172');
INSERT INTO `area_mapping` VALUES (563, '吉林省', '220000', '长春市', '220100', '长春高新技术产业开发区', '220173');
INSERT INTO `area_mapping` VALUES (564, '吉林省', '220000', '长春市', '220100', '长春汽车经济技术开发区', '220174');
INSERT INTO `area_mapping` VALUES (565, '吉林省', '220000', '长春市', '220100', '榆树市', '220182');
INSERT INTO `area_mapping` VALUES (566, '吉林省', '220000', '长春市', '220100', '德惠市', '220183');
INSERT INTO `area_mapping` VALUES (567, '吉林省', '220000', '长春市', '220100', '公主岭市', '220184');
INSERT INTO `area_mapping` VALUES (568, '吉林省', '220000', '吉林市', '220200', '昌邑区', '220202');
INSERT INTO `area_mapping` VALUES (569, '吉林省', '220000', '吉林市', '220200', '龙潭区', '220203');
INSERT INTO `area_mapping` VALUES (570, '吉林省', '220000', '吉林市', '220200', '船营区', '220204');
INSERT INTO `area_mapping` VALUES (571, '吉林省', '220000', '吉林市', '220200', '丰满区', '220211');
INSERT INTO `area_mapping` VALUES (572, '吉林省', '220000', '吉林市', '220200', '永吉县', '220221');
INSERT INTO `area_mapping` VALUES (573, '吉林省', '220000', '吉林市', '220200', '吉林经济开发区', '220271');
INSERT INTO `area_mapping` VALUES (574, '吉林省', '220000', '吉林市', '220200', '吉林高新技术产业开发区', '220272');
INSERT INTO `area_mapping` VALUES (575, '吉林省', '220000', '吉林市', '220200', '吉林中国新加坡食品区', '220273');
INSERT INTO `area_mapping` VALUES (576, '吉林省', '220000', '吉林市', '220200', '蛟河市', '220281');
INSERT INTO `area_mapping` VALUES (577, '吉林省', '220000', '吉林市', '220200', '桦甸市', '220282');
INSERT INTO `area_mapping` VALUES (578, '吉林省', '220000', '吉林市', '220200', '舒兰市', '220283');
INSERT INTO `area_mapping` VALUES (579, '吉林省', '220000', '吉林市', '220200', '磐石市', '220284');
INSERT INTO `area_mapping` VALUES (580, '吉林省', '220000', '四平市', '220300', '铁西区', '220302');
INSERT INTO `area_mapping` VALUES (581, '吉林省', '220000', '四平市', '220300', '铁东区', '220303');
INSERT INTO `area_mapping` VALUES (582, '吉林省', '220000', '四平市', '220300', '梨树县', '220322');
INSERT INTO `area_mapping` VALUES (583, '吉林省', '220000', '四平市', '220300', '伊通满族自治县', '220323');
INSERT INTO `area_mapping` VALUES (584, '吉林省', '220000', '四平市', '220300', '双辽市', '220382');
INSERT INTO `area_mapping` VALUES (585, '吉林省', '220000', '辽源市', '220400', '龙山区', '220402');
INSERT INTO `area_mapping` VALUES (586, '吉林省', '220000', '辽源市', '220400', '西安区', '220403');
INSERT INTO `area_mapping` VALUES (587, '吉林省', '220000', '辽源市', '220400', '东丰县', '220421');
INSERT INTO `area_mapping` VALUES (588, '吉林省', '220000', '辽源市', '220400', '东辽县', '220422');
INSERT INTO `area_mapping` VALUES (589, '吉林省', '220000', '通化市', '220500', '东昌区', '220502');
INSERT INTO `area_mapping` VALUES (590, '吉林省', '220000', '通化市', '220500', '二道江区', '220503');
INSERT INTO `area_mapping` VALUES (591, '吉林省', '220000', '通化市', '220500', '通化县', '220521');
INSERT INTO `area_mapping` VALUES (592, '吉林省', '220000', '通化市', '220500', '辉南县', '220523');
INSERT INTO `area_mapping` VALUES (593, '吉林省', '220000', '通化市', '220500', '柳河县', '220524');
INSERT INTO `area_mapping` VALUES (594, '吉林省', '220000', '通化市', '220500', '梅河口市', '220581');
INSERT INTO `area_mapping` VALUES (595, '吉林省', '220000', '通化市', '220500', '集安市', '220582');
INSERT INTO `area_mapping` VALUES (596, '吉林省', '220000', '白山市', '220600', '浑江区', '220602');
INSERT INTO `area_mapping` VALUES (597, '吉林省', '220000', '白山市', '220600', '江源区', '220605');
INSERT INTO `area_mapping` VALUES (598, '吉林省', '220000', '白山市', '220600', '抚松县', '220621');
INSERT INTO `area_mapping` VALUES (599, '吉林省', '220000', '白山市', '220600', '靖宇县', '220622');
INSERT INTO `area_mapping` VALUES (600, '吉林省', '220000', '白山市', '220600', '长白朝鲜族自治县', '220623');
INSERT INTO `area_mapping` VALUES (601, '吉林省', '220000', '白山市', '220600', '临江市', '220681');
INSERT INTO `area_mapping` VALUES (602, '吉林省', '220000', '松原市', '220700', '宁江区', '220702');
INSERT INTO `area_mapping` VALUES (603, '吉林省', '220000', '松原市', '220700', '前郭尔罗斯蒙古族自治县', '220721');
INSERT INTO `area_mapping` VALUES (604, '吉林省', '220000', '松原市', '220700', '长岭县', '220722');
INSERT INTO `area_mapping` VALUES (605, '吉林省', '220000', '松原市', '220700', '乾安县', '220723');
INSERT INTO `area_mapping` VALUES (606, '吉林省', '220000', '松原市', '220700', '吉林松原经济开发区', '220771');
INSERT INTO `area_mapping` VALUES (607, '吉林省', '220000', '松原市', '220700', '扶余市', '220781');
INSERT INTO `area_mapping` VALUES (608, '吉林省', '220000', '白城市', '220800', '洮北区', '220802');
INSERT INTO `area_mapping` VALUES (609, '吉林省', '220000', '白城市', '220800', '镇赉县', '220821');
INSERT INTO `area_mapping` VALUES (610, '吉林省', '220000', '白城市', '220800', '通榆县', '220822');
INSERT INTO `area_mapping` VALUES (611, '吉林省', '220000', '白城市', '220800', '吉林白城经济开发区', '220871');
INSERT INTO `area_mapping` VALUES (612, '吉林省', '220000', '白城市', '220800', '洮南市', '220881');
INSERT INTO `area_mapping` VALUES (613, '吉林省', '220000', '白城市', '220800', '大安市', '220882');
INSERT INTO `area_mapping` VALUES (614, '吉林省', '220000', '延边朝鲜族自治州', '222400', '延吉市', '222401');
INSERT INTO `area_mapping` VALUES (615, '吉林省', '220000', '延边朝鲜族自治州', '222400', '图们市', '222402');
INSERT INTO `area_mapping` VALUES (616, '吉林省', '220000', '延边朝鲜族自治州', '222400', '敦化市', '222403');
INSERT INTO `area_mapping` VALUES (617, '吉林省', '220000', '延边朝鲜族自治州', '222400', '珲春市', '222404');
INSERT INTO `area_mapping` VALUES (618, '吉林省', '220000', '延边朝鲜族自治州', '222400', '龙井市', '222405');
INSERT INTO `area_mapping` VALUES (619, '吉林省', '220000', '延边朝鲜族自治州', '222400', '和龙市', '222406');
INSERT INTO `area_mapping` VALUES (620, '吉林省', '220000', '延边朝鲜族自治州', '222400', '汪清县', '222424');
INSERT INTO `area_mapping` VALUES (621, '吉林省', '220000', '延边朝鲜族自治州', '222400', '安图县', '222426');
INSERT INTO `area_mapping` VALUES (622, '黑龙江省', '230000', '哈尔滨市', '230100', '道里区', '230102');
INSERT INTO `area_mapping` VALUES (623, '黑龙江省', '230000', '哈尔滨市', '230100', '南岗区', '230103');
INSERT INTO `area_mapping` VALUES (624, '黑龙江省', '230000', '哈尔滨市', '230100', '道外区', '230104');
INSERT INTO `area_mapping` VALUES (625, '黑龙江省', '230000', '哈尔滨市', '230100', '平房区', '230108');
INSERT INTO `area_mapping` VALUES (626, '黑龙江省', '230000', '哈尔滨市', '230100', '松北区', '230109');
INSERT INTO `area_mapping` VALUES (627, '黑龙江省', '230000', '哈尔滨市', '230100', '香坊区', '230110');
INSERT INTO `area_mapping` VALUES (628, '黑龙江省', '230000', '哈尔滨市', '230100', '呼兰区', '230111');
INSERT INTO `area_mapping` VALUES (629, '黑龙江省', '230000', '哈尔滨市', '230100', '阿城区', '230112');
INSERT INTO `area_mapping` VALUES (630, '黑龙江省', '230000', '哈尔滨市', '230100', '双城区', '230113');
INSERT INTO `area_mapping` VALUES (631, '黑龙江省', '230000', '哈尔滨市', '230100', '依兰县', '230123');
INSERT INTO `area_mapping` VALUES (632, '黑龙江省', '230000', '哈尔滨市', '230100', '方正县', '230124');
INSERT INTO `area_mapping` VALUES (633, '黑龙江省', '230000', '哈尔滨市', '230100', '宾县', '230125');
INSERT INTO `area_mapping` VALUES (634, '黑龙江省', '230000', '哈尔滨市', '230100', '巴彦县', '230126');
INSERT INTO `area_mapping` VALUES (635, '黑龙江省', '230000', '哈尔滨市', '230100', '木兰县', '230127');
INSERT INTO `area_mapping` VALUES (636, '黑龙江省', '230000', '哈尔滨市', '230100', '通河县', '230128');
INSERT INTO `area_mapping` VALUES (637, '黑龙江省', '230000', '哈尔滨市', '230100', '延寿县', '230129');
INSERT INTO `area_mapping` VALUES (638, '黑龙江省', '230000', '哈尔滨市', '230100', '尚志市', '230183');
INSERT INTO `area_mapping` VALUES (639, '黑龙江省', '230000', '哈尔滨市', '230100', '五常市', '230184');
INSERT INTO `area_mapping` VALUES (640, '黑龙江省', '230000', '齐齐哈尔市', '230200', '龙沙区', '230202');
INSERT INTO `area_mapping` VALUES (641, '黑龙江省', '230000', '齐齐哈尔市', '230200', '建华区', '230203');
INSERT INTO `area_mapping` VALUES (642, '黑龙江省', '230000', '齐齐哈尔市', '230200', '铁锋区', '230204');
INSERT INTO `area_mapping` VALUES (643, '黑龙江省', '230000', '齐齐哈尔市', '230200', '昂昂溪区', '230205');
INSERT INTO `area_mapping` VALUES (644, '黑龙江省', '230000', '齐齐哈尔市', '230200', '富拉尔基区', '230206');
INSERT INTO `area_mapping` VALUES (645, '黑龙江省', '230000', '齐齐哈尔市', '230200', '碾子山区', '230207');
INSERT INTO `area_mapping` VALUES (646, '黑龙江省', '230000', '齐齐哈尔市', '230200', '梅里斯达斡尔族区', '230208');
INSERT INTO `area_mapping` VALUES (647, '黑龙江省', '230000', '齐齐哈尔市', '230200', '龙江县', '230221');
INSERT INTO `area_mapping` VALUES (648, '黑龙江省', '230000', '齐齐哈尔市', '230200', '依安县', '230223');
INSERT INTO `area_mapping` VALUES (649, '黑龙江省', '230000', '齐齐哈尔市', '230200', '泰来县', '230224');
INSERT INTO `area_mapping` VALUES (650, '黑龙江省', '230000', '齐齐哈尔市', '230200', '甘南县', '230225');
INSERT INTO `area_mapping` VALUES (651, '黑龙江省', '230000', '齐齐哈尔市', '230200', '富裕县', '230227');
INSERT INTO `area_mapping` VALUES (652, '黑龙江省', '230000', '齐齐哈尔市', '230200', '克山县', '230229');
INSERT INTO `area_mapping` VALUES (653, '黑龙江省', '230000', '齐齐哈尔市', '230200', '克东县', '230230');
INSERT INTO `area_mapping` VALUES (654, '黑龙江省', '230000', '齐齐哈尔市', '230200', '拜泉县', '230231');
INSERT INTO `area_mapping` VALUES (655, '黑龙江省', '230000', '齐齐哈尔市', '230200', '讷河市', '230281');
INSERT INTO `area_mapping` VALUES (656, '黑龙江省', '230000', '鸡西市', '230300', '鸡冠区', '230302');
INSERT INTO `area_mapping` VALUES (657, '黑龙江省', '230000', '鸡西市', '230300', '恒山区', '230303');
INSERT INTO `area_mapping` VALUES (658, '黑龙江省', '230000', '鸡西市', '230300', '滴道区', '230304');
INSERT INTO `area_mapping` VALUES (659, '黑龙江省', '230000', '鸡西市', '230300', '梨树区', '230305');
INSERT INTO `area_mapping` VALUES (660, '黑龙江省', '230000', '鸡西市', '230300', '城子河区', '230306');
INSERT INTO `area_mapping` VALUES (661, '黑龙江省', '230000', '鸡西市', '230300', '麻山区', '230307');
INSERT INTO `area_mapping` VALUES (662, '黑龙江省', '230000', '鸡西市', '230300', '鸡东县', '230321');
INSERT INTO `area_mapping` VALUES (663, '黑龙江省', '230000', '鸡西市', '230300', '虎林市', '230381');
INSERT INTO `area_mapping` VALUES (664, '黑龙江省', '230000', '鸡西市', '230300', '密山市', '230382');
INSERT INTO `area_mapping` VALUES (665, '黑龙江省', '230000', '鹤岗市', '230400', '向阳区', '230402');
INSERT INTO `area_mapping` VALUES (666, '黑龙江省', '230000', '鹤岗市', '230400', '工农区', '230403');
INSERT INTO `area_mapping` VALUES (667, '黑龙江省', '230000', '鹤岗市', '230400', '南山区', '230404');
INSERT INTO `area_mapping` VALUES (668, '黑龙江省', '230000', '鹤岗市', '230400', '兴安区', '230405');
INSERT INTO `area_mapping` VALUES (669, '黑龙江省', '230000', '鹤岗市', '230400', '东山区', '230406');
INSERT INTO `area_mapping` VALUES (670, '黑龙江省', '230000', '鹤岗市', '230400', '兴山区', '230407');
INSERT INTO `area_mapping` VALUES (671, '黑龙江省', '230000', '鹤岗市', '230400', '萝北县', '230421');
INSERT INTO `area_mapping` VALUES (672, '黑龙江省', '230000', '鹤岗市', '230400', '绥滨县', '230422');
INSERT INTO `area_mapping` VALUES (673, '黑龙江省', '230000', '双鸭山市', '230500', '尖山区', '230502');
INSERT INTO `area_mapping` VALUES (674, '黑龙江省', '230000', '双鸭山市', '230500', '岭东区', '230503');
INSERT INTO `area_mapping` VALUES (675, '黑龙江省', '230000', '双鸭山市', '230500', '四方台区', '230505');
INSERT INTO `area_mapping` VALUES (676, '黑龙江省', '230000', '双鸭山市', '230500', '宝山区', '230506');
INSERT INTO `area_mapping` VALUES (677, '黑龙江省', '230000', '双鸭山市', '230500', '集贤县', '230521');
INSERT INTO `area_mapping` VALUES (678, '黑龙江省', '230000', '双鸭山市', '230500', '友谊县', '230522');
INSERT INTO `area_mapping` VALUES (679, '黑龙江省', '230000', '双鸭山市', '230500', '宝清县', '230523');
INSERT INTO `area_mapping` VALUES (680, '黑龙江省', '230000', '双鸭山市', '230500', '饶河县', '230524');
INSERT INTO `area_mapping` VALUES (681, '黑龙江省', '230000', '大庆市', '230600', '萨尔图区', '230602');
INSERT INTO `area_mapping` VALUES (682, '黑龙江省', '230000', '大庆市', '230600', '龙凤区', '230603');
INSERT INTO `area_mapping` VALUES (683, '黑龙江省', '230000', '大庆市', '230600', '让胡路区', '230604');
INSERT INTO `area_mapping` VALUES (684, '黑龙江省', '230000', '大庆市', '230600', '红岗区', '230605');
INSERT INTO `area_mapping` VALUES (685, '黑龙江省', '230000', '大庆市', '230600', '大同区', '230606');
INSERT INTO `area_mapping` VALUES (686, '黑龙江省', '230000', '大庆市', '230600', '肇州县', '230621');
INSERT INTO `area_mapping` VALUES (687, '黑龙江省', '230000', '大庆市', '230600', '肇源县', '230622');
INSERT INTO `area_mapping` VALUES (688, '黑龙江省', '230000', '大庆市', '230600', '林甸县', '230623');
INSERT INTO `area_mapping` VALUES (689, '黑龙江省', '230000', '大庆市', '230600', '杜尔伯特蒙古族自治县', '230624');
INSERT INTO `area_mapping` VALUES (690, '黑龙江省', '230000', '大庆市', '230600', '大庆高新技术产业开发区', '230671');
INSERT INTO `area_mapping` VALUES (691, '黑龙江省', '230000', '伊春市', '230700', '伊美区', '230717');
INSERT INTO `area_mapping` VALUES (692, '黑龙江省', '230000', '伊春市', '230700', '乌翠区', '230718');
INSERT INTO `area_mapping` VALUES (693, '黑龙江省', '230000', '伊春市', '230700', '友好区', '230719');
INSERT INTO `area_mapping` VALUES (694, '黑龙江省', '230000', '伊春市', '230700', '嘉荫县', '230722');
INSERT INTO `area_mapping` VALUES (695, '黑龙江省', '230000', '伊春市', '230700', '汤旺县', '230723');
INSERT INTO `area_mapping` VALUES (696, '黑龙江省', '230000', '伊春市', '230700', '丰林县', '230724');
INSERT INTO `area_mapping` VALUES (697, '黑龙江省', '230000', '伊春市', '230700', '大箐山县', '230725');
INSERT INTO `area_mapping` VALUES (698, '黑龙江省', '230000', '伊春市', '230700', '南岔县', '230726');
INSERT INTO `area_mapping` VALUES (699, '黑龙江省', '230000', '伊春市', '230700', '金林区', '230751');
INSERT INTO `area_mapping` VALUES (700, '黑龙江省', '230000', '伊春市', '230700', '铁力市', '230781');
INSERT INTO `area_mapping` VALUES (701, '黑龙江省', '230000', '佳木斯市', '230800', '向阳区', '230803');
INSERT INTO `area_mapping` VALUES (702, '黑龙江省', '230000', '佳木斯市', '230800', '前进区', '230804');
INSERT INTO `area_mapping` VALUES (703, '黑龙江省', '230000', '佳木斯市', '230800', '东风区', '230805');
INSERT INTO `area_mapping` VALUES (704, '黑龙江省', '230000', '佳木斯市', '230800', '郊区', '230811');
INSERT INTO `area_mapping` VALUES (705, '黑龙江省', '230000', '佳木斯市', '230800', '桦南县', '230822');
INSERT INTO `area_mapping` VALUES (706, '黑龙江省', '230000', '佳木斯市', '230800', '桦川县', '230826');
INSERT INTO `area_mapping` VALUES (707, '黑龙江省', '230000', '佳木斯市', '230800', '汤原县', '230828');
INSERT INTO `area_mapping` VALUES (708, '黑龙江省', '230000', '佳木斯市', '230800', '同江市', '230881');
INSERT INTO `area_mapping` VALUES (709, '黑龙江省', '230000', '佳木斯市', '230800', '富锦市', '230882');
INSERT INTO `area_mapping` VALUES (710, '黑龙江省', '230000', '佳木斯市', '230800', '抚远市', '230883');
INSERT INTO `area_mapping` VALUES (711, '黑龙江省', '230000', '七台河市', '230900', '新兴区', '230902');
INSERT INTO `area_mapping` VALUES (712, '黑龙江省', '230000', '七台河市', '230900', '桃山区', '230903');
INSERT INTO `area_mapping` VALUES (713, '黑龙江省', '230000', '七台河市', '230900', '茄子河区', '230904');
INSERT INTO `area_mapping` VALUES (714, '黑龙江省', '230000', '七台河市', '230900', '勃利县', '230921');
INSERT INTO `area_mapping` VALUES (715, '黑龙江省', '230000', '牡丹江市', '231000', '东安区', '231002');
INSERT INTO `area_mapping` VALUES (716, '黑龙江省', '230000', '牡丹江市', '231000', '阳明区', '231003');
INSERT INTO `area_mapping` VALUES (717, '黑龙江省', '230000', '牡丹江市', '231000', '爱民区', '231004');
INSERT INTO `area_mapping` VALUES (718, '黑龙江省', '230000', '牡丹江市', '231000', '西安区', '231005');
INSERT INTO `area_mapping` VALUES (719, '黑龙江省', '230000', '牡丹江市', '231000', '林口县', '231025');
INSERT INTO `area_mapping` VALUES (720, '黑龙江省', '230000', '牡丹江市', '231000', '牡丹江经济技术开发区', '231071');
INSERT INTO `area_mapping` VALUES (721, '黑龙江省', '230000', '牡丹江市', '231000', '绥芬河市', '231081');
INSERT INTO `area_mapping` VALUES (722, '黑龙江省', '230000', '牡丹江市', '231000', '海林市', '231083');
INSERT INTO `area_mapping` VALUES (723, '黑龙江省', '230000', '牡丹江市', '231000', '宁安市', '231084');
INSERT INTO `area_mapping` VALUES (724, '黑龙江省', '230000', '牡丹江市', '231000', '穆棱市', '231085');
INSERT INTO `area_mapping` VALUES (725, '黑龙江省', '230000', '牡丹江市', '231000', '东宁市', '231086');
INSERT INTO `area_mapping` VALUES (726, '黑龙江省', '230000', '黑河市', '231100', '爱辉区', '231102');
INSERT INTO `area_mapping` VALUES (727, '黑龙江省', '230000', '黑河市', '231100', '逊克县', '231123');
INSERT INTO `area_mapping` VALUES (728, '黑龙江省', '230000', '黑河市', '231100', '孙吴县', '231124');
INSERT INTO `area_mapping` VALUES (729, '黑龙江省', '230000', '黑河市', '231100', '北安市', '231181');
INSERT INTO `area_mapping` VALUES (730, '黑龙江省', '230000', '黑河市', '231100', '五大连池市', '231182');
INSERT INTO `area_mapping` VALUES (731, '黑龙江省', '230000', '黑河市', '231100', '嫩江市', '231183');
INSERT INTO `area_mapping` VALUES (732, '黑龙江省', '230000', '绥化市', '231200', '北林区', '231202');
INSERT INTO `area_mapping` VALUES (733, '黑龙江省', '230000', '绥化市', '231200', '望奎县', '231221');
INSERT INTO `area_mapping` VALUES (734, '黑龙江省', '230000', '绥化市', '231200', '兰西县', '231222');
INSERT INTO `area_mapping` VALUES (735, '黑龙江省', '230000', '绥化市', '231200', '青冈县', '231223');
INSERT INTO `area_mapping` VALUES (736, '黑龙江省', '230000', '绥化市', '231200', '庆安县', '231224');
INSERT INTO `area_mapping` VALUES (737, '黑龙江省', '230000', '绥化市', '231200', '明水县', '231225');
INSERT INTO `area_mapping` VALUES (738, '黑龙江省', '230000', '绥化市', '231200', '绥棱县', '231226');
INSERT INTO `area_mapping` VALUES (739, '黑龙江省', '230000', '绥化市', '231200', '安达市', '231281');
INSERT INTO `area_mapping` VALUES (740, '黑龙江省', '230000', '绥化市', '231200', '肇东市', '231282');
INSERT INTO `area_mapping` VALUES (741, '黑龙江省', '230000', '绥化市', '231200', '海伦市', '231283');
INSERT INTO `area_mapping` VALUES (742, '黑龙江省', '230000', '大兴安岭地区', '232700', '漠河市', '232701');
INSERT INTO `area_mapping` VALUES (743, '黑龙江省', '230000', '大兴安岭地区', '232700', '呼玛县', '232721');
INSERT INTO `area_mapping` VALUES (744, '黑龙江省', '230000', '大兴安岭地区', '232700', '塔河县', '232722');
INSERT INTO `area_mapping` VALUES (745, '黑龙江省', '230000', '大兴安岭地区', '232700', '加格达奇区', '232761');
INSERT INTO `area_mapping` VALUES (746, '黑龙江省', '230000', '大兴安岭地区', '232700', '松岭区', '232762');
INSERT INTO `area_mapping` VALUES (747, '黑龙江省', '230000', '大兴安岭地区', '232700', '新林区', '232763');
INSERT INTO `area_mapping` VALUES (748, '黑龙江省', '230000', '大兴安岭地区', '232700', '呼中区', '232764');
INSERT INTO `area_mapping` VALUES (749, '上海市', '310000', '上海市', '310100', '黄浦区', '310101');
INSERT INTO `area_mapping` VALUES (750, '上海市', '310000', '上海市', '310100', '徐汇区', '310104');
INSERT INTO `area_mapping` VALUES (751, '上海市', '310000', '上海市', '310100', '长宁区', '310105');
INSERT INTO `area_mapping` VALUES (752, '上海市', '310000', '上海市', '310100', '静安区', '310106');
INSERT INTO `area_mapping` VALUES (753, '上海市', '310000', '上海市', '310100', '普陀区', '310107');
INSERT INTO `area_mapping` VALUES (754, '上海市', '310000', '上海市', '310100', '虹口区', '310109');
INSERT INTO `area_mapping` VALUES (755, '上海市', '310000', '上海市', '310100', '杨浦区', '310110');
INSERT INTO `area_mapping` VALUES (756, '上海市', '310000', '上海市', '310100', '闵行区', '310112');
INSERT INTO `area_mapping` VALUES (757, '上海市', '310000', '上海市', '310100', '宝山区', '310113');
INSERT INTO `area_mapping` VALUES (758, '上海市', '310000', '上海市', '310100', '嘉定区', '310114');
INSERT INTO `area_mapping` VALUES (759, '上海市', '310000', '上海市', '310100', '浦东新区', '310115');
INSERT INTO `area_mapping` VALUES (760, '上海市', '310000', '上海市', '310100', '金山区', '310116');
INSERT INTO `area_mapping` VALUES (761, '上海市', '310000', '上海市', '310100', '松江区', '310117');
INSERT INTO `area_mapping` VALUES (762, '上海市', '310000', '上海市', '310100', '青浦区', '310118');
INSERT INTO `area_mapping` VALUES (763, '上海市', '310000', '上海市', '310100', '奉贤区', '310120');
INSERT INTO `area_mapping` VALUES (764, '上海市', '310000', '上海市', '310100', '崇明区', '310151');
INSERT INTO `area_mapping` VALUES (765, '江苏省', '320000', '南京市', '320100', '玄武区', '320102');
INSERT INTO `area_mapping` VALUES (766, '江苏省', '320000', '南京市', '320100', '秦淮区', '320104');
INSERT INTO `area_mapping` VALUES (767, '江苏省', '320000', '南京市', '320100', '建邺区', '320105');
INSERT INTO `area_mapping` VALUES (768, '江苏省', '320000', '南京市', '320100', '鼓楼区', '320106');
INSERT INTO `area_mapping` VALUES (769, '江苏省', '320000', '南京市', '320100', '浦口区', '320111');
INSERT INTO `area_mapping` VALUES (770, '江苏省', '320000', '南京市', '320100', '栖霞区', '320113');
INSERT INTO `area_mapping` VALUES (771, '江苏省', '320000', '南京市', '320100', '雨花台区', '320114');
INSERT INTO `area_mapping` VALUES (772, '江苏省', '320000', '南京市', '320100', '江宁区', '320115');
INSERT INTO `area_mapping` VALUES (773, '江苏省', '320000', '南京市', '320100', '六合区', '320116');
INSERT INTO `area_mapping` VALUES (774, '江苏省', '320000', '南京市', '320100', '溧水区', '320117');
INSERT INTO `area_mapping` VALUES (775, '江苏省', '320000', '南京市', '320100', '高淳区', '320118');
INSERT INTO `area_mapping` VALUES (776, '江苏省', '320000', '无锡市', '320200', '锡山区', '320205');
INSERT INTO `area_mapping` VALUES (777, '江苏省', '320000', '无锡市', '320200', '惠山区', '320206');
INSERT INTO `area_mapping` VALUES (778, '江苏省', '320000', '无锡市', '320200', '滨湖区', '320211');
INSERT INTO `area_mapping` VALUES (779, '江苏省', '320000', '无锡市', '320200', '梁溪区', '320213');
INSERT INTO `area_mapping` VALUES (780, '江苏省', '320000', '无锡市', '320200', '新吴区', '320214');
INSERT INTO `area_mapping` VALUES (781, '江苏省', '320000', '无锡市', '320200', '江阴市', '320281');
INSERT INTO `area_mapping` VALUES (782, '江苏省', '320000', '无锡市', '320200', '宜兴市', '320282');
INSERT INTO `area_mapping` VALUES (783, '江苏省', '320000', '徐州市', '320300', '鼓楼区', '320302');
INSERT INTO `area_mapping` VALUES (784, '江苏省', '320000', '徐州市', '320300', '云龙区', '320303');
INSERT INTO `area_mapping` VALUES (785, '江苏省', '320000', '徐州市', '320300', '贾汪区', '320305');
INSERT INTO `area_mapping` VALUES (786, '江苏省', '320000', '徐州市', '320300', '泉山区', '320311');
INSERT INTO `area_mapping` VALUES (787, '江苏省', '320000', '徐州市', '320300', '铜山区', '320312');
INSERT INTO `area_mapping` VALUES (788, '江苏省', '320000', '徐州市', '320300', '丰县', '320321');
INSERT INTO `area_mapping` VALUES (789, '江苏省', '320000', '徐州市', '320300', '沛县', '320322');
INSERT INTO `area_mapping` VALUES (790, '江苏省', '320000', '徐州市', '320300', '睢宁县', '320324');
INSERT INTO `area_mapping` VALUES (791, '江苏省', '320000', '徐州市', '320300', '徐州经济技术开发区', '320371');
INSERT INTO `area_mapping` VALUES (792, '江苏省', '320000', '徐州市', '320300', '新沂市', '320381');
INSERT INTO `area_mapping` VALUES (793, '江苏省', '320000', '徐州市', '320300', '邳州市', '320382');
INSERT INTO `area_mapping` VALUES (794, '江苏省', '320000', '常州市', '320400', '天宁区', '320402');
INSERT INTO `area_mapping` VALUES (795, '江苏省', '320000', '常州市', '320400', '钟楼区', '320404');
INSERT INTO `area_mapping` VALUES (796, '江苏省', '320000', '常州市', '320400', '新北区', '320411');
INSERT INTO `area_mapping` VALUES (797, '江苏省', '320000', '常州市', '320400', '武进区', '320412');
INSERT INTO `area_mapping` VALUES (798, '江苏省', '320000', '常州市', '320400', '金坛区', '320413');
INSERT INTO `area_mapping` VALUES (799, '江苏省', '320000', '常州市', '320400', '溧阳市', '320481');
INSERT INTO `area_mapping` VALUES (800, '江苏省', '320000', '苏州市', '320500', '虎丘区', '320505');
INSERT INTO `area_mapping` VALUES (801, '江苏省', '320000', '苏州市', '320500', '吴中区', '320506');
INSERT INTO `area_mapping` VALUES (802, '江苏省', '320000', '苏州市', '320500', '相城区', '320507');
INSERT INTO `area_mapping` VALUES (803, '江苏省', '320000', '苏州市', '320500', '姑苏区', '320508');
INSERT INTO `area_mapping` VALUES (804, '江苏省', '320000', '苏州市', '320500', '吴江区', '320509');
INSERT INTO `area_mapping` VALUES (805, '江苏省', '320000', '苏州市', '320500', '苏州工业园区', '320571');
INSERT INTO `area_mapping` VALUES (806, '江苏省', '320000', '苏州市', '320500', '常熟市', '320581');
INSERT INTO `area_mapping` VALUES (807, '江苏省', '320000', '苏州市', '320500', '张家港市', '320582');
INSERT INTO `area_mapping` VALUES (808, '江苏省', '320000', '苏州市', '320500', '昆山市', '320583');
INSERT INTO `area_mapping` VALUES (809, '江苏省', '320000', '苏州市', '320500', '太仓市', '320585');
INSERT INTO `area_mapping` VALUES (810, '江苏省', '320000', '南通市', '320600', '崇川区', '320602');
INSERT INTO `area_mapping` VALUES (811, '江苏省', '320000', '南通市', '320600', '港闸区', '320611');
INSERT INTO `area_mapping` VALUES (812, '江苏省', '320000', '南通市', '320600', '通州区', '320612');
INSERT INTO `area_mapping` VALUES (813, '江苏省', '320000', '南通市', '320600', '如东县', '320623');
INSERT INTO `area_mapping` VALUES (814, '江苏省', '320000', '南通市', '320600', '南通经济技术开发区', '320671');
INSERT INTO `area_mapping` VALUES (815, '江苏省', '320000', '南通市', '320600', '启东市', '320681');
INSERT INTO `area_mapping` VALUES (816, '江苏省', '320000', '南通市', '320600', '如皋市', '320682');
INSERT INTO `area_mapping` VALUES (817, '江苏省', '320000', '南通市', '320600', '海门市', '320684');
INSERT INTO `area_mapping` VALUES (818, '江苏省', '320000', '南通市', '320600', '海安市', '320685');
INSERT INTO `area_mapping` VALUES (819, '江苏省', '320000', '连云港市', '320700', '连云区', '320703');
INSERT INTO `area_mapping` VALUES (820, '江苏省', '320000', '连云港市', '320700', '海州区', '320706');
INSERT INTO `area_mapping` VALUES (821, '江苏省', '320000', '连云港市', '320700', '赣榆区', '320707');
INSERT INTO `area_mapping` VALUES (822, '江苏省', '320000', '连云港市', '320700', '东海县', '320722');
INSERT INTO `area_mapping` VALUES (823, '江苏省', '320000', '连云港市', '320700', '灌云县', '320723');
INSERT INTO `area_mapping` VALUES (824, '江苏省', '320000', '连云港市', '320700', '灌南县', '320724');
INSERT INTO `area_mapping` VALUES (825, '江苏省', '320000', '连云港市', '320700', '连云港经济技术开发区', '320771');
INSERT INTO `area_mapping` VALUES (826, '江苏省', '320000', '连云港市', '320700', '连云港高新技术产业开发区', '320772');
INSERT INTO `area_mapping` VALUES (827, '江苏省', '320000', '淮安市', '320800', '淮安区', '320803');
INSERT INTO `area_mapping` VALUES (828, '江苏省', '320000', '淮安市', '320800', '淮阴区', '320804');
INSERT INTO `area_mapping` VALUES (829, '江苏省', '320000', '淮安市', '320800', '清江浦区', '320812');
INSERT INTO `area_mapping` VALUES (830, '江苏省', '320000', '淮安市', '320800', '洪泽区', '320813');
INSERT INTO `area_mapping` VALUES (831, '江苏省', '320000', '淮安市', '320800', '涟水县', '320826');
INSERT INTO `area_mapping` VALUES (832, '江苏省', '320000', '淮安市', '320800', '盱眙县', '320830');
INSERT INTO `area_mapping` VALUES (833, '江苏省', '320000', '淮安市', '320800', '金湖县', '320831');
INSERT INTO `area_mapping` VALUES (834, '江苏省', '320000', '淮安市', '320800', '淮安经济技术开发区', '320871');
INSERT INTO `area_mapping` VALUES (835, '江苏省', '320000', '盐城市', '320900', '亭湖区', '320902');
INSERT INTO `area_mapping` VALUES (836, '江苏省', '320000', '盐城市', '320900', '盐都区', '320903');
INSERT INTO `area_mapping` VALUES (837, '江苏省', '320000', '盐城市', '320900', '大丰区', '320904');
INSERT INTO `area_mapping` VALUES (838, '江苏省', '320000', '盐城市', '320900', '响水县', '320921');
INSERT INTO `area_mapping` VALUES (839, '江苏省', '320000', '盐城市', '320900', '滨海县', '320922');
INSERT INTO `area_mapping` VALUES (840, '江苏省', '320000', '盐城市', '320900', '阜宁县', '320923');
INSERT INTO `area_mapping` VALUES (841, '江苏省', '320000', '盐城市', '320900', '射阳县', '320924');
INSERT INTO `area_mapping` VALUES (842, '江苏省', '320000', '盐城市', '320900', '建湖县', '320925');
INSERT INTO `area_mapping` VALUES (843, '江苏省', '320000', '盐城市', '320900', '盐城经济技术开发区', '320971');
INSERT INTO `area_mapping` VALUES (844, '江苏省', '320000', '盐城市', '320900', '东台市', '320981');
INSERT INTO `area_mapping` VALUES (845, '江苏省', '320000', '扬州市', '321000', '广陵区', '321002');
INSERT INTO `area_mapping` VALUES (846, '江苏省', '320000', '扬州市', '321000', '邗江区', '321003');
INSERT INTO `area_mapping` VALUES (847, '江苏省', '320000', '扬州市', '321000', '江都区', '321012');
INSERT INTO `area_mapping` VALUES (848, '江苏省', '320000', '扬州市', '321000', '宝应县', '321023');
INSERT INTO `area_mapping` VALUES (849, '江苏省', '320000', '扬州市', '321000', '扬州经济技术开发区', '321071');
INSERT INTO `area_mapping` VALUES (850, '江苏省', '320000', '扬州市', '321000', '仪征市', '321081');
INSERT INTO `area_mapping` VALUES (851, '江苏省', '320000', '扬州市', '321000', '高邮市', '321084');
INSERT INTO `area_mapping` VALUES (852, '江苏省', '320000', '镇江市', '321100', '京口区', '321102');
INSERT INTO `area_mapping` VALUES (853, '江苏省', '320000', '镇江市', '321100', '润州区', '321111');
INSERT INTO `area_mapping` VALUES (854, '江苏省', '320000', '镇江市', '321100', '丹徒区', '321112');
INSERT INTO `area_mapping` VALUES (855, '江苏省', '320000', '镇江市', '321100', '镇江新区', '321171');
INSERT INTO `area_mapping` VALUES (856, '江苏省', '320000', '镇江市', '321100', '丹阳市', '321181');
INSERT INTO `area_mapping` VALUES (857, '江苏省', '320000', '镇江市', '321100', '扬中市', '321182');
INSERT INTO `area_mapping` VALUES (858, '江苏省', '320000', '镇江市', '321100', '句容市', '321183');
INSERT INTO `area_mapping` VALUES (859, '江苏省', '320000', '泰州市', '321200', '海陵区', '321202');
INSERT INTO `area_mapping` VALUES (860, '江苏省', '320000', '泰州市', '321200', '高港区', '321203');
INSERT INTO `area_mapping` VALUES (861, '江苏省', '320000', '泰州市', '321200', '姜堰区', '321204');
INSERT INTO `area_mapping` VALUES (862, '江苏省', '320000', '泰州市', '321200', '泰州医药高新技术产业开发区', '321271');
INSERT INTO `area_mapping` VALUES (863, '江苏省', '320000', '泰州市', '321200', '兴化市', '321281');
INSERT INTO `area_mapping` VALUES (864, '江苏省', '320000', '泰州市', '321200', '靖江市', '321282');
INSERT INTO `area_mapping` VALUES (865, '江苏省', '320000', '泰州市', '321200', '泰兴市', '321283');
INSERT INTO `area_mapping` VALUES (866, '江苏省', '320000', '宿迁市', '321300', '宿城区', '321302');
INSERT INTO `area_mapping` VALUES (867, '江苏省', '320000', '宿迁市', '321300', '宿豫区', '321311');
INSERT INTO `area_mapping` VALUES (868, '江苏省', '320000', '宿迁市', '321300', '沭阳县', '321322');
INSERT INTO `area_mapping` VALUES (869, '江苏省', '320000', '宿迁市', '321300', '泗阳县', '321323');
INSERT INTO `area_mapping` VALUES (870, '江苏省', '320000', '宿迁市', '321300', '泗洪县', '321324');
INSERT INTO `area_mapping` VALUES (871, '江苏省', '320000', '宿迁市', '321300', '宿迁经济技术开发区', '321371');
INSERT INTO `area_mapping` VALUES (872, '浙江省', '330000', '杭州市', '330100', '上城区', '330102');
INSERT INTO `area_mapping` VALUES (873, '浙江省', '330000', '杭州市', '330100', '下城区', '330103');
INSERT INTO `area_mapping` VALUES (874, '浙江省', '330000', '杭州市', '330100', '江干区', '330104');
INSERT INTO `area_mapping` VALUES (875, '浙江省', '330000', '杭州市', '330100', '拱墅区', '330105');
INSERT INTO `area_mapping` VALUES (876, '浙江省', '330000', '杭州市', '330100', '西湖区', '330106');
INSERT INTO `area_mapping` VALUES (877, '浙江省', '330000', '杭州市', '330100', '滨江区', '330108');
INSERT INTO `area_mapping` VALUES (878, '浙江省', '330000', '杭州市', '330100', '萧山区', '330109');
INSERT INTO `area_mapping` VALUES (879, '浙江省', '330000', '杭州市', '330100', '余杭区', '330110');
INSERT INTO `area_mapping` VALUES (880, '浙江省', '330000', '杭州市', '330100', '富阳区', '330111');
INSERT INTO `area_mapping` VALUES (881, '浙江省', '330000', '杭州市', '330100', '临安区', '330112');
INSERT INTO `area_mapping` VALUES (882, '浙江省', '330000', '杭州市', '330100', '桐庐县', '330122');
INSERT INTO `area_mapping` VALUES (883, '浙江省', '330000', '杭州市', '330100', '淳安县', '330127');
INSERT INTO `area_mapping` VALUES (884, '浙江省', '330000', '杭州市', '330100', '建德市', '330182');
INSERT INTO `area_mapping` VALUES (885, '浙江省', '330000', '宁波市', '330200', '海曙区', '330203');
INSERT INTO `area_mapping` VALUES (886, '浙江省', '330000', '宁波市', '330200', '江北区', '330205');
INSERT INTO `area_mapping` VALUES (887, '浙江省', '330000', '宁波市', '330200', '北仑区', '330206');
INSERT INTO `area_mapping` VALUES (888, '浙江省', '330000', '宁波市', '330200', '镇海区', '330211');
INSERT INTO `area_mapping` VALUES (889, '浙江省', '330000', '宁波市', '330200', '鄞州区', '330212');
INSERT INTO `area_mapping` VALUES (890, '浙江省', '330000', '宁波市', '330200', '奉化区', '330213');
INSERT INTO `area_mapping` VALUES (891, '浙江省', '330000', '宁波市', '330200', '象山县', '330225');
INSERT INTO `area_mapping` VALUES (892, '浙江省', '330000', '宁波市', '330200', '宁海县', '330226');
INSERT INTO `area_mapping` VALUES (893, '浙江省', '330000', '宁波市', '330200', '余姚市', '330281');
INSERT INTO `area_mapping` VALUES (894, '浙江省', '330000', '宁波市', '330200', '慈溪市', '330282');
INSERT INTO `area_mapping` VALUES (895, '浙江省', '330000', '温州市', '330300', '鹿城区', '330302');
INSERT INTO `area_mapping` VALUES (896, '浙江省', '330000', '温州市', '330300', '龙湾区', '330303');
INSERT INTO `area_mapping` VALUES (897, '浙江省', '330000', '温州市', '330300', '瓯海区', '330304');
INSERT INTO `area_mapping` VALUES (898, '浙江省', '330000', '温州市', '330300', '洞头区', '330305');
INSERT INTO `area_mapping` VALUES (899, '浙江省', '330000', '温州市', '330300', '永嘉县', '330324');
INSERT INTO `area_mapping` VALUES (900, '浙江省', '330000', '温州市', '330300', '平阳县', '330326');
INSERT INTO `area_mapping` VALUES (901, '浙江省', '330000', '温州市', '330300', '苍南县', '330327');
INSERT INTO `area_mapping` VALUES (902, '浙江省', '330000', '温州市', '330300', '文成县', '330328');
INSERT INTO `area_mapping` VALUES (903, '浙江省', '330000', '温州市', '330300', '泰顺县', '330329');
INSERT INTO `area_mapping` VALUES (904, '浙江省', '330000', '温州市', '330300', '温州经济技术开发区', '330371');
INSERT INTO `area_mapping` VALUES (905, '浙江省', '330000', '温州市', '330300', '瑞安市', '330381');
INSERT INTO `area_mapping` VALUES (906, '浙江省', '330000', '温州市', '330300', '乐清市', '330382');
INSERT INTO `area_mapping` VALUES (907, '浙江省', '330000', '温州市', '330300', '龙港市', '330383');
INSERT INTO `area_mapping` VALUES (908, '浙江省', '330000', '嘉兴市', '330400', '南湖区', '330402');
INSERT INTO `area_mapping` VALUES (909, '浙江省', '330000', '嘉兴市', '330400', '秀洲区', '330411');
INSERT INTO `area_mapping` VALUES (910, '浙江省', '330000', '嘉兴市', '330400', '嘉善县', '330421');
INSERT INTO `area_mapping` VALUES (911, '浙江省', '330000', '嘉兴市', '330400', '海盐县', '330424');
INSERT INTO `area_mapping` VALUES (912, '浙江省', '330000', '嘉兴市', '330400', '海宁市', '330481');
INSERT INTO `area_mapping` VALUES (913, '浙江省', '330000', '嘉兴市', '330400', '平湖市', '330482');
INSERT INTO `area_mapping` VALUES (914, '浙江省', '330000', '嘉兴市', '330400', '桐乡市', '330483');
INSERT INTO `area_mapping` VALUES (915, '浙江省', '330000', '湖州市', '330500', '吴兴区', '330502');
INSERT INTO `area_mapping` VALUES (916, '浙江省', '330000', '湖州市', '330500', '南浔区', '330503');
INSERT INTO `area_mapping` VALUES (917, '浙江省', '330000', '湖州市', '330500', '德清县', '330521');
INSERT INTO `area_mapping` VALUES (918, '浙江省', '330000', '湖州市', '330500', '长兴县', '330522');
INSERT INTO `area_mapping` VALUES (919, '浙江省', '330000', '湖州市', '330500', '安吉县', '330523');
INSERT INTO `area_mapping` VALUES (920, '浙江省', '330000', '绍兴市', '330600', '越城区', '330602');
INSERT INTO `area_mapping` VALUES (921, '浙江省', '330000', '绍兴市', '330600', '柯桥区', '330603');
INSERT INTO `area_mapping` VALUES (922, '浙江省', '330000', '绍兴市', '330600', '上虞区', '330604');
INSERT INTO `area_mapping` VALUES (923, '浙江省', '330000', '绍兴市', '330600', '新昌县', '330624');
INSERT INTO `area_mapping` VALUES (924, '浙江省', '330000', '绍兴市', '330600', '诸暨市', '330681');
INSERT INTO `area_mapping` VALUES (925, '浙江省', '330000', '绍兴市', '330600', '嵊州市', '330683');
INSERT INTO `area_mapping` VALUES (926, '浙江省', '330000', '金华市', '330700', '婺城区', '330702');
INSERT INTO `area_mapping` VALUES (927, '浙江省', '330000', '金华市', '330700', '金东区', '330703');
INSERT INTO `area_mapping` VALUES (928, '浙江省', '330000', '金华市', '330700', '武义县', '330723');
INSERT INTO `area_mapping` VALUES (929, '浙江省', '330000', '金华市', '330700', '浦江县', '330726');
INSERT INTO `area_mapping` VALUES (930, '浙江省', '330000', '金华市', '330700', '磐安县', '330727');
INSERT INTO `area_mapping` VALUES (931, '浙江省', '330000', '金华市', '330700', '兰溪市', '330781');
INSERT INTO `area_mapping` VALUES (932, '浙江省', '330000', '金华市', '330700', '义乌市', '330782');
INSERT INTO `area_mapping` VALUES (933, '浙江省', '330000', '金华市', '330700', '东阳市', '330783');
INSERT INTO `area_mapping` VALUES (934, '浙江省', '330000', '金华市', '330700', '永康市', '330784');
INSERT INTO `area_mapping` VALUES (935, '浙江省', '330000', '衢州市', '330800', '柯城区', '330802');
INSERT INTO `area_mapping` VALUES (936, '浙江省', '330000', '衢州市', '330800', '衢江区', '330803');
INSERT INTO `area_mapping` VALUES (937, '浙江省', '330000', '衢州市', '330800', '常山县', '330822');
INSERT INTO `area_mapping` VALUES (938, '浙江省', '330000', '衢州市', '330800', '开化县', '330824');
INSERT INTO `area_mapping` VALUES (939, '浙江省', '330000', '衢州市', '330800', '龙游县', '330825');
INSERT INTO `area_mapping` VALUES (940, '浙江省', '330000', '衢州市', '330800', '江山市', '330881');
INSERT INTO `area_mapping` VALUES (941, '浙江省', '330000', '舟山市', '330900', '定海区', '330902');
INSERT INTO `area_mapping` VALUES (942, '浙江省', '330000', '舟山市', '330900', '普陀区', '330903');
INSERT INTO `area_mapping` VALUES (943, '浙江省', '330000', '舟山市', '330900', '岱山县', '330921');
INSERT INTO `area_mapping` VALUES (944, '浙江省', '330000', '舟山市', '330900', '嵊泗县', '330922');
INSERT INTO `area_mapping` VALUES (945, '浙江省', '330000', '台州市', '331000', '椒江区', '331002');
INSERT INTO `area_mapping` VALUES (946, '浙江省', '330000', '台州市', '331000', '黄岩区', '331003');
INSERT INTO `area_mapping` VALUES (947, '浙江省', '330000', '台州市', '331000', '路桥区', '331004');
INSERT INTO `area_mapping` VALUES (948, '浙江省', '330000', '台州市', '331000', '三门县', '331022');
INSERT INTO `area_mapping` VALUES (949, '浙江省', '330000', '台州市', '331000', '天台县', '331023');
INSERT INTO `area_mapping` VALUES (950, '浙江省', '330000', '台州市', '331000', '仙居县', '331024');
INSERT INTO `area_mapping` VALUES (951, '浙江省', '330000', '台州市', '331000', '温岭市', '331081');
INSERT INTO `area_mapping` VALUES (952, '浙江省', '330000', '台州市', '331000', '临海市', '331082');
INSERT INTO `area_mapping` VALUES (953, '浙江省', '330000', '台州市', '331000', '玉环市', '331083');
INSERT INTO `area_mapping` VALUES (954, '浙江省', '330000', '丽水市', '331100', '莲都区', '331102');
INSERT INTO `area_mapping` VALUES (955, '浙江省', '330000', '丽水市', '331100', '青田县', '331121');
INSERT INTO `area_mapping` VALUES (956, '浙江省', '330000', '丽水市', '331100', '缙云县', '331122');
INSERT INTO `area_mapping` VALUES (957, '浙江省', '330000', '丽水市', '331100', '遂昌县', '331123');
INSERT INTO `area_mapping` VALUES (958, '浙江省', '330000', '丽水市', '331100', '松阳县', '331124');
INSERT INTO `area_mapping` VALUES (959, '浙江省', '330000', '丽水市', '331100', '云和县', '331125');
INSERT INTO `area_mapping` VALUES (960, '浙江省', '330000', '丽水市', '331100', '庆元县', '331126');
INSERT INTO `area_mapping` VALUES (961, '浙江省', '330000', '丽水市', '331100', '景宁畲族自治县', '331127');
INSERT INTO `area_mapping` VALUES (962, '浙江省', '330000', '丽水市', '331100', '龙泉市', '331181');
INSERT INTO `area_mapping` VALUES (963, '安徽省', '340000', '合肥市', '340100', '瑶海区', '340102');
INSERT INTO `area_mapping` VALUES (964, '安徽省', '340000', '合肥市', '340100', '庐阳区', '340103');
INSERT INTO `area_mapping` VALUES (965, '安徽省', '340000', '合肥市', '340100', '蜀山区', '340104');
INSERT INTO `area_mapping` VALUES (966, '安徽省', '340000', '合肥市', '340100', '包河区', '340111');
INSERT INTO `area_mapping` VALUES (967, '安徽省', '340000', '合肥市', '340100', '长丰县', '340121');
INSERT INTO `area_mapping` VALUES (968, '安徽省', '340000', '合肥市', '340100', '肥东县', '340122');
INSERT INTO `area_mapping` VALUES (969, '安徽省', '340000', '合肥市', '340100', '肥西县', '340123');
INSERT INTO `area_mapping` VALUES (970, '安徽省', '340000', '合肥市', '340100', '庐江县', '340124');
INSERT INTO `area_mapping` VALUES (971, '安徽省', '340000', '合肥市', '340100', '合肥高新技术产业开发区', '340171');
INSERT INTO `area_mapping` VALUES (972, '安徽省', '340000', '合肥市', '340100', '合肥经济技术开发区', '340172');
INSERT INTO `area_mapping` VALUES (973, '安徽省', '340000', '合肥市', '340100', '合肥新站高新技术产业开发区', '340173');
INSERT INTO `area_mapping` VALUES (974, '安徽省', '340000', '合肥市', '340100', '巢湖市', '340181');
INSERT INTO `area_mapping` VALUES (975, '安徽省', '340000', '芜湖市', '340200', '镜湖区', '340202');
INSERT INTO `area_mapping` VALUES (976, '安徽省', '340000', '芜湖市', '340200', '弋江区', '340203');
INSERT INTO `area_mapping` VALUES (977, '安徽省', '340000', '芜湖市', '340200', '鸠江区', '340207');
INSERT INTO `area_mapping` VALUES (978, '安徽省', '340000', '芜湖市', '340200', '三山区', '340208');
INSERT INTO `area_mapping` VALUES (979, '安徽省', '340000', '芜湖市', '340200', '芜湖县', '340221');
INSERT INTO `area_mapping` VALUES (980, '安徽省', '340000', '芜湖市', '340200', '繁昌县', '340222');
INSERT INTO `area_mapping` VALUES (981, '安徽省', '340000', '芜湖市', '340200', '南陵县', '340223');
INSERT INTO `area_mapping` VALUES (982, '安徽省', '340000', '芜湖市', '340200', '芜湖经济技术开发区', '340271');
INSERT INTO `area_mapping` VALUES (983, '安徽省', '340000', '芜湖市', '340200', '安徽芜湖长江大桥经济开发区', '340272');
INSERT INTO `area_mapping` VALUES (984, '安徽省', '340000', '芜湖市', '340200', '无为市', '340281');
INSERT INTO `area_mapping` VALUES (985, '安徽省', '340000', '蚌埠市', '340300', '龙子湖区', '340302');
INSERT INTO `area_mapping` VALUES (986, '安徽省', '340000', '蚌埠市', '340300', '蚌山区', '340303');
INSERT INTO `area_mapping` VALUES (987, '安徽省', '340000', '蚌埠市', '340300', '禹会区', '340304');
INSERT INTO `area_mapping` VALUES (988, '安徽省', '340000', '蚌埠市', '340300', '淮上区', '340311');
INSERT INTO `area_mapping` VALUES (989, '安徽省', '340000', '蚌埠市', '340300', '怀远县', '340321');
INSERT INTO `area_mapping` VALUES (990, '安徽省', '340000', '蚌埠市', '340300', '五河县', '340322');
INSERT INTO `area_mapping` VALUES (991, '安徽省', '340000', '蚌埠市', '340300', '固镇县', '340323');
INSERT INTO `area_mapping` VALUES (992, '安徽省', '340000', '蚌埠市', '340300', '蚌埠市高新技术开发区', '340371');
INSERT INTO `area_mapping` VALUES (993, '安徽省', '340000', '蚌埠市', '340300', '蚌埠市经济开发区', '340372');
INSERT INTO `area_mapping` VALUES (994, '安徽省', '340000', '淮南市', '340400', '大通区', '340402');
INSERT INTO `area_mapping` VALUES (995, '安徽省', '340000', '淮南市', '340400', '田家庵区', '340403');
INSERT INTO `area_mapping` VALUES (996, '安徽省', '340000', '淮南市', '340400', '谢家集区', '340404');
INSERT INTO `area_mapping` VALUES (997, '安徽省', '340000', '淮南市', '340400', '八公山区', '340405');
INSERT INTO `area_mapping` VALUES (998, '安徽省', '340000', '淮南市', '340400', '潘集区', '340406');
INSERT INTO `area_mapping` VALUES (999, '安徽省', '340000', '淮南市', '340400', '凤台县', '340421');
INSERT INTO `area_mapping` VALUES (1000, '安徽省', '340000', '淮南市', '340400', '寿县', '340422');
INSERT INTO `area_mapping` VALUES (1001, '安徽省', '340000', '马鞍山市', '340500', '花山区', '340503');
INSERT INTO `area_mapping` VALUES (1002, '安徽省', '340000', '马鞍山市', '340500', '雨山区', '340504');
INSERT INTO `area_mapping` VALUES (1003, '安徽省', '340000', '马鞍山市', '340500', '博望区', '340506');
INSERT INTO `area_mapping` VALUES (1004, '安徽省', '340000', '马鞍山市', '340500', '当涂县', '340521');
INSERT INTO `area_mapping` VALUES (1005, '安徽省', '340000', '马鞍山市', '340500', '含山县', '340522');
INSERT INTO `area_mapping` VALUES (1006, '安徽省', '340000', '马鞍山市', '340500', '和县', '340523');
INSERT INTO `area_mapping` VALUES (1007, '安徽省', '340000', '淮北市', '340600', '杜集区', '340602');
INSERT INTO `area_mapping` VALUES (1008, '安徽省', '340000', '淮北市', '340600', '相山区', '340603');
INSERT INTO `area_mapping` VALUES (1009, '安徽省', '340000', '淮北市', '340600', '烈山区', '340604');
INSERT INTO `area_mapping` VALUES (1010, '安徽省', '340000', '淮北市', '340600', '濉溪县', '340621');
INSERT INTO `area_mapping` VALUES (1011, '安徽省', '340000', '铜陵市', '340700', '铜官区', '340705');
INSERT INTO `area_mapping` VALUES (1012, '安徽省', '340000', '铜陵市', '340700', '义安区', '340706');
INSERT INTO `area_mapping` VALUES (1013, '安徽省', '340000', '铜陵市', '340700', '郊区', '340711');
INSERT INTO `area_mapping` VALUES (1014, '安徽省', '340000', '铜陵市', '340700', '枞阳县', '340722');
INSERT INTO `area_mapping` VALUES (1015, '安徽省', '340000', '安庆市', '340800', '迎江区', '340802');
INSERT INTO `area_mapping` VALUES (1016, '安徽省', '340000', '安庆市', '340800', '大观区', '340803');
INSERT INTO `area_mapping` VALUES (1017, '安徽省', '340000', '安庆市', '340800', '宜秀区', '340811');
INSERT INTO `area_mapping` VALUES (1018, '安徽省', '340000', '安庆市', '340800', '怀宁县', '340822');
INSERT INTO `area_mapping` VALUES (1019, '安徽省', '340000', '安庆市', '340800', '太湖县', '340825');
INSERT INTO `area_mapping` VALUES (1020, '安徽省', '340000', '安庆市', '340800', '宿松县', '340826');
INSERT INTO `area_mapping` VALUES (1021, '安徽省', '340000', '安庆市', '340800', '望江县', '340827');
INSERT INTO `area_mapping` VALUES (1022, '安徽省', '340000', '安庆市', '340800', '岳西县', '340828');
INSERT INTO `area_mapping` VALUES (1023, '安徽省', '340000', '安庆市', '340800', '安徽安庆经济开发区', '340871');
INSERT INTO `area_mapping` VALUES (1024, '安徽省', '340000', '安庆市', '340800', '桐城市', '340881');
INSERT INTO `area_mapping` VALUES (1025, '安徽省', '340000', '安庆市', '340800', '潜山市', '340882');
INSERT INTO `area_mapping` VALUES (1026, '安徽省', '340000', '黄山市', '341000', '屯溪区', '341002');
INSERT INTO `area_mapping` VALUES (1027, '安徽省', '340000', '黄山市', '341000', '黄山区', '341003');
INSERT INTO `area_mapping` VALUES (1028, '安徽省', '340000', '黄山市', '341000', '徽州区', '341004');
INSERT INTO `area_mapping` VALUES (1029, '安徽省', '340000', '黄山市', '341000', '歙县', '341021');
INSERT INTO `area_mapping` VALUES (1030, '安徽省', '340000', '黄山市', '341000', '休宁县', '341022');
INSERT INTO `area_mapping` VALUES (1031, '安徽省', '340000', '黄山市', '341000', '黟县', '341023');
INSERT INTO `area_mapping` VALUES (1032, '安徽省', '340000', '黄山市', '341000', '祁门县', '341024');
INSERT INTO `area_mapping` VALUES (1033, '安徽省', '340000', '滁州市', '341100', '琅琊区', '341102');
INSERT INTO `area_mapping` VALUES (1034, '安徽省', '340000', '滁州市', '341100', '南谯区', '341103');
INSERT INTO `area_mapping` VALUES (1035, '安徽省', '340000', '滁州市', '341100', '来安县', '341122');
INSERT INTO `area_mapping` VALUES (1036, '安徽省', '340000', '滁州市', '341100', '全椒县', '341124');
INSERT INTO `area_mapping` VALUES (1037, '安徽省', '340000', '滁州市', '341100', '定远县', '341125');
INSERT INTO `area_mapping` VALUES (1038, '安徽省', '340000', '滁州市', '341100', '凤阳县', '341126');
INSERT INTO `area_mapping` VALUES (1039, '安徽省', '340000', '滁州市', '341100', '苏滁现代产业园', '341171');
INSERT INTO `area_mapping` VALUES (1040, '安徽省', '340000', '滁州市', '341100', '滁州经济技术开发区', '341172');
INSERT INTO `area_mapping` VALUES (1041, '安徽省', '340000', '滁州市', '341100', '天长市', '341181');
INSERT INTO `area_mapping` VALUES (1042, '安徽省', '340000', '滁州市', '341100', '明光市', '341182');
INSERT INTO `area_mapping` VALUES (1043, '安徽省', '340000', '阜阳市', '341200', '颍州区', '341202');
INSERT INTO `area_mapping` VALUES (1044, '安徽省', '340000', '阜阳市', '341200', '颍东区', '341203');
INSERT INTO `area_mapping` VALUES (1045, '安徽省', '340000', '阜阳市', '341200', '颍泉区', '341204');
INSERT INTO `area_mapping` VALUES (1046, '安徽省', '340000', '阜阳市', '341200', '临泉县', '341221');
INSERT INTO `area_mapping` VALUES (1047, '安徽省', '340000', '阜阳市', '341200', '太和县', '341222');
INSERT INTO `area_mapping` VALUES (1048, '安徽省', '340000', '阜阳市', '341200', '阜南县', '341225');
INSERT INTO `area_mapping` VALUES (1049, '安徽省', '340000', '阜阳市', '341200', '颍上县', '341226');
INSERT INTO `area_mapping` VALUES (1050, '安徽省', '340000', '阜阳市', '341200', '阜阳合肥现代产业园区', '341271');
INSERT INTO `area_mapping` VALUES (1051, '安徽省', '340000', '阜阳市', '341200', '阜阳经济技术开发区', '341272');
INSERT INTO `area_mapping` VALUES (1052, '安徽省', '340000', '阜阳市', '341200', '界首市', '341282');
INSERT INTO `area_mapping` VALUES (1053, '安徽省', '340000', '宿州市', '341300', '埇桥区', '341302');
INSERT INTO `area_mapping` VALUES (1054, '安徽省', '340000', '宿州市', '341300', '砀山县', '341321');
INSERT INTO `area_mapping` VALUES (1055, '安徽省', '340000', '宿州市', '341300', '萧县', '341322');
INSERT INTO `area_mapping` VALUES (1056, '安徽省', '340000', '宿州市', '341300', '灵璧县', '341323');
INSERT INTO `area_mapping` VALUES (1057, '安徽省', '340000', '宿州市', '341300', '泗县', '341324');
INSERT INTO `area_mapping` VALUES (1058, '安徽省', '340000', '宿州市', '341300', '宿州马鞍山现代产业园区', '341371');
INSERT INTO `area_mapping` VALUES (1059, '安徽省', '340000', '宿州市', '341300', '宿州经济技术开发区', '341372');
INSERT INTO `area_mapping` VALUES (1060, '安徽省', '340000', '六安市', '341500', '金安区', '341502');
INSERT INTO `area_mapping` VALUES (1061, '安徽省', '340000', '六安市', '341500', '裕安区', '341503');
INSERT INTO `area_mapping` VALUES (1062, '安徽省', '340000', '六安市', '341500', '叶集区', '341504');
INSERT INTO `area_mapping` VALUES (1063, '安徽省', '340000', '六安市', '341500', '霍邱县', '341522');
INSERT INTO `area_mapping` VALUES (1064, '安徽省', '340000', '六安市', '341500', '舒城县', '341523');
INSERT INTO `area_mapping` VALUES (1065, '安徽省', '340000', '六安市', '341500', '金寨县', '341524');
INSERT INTO `area_mapping` VALUES (1066, '安徽省', '340000', '六安市', '341500', '霍山县', '341525');
INSERT INTO `area_mapping` VALUES (1067, '安徽省', '340000', '亳州市', '341600', '谯城区', '341602');
INSERT INTO `area_mapping` VALUES (1068, '安徽省', '340000', '亳州市', '341600', '涡阳县', '341621');
INSERT INTO `area_mapping` VALUES (1069, '安徽省', '340000', '亳州市', '341600', '蒙城县', '341622');
INSERT INTO `area_mapping` VALUES (1070, '安徽省', '340000', '亳州市', '341600', '利辛县', '341623');
INSERT INTO `area_mapping` VALUES (1071, '安徽省', '340000', '池州市', '341700', '贵池区', '341702');
INSERT INTO `area_mapping` VALUES (1072, '安徽省', '340000', '池州市', '341700', '东至县', '341721');
INSERT INTO `area_mapping` VALUES (1073, '安徽省', '340000', '池州市', '341700', '石台县', '341722');
INSERT INTO `area_mapping` VALUES (1074, '安徽省', '340000', '池州市', '341700', '青阳县', '341723');
INSERT INTO `area_mapping` VALUES (1075, '安徽省', '340000', '宣城市', '341800', '宣州区', '341802');
INSERT INTO `area_mapping` VALUES (1076, '安徽省', '340000', '宣城市', '341800', '郎溪县', '341821');
INSERT INTO `area_mapping` VALUES (1077, '安徽省', '340000', '宣城市', '341800', '泾县', '341823');
INSERT INTO `area_mapping` VALUES (1078, '安徽省', '340000', '宣城市', '341800', '绩溪县', '341824');
INSERT INTO `area_mapping` VALUES (1079, '安徽省', '340000', '宣城市', '341800', '旌德县', '341825');
INSERT INTO `area_mapping` VALUES (1080, '安徽省', '340000', '宣城市', '341800', '宣城市经济开发区', '341871');
INSERT INTO `area_mapping` VALUES (1081, '安徽省', '340000', '宣城市', '341800', '宁国市', '341881');
INSERT INTO `area_mapping` VALUES (1082, '安徽省', '340000', '宣城市', '341800', '广德市', '341882');
INSERT INTO `area_mapping` VALUES (1083, '福建省', '350000', '福州市', '350100', '鼓楼区', '350102');
INSERT INTO `area_mapping` VALUES (1084, '福建省', '350000', '福州市', '350100', '台江区', '350103');
INSERT INTO `area_mapping` VALUES (1085, '福建省', '350000', '福州市', '350100', '仓山区', '350104');
INSERT INTO `area_mapping` VALUES (1086, '福建省', '350000', '福州市', '350100', '马尾区', '350105');
INSERT INTO `area_mapping` VALUES (1087, '福建省', '350000', '福州市', '350100', '晋安区', '350111');
INSERT INTO `area_mapping` VALUES (1088, '福建省', '350000', '福州市', '350100', '长乐区', '350112');
INSERT INTO `area_mapping` VALUES (1089, '福建省', '350000', '福州市', '350100', '闽侯县', '350121');
INSERT INTO `area_mapping` VALUES (1090, '福建省', '350000', '福州市', '350100', '连江县', '350122');
INSERT INTO `area_mapping` VALUES (1091, '福建省', '350000', '福州市', '350100', '罗源县', '350123');
INSERT INTO `area_mapping` VALUES (1092, '福建省', '350000', '福州市', '350100', '闽清县', '350124');
INSERT INTO `area_mapping` VALUES (1093, '福建省', '350000', '福州市', '350100', '永泰县', '350125');
INSERT INTO `area_mapping` VALUES (1094, '福建省', '350000', '福州市', '350100', '平潭县', '350128');
INSERT INTO `area_mapping` VALUES (1095, '福建省', '350000', '福州市', '350100', '福清市', '350181');
INSERT INTO `area_mapping` VALUES (1096, '福建省', '350000', '厦门市', '350200', '思明区', '350203');
INSERT INTO `area_mapping` VALUES (1097, '福建省', '350000', '厦门市', '350200', '海沧区', '350205');
INSERT INTO `area_mapping` VALUES (1098, '福建省', '350000', '厦门市', '350200', '湖里区', '350206');
INSERT INTO `area_mapping` VALUES (1099, '福建省', '350000', '厦门市', '350200', '集美区', '350211');
INSERT INTO `area_mapping` VALUES (1100, '福建省', '350000', '厦门市', '350200', '同安区', '350212');
INSERT INTO `area_mapping` VALUES (1101, '福建省', '350000', '厦门市', '350200', '翔安区', '350213');
INSERT INTO `area_mapping` VALUES (1102, '福建省', '350000', '莆田市', '350300', '城厢区', '350302');
INSERT INTO `area_mapping` VALUES (1103, '福建省', '350000', '莆田市', '350300', '涵江区', '350303');
INSERT INTO `area_mapping` VALUES (1104, '福建省', '350000', '莆田市', '350300', '荔城区', '350304');
INSERT INTO `area_mapping` VALUES (1105, '福建省', '350000', '莆田市', '350300', '秀屿区', '350305');
INSERT INTO `area_mapping` VALUES (1106, '福建省', '350000', '莆田市', '350300', '仙游县', '350322');
INSERT INTO `area_mapping` VALUES (1107, '福建省', '350000', '三明市', '350400', '梅列区', '350402');
INSERT INTO `area_mapping` VALUES (1108, '福建省', '350000', '三明市', '350400', '三元区', '350403');
INSERT INTO `area_mapping` VALUES (1109, '福建省', '350000', '三明市', '350400', '明溪县', '350421');
INSERT INTO `area_mapping` VALUES (1110, '福建省', '350000', '三明市', '350400', '清流县', '350423');
INSERT INTO `area_mapping` VALUES (1111, '福建省', '350000', '三明市', '350400', '宁化县', '350424');
INSERT INTO `area_mapping` VALUES (1112, '福建省', '350000', '三明市', '350400', '大田县', '350425');
INSERT INTO `area_mapping` VALUES (1113, '福建省', '350000', '三明市', '350400', '尤溪县', '350426');
INSERT INTO `area_mapping` VALUES (1114, '福建省', '350000', '三明市', '350400', '沙县', '350427');
INSERT INTO `area_mapping` VALUES (1115, '福建省', '350000', '三明市', '350400', '将乐县', '350428');
INSERT INTO `area_mapping` VALUES (1116, '福建省', '350000', '三明市', '350400', '泰宁县', '350429');
INSERT INTO `area_mapping` VALUES (1117, '福建省', '350000', '三明市', '350400', '建宁县', '350430');
INSERT INTO `area_mapping` VALUES (1118, '福建省', '350000', '三明市', '350400', '永安市', '350481');
INSERT INTO `area_mapping` VALUES (1119, '福建省', '350000', '泉州市', '350500', '鲤城区', '350502');
INSERT INTO `area_mapping` VALUES (1120, '福建省', '350000', '泉州市', '350500', '丰泽区', '350503');
INSERT INTO `area_mapping` VALUES (1121, '福建省', '350000', '泉州市', '350500', '洛江区', '350504');
INSERT INTO `area_mapping` VALUES (1122, '福建省', '350000', '泉州市', '350500', '泉港区', '350505');
INSERT INTO `area_mapping` VALUES (1123, '福建省', '350000', '泉州市', '350500', '惠安县', '350521');
INSERT INTO `area_mapping` VALUES (1124, '福建省', '350000', '泉州市', '350500', '安溪县', '350524');
INSERT INTO `area_mapping` VALUES (1125, '福建省', '350000', '泉州市', '350500', '永春县', '350525');
INSERT INTO `area_mapping` VALUES (1126, '福建省', '350000', '泉州市', '350500', '德化县', '350526');
INSERT INTO `area_mapping` VALUES (1127, '福建省', '350000', '泉州市', '350500', '金门县', '350527');
INSERT INTO `area_mapping` VALUES (1128, '福建省', '350000', '泉州市', '350500', '石狮市', '350581');
INSERT INTO `area_mapping` VALUES (1129, '福建省', '350000', '泉州市', '350500', '晋江市', '350582');
INSERT INTO `area_mapping` VALUES (1130, '福建省', '350000', '泉州市', '350500', '南安市', '350583');
INSERT INTO `area_mapping` VALUES (1131, '福建省', '350000', '漳州市', '350600', '芗城区', '350602');
INSERT INTO `area_mapping` VALUES (1132, '福建省', '350000', '漳州市', '350600', '龙文区', '350603');
INSERT INTO `area_mapping` VALUES (1133, '福建省', '350000', '漳州市', '350600', '云霄县', '350622');
INSERT INTO `area_mapping` VALUES (1134, '福建省', '350000', '漳州市', '350600', '漳浦县', '350623');
INSERT INTO `area_mapping` VALUES (1135, '福建省', '350000', '漳州市', '350600', '诏安县', '350624');
INSERT INTO `area_mapping` VALUES (1136, '福建省', '350000', '漳州市', '350600', '长泰县', '350625');
INSERT INTO `area_mapping` VALUES (1137, '福建省', '350000', '漳州市', '350600', '东山县', '350626');
INSERT INTO `area_mapping` VALUES (1138, '福建省', '350000', '漳州市', '350600', '南靖县', '350627');
INSERT INTO `area_mapping` VALUES (1139, '福建省', '350000', '漳州市', '350600', '平和县', '350628');
INSERT INTO `area_mapping` VALUES (1140, '福建省', '350000', '漳州市', '350600', '华安县', '350629');
INSERT INTO `area_mapping` VALUES (1141, '福建省', '350000', '漳州市', '350600', '龙海市', '350681');
INSERT INTO `area_mapping` VALUES (1142, '福建省', '350000', '南平市', '350700', '延平区', '350702');
INSERT INTO `area_mapping` VALUES (1143, '福建省', '350000', '南平市', '350700', '建阳区', '350703');
INSERT INTO `area_mapping` VALUES (1144, '福建省', '350000', '南平市', '350700', '顺昌县', '350721');
INSERT INTO `area_mapping` VALUES (1145, '福建省', '350000', '南平市', '350700', '浦城县', '350722');
INSERT INTO `area_mapping` VALUES (1146, '福建省', '350000', '南平市', '350700', '光泽县', '350723');
INSERT INTO `area_mapping` VALUES (1147, '福建省', '350000', '南平市', '350700', '松溪县', '350724');
INSERT INTO `area_mapping` VALUES (1148, '福建省', '350000', '南平市', '350700', '政和县', '350725');
INSERT INTO `area_mapping` VALUES (1149, '福建省', '350000', '南平市', '350700', '邵武市', '350781');
INSERT INTO `area_mapping` VALUES (1150, '福建省', '350000', '南平市', '350700', '武夷山市', '350782');
INSERT INTO `area_mapping` VALUES (1151, '福建省', '350000', '南平市', '350700', '建瓯市', '350783');
INSERT INTO `area_mapping` VALUES (1152, '福建省', '350000', '龙岩市', '350800', '新罗区', '350802');
INSERT INTO `area_mapping` VALUES (1153, '福建省', '350000', '龙岩市', '350800', '永定区', '350803');
INSERT INTO `area_mapping` VALUES (1154, '福建省', '350000', '龙岩市', '350800', '长汀县', '350821');
INSERT INTO `area_mapping` VALUES (1155, '福建省', '350000', '龙岩市', '350800', '上杭县', '350823');
INSERT INTO `area_mapping` VALUES (1156, '福建省', '350000', '龙岩市', '350800', '武平县', '350824');
INSERT INTO `area_mapping` VALUES (1157, '福建省', '350000', '龙岩市', '350800', '连城县', '350825');
INSERT INTO `area_mapping` VALUES (1158, '福建省', '350000', '龙岩市', '350800', '漳平市', '350881');
INSERT INTO `area_mapping` VALUES (1159, '福建省', '350000', '宁德市', '350900', '蕉城区', '350902');
INSERT INTO `area_mapping` VALUES (1160, '福建省', '350000', '宁德市', '350900', '霞浦县', '350921');
INSERT INTO `area_mapping` VALUES (1161, '福建省', '350000', '宁德市', '350900', '古田县', '350922');
INSERT INTO `area_mapping` VALUES (1162, '福建省', '350000', '宁德市', '350900', '屏南县', '350923');
INSERT INTO `area_mapping` VALUES (1163, '福建省', '350000', '宁德市', '350900', '寿宁县', '350924');
INSERT INTO `area_mapping` VALUES (1164, '福建省', '350000', '宁德市', '350900', '周宁县', '350925');
INSERT INTO `area_mapping` VALUES (1165, '福建省', '350000', '宁德市', '350900', '柘荣县', '350926');
INSERT INTO `area_mapping` VALUES (1166, '福建省', '350000', '宁德市', '350900', '福安市', '350981');
INSERT INTO `area_mapping` VALUES (1167, '福建省', '350000', '宁德市', '350900', '福鼎市', '350982');
INSERT INTO `area_mapping` VALUES (1168, '江西省', '360000', '南昌市', '360100', '东湖区', '360102');
INSERT INTO `area_mapping` VALUES (1169, '江西省', '360000', '南昌市', '360100', '西湖区', '360103');
INSERT INTO `area_mapping` VALUES (1170, '江西省', '360000', '南昌市', '360100', '青云谱区', '360104');
INSERT INTO `area_mapping` VALUES (1171, '江西省', '360000', '南昌市', '360100', '青山湖区', '360111');
INSERT INTO `area_mapping` VALUES (1172, '江西省', '360000', '南昌市', '360100', '新建区', '360112');
INSERT INTO `area_mapping` VALUES (1173, '江西省', '360000', '南昌市', '360100', '红谷滩区', '360113');
INSERT INTO `area_mapping` VALUES (1174, '江西省', '360000', '南昌市', '360100', '南昌县', '360121');
INSERT INTO `area_mapping` VALUES (1175, '江西省', '360000', '南昌市', '360100', '安义县', '360123');
INSERT INTO `area_mapping` VALUES (1176, '江西省', '360000', '南昌市', '360100', '进贤县', '360124');
INSERT INTO `area_mapping` VALUES (1177, '江西省', '360000', '景德镇市', '360200', '昌江区', '360202');
INSERT INTO `area_mapping` VALUES (1178, '江西省', '360000', '景德镇市', '360200', '珠山区', '360203');
INSERT INTO `area_mapping` VALUES (1179, '江西省', '360000', '景德镇市', '360200', '浮梁县', '360222');
INSERT INTO `area_mapping` VALUES (1180, '江西省', '360000', '景德镇市', '360200', '乐平市', '360281');
INSERT INTO `area_mapping` VALUES (1181, '江西省', '360000', '萍乡市', '360300', '安源区', '360302');
INSERT INTO `area_mapping` VALUES (1182, '江西省', '360000', '萍乡市', '360300', '湘东区', '360313');
INSERT INTO `area_mapping` VALUES (1183, '江西省', '360000', '萍乡市', '360300', '莲花县', '360321');
INSERT INTO `area_mapping` VALUES (1184, '江西省', '360000', '萍乡市', '360300', '上栗县', '360322');
INSERT INTO `area_mapping` VALUES (1185, '江西省', '360000', '萍乡市', '360300', '芦溪县', '360323');
INSERT INTO `area_mapping` VALUES (1186, '江西省', '360000', '九江市', '360400', '濂溪区', '360402');
INSERT INTO `area_mapping` VALUES (1187, '江西省', '360000', '九江市', '360400', '浔阳区', '360403');
INSERT INTO `area_mapping` VALUES (1188, '江西省', '360000', '九江市', '360400', '柴桑区', '360404');
INSERT INTO `area_mapping` VALUES (1189, '江西省', '360000', '九江市', '360400', '武宁县', '360423');
INSERT INTO `area_mapping` VALUES (1190, '江西省', '360000', '九江市', '360400', '修水县', '360424');
INSERT INTO `area_mapping` VALUES (1191, '江西省', '360000', '九江市', '360400', '永修县', '360425');
INSERT INTO `area_mapping` VALUES (1192, '江西省', '360000', '九江市', '360400', '德安县', '360426');
INSERT INTO `area_mapping` VALUES (1193, '江西省', '360000', '九江市', '360400', '都昌县', '360428');
INSERT INTO `area_mapping` VALUES (1194, '江西省', '360000', '九江市', '360400', '湖口县', '360429');
INSERT INTO `area_mapping` VALUES (1195, '江西省', '360000', '九江市', '360400', '彭泽县', '360430');
INSERT INTO `area_mapping` VALUES (1196, '江西省', '360000', '九江市', '360400', '瑞昌市', '360481');
INSERT INTO `area_mapping` VALUES (1197, '江西省', '360000', '九江市', '360400', '共青城市', '360482');
INSERT INTO `area_mapping` VALUES (1198, '江西省', '360000', '九江市', '360400', '庐山市', '360483');
INSERT INTO `area_mapping` VALUES (1199, '江西省', '360000', '新余市', '360500', '渝水区', '360502');
INSERT INTO `area_mapping` VALUES (1200, '江西省', '360000', '新余市', '360500', '分宜县', '360521');
INSERT INTO `area_mapping` VALUES (1201, '江西省', '360000', '鹰潭市', '360600', '月湖区', '360602');
INSERT INTO `area_mapping` VALUES (1202, '江西省', '360000', '鹰潭市', '360600', '余江区', '360603');
INSERT INTO `area_mapping` VALUES (1203, '江西省', '360000', '鹰潭市', '360600', '贵溪市', '360681');
INSERT INTO `area_mapping` VALUES (1204, '江西省', '360000', '赣州市', '360700', '章贡区', '360702');
INSERT INTO `area_mapping` VALUES (1205, '江西省', '360000', '赣州市', '360700', '南康区', '360703');
INSERT INTO `area_mapping` VALUES (1206, '江西省', '360000', '赣州市', '360700', '赣县区', '360704');
INSERT INTO `area_mapping` VALUES (1207, '江西省', '360000', '赣州市', '360700', '信丰县', '360722');
INSERT INTO `area_mapping` VALUES (1208, '江西省', '360000', '赣州市', '360700', '大余县', '360723');
INSERT INTO `area_mapping` VALUES (1209, '江西省', '360000', '赣州市', '360700', '上犹县', '360724');
INSERT INTO `area_mapping` VALUES (1210, '江西省', '360000', '赣州市', '360700', '崇义县', '360725');
INSERT INTO `area_mapping` VALUES (1211, '江西省', '360000', '赣州市', '360700', '安远县', '360726');
INSERT INTO `area_mapping` VALUES (1212, '江西省', '360000', '赣州市', '360700', '定南县', '360728');
INSERT INTO `area_mapping` VALUES (1213, '江西省', '360000', '赣州市', '360700', '全南县', '360729');
INSERT INTO `area_mapping` VALUES (1214, '江西省', '360000', '赣州市', '360700', '宁都县', '360730');
INSERT INTO `area_mapping` VALUES (1215, '江西省', '360000', '赣州市', '360700', '于都县', '360731');
INSERT INTO `area_mapping` VALUES (1216, '江西省', '360000', '赣州市', '360700', '兴国县', '360732');
INSERT INTO `area_mapping` VALUES (1217, '江西省', '360000', '赣州市', '360700', '会昌县', '360733');
INSERT INTO `area_mapping` VALUES (1218, '江西省', '360000', '赣州市', '360700', '寻乌县', '360734');
INSERT INTO `area_mapping` VALUES (1219, '江西省', '360000', '赣州市', '360700', '石城县', '360735');
INSERT INTO `area_mapping` VALUES (1220, '江西省', '360000', '赣州市', '360700', '瑞金市', '360781');
INSERT INTO `area_mapping` VALUES (1221, '江西省', '360000', '赣州市', '360700', '龙南市', '360783');
INSERT INTO `area_mapping` VALUES (1222, '江西省', '360000', '吉安市', '360800', '吉州区', '360802');
INSERT INTO `area_mapping` VALUES (1223, '江西省', '360000', '吉安市', '360800', '青原区', '360803');
INSERT INTO `area_mapping` VALUES (1224, '江西省', '360000', '吉安市', '360800', '吉安县', '360821');
INSERT INTO `area_mapping` VALUES (1225, '江西省', '360000', '吉安市', '360800', '吉水县', '360822');
INSERT INTO `area_mapping` VALUES (1226, '江西省', '360000', '吉安市', '360800', '峡江县', '360823');
INSERT INTO `area_mapping` VALUES (1227, '江西省', '360000', '吉安市', '360800', '新干县', '360824');
INSERT INTO `area_mapping` VALUES (1228, '江西省', '360000', '吉安市', '360800', '永丰县', '360825');
INSERT INTO `area_mapping` VALUES (1229, '江西省', '360000', '吉安市', '360800', '泰和县', '360826');
INSERT INTO `area_mapping` VALUES (1230, '江西省', '360000', '吉安市', '360800', '遂川县', '360827');
INSERT INTO `area_mapping` VALUES (1231, '江西省', '360000', '吉安市', '360800', '万安县', '360828');
INSERT INTO `area_mapping` VALUES (1232, '江西省', '360000', '吉安市', '360800', '安福县', '360829');
INSERT INTO `area_mapping` VALUES (1233, '江西省', '360000', '吉安市', '360800', '永新县', '360830');
INSERT INTO `area_mapping` VALUES (1234, '江西省', '360000', '吉安市', '360800', '井冈山市', '360881');
INSERT INTO `area_mapping` VALUES (1235, '江西省', '360000', '宜春市', '360900', '袁州区', '360902');
INSERT INTO `area_mapping` VALUES (1236, '江西省', '360000', '宜春市', '360900', '奉新县', '360921');
INSERT INTO `area_mapping` VALUES (1237, '江西省', '360000', '宜春市', '360900', '万载县', '360922');
INSERT INTO `area_mapping` VALUES (1238, '江西省', '360000', '宜春市', '360900', '上高县', '360923');
INSERT INTO `area_mapping` VALUES (1239, '江西省', '360000', '宜春市', '360900', '宜丰县', '360924');
INSERT INTO `area_mapping` VALUES (1240, '江西省', '360000', '宜春市', '360900', '靖安县', '360925');
INSERT INTO `area_mapping` VALUES (1241, '江西省', '360000', '宜春市', '360900', '铜鼓县', '360926');
INSERT INTO `area_mapping` VALUES (1242, '江西省', '360000', '宜春市', '360900', '丰城市', '360981');
INSERT INTO `area_mapping` VALUES (1243, '江西省', '360000', '宜春市', '360900', '樟树市', '360982');
INSERT INTO `area_mapping` VALUES (1244, '江西省', '360000', '宜春市', '360900', '高安市', '360983');
INSERT INTO `area_mapping` VALUES (1245, '江西省', '360000', '抚州市', '361000', '临川区', '361002');
INSERT INTO `area_mapping` VALUES (1246, '江西省', '360000', '抚州市', '361000', '东乡区', '361003');
INSERT INTO `area_mapping` VALUES (1247, '江西省', '360000', '抚州市', '361000', '南城县', '361021');
INSERT INTO `area_mapping` VALUES (1248, '江西省', '360000', '抚州市', '361000', '黎川县', '361022');
INSERT INTO `area_mapping` VALUES (1249, '江西省', '360000', '抚州市', '361000', '南丰县', '361023');
INSERT INTO `area_mapping` VALUES (1250, '江西省', '360000', '抚州市', '361000', '崇仁县', '361024');
INSERT INTO `area_mapping` VALUES (1251, '江西省', '360000', '抚州市', '361000', '乐安县', '361025');
INSERT INTO `area_mapping` VALUES (1252, '江西省', '360000', '抚州市', '361000', '宜黄县', '361026');
INSERT INTO `area_mapping` VALUES (1253, '江西省', '360000', '抚州市', '361000', '金溪县', '361027');
INSERT INTO `area_mapping` VALUES (1254, '江西省', '360000', '抚州市', '361000', '资溪县', '361028');
INSERT INTO `area_mapping` VALUES (1255, '江西省', '360000', '抚州市', '361000', '广昌县', '361030');
INSERT INTO `area_mapping` VALUES (1256, '江西省', '360000', '上饶市', '361100', '信州区', '361102');
INSERT INTO `area_mapping` VALUES (1257, '江西省', '360000', '上饶市', '361100', '广丰区', '361103');
INSERT INTO `area_mapping` VALUES (1258, '江西省', '360000', '上饶市', '361100', '广信区', '361104');
INSERT INTO `area_mapping` VALUES (1259, '江西省', '360000', '上饶市', '361100', '玉山县', '361123');
INSERT INTO `area_mapping` VALUES (1260, '江西省', '360000', '上饶市', '361100', '铅山县', '361124');
INSERT INTO `area_mapping` VALUES (1261, '江西省', '360000', '上饶市', '361100', '横峰县', '361125');
INSERT INTO `area_mapping` VALUES (1262, '江西省', '360000', '上饶市', '361100', '弋阳县', '361126');
INSERT INTO `area_mapping` VALUES (1263, '江西省', '360000', '上饶市', '361100', '余干县', '361127');
INSERT INTO `area_mapping` VALUES (1264, '江西省', '360000', '上饶市', '361100', '鄱阳县', '361128');
INSERT INTO `area_mapping` VALUES (1265, '江西省', '360000', '上饶市', '361100', '万年县', '361129');
INSERT INTO `area_mapping` VALUES (1266, '江西省', '360000', '上饶市', '361100', '婺源县', '361130');
INSERT INTO `area_mapping` VALUES (1267, '江西省', '360000', '上饶市', '361100', '德兴市', '361181');
INSERT INTO `area_mapping` VALUES (1268, '山东省', '370000', '济南市', '370100', '历下区', '370102');
INSERT INTO `area_mapping` VALUES (1269, '山东省', '370000', '济南市', '370100', '市中区', '370103');
INSERT INTO `area_mapping` VALUES (1270, '山东省', '370000', '济南市', '370100', '槐荫区', '370104');
INSERT INTO `area_mapping` VALUES (1271, '山东省', '370000', '济南市', '370100', '天桥区', '370105');
INSERT INTO `area_mapping` VALUES (1272, '山东省', '370000', '济南市', '370100', '历城区', '370112');
INSERT INTO `area_mapping` VALUES (1273, '山东省', '370000', '济南市', '370100', '长清区', '370113');
INSERT INTO `area_mapping` VALUES (1274, '山东省', '370000', '济南市', '370100', '章丘区', '370114');
INSERT INTO `area_mapping` VALUES (1275, '山东省', '370000', '济南市', '370100', '济阳区', '370115');
INSERT INTO `area_mapping` VALUES (1276, '山东省', '370000', '济南市', '370100', '莱芜区', '370116');
INSERT INTO `area_mapping` VALUES (1277, '山东省', '370000', '济南市', '370100', '钢城区', '370117');
INSERT INTO `area_mapping` VALUES (1278, '山东省', '370000', '济南市', '370100', '平阴县', '370124');
INSERT INTO `area_mapping` VALUES (1279, '山东省', '370000', '济南市', '370100', '商河县', '370126');
INSERT INTO `area_mapping` VALUES (1280, '山东省', '370000', '济南市', '370100', '济南高新技术产业开发区', '370171');
INSERT INTO `area_mapping` VALUES (1281, '山东省', '370000', '青岛市', '370200', '市南区', '370202');
INSERT INTO `area_mapping` VALUES (1282, '山东省', '370000', '青岛市', '370200', '市北区', '370203');
INSERT INTO `area_mapping` VALUES (1283, '山东省', '370000', '青岛市', '370200', '黄岛区', '370211');
INSERT INTO `area_mapping` VALUES (1284, '山东省', '370000', '青岛市', '370200', '崂山区', '370212');
INSERT INTO `area_mapping` VALUES (1285, '山东省', '370000', '青岛市', '370200', '李沧区', '370213');
INSERT INTO `area_mapping` VALUES (1286, '山东省', '370000', '青岛市', '370200', '城阳区', '370214');
INSERT INTO `area_mapping` VALUES (1287, '山东省', '370000', '青岛市', '370200', '即墨区', '370215');
INSERT INTO `area_mapping` VALUES (1288, '山东省', '370000', '青岛市', '370200', '青岛高新技术产业开发区', '370271');
INSERT INTO `area_mapping` VALUES (1289, '山东省', '370000', '青岛市', '370200', '胶州市', '370281');
INSERT INTO `area_mapping` VALUES (1290, '山东省', '370000', '青岛市', '370200', '平度市', '370283');
INSERT INTO `area_mapping` VALUES (1291, '山东省', '370000', '青岛市', '370200', '莱西市', '370285');
INSERT INTO `area_mapping` VALUES (1292, '山东省', '370000', '淄博市', '370300', '淄川区', '370302');
INSERT INTO `area_mapping` VALUES (1293, '山东省', '370000', '淄博市', '370300', '张店区', '370303');
INSERT INTO `area_mapping` VALUES (1294, '山东省', '370000', '淄博市', '370300', '博山区', '370304');
INSERT INTO `area_mapping` VALUES (1295, '山东省', '370000', '淄博市', '370300', '临淄区', '370305');
INSERT INTO `area_mapping` VALUES (1296, '山东省', '370000', '淄博市', '370300', '周村区', '370306');
INSERT INTO `area_mapping` VALUES (1297, '山东省', '370000', '淄博市', '370300', '桓台县', '370321');
INSERT INTO `area_mapping` VALUES (1298, '山东省', '370000', '淄博市', '370300', '高青县', '370322');
INSERT INTO `area_mapping` VALUES (1299, '山东省', '370000', '淄博市', '370300', '沂源县', '370323');
INSERT INTO `area_mapping` VALUES (1300, '山东省', '370000', '枣庄市', '370400', '市中区', '370402');
INSERT INTO `area_mapping` VALUES (1301, '山东省', '370000', '枣庄市', '370400', '薛城区', '370403');
INSERT INTO `area_mapping` VALUES (1302, '山东省', '370000', '枣庄市', '370400', '峄城区', '370404');
INSERT INTO `area_mapping` VALUES (1303, '山东省', '370000', '枣庄市', '370400', '台儿庄区', '370405');
INSERT INTO `area_mapping` VALUES (1304, '山东省', '370000', '枣庄市', '370400', '山亭区', '370406');
INSERT INTO `area_mapping` VALUES (1305, '山东省', '370000', '枣庄市', '370400', '滕州市', '370481');
INSERT INTO `area_mapping` VALUES (1306, '山东省', '370000', '东营市', '370500', '东营区', '370502');
INSERT INTO `area_mapping` VALUES (1307, '山东省', '370000', '东营市', '370500', '河口区', '370503');
INSERT INTO `area_mapping` VALUES (1308, '山东省', '370000', '东营市', '370500', '垦利区', '370505');
INSERT INTO `area_mapping` VALUES (1309, '山东省', '370000', '东营市', '370500', '利津县', '370522');
INSERT INTO `area_mapping` VALUES (1310, '山东省', '370000', '东营市', '370500', '广饶县', '370523');
INSERT INTO `area_mapping` VALUES (1311, '山东省', '370000', '东营市', '370500', '东营经济技术开发区', '370571');
INSERT INTO `area_mapping` VALUES (1312, '山东省', '370000', '东营市', '370500', '东营港经济开发区', '370572');
INSERT INTO `area_mapping` VALUES (1313, '山东省', '370000', '烟台市', '370600', '芝罘区', '370602');
INSERT INTO `area_mapping` VALUES (1314, '山东省', '370000', '烟台市', '370600', '福山区', '370611');
INSERT INTO `area_mapping` VALUES (1315, '山东省', '370000', '烟台市', '370600', '牟平区', '370612');
INSERT INTO `area_mapping` VALUES (1316, '山东省', '370000', '烟台市', '370600', '莱山区', '370613');
INSERT INTO `area_mapping` VALUES (1317, '山东省', '370000', '烟台市', '370600', '蓬莱区', '370614');
INSERT INTO `area_mapping` VALUES (1318, '山东省', '370000', '烟台市', '370600', '烟台高新技术产业开发区', '370671');
INSERT INTO `area_mapping` VALUES (1319, '山东省', '370000', '烟台市', '370600', '烟台经济技术开发区', '370672');
INSERT INTO `area_mapping` VALUES (1320, '山东省', '370000', '烟台市', '370600', '龙口市', '370681');
INSERT INTO `area_mapping` VALUES (1321, '山东省', '370000', '烟台市', '370600', '莱阳市', '370682');
INSERT INTO `area_mapping` VALUES (1322, '山东省', '370000', '烟台市', '370600', '莱州市', '370683');
INSERT INTO `area_mapping` VALUES (1323, '山东省', '370000', '烟台市', '370600', '招远市', '370685');
INSERT INTO `area_mapping` VALUES (1324, '山东省', '370000', '烟台市', '370600', '栖霞市', '370686');
INSERT INTO `area_mapping` VALUES (1325, '山东省', '370000', '烟台市', '370600', '海阳市', '370687');
INSERT INTO `area_mapping` VALUES (1326, '山东省', '370000', '潍坊市', '370700', '潍城区', '370702');
INSERT INTO `area_mapping` VALUES (1327, '山东省', '370000', '潍坊市', '370700', '寒亭区', '370703');
INSERT INTO `area_mapping` VALUES (1328, '山东省', '370000', '潍坊市', '370700', '坊子区', '370704');
INSERT INTO `area_mapping` VALUES (1329, '山东省', '370000', '潍坊市', '370700', '奎文区', '370705');
INSERT INTO `area_mapping` VALUES (1330, '山东省', '370000', '潍坊市', '370700', '临朐县', '370724');
INSERT INTO `area_mapping` VALUES (1331, '山东省', '370000', '潍坊市', '370700', '昌乐县', '370725');
INSERT INTO `area_mapping` VALUES (1332, '山东省', '370000', '潍坊市', '370700', '潍坊滨海经济技术开发区', '370772');
INSERT INTO `area_mapping` VALUES (1333, '山东省', '370000', '潍坊市', '370700', '青州市', '370781');
INSERT INTO `area_mapping` VALUES (1334, '山东省', '370000', '潍坊市', '370700', '诸城市', '370782');
INSERT INTO `area_mapping` VALUES (1335, '山东省', '370000', '潍坊市', '370700', '寿光市', '370783');
INSERT INTO `area_mapping` VALUES (1336, '山东省', '370000', '潍坊市', '370700', '安丘市', '370784');
INSERT INTO `area_mapping` VALUES (1337, '山东省', '370000', '潍坊市', '370700', '高密市', '370785');
INSERT INTO `area_mapping` VALUES (1338, '山东省', '370000', '潍坊市', '370700', '昌邑市', '370786');
INSERT INTO `area_mapping` VALUES (1339, '山东省', '370000', '济宁市', '370800', '任城区', '370811');
INSERT INTO `area_mapping` VALUES (1340, '山东省', '370000', '济宁市', '370800', '兖州区', '370812');
INSERT INTO `area_mapping` VALUES (1341, '山东省', '370000', '济宁市', '370800', '微山县', '370826');
INSERT INTO `area_mapping` VALUES (1342, '山东省', '370000', '济宁市', '370800', '鱼台县', '370827');
INSERT INTO `area_mapping` VALUES (1343, '山东省', '370000', '济宁市', '370800', '金乡县', '370828');
INSERT INTO `area_mapping` VALUES (1344, '山东省', '370000', '济宁市', '370800', '嘉祥县', '370829');
INSERT INTO `area_mapping` VALUES (1345, '山东省', '370000', '济宁市', '370800', '汶上县', '370830');
INSERT INTO `area_mapping` VALUES (1346, '山东省', '370000', '济宁市', '370800', '泗水县', '370831');
INSERT INTO `area_mapping` VALUES (1347, '山东省', '370000', '济宁市', '370800', '梁山县', '370832');
INSERT INTO `area_mapping` VALUES (1348, '山东省', '370000', '济宁市', '370800', '济宁高新技术产业开发区', '370871');
INSERT INTO `area_mapping` VALUES (1349, '山东省', '370000', '济宁市', '370800', '曲阜市', '370881');
INSERT INTO `area_mapping` VALUES (1350, '山东省', '370000', '济宁市', '370800', '邹城市', '370883');
INSERT INTO `area_mapping` VALUES (1351, '山东省', '370000', '泰安市', '370900', '泰山区', '370902');
INSERT INTO `area_mapping` VALUES (1352, '山东省', '370000', '泰安市', '370900', '岱岳区', '370911');
INSERT INTO `area_mapping` VALUES (1353, '山东省', '370000', '泰安市', '370900', '宁阳县', '370921');
INSERT INTO `area_mapping` VALUES (1354, '山东省', '370000', '泰安市', '370900', '东平县', '370923');
INSERT INTO `area_mapping` VALUES (1355, '山东省', '370000', '泰安市', '370900', '新泰市', '370982');
INSERT INTO `area_mapping` VALUES (1356, '山东省', '370000', '泰安市', '370900', '肥城市', '370983');
INSERT INTO `area_mapping` VALUES (1357, '山东省', '370000', '威海市', '371000', '环翠区', '371002');
INSERT INTO `area_mapping` VALUES (1358, '山东省', '370000', '威海市', '371000', '文登区', '371003');
INSERT INTO `area_mapping` VALUES (1359, '山东省', '370000', '威海市', '371000', '威海火炬高技术产业开发区', '371071');
INSERT INTO `area_mapping` VALUES (1360, '山东省', '370000', '威海市', '371000', '威海经济技术开发区', '371072');
INSERT INTO `area_mapping` VALUES (1361, '山东省', '370000', '威海市', '371000', '威海临港经济技术开发区', '371073');
INSERT INTO `area_mapping` VALUES (1362, '山东省', '370000', '威海市', '371000', '荣成市', '371082');
INSERT INTO `area_mapping` VALUES (1363, '山东省', '370000', '威海市', '371000', '乳山市', '371083');
INSERT INTO `area_mapping` VALUES (1364, '山东省', '370000', '日照市', '371100', '东港区', '371102');
INSERT INTO `area_mapping` VALUES (1365, '山东省', '370000', '日照市', '371100', '岚山区', '371103');
INSERT INTO `area_mapping` VALUES (1366, '山东省', '370000', '日照市', '371100', '五莲县', '371121');
INSERT INTO `area_mapping` VALUES (1367, '山东省', '370000', '日照市', '371100', '莒县', '371122');
INSERT INTO `area_mapping` VALUES (1368, '山东省', '370000', '日照市', '371100', '日照经济技术开发区', '371171');
INSERT INTO `area_mapping` VALUES (1369, '山东省', '370000', '临沂市', '371300', '兰山区', '371302');
INSERT INTO `area_mapping` VALUES (1370, '山东省', '370000', '临沂市', '371300', '罗庄区', '371311');
INSERT INTO `area_mapping` VALUES (1371, '山东省', '370000', '临沂市', '371300', '河东区', '371312');
INSERT INTO `area_mapping` VALUES (1372, '山东省', '370000', '临沂市', '371300', '沂南县', '371321');
INSERT INTO `area_mapping` VALUES (1373, '山东省', '370000', '临沂市', '371300', '郯城县', '371322');
INSERT INTO `area_mapping` VALUES (1374, '山东省', '370000', '临沂市', '371300', '沂水县', '371323');
INSERT INTO `area_mapping` VALUES (1375, '山东省', '370000', '临沂市', '371300', '兰陵县', '371324');
INSERT INTO `area_mapping` VALUES (1376, '山东省', '370000', '临沂市', '371300', '费县', '371325');
INSERT INTO `area_mapping` VALUES (1377, '山东省', '370000', '临沂市', '371300', '平邑县', '371326');
INSERT INTO `area_mapping` VALUES (1378, '山东省', '370000', '临沂市', '371300', '莒南县', '371327');
INSERT INTO `area_mapping` VALUES (1379, '山东省', '370000', '临沂市', '371300', '蒙阴县', '371328');
INSERT INTO `area_mapping` VALUES (1380, '山东省', '370000', '临沂市', '371300', '临沭县', '371329');
INSERT INTO `area_mapping` VALUES (1381, '山东省', '370000', '临沂市', '371300', '临沂高新技术产业开发区', '371371');
INSERT INTO `area_mapping` VALUES (1382, '山东省', '370000', '德州市', '371400', '德城区', '371402');
INSERT INTO `area_mapping` VALUES (1383, '山东省', '370000', '德州市', '371400', '陵城区', '371403');
INSERT INTO `area_mapping` VALUES (1384, '山东省', '370000', '德州市', '371400', '宁津县', '371422');
INSERT INTO `area_mapping` VALUES (1385, '山东省', '370000', '德州市', '371400', '庆云县', '371423');
INSERT INTO `area_mapping` VALUES (1386, '山东省', '370000', '德州市', '371400', '临邑县', '371424');
INSERT INTO `area_mapping` VALUES (1387, '山东省', '370000', '德州市', '371400', '齐河县', '371425');
INSERT INTO `area_mapping` VALUES (1388, '山东省', '370000', '德州市', '371400', '平原县', '371426');
INSERT INTO `area_mapping` VALUES (1389, '山东省', '370000', '德州市', '371400', '夏津县', '371427');
INSERT INTO `area_mapping` VALUES (1390, '山东省', '370000', '德州市', '371400', '武城县', '371428');
INSERT INTO `area_mapping` VALUES (1391, '山东省', '370000', '德州市', '371400', '德州经济技术开发区', '371471');
INSERT INTO `area_mapping` VALUES (1392, '山东省', '370000', '德州市', '371400', '德州运河经济开发区', '371472');
INSERT INTO `area_mapping` VALUES (1393, '山东省', '370000', '德州市', '371400', '乐陵市', '371481');
INSERT INTO `area_mapping` VALUES (1394, '山东省', '370000', '德州市', '371400', '禹城市', '371482');
INSERT INTO `area_mapping` VALUES (1395, '山东省', '370000', '聊城市', '371500', '东昌府区', '371502');
INSERT INTO `area_mapping` VALUES (1396, '山东省', '370000', '聊城市', '371500', '茌平区', '371503');
INSERT INTO `area_mapping` VALUES (1397, '山东省', '370000', '聊城市', '371500', '阳谷县', '371521');
INSERT INTO `area_mapping` VALUES (1398, '山东省', '370000', '聊城市', '371500', '莘县', '371522');
INSERT INTO `area_mapping` VALUES (1399, '山东省', '370000', '聊城市', '371500', '东阿县', '371524');
INSERT INTO `area_mapping` VALUES (1400, '山东省', '370000', '聊城市', '371500', '冠县', '371525');
INSERT INTO `area_mapping` VALUES (1401, '山东省', '370000', '聊城市', '371500', '高唐县', '371526');
INSERT INTO `area_mapping` VALUES (1402, '山东省', '370000', '聊城市', '371500', '临清市', '371581');
INSERT INTO `area_mapping` VALUES (1403, '山东省', '370000', '滨州市', '371600', '滨城区', '371602');
INSERT INTO `area_mapping` VALUES (1404, '山东省', '370000', '滨州市', '371600', '沾化区', '371603');
INSERT INTO `area_mapping` VALUES (1405, '山东省', '370000', '滨州市', '371600', '惠民县', '371621');
INSERT INTO `area_mapping` VALUES (1406, '山东省', '370000', '滨州市', '371600', '阳信县', '371622');
INSERT INTO `area_mapping` VALUES (1407, '山东省', '370000', '滨州市', '371600', '无棣县', '371623');
INSERT INTO `area_mapping` VALUES (1408, '山东省', '370000', '滨州市', '371600', '博兴县', '371625');
INSERT INTO `area_mapping` VALUES (1409, '山东省', '370000', '滨州市', '371600', '邹平市', '371681');
INSERT INTO `area_mapping` VALUES (1410, '山东省', '370000', '菏泽市', '371700', '牡丹区', '371702');
INSERT INTO `area_mapping` VALUES (1411, '山东省', '370000', '菏泽市', '371700', '定陶区', '371703');
INSERT INTO `area_mapping` VALUES (1412, '山东省', '370000', '菏泽市', '371700', '曹县', '371721');
INSERT INTO `area_mapping` VALUES (1413, '山东省', '370000', '菏泽市', '371700', '单县', '371722');
INSERT INTO `area_mapping` VALUES (1414, '山东省', '370000', '菏泽市', '371700', '成武县', '371723');
INSERT INTO `area_mapping` VALUES (1415, '山东省', '370000', '菏泽市', '371700', '巨野县', '371724');
INSERT INTO `area_mapping` VALUES (1416, '山东省', '370000', '菏泽市', '371700', '郓城县', '371725');
INSERT INTO `area_mapping` VALUES (1417, '山东省', '370000', '菏泽市', '371700', '鄄城县', '371726');
INSERT INTO `area_mapping` VALUES (1418, '山东省', '370000', '菏泽市', '371700', '东明县', '371728');
INSERT INTO `area_mapping` VALUES (1419, '山东省', '370000', '菏泽市', '371700', '菏泽经济技术开发区', '371771');
INSERT INTO `area_mapping` VALUES (1420, '山东省', '370000', '菏泽市', '371700', '菏泽高新技术开发区', '371772');
INSERT INTO `area_mapping` VALUES (1421, '河南省', '410000', '郑州市', '410100', '中原区', '410102');
INSERT INTO `area_mapping` VALUES (1422, '河南省', '410000', '郑州市', '410100', '二七区', '410103');
INSERT INTO `area_mapping` VALUES (1423, '河南省', '410000', '郑州市', '410100', '管城回族区', '410104');
INSERT INTO `area_mapping` VALUES (1424, '河南省', '410000', '郑州市', '410100', '金水区', '410105');
INSERT INTO `area_mapping` VALUES (1425, '河南省', '410000', '郑州市', '410100', '上街区', '410106');
INSERT INTO `area_mapping` VALUES (1426, '河南省', '410000', '郑州市', '410100', '惠济区', '410108');
INSERT INTO `area_mapping` VALUES (1427, '河南省', '410000', '郑州市', '410100', '中牟县', '410122');
INSERT INTO `area_mapping` VALUES (1428, '河南省', '410000', '郑州市', '410100', '郑州经济技术开发区', '410171');
INSERT INTO `area_mapping` VALUES (1429, '河南省', '410000', '郑州市', '410100', '郑州高新技术产业开发区', '410172');
INSERT INTO `area_mapping` VALUES (1430, '河南省', '410000', '郑州市', '410100', '郑州航空港经济综合实验区', '410173');
INSERT INTO `area_mapping` VALUES (1431, '河南省', '410000', '郑州市', '410100', '巩义市', '410181');
INSERT INTO `area_mapping` VALUES (1432, '河南省', '410000', '郑州市', '410100', '荥阳市', '410182');
INSERT INTO `area_mapping` VALUES (1433, '河南省', '410000', '郑州市', '410100', '新密市', '410183');
INSERT INTO `area_mapping` VALUES (1434, '河南省', '410000', '郑州市', '410100', '新郑市', '410184');
INSERT INTO `area_mapping` VALUES (1435, '河南省', '410000', '郑州市', '410100', '登封市', '410185');
INSERT INTO `area_mapping` VALUES (1436, '河南省', '410000', '开封市', '410200', '龙亭区', '410202');
INSERT INTO `area_mapping` VALUES (1437, '河南省', '410000', '开封市', '410200', '顺河回族区', '410203');
INSERT INTO `area_mapping` VALUES (1438, '河南省', '410000', '开封市', '410200', '鼓楼区', '410204');
INSERT INTO `area_mapping` VALUES (1439, '河南省', '410000', '开封市', '410200', '禹王台区', '410205');
INSERT INTO `area_mapping` VALUES (1440, '河南省', '410000', '开封市', '410200', '祥符区', '410212');
INSERT INTO `area_mapping` VALUES (1441, '河南省', '410000', '开封市', '410200', '杞县', '410221');
INSERT INTO `area_mapping` VALUES (1442, '河南省', '410000', '开封市', '410200', '通许县', '410222');
INSERT INTO `area_mapping` VALUES (1443, '河南省', '410000', '开封市', '410200', '尉氏县', '410223');
INSERT INTO `area_mapping` VALUES (1444, '河南省', '410000', '开封市', '410200', '兰考县', '410225');
INSERT INTO `area_mapping` VALUES (1445, '河南省', '410000', '洛阳市', '410300', '老城区', '410302');
INSERT INTO `area_mapping` VALUES (1446, '河南省', '410000', '洛阳市', '410300', '西工区', '410303');
INSERT INTO `area_mapping` VALUES (1447, '河南省', '410000', '洛阳市', '410300', '瀍河回族区', '410304');
INSERT INTO `area_mapping` VALUES (1448, '河南省', '410000', '洛阳市', '410300', '涧西区', '410305');
INSERT INTO `area_mapping` VALUES (1449, '河南省', '410000', '洛阳市', '410300', '吉利区', '410306');
INSERT INTO `area_mapping` VALUES (1450, '河南省', '410000', '洛阳市', '410300', '洛龙区', '410311');
INSERT INTO `area_mapping` VALUES (1451, '河南省', '410000', '洛阳市', '410300', '孟津县', '410322');
INSERT INTO `area_mapping` VALUES (1452, '河南省', '410000', '洛阳市', '410300', '新安县', '410323');
INSERT INTO `area_mapping` VALUES (1453, '河南省', '410000', '洛阳市', '410300', '栾川县', '410324');
INSERT INTO `area_mapping` VALUES (1454, '河南省', '410000', '洛阳市', '410300', '嵩县', '410325');
INSERT INTO `area_mapping` VALUES (1455, '河南省', '410000', '洛阳市', '410300', '汝阳县', '410326');
INSERT INTO `area_mapping` VALUES (1456, '河南省', '410000', '洛阳市', '410300', '宜阳县', '410327');
INSERT INTO `area_mapping` VALUES (1457, '河南省', '410000', '洛阳市', '410300', '洛宁县', '410328');
INSERT INTO `area_mapping` VALUES (1458, '河南省', '410000', '洛阳市', '410300', '伊川县', '410329');
INSERT INTO `area_mapping` VALUES (1459, '河南省', '410000', '洛阳市', '410300', '洛阳高新技术产业开发区', '410371');
INSERT INTO `area_mapping` VALUES (1460, '河南省', '410000', '洛阳市', '410300', '偃师市', '410381');
INSERT INTO `area_mapping` VALUES (1461, '河南省', '410000', '平顶山市', '410400', '新华区', '410402');
INSERT INTO `area_mapping` VALUES (1462, '河南省', '410000', '平顶山市', '410400', '卫东区', '410403');
INSERT INTO `area_mapping` VALUES (1463, '河南省', '410000', '平顶山市', '410400', '石龙区', '410404');
INSERT INTO `area_mapping` VALUES (1464, '河南省', '410000', '平顶山市', '410400', '湛河区', '410411');
INSERT INTO `area_mapping` VALUES (1465, '河南省', '410000', '平顶山市', '410400', '宝丰县', '410421');
INSERT INTO `area_mapping` VALUES (1466, '河南省', '410000', '平顶山市', '410400', '叶县', '410422');
INSERT INTO `area_mapping` VALUES (1467, '河南省', '410000', '平顶山市', '410400', '鲁山县', '410423');
INSERT INTO `area_mapping` VALUES (1468, '河南省', '410000', '平顶山市', '410400', '郏县', '410425');
INSERT INTO `area_mapping` VALUES (1469, '河南省', '410000', '平顶山市', '410400', '平顶山高新技术产业开发区', '410471');
INSERT INTO `area_mapping` VALUES (1470, '河南省', '410000', '平顶山市', '410400', '平顶山市城乡一体化示范区', '410472');
INSERT INTO `area_mapping` VALUES (1471, '河南省', '410000', '平顶山市', '410400', '舞钢市', '410481');
INSERT INTO `area_mapping` VALUES (1472, '河南省', '410000', '平顶山市', '410400', '汝州市', '410482');
INSERT INTO `area_mapping` VALUES (1473, '河南省', '410000', '安阳市', '410500', '文峰区', '410502');
INSERT INTO `area_mapping` VALUES (1474, '河南省', '410000', '安阳市', '410500', '北关区', '410503');
INSERT INTO `area_mapping` VALUES (1475, '河南省', '410000', '安阳市', '410500', '殷都区', '410505');
INSERT INTO `area_mapping` VALUES (1476, '河南省', '410000', '安阳市', '410500', '龙安区', '410506');
INSERT INTO `area_mapping` VALUES (1477, '河南省', '410000', '安阳市', '410500', '安阳县', '410522');
INSERT INTO `area_mapping` VALUES (1478, '河南省', '410000', '安阳市', '410500', '汤阴县', '410523');
INSERT INTO `area_mapping` VALUES (1479, '河南省', '410000', '安阳市', '410500', '滑县', '410526');
INSERT INTO `area_mapping` VALUES (1480, '河南省', '410000', '安阳市', '410500', '内黄县', '410527');
INSERT INTO `area_mapping` VALUES (1481, '河南省', '410000', '安阳市', '410500', '安阳高新技术产业开发区', '410571');
INSERT INTO `area_mapping` VALUES (1482, '河南省', '410000', '安阳市', '410500', '林州市', '410581');
INSERT INTO `area_mapping` VALUES (1483, '河南省', '410000', '鹤壁市', '410600', '鹤山区', '410602');
INSERT INTO `area_mapping` VALUES (1484, '河南省', '410000', '鹤壁市', '410600', '山城区', '410603');
INSERT INTO `area_mapping` VALUES (1485, '河南省', '410000', '鹤壁市', '410600', '淇滨区', '410611');
INSERT INTO `area_mapping` VALUES (1486, '河南省', '410000', '鹤壁市', '410600', '浚县', '410621');
INSERT INTO `area_mapping` VALUES (1487, '河南省', '410000', '鹤壁市', '410600', '淇县', '410622');
INSERT INTO `area_mapping` VALUES (1488, '河南省', '410000', '鹤壁市', '410600', '鹤壁经济技术开发区', '410671');
INSERT INTO `area_mapping` VALUES (1489, '河南省', '410000', '新乡市', '410700', '红旗区', '410702');
INSERT INTO `area_mapping` VALUES (1490, '河南省', '410000', '新乡市', '410700', '卫滨区', '410703');
INSERT INTO `area_mapping` VALUES (1491, '河南省', '410000', '新乡市', '410700', '凤泉区', '410704');
INSERT INTO `area_mapping` VALUES (1492, '河南省', '410000', '新乡市', '410700', '牧野区', '410711');
INSERT INTO `area_mapping` VALUES (1493, '河南省', '410000', '新乡市', '410700', '新乡县', '410721');
INSERT INTO `area_mapping` VALUES (1494, '河南省', '410000', '新乡市', '410700', '获嘉县', '410724');
INSERT INTO `area_mapping` VALUES (1495, '河南省', '410000', '新乡市', '410700', '原阳县', '410725');
INSERT INTO `area_mapping` VALUES (1496, '河南省', '410000', '新乡市', '410700', '延津县', '410726');
INSERT INTO `area_mapping` VALUES (1497, '河南省', '410000', '新乡市', '410700', '封丘县', '410727');
INSERT INTO `area_mapping` VALUES (1498, '河南省', '410000', '新乡市', '410700', '新乡高新技术产业开发区', '410771');
INSERT INTO `area_mapping` VALUES (1499, '河南省', '410000', '新乡市', '410700', '新乡经济技术开发区', '410772');
INSERT INTO `area_mapping` VALUES (1500, '河南省', '410000', '新乡市', '410700', '新乡市平原城乡一体化示范区', '410773');
INSERT INTO `area_mapping` VALUES (1501, '河南省', '410000', '新乡市', '410700', '卫辉市', '410781');
INSERT INTO `area_mapping` VALUES (1502, '河南省', '410000', '新乡市', '410700', '辉县市', '410782');
INSERT INTO `area_mapping` VALUES (1503, '河南省', '410000', '新乡市', '410700', '长垣市', '410783');
INSERT INTO `area_mapping` VALUES (1504, '河南省', '410000', '焦作市', '410800', '解放区', '410802');
INSERT INTO `area_mapping` VALUES (1505, '河南省', '410000', '焦作市', '410800', '中站区', '410803');
INSERT INTO `area_mapping` VALUES (1506, '河南省', '410000', '焦作市', '410800', '马村区', '410804');
INSERT INTO `area_mapping` VALUES (1507, '河南省', '410000', '焦作市', '410800', '山阳区', '410811');
INSERT INTO `area_mapping` VALUES (1508, '河南省', '410000', '焦作市', '410800', '修武县', '410821');
INSERT INTO `area_mapping` VALUES (1509, '河南省', '410000', '焦作市', '410800', '博爱县', '410822');
INSERT INTO `area_mapping` VALUES (1510, '河南省', '410000', '焦作市', '410800', '武陟县', '410823');
INSERT INTO `area_mapping` VALUES (1511, '河南省', '410000', '焦作市', '410800', '温县', '410825');
INSERT INTO `area_mapping` VALUES (1512, '河南省', '410000', '焦作市', '410800', '焦作城乡一体化示范区', '410871');
INSERT INTO `area_mapping` VALUES (1513, '河南省', '410000', '焦作市', '410800', '沁阳市', '410882');
INSERT INTO `area_mapping` VALUES (1514, '河南省', '410000', '焦作市', '410800', '孟州市', '410883');
INSERT INTO `area_mapping` VALUES (1515, '河南省', '410000', '濮阳市', '410900', '华龙区', '410902');
INSERT INTO `area_mapping` VALUES (1516, '河南省', '410000', '濮阳市', '410900', '清丰县', '410922');
INSERT INTO `area_mapping` VALUES (1517, '河南省', '410000', '濮阳市', '410900', '南乐县', '410923');
INSERT INTO `area_mapping` VALUES (1518, '河南省', '410000', '濮阳市', '410900', '范县', '410926');
INSERT INTO `area_mapping` VALUES (1519, '河南省', '410000', '濮阳市', '410900', '台前县', '410927');
INSERT INTO `area_mapping` VALUES (1520, '河南省', '410000', '濮阳市', '410900', '濮阳县', '410928');
INSERT INTO `area_mapping` VALUES (1521, '河南省', '410000', '濮阳市', '410900', '河南濮阳工业园区', '410971');
INSERT INTO `area_mapping` VALUES (1522, '河南省', '410000', '濮阳市', '410900', '濮阳经济技术开发区', '410972');
INSERT INTO `area_mapping` VALUES (1523, '河南省', '410000', '许昌市', '411000', '魏都区', '411002');
INSERT INTO `area_mapping` VALUES (1524, '河南省', '410000', '许昌市', '411000', '建安区', '411003');
INSERT INTO `area_mapping` VALUES (1525, '河南省', '410000', '许昌市', '411000', '鄢陵县', '411024');
INSERT INTO `area_mapping` VALUES (1526, '河南省', '410000', '许昌市', '411000', '襄城县', '411025');
INSERT INTO `area_mapping` VALUES (1527, '河南省', '410000', '许昌市', '411000', '许昌经济技术开发区', '411071');
INSERT INTO `area_mapping` VALUES (1528, '河南省', '410000', '许昌市', '411000', '禹州市', '411081');
INSERT INTO `area_mapping` VALUES (1529, '河南省', '410000', '许昌市', '411000', '长葛市', '411082');
INSERT INTO `area_mapping` VALUES (1530, '河南省', '410000', '漯河市', '411100', '源汇区', '411102');
INSERT INTO `area_mapping` VALUES (1531, '河南省', '410000', '漯河市', '411100', '郾城区', '411103');
INSERT INTO `area_mapping` VALUES (1532, '河南省', '410000', '漯河市', '411100', '召陵区', '411104');
INSERT INTO `area_mapping` VALUES (1533, '河南省', '410000', '漯河市', '411100', '舞阳县', '411121');
INSERT INTO `area_mapping` VALUES (1534, '河南省', '410000', '漯河市', '411100', '临颍县', '411122');
INSERT INTO `area_mapping` VALUES (1535, '河南省', '410000', '漯河市', '411100', '漯河经济技术开发区', '411171');
INSERT INTO `area_mapping` VALUES (1536, '河南省', '410000', '三门峡市', '411200', '湖滨区', '411202');
INSERT INTO `area_mapping` VALUES (1537, '河南省', '410000', '三门峡市', '411200', '陕州区', '411203');
INSERT INTO `area_mapping` VALUES (1538, '河南省', '410000', '三门峡市', '411200', '渑池县', '411221');
INSERT INTO `area_mapping` VALUES (1539, '河南省', '410000', '三门峡市', '411200', '卢氏县', '411224');
INSERT INTO `area_mapping` VALUES (1540, '河南省', '410000', '三门峡市', '411200', '河南三门峡经济开发区', '411271');
INSERT INTO `area_mapping` VALUES (1541, '河南省', '410000', '三门峡市', '411200', '义马市', '411281');
INSERT INTO `area_mapping` VALUES (1542, '河南省', '410000', '三门峡市', '411200', '灵宝市', '411282');
INSERT INTO `area_mapping` VALUES (1543, '河南省', '410000', '南阳市', '411300', '宛城区', '411302');
INSERT INTO `area_mapping` VALUES (1544, '河南省', '410000', '南阳市', '411300', '卧龙区', '411303');
INSERT INTO `area_mapping` VALUES (1545, '河南省', '410000', '南阳市', '411300', '南召县', '411321');
INSERT INTO `area_mapping` VALUES (1546, '河南省', '410000', '南阳市', '411300', '方城县', '411322');
INSERT INTO `area_mapping` VALUES (1547, '河南省', '410000', '南阳市', '411300', '西峡县', '411323');
INSERT INTO `area_mapping` VALUES (1548, '河南省', '410000', '南阳市', '411300', '镇平县', '411324');
INSERT INTO `area_mapping` VALUES (1549, '河南省', '410000', '南阳市', '411300', '内乡县', '411325');
INSERT INTO `area_mapping` VALUES (1550, '河南省', '410000', '南阳市', '411300', '淅川县', '411326');
INSERT INTO `area_mapping` VALUES (1551, '河南省', '410000', '南阳市', '411300', '社旗县', '411327');
INSERT INTO `area_mapping` VALUES (1552, '河南省', '410000', '南阳市', '411300', '唐河县', '411328');
INSERT INTO `area_mapping` VALUES (1553, '河南省', '410000', '南阳市', '411300', '新野县', '411329');
INSERT INTO `area_mapping` VALUES (1554, '河南省', '410000', '南阳市', '411300', '桐柏县', '411330');
INSERT INTO `area_mapping` VALUES (1555, '河南省', '410000', '南阳市', '411300', '南阳高新技术产业开发区', '411371');
INSERT INTO `area_mapping` VALUES (1556, '河南省', '410000', '南阳市', '411300', '南阳市城乡一体化示范区', '411372');
INSERT INTO `area_mapping` VALUES (1557, '河南省', '410000', '南阳市', '411300', '邓州市', '411381');
INSERT INTO `area_mapping` VALUES (1558, '河南省', '410000', '商丘市', '411400', '梁园区', '411402');
INSERT INTO `area_mapping` VALUES (1559, '河南省', '410000', '商丘市', '411400', '睢阳区', '411403');
INSERT INTO `area_mapping` VALUES (1560, '河南省', '410000', '商丘市', '411400', '民权县', '411421');
INSERT INTO `area_mapping` VALUES (1561, '河南省', '410000', '商丘市', '411400', '睢县', '411422');
INSERT INTO `area_mapping` VALUES (1562, '河南省', '410000', '商丘市', '411400', '宁陵县', '411423');
INSERT INTO `area_mapping` VALUES (1563, '河南省', '410000', '商丘市', '411400', '柘城县', '411424');
INSERT INTO `area_mapping` VALUES (1564, '河南省', '410000', '商丘市', '411400', '虞城县', '411425');
INSERT INTO `area_mapping` VALUES (1565, '河南省', '410000', '商丘市', '411400', '夏邑县', '411426');
INSERT INTO `area_mapping` VALUES (1566, '河南省', '410000', '商丘市', '411400', '豫东综合物流产业聚集区', '411471');
INSERT INTO `area_mapping` VALUES (1567, '河南省', '410000', '商丘市', '411400', '河南商丘经济开发区', '411472');
INSERT INTO `area_mapping` VALUES (1568, '河南省', '410000', '商丘市', '411400', '永城市', '411481');
INSERT INTO `area_mapping` VALUES (1569, '河南省', '410000', '信阳市', '411500', '浉河区', '411502');
INSERT INTO `area_mapping` VALUES (1570, '河南省', '410000', '信阳市', '411500', '平桥区', '411503');
INSERT INTO `area_mapping` VALUES (1571, '河南省', '410000', '信阳市', '411500', '罗山县', '411521');
INSERT INTO `area_mapping` VALUES (1572, '河南省', '410000', '信阳市', '411500', '光山县', '411522');
INSERT INTO `area_mapping` VALUES (1573, '河南省', '410000', '信阳市', '411500', '新县', '411523');
INSERT INTO `area_mapping` VALUES (1574, '河南省', '410000', '信阳市', '411500', '商城县', '411524');
INSERT INTO `area_mapping` VALUES (1575, '河南省', '410000', '信阳市', '411500', '固始县', '411525');
INSERT INTO `area_mapping` VALUES (1576, '河南省', '410000', '信阳市', '411500', '潢川县', '411526');
INSERT INTO `area_mapping` VALUES (1577, '河南省', '410000', '信阳市', '411500', '淮滨县', '411527');
INSERT INTO `area_mapping` VALUES (1578, '河南省', '410000', '信阳市', '411500', '息县', '411528');
INSERT INTO `area_mapping` VALUES (1579, '河南省', '410000', '信阳市', '411500', '信阳高新技术产业开发区', '411571');
INSERT INTO `area_mapping` VALUES (1580, '河南省', '410000', '周口市', '411600', '川汇区', '411602');
INSERT INTO `area_mapping` VALUES (1581, '河南省', '410000', '周口市', '411600', '淮阳区', '411603');
INSERT INTO `area_mapping` VALUES (1582, '河南省', '410000', '周口市', '411600', '扶沟县', '411621');
INSERT INTO `area_mapping` VALUES (1583, '河南省', '410000', '周口市', '411600', '西华县', '411622');
INSERT INTO `area_mapping` VALUES (1584, '河南省', '410000', '周口市', '411600', '商水县', '411623');
INSERT INTO `area_mapping` VALUES (1585, '河南省', '410000', '周口市', '411600', '沈丘县', '411624');
INSERT INTO `area_mapping` VALUES (1586, '河南省', '410000', '周口市', '411600', '郸城县', '411625');
INSERT INTO `area_mapping` VALUES (1587, '河南省', '410000', '周口市', '411600', '太康县', '411627');
INSERT INTO `area_mapping` VALUES (1588, '河南省', '410000', '周口市', '411600', '鹿邑县', '411628');
INSERT INTO `area_mapping` VALUES (1589, '河南省', '410000', '周口市', '411600', '河南周口经济开发区', '411671');
INSERT INTO `area_mapping` VALUES (1590, '河南省', '410000', '周口市', '411600', '项城市', '411681');
INSERT INTO `area_mapping` VALUES (1591, '河南省', '410000', '驻马店市', '411700', '驿城区', '411702');
INSERT INTO `area_mapping` VALUES (1592, '河南省', '410000', '驻马店市', '411700', '西平县', '411721');
INSERT INTO `area_mapping` VALUES (1593, '河南省', '410000', '驻马店市', '411700', '上蔡县', '411722');
INSERT INTO `area_mapping` VALUES (1594, '河南省', '410000', '驻马店市', '411700', '平舆县', '411723');
INSERT INTO `area_mapping` VALUES (1595, '河南省', '410000', '驻马店市', '411700', '正阳县', '411724');
INSERT INTO `area_mapping` VALUES (1596, '河南省', '410000', '驻马店市', '411700', '确山县', '411725');
INSERT INTO `area_mapping` VALUES (1597, '河南省', '410000', '驻马店市', '411700', '泌阳县', '411726');
INSERT INTO `area_mapping` VALUES (1598, '河南省', '410000', '驻马店市', '411700', '汝南县', '411727');
INSERT INTO `area_mapping` VALUES (1599, '河南省', '410000', '驻马店市', '411700', '遂平县', '411728');
INSERT INTO `area_mapping` VALUES (1600, '河南省', '410000', '驻马店市', '411700', '新蔡县', '411729');
INSERT INTO `area_mapping` VALUES (1601, '河南省', '410000', '驻马店市', '411700', '河南驻马店经济开发区', '411771');
INSERT INTO `area_mapping` VALUES (1602, '河南省', '410000', '省直辖县级行政区划', '419000', '济源市', '419001');
INSERT INTO `area_mapping` VALUES (1603, '湖北省', '420000', '武汉市', '420100', '江岸区', '420102');
INSERT INTO `area_mapping` VALUES (1604, '湖北省', '420000', '武汉市', '420100', '江汉区', '420103');
INSERT INTO `area_mapping` VALUES (1605, '湖北省', '420000', '武汉市', '420100', '硚口区', '420104');
INSERT INTO `area_mapping` VALUES (1606, '湖北省', '420000', '武汉市', '420100', '汉阳区', '420105');
INSERT INTO `area_mapping` VALUES (1607, '湖北省', '420000', '武汉市', '420100', '武昌区', '420106');
INSERT INTO `area_mapping` VALUES (1608, '湖北省', '420000', '武汉市', '420100', '青山区', '420107');
INSERT INTO `area_mapping` VALUES (1609, '湖北省', '420000', '武汉市', '420100', '洪山区', '420111');
INSERT INTO `area_mapping` VALUES (1610, '湖北省', '420000', '武汉市', '420100', '东西湖区', '420112');
INSERT INTO `area_mapping` VALUES (1611, '湖北省', '420000', '武汉市', '420100', '汉南区', '420113');
INSERT INTO `area_mapping` VALUES (1612, '湖北省', '420000', '武汉市', '420100', '蔡甸区', '420114');
INSERT INTO `area_mapping` VALUES (1613, '湖北省', '420000', '武汉市', '420100', '江夏区', '420115');
INSERT INTO `area_mapping` VALUES (1614, '湖北省', '420000', '武汉市', '420100', '黄陂区', '420116');
INSERT INTO `area_mapping` VALUES (1615, '湖北省', '420000', '武汉市', '420100', '新洲区', '420117');
INSERT INTO `area_mapping` VALUES (1616, '湖北省', '420000', '黄石市', '420200', '黄石港区', '420202');
INSERT INTO `area_mapping` VALUES (1617, '湖北省', '420000', '黄石市', '420200', '西塞山区', '420203');
INSERT INTO `area_mapping` VALUES (1618, '湖北省', '420000', '黄石市', '420200', '下陆区', '420204');
INSERT INTO `area_mapping` VALUES (1619, '湖北省', '420000', '黄石市', '420200', '铁山区', '420205');
INSERT INTO `area_mapping` VALUES (1620, '湖北省', '420000', '黄石市', '420200', '阳新县', '420222');
INSERT INTO `area_mapping` VALUES (1621, '湖北省', '420000', '黄石市', '420200', '大冶市', '420281');
INSERT INTO `area_mapping` VALUES (1622, '湖北省', '420000', '十堰市', '420300', '茅箭区', '420302');
INSERT INTO `area_mapping` VALUES (1623, '湖北省', '420000', '十堰市', '420300', '张湾区', '420303');
INSERT INTO `area_mapping` VALUES (1624, '湖北省', '420000', '十堰市', '420300', '郧阳区', '420304');
INSERT INTO `area_mapping` VALUES (1625, '湖北省', '420000', '十堰市', '420300', '郧西县', '420322');
INSERT INTO `area_mapping` VALUES (1626, '湖北省', '420000', '十堰市', '420300', '竹山县', '420323');
INSERT INTO `area_mapping` VALUES (1627, '湖北省', '420000', '十堰市', '420300', '竹溪县', '420324');
INSERT INTO `area_mapping` VALUES (1628, '湖北省', '420000', '十堰市', '420300', '房县', '420325');
INSERT INTO `area_mapping` VALUES (1629, '湖北省', '420000', '十堰市', '420300', '丹江口市', '420381');
INSERT INTO `area_mapping` VALUES (1630, '湖北省', '420000', '宜昌市', '420500', '西陵区', '420502');
INSERT INTO `area_mapping` VALUES (1631, '湖北省', '420000', '宜昌市', '420500', '伍家岗区', '420503');
INSERT INTO `area_mapping` VALUES (1632, '湖北省', '420000', '宜昌市', '420500', '点军区', '420504');
INSERT INTO `area_mapping` VALUES (1633, '湖北省', '420000', '宜昌市', '420500', '猇亭区', '420505');
INSERT INTO `area_mapping` VALUES (1634, '湖北省', '420000', '宜昌市', '420500', '夷陵区', '420506');
INSERT INTO `area_mapping` VALUES (1635, '湖北省', '420000', '宜昌市', '420500', '远安县', '420525');
INSERT INTO `area_mapping` VALUES (1636, '湖北省', '420000', '宜昌市', '420500', '兴山县', '420526');
INSERT INTO `area_mapping` VALUES (1637, '湖北省', '420000', '宜昌市', '420500', '秭归县', '420527');
INSERT INTO `area_mapping` VALUES (1638, '湖北省', '420000', '宜昌市', '420500', '长阳土家族自治县', '420528');
INSERT INTO `area_mapping` VALUES (1639, '湖北省', '420000', '宜昌市', '420500', '五峰土家族自治县', '420529');
INSERT INTO `area_mapping` VALUES (1640, '湖北省', '420000', '宜昌市', '420500', '宜都市', '420581');
INSERT INTO `area_mapping` VALUES (1641, '湖北省', '420000', '宜昌市', '420500', '当阳市', '420582');
INSERT INTO `area_mapping` VALUES (1642, '湖北省', '420000', '宜昌市', '420500', '枝江市', '420583');
INSERT INTO `area_mapping` VALUES (1643, '湖北省', '420000', '襄阳市', '420600', '襄城区', '420602');
INSERT INTO `area_mapping` VALUES (1644, '湖北省', '420000', '襄阳市', '420600', '樊城区', '420606');
INSERT INTO `area_mapping` VALUES (1645, '湖北省', '420000', '襄阳市', '420600', '襄州区', '420607');
INSERT INTO `area_mapping` VALUES (1646, '湖北省', '420000', '襄阳市', '420600', '南漳县', '420624');
INSERT INTO `area_mapping` VALUES (1647, '湖北省', '420000', '襄阳市', '420600', '谷城县', '420625');
INSERT INTO `area_mapping` VALUES (1648, '湖北省', '420000', '襄阳市', '420600', '保康县', '420626');
INSERT INTO `area_mapping` VALUES (1649, '湖北省', '420000', '襄阳市', '420600', '老河口市', '420682');
INSERT INTO `area_mapping` VALUES (1650, '湖北省', '420000', '襄阳市', '420600', '枣阳市', '420683');
INSERT INTO `area_mapping` VALUES (1651, '湖北省', '420000', '襄阳市', '420600', '宜城市', '420684');
INSERT INTO `area_mapping` VALUES (1652, '湖北省', '420000', '鄂州市', '420700', '梁子湖区', '420702');
INSERT INTO `area_mapping` VALUES (1653, '湖北省', '420000', '鄂州市', '420700', '华容区', '420703');
INSERT INTO `area_mapping` VALUES (1654, '湖北省', '420000', '鄂州市', '420700', '鄂城区', '420704');
INSERT INTO `area_mapping` VALUES (1655, '湖北省', '420000', '荆门市', '420800', '东宝区', '420802');
INSERT INTO `area_mapping` VALUES (1656, '湖北省', '420000', '荆门市', '420800', '掇刀区', '420804');
INSERT INTO `area_mapping` VALUES (1657, '湖北省', '420000', '荆门市', '420800', '沙洋县', '420822');
INSERT INTO `area_mapping` VALUES (1658, '湖北省', '420000', '荆门市', '420800', '钟祥市', '420881');
INSERT INTO `area_mapping` VALUES (1659, '湖北省', '420000', '荆门市', '420800', '京山市', '420882');
INSERT INTO `area_mapping` VALUES (1660, '湖北省', '420000', '孝感市', '420900', '孝南区', '420902');
INSERT INTO `area_mapping` VALUES (1661, '湖北省', '420000', '孝感市', '420900', '孝昌县', '420921');
INSERT INTO `area_mapping` VALUES (1662, '湖北省', '420000', '孝感市', '420900', '大悟县', '420922');
INSERT INTO `area_mapping` VALUES (1663, '湖北省', '420000', '孝感市', '420900', '云梦县', '420923');
INSERT INTO `area_mapping` VALUES (1664, '湖北省', '420000', '孝感市', '420900', '应城市', '420981');
INSERT INTO `area_mapping` VALUES (1665, '湖北省', '420000', '孝感市', '420900', '安陆市', '420982');
INSERT INTO `area_mapping` VALUES (1666, '湖北省', '420000', '孝感市', '420900', '汉川市', '420984');
INSERT INTO `area_mapping` VALUES (1667, '湖北省', '420000', '荆州市', '421000', '沙市区', '421002');
INSERT INTO `area_mapping` VALUES (1668, '湖北省', '420000', '荆州市', '421000', '荆州区', '421003');
INSERT INTO `area_mapping` VALUES (1669, '湖北省', '420000', '荆州市', '421000', '公安县', '421022');
INSERT INTO `area_mapping` VALUES (1670, '湖北省', '420000', '荆州市', '421000', '监利县', '421023');
INSERT INTO `area_mapping` VALUES (1671, '湖北省', '420000', '荆州市', '421000', '江陵县', '421024');
INSERT INTO `area_mapping` VALUES (1672, '湖北省', '420000', '荆州市', '421000', '荆州经济技术开发区', '421071');
INSERT INTO `area_mapping` VALUES (1673, '湖北省', '420000', '荆州市', '421000', '石首市', '421081');
INSERT INTO `area_mapping` VALUES (1674, '湖北省', '420000', '荆州市', '421000', '洪湖市', '421083');
INSERT INTO `area_mapping` VALUES (1675, '湖北省', '420000', '荆州市', '421000', '松滋市', '421087');
INSERT INTO `area_mapping` VALUES (1676, '湖北省', '420000', '黄冈市', '421100', '黄州区', '421102');
INSERT INTO `area_mapping` VALUES (1677, '湖北省', '420000', '黄冈市', '421100', '团风县', '421121');
INSERT INTO `area_mapping` VALUES (1678, '湖北省', '420000', '黄冈市', '421100', '红安县', '421122');
INSERT INTO `area_mapping` VALUES (1679, '湖北省', '420000', '黄冈市', '421100', '罗田县', '421123');
INSERT INTO `area_mapping` VALUES (1680, '湖北省', '420000', '黄冈市', '421100', '英山县', '421124');
INSERT INTO `area_mapping` VALUES (1681, '湖北省', '420000', '黄冈市', '421100', '浠水县', '421125');
INSERT INTO `area_mapping` VALUES (1682, '湖北省', '420000', '黄冈市', '421100', '蕲春县', '421126');
INSERT INTO `area_mapping` VALUES (1683, '湖北省', '420000', '黄冈市', '421100', '黄梅县', '421127');
INSERT INTO `area_mapping` VALUES (1684, '湖北省', '420000', '黄冈市', '421100', '龙感湖管理区', '421171');
INSERT INTO `area_mapping` VALUES (1685, '湖北省', '420000', '黄冈市', '421100', '麻城市', '421181');
INSERT INTO `area_mapping` VALUES (1686, '湖北省', '420000', '黄冈市', '421100', '武穴市', '421182');
INSERT INTO `area_mapping` VALUES (1687, '湖北省', '420000', '咸宁市', '421200', '咸安区', '421202');
INSERT INTO `area_mapping` VALUES (1688, '湖北省', '420000', '咸宁市', '421200', '嘉鱼县', '421221');
INSERT INTO `area_mapping` VALUES (1689, '湖北省', '420000', '咸宁市', '421200', '通城县', '421222');
INSERT INTO `area_mapping` VALUES (1690, '湖北省', '420000', '咸宁市', '421200', '崇阳县', '421223');
INSERT INTO `area_mapping` VALUES (1691, '湖北省', '420000', '咸宁市', '421200', '通山县', '421224');
INSERT INTO `area_mapping` VALUES (1692, '湖北省', '420000', '咸宁市', '421200', '赤壁市', '421281');
INSERT INTO `area_mapping` VALUES (1693, '湖北省', '420000', '随州市', '421300', '曾都区', '421303');
INSERT INTO `area_mapping` VALUES (1694, '湖北省', '420000', '随州市', '421300', '随县', '421321');
INSERT INTO `area_mapping` VALUES (1695, '湖北省', '420000', '随州市', '421300', '广水市', '421381');
INSERT INTO `area_mapping` VALUES (1696, '湖北省', '420000', '恩施土家族苗族自治州', '422800', '恩施市', '422801');
INSERT INTO `area_mapping` VALUES (1697, '湖北省', '420000', '恩施土家族苗族自治州', '422800', '利川市', '422802');
INSERT INTO `area_mapping` VALUES (1698, '湖北省', '420000', '恩施土家族苗族自治州', '422800', '建始县', '422822');
INSERT INTO `area_mapping` VALUES (1699, '湖北省', '420000', '恩施土家族苗族自治州', '422800', '巴东县', '422823');
INSERT INTO `area_mapping` VALUES (1700, '湖北省', '420000', '恩施土家族苗族自治州', '422800', '宣恩县', '422825');
INSERT INTO `area_mapping` VALUES (1701, '湖北省', '420000', '恩施土家族苗族自治州', '422800', '咸丰县', '422826');
INSERT INTO `area_mapping` VALUES (1702, '湖北省', '420000', '恩施土家族苗族自治州', '422800', '来凤县', '422827');
INSERT INTO `area_mapping` VALUES (1703, '湖北省', '420000', '恩施土家族苗族自治州', '422800', '鹤峰县', '422828');
INSERT INTO `area_mapping` VALUES (1704, '湖北省', '420000', '省直辖县级行政区划', '429000', '仙桃市', '429004');
INSERT INTO `area_mapping` VALUES (1705, '湖北省', '420000', '省直辖县级行政区划', '429000', '潜江市', '429005');
INSERT INTO `area_mapping` VALUES (1706, '湖北省', '420000', '省直辖县级行政区划', '429000', '天门市', '429006');
INSERT INTO `area_mapping` VALUES (1707, '湖北省', '420000', '省直辖县级行政区划', '429000', '神农架林区', '429021');
INSERT INTO `area_mapping` VALUES (1708, '湖南省', '430000', '长沙市', '430100', '芙蓉区', '430102');
INSERT INTO `area_mapping` VALUES (1709, '湖南省', '430000', '长沙市', '430100', '天心区', '430103');
INSERT INTO `area_mapping` VALUES (1710, '湖南省', '430000', '长沙市', '430100', '岳麓区', '430104');
INSERT INTO `area_mapping` VALUES (1711, '湖南省', '430000', '长沙市', '430100', '开福区', '430105');
INSERT INTO `area_mapping` VALUES (1712, '湖南省', '430000', '长沙市', '430100', '雨花区', '430111');
INSERT INTO `area_mapping` VALUES (1713, '湖南省', '430000', '长沙市', '430100', '望城区', '430112');
INSERT INTO `area_mapping` VALUES (1714, '湖南省', '430000', '长沙市', '430100', '长沙县', '430121');
INSERT INTO `area_mapping` VALUES (1715, '湖南省', '430000', '长沙市', '430100', '浏阳市', '430181');
INSERT INTO `area_mapping` VALUES (1716, '湖南省', '430000', '长沙市', '430100', '宁乡市', '430182');
INSERT INTO `area_mapping` VALUES (1717, '湖南省', '430000', '株洲市', '430200', '荷塘区', '430202');
INSERT INTO `area_mapping` VALUES (1718, '湖南省', '430000', '株洲市', '430200', '芦淞区', '430203');
INSERT INTO `area_mapping` VALUES (1719, '湖南省', '430000', '株洲市', '430200', '石峰区', '430204');
INSERT INTO `area_mapping` VALUES (1720, '湖南省', '430000', '株洲市', '430200', '天元区', '430211');
INSERT INTO `area_mapping` VALUES (1721, '湖南省', '430000', '株洲市', '430200', '渌口区', '430212');
INSERT INTO `area_mapping` VALUES (1722, '湖南省', '430000', '株洲市', '430200', '攸县', '430223');
INSERT INTO `area_mapping` VALUES (1723, '湖南省', '430000', '株洲市', '430200', '茶陵县', '430224');
INSERT INTO `area_mapping` VALUES (1724, '湖南省', '430000', '株洲市', '430200', '炎陵县', '430225');
INSERT INTO `area_mapping` VALUES (1725, '湖南省', '430000', '株洲市', '430200', '云龙示范区', '430271');
INSERT INTO `area_mapping` VALUES (1726, '湖南省', '430000', '株洲市', '430200', '醴陵市', '430281');
INSERT INTO `area_mapping` VALUES (1727, '湖南省', '430000', '湘潭市', '430300', '雨湖区', '430302');
INSERT INTO `area_mapping` VALUES (1728, '湖南省', '430000', '湘潭市', '430300', '岳塘区', '430304');
INSERT INTO `area_mapping` VALUES (1729, '湖南省', '430000', '湘潭市', '430300', '湘潭县', '430321');
INSERT INTO `area_mapping` VALUES (1730, '湖南省', '430000', '湘潭市', '430300', '湖南湘潭高新技术产业园区', '430371');
INSERT INTO `area_mapping` VALUES (1731, '湖南省', '430000', '湘潭市', '430300', '湘潭昭山示范区', '430372');
INSERT INTO `area_mapping` VALUES (1732, '湖南省', '430000', '湘潭市', '430300', '湘潭九华示范区', '430373');
INSERT INTO `area_mapping` VALUES (1733, '湖南省', '430000', '湘潭市', '430300', '湘乡市', '430381');
INSERT INTO `area_mapping` VALUES (1734, '湖南省', '430000', '湘潭市', '430300', '韶山市', '430382');
INSERT INTO `area_mapping` VALUES (1735, '湖南省', '430000', '衡阳市', '430400', '珠晖区', '430405');
INSERT INTO `area_mapping` VALUES (1736, '湖南省', '430000', '衡阳市', '430400', '雁峰区', '430406');
INSERT INTO `area_mapping` VALUES (1737, '湖南省', '430000', '衡阳市', '430400', '石鼓区', '430407');
INSERT INTO `area_mapping` VALUES (1738, '湖南省', '430000', '衡阳市', '430400', '蒸湘区', '430408');
INSERT INTO `area_mapping` VALUES (1739, '湖南省', '430000', '衡阳市', '430400', '南岳区', '430412');
INSERT INTO `area_mapping` VALUES (1740, '湖南省', '430000', '衡阳市', '430400', '衡阳县', '430421');
INSERT INTO `area_mapping` VALUES (1741, '湖南省', '430000', '衡阳市', '430400', '衡南县', '430422');
INSERT INTO `area_mapping` VALUES (1742, '湖南省', '430000', '衡阳市', '430400', '衡山县', '430423');
INSERT INTO `area_mapping` VALUES (1743, '湖南省', '430000', '衡阳市', '430400', '衡东县', '430424');
INSERT INTO `area_mapping` VALUES (1744, '湖南省', '430000', '衡阳市', '430400', '祁东县', '430426');
INSERT INTO `area_mapping` VALUES (1745, '湖南省', '430000', '衡阳市', '430400', '衡阳综合保税区', '430471');
INSERT INTO `area_mapping` VALUES (1746, '湖南省', '430000', '衡阳市', '430400', '湖南衡阳高新技术产业园区', '430472');
INSERT INTO `area_mapping` VALUES (1747, '湖南省', '430000', '衡阳市', '430400', '湖南衡阳松木经济开发区', '430473');
INSERT INTO `area_mapping` VALUES (1748, '湖南省', '430000', '衡阳市', '430400', '耒阳市', '430481');
INSERT INTO `area_mapping` VALUES (1749, '湖南省', '430000', '衡阳市', '430400', '常宁市', '430482');
INSERT INTO `area_mapping` VALUES (1750, '湖南省', '430000', '邵阳市', '430500', '双清区', '430502');
INSERT INTO `area_mapping` VALUES (1751, '湖南省', '430000', '邵阳市', '430500', '大祥区', '430503');
INSERT INTO `area_mapping` VALUES (1752, '湖南省', '430000', '邵阳市', '430500', '北塔区', '430511');
INSERT INTO `area_mapping` VALUES (1753, '湖南省', '430000', '邵阳市', '430500', '新邵县', '430522');
INSERT INTO `area_mapping` VALUES (1754, '湖南省', '430000', '邵阳市', '430500', '邵阳县', '430523');
INSERT INTO `area_mapping` VALUES (1755, '湖南省', '430000', '邵阳市', '430500', '隆回县', '430524');
INSERT INTO `area_mapping` VALUES (1756, '湖南省', '430000', '邵阳市', '430500', '洞口县', '430525');
INSERT INTO `area_mapping` VALUES (1757, '湖南省', '430000', '邵阳市', '430500', '绥宁县', '430527');
INSERT INTO `area_mapping` VALUES (1758, '湖南省', '430000', '邵阳市', '430500', '新宁县', '430528');
INSERT INTO `area_mapping` VALUES (1759, '湖南省', '430000', '邵阳市', '430500', '城步苗族自治县', '430529');
INSERT INTO `area_mapping` VALUES (1760, '湖南省', '430000', '邵阳市', '430500', '武冈市', '430581');
INSERT INTO `area_mapping` VALUES (1761, '湖南省', '430000', '邵阳市', '430500', '邵东市', '430582');
INSERT INTO `area_mapping` VALUES (1762, '湖南省', '430000', '岳阳市', '430600', '岳阳楼区', '430602');
INSERT INTO `area_mapping` VALUES (1763, '湖南省', '430000', '岳阳市', '430600', '云溪区', '430603');
INSERT INTO `area_mapping` VALUES (1764, '湖南省', '430000', '岳阳市', '430600', '君山区', '430611');
INSERT INTO `area_mapping` VALUES (1765, '湖南省', '430000', '岳阳市', '430600', '岳阳县', '430621');
INSERT INTO `area_mapping` VALUES (1766, '湖南省', '430000', '岳阳市', '430600', '华容县', '430623');
INSERT INTO `area_mapping` VALUES (1767, '湖南省', '430000', '岳阳市', '430600', '湘阴县', '430624');
INSERT INTO `area_mapping` VALUES (1768, '湖南省', '430000', '岳阳市', '430600', '平江县', '430626');
INSERT INTO `area_mapping` VALUES (1769, '湖南省', '430000', '岳阳市', '430600', '岳阳市屈原管理区', '430671');
INSERT INTO `area_mapping` VALUES (1770, '湖南省', '430000', '岳阳市', '430600', '汨罗市', '430681');
INSERT INTO `area_mapping` VALUES (1771, '湖南省', '430000', '岳阳市', '430600', '临湘市', '430682');
INSERT INTO `area_mapping` VALUES (1772, '湖南省', '430000', '常德市', '430700', '武陵区', '430702');
INSERT INTO `area_mapping` VALUES (1773, '湖南省', '430000', '常德市', '430700', '鼎城区', '430703');
INSERT INTO `area_mapping` VALUES (1774, '湖南省', '430000', '常德市', '430700', '安乡县', '430721');
INSERT INTO `area_mapping` VALUES (1775, '湖南省', '430000', '常德市', '430700', '汉寿县', '430722');
INSERT INTO `area_mapping` VALUES (1776, '湖南省', '430000', '常德市', '430700', '澧县', '430723');
INSERT INTO `area_mapping` VALUES (1777, '湖南省', '430000', '常德市', '430700', '临澧县', '430724');
INSERT INTO `area_mapping` VALUES (1778, '湖南省', '430000', '常德市', '430700', '桃源县', '430725');
INSERT INTO `area_mapping` VALUES (1779, '湖南省', '430000', '常德市', '430700', '石门县', '430726');
INSERT INTO `area_mapping` VALUES (1780, '湖南省', '430000', '常德市', '430700', '常德市西洞庭管理区', '430771');
INSERT INTO `area_mapping` VALUES (1781, '湖南省', '430000', '常德市', '430700', '津市市', '430781');
INSERT INTO `area_mapping` VALUES (1782, '湖南省', '430000', '张家界市', '430800', '永定区', '430802');
INSERT INTO `area_mapping` VALUES (1783, '湖南省', '430000', '张家界市', '430800', '武陵源区', '430811');
INSERT INTO `area_mapping` VALUES (1784, '湖南省', '430000', '张家界市', '430800', '慈利县', '430821');
INSERT INTO `area_mapping` VALUES (1785, '湖南省', '430000', '张家界市', '430800', '桑植县', '430822');
INSERT INTO `area_mapping` VALUES (1786, '湖南省', '430000', '益阳市', '430900', '资阳区', '430902');
INSERT INTO `area_mapping` VALUES (1787, '湖南省', '430000', '益阳市', '430900', '赫山区', '430903');
INSERT INTO `area_mapping` VALUES (1788, '湖南省', '430000', '益阳市', '430900', '南县', '430921');
INSERT INTO `area_mapping` VALUES (1789, '湖南省', '430000', '益阳市', '430900', '桃江县', '430922');
INSERT INTO `area_mapping` VALUES (1790, '湖南省', '430000', '益阳市', '430900', '安化县', '430923');
INSERT INTO `area_mapping` VALUES (1791, '湖南省', '430000', '益阳市', '430900', '益阳市大通湖管理区', '430971');
INSERT INTO `area_mapping` VALUES (1792, '湖南省', '430000', '益阳市', '430900', '湖南益阳高新技术产业园区', '430972');
INSERT INTO `area_mapping` VALUES (1793, '湖南省', '430000', '益阳市', '430900', '沅江市', '430981');
INSERT INTO `area_mapping` VALUES (1794, '湖南省', '430000', '郴州市', '431000', '北湖区', '431002');
INSERT INTO `area_mapping` VALUES (1795, '湖南省', '430000', '郴州市', '431000', '苏仙区', '431003');
INSERT INTO `area_mapping` VALUES (1796, '湖南省', '430000', '郴州市', '431000', '桂阳县', '431021');
INSERT INTO `area_mapping` VALUES (1797, '湖南省', '430000', '郴州市', '431000', '宜章县', '431022');
INSERT INTO `area_mapping` VALUES (1798, '湖南省', '430000', '郴州市', '431000', '永兴县', '431023');
INSERT INTO `area_mapping` VALUES (1799, '湖南省', '430000', '郴州市', '431000', '嘉禾县', '431024');
INSERT INTO `area_mapping` VALUES (1800, '湖南省', '430000', '郴州市', '431000', '临武县', '431025');
INSERT INTO `area_mapping` VALUES (1801, '湖南省', '430000', '郴州市', '431000', '汝城县', '431026');
INSERT INTO `area_mapping` VALUES (1802, '湖南省', '430000', '郴州市', '431000', '桂东县', '431027');
INSERT INTO `area_mapping` VALUES (1803, '湖南省', '430000', '郴州市', '431000', '安仁县', '431028');
INSERT INTO `area_mapping` VALUES (1804, '湖南省', '430000', '郴州市', '431000', '资兴市', '431081');
INSERT INTO `area_mapping` VALUES (1805, '湖南省', '430000', '永州市', '431100', '零陵区', '431102');
INSERT INTO `area_mapping` VALUES (1806, '湖南省', '430000', '永州市', '431100', '冷水滩区', '431103');
INSERT INTO `area_mapping` VALUES (1807, '湖南省', '430000', '永州市', '431100', '祁阳县', '431121');
INSERT INTO `area_mapping` VALUES (1808, '湖南省', '430000', '永州市', '431100', '东安县', '431122');
INSERT INTO `area_mapping` VALUES (1809, '湖南省', '430000', '永州市', '431100', '双牌县', '431123');
INSERT INTO `area_mapping` VALUES (1810, '湖南省', '430000', '永州市', '431100', '道县', '431124');
INSERT INTO `area_mapping` VALUES (1811, '湖南省', '430000', '永州市', '431100', '江永县', '431125');
INSERT INTO `area_mapping` VALUES (1812, '湖南省', '430000', '永州市', '431100', '宁远县', '431126');
INSERT INTO `area_mapping` VALUES (1813, '湖南省', '430000', '永州市', '431100', '蓝山县', '431127');
INSERT INTO `area_mapping` VALUES (1814, '湖南省', '430000', '永州市', '431100', '新田县', '431128');
INSERT INTO `area_mapping` VALUES (1815, '湖南省', '430000', '永州市', '431100', '江华瑶族自治县', '431129');
INSERT INTO `area_mapping` VALUES (1816, '湖南省', '430000', '永州市', '431100', '永州经济技术开发区', '431171');
INSERT INTO `area_mapping` VALUES (1817, '湖南省', '430000', '永州市', '431100', '永州市金洞管理区', '431172');
INSERT INTO `area_mapping` VALUES (1818, '湖南省', '430000', '永州市', '431100', '永州市回龙圩管理区', '431173');
INSERT INTO `area_mapping` VALUES (1819, '湖南省', '430000', '怀化市', '431200', '鹤城区', '431202');
INSERT INTO `area_mapping` VALUES (1820, '湖南省', '430000', '怀化市', '431200', '中方县', '431221');
INSERT INTO `area_mapping` VALUES (1821, '湖南省', '430000', '怀化市', '431200', '沅陵县', '431222');
INSERT INTO `area_mapping` VALUES (1822, '湖南省', '430000', '怀化市', '431200', '辰溪县', '431223');
INSERT INTO `area_mapping` VALUES (1823, '湖南省', '430000', '怀化市', '431200', '溆浦县', '431224');
INSERT INTO `area_mapping` VALUES (1824, '湖南省', '430000', '怀化市', '431200', '会同县', '431225');
INSERT INTO `area_mapping` VALUES (1825, '湖南省', '430000', '怀化市', '431200', '麻阳苗族自治县', '431226');
INSERT INTO `area_mapping` VALUES (1826, '湖南省', '430000', '怀化市', '431200', '新晃侗族自治县', '431227');
INSERT INTO `area_mapping` VALUES (1827, '湖南省', '430000', '怀化市', '431200', '芷江侗族自治县', '431228');
INSERT INTO `area_mapping` VALUES (1828, '湖南省', '430000', '怀化市', '431200', '靖州苗族侗族自治县', '431229');
INSERT INTO `area_mapping` VALUES (1829, '湖南省', '430000', '怀化市', '431200', '通道侗族自治县', '431230');
INSERT INTO `area_mapping` VALUES (1830, '湖南省', '430000', '怀化市', '431200', '怀化市洪江管理区', '431271');
INSERT INTO `area_mapping` VALUES (1831, '湖南省', '430000', '怀化市', '431200', '洪江市', '431281');
INSERT INTO `area_mapping` VALUES (1832, '湖南省', '430000', '娄底市', '431300', '娄星区', '431302');
INSERT INTO `area_mapping` VALUES (1833, '湖南省', '430000', '娄底市', '431300', '双峰县', '431321');
INSERT INTO `area_mapping` VALUES (1834, '湖南省', '430000', '娄底市', '431300', '新化县', '431322');
INSERT INTO `area_mapping` VALUES (1835, '湖南省', '430000', '娄底市', '431300', '冷水江市', '431381');
INSERT INTO `area_mapping` VALUES (1836, '湖南省', '430000', '娄底市', '431300', '涟源市', '431382');
INSERT INTO `area_mapping` VALUES (1837, '湖南省', '430000', '湘西土家族苗族自治州', '433100', '吉首市', '433101');
INSERT INTO `area_mapping` VALUES (1838, '湖南省', '430000', '湘西土家族苗族自治州', '433100', '泸溪县', '433122');
INSERT INTO `area_mapping` VALUES (1839, '湖南省', '430000', '湘西土家族苗族自治州', '433100', '凤凰县', '433123');
INSERT INTO `area_mapping` VALUES (1840, '湖南省', '430000', '湘西土家族苗族自治州', '433100', '花垣县', '433124');
INSERT INTO `area_mapping` VALUES (1841, '湖南省', '430000', '湘西土家族苗族自治州', '433100', '保靖县', '433125');
INSERT INTO `area_mapping` VALUES (1842, '湖南省', '430000', '湘西土家族苗族自治州', '433100', '古丈县', '433126');
INSERT INTO `area_mapping` VALUES (1843, '湖南省', '430000', '湘西土家族苗族自治州', '433100', '永顺县', '433127');
INSERT INTO `area_mapping` VALUES (1844, '湖南省', '430000', '湘西土家族苗族自治州', '433100', '龙山县', '433130');
INSERT INTO `area_mapping` VALUES (1845, '广东省', '440000', '广州市', '440100', '荔湾区', '440103');
INSERT INTO `area_mapping` VALUES (1846, '广东省', '440000', '广州市', '440100', '越秀区', '440104');
INSERT INTO `area_mapping` VALUES (1847, '广东省', '440000', '广州市', '440100', '海珠区', '440105');
INSERT INTO `area_mapping` VALUES (1848, '广东省', '440000', '广州市', '440100', '天河区', '440106');
INSERT INTO `area_mapping` VALUES (1849, '广东省', '440000', '广州市', '440100', '白云区', '440111');
INSERT INTO `area_mapping` VALUES (1850, '广东省', '440000', '广州市', '440100', '黄埔区', '440112');
INSERT INTO `area_mapping` VALUES (1851, '广东省', '440000', '广州市', '440100', '番禺区', '440113');
INSERT INTO `area_mapping` VALUES (1852, '广东省', '440000', '广州市', '440100', '花都区', '440114');
INSERT INTO `area_mapping` VALUES (1853, '广东省', '440000', '广州市', '440100', '南沙区', '440115');
INSERT INTO `area_mapping` VALUES (1854, '广东省', '440000', '广州市', '440100', '从化区', '440117');
INSERT INTO `area_mapping` VALUES (1855, '广东省', '440000', '广州市', '440100', '增城区', '440118');
INSERT INTO `area_mapping` VALUES (1856, '广东省', '440000', '韶关市', '440200', '武江区', '440203');
INSERT INTO `area_mapping` VALUES (1857, '广东省', '440000', '韶关市', '440200', '浈江区', '440204');
INSERT INTO `area_mapping` VALUES (1858, '广东省', '440000', '韶关市', '440200', '曲江区', '440205');
INSERT INTO `area_mapping` VALUES (1859, '广东省', '440000', '韶关市', '440200', '始兴县', '440222');
INSERT INTO `area_mapping` VALUES (1860, '广东省', '440000', '韶关市', '440200', '仁化县', '440224');
INSERT INTO `area_mapping` VALUES (1861, '广东省', '440000', '韶关市', '440200', '翁源县', '440229');
INSERT INTO `area_mapping` VALUES (1862, '广东省', '440000', '韶关市', '440200', '乳源瑶族自治县', '440232');
INSERT INTO `area_mapping` VALUES (1863, '广东省', '440000', '韶关市', '440200', '新丰县', '440233');
INSERT INTO `area_mapping` VALUES (1864, '广东省', '440000', '韶关市', '440200', '乐昌市', '440281');
INSERT INTO `area_mapping` VALUES (1865, '广东省', '440000', '韶关市', '440200', '南雄市', '440282');
INSERT INTO `area_mapping` VALUES (1866, '广东省', '440000', '深圳市', '440300', '罗湖区', '440303');
INSERT INTO `area_mapping` VALUES (1867, '广东省', '440000', '深圳市', '440300', '福田区', '440304');
INSERT INTO `area_mapping` VALUES (1868, '广东省', '440000', '深圳市', '440300', '南山区', '440305');
INSERT INTO `area_mapping` VALUES (1869, '广东省', '440000', '深圳市', '440300', '宝安区', '440306');
INSERT INTO `area_mapping` VALUES (1870, '广东省', '440000', '深圳市', '440300', '龙岗区', '440307');
INSERT INTO `area_mapping` VALUES (1871, '广东省', '440000', '深圳市', '440300', '盐田区', '440308');
INSERT INTO `area_mapping` VALUES (1872, '广东省', '440000', '深圳市', '440300', '龙华区', '440309');
INSERT INTO `area_mapping` VALUES (1873, '广东省', '440000', '深圳市', '440300', '坪山区', '440310');
INSERT INTO `area_mapping` VALUES (1874, '广东省', '440000', '深圳市', '440300', '光明区', '440311');
INSERT INTO `area_mapping` VALUES (1875, '广东省', '440000', '珠海市', '440400', '香洲区', '440402');
INSERT INTO `area_mapping` VALUES (1876, '广东省', '440000', '珠海市', '440400', '斗门区', '440403');
INSERT INTO `area_mapping` VALUES (1877, '广东省', '440000', '珠海市', '440400', '金湾区', '440404');
INSERT INTO `area_mapping` VALUES (1878, '广东省', '440000', '汕头市', '440500', '龙湖区', '440507');
INSERT INTO `area_mapping` VALUES (1879, '广东省', '440000', '汕头市', '440500', '金平区', '440511');
INSERT INTO `area_mapping` VALUES (1880, '广东省', '440000', '汕头市', '440500', '濠江区', '440512');
INSERT INTO `area_mapping` VALUES (1881, '广东省', '440000', '汕头市', '440500', '潮阳区', '440513');
INSERT INTO `area_mapping` VALUES (1882, '广东省', '440000', '汕头市', '440500', '潮南区', '440514');
INSERT INTO `area_mapping` VALUES (1883, '广东省', '440000', '汕头市', '440500', '澄海区', '440515');
INSERT INTO `area_mapping` VALUES (1884, '广东省', '440000', '汕头市', '440500', '南澳县', '440523');
INSERT INTO `area_mapping` VALUES (1885, '广东省', '440000', '佛山市', '440600', '禅城区', '440604');
INSERT INTO `area_mapping` VALUES (1886, '广东省', '440000', '佛山市', '440600', '南海区', '440605');
INSERT INTO `area_mapping` VALUES (1887, '广东省', '440000', '佛山市', '440600', '顺德区', '440606');
INSERT INTO `area_mapping` VALUES (1888, '广东省', '440000', '佛山市', '440600', '三水区', '440607');
INSERT INTO `area_mapping` VALUES (1889, '广东省', '440000', '佛山市', '440600', '高明区', '440608');
INSERT INTO `area_mapping` VALUES (1890, '广东省', '440000', '江门市', '440700', '蓬江区', '440703');
INSERT INTO `area_mapping` VALUES (1891, '广东省', '440000', '江门市', '440700', '江海区', '440704');
INSERT INTO `area_mapping` VALUES (1892, '广东省', '440000', '江门市', '440700', '新会区', '440705');
INSERT INTO `area_mapping` VALUES (1893, '广东省', '440000', '江门市', '440700', '台山市', '440781');
INSERT INTO `area_mapping` VALUES (1894, '广东省', '440000', '江门市', '440700', '开平市', '440783');
INSERT INTO `area_mapping` VALUES (1895, '广东省', '440000', '江门市', '440700', '鹤山市', '440784');
INSERT INTO `area_mapping` VALUES (1896, '广东省', '440000', '江门市', '440700', '恩平市', '440785');
INSERT INTO `area_mapping` VALUES (1897, '广东省', '440000', '湛江市', '440800', '赤坎区', '440802');
INSERT INTO `area_mapping` VALUES (1898, '广东省', '440000', '湛江市', '440800', '霞山区', '440803');
INSERT INTO `area_mapping` VALUES (1899, '广东省', '440000', '湛江市', '440800', '坡头区', '440804');
INSERT INTO `area_mapping` VALUES (1900, '广东省', '440000', '湛江市', '440800', '麻章区', '440811');
INSERT INTO `area_mapping` VALUES (1901, '广东省', '440000', '湛江市', '440800', '遂溪县', '440823');
INSERT INTO `area_mapping` VALUES (1902, '广东省', '440000', '湛江市', '440800', '徐闻县', '440825');
INSERT INTO `area_mapping` VALUES (1903, '广东省', '440000', '湛江市', '440800', '廉江市', '440881');
INSERT INTO `area_mapping` VALUES (1904, '广东省', '440000', '湛江市', '440800', '雷州市', '440882');
INSERT INTO `area_mapping` VALUES (1905, '广东省', '440000', '湛江市', '440800', '吴川市', '440883');
INSERT INTO `area_mapping` VALUES (1906, '广东省', '440000', '茂名市', '440900', '茂南区', '440902');
INSERT INTO `area_mapping` VALUES (1907, '广东省', '440000', '茂名市', '440900', '电白区', '440904');
INSERT INTO `area_mapping` VALUES (1908, '广东省', '440000', '茂名市', '440900', '高州市', '440981');
INSERT INTO `area_mapping` VALUES (1909, '广东省', '440000', '茂名市', '440900', '化州市', '440982');
INSERT INTO `area_mapping` VALUES (1910, '广东省', '440000', '茂名市', '440900', '信宜市', '440983');
INSERT INTO `area_mapping` VALUES (1911, '广东省', '440000', '肇庆市', '441200', '端州区', '441202');
INSERT INTO `area_mapping` VALUES (1912, '广东省', '440000', '肇庆市', '441200', '鼎湖区', '441203');
INSERT INTO `area_mapping` VALUES (1913, '广东省', '440000', '肇庆市', '441200', '高要区', '441204');
INSERT INTO `area_mapping` VALUES (1914, '广东省', '440000', '肇庆市', '441200', '广宁县', '441223');
INSERT INTO `area_mapping` VALUES (1915, '广东省', '440000', '肇庆市', '441200', '怀集县', '441224');
INSERT INTO `area_mapping` VALUES (1916, '广东省', '440000', '肇庆市', '441200', '封开县', '441225');
INSERT INTO `area_mapping` VALUES (1917, '广东省', '440000', '肇庆市', '441200', '德庆县', '441226');
INSERT INTO `area_mapping` VALUES (1918, '广东省', '440000', '肇庆市', '441200', '四会市', '441284');
INSERT INTO `area_mapping` VALUES (1919, '广东省', '440000', '惠州市', '441300', '惠城区', '441302');
INSERT INTO `area_mapping` VALUES (1920, '广东省', '440000', '惠州市', '441300', '惠阳区', '441303');
INSERT INTO `area_mapping` VALUES (1921, '广东省', '440000', '惠州市', '441300', '博罗县', '441322');
INSERT INTO `area_mapping` VALUES (1922, '广东省', '440000', '惠州市', '441300', '惠东县', '441323');
INSERT INTO `area_mapping` VALUES (1923, '广东省', '440000', '惠州市', '441300', '龙门县', '441324');
INSERT INTO `area_mapping` VALUES (1924, '广东省', '440000', '梅州市', '441400', '梅江区', '441402');
INSERT INTO `area_mapping` VALUES (1925, '广东省', '440000', '梅州市', '441400', '梅县区', '441403');
INSERT INTO `area_mapping` VALUES (1926, '广东省', '440000', '梅州市', '441400', '大埔县', '441422');
INSERT INTO `area_mapping` VALUES (1927, '广东省', '440000', '梅州市', '441400', '丰顺县', '441423');
INSERT INTO `area_mapping` VALUES (1928, '广东省', '440000', '梅州市', '441400', '五华县', '441424');
INSERT INTO `area_mapping` VALUES (1929, '广东省', '440000', '梅州市', '441400', '平远县', '441426');
INSERT INTO `area_mapping` VALUES (1930, '广东省', '440000', '梅州市', '441400', '蕉岭县', '441427');
INSERT INTO `area_mapping` VALUES (1931, '广东省', '440000', '梅州市', '441400', '兴宁市', '441481');
INSERT INTO `area_mapping` VALUES (1932, '广东省', '440000', '汕尾市', '441500', '城区', '441502');
INSERT INTO `area_mapping` VALUES (1933, '广东省', '440000', '汕尾市', '441500', '海丰县', '441521');
INSERT INTO `area_mapping` VALUES (1934, '广东省', '440000', '汕尾市', '441500', '陆河县', '441523');
INSERT INTO `area_mapping` VALUES (1935, '广东省', '440000', '汕尾市', '441500', '陆丰市', '441581');
INSERT INTO `area_mapping` VALUES (1936, '广东省', '440000', '河源市', '441600', '源城区', '441602');
INSERT INTO `area_mapping` VALUES (1937, '广东省', '440000', '河源市', '441600', '紫金县', '441621');
INSERT INTO `area_mapping` VALUES (1938, '广东省', '440000', '河源市', '441600', '龙川县', '441622');
INSERT INTO `area_mapping` VALUES (1939, '广东省', '440000', '河源市', '441600', '连平县', '441623');
INSERT INTO `area_mapping` VALUES (1940, '广东省', '440000', '河源市', '441600', '和平县', '441624');
INSERT INTO `area_mapping` VALUES (1941, '广东省', '440000', '河源市', '441600', '东源县', '441625');
INSERT INTO `area_mapping` VALUES (1942, '广东省', '440000', '阳江市', '441700', '江城区', '441702');
INSERT INTO `area_mapping` VALUES (1943, '广东省', '440000', '阳江市', '441700', '阳东区', '441704');
INSERT INTO `area_mapping` VALUES (1944, '广东省', '440000', '阳江市', '441700', '阳西县', '441721');
INSERT INTO `area_mapping` VALUES (1945, '广东省', '440000', '阳江市', '441700', '阳春市', '441781');
INSERT INTO `area_mapping` VALUES (1946, '广东省', '440000', '清远市', '441800', '清城区', '441802');
INSERT INTO `area_mapping` VALUES (1947, '广东省', '440000', '清远市', '441800', '清新区', '441803');
INSERT INTO `area_mapping` VALUES (1948, '广东省', '440000', '清远市', '441800', '佛冈县', '441821');
INSERT INTO `area_mapping` VALUES (1949, '广东省', '440000', '清远市', '441800', '阳山县', '441823');
INSERT INTO `area_mapping` VALUES (1950, '广东省', '440000', '清远市', '441800', '连山壮族瑶族自治县', '441825');
INSERT INTO `area_mapping` VALUES (1951, '广东省', '440000', '清远市', '441800', '连南瑶族自治县', '441826');
INSERT INTO `area_mapping` VALUES (1952, '广东省', '440000', '清远市', '441800', '英德市', '441881');
INSERT INTO `area_mapping` VALUES (1953, '广东省', '440000', '清远市', '441800', '连州市', '441882');
INSERT INTO `area_mapping` VALUES (1954, '广东省', '440000', '东莞市', '441900', '东莞市', '441900');
INSERT INTO `area_mapping` VALUES (1955, '广东省', '440000', '中山市', '442000', '中山市', '442000');
INSERT INTO `area_mapping` VALUES (1956, '广东省', '440000', '潮州市', '445100', '湘桥区', '445102');
INSERT INTO `area_mapping` VALUES (1957, '广东省', '440000', '潮州市', '445100', '潮安区', '445103');
INSERT INTO `area_mapping` VALUES (1958, '广东省', '440000', '潮州市', '445100', '饶平县', '445122');
INSERT INTO `area_mapping` VALUES (1959, '广东省', '440000', '揭阳市', '445200', '榕城区', '445202');
INSERT INTO `area_mapping` VALUES (1960, '广东省', '440000', '揭阳市', '445200', '揭东区', '445203');
INSERT INTO `area_mapping` VALUES (1961, '广东省', '440000', '揭阳市', '445200', '揭西县', '445222');
INSERT INTO `area_mapping` VALUES (1962, '广东省', '440000', '揭阳市', '445200', '惠来县', '445224');
INSERT INTO `area_mapping` VALUES (1963, '广东省', '440000', '揭阳市', '445200', '普宁市', '445281');
INSERT INTO `area_mapping` VALUES (1964, '广东省', '440000', '云浮市', '445300', '云城区', '445302');
INSERT INTO `area_mapping` VALUES (1965, '广东省', '440000', '云浮市', '445300', '云安区', '445303');
INSERT INTO `area_mapping` VALUES (1966, '广东省', '440000', '云浮市', '445300', '新兴县', '445321');
INSERT INTO `area_mapping` VALUES (1967, '广东省', '440000', '云浮市', '445300', '郁南县', '445322');
INSERT INTO `area_mapping` VALUES (1968, '广东省', '440000', '云浮市', '445300', '罗定市', '445381');
INSERT INTO `area_mapping` VALUES (1969, '广西壮族自治区', '450000', '南宁市', '450100', '兴宁区', '450102');
INSERT INTO `area_mapping` VALUES (1970, '广西壮族自治区', '450000', '南宁市', '450100', '青秀区', '450103');
INSERT INTO `area_mapping` VALUES (1971, '广西壮族自治区', '450000', '南宁市', '450100', '江南区', '450105');
INSERT INTO `area_mapping` VALUES (1972, '广西壮族自治区', '450000', '南宁市', '450100', '西乡塘区', '450107');
INSERT INTO `area_mapping` VALUES (1973, '广西壮族自治区', '450000', '南宁市', '450100', '良庆区', '450108');
INSERT INTO `area_mapping` VALUES (1974, '广西壮族自治区', '450000', '南宁市', '450100', '邕宁区', '450109');
INSERT INTO `area_mapping` VALUES (1975, '广西壮族自治区', '450000', '南宁市', '450100', '武鸣区', '450110');
INSERT INTO `area_mapping` VALUES (1976, '广西壮族自治区', '450000', '南宁市', '450100', '隆安县', '450123');
INSERT INTO `area_mapping` VALUES (1977, '广西壮族自治区', '450000', '南宁市', '450100', '马山县', '450124');
INSERT INTO `area_mapping` VALUES (1978, '广西壮族自治区', '450000', '南宁市', '450100', '上林县', '450125');
INSERT INTO `area_mapping` VALUES (1979, '广西壮族自治区', '450000', '南宁市', '450100', '宾阳县', '450126');
INSERT INTO `area_mapping` VALUES (1980, '广西壮族自治区', '450000', '南宁市', '450100', '横县', '450127');
INSERT INTO `area_mapping` VALUES (1981, '广西壮族自治区', '450000', '柳州市', '450200', '城中区', '450202');
INSERT INTO `area_mapping` VALUES (1982, '广西壮族自治区', '450000', '柳州市', '450200', '鱼峰区', '450203');
INSERT INTO `area_mapping` VALUES (1983, '广西壮族自治区', '450000', '柳州市', '450200', '柳南区', '450204');
INSERT INTO `area_mapping` VALUES (1984, '广西壮族自治区', '450000', '柳州市', '450200', '柳北区', '450205');
INSERT INTO `area_mapping` VALUES (1985, '广西壮族自治区', '450000', '柳州市', '450200', '柳江区', '450206');
INSERT INTO `area_mapping` VALUES (1986, '广西壮族自治区', '450000', '柳州市', '450200', '柳城县', '450222');
INSERT INTO `area_mapping` VALUES (1987, '广西壮族自治区', '450000', '柳州市', '450200', '鹿寨县', '450223');
INSERT INTO `area_mapping` VALUES (1988, '广西壮族自治区', '450000', '柳州市', '450200', '融安县', '450224');
INSERT INTO `area_mapping` VALUES (1989, '广西壮族自治区', '450000', '柳州市', '450200', '融水苗族自治县', '450225');
INSERT INTO `area_mapping` VALUES (1990, '广西壮族自治区', '450000', '柳州市', '450200', '三江侗族自治县', '450226');
INSERT INTO `area_mapping` VALUES (1991, '广西壮族自治区', '450000', '桂林市', '450300', '秀峰区', '450302');
INSERT INTO `area_mapping` VALUES (1992, '广西壮族自治区', '450000', '桂林市', '450300', '叠彩区', '450303');
INSERT INTO `area_mapping` VALUES (1993, '广西壮族自治区', '450000', '桂林市', '450300', '象山区', '450304');
INSERT INTO `area_mapping` VALUES (1994, '广西壮族自治区', '450000', '桂林市', '450300', '七星区', '450305');
INSERT INTO `area_mapping` VALUES (1995, '广西壮族自治区', '450000', '桂林市', '450300', '雁山区', '450311');
INSERT INTO `area_mapping` VALUES (1996, '广西壮族自治区', '450000', '桂林市', '450300', '临桂区', '450312');
INSERT INTO `area_mapping` VALUES (1997, '广西壮族自治区', '450000', '桂林市', '450300', '阳朔县', '450321');
INSERT INTO `area_mapping` VALUES (1998, '广西壮族自治区', '450000', '桂林市', '450300', '灵川县', '450323');
INSERT INTO `area_mapping` VALUES (1999, '广西壮族自治区', '450000', '桂林市', '450300', '全州县', '450324');
INSERT INTO `area_mapping` VALUES (2000, '广西壮族自治区', '450000', '桂林市', '450300', '兴安县', '450325');
INSERT INTO `area_mapping` VALUES (2001, '广西壮族自治区', '450000', '桂林市', '450300', '永福县', '450326');
INSERT INTO `area_mapping` VALUES (2002, '广西壮族自治区', '450000', '桂林市', '450300', '灌阳县', '450327');
INSERT INTO `area_mapping` VALUES (2003, '广西壮族自治区', '450000', '桂林市', '450300', '龙胜各族自治县', '450328');
INSERT INTO `area_mapping` VALUES (2004, '广西壮族自治区', '450000', '桂林市', '450300', '资源县', '450329');
INSERT INTO `area_mapping` VALUES (2005, '广西壮族自治区', '450000', '桂林市', '450300', '平乐县', '450330');
INSERT INTO `area_mapping` VALUES (2006, '广西壮族自治区', '450000', '桂林市', '450300', '恭城瑶族自治县', '450332');
INSERT INTO `area_mapping` VALUES (2007, '广西壮族自治区', '450000', '桂林市', '450300', '荔浦市', '450381');
INSERT INTO `area_mapping` VALUES (2008, '广西壮族自治区', '450000', '梧州市', '450400', '万秀区', '450403');
INSERT INTO `area_mapping` VALUES (2009, '广西壮族自治区', '450000', '梧州市', '450400', '长洲区', '450405');
INSERT INTO `area_mapping` VALUES (2010, '广西壮族自治区', '450000', '梧州市', '450400', '龙圩区', '450406');
INSERT INTO `area_mapping` VALUES (2011, '广西壮族自治区', '450000', '梧州市', '450400', '苍梧县', '450421');
INSERT INTO `area_mapping` VALUES (2012, '广西壮族自治区', '450000', '梧州市', '450400', '藤县', '450422');
INSERT INTO `area_mapping` VALUES (2013, '广西壮族自治区', '450000', '梧州市', '450400', '蒙山县', '450423');
INSERT INTO `area_mapping` VALUES (2014, '广西壮族自治区', '450000', '梧州市', '450400', '岑溪市', '450481');
INSERT INTO `area_mapping` VALUES (2015, '广西壮族自治区', '450000', '北海市', '450500', '海城区', '450502');
INSERT INTO `area_mapping` VALUES (2016, '广西壮族自治区', '450000', '北海市', '450500', '银海区', '450503');
INSERT INTO `area_mapping` VALUES (2017, '广西壮族自治区', '450000', '北海市', '450500', '铁山港区', '450512');
INSERT INTO `area_mapping` VALUES (2018, '广西壮族自治区', '450000', '北海市', '450500', '合浦县', '450521');
INSERT INTO `area_mapping` VALUES (2019, '广西壮族自治区', '450000', '防城港市', '450600', '港口区', '450602');
INSERT INTO `area_mapping` VALUES (2020, '广西壮族自治区', '450000', '防城港市', '450600', '防城区', '450603');
INSERT INTO `area_mapping` VALUES (2021, '广西壮族自治区', '450000', '防城港市', '450600', '上思县', '450621');
INSERT INTO `area_mapping` VALUES (2022, '广西壮族自治区', '450000', '防城港市', '450600', '东兴市', '450681');
INSERT INTO `area_mapping` VALUES (2023, '广西壮族自治区', '450000', '钦州市', '450700', '钦南区', '450702');
INSERT INTO `area_mapping` VALUES (2024, '广西壮族自治区', '450000', '钦州市', '450700', '钦北区', '450703');
INSERT INTO `area_mapping` VALUES (2025, '广西壮族自治区', '450000', '钦州市', '450700', '灵山县', '450721');
INSERT INTO `area_mapping` VALUES (2026, '广西壮族自治区', '450000', '钦州市', '450700', '浦北县', '450722');
INSERT INTO `area_mapping` VALUES (2027, '广西壮族自治区', '450000', '贵港市', '450800', '港北区', '450802');
INSERT INTO `area_mapping` VALUES (2028, '广西壮族自治区', '450000', '贵港市', '450800', '港南区', '450803');
INSERT INTO `area_mapping` VALUES (2029, '广西壮族自治区', '450000', '贵港市', '450800', '覃塘区', '450804');
INSERT INTO `area_mapping` VALUES (2030, '广西壮族自治区', '450000', '贵港市', '450800', '平南县', '450821');
INSERT INTO `area_mapping` VALUES (2031, '广西壮族自治区', '450000', '贵港市', '450800', '桂平市', '450881');
INSERT INTO `area_mapping` VALUES (2032, '广西壮族自治区', '450000', '玉林市', '450900', '玉州区', '450902');
INSERT INTO `area_mapping` VALUES (2033, '广西壮族自治区', '450000', '玉林市', '450900', '福绵区', '450903');
INSERT INTO `area_mapping` VALUES (2034, '广西壮族自治区', '450000', '玉林市', '450900', '容县', '450921');
INSERT INTO `area_mapping` VALUES (2035, '广西壮族自治区', '450000', '玉林市', '450900', '陆川县', '450922');
INSERT INTO `area_mapping` VALUES (2036, '广西壮族自治区', '450000', '玉林市', '450900', '博白县', '450923');
INSERT INTO `area_mapping` VALUES (2037, '广西壮族自治区', '450000', '玉林市', '450900', '兴业县', '450924');
INSERT INTO `area_mapping` VALUES (2038, '广西壮族自治区', '450000', '玉林市', '450900', '北流市', '450981');
INSERT INTO `area_mapping` VALUES (2039, '广西壮族自治区', '450000', '百色市', '451000', '右江区', '451002');
INSERT INTO `area_mapping` VALUES (2040, '广西壮族自治区', '450000', '百色市', '451000', '田阳区', '451003');
INSERT INTO `area_mapping` VALUES (2041, '广西壮族自治区', '450000', '百色市', '451000', '田东县', '451022');
INSERT INTO `area_mapping` VALUES (2042, '广西壮族自治区', '450000', '百色市', '451000', '德保县', '451024');
INSERT INTO `area_mapping` VALUES (2043, '广西壮族自治区', '450000', '百色市', '451000', '那坡县', '451026');
INSERT INTO `area_mapping` VALUES (2044, '广西壮族自治区', '450000', '百色市', '451000', '凌云县', '451027');
INSERT INTO `area_mapping` VALUES (2045, '广西壮族自治区', '450000', '百色市', '451000', '乐业县', '451028');
INSERT INTO `area_mapping` VALUES (2046, '广西壮族自治区', '450000', '百色市', '451000', '田林县', '451029');
INSERT INTO `area_mapping` VALUES (2047, '广西壮族自治区', '450000', '百色市', '451000', '西林县', '451030');
INSERT INTO `area_mapping` VALUES (2048, '广西壮族自治区', '450000', '百色市', '451000', '隆林各族自治县', '451031');
INSERT INTO `area_mapping` VALUES (2049, '广西壮族自治区', '450000', '百色市', '451000', '靖西市', '451081');
INSERT INTO `area_mapping` VALUES (2050, '广西壮族自治区', '450000', '百色市', '451000', '平果市', '451082');
INSERT INTO `area_mapping` VALUES (2051, '广西壮族自治区', '450000', '贺州市', '451100', '八步区', '451102');
INSERT INTO `area_mapping` VALUES (2052, '广西壮族自治区', '450000', '贺州市', '451100', '平桂区', '451103');
INSERT INTO `area_mapping` VALUES (2053, '广西壮族自治区', '450000', '贺州市', '451100', '昭平县', '451121');
INSERT INTO `area_mapping` VALUES (2054, '广西壮族自治区', '450000', '贺州市', '451100', '钟山县', '451122');
INSERT INTO `area_mapping` VALUES (2055, '广西壮族自治区', '450000', '贺州市', '451100', '富川瑶族自治县', '451123');
INSERT INTO `area_mapping` VALUES (2056, '广西壮族自治区', '450000', '河池市', '451200', '金城江区', '451202');
INSERT INTO `area_mapping` VALUES (2057, '广西壮族自治区', '450000', '河池市', '451200', '宜州区', '451203');
INSERT INTO `area_mapping` VALUES (2058, '广西壮族自治区', '450000', '河池市', '451200', '南丹县', '451221');
INSERT INTO `area_mapping` VALUES (2059, '广西壮族自治区', '450000', '河池市', '451200', '天峨县', '451222');
INSERT INTO `area_mapping` VALUES (2060, '广西壮族自治区', '450000', '河池市', '451200', '凤山县', '451223');
INSERT INTO `area_mapping` VALUES (2061, '广西壮族自治区', '450000', '河池市', '451200', '东兰县', '451224');
INSERT INTO `area_mapping` VALUES (2062, '广西壮族自治区', '450000', '河池市', '451200', '罗城仫佬族自治县', '451225');
INSERT INTO `area_mapping` VALUES (2063, '广西壮族自治区', '450000', '河池市', '451200', '环江毛南族自治县', '451226');
INSERT INTO `area_mapping` VALUES (2064, '广西壮族自治区', '450000', '河池市', '451200', '巴马瑶族自治县', '451227');
INSERT INTO `area_mapping` VALUES (2065, '广西壮族自治区', '450000', '河池市', '451200', '都安瑶族自治县', '451228');
INSERT INTO `area_mapping` VALUES (2066, '广西壮族自治区', '450000', '河池市', '451200', '大化瑶族自治县', '451229');
INSERT INTO `area_mapping` VALUES (2067, '广西壮族自治区', '450000', '来宾市', '451300', '兴宾区', '451302');
INSERT INTO `area_mapping` VALUES (2068, '广西壮族自治区', '450000', '来宾市', '451300', '忻城县', '451321');
INSERT INTO `area_mapping` VALUES (2069, '广西壮族自治区', '450000', '来宾市', '451300', '象州县', '451322');
INSERT INTO `area_mapping` VALUES (2070, '广西壮族自治区', '450000', '来宾市', '451300', '武宣县', '451323');
INSERT INTO `area_mapping` VALUES (2071, '广西壮族自治区', '450000', '来宾市', '451300', '金秀瑶族自治县', '451324');
INSERT INTO `area_mapping` VALUES (2072, '广西壮族自治区', '450000', '来宾市', '451300', '合山市', '451381');
INSERT INTO `area_mapping` VALUES (2073, '广西壮族自治区', '450000', '崇左市', '451400', '江州区', '451402');
INSERT INTO `area_mapping` VALUES (2074, '广西壮族自治区', '450000', '崇左市', '451400', '扶绥县', '451421');
INSERT INTO `area_mapping` VALUES (2075, '广西壮族自治区', '450000', '崇左市', '451400', '宁明县', '451422');
INSERT INTO `area_mapping` VALUES (2076, '广西壮族自治区', '450000', '崇左市', '451400', '龙州县', '451423');
INSERT INTO `area_mapping` VALUES (2077, '广西壮族自治区', '450000', '崇左市', '451400', '大新县', '451424');
INSERT INTO `area_mapping` VALUES (2078, '广西壮族自治区', '450000', '崇左市', '451400', '天等县', '451425');
INSERT INTO `area_mapping` VALUES (2079, '广西壮族自治区', '450000', '崇左市', '451400', '凭祥市', '451481');
INSERT INTO `area_mapping` VALUES (2080, '海南省', '460000', '海口市', '460100', '秀英区', '460105');
INSERT INTO `area_mapping` VALUES (2081, '海南省', '460000', '海口市', '460100', '龙华区', '460106');
INSERT INTO `area_mapping` VALUES (2082, '海南省', '460000', '海口市', '460100', '琼山区', '460107');
INSERT INTO `area_mapping` VALUES (2083, '海南省', '460000', '海口市', '460100', '美兰区', '460108');
INSERT INTO `area_mapping` VALUES (2084, '海南省', '460000', '三亚市', '460200', '海棠区', '460202');
INSERT INTO `area_mapping` VALUES (2085, '海南省', '460000', '三亚市', '460200', '吉阳区', '460203');
INSERT INTO `area_mapping` VALUES (2086, '海南省', '460000', '三亚市', '460200', '天涯区', '460204');
INSERT INTO `area_mapping` VALUES (2087, '海南省', '460000', '三亚市', '460200', '崖州区', '460205');
INSERT INTO `area_mapping` VALUES (2088, '海南省', '460000', '三沙市', '460300', '西沙群岛', '460321');
INSERT INTO `area_mapping` VALUES (2089, '海南省', '460000', '三沙市', '460300', '南沙群岛', '460322');
INSERT INTO `area_mapping` VALUES (2090, '海南省', '460000', '三沙市', '460300', '中沙群岛的岛礁及其海域', '460323');
INSERT INTO `area_mapping` VALUES (2091, '海南省', '460000', '儋州市', '460400', '儋州市', '460400');
INSERT INTO `area_mapping` VALUES (2092, '海南省', '460000', '省直辖县级行政区划', '469000', '五指山市', '469001');
INSERT INTO `area_mapping` VALUES (2093, '海南省', '460000', '省直辖县级行政区划', '469000', '琼海市', '469002');
INSERT INTO `area_mapping` VALUES (2094, '海南省', '460000', '省直辖县级行政区划', '469000', '文昌市', '469005');
INSERT INTO `area_mapping` VALUES (2095, '海南省', '460000', '省直辖县级行政区划', '469000', '万宁市', '469006');
INSERT INTO `area_mapping` VALUES (2096, '海南省', '460000', '省直辖县级行政区划', '469000', '东方市', '469007');
INSERT INTO `area_mapping` VALUES (2097, '海南省', '460000', '省直辖县级行政区划', '469000', '定安县', '469021');
INSERT INTO `area_mapping` VALUES (2098, '海南省', '460000', '省直辖县级行政区划', '469000', '屯昌县', '469022');
INSERT INTO `area_mapping` VALUES (2099, '海南省', '460000', '省直辖县级行政区划', '469000', '澄迈县', '469023');
INSERT INTO `area_mapping` VALUES (2100, '海南省', '460000', '省直辖县级行政区划', '469000', '临高县', '469024');
INSERT INTO `area_mapping` VALUES (2101, '海南省', '460000', '省直辖县级行政区划', '469000', '白沙黎族自治县', '469025');
INSERT INTO `area_mapping` VALUES (2102, '海南省', '460000', '省直辖县级行政区划', '469000', '昌江黎族自治县', '469026');
INSERT INTO `area_mapping` VALUES (2103, '海南省', '460000', '省直辖县级行政区划', '469000', '乐东黎族自治县', '469027');
INSERT INTO `area_mapping` VALUES (2104, '海南省', '460000', '省直辖县级行政区划', '469000', '陵水黎族自治县', '469028');
INSERT INTO `area_mapping` VALUES (2105, '海南省', '460000', '省直辖县级行政区划', '469000', '保亭黎族苗族自治县', '469029');
INSERT INTO `area_mapping` VALUES (2106, '海南省', '460000', '省直辖县级行政区划', '469000', '琼中黎族苗族自治县', '469030');
INSERT INTO `area_mapping` VALUES (2107, '重庆市', '500000', '重庆市', '500100', '万州区', '500101');
INSERT INTO `area_mapping` VALUES (2108, '重庆市', '500000', '重庆市', '500100', '涪陵区', '500102');
INSERT INTO `area_mapping` VALUES (2109, '重庆市', '500000', '重庆市', '500100', '渝中区', '500103');
INSERT INTO `area_mapping` VALUES (2110, '重庆市', '500000', '重庆市', '500100', '大渡口区', '500104');
INSERT INTO `area_mapping` VALUES (2111, '重庆市', '500000', '重庆市', '500100', '江北区', '500105');
INSERT INTO `area_mapping` VALUES (2112, '重庆市', '500000', '重庆市', '500100', '沙坪坝区', '500106');
INSERT INTO `area_mapping` VALUES (2113, '重庆市', '500000', '重庆市', '500100', '九龙坡区', '500107');
INSERT INTO `area_mapping` VALUES (2114, '重庆市', '500000', '重庆市', '500100', '南岸区', '500108');
INSERT INTO `area_mapping` VALUES (2115, '重庆市', '500000', '重庆市', '500100', '北碚区', '500109');
INSERT INTO `area_mapping` VALUES (2116, '重庆市', '500000', '重庆市', '500100', '綦江区', '500110');
INSERT INTO `area_mapping` VALUES (2117, '重庆市', '500000', '重庆市', '500100', '大足区', '500111');
INSERT INTO `area_mapping` VALUES (2118, '重庆市', '500000', '重庆市', '500100', '渝北区', '500112');
INSERT INTO `area_mapping` VALUES (2119, '重庆市', '500000', '重庆市', '500100', '巴南区', '500113');
INSERT INTO `area_mapping` VALUES (2120, '重庆市', '500000', '重庆市', '500100', '黔江区', '500114');
INSERT INTO `area_mapping` VALUES (2121, '重庆市', '500000', '重庆市', '500100', '长寿区', '500115');
INSERT INTO `area_mapping` VALUES (2122, '重庆市', '500000', '重庆市', '500100', '江津区', '500116');
INSERT INTO `area_mapping` VALUES (2123, '重庆市', '500000', '重庆市', '500100', '合川区', '500117');
INSERT INTO `area_mapping` VALUES (2124, '重庆市', '500000', '重庆市', '500100', '永川区', '500118');
INSERT INTO `area_mapping` VALUES (2125, '重庆市', '500000', '重庆市', '500100', '南川区', '500119');
INSERT INTO `area_mapping` VALUES (2126, '重庆市', '500000', '重庆市', '500100', '璧山区', '500120');
INSERT INTO `area_mapping` VALUES (2127, '重庆市', '500000', '重庆市', '500100', '铜梁区', '500151');
INSERT INTO `area_mapping` VALUES (2128, '重庆市', '500000', '重庆市', '500100', '潼南区', '500152');
INSERT INTO `area_mapping` VALUES (2129, '重庆市', '500000', '重庆市', '500100', '荣昌区', '500153');
INSERT INTO `area_mapping` VALUES (2130, '重庆市', '500000', '重庆市', '500100', '开州区', '500154');
INSERT INTO `area_mapping` VALUES (2131, '重庆市', '500000', '重庆市', '500100', '梁平区', '500155');
INSERT INTO `area_mapping` VALUES (2132, '重庆市', '500000', '重庆市', '500100', '武隆区', '500156');
INSERT INTO `area_mapping` VALUES (2133, '重庆市', '500000', '县', '500200', '城口县', '500229');
INSERT INTO `area_mapping` VALUES (2134, '重庆市', '500000', '县', '500200', '丰都县', '500230');
INSERT INTO `area_mapping` VALUES (2135, '重庆市', '500000', '县', '500200', '垫江县', '500231');
INSERT INTO `area_mapping` VALUES (2136, '重庆市', '500000', '县', '500200', '忠县', '500233');
INSERT INTO `area_mapping` VALUES (2137, '重庆市', '500000', '县', '500200', '云阳县', '500235');
INSERT INTO `area_mapping` VALUES (2138, '重庆市', '500000', '县', '500200', '奉节县', '500236');
INSERT INTO `area_mapping` VALUES (2139, '重庆市', '500000', '县', '500200', '巫山县', '500237');
INSERT INTO `area_mapping` VALUES (2140, '重庆市', '500000', '县', '500200', '巫溪县', '500238');
INSERT INTO `area_mapping` VALUES (2141, '重庆市', '500000', '县', '500200', '石柱土家族自治县', '500240');
INSERT INTO `area_mapping` VALUES (2142, '重庆市', '500000', '县', '500200', '秀山土家族苗族自治县', '500241');
INSERT INTO `area_mapping` VALUES (2143, '重庆市', '500000', '县', '500200', '酉阳土家族苗族自治县', '500242');
INSERT INTO `area_mapping` VALUES (2144, '重庆市', '500000', '县', '500200', '彭水苗族土家族自治县', '500243');
INSERT INTO `area_mapping` VALUES (2145, '四川省', '510000', '成都市', '510100', '锦江区', '510104');
INSERT INTO `area_mapping` VALUES (2146, '四川省', '510000', '成都市', '510100', '青羊区', '510105');
INSERT INTO `area_mapping` VALUES (2147, '四川省', '510000', '成都市', '510100', '金牛区', '510106');
INSERT INTO `area_mapping` VALUES (2148, '四川省', '510000', '成都市', '510100', '武侯区', '510107');
INSERT INTO `area_mapping` VALUES (2149, '四川省', '510000', '成都市', '510100', '成华区', '510108');
INSERT INTO `area_mapping` VALUES (2150, '四川省', '510000', '成都市', '510100', '龙泉驿区', '510112');
INSERT INTO `area_mapping` VALUES (2151, '四川省', '510000', '成都市', '510100', '青白江区', '510113');
INSERT INTO `area_mapping` VALUES (2152, '四川省', '510000', '成都市', '510100', '新都区', '510114');
INSERT INTO `area_mapping` VALUES (2153, '四川省', '510000', '成都市', '510100', '温江区', '510115');
INSERT INTO `area_mapping` VALUES (2154, '四川省', '510000', '成都市', '510100', '双流区', '510116');
INSERT INTO `area_mapping` VALUES (2155, '四川省', '510000', '成都市', '510100', '郫都区', '510117');
INSERT INTO `area_mapping` VALUES (2156, '四川省', '510000', '成都市', '510100', '新津区', '510118');
INSERT INTO `area_mapping` VALUES (2157, '四川省', '510000', '成都市', '510100', '金堂县', '510121');
INSERT INTO `area_mapping` VALUES (2158, '四川省', '510000', '成都市', '510100', '大邑县', '510129');
INSERT INTO `area_mapping` VALUES (2159, '四川省', '510000', '成都市', '510100', '蒲江县', '510131');
INSERT INTO `area_mapping` VALUES (2160, '四川省', '510000', '成都市', '510100', '都江堰市', '510181');
INSERT INTO `area_mapping` VALUES (2161, '四川省', '510000', '成都市', '510100', '彭州市', '510182');
INSERT INTO `area_mapping` VALUES (2162, '四川省', '510000', '成都市', '510100', '邛崃市', '510183');
INSERT INTO `area_mapping` VALUES (2163, '四川省', '510000', '成都市', '510100', '崇州市', '510184');
INSERT INTO `area_mapping` VALUES (2164, '四川省', '510000', '成都市', '510100', '简阳市', '510185');
INSERT INTO `area_mapping` VALUES (2165, '四川省', '510000', '自贡市', '510300', '自流井区', '510302');
INSERT INTO `area_mapping` VALUES (2166, '四川省', '510000', '自贡市', '510300', '贡井区', '510303');
INSERT INTO `area_mapping` VALUES (2167, '四川省', '510000', '自贡市', '510300', '大安区', '510304');
INSERT INTO `area_mapping` VALUES (2168, '四川省', '510000', '自贡市', '510300', '沿滩区', '510311');
INSERT INTO `area_mapping` VALUES (2169, '四川省', '510000', '自贡市', '510300', '荣县', '510321');
INSERT INTO `area_mapping` VALUES (2170, '四川省', '510000', '自贡市', '510300', '富顺县', '510322');
INSERT INTO `area_mapping` VALUES (2171, '四川省', '510000', '攀枝花市', '510400', '东区', '510402');
INSERT INTO `area_mapping` VALUES (2172, '四川省', '510000', '攀枝花市', '510400', '西区', '510403');
INSERT INTO `area_mapping` VALUES (2173, '四川省', '510000', '攀枝花市', '510400', '仁和区', '510411');
INSERT INTO `area_mapping` VALUES (2174, '四川省', '510000', '攀枝花市', '510400', '米易县', '510421');
INSERT INTO `area_mapping` VALUES (2175, '四川省', '510000', '攀枝花市', '510400', '盐边县', '510422');
INSERT INTO `area_mapping` VALUES (2176, '四川省', '510000', '泸州市', '510500', '江阳区', '510502');
INSERT INTO `area_mapping` VALUES (2177, '四川省', '510000', '泸州市', '510500', '纳溪区', '510503');
INSERT INTO `area_mapping` VALUES (2178, '四川省', '510000', '泸州市', '510500', '龙马潭区', '510504');
INSERT INTO `area_mapping` VALUES (2179, '四川省', '510000', '泸州市', '510500', '泸县', '510521');
INSERT INTO `area_mapping` VALUES (2180, '四川省', '510000', '泸州市', '510500', '合江县', '510522');
INSERT INTO `area_mapping` VALUES (2181, '四川省', '510000', '泸州市', '510500', '叙永县', '510524');
INSERT INTO `area_mapping` VALUES (2182, '四川省', '510000', '泸州市', '510500', '古蔺县', '510525');
INSERT INTO `area_mapping` VALUES (2183, '四川省', '510000', '德阳市', '510600', '旌阳区', '510603');
INSERT INTO `area_mapping` VALUES (2184, '四川省', '510000', '德阳市', '510600', '罗江区', '510604');
INSERT INTO `area_mapping` VALUES (2185, '四川省', '510000', '德阳市', '510600', '中江县', '510623');
INSERT INTO `area_mapping` VALUES (2186, '四川省', '510000', '德阳市', '510600', '广汉市', '510681');
INSERT INTO `area_mapping` VALUES (2187, '四川省', '510000', '德阳市', '510600', '什邡市', '510682');
INSERT INTO `area_mapping` VALUES (2188, '四川省', '510000', '德阳市', '510600', '绵竹市', '510683');
INSERT INTO `area_mapping` VALUES (2189, '四川省', '510000', '绵阳市', '510700', '涪城区', '510703');
INSERT INTO `area_mapping` VALUES (2190, '四川省', '510000', '绵阳市', '510700', '游仙区', '510704');
INSERT INTO `area_mapping` VALUES (2191, '四川省', '510000', '绵阳市', '510700', '安州区', '510705');
INSERT INTO `area_mapping` VALUES (2192, '四川省', '510000', '绵阳市', '510700', '三台县', '510722');
INSERT INTO `area_mapping` VALUES (2193, '四川省', '510000', '绵阳市', '510700', '盐亭县', '510723');
INSERT INTO `area_mapping` VALUES (2194, '四川省', '510000', '绵阳市', '510700', '梓潼县', '510725');
INSERT INTO `area_mapping` VALUES (2195, '四川省', '510000', '绵阳市', '510700', '北川羌族自治县', '510726');
INSERT INTO `area_mapping` VALUES (2196, '四川省', '510000', '绵阳市', '510700', '平武县', '510727');
INSERT INTO `area_mapping` VALUES (2197, '四川省', '510000', '绵阳市', '510700', '江油市', '510781');
INSERT INTO `area_mapping` VALUES (2198, '四川省', '510000', '广元市', '510800', '利州区', '510802');
INSERT INTO `area_mapping` VALUES (2199, '四川省', '510000', '广元市', '510800', '昭化区', '510811');
INSERT INTO `area_mapping` VALUES (2200, '四川省', '510000', '广元市', '510800', '朝天区', '510812');
INSERT INTO `area_mapping` VALUES (2201, '四川省', '510000', '广元市', '510800', '旺苍县', '510821');
INSERT INTO `area_mapping` VALUES (2202, '四川省', '510000', '广元市', '510800', '青川县', '510822');
INSERT INTO `area_mapping` VALUES (2203, '四川省', '510000', '广元市', '510800', '剑阁县', '510823');
INSERT INTO `area_mapping` VALUES (2204, '四川省', '510000', '广元市', '510800', '苍溪县', '510824');
INSERT INTO `area_mapping` VALUES (2205, '四川省', '510000', '遂宁市', '510900', '船山区', '510903');
INSERT INTO `area_mapping` VALUES (2206, '四川省', '510000', '遂宁市', '510900', '安居区', '510904');
INSERT INTO `area_mapping` VALUES (2207, '四川省', '510000', '遂宁市', '510900', '蓬溪县', '510921');
INSERT INTO `area_mapping` VALUES (2208, '四川省', '510000', '遂宁市', '510900', '大英县', '510923');
INSERT INTO `area_mapping` VALUES (2209, '四川省', '510000', '遂宁市', '510900', '射洪市', '510981');
INSERT INTO `area_mapping` VALUES (2210, '四川省', '510000', '内江市', '511000', '市中区', '511002');
INSERT INTO `area_mapping` VALUES (2211, '四川省', '510000', '内江市', '511000', '东兴区', '511011');
INSERT INTO `area_mapping` VALUES (2212, '四川省', '510000', '内江市', '511000', '威远县', '511024');
INSERT INTO `area_mapping` VALUES (2213, '四川省', '510000', '内江市', '511000', '资中县', '511025');
INSERT INTO `area_mapping` VALUES (2214, '四川省', '510000', '内江市', '511000', '内江经济开发区', '511071');
INSERT INTO `area_mapping` VALUES (2215, '四川省', '510000', '内江市', '511000', '隆昌市', '511083');
INSERT INTO `area_mapping` VALUES (2216, '四川省', '510000', '乐山市', '511100', '市中区', '511102');
INSERT INTO `area_mapping` VALUES (2217, '四川省', '510000', '乐山市', '511100', '沙湾区', '511111');
INSERT INTO `area_mapping` VALUES (2218, '四川省', '510000', '乐山市', '511100', '五通桥区', '511112');
INSERT INTO `area_mapping` VALUES (2219, '四川省', '510000', '乐山市', '511100', '金口河区', '511113');
INSERT INTO `area_mapping` VALUES (2220, '四川省', '510000', '乐山市', '511100', '犍为县', '511123');
INSERT INTO `area_mapping` VALUES (2221, '四川省', '510000', '乐山市', '511100', '井研县', '511124');
INSERT INTO `area_mapping` VALUES (2222, '四川省', '510000', '乐山市', '511100', '夹江县', '511126');
INSERT INTO `area_mapping` VALUES (2223, '四川省', '510000', '乐山市', '511100', '沐川县', '511129');
INSERT INTO `area_mapping` VALUES (2224, '四川省', '510000', '乐山市', '511100', '峨边彝族自治县', '511132');
INSERT INTO `area_mapping` VALUES (2225, '四川省', '510000', '乐山市', '511100', '马边彝族自治县', '511133');
INSERT INTO `area_mapping` VALUES (2226, '四川省', '510000', '乐山市', '511100', '峨眉山市', '511181');
INSERT INTO `area_mapping` VALUES (2227, '四川省', '510000', '南充市', '511300', '顺庆区', '511302');
INSERT INTO `area_mapping` VALUES (2228, '四川省', '510000', '南充市', '511300', '高坪区', '511303');
INSERT INTO `area_mapping` VALUES (2229, '四川省', '510000', '南充市', '511300', '嘉陵区', '511304');
INSERT INTO `area_mapping` VALUES (2230, '四川省', '510000', '南充市', '511300', '南部县', '511321');
INSERT INTO `area_mapping` VALUES (2231, '四川省', '510000', '南充市', '511300', '营山县', '511322');
INSERT INTO `area_mapping` VALUES (2232, '四川省', '510000', '南充市', '511300', '蓬安县', '511323');
INSERT INTO `area_mapping` VALUES (2233, '四川省', '510000', '南充市', '511300', '仪陇县', '511324');
INSERT INTO `area_mapping` VALUES (2234, '四川省', '510000', '南充市', '511300', '西充县', '511325');
INSERT INTO `area_mapping` VALUES (2235, '四川省', '510000', '南充市', '511300', '阆中市', '511381');
INSERT INTO `area_mapping` VALUES (2236, '四川省', '510000', '眉山市', '511400', '东坡区', '511402');
INSERT INTO `area_mapping` VALUES (2237, '四川省', '510000', '眉山市', '511400', '彭山区', '511403');
INSERT INTO `area_mapping` VALUES (2238, '四川省', '510000', '眉山市', '511400', '仁寿县', '511421');
INSERT INTO `area_mapping` VALUES (2239, '四川省', '510000', '眉山市', '511400', '洪雅县', '511423');
INSERT INTO `area_mapping` VALUES (2240, '四川省', '510000', '眉山市', '511400', '丹棱县', '511424');
INSERT INTO `area_mapping` VALUES (2241, '四川省', '510000', '眉山市', '511400', '青神县', '511425');
INSERT INTO `area_mapping` VALUES (2242, '四川省', '510000', '宜宾市', '511500', '翠屏区', '511502');
INSERT INTO `area_mapping` VALUES (2243, '四川省', '510000', '宜宾市', '511500', '南溪区', '511503');
INSERT INTO `area_mapping` VALUES (2244, '四川省', '510000', '宜宾市', '511500', '叙州区', '511504');
INSERT INTO `area_mapping` VALUES (2245, '四川省', '510000', '宜宾市', '511500', '江安县', '511523');
INSERT INTO `area_mapping` VALUES (2246, '四川省', '510000', '宜宾市', '511500', '长宁县', '511524');
INSERT INTO `area_mapping` VALUES (2247, '四川省', '510000', '宜宾市', '511500', '高县', '511525');
INSERT INTO `area_mapping` VALUES (2248, '四川省', '510000', '宜宾市', '511500', '珙县', '511526');
INSERT INTO `area_mapping` VALUES (2249, '四川省', '510000', '宜宾市', '511500', '筠连县', '511527');
INSERT INTO `area_mapping` VALUES (2250, '四川省', '510000', '宜宾市', '511500', '兴文县', '511528');
INSERT INTO `area_mapping` VALUES (2251, '四川省', '510000', '宜宾市', '511500', '屏山县', '511529');
INSERT INTO `area_mapping` VALUES (2252, '四川省', '510000', '广安市', '511600', '广安区', '511602');
INSERT INTO `area_mapping` VALUES (2253, '四川省', '510000', '广安市', '511600', '前锋区', '511603');
INSERT INTO `area_mapping` VALUES (2254, '四川省', '510000', '广安市', '511600', '岳池县', '511621');
INSERT INTO `area_mapping` VALUES (2255, '四川省', '510000', '广安市', '511600', '武胜县', '511622');
INSERT INTO `area_mapping` VALUES (2256, '四川省', '510000', '广安市', '511600', '邻水县', '511623');
INSERT INTO `area_mapping` VALUES (2257, '四川省', '510000', '广安市', '511600', '华蓥市', '511681');
INSERT INTO `area_mapping` VALUES (2258, '四川省', '510000', '达州市', '511700', '通川区', '511702');
INSERT INTO `area_mapping` VALUES (2259, '四川省', '510000', '达州市', '511700', '达川区', '511703');
INSERT INTO `area_mapping` VALUES (2260, '四川省', '510000', '达州市', '511700', '宣汉县', '511722');
INSERT INTO `area_mapping` VALUES (2261, '四川省', '510000', '达州市', '511700', '开江县', '511723');
INSERT INTO `area_mapping` VALUES (2262, '四川省', '510000', '达州市', '511700', '大竹县', '511724');
INSERT INTO `area_mapping` VALUES (2263, '四川省', '510000', '达州市', '511700', '渠县', '511725');
INSERT INTO `area_mapping` VALUES (2264, '四川省', '510000', '达州市', '511700', '达州经济开发区', '511771');
INSERT INTO `area_mapping` VALUES (2265, '四川省', '510000', '达州市', '511700', '万源市', '511781');
INSERT INTO `area_mapping` VALUES (2266, '四川省', '510000', '雅安市', '511800', '雨城区', '511802');
INSERT INTO `area_mapping` VALUES (2267, '四川省', '510000', '雅安市', '511800', '名山区', '511803');
INSERT INTO `area_mapping` VALUES (2268, '四川省', '510000', '雅安市', '511800', '荥经县', '511822');
INSERT INTO `area_mapping` VALUES (2269, '四川省', '510000', '雅安市', '511800', '汉源县', '511823');
INSERT INTO `area_mapping` VALUES (2270, '四川省', '510000', '雅安市', '511800', '石棉县', '511824');
INSERT INTO `area_mapping` VALUES (2271, '四川省', '510000', '雅安市', '511800', '天全县', '511825');
INSERT INTO `area_mapping` VALUES (2272, '四川省', '510000', '雅安市', '511800', '芦山县', '511826');
INSERT INTO `area_mapping` VALUES (2273, '四川省', '510000', '雅安市', '511800', '宝兴县', '511827');
INSERT INTO `area_mapping` VALUES (2274, '四川省', '510000', '巴中市', '511900', '巴州区', '511902');
INSERT INTO `area_mapping` VALUES (2275, '四川省', '510000', '巴中市', '511900', '恩阳区', '511903');
INSERT INTO `area_mapping` VALUES (2276, '四川省', '510000', '巴中市', '511900', '通江县', '511921');
INSERT INTO `area_mapping` VALUES (2277, '四川省', '510000', '巴中市', '511900', '南江县', '511922');
INSERT INTO `area_mapping` VALUES (2278, '四川省', '510000', '巴中市', '511900', '平昌县', '511923');
INSERT INTO `area_mapping` VALUES (2279, '四川省', '510000', '巴中市', '511900', '巴中经济开发区', '511971');
INSERT INTO `area_mapping` VALUES (2280, '四川省', '510000', '资阳市', '512000', '雁江区', '512002');
INSERT INTO `area_mapping` VALUES (2281, '四川省', '510000', '资阳市', '512000', '安岳县', '512021');
INSERT INTO `area_mapping` VALUES (2282, '四川省', '510000', '资阳市', '512000', '乐至县', '512022');
INSERT INTO `area_mapping` VALUES (2283, '四川省', '510000', '阿坝藏族羌族自治州', '513200', '马尔康市', '513201');
INSERT INTO `area_mapping` VALUES (2284, '四川省', '510000', '阿坝藏族羌族自治州', '513200', '汶川县', '513221');
INSERT INTO `area_mapping` VALUES (2285, '四川省', '510000', '阿坝藏族羌族自治州', '513200', '理县', '513222');
INSERT INTO `area_mapping` VALUES (2286, '四川省', '510000', '阿坝藏族羌族自治州', '513200', '茂县', '513223');
INSERT INTO `area_mapping` VALUES (2287, '四川省', '510000', '阿坝藏族羌族自治州', '513200', '松潘县', '513224');
INSERT INTO `area_mapping` VALUES (2288, '四川省', '510000', '阿坝藏族羌族自治州', '513200', '九寨沟县', '513225');
INSERT INTO `area_mapping` VALUES (2289, '四川省', '510000', '阿坝藏族羌族自治州', '513200', '金川县', '513226');
INSERT INTO `area_mapping` VALUES (2290, '四川省', '510000', '阿坝藏族羌族自治州', '513200', '小金县', '513227');
INSERT INTO `area_mapping` VALUES (2291, '四川省', '510000', '阿坝藏族羌族自治州', '513200', '黑水县', '513228');
INSERT INTO `area_mapping` VALUES (2292, '四川省', '510000', '阿坝藏族羌族自治州', '513200', '壤塘县', '513230');
INSERT INTO `area_mapping` VALUES (2293, '四川省', '510000', '阿坝藏族羌族自治州', '513200', '阿坝县', '513231');
INSERT INTO `area_mapping` VALUES (2294, '四川省', '510000', '阿坝藏族羌族自治州', '513200', '若尔盖县', '513232');
INSERT INTO `area_mapping` VALUES (2295, '四川省', '510000', '阿坝藏族羌族自治州', '513200', '红原县', '513233');
INSERT INTO `area_mapping` VALUES (2296, '四川省', '510000', '甘孜藏族自治州', '513300', '康定市', '513301');
INSERT INTO `area_mapping` VALUES (2297, '四川省', '510000', '甘孜藏族自治州', '513300', '泸定县', '513322');
INSERT INTO `area_mapping` VALUES (2298, '四川省', '510000', '甘孜藏族自治州', '513300', '丹巴县', '513323');
INSERT INTO `area_mapping` VALUES (2299, '四川省', '510000', '甘孜藏族自治州', '513300', '九龙县', '513324');
INSERT INTO `area_mapping` VALUES (2300, '四川省', '510000', '甘孜藏族自治州', '513300', '雅江县', '513325');
INSERT INTO `area_mapping` VALUES (2301, '四川省', '510000', '甘孜藏族自治州', '513300', '道孚县', '513326');
INSERT INTO `area_mapping` VALUES (2302, '四川省', '510000', '甘孜藏族自治州', '513300', '炉霍县', '513327');
INSERT INTO `area_mapping` VALUES (2303, '四川省', '510000', '甘孜藏族自治州', '513300', '甘孜县', '513328');
INSERT INTO `area_mapping` VALUES (2304, '四川省', '510000', '甘孜藏族自治州', '513300', '新龙县', '513329');
INSERT INTO `area_mapping` VALUES (2305, '四川省', '510000', '甘孜藏族自治州', '513300', '德格县', '513330');
INSERT INTO `area_mapping` VALUES (2306, '四川省', '510000', '甘孜藏族自治州', '513300', '白玉县', '513331');
INSERT INTO `area_mapping` VALUES (2307, '四川省', '510000', '甘孜藏族自治州', '513300', '石渠县', '513332');
INSERT INTO `area_mapping` VALUES (2308, '四川省', '510000', '甘孜藏族自治州', '513300', '色达县', '513333');
INSERT INTO `area_mapping` VALUES (2309, '四川省', '510000', '甘孜藏族自治州', '513300', '理塘县', '513334');
INSERT INTO `area_mapping` VALUES (2310, '四川省', '510000', '甘孜藏族自治州', '513300', '巴塘县', '513335');
INSERT INTO `area_mapping` VALUES (2311, '四川省', '510000', '甘孜藏族自治州', '513300', '乡城县', '513336');
INSERT INTO `area_mapping` VALUES (2312, '四川省', '510000', '甘孜藏族自治州', '513300', '稻城县', '513337');
INSERT INTO `area_mapping` VALUES (2313, '四川省', '510000', '甘孜藏族自治州', '513300', '得荣县', '513338');
INSERT INTO `area_mapping` VALUES (2314, '四川省', '510000', '凉山彝族自治州', '513400', '西昌市', '513401');
INSERT INTO `area_mapping` VALUES (2315, '四川省', '510000', '凉山彝族自治州', '513400', '木里藏族自治县', '513422');
INSERT INTO `area_mapping` VALUES (2316, '四川省', '510000', '凉山彝族自治州', '513400', '盐源县', '513423');
INSERT INTO `area_mapping` VALUES (2317, '四川省', '510000', '凉山彝族自治州', '513400', '德昌县', '513424');
INSERT INTO `area_mapping` VALUES (2318, '四川省', '510000', '凉山彝族自治州', '513400', '会理县', '513425');
INSERT INTO `area_mapping` VALUES (2319, '四川省', '510000', '凉山彝族自治州', '513400', '会东县', '513426');
INSERT INTO `area_mapping` VALUES (2320, '四川省', '510000', '凉山彝族自治州', '513400', '宁南县', '513427');
INSERT INTO `area_mapping` VALUES (2321, '四川省', '510000', '凉山彝族自治州', '513400', '普格县', '513428');
INSERT INTO `area_mapping` VALUES (2322, '四川省', '510000', '凉山彝族自治州', '513400', '布拖县', '513429');
INSERT INTO `area_mapping` VALUES (2323, '四川省', '510000', '凉山彝族自治州', '513400', '金阳县', '513430');
INSERT INTO `area_mapping` VALUES (2324, '四川省', '510000', '凉山彝族自治州', '513400', '昭觉县', '513431');
INSERT INTO `area_mapping` VALUES (2325, '四川省', '510000', '凉山彝族自治州', '513400', '喜德县', '513432');
INSERT INTO `area_mapping` VALUES (2326, '四川省', '510000', '凉山彝族自治州', '513400', '冕宁县', '513433');
INSERT INTO `area_mapping` VALUES (2327, '四川省', '510000', '凉山彝族自治州', '513400', '越西县', '513434');
INSERT INTO `area_mapping` VALUES (2328, '四川省', '510000', '凉山彝族自治州', '513400', '甘洛县', '513435');
INSERT INTO `area_mapping` VALUES (2329, '四川省', '510000', '凉山彝族自治州', '513400', '美姑县', '513436');
INSERT INTO `area_mapping` VALUES (2330, '四川省', '510000', '凉山彝族自治州', '513400', '雷波县', '513437');
INSERT INTO `area_mapping` VALUES (2331, '贵州省', '520000', '贵阳市', '520100', '南明区', '520102');
INSERT INTO `area_mapping` VALUES (2332, '贵州省', '520000', '贵阳市', '520100', '云岩区', '520103');
INSERT INTO `area_mapping` VALUES (2333, '贵州省', '520000', '贵阳市', '520100', '花溪区', '520111');
INSERT INTO `area_mapping` VALUES (2334, '贵州省', '520000', '贵阳市', '520100', '乌当区', '520112');
INSERT INTO `area_mapping` VALUES (2335, '贵州省', '520000', '贵阳市', '520100', '白云区', '520113');
INSERT INTO `area_mapping` VALUES (2336, '贵州省', '520000', '贵阳市', '520100', '观山湖区', '520115');
INSERT INTO `area_mapping` VALUES (2337, '贵州省', '520000', '贵阳市', '520100', '开阳县', '520121');
INSERT INTO `area_mapping` VALUES (2338, '贵州省', '520000', '贵阳市', '520100', '息烽县', '520122');
INSERT INTO `area_mapping` VALUES (2339, '贵州省', '520000', '贵阳市', '520100', '修文县', '520123');
INSERT INTO `area_mapping` VALUES (2340, '贵州省', '520000', '贵阳市', '520100', '清镇市', '520181');
INSERT INTO `area_mapping` VALUES (2341, '贵州省', '520000', '六盘水市', '520200', '钟山区', '520201');
INSERT INTO `area_mapping` VALUES (2342, '贵州省', '520000', '六盘水市', '520200', '六枝特区', '520203');
INSERT INTO `area_mapping` VALUES (2343, '贵州省', '520000', '六盘水市', '520200', '水城县', '520221');
INSERT INTO `area_mapping` VALUES (2344, '贵州省', '520000', '六盘水市', '520200', '盘州市', '520281');
INSERT INTO `area_mapping` VALUES (2345, '贵州省', '520000', '遵义市', '520300', '红花岗区', '520302');
INSERT INTO `area_mapping` VALUES (2346, '贵州省', '520000', '遵义市', '520300', '汇川区', '520303');
INSERT INTO `area_mapping` VALUES (2347, '贵州省', '520000', '遵义市', '520300', '播州区', '520304');
INSERT INTO `area_mapping` VALUES (2348, '贵州省', '520000', '遵义市', '520300', '桐梓县', '520322');
INSERT INTO `area_mapping` VALUES (2349, '贵州省', '520000', '遵义市', '520300', '绥阳县', '520323');
INSERT INTO `area_mapping` VALUES (2350, '贵州省', '520000', '遵义市', '520300', '正安县', '520324');
INSERT INTO `area_mapping` VALUES (2351, '贵州省', '520000', '遵义市', '520300', '道真仡佬族苗族自治县', '520325');
INSERT INTO `area_mapping` VALUES (2352, '贵州省', '520000', '遵义市', '520300', '务川仡佬族苗族自治县', '520326');
INSERT INTO `area_mapping` VALUES (2353, '贵州省', '520000', '遵义市', '520300', '凤冈县', '520327');
INSERT INTO `area_mapping` VALUES (2354, '贵州省', '520000', '遵义市', '520300', '湄潭县', '520328');
INSERT INTO `area_mapping` VALUES (2355, '贵州省', '520000', '遵义市', '520300', '余庆县', '520329');
INSERT INTO `area_mapping` VALUES (2356, '贵州省', '520000', '遵义市', '520300', '习水县', '520330');
INSERT INTO `area_mapping` VALUES (2357, '贵州省', '520000', '遵义市', '520300', '赤水市', '520381');
INSERT INTO `area_mapping` VALUES (2358, '贵州省', '520000', '遵义市', '520300', '仁怀市', '520382');
INSERT INTO `area_mapping` VALUES (2359, '贵州省', '520000', '安顺市', '520400', '西秀区', '520402');
INSERT INTO `area_mapping` VALUES (2360, '贵州省', '520000', '安顺市', '520400', '平坝区', '520403');
INSERT INTO `area_mapping` VALUES (2361, '贵州省', '520000', '安顺市', '520400', '普定县', '520422');
INSERT INTO `area_mapping` VALUES (2362, '贵州省', '520000', '安顺市', '520400', '镇宁布依族苗族自治县', '520423');
INSERT INTO `area_mapping` VALUES (2363, '贵州省', '520000', '安顺市', '520400', '关岭布依族苗族自治县', '520424');
INSERT INTO `area_mapping` VALUES (2364, '贵州省', '520000', '安顺市', '520400', '紫云苗族布依族自治县', '520425');
INSERT INTO `area_mapping` VALUES (2365, '贵州省', '520000', '毕节市', '520500', '七星关区', '520502');
INSERT INTO `area_mapping` VALUES (2366, '贵州省', '520000', '毕节市', '520500', '大方县', '520521');
INSERT INTO `area_mapping` VALUES (2367, '贵州省', '520000', '毕节市', '520500', '黔西县', '520522');
INSERT INTO `area_mapping` VALUES (2368, '贵州省', '520000', '毕节市', '520500', '金沙县', '520523');
INSERT INTO `area_mapping` VALUES (2369, '贵州省', '520000', '毕节市', '520500', '织金县', '520524');
INSERT INTO `area_mapping` VALUES (2370, '贵州省', '520000', '毕节市', '520500', '纳雍县', '520525');
INSERT INTO `area_mapping` VALUES (2371, '贵州省', '520000', '毕节市', '520500', '威宁彝族回族苗族自治县', '520526');
INSERT INTO `area_mapping` VALUES (2372, '贵州省', '520000', '毕节市', '520500', '赫章县', '520527');
INSERT INTO `area_mapping` VALUES (2373, '贵州省', '520000', '铜仁市', '520600', '碧江区', '520602');
INSERT INTO `area_mapping` VALUES (2374, '贵州省', '520000', '铜仁市', '520600', '万山区', '520603');
INSERT INTO `area_mapping` VALUES (2375, '贵州省', '520000', '铜仁市', '520600', '江口县', '520621');
INSERT INTO `area_mapping` VALUES (2376, '贵州省', '520000', '铜仁市', '520600', '玉屏侗族自治县', '520622');
INSERT INTO `area_mapping` VALUES (2377, '贵州省', '520000', '铜仁市', '520600', '石阡县', '520623');
INSERT INTO `area_mapping` VALUES (2378, '贵州省', '520000', '铜仁市', '520600', '思南县', '520624');
INSERT INTO `area_mapping` VALUES (2379, '贵州省', '520000', '铜仁市', '520600', '印江土家族苗族自治县', '520625');
INSERT INTO `area_mapping` VALUES (2380, '贵州省', '520000', '铜仁市', '520600', '德江县', '520626');
INSERT INTO `area_mapping` VALUES (2381, '贵州省', '520000', '铜仁市', '520600', '沿河土家族自治县', '520627');
INSERT INTO `area_mapping` VALUES (2382, '贵州省', '520000', '铜仁市', '520600', '松桃苗族自治县', '520628');
INSERT INTO `area_mapping` VALUES (2383, '贵州省', '520000', '黔西南布依族苗族自治州', '522300', '兴义市', '522301');
INSERT INTO `area_mapping` VALUES (2384, '贵州省', '520000', '黔西南布依族苗族自治州', '522300', '兴仁市', '522302');
INSERT INTO `area_mapping` VALUES (2385, '贵州省', '520000', '黔西南布依族苗族自治州', '522300', '普安县', '522323');
INSERT INTO `area_mapping` VALUES (2386, '贵州省', '520000', '黔西南布依族苗族自治州', '522300', '晴隆县', '522324');
INSERT INTO `area_mapping` VALUES (2387, '贵州省', '520000', '黔西南布依族苗族自治州', '522300', '贞丰县', '522325');
INSERT INTO `area_mapping` VALUES (2388, '贵州省', '520000', '黔西南布依族苗族自治州', '522300', '望谟县', '522326');
INSERT INTO `area_mapping` VALUES (2389, '贵州省', '520000', '黔西南布依族苗族自治州', '522300', '册亨县', '522327');
INSERT INTO `area_mapping` VALUES (2390, '贵州省', '520000', '黔西南布依族苗族自治州', '522300', '安龙县', '522328');
INSERT INTO `area_mapping` VALUES (2391, '贵州省', '520000', '黔东南苗族侗族自治州', '522600', '凯里市', '522601');
INSERT INTO `area_mapping` VALUES (2392, '贵州省', '520000', '黔东南苗族侗族自治州', '522600', '黄平县', '522622');
INSERT INTO `area_mapping` VALUES (2393, '贵州省', '520000', '黔东南苗族侗族自治州', '522600', '施秉县', '522623');
INSERT INTO `area_mapping` VALUES (2394, '贵州省', '520000', '黔东南苗族侗族自治州', '522600', '三穗县', '522624');
INSERT INTO `area_mapping` VALUES (2395, '贵州省', '520000', '黔东南苗族侗族自治州', '522600', '镇远县', '522625');
INSERT INTO `area_mapping` VALUES (2396, '贵州省', '520000', '黔东南苗族侗族自治州', '522600', '岑巩县', '522626');
INSERT INTO `area_mapping` VALUES (2397, '贵州省', '520000', '黔东南苗族侗族自治州', '522600', '天柱县', '522627');
INSERT INTO `area_mapping` VALUES (2398, '贵州省', '520000', '黔东南苗族侗族自治州', '522600', '锦屏县', '522628');
INSERT INTO `area_mapping` VALUES (2399, '贵州省', '520000', '黔东南苗族侗族自治州', '522600', '剑河县', '522629');
INSERT INTO `area_mapping` VALUES (2400, '贵州省', '520000', '黔东南苗族侗族自治州', '522600', '台江县', '522630');
INSERT INTO `area_mapping` VALUES (2401, '贵州省', '520000', '黔东南苗族侗族自治州', '522600', '黎平县', '522631');
INSERT INTO `area_mapping` VALUES (2402, '贵州省', '520000', '黔东南苗族侗族自治州', '522600', '榕江县', '522632');
INSERT INTO `area_mapping` VALUES (2403, '贵州省', '520000', '黔东南苗族侗族自治州', '522600', '从江县', '522633');
INSERT INTO `area_mapping` VALUES (2404, '贵州省', '520000', '黔东南苗族侗族自治州', '522600', '雷山县', '522634');
INSERT INTO `area_mapping` VALUES (2405, '贵州省', '520000', '黔东南苗族侗族自治州', '522600', '麻江县', '522635');
INSERT INTO `area_mapping` VALUES (2406, '贵州省', '520000', '黔东南苗族侗族自治州', '522600', '丹寨县', '522636');
INSERT INTO `area_mapping` VALUES (2407, '贵州省', '520000', '黔南布依族苗族自治州', '522700', '都匀市', '522701');
INSERT INTO `area_mapping` VALUES (2408, '贵州省', '520000', '黔南布依族苗族自治州', '522700', '福泉市', '522702');
INSERT INTO `area_mapping` VALUES (2409, '贵州省', '520000', '黔南布依族苗族自治州', '522700', '荔波县', '522722');
INSERT INTO `area_mapping` VALUES (2410, '贵州省', '520000', '黔南布依族苗族自治州', '522700', '贵定县', '522723');
INSERT INTO `area_mapping` VALUES (2411, '贵州省', '520000', '黔南布依族苗族自治州', '522700', '瓮安县', '522725');
INSERT INTO `area_mapping` VALUES (2412, '贵州省', '520000', '黔南布依族苗族自治州', '522700', '独山县', '522726');
INSERT INTO `area_mapping` VALUES (2413, '贵州省', '520000', '黔南布依族苗族自治州', '522700', '平塘县', '522727');
INSERT INTO `area_mapping` VALUES (2414, '贵州省', '520000', '黔南布依族苗族自治州', '522700', '罗甸县', '522728');
INSERT INTO `area_mapping` VALUES (2415, '贵州省', '520000', '黔南布依族苗族自治州', '522700', '长顺县', '522729');
INSERT INTO `area_mapping` VALUES (2416, '贵州省', '520000', '黔南布依族苗族自治州', '522700', '龙里县', '522730');
INSERT INTO `area_mapping` VALUES (2417, '贵州省', '520000', '黔南布依族苗族自治州', '522700', '惠水县', '522731');
INSERT INTO `area_mapping` VALUES (2418, '贵州省', '520000', '黔南布依族苗族自治州', '522700', '三都水族自治县', '522732');
INSERT INTO `area_mapping` VALUES (2419, '云南省', '530000', '昆明市', '530100', '五华区', '530102');
INSERT INTO `area_mapping` VALUES (2420, '云南省', '530000', '昆明市', '530100', '盘龙区', '530103');
INSERT INTO `area_mapping` VALUES (2421, '云南省', '530000', '昆明市', '530100', '官渡区', '530111');
INSERT INTO `area_mapping` VALUES (2422, '云南省', '530000', '昆明市', '530100', '西山区', '530112');
INSERT INTO `area_mapping` VALUES (2423, '云南省', '530000', '昆明市', '530100', '东川区', '530113');
INSERT INTO `area_mapping` VALUES (2424, '云南省', '530000', '昆明市', '530100', '呈贡区', '530114');
INSERT INTO `area_mapping` VALUES (2425, '云南省', '530000', '昆明市', '530100', '晋宁区', '530115');
INSERT INTO `area_mapping` VALUES (2426, '云南省', '530000', '昆明市', '530100', '富民县', '530124');
INSERT INTO `area_mapping` VALUES (2427, '云南省', '530000', '昆明市', '530100', '宜良县', '530125');
INSERT INTO `area_mapping` VALUES (2428, '云南省', '530000', '昆明市', '530100', '石林彝族自治县', '530126');
INSERT INTO `area_mapping` VALUES (2429, '云南省', '530000', '昆明市', '530100', '嵩明县', '530127');
INSERT INTO `area_mapping` VALUES (2430, '云南省', '530000', '昆明市', '530100', '禄劝彝族苗族自治县', '530128');
INSERT INTO `area_mapping` VALUES (2431, '云南省', '530000', '昆明市', '530100', '寻甸回族彝族自治县', '530129');
INSERT INTO `area_mapping` VALUES (2432, '云南省', '530000', '昆明市', '530100', '安宁市', '530181');
INSERT INTO `area_mapping` VALUES (2433, '云南省', '530000', '曲靖市', '530300', '麒麟区', '530302');
INSERT INTO `area_mapping` VALUES (2434, '云南省', '530000', '曲靖市', '530300', '沾益区', '530303');
INSERT INTO `area_mapping` VALUES (2435, '云南省', '530000', '曲靖市', '530300', '马龙区', '530304');
INSERT INTO `area_mapping` VALUES (2436, '云南省', '530000', '曲靖市', '530300', '陆良县', '530322');
INSERT INTO `area_mapping` VALUES (2437, '云南省', '530000', '曲靖市', '530300', '师宗县', '530323');
INSERT INTO `area_mapping` VALUES (2438, '云南省', '530000', '曲靖市', '530300', '罗平县', '530324');
INSERT INTO `area_mapping` VALUES (2439, '云南省', '530000', '曲靖市', '530300', '富源县', '530325');
INSERT INTO `area_mapping` VALUES (2440, '云南省', '530000', '曲靖市', '530300', '会泽县', '530326');
INSERT INTO `area_mapping` VALUES (2441, '云南省', '530000', '曲靖市', '530300', '宣威市', '530381');
INSERT INTO `area_mapping` VALUES (2442, '云南省', '530000', '玉溪市', '530400', '红塔区', '530402');
INSERT INTO `area_mapping` VALUES (2443, '云南省', '530000', '玉溪市', '530400', '江川区', '530403');
INSERT INTO `area_mapping` VALUES (2444, '云南省', '530000', '玉溪市', '530400', '通海县', '530423');
INSERT INTO `area_mapping` VALUES (2445, '云南省', '530000', '玉溪市', '530400', '华宁县', '530424');
INSERT INTO `area_mapping` VALUES (2446, '云南省', '530000', '玉溪市', '530400', '易门县', '530425');
INSERT INTO `area_mapping` VALUES (2447, '云南省', '530000', '玉溪市', '530400', '峨山彝族自治县', '530426');
INSERT INTO `area_mapping` VALUES (2448, '云南省', '530000', '玉溪市', '530400', '新平彝族傣族自治县', '530427');
INSERT INTO `area_mapping` VALUES (2449, '云南省', '530000', '玉溪市', '530400', '元江哈尼族彝族傣族自治县', '530428');
INSERT INTO `area_mapping` VALUES (2450, '云南省', '530000', '玉溪市', '530400', '澄江市', '530481');
INSERT INTO `area_mapping` VALUES (2451, '云南省', '530000', '保山市', '530500', '隆阳区', '530502');
INSERT INTO `area_mapping` VALUES (2452, '云南省', '530000', '保山市', '530500', '施甸县', '530521');
INSERT INTO `area_mapping` VALUES (2453, '云南省', '530000', '保山市', '530500', '龙陵县', '530523');
INSERT INTO `area_mapping` VALUES (2454, '云南省', '530000', '保山市', '530500', '昌宁县', '530524');
INSERT INTO `area_mapping` VALUES (2455, '云南省', '530000', '保山市', '530500', '腾冲市', '530581');
INSERT INTO `area_mapping` VALUES (2456, '云南省', '530000', '昭通市', '530600', '昭阳区', '530602');
INSERT INTO `area_mapping` VALUES (2457, '云南省', '530000', '昭通市', '530600', '鲁甸县', '530621');
INSERT INTO `area_mapping` VALUES (2458, '云南省', '530000', '昭通市', '530600', '巧家县', '530622');
INSERT INTO `area_mapping` VALUES (2459, '云南省', '530000', '昭通市', '530600', '盐津县', '530623');
INSERT INTO `area_mapping` VALUES (2460, '云南省', '530000', '昭通市', '530600', '大关县', '530624');
INSERT INTO `area_mapping` VALUES (2461, '云南省', '530000', '昭通市', '530600', '永善县', '530625');
INSERT INTO `area_mapping` VALUES (2462, '云南省', '530000', '昭通市', '530600', '绥江县', '530626');
INSERT INTO `area_mapping` VALUES (2463, '云南省', '530000', '昭通市', '530600', '镇雄县', '530627');
INSERT INTO `area_mapping` VALUES (2464, '云南省', '530000', '昭通市', '530600', '彝良县', '530628');
INSERT INTO `area_mapping` VALUES (2465, '云南省', '530000', '昭通市', '530600', '威信县', '530629');
INSERT INTO `area_mapping` VALUES (2466, '云南省', '530000', '昭通市', '530600', '水富市', '530681');
INSERT INTO `area_mapping` VALUES (2467, '云南省', '530000', '丽江市', '530700', '古城区', '530702');
INSERT INTO `area_mapping` VALUES (2468, '云南省', '530000', '丽江市', '530700', '玉龙纳西族自治县', '530721');
INSERT INTO `area_mapping` VALUES (2469, '云南省', '530000', '丽江市', '530700', '永胜县', '530722');
INSERT INTO `area_mapping` VALUES (2470, '云南省', '530000', '丽江市', '530700', '华坪县', '530723');
INSERT INTO `area_mapping` VALUES (2471, '云南省', '530000', '丽江市', '530700', '宁蒗彝族自治县', '530724');
INSERT INTO `area_mapping` VALUES (2472, '云南省', '530000', '普洱市', '530800', '思茅区', '530802');
INSERT INTO `area_mapping` VALUES (2473, '云南省', '530000', '普洱市', '530800', '宁洱哈尼族彝族自治县', '530821');
INSERT INTO `area_mapping` VALUES (2474, '云南省', '530000', '普洱市', '530800', '墨江哈尼族自治县', '530822');
INSERT INTO `area_mapping` VALUES (2475, '云南省', '530000', '普洱市', '530800', '景东彝族自治县', '530823');
INSERT INTO `area_mapping` VALUES (2476, '云南省', '530000', '普洱市', '530800', '景谷傣族彝族自治县', '530824');
INSERT INTO `area_mapping` VALUES (2477, '云南省', '530000', '普洱市', '530800', '镇沅彝族哈尼族拉祜族自治县', '530825');
INSERT INTO `area_mapping` VALUES (2478, '云南省', '530000', '普洱市', '530800', '江城哈尼族彝族自治县', '530826');
INSERT INTO `area_mapping` VALUES (2479, '云南省', '530000', '普洱市', '530800', '孟连傣族拉祜族佤族自治县', '530827');
INSERT INTO `area_mapping` VALUES (2480, '云南省', '530000', '普洱市', '530800', '澜沧拉祜族自治县', '530828');
INSERT INTO `area_mapping` VALUES (2481, '云南省', '530000', '普洱市', '530800', '西盟佤族自治县', '530829');
INSERT INTO `area_mapping` VALUES (2482, '云南省', '530000', '临沧市', '530900', '临翔区', '530902');
INSERT INTO `area_mapping` VALUES (2483, '云南省', '530000', '临沧市', '530900', '凤庆县', '530921');
INSERT INTO `area_mapping` VALUES (2484, '云南省', '530000', '临沧市', '530900', '云县', '530922');
INSERT INTO `area_mapping` VALUES (2485, '云南省', '530000', '临沧市', '530900', '永德县', '530923');
INSERT INTO `area_mapping` VALUES (2486, '云南省', '530000', '临沧市', '530900', '镇康县', '530924');
INSERT INTO `area_mapping` VALUES (2487, '云南省', '530000', '临沧市', '530900', '双江拉祜族佤族布朗族傣族自治县', '530925');
INSERT INTO `area_mapping` VALUES (2488, '云南省', '530000', '临沧市', '530900', '耿马傣族佤族自治县', '530926');
INSERT INTO `area_mapping` VALUES (2489, '云南省', '530000', '临沧市', '530900', '沧源佤族自治县', '530927');
INSERT INTO `area_mapping` VALUES (2490, '云南省', '530000', '楚雄彝族自治州', '532300', '楚雄市', '532301');
INSERT INTO `area_mapping` VALUES (2491, '云南省', '530000', '楚雄彝族自治州', '532300', '双柏县', '532322');
INSERT INTO `area_mapping` VALUES (2492, '云南省', '530000', '楚雄彝族自治州', '532300', '牟定县', '532323');
INSERT INTO `area_mapping` VALUES (2493, '云南省', '530000', '楚雄彝族自治州', '532300', '南华县', '532324');
INSERT INTO `area_mapping` VALUES (2494, '云南省', '530000', '楚雄彝族自治州', '532300', '姚安县', '532325');
INSERT INTO `area_mapping` VALUES (2495, '云南省', '530000', '楚雄彝族自治州', '532300', '大姚县', '532326');
INSERT INTO `area_mapping` VALUES (2496, '云南省', '530000', '楚雄彝族自治州', '532300', '永仁县', '532327');
INSERT INTO `area_mapping` VALUES (2497, '云南省', '530000', '楚雄彝族自治州', '532300', '元谋县', '532328');
INSERT INTO `area_mapping` VALUES (2498, '云南省', '530000', '楚雄彝族自治州', '532300', '武定县', '532329');
INSERT INTO `area_mapping` VALUES (2499, '云南省', '530000', '楚雄彝族自治州', '532300', '禄丰县', '532331');
INSERT INTO `area_mapping` VALUES (2500, '云南省', '530000', '红河哈尼族彝族自治州', '532500', '个旧市', '532501');
INSERT INTO `area_mapping` VALUES (2501, '云南省', '530000', '红河哈尼族彝族自治州', '532500', '开远市', '532502');
INSERT INTO `area_mapping` VALUES (2502, '云南省', '530000', '红河哈尼族彝族自治州', '532500', '蒙自市', '532503');
INSERT INTO `area_mapping` VALUES (2503, '云南省', '530000', '红河哈尼族彝族自治州', '532500', '弥勒市', '532504');
INSERT INTO `area_mapping` VALUES (2504, '云南省', '530000', '红河哈尼族彝族自治州', '532500', '屏边苗族自治县', '532523');
INSERT INTO `area_mapping` VALUES (2505, '云南省', '530000', '红河哈尼族彝族自治州', '532500', '建水县', '532524');
INSERT INTO `area_mapping` VALUES (2506, '云南省', '530000', '红河哈尼族彝族自治州', '532500', '石屏县', '532525');
INSERT INTO `area_mapping` VALUES (2507, '云南省', '530000', '红河哈尼族彝族自治州', '532500', '泸西县', '532527');
INSERT INTO `area_mapping` VALUES (2508, '云南省', '530000', '红河哈尼族彝族自治州', '532500', '元阳县', '532528');
INSERT INTO `area_mapping` VALUES (2509, '云南省', '530000', '红河哈尼族彝族自治州', '532500', '红河县', '532529');
INSERT INTO `area_mapping` VALUES (2510, '云南省', '530000', '红河哈尼族彝族自治州', '532500', '金平苗族瑶族傣族自治县', '532530');
INSERT INTO `area_mapping` VALUES (2511, '云南省', '530000', '红河哈尼族彝族自治州', '532500', '绿春县', '532531');
INSERT INTO `area_mapping` VALUES (2512, '云南省', '530000', '红河哈尼族彝族自治州', '532500', '河口瑶族自治县', '532532');
INSERT INTO `area_mapping` VALUES (2513, '云南省', '530000', '文山壮族苗族自治州', '532600', '文山市', '532601');
INSERT INTO `area_mapping` VALUES (2514, '云南省', '530000', '文山壮族苗族自治州', '532600', '砚山县', '532622');
INSERT INTO `area_mapping` VALUES (2515, '云南省', '530000', '文山壮族苗族自治州', '532600', '西畴县', '532623');
INSERT INTO `area_mapping` VALUES (2516, '云南省', '530000', '文山壮族苗族自治州', '532600', '麻栗坡县', '532624');
INSERT INTO `area_mapping` VALUES (2517, '云南省', '530000', '文山壮族苗族自治州', '532600', '马关县', '532625');
INSERT INTO `area_mapping` VALUES (2518, '云南省', '530000', '文山壮族苗族自治州', '532600', '丘北县', '532626');
INSERT INTO `area_mapping` VALUES (2519, '云南省', '530000', '文山壮族苗族自治州', '532600', '广南县', '532627');
INSERT INTO `area_mapping` VALUES (2520, '云南省', '530000', '文山壮族苗族自治州', '532600', '富宁县', '532628');
INSERT INTO `area_mapping` VALUES (2521, '云南省', '530000', '西双版纳傣族自治州', '532800', '景洪市', '532801');
INSERT INTO `area_mapping` VALUES (2522, '云南省', '530000', '西双版纳傣族自治州', '532800', '勐海县', '532822');
INSERT INTO `area_mapping` VALUES (2523, '云南省', '530000', '西双版纳傣族自治州', '532800', '勐腊县', '532823');
INSERT INTO `area_mapping` VALUES (2524, '云南省', '530000', '大理白族自治州', '532900', '大理市', '532901');
INSERT INTO `area_mapping` VALUES (2525, '云南省', '530000', '大理白族自治州', '532900', '漾濞彝族自治县', '532922');
INSERT INTO `area_mapping` VALUES (2526, '云南省', '530000', '大理白族自治州', '532900', '祥云县', '532923');
INSERT INTO `area_mapping` VALUES (2527, '云南省', '530000', '大理白族自治州', '532900', '宾川县', '532924');
INSERT INTO `area_mapping` VALUES (2528, '云南省', '530000', '大理白族自治州', '532900', '弥渡县', '532925');
INSERT INTO `area_mapping` VALUES (2529, '云南省', '530000', '大理白族自治州', '532900', '南涧彝族自治县', '532926');
INSERT INTO `area_mapping` VALUES (2530, '云南省', '530000', '大理白族自治州', '532900', '巍山彝族回族自治县', '532927');
INSERT INTO `area_mapping` VALUES (2531, '云南省', '530000', '大理白族自治州', '532900', '永平县', '532928');
INSERT INTO `area_mapping` VALUES (2532, '云南省', '530000', '大理白族自治州', '532900', '云龙县', '532929');
INSERT INTO `area_mapping` VALUES (2533, '云南省', '530000', '大理白族自治州', '532900', '洱源县', '532930');
INSERT INTO `area_mapping` VALUES (2534, '云南省', '530000', '大理白族自治州', '532900', '剑川县', '532931');
INSERT INTO `area_mapping` VALUES (2535, '云南省', '530000', '大理白族自治州', '532900', '鹤庆县', '532932');
INSERT INTO `area_mapping` VALUES (2536, '云南省', '530000', '德宏傣族景颇族自治州', '533100', '瑞丽市', '533102');
INSERT INTO `area_mapping` VALUES (2537, '云南省', '530000', '德宏傣族景颇族自治州', '533100', '芒市', '533103');
INSERT INTO `area_mapping` VALUES (2538, '云南省', '530000', '德宏傣族景颇族自治州', '533100', '梁河县', '533122');
INSERT INTO `area_mapping` VALUES (2539, '云南省', '530000', '德宏傣族景颇族自治州', '533100', '盈江县', '533123');
INSERT INTO `area_mapping` VALUES (2540, '云南省', '530000', '德宏傣族景颇族自治州', '533100', '陇川县', '533124');
INSERT INTO `area_mapping` VALUES (2541, '云南省', '530000', '怒江傈僳族自治州', '533300', '泸水市', '533301');
INSERT INTO `area_mapping` VALUES (2542, '云南省', '530000', '怒江傈僳族自治州', '533300', '福贡县', '533323');
INSERT INTO `area_mapping` VALUES (2543, '云南省', '530000', '怒江傈僳族自治州', '533300', '贡山独龙族怒族自治县', '533324');
INSERT INTO `area_mapping` VALUES (2544, '云南省', '530000', '怒江傈僳族自治州', '533300', '兰坪白族普米族自治县', '533325');
INSERT INTO `area_mapping` VALUES (2545, '云南省', '530000', '迪庆藏族自治州', '533400', '香格里拉市', '533401');
INSERT INTO `area_mapping` VALUES (2546, '云南省', '530000', '迪庆藏族自治州', '533400', '德钦县', '533422');
INSERT INTO `area_mapping` VALUES (2547, '云南省', '530000', '迪庆藏族自治州', '533400', '维西傈僳族自治县', '533423');
INSERT INTO `area_mapping` VALUES (2548, '西藏自治区', '540000', '拉萨市', '540100', '城关区', '540102');
INSERT INTO `area_mapping` VALUES (2549, '西藏自治区', '540000', '拉萨市', '540100', '堆龙德庆区', '540103');
INSERT INTO `area_mapping` VALUES (2550, '西藏自治区', '540000', '拉萨市', '540100', '达孜区', '540104');
INSERT INTO `area_mapping` VALUES (2551, '西藏自治区', '540000', '拉萨市', '540100', '林周县', '540121');
INSERT INTO `area_mapping` VALUES (2552, '西藏自治区', '540000', '拉萨市', '540100', '当雄县', '540122');
INSERT INTO `area_mapping` VALUES (2553, '西藏自治区', '540000', '拉萨市', '540100', '尼木县', '540123');
INSERT INTO `area_mapping` VALUES (2554, '西藏自治区', '540000', '拉萨市', '540100', '曲水县', '540124');
INSERT INTO `area_mapping` VALUES (2555, '西藏自治区', '540000', '拉萨市', '540100', '墨竹工卡县', '540127');
INSERT INTO `area_mapping` VALUES (2556, '西藏自治区', '540000', '拉萨市', '540100', '格尔木藏青工业园区', '540171');
INSERT INTO `area_mapping` VALUES (2557, '西藏自治区', '540000', '拉萨市', '540100', '拉萨经济技术开发区', '540172');
INSERT INTO `area_mapping` VALUES (2558, '西藏自治区', '540000', '拉萨市', '540100', '西藏文化旅游创意园区', '540173');
INSERT INTO `area_mapping` VALUES (2559, '西藏自治区', '540000', '拉萨市', '540100', '达孜工业园区', '540174');
INSERT INTO `area_mapping` VALUES (2560, '西藏自治区', '540000', '日喀则市', '540200', '桑珠孜区', '540202');
INSERT INTO `area_mapping` VALUES (2561, '西藏自治区', '540000', '日喀则市', '540200', '南木林县', '540221');
INSERT INTO `area_mapping` VALUES (2562, '西藏自治区', '540000', '日喀则市', '540200', '江孜县', '540222');
INSERT INTO `area_mapping` VALUES (2563, '西藏自治区', '540000', '日喀则市', '540200', '定日县', '540223');
INSERT INTO `area_mapping` VALUES (2564, '西藏自治区', '540000', '日喀则市', '540200', '萨迦县', '540224');
INSERT INTO `area_mapping` VALUES (2565, '西藏自治区', '540000', '日喀则市', '540200', '拉孜县', '540225');
INSERT INTO `area_mapping` VALUES (2566, '西藏自治区', '540000', '日喀则市', '540200', '昂仁县', '540226');
INSERT INTO `area_mapping` VALUES (2567, '西藏自治区', '540000', '日喀则市', '540200', '谢通门县', '540227');
INSERT INTO `area_mapping` VALUES (2568, '西藏自治区', '540000', '日喀则市', '540200', '白朗县', '540228');
INSERT INTO `area_mapping` VALUES (2569, '西藏自治区', '540000', '日喀则市', '540200', '仁布县', '540229');
INSERT INTO `area_mapping` VALUES (2570, '西藏自治区', '540000', '日喀则市', '540200', '康马县', '540230');
INSERT INTO `area_mapping` VALUES (2571, '西藏自治区', '540000', '日喀则市', '540200', '定结县', '540231');
INSERT INTO `area_mapping` VALUES (2572, '西藏自治区', '540000', '日喀则市', '540200', '仲巴县', '540232');
INSERT INTO `area_mapping` VALUES (2573, '西藏自治区', '540000', '日喀则市', '540200', '亚东县', '540233');
INSERT INTO `area_mapping` VALUES (2574, '西藏自治区', '540000', '日喀则市', '540200', '吉隆县', '540234');
INSERT INTO `area_mapping` VALUES (2575, '西藏自治区', '540000', '日喀则市', '540200', '聂拉木县', '540235');
INSERT INTO `area_mapping` VALUES (2576, '西藏自治区', '540000', '日喀则市', '540200', '萨嘎县', '540236');
INSERT INTO `area_mapping` VALUES (2577, '西藏自治区', '540000', '日喀则市', '540200', '岗巴县', '540237');
INSERT INTO `area_mapping` VALUES (2578, '西藏自治区', '540000', '昌都市', '540300', '卡若区', '540302');
INSERT INTO `area_mapping` VALUES (2579, '西藏自治区', '540000', '昌都市', '540300', '江达县', '540321');
INSERT INTO `area_mapping` VALUES (2580, '西藏自治区', '540000', '昌都市', '540300', '贡觉县', '540322');
INSERT INTO `area_mapping` VALUES (2581, '西藏自治区', '540000', '昌都市', '540300', '类乌齐县', '540323');
INSERT INTO `area_mapping` VALUES (2582, '西藏自治区', '540000', '昌都市', '540300', '丁青县', '540324');
INSERT INTO `area_mapping` VALUES (2583, '西藏自治区', '540000', '昌都市', '540300', '察雅县', '540325');
INSERT INTO `area_mapping` VALUES (2584, '西藏自治区', '540000', '昌都市', '540300', '八宿县', '540326');
INSERT INTO `area_mapping` VALUES (2585, '西藏自治区', '540000', '昌都市', '540300', '左贡县', '540327');
INSERT INTO `area_mapping` VALUES (2586, '西藏自治区', '540000', '昌都市', '540300', '芒康县', '540328');
INSERT INTO `area_mapping` VALUES (2587, '西藏自治区', '540000', '昌都市', '540300', '洛隆县', '540329');
INSERT INTO `area_mapping` VALUES (2588, '西藏自治区', '540000', '昌都市', '540300', '边坝县', '540330');
INSERT INTO `area_mapping` VALUES (2589, '西藏自治区', '540000', '林芝市', '540400', '巴宜区', '540402');
INSERT INTO `area_mapping` VALUES (2590, '西藏自治区', '540000', '林芝市', '540400', '工布江达县', '540421');
INSERT INTO `area_mapping` VALUES (2591, '西藏自治区', '540000', '林芝市', '540400', '米林县', '540422');
INSERT INTO `area_mapping` VALUES (2592, '西藏自治区', '540000', '林芝市', '540400', '墨脱县', '540423');
INSERT INTO `area_mapping` VALUES (2593, '西藏自治区', '540000', '林芝市', '540400', '波密县', '540424');
INSERT INTO `area_mapping` VALUES (2594, '西藏自治区', '540000', '林芝市', '540400', '察隅县', '540425');
INSERT INTO `area_mapping` VALUES (2595, '西藏自治区', '540000', '林芝市', '540400', '朗县', '540426');
INSERT INTO `area_mapping` VALUES (2596, '西藏自治区', '540000', '山南市', '540500', '乃东区', '540502');
INSERT INTO `area_mapping` VALUES (2597, '西藏自治区', '540000', '山南市', '540500', '扎囊县', '540521');
INSERT INTO `area_mapping` VALUES (2598, '西藏自治区', '540000', '山南市', '540500', '贡嘎县', '540522');
INSERT INTO `area_mapping` VALUES (2599, '西藏自治区', '540000', '山南市', '540500', '桑日县', '540523');
INSERT INTO `area_mapping` VALUES (2600, '西藏自治区', '540000', '山南市', '540500', '琼结县', '540524');
INSERT INTO `area_mapping` VALUES (2601, '西藏自治区', '540000', '山南市', '540500', '曲松县', '540525');
INSERT INTO `area_mapping` VALUES (2602, '西藏自治区', '540000', '山南市', '540500', '措美县', '540526');
INSERT INTO `area_mapping` VALUES (2603, '西藏自治区', '540000', '山南市', '540500', '洛扎县', '540527');
INSERT INTO `area_mapping` VALUES (2604, '西藏自治区', '540000', '山南市', '540500', '加查县', '540528');
INSERT INTO `area_mapping` VALUES (2605, '西藏自治区', '540000', '山南市', '540500', '隆子县', '540529');
INSERT INTO `area_mapping` VALUES (2606, '西藏自治区', '540000', '山南市', '540500', '错那县', '540530');
INSERT INTO `area_mapping` VALUES (2607, '西藏自治区', '540000', '山南市', '540500', '浪卡子县', '540531');
INSERT INTO `area_mapping` VALUES (2608, '西藏自治区', '540000', '那曲市', '540600', '色尼区', '540602');
INSERT INTO `area_mapping` VALUES (2609, '西藏自治区', '540000', '那曲市', '540600', '嘉黎县', '540621');
INSERT INTO `area_mapping` VALUES (2610, '西藏自治区', '540000', '那曲市', '540600', '比如县', '540622');
INSERT INTO `area_mapping` VALUES (2611, '西藏自治区', '540000', '那曲市', '540600', '聂荣县', '540623');
INSERT INTO `area_mapping` VALUES (2612, '西藏自治区', '540000', '那曲市', '540600', '安多县', '540624');
INSERT INTO `area_mapping` VALUES (2613, '西藏自治区', '540000', '那曲市', '540600', '申扎县', '540625');
INSERT INTO `area_mapping` VALUES (2614, '西藏自治区', '540000', '那曲市', '540600', '索县', '540626');
INSERT INTO `area_mapping` VALUES (2615, '西藏自治区', '540000', '那曲市', '540600', '班戈县', '540627');
INSERT INTO `area_mapping` VALUES (2616, '西藏自治区', '540000', '那曲市', '540600', '巴青县', '540628');
INSERT INTO `area_mapping` VALUES (2617, '西藏自治区', '540000', '那曲市', '540600', '尼玛县', '540629');
INSERT INTO `area_mapping` VALUES (2618, '西藏自治区', '540000', '那曲市', '540600', '双湖县', '540630');
INSERT INTO `area_mapping` VALUES (2619, '西藏自治区', '540000', '阿里地区', '542500', '普兰县', '542521');
INSERT INTO `area_mapping` VALUES (2620, '西藏自治区', '540000', '阿里地区', '542500', '札达县', '542522');
INSERT INTO `area_mapping` VALUES (2621, '西藏自治区', '540000', '阿里地区', '542500', '噶尔县', '542523');
INSERT INTO `area_mapping` VALUES (2622, '西藏自治区', '540000', '阿里地区', '542500', '日土县', '542524');
INSERT INTO `area_mapping` VALUES (2623, '西藏自治区', '540000', '阿里地区', '542500', '革吉县', '542525');
INSERT INTO `area_mapping` VALUES (2624, '西藏自治区', '540000', '阿里地区', '542500', '改则县', '542526');
INSERT INTO `area_mapping` VALUES (2625, '西藏自治区', '540000', '阿里地区', '542500', '措勤县', '542527');
INSERT INTO `area_mapping` VALUES (2626, '陕西省', '610000', '西安市', '610100', '新城区', '610102');
INSERT INTO `area_mapping` VALUES (2627, '陕西省', '610000', '西安市', '610100', '碑林区', '610103');
INSERT INTO `area_mapping` VALUES (2628, '陕西省', '610000', '西安市', '610100', '莲湖区', '610104');
INSERT INTO `area_mapping` VALUES (2629, '陕西省', '610000', '西安市', '610100', '灞桥区', '610111');
INSERT INTO `area_mapping` VALUES (2630, '陕西省', '610000', '西安市', '610100', '未央区', '610112');
INSERT INTO `area_mapping` VALUES (2631, '陕西省', '610000', '西安市', '610100', '雁塔区', '610113');
INSERT INTO `area_mapping` VALUES (2632, '陕西省', '610000', '西安市', '610100', '阎良区', '610114');
INSERT INTO `area_mapping` VALUES (2633, '陕西省', '610000', '西安市', '610100', '临潼区', '610115');
INSERT INTO `area_mapping` VALUES (2634, '陕西省', '610000', '西安市', '610100', '长安区', '610116');
INSERT INTO `area_mapping` VALUES (2635, '陕西省', '610000', '西安市', '610100', '高陵区', '610117');
INSERT INTO `area_mapping` VALUES (2636, '陕西省', '610000', '西安市', '610100', '鄠邑区', '610118');
INSERT INTO `area_mapping` VALUES (2637, '陕西省', '610000', '西安市', '610100', '蓝田县', '610122');
INSERT INTO `area_mapping` VALUES (2638, '陕西省', '610000', '西安市', '610100', '周至县', '610124');
INSERT INTO `area_mapping` VALUES (2639, '陕西省', '610000', '铜川市', '610200', '王益区', '610202');
INSERT INTO `area_mapping` VALUES (2640, '陕西省', '610000', '铜川市', '610200', '印台区', '610203');
INSERT INTO `area_mapping` VALUES (2641, '陕西省', '610000', '铜川市', '610200', '耀州区', '610204');
INSERT INTO `area_mapping` VALUES (2642, '陕西省', '610000', '铜川市', '610200', '宜君县', '610222');
INSERT INTO `area_mapping` VALUES (2643, '陕西省', '610000', '宝鸡市', '610300', '渭滨区', '610302');
INSERT INTO `area_mapping` VALUES (2644, '陕西省', '610000', '宝鸡市', '610300', '金台区', '610303');
INSERT INTO `area_mapping` VALUES (2645, '陕西省', '610000', '宝鸡市', '610300', '陈仓区', '610304');
INSERT INTO `area_mapping` VALUES (2646, '陕西省', '610000', '宝鸡市', '610300', '凤翔县', '610322');
INSERT INTO `area_mapping` VALUES (2647, '陕西省', '610000', '宝鸡市', '610300', '岐山县', '610323');
INSERT INTO `area_mapping` VALUES (2648, '陕西省', '610000', '宝鸡市', '610300', '扶风县', '610324');
INSERT INTO `area_mapping` VALUES (2649, '陕西省', '610000', '宝鸡市', '610300', '眉县', '610326');
INSERT INTO `area_mapping` VALUES (2650, '陕西省', '610000', '宝鸡市', '610300', '陇县', '610327');
INSERT INTO `area_mapping` VALUES (2651, '陕西省', '610000', '宝鸡市', '610300', '千阳县', '610328');
INSERT INTO `area_mapping` VALUES (2652, '陕西省', '610000', '宝鸡市', '610300', '麟游县', '610329');
INSERT INTO `area_mapping` VALUES (2653, '陕西省', '610000', '宝鸡市', '610300', '凤县', '610330');
INSERT INTO `area_mapping` VALUES (2654, '陕西省', '610000', '宝鸡市', '610300', '太白县', '610331');
INSERT INTO `area_mapping` VALUES (2655, '陕西省', '610000', '咸阳市', '610400', '秦都区', '610402');
INSERT INTO `area_mapping` VALUES (2656, '陕西省', '610000', '咸阳市', '610400', '杨陵区', '610403');
INSERT INTO `area_mapping` VALUES (2657, '陕西省', '610000', '咸阳市', '610400', '渭城区', '610404');
INSERT INTO `area_mapping` VALUES (2658, '陕西省', '610000', '咸阳市', '610400', '三原县', '610422');
INSERT INTO `area_mapping` VALUES (2659, '陕西省', '610000', '咸阳市', '610400', '泾阳县', '610423');
INSERT INTO `area_mapping` VALUES (2660, '陕西省', '610000', '咸阳市', '610400', '乾县', '610424');
INSERT INTO `area_mapping` VALUES (2661, '陕西省', '610000', '咸阳市', '610400', '礼泉县', '610425');
INSERT INTO `area_mapping` VALUES (2662, '陕西省', '610000', '咸阳市', '610400', '永寿县', '610426');
INSERT INTO `area_mapping` VALUES (2663, '陕西省', '610000', '咸阳市', '610400', '长武县', '610428');
INSERT INTO `area_mapping` VALUES (2664, '陕西省', '610000', '咸阳市', '610400', '旬邑县', '610429');
INSERT INTO `area_mapping` VALUES (2665, '陕西省', '610000', '咸阳市', '610400', '淳化县', '610430');
INSERT INTO `area_mapping` VALUES (2666, '陕西省', '610000', '咸阳市', '610400', '武功县', '610431');
INSERT INTO `area_mapping` VALUES (2667, '陕西省', '610000', '咸阳市', '610400', '兴平市', '610481');
INSERT INTO `area_mapping` VALUES (2668, '陕西省', '610000', '咸阳市', '610400', '彬州市', '610482');
INSERT INTO `area_mapping` VALUES (2669, '陕西省', '610000', '渭南市', '610500', '临渭区', '610502');
INSERT INTO `area_mapping` VALUES (2670, '陕西省', '610000', '渭南市', '610500', '华州区', '610503');
INSERT INTO `area_mapping` VALUES (2671, '陕西省', '610000', '渭南市', '610500', '潼关县', '610522');
INSERT INTO `area_mapping` VALUES (2672, '陕西省', '610000', '渭南市', '610500', '大荔县', '610523');
INSERT INTO `area_mapping` VALUES (2673, '陕西省', '610000', '渭南市', '610500', '合阳县', '610524');
INSERT INTO `area_mapping` VALUES (2674, '陕西省', '610000', '渭南市', '610500', '澄城县', '610525');
INSERT INTO `area_mapping` VALUES (2675, '陕西省', '610000', '渭南市', '610500', '蒲城县', '610526');
INSERT INTO `area_mapping` VALUES (2676, '陕西省', '610000', '渭南市', '610500', '白水县', '610527');
INSERT INTO `area_mapping` VALUES (2677, '陕西省', '610000', '渭南市', '610500', '富平县', '610528');
INSERT INTO `area_mapping` VALUES (2678, '陕西省', '610000', '渭南市', '610500', '韩城市', '610581');
INSERT INTO `area_mapping` VALUES (2679, '陕西省', '610000', '渭南市', '610500', '华阴市', '610582');
INSERT INTO `area_mapping` VALUES (2680, '陕西省', '610000', '延安市', '610600', '宝塔区', '610602');
INSERT INTO `area_mapping` VALUES (2681, '陕西省', '610000', '延安市', '610600', '安塞区', '610603');
INSERT INTO `area_mapping` VALUES (2682, '陕西省', '610000', '延安市', '610600', '延长县', '610621');
INSERT INTO `area_mapping` VALUES (2683, '陕西省', '610000', '延安市', '610600', '延川县', '610622');
INSERT INTO `area_mapping` VALUES (2684, '陕西省', '610000', '延安市', '610600', '志丹县', '610625');
INSERT INTO `area_mapping` VALUES (2685, '陕西省', '610000', '延安市', '610600', '吴起县', '610626');
INSERT INTO `area_mapping` VALUES (2686, '陕西省', '610000', '延安市', '610600', '甘泉县', '610627');
INSERT INTO `area_mapping` VALUES (2687, '陕西省', '610000', '延安市', '610600', '富县', '610628');
INSERT INTO `area_mapping` VALUES (2688, '陕西省', '610000', '延安市', '610600', '洛川县', '610629');
INSERT INTO `area_mapping` VALUES (2689, '陕西省', '610000', '延安市', '610600', '宜川县', '610630');
INSERT INTO `area_mapping` VALUES (2690, '陕西省', '610000', '延安市', '610600', '黄龙县', '610631');
INSERT INTO `area_mapping` VALUES (2691, '陕西省', '610000', '延安市', '610600', '黄陵县', '610632');
INSERT INTO `area_mapping` VALUES (2692, '陕西省', '610000', '延安市', '610600', '子长市', '610681');
INSERT INTO `area_mapping` VALUES (2693, '陕西省', '610000', '汉中市', '610700', '汉台区', '610702');
INSERT INTO `area_mapping` VALUES (2694, '陕西省', '610000', '汉中市', '610700', '南郑区', '610703');
INSERT INTO `area_mapping` VALUES (2695, '陕西省', '610000', '汉中市', '610700', '城固县', '610722');
INSERT INTO `area_mapping` VALUES (2696, '陕西省', '610000', '汉中市', '610700', '洋县', '610723');
INSERT INTO `area_mapping` VALUES (2697, '陕西省', '610000', '汉中市', '610700', '西乡县', '610724');
INSERT INTO `area_mapping` VALUES (2698, '陕西省', '610000', '汉中市', '610700', '勉县', '610725');
INSERT INTO `area_mapping` VALUES (2699, '陕西省', '610000', '汉中市', '610700', '宁强县', '610726');
INSERT INTO `area_mapping` VALUES (2700, '陕西省', '610000', '汉中市', '610700', '略阳县', '610727');
INSERT INTO `area_mapping` VALUES (2701, '陕西省', '610000', '汉中市', '610700', '镇巴县', '610728');
INSERT INTO `area_mapping` VALUES (2702, '陕西省', '610000', '汉中市', '610700', '留坝县', '610729');
INSERT INTO `area_mapping` VALUES (2703, '陕西省', '610000', '汉中市', '610700', '佛坪县', '610730');
INSERT INTO `area_mapping` VALUES (2704, '陕西省', '610000', '榆林市', '610800', '榆阳区', '610802');
INSERT INTO `area_mapping` VALUES (2705, '陕西省', '610000', '榆林市', '610800', '横山区', '610803');
INSERT INTO `area_mapping` VALUES (2706, '陕西省', '610000', '榆林市', '610800', '府谷县', '610822');
INSERT INTO `area_mapping` VALUES (2707, '陕西省', '610000', '榆林市', '610800', '靖边县', '610824');
INSERT INTO `area_mapping` VALUES (2708, '陕西省', '610000', '榆林市', '610800', '定边县', '610825');
INSERT INTO `area_mapping` VALUES (2709, '陕西省', '610000', '榆林市', '610800', '绥德县', '610826');
INSERT INTO `area_mapping` VALUES (2710, '陕西省', '610000', '榆林市', '610800', '米脂县', '610827');
INSERT INTO `area_mapping` VALUES (2711, '陕西省', '610000', '榆林市', '610800', '佳县', '610828');
INSERT INTO `area_mapping` VALUES (2712, '陕西省', '610000', '榆林市', '610800', '吴堡县', '610829');
INSERT INTO `area_mapping` VALUES (2713, '陕西省', '610000', '榆林市', '610800', '清涧县', '610830');
INSERT INTO `area_mapping` VALUES (2714, '陕西省', '610000', '榆林市', '610800', '子洲县', '610831');
INSERT INTO `area_mapping` VALUES (2715, '陕西省', '610000', '榆林市', '610800', '神木市', '610881');
INSERT INTO `area_mapping` VALUES (2716, '陕西省', '610000', '安康市', '610900', '汉滨区', '610902');
INSERT INTO `area_mapping` VALUES (2717, '陕西省', '610000', '安康市', '610900', '汉阴县', '610921');
INSERT INTO `area_mapping` VALUES (2718, '陕西省', '610000', '安康市', '610900', '石泉县', '610922');
INSERT INTO `area_mapping` VALUES (2719, '陕西省', '610000', '安康市', '610900', '宁陕县', '610923');
INSERT INTO `area_mapping` VALUES (2720, '陕西省', '610000', '安康市', '610900', '紫阳县', '610924');
INSERT INTO `area_mapping` VALUES (2721, '陕西省', '610000', '安康市', '610900', '岚皋县', '610925');
INSERT INTO `area_mapping` VALUES (2722, '陕西省', '610000', '安康市', '610900', '平利县', '610926');
INSERT INTO `area_mapping` VALUES (2723, '陕西省', '610000', '安康市', '610900', '镇坪县', '610927');
INSERT INTO `area_mapping` VALUES (2724, '陕西省', '610000', '安康市', '610900', '旬阳县', '610928');
INSERT INTO `area_mapping` VALUES (2725, '陕西省', '610000', '安康市', '610900', '白河县', '610929');
INSERT INTO `area_mapping` VALUES (2726, '陕西省', '610000', '商洛市', '611000', '商州区', '611002');
INSERT INTO `area_mapping` VALUES (2727, '陕西省', '610000', '商洛市', '611000', '洛南县', '611021');
INSERT INTO `area_mapping` VALUES (2728, '陕西省', '610000', '商洛市', '611000', '丹凤县', '611022');
INSERT INTO `area_mapping` VALUES (2729, '陕西省', '610000', '商洛市', '611000', '商南县', '611023');
INSERT INTO `area_mapping` VALUES (2730, '陕西省', '610000', '商洛市', '611000', '山阳县', '611024');
INSERT INTO `area_mapping` VALUES (2731, '陕西省', '610000', '商洛市', '611000', '镇安县', '611025');
INSERT INTO `area_mapping` VALUES (2732, '陕西省', '610000', '商洛市', '611000', '柞水县', '611026');
INSERT INTO `area_mapping` VALUES (2733, '甘肃省', '620000', '兰州市', '620100', '城关区', '620102');
INSERT INTO `area_mapping` VALUES (2734, '甘肃省', '620000', '兰州市', '620100', '七里河区', '620103');
INSERT INTO `area_mapping` VALUES (2735, '甘肃省', '620000', '兰州市', '620100', '西固区', '620104');
INSERT INTO `area_mapping` VALUES (2736, '甘肃省', '620000', '兰州市', '620100', '安宁区', '620105');
INSERT INTO `area_mapping` VALUES (2737, '甘肃省', '620000', '兰州市', '620100', '红古区', '620111');
INSERT INTO `area_mapping` VALUES (2738, '甘肃省', '620000', '兰州市', '620100', '永登县', '620121');
INSERT INTO `area_mapping` VALUES (2739, '甘肃省', '620000', '兰州市', '620100', '皋兰县', '620122');
INSERT INTO `area_mapping` VALUES (2740, '甘肃省', '620000', '兰州市', '620100', '榆中县', '620123');
INSERT INTO `area_mapping` VALUES (2741, '甘肃省', '620000', '兰州市', '620100', '兰州新区', '620171');
INSERT INTO `area_mapping` VALUES (2742, '甘肃省', '620000', '嘉峪关市', '620200', '嘉峪关市', '620201');
INSERT INTO `area_mapping` VALUES (2743, '甘肃省', '620000', '金昌市', '620300', '金川区', '620302');
INSERT INTO `area_mapping` VALUES (2744, '甘肃省', '620000', '金昌市', '620300', '永昌县', '620321');
INSERT INTO `area_mapping` VALUES (2745, '甘肃省', '620000', '白银市', '620400', '白银区', '620402');
INSERT INTO `area_mapping` VALUES (2746, '甘肃省', '620000', '白银市', '620400', '平川区', '620403');
INSERT INTO `area_mapping` VALUES (2747, '甘肃省', '620000', '白银市', '620400', '靖远县', '620421');
INSERT INTO `area_mapping` VALUES (2748, '甘肃省', '620000', '白银市', '620400', '会宁县', '620422');
INSERT INTO `area_mapping` VALUES (2749, '甘肃省', '620000', '白银市', '620400', '景泰县', '620423');
INSERT INTO `area_mapping` VALUES (2750, '甘肃省', '620000', '天水市', '620500', '秦州区', '620502');
INSERT INTO `area_mapping` VALUES (2751, '甘肃省', '620000', '天水市', '620500', '麦积区', '620503');
INSERT INTO `area_mapping` VALUES (2752, '甘肃省', '620000', '天水市', '620500', '清水县', '620521');
INSERT INTO `area_mapping` VALUES (2753, '甘肃省', '620000', '天水市', '620500', '秦安县', '620522');
INSERT INTO `area_mapping` VALUES (2754, '甘肃省', '620000', '天水市', '620500', '甘谷县', '620523');
INSERT INTO `area_mapping` VALUES (2755, '甘肃省', '620000', '天水市', '620500', '武山县', '620524');
INSERT INTO `area_mapping` VALUES (2756, '甘肃省', '620000', '天水市', '620500', '张家川回族自治县', '620525');
INSERT INTO `area_mapping` VALUES (2757, '甘肃省', '620000', '武威市', '620600', '凉州区', '620602');
INSERT INTO `area_mapping` VALUES (2758, '甘肃省', '620000', '武威市', '620600', '民勤县', '620621');
INSERT INTO `area_mapping` VALUES (2759, '甘肃省', '620000', '武威市', '620600', '古浪县', '620622');
INSERT INTO `area_mapping` VALUES (2760, '甘肃省', '620000', '武威市', '620600', '天祝藏族自治县', '620623');
INSERT INTO `area_mapping` VALUES (2761, '甘肃省', '620000', '张掖市', '620700', '甘州区', '620702');
INSERT INTO `area_mapping` VALUES (2762, '甘肃省', '620000', '张掖市', '620700', '肃南裕固族自治县', '620721');
INSERT INTO `area_mapping` VALUES (2763, '甘肃省', '620000', '张掖市', '620700', '民乐县', '620722');
INSERT INTO `area_mapping` VALUES (2764, '甘肃省', '620000', '张掖市', '620700', '临泽县', '620723');
INSERT INTO `area_mapping` VALUES (2765, '甘肃省', '620000', '张掖市', '620700', '高台县', '620724');
INSERT INTO `area_mapping` VALUES (2766, '甘肃省', '620000', '张掖市', '620700', '山丹县', '620725');
INSERT INTO `area_mapping` VALUES (2767, '甘肃省', '620000', '平凉市', '620800', '崆峒区', '620802');
INSERT INTO `area_mapping` VALUES (2768, '甘肃省', '620000', '平凉市', '620800', '泾川县', '620821');
INSERT INTO `area_mapping` VALUES (2769, '甘肃省', '620000', '平凉市', '620800', '灵台县', '620822');
INSERT INTO `area_mapping` VALUES (2770, '甘肃省', '620000', '平凉市', '620800', '崇信县', '620823');
INSERT INTO `area_mapping` VALUES (2771, '甘肃省', '620000', '平凉市', '620800', '庄浪县', '620825');
INSERT INTO `area_mapping` VALUES (2772, '甘肃省', '620000', '平凉市', '620800', '静宁县', '620826');
INSERT INTO `area_mapping` VALUES (2773, '甘肃省', '620000', '平凉市', '620800', '华亭市', '620881');
INSERT INTO `area_mapping` VALUES (2774, '甘肃省', '620000', '酒泉市', '620900', '肃州区', '620902');
INSERT INTO `area_mapping` VALUES (2775, '甘肃省', '620000', '酒泉市', '620900', '金塔县', '620921');
INSERT INTO `area_mapping` VALUES (2776, '甘肃省', '620000', '酒泉市', '620900', '瓜州县', '620922');
INSERT INTO `area_mapping` VALUES (2777, '甘肃省', '620000', '酒泉市', '620900', '肃北蒙古族自治县', '620923');
INSERT INTO `area_mapping` VALUES (2778, '甘肃省', '620000', '酒泉市', '620900', '阿克塞哈萨克族自治县', '620924');
INSERT INTO `area_mapping` VALUES (2779, '甘肃省', '620000', '酒泉市', '620900', '玉门市', '620981');
INSERT INTO `area_mapping` VALUES (2780, '甘肃省', '620000', '酒泉市', '620900', '敦煌市', '620982');
INSERT INTO `area_mapping` VALUES (2781, '甘肃省', '620000', '庆阳市', '621000', '西峰区', '621002');
INSERT INTO `area_mapping` VALUES (2782, '甘肃省', '620000', '庆阳市', '621000', '庆城县', '621021');
INSERT INTO `area_mapping` VALUES (2783, '甘肃省', '620000', '庆阳市', '621000', '环县', '621022');
INSERT INTO `area_mapping` VALUES (2784, '甘肃省', '620000', '庆阳市', '621000', '华池县', '621023');
INSERT INTO `area_mapping` VALUES (2785, '甘肃省', '620000', '庆阳市', '621000', '合水县', '621024');
INSERT INTO `area_mapping` VALUES (2786, '甘肃省', '620000', '庆阳市', '621000', '正宁县', '621025');
INSERT INTO `area_mapping` VALUES (2787, '甘肃省', '620000', '庆阳市', '621000', '宁县', '621026');
INSERT INTO `area_mapping` VALUES (2788, '甘肃省', '620000', '庆阳市', '621000', '镇原县', '621027');
INSERT INTO `area_mapping` VALUES (2789, '甘肃省', '620000', '定西市', '621100', '安定区', '621102');
INSERT INTO `area_mapping` VALUES (2790, '甘肃省', '620000', '定西市', '621100', '通渭县', '621121');
INSERT INTO `area_mapping` VALUES (2791, '甘肃省', '620000', '定西市', '621100', '陇西县', '621122');
INSERT INTO `area_mapping` VALUES (2792, '甘肃省', '620000', '定西市', '621100', '渭源县', '621123');
INSERT INTO `area_mapping` VALUES (2793, '甘肃省', '620000', '定西市', '621100', '临洮县', '621124');
INSERT INTO `area_mapping` VALUES (2794, '甘肃省', '620000', '定西市', '621100', '漳县', '621125');
INSERT INTO `area_mapping` VALUES (2795, '甘肃省', '620000', '定西市', '621100', '岷县', '621126');
INSERT INTO `area_mapping` VALUES (2796, '甘肃省', '620000', '陇南市', '621200', '武都区', '621202');
INSERT INTO `area_mapping` VALUES (2797, '甘肃省', '620000', '陇南市', '621200', '成县', '621221');
INSERT INTO `area_mapping` VALUES (2798, '甘肃省', '620000', '陇南市', '621200', '文县', '621222');
INSERT INTO `area_mapping` VALUES (2799, '甘肃省', '620000', '陇南市', '621200', '宕昌县', '621223');
INSERT INTO `area_mapping` VALUES (2800, '甘肃省', '620000', '陇南市', '621200', '康县', '621224');
INSERT INTO `area_mapping` VALUES (2801, '甘肃省', '620000', '陇南市', '621200', '西和县', '621225');
INSERT INTO `area_mapping` VALUES (2802, '甘肃省', '620000', '陇南市', '621200', '礼县', '621226');
INSERT INTO `area_mapping` VALUES (2803, '甘肃省', '620000', '陇南市', '621200', '徽县', '621227');
INSERT INTO `area_mapping` VALUES (2804, '甘肃省', '620000', '陇南市', '621200', '两当县', '621228');
INSERT INTO `area_mapping` VALUES (2805, '甘肃省', '620000', '临夏回族自治州', '622900', '临夏市', '622901');
INSERT INTO `area_mapping` VALUES (2806, '甘肃省', '620000', '临夏回族自治州', '622900', '临夏县', '622921');
INSERT INTO `area_mapping` VALUES (2807, '甘肃省', '620000', '临夏回族自治州', '622900', '康乐县', '622922');
INSERT INTO `area_mapping` VALUES (2808, '甘肃省', '620000', '临夏回族自治州', '622900', '永靖县', '622923');
INSERT INTO `area_mapping` VALUES (2809, '甘肃省', '620000', '临夏回族自治州', '622900', '广河县', '622924');
INSERT INTO `area_mapping` VALUES (2810, '甘肃省', '620000', '临夏回族自治州', '622900', '和政县', '622925');
INSERT INTO `area_mapping` VALUES (2811, '甘肃省', '620000', '临夏回族自治州', '622900', '东乡族自治县', '622926');
INSERT INTO `area_mapping` VALUES (2812, '甘肃省', '620000', '临夏回族自治州', '622900', '积石山保安族东乡族撒拉族自治县', '622927');
INSERT INTO `area_mapping` VALUES (2813, '甘肃省', '620000', '甘南藏族自治州', '623000', '合作市', '623001');
INSERT INTO `area_mapping` VALUES (2814, '甘肃省', '620000', '甘南藏族自治州', '623000', '临潭县', '623021');
INSERT INTO `area_mapping` VALUES (2815, '甘肃省', '620000', '甘南藏族自治州', '623000', '卓尼县', '623022');
INSERT INTO `area_mapping` VALUES (2816, '甘肃省', '620000', '甘南藏族自治州', '623000', '舟曲县', '623023');
INSERT INTO `area_mapping` VALUES (2817, '甘肃省', '620000', '甘南藏族自治州', '623000', '迭部县', '623024');
INSERT INTO `area_mapping` VALUES (2818, '甘肃省', '620000', '甘南藏族自治州', '623000', '玛曲县', '623025');
INSERT INTO `area_mapping` VALUES (2819, '甘肃省', '620000', '甘南藏族自治州', '623000', '碌曲县', '623026');
INSERT INTO `area_mapping` VALUES (2820, '甘肃省', '620000', '甘南藏族自治州', '623000', '夏河县', '623027');
INSERT INTO `area_mapping` VALUES (2821, '青海省', '630000', '西宁市', '630100', '城东区', '630102');
INSERT INTO `area_mapping` VALUES (2822, '青海省', '630000', '西宁市', '630100', '城中区', '630103');
INSERT INTO `area_mapping` VALUES (2823, '青海省', '630000', '西宁市', '630100', '城西区', '630104');
INSERT INTO `area_mapping` VALUES (2824, '青海省', '630000', '西宁市', '630100', '城北区', '630105');
INSERT INTO `area_mapping` VALUES (2825, '青海省', '630000', '西宁市', '630100', '湟中区', '630106');
INSERT INTO `area_mapping` VALUES (2826, '青海省', '630000', '西宁市', '630100', '大通回族土族自治县', '630121');
INSERT INTO `area_mapping` VALUES (2827, '青海省', '630000', '西宁市', '630100', '湟源县', '630123');
INSERT INTO `area_mapping` VALUES (2828, '青海省', '630000', '海东市', '630200', '乐都区', '630202');
INSERT INTO `area_mapping` VALUES (2829, '青海省', '630000', '海东市', '630200', '平安区', '630203');
INSERT INTO `area_mapping` VALUES (2830, '青海省', '630000', '海东市', '630200', '民和回族土族自治县', '630222');
INSERT INTO `area_mapping` VALUES (2831, '青海省', '630000', '海东市', '630200', '互助土族自治县', '630223');
INSERT INTO `area_mapping` VALUES (2832, '青海省', '630000', '海东市', '630200', '化隆回族自治县', '630224');
INSERT INTO `area_mapping` VALUES (2833, '青海省', '630000', '海东市', '630200', '循化撒拉族自治县', '630225');
INSERT INTO `area_mapping` VALUES (2834, '青海省', '630000', '海北藏族自治州', '632200', '门源回族自治县', '632221');
INSERT INTO `area_mapping` VALUES (2835, '青海省', '630000', '海北藏族自治州', '632200', '祁连县', '632222');
INSERT INTO `area_mapping` VALUES (2836, '青海省', '630000', '海北藏族自治州', '632200', '海晏县', '632223');
INSERT INTO `area_mapping` VALUES (2837, '青海省', '630000', '海北藏族自治州', '632200', '刚察县', '632224');
INSERT INTO `area_mapping` VALUES (2838, '青海省', '630000', '黄南藏族自治州', '632300', '同仁县', '632321');
INSERT INTO `area_mapping` VALUES (2839, '青海省', '630000', '黄南藏族自治州', '632300', '尖扎县', '632322');
INSERT INTO `area_mapping` VALUES (2840, '青海省', '630000', '黄南藏族自治州', '632300', '泽库县', '632323');
INSERT INTO `area_mapping` VALUES (2841, '青海省', '630000', '黄南藏族自治州', '632300', '河南蒙古族自治县', '632324');
INSERT INTO `area_mapping` VALUES (2842, '青海省', '630000', '海南藏族自治州', '632500', '共和县', '632521');
INSERT INTO `area_mapping` VALUES (2843, '青海省', '630000', '海南藏族自治州', '632500', '同德县', '632522');
INSERT INTO `area_mapping` VALUES (2844, '青海省', '630000', '海南藏族自治州', '632500', '贵德县', '632523');
INSERT INTO `area_mapping` VALUES (2845, '青海省', '630000', '海南藏族自治州', '632500', '兴海县', '632524');
INSERT INTO `area_mapping` VALUES (2846, '青海省', '630000', '海南藏族自治州', '632500', '贵南县', '632525');
INSERT INTO `area_mapping` VALUES (2847, '青海省', '630000', '果洛藏族自治州', '632600', '玛沁县', '632621');
INSERT INTO `area_mapping` VALUES (2848, '青海省', '630000', '果洛藏族自治州', '632600', '班玛县', '632622');
INSERT INTO `area_mapping` VALUES (2849, '青海省', '630000', '果洛藏族自治州', '632600', '甘德县', '632623');
INSERT INTO `area_mapping` VALUES (2850, '青海省', '630000', '果洛藏族自治州', '632600', '达日县', '632624');
INSERT INTO `area_mapping` VALUES (2851, '青海省', '630000', '果洛藏族自治州', '632600', '久治县', '632625');
INSERT INTO `area_mapping` VALUES (2852, '青海省', '630000', '果洛藏族自治州', '632600', '玛多县', '632626');
INSERT INTO `area_mapping` VALUES (2853, '青海省', '630000', '玉树藏族自治州', '632700', '玉树市', '632701');
INSERT INTO `area_mapping` VALUES (2854, '青海省', '630000', '玉树藏族自治州', '632700', '杂多县', '632722');
INSERT INTO `area_mapping` VALUES (2855, '青海省', '630000', '玉树藏族自治州', '632700', '称多县', '632723');
INSERT INTO `area_mapping` VALUES (2856, '青海省', '630000', '玉树藏族自治州', '632700', '治多县', '632724');
INSERT INTO `area_mapping` VALUES (2857, '青海省', '630000', '玉树藏族自治州', '632700', '囊谦县', '632725');
INSERT INTO `area_mapping` VALUES (2858, '青海省', '630000', '玉树藏族自治州', '632700', '曲麻莱县', '632726');
INSERT INTO `area_mapping` VALUES (2859, '青海省', '630000', '海西蒙古族藏族自治州', '632800', '格尔木市', '632801');
INSERT INTO `area_mapping` VALUES (2860, '青海省', '630000', '海西蒙古族藏族自治州', '632800', '德令哈市', '632802');
INSERT INTO `area_mapping` VALUES (2861, '青海省', '630000', '海西蒙古族藏族自治州', '632800', '茫崖市', '632803');
INSERT INTO `area_mapping` VALUES (2862, '青海省', '630000', '海西蒙古族藏族自治州', '632800', '乌兰县', '632821');
INSERT INTO `area_mapping` VALUES (2863, '青海省', '630000', '海西蒙古族藏族自治州', '632800', '都兰县', '632822');
INSERT INTO `area_mapping` VALUES (2864, '青海省', '630000', '海西蒙古族藏族自治州', '632800', '天峻县', '632823');
INSERT INTO `area_mapping` VALUES (2865, '青海省', '630000', '海西蒙古族藏族自治州', '632800', '大柴旦行政委员会', '632857');
INSERT INTO `area_mapping` VALUES (2866, '宁夏回族自治区', '640000', '银川市', '640100', '兴庆区', '640104');
INSERT INTO `area_mapping` VALUES (2867, '宁夏回族自治区', '640000', '银川市', '640100', '西夏区', '640105');
INSERT INTO `area_mapping` VALUES (2868, '宁夏回族自治区', '640000', '银川市', '640100', '金凤区', '640106');
INSERT INTO `area_mapping` VALUES (2869, '宁夏回族自治区', '640000', '银川市', '640100', '永宁县', '640121');
INSERT INTO `area_mapping` VALUES (2870, '宁夏回族自治区', '640000', '银川市', '640100', '贺兰县', '640122');
INSERT INTO `area_mapping` VALUES (2871, '宁夏回族自治区', '640000', '银川市', '640100', '灵武市', '640181');
INSERT INTO `area_mapping` VALUES (2872, '宁夏回族自治区', '640000', '石嘴山市', '640200', '大武口区', '640202');
INSERT INTO `area_mapping` VALUES (2873, '宁夏回族自治区', '640000', '石嘴山市', '640200', '惠农区', '640205');
INSERT INTO `area_mapping` VALUES (2874, '宁夏回族自治区', '640000', '石嘴山市', '640200', '平罗县', '640221');
INSERT INTO `area_mapping` VALUES (2875, '宁夏回族自治区', '640000', '吴忠市', '640300', '利通区', '640302');
INSERT INTO `area_mapping` VALUES (2876, '宁夏回族自治区', '640000', '吴忠市', '640300', '红寺堡区', '640303');
INSERT INTO `area_mapping` VALUES (2877, '宁夏回族自治区', '640000', '吴忠市', '640300', '盐池县', '640323');
INSERT INTO `area_mapping` VALUES (2878, '宁夏回族自治区', '640000', '吴忠市', '640300', '同心县', '640324');
INSERT INTO `area_mapping` VALUES (2879, '宁夏回族自治区', '640000', '吴忠市', '640300', '青铜峡市', '640381');
INSERT INTO `area_mapping` VALUES (2880, '宁夏回族自治区', '640000', '固原市', '640400', '原州区', '640402');
INSERT INTO `area_mapping` VALUES (2881, '宁夏回族自治区', '640000', '固原市', '640400', '西吉县', '640422');
INSERT INTO `area_mapping` VALUES (2882, '宁夏回族自治区', '640000', '固原市', '640400', '隆德县', '640423');
INSERT INTO `area_mapping` VALUES (2883, '宁夏回族自治区', '640000', '固原市', '640400', '泾源县', '640424');
INSERT INTO `area_mapping` VALUES (2884, '宁夏回族自治区', '640000', '固原市', '640400', '彭阳县', '640425');
INSERT INTO `area_mapping` VALUES (2885, '宁夏回族自治区', '640000', '中卫市', '640500', '沙坡头区', '640502');
INSERT INTO `area_mapping` VALUES (2886, '宁夏回族自治区', '640000', '中卫市', '640500', '中宁县', '640521');
INSERT INTO `area_mapping` VALUES (2887, '宁夏回族自治区', '640000', '中卫市', '640500', '海原县', '640522');
INSERT INTO `area_mapping` VALUES (2888, '新疆维吾尔自治区', '650000', '乌鲁木齐市', '650100', '天山区', '650102');
INSERT INTO `area_mapping` VALUES (2889, '新疆维吾尔自治区', '650000', '乌鲁木齐市', '650100', '沙依巴克区', '650103');
INSERT INTO `area_mapping` VALUES (2890, '新疆维吾尔自治区', '650000', '乌鲁木齐市', '650100', '新市区', '650104');
INSERT INTO `area_mapping` VALUES (2891, '新疆维吾尔自治区', '650000', '乌鲁木齐市', '650100', '水磨沟区', '650105');
INSERT INTO `area_mapping` VALUES (2892, '新疆维吾尔自治区', '650000', '乌鲁木齐市', '650100', '头屯河区', '650106');
INSERT INTO `area_mapping` VALUES (2893, '新疆维吾尔自治区', '650000', '乌鲁木齐市', '650100', '达坂城区', '650107');
INSERT INTO `area_mapping` VALUES (2894, '新疆维吾尔自治区', '650000', '乌鲁木齐市', '650100', '米东区', '650109');
INSERT INTO `area_mapping` VALUES (2895, '新疆维吾尔自治区', '650000', '乌鲁木齐市', '650100', '乌鲁木齐县', '650121');
INSERT INTO `area_mapping` VALUES (2896, '新疆维吾尔自治区', '650000', '克拉玛依市', '650200', '独山子区', '650202');
INSERT INTO `area_mapping` VALUES (2897, '新疆维吾尔自治区', '650000', '克拉玛依市', '650200', '克拉玛依区', '650203');
INSERT INTO `area_mapping` VALUES (2898, '新疆维吾尔自治区', '650000', '克拉玛依市', '650200', '白碱滩区', '650204');
INSERT INTO `area_mapping` VALUES (2899, '新疆维吾尔自治区', '650000', '克拉玛依市', '650200', '乌尔禾区', '650205');
INSERT INTO `area_mapping` VALUES (2900, '新疆维吾尔自治区', '650000', '吐鲁番市', '650400', '高昌区', '650402');
INSERT INTO `area_mapping` VALUES (2901, '新疆维吾尔自治区', '650000', '吐鲁番市', '650400', '鄯善县', '650421');
INSERT INTO `area_mapping` VALUES (2902, '新疆维吾尔自治区', '650000', '吐鲁番市', '650400', '托克逊县', '650422');
INSERT INTO `area_mapping` VALUES (2903, '新疆维吾尔自治区', '650000', '哈密市', '650500', '伊州区', '650502');
INSERT INTO `area_mapping` VALUES (2904, '新疆维吾尔自治区', '650000', '哈密市', '650500', '巴里坤哈萨克自治县', '650521');
INSERT INTO `area_mapping` VALUES (2905, '新疆维吾尔自治区', '650000', '哈密市', '650500', '伊吾县', '650522');
INSERT INTO `area_mapping` VALUES (2906, '新疆维吾尔自治区', '650000', '昌吉回族自治州', '652300', '昌吉市', '652301');
INSERT INTO `area_mapping` VALUES (2907, '新疆维吾尔自治区', '650000', '昌吉回族自治州', '652300', '阜康市', '652302');
INSERT INTO `area_mapping` VALUES (2908, '新疆维吾尔自治区', '650000', '昌吉回族自治州', '652300', '呼图壁县', '652323');
INSERT INTO `area_mapping` VALUES (2909, '新疆维吾尔自治区', '650000', '昌吉回族自治州', '652300', '玛纳斯县', '652324');
INSERT INTO `area_mapping` VALUES (2910, '新疆维吾尔自治区', '650000', '昌吉回族自治州', '652300', '奇台县', '652325');
INSERT INTO `area_mapping` VALUES (2911, '新疆维吾尔自治区', '650000', '昌吉回族自治州', '652300', '吉木萨尔县', '652327');
INSERT INTO `area_mapping` VALUES (2912, '新疆维吾尔自治区', '650000', '昌吉回族自治州', '652300', '木垒哈萨克自治县', '652328');
INSERT INTO `area_mapping` VALUES (2913, '新疆维吾尔自治区', '650000', '博尔塔拉蒙古自治州', '652700', '博乐市', '652701');
INSERT INTO `area_mapping` VALUES (2914, '新疆维吾尔自治区', '650000', '博尔塔拉蒙古自治州', '652700', '阿拉山口市', '652702');
INSERT INTO `area_mapping` VALUES (2915, '新疆维吾尔自治区', '650000', '博尔塔拉蒙古自治州', '652700', '精河县', '652722');
INSERT INTO `area_mapping` VALUES (2916, '新疆维吾尔自治区', '650000', '博尔塔拉蒙古自治州', '652700', '温泉县', '652723');
INSERT INTO `area_mapping` VALUES (2917, '新疆维吾尔自治区', '650000', '巴音郭楞蒙古自治州', '652800', '库尔勒市', '652801');
INSERT INTO `area_mapping` VALUES (2918, '新疆维吾尔自治区', '650000', '巴音郭楞蒙古自治州', '652800', '轮台县', '652822');
INSERT INTO `area_mapping` VALUES (2919, '新疆维吾尔自治区', '650000', '巴音郭楞蒙古自治州', '652800', '尉犁县', '652823');
INSERT INTO `area_mapping` VALUES (2920, '新疆维吾尔自治区', '650000', '巴音郭楞蒙古自治州', '652800', '若羌县', '652824');
INSERT INTO `area_mapping` VALUES (2921, '新疆维吾尔自治区', '650000', '巴音郭楞蒙古自治州', '652800', '且末县', '652825');
INSERT INTO `area_mapping` VALUES (2922, '新疆维吾尔自治区', '650000', '巴音郭楞蒙古自治州', '652800', '焉耆回族自治县', '652826');
INSERT INTO `area_mapping` VALUES (2923, '新疆维吾尔自治区', '650000', '巴音郭楞蒙古自治州', '652800', '和静县', '652827');
INSERT INTO `area_mapping` VALUES (2924, '新疆维吾尔自治区', '650000', '巴音郭楞蒙古自治州', '652800', '和硕县', '652828');
INSERT INTO `area_mapping` VALUES (2925, '新疆维吾尔自治区', '650000', '巴音郭楞蒙古自治州', '652800', '博湖县', '652829');
INSERT INTO `area_mapping` VALUES (2926, '新疆维吾尔自治区', '650000', '巴音郭楞蒙古自治州', '652800', '库尔勒经济技术开发区', '652871');
INSERT INTO `area_mapping` VALUES (2927, '新疆维吾尔自治区', '650000', '阿克苏地区', '652900', '阿克苏市', '652901');
INSERT INTO `area_mapping` VALUES (2928, '新疆维吾尔自治区', '650000', '阿克苏地区', '652900', '库车市', '652902');
INSERT INTO `area_mapping` VALUES (2929, '新疆维吾尔自治区', '650000', '阿克苏地区', '652900', '温宿县', '652922');
INSERT INTO `area_mapping` VALUES (2930, '新疆维吾尔自治区', '650000', '阿克苏地区', '652900', '沙雅县', '652924');
INSERT INTO `area_mapping` VALUES (2931, '新疆维吾尔自治区', '650000', '阿克苏地区', '652900', '新和县', '652925');
INSERT INTO `area_mapping` VALUES (2932, '新疆维吾尔自治区', '650000', '阿克苏地区', '652900', '拜城县', '652926');
INSERT INTO `area_mapping` VALUES (2933, '新疆维吾尔自治区', '650000', '阿克苏地区', '652900', '乌什县', '652927');
INSERT INTO `area_mapping` VALUES (2934, '新疆维吾尔自治区', '650000', '阿克苏地区', '652900', '阿瓦提县', '652928');
INSERT INTO `area_mapping` VALUES (2935, '新疆维吾尔自治区', '650000', '阿克苏地区', '652900', '柯坪县', '652929');
INSERT INTO `area_mapping` VALUES (2936, '新疆维吾尔自治区', '650000', '克孜勒苏柯尔克孜自治州', '653000', '阿图什市', '653001');
INSERT INTO `area_mapping` VALUES (2937, '新疆维吾尔自治区', '650000', '克孜勒苏柯尔克孜自治州', '653000', '阿克陶县', '653022');
INSERT INTO `area_mapping` VALUES (2938, '新疆维吾尔自治区', '650000', '克孜勒苏柯尔克孜自治州', '653000', '阿合奇县', '653023');
INSERT INTO `area_mapping` VALUES (2939, '新疆维吾尔自治区', '650000', '克孜勒苏柯尔克孜自治州', '653000', '乌恰县', '653024');
INSERT INTO `area_mapping` VALUES (2940, '新疆维吾尔自治区', '650000', '喀什地区', '653100', '喀什市', '653101');
INSERT INTO `area_mapping` VALUES (2941, '新疆维吾尔自治区', '650000', '喀什地区', '653100', '疏附县', '653121');
INSERT INTO `area_mapping` VALUES (2942, '新疆维吾尔自治区', '650000', '喀什地区', '653100', '疏勒县', '653122');
INSERT INTO `area_mapping` VALUES (2943, '新疆维吾尔自治区', '650000', '喀什地区', '653100', '英吉沙县', '653123');
INSERT INTO `area_mapping` VALUES (2944, '新疆维吾尔自治区', '650000', '喀什地区', '653100', '泽普县', '653124');
INSERT INTO `area_mapping` VALUES (2945, '新疆维吾尔自治区', '650000', '喀什地区', '653100', '莎车县', '653125');
INSERT INTO `area_mapping` VALUES (2946, '新疆维吾尔自治区', '650000', '喀什地区', '653100', '叶城县', '653126');
INSERT INTO `area_mapping` VALUES (2947, '新疆维吾尔自治区', '650000', '喀什地区', '653100', '麦盖提县', '653127');
INSERT INTO `area_mapping` VALUES (2948, '新疆维吾尔自治区', '650000', '喀什地区', '653100', '岳普湖县', '653128');
INSERT INTO `area_mapping` VALUES (2949, '新疆维吾尔自治区', '650000', '喀什地区', '653100', '伽师县', '653129');
INSERT INTO `area_mapping` VALUES (2950, '新疆维吾尔自治区', '650000', '喀什地区', '653100', '巴楚县', '653130');
INSERT INTO `area_mapping` VALUES (2951, '新疆维吾尔自治区', '650000', '喀什地区', '653100', '塔什库尔干塔吉克自治县', '653131');
INSERT INTO `area_mapping` VALUES (2952, '新疆维吾尔自治区', '650000', '和田地区', '653200', '和田市', '653201');
INSERT INTO `area_mapping` VALUES (2953, '新疆维吾尔自治区', '650000', '和田地区', '653200', '和田县', '653221');
INSERT INTO `area_mapping` VALUES (2954, '新疆维吾尔自治区', '650000', '和田地区', '653200', '墨玉县', '653222');
INSERT INTO `area_mapping` VALUES (2955, '新疆维吾尔自治区', '650000', '和田地区', '653200', '皮山县', '653223');
INSERT INTO `area_mapping` VALUES (2956, '新疆维吾尔自治区', '650000', '和田地区', '653200', '洛浦县', '653224');
INSERT INTO `area_mapping` VALUES (2957, '新疆维吾尔自治区', '650000', '和田地区', '653200', '策勒县', '653225');
INSERT INTO `area_mapping` VALUES (2958, '新疆维吾尔自治区', '650000', '和田地区', '653200', '于田县', '653226');
INSERT INTO `area_mapping` VALUES (2959, '新疆维吾尔自治区', '650000', '和田地区', '653200', '民丰县', '653227');
INSERT INTO `area_mapping` VALUES (2960, '新疆维吾尔自治区', '650000', '伊犁哈萨克自治州', '654000', '伊宁市', '654002');
INSERT INTO `area_mapping` VALUES (2961, '新疆维吾尔自治区', '650000', '伊犁哈萨克自治州', '654000', '奎屯市', '654003');
INSERT INTO `area_mapping` VALUES (2962, '新疆维吾尔自治区', '650000', '伊犁哈萨克自治州', '654000', '霍尔果斯市', '654004');
INSERT INTO `area_mapping` VALUES (2963, '新疆维吾尔自治区', '650000', '伊犁哈萨克自治州', '654000', '伊宁县', '654021');
INSERT INTO `area_mapping` VALUES (2964, '新疆维吾尔自治区', '650000', '伊犁哈萨克自治州', '654000', '察布查尔锡伯自治县', '654022');
INSERT INTO `area_mapping` VALUES (2965, '新疆维吾尔自治区', '650000', '伊犁哈萨克自治州', '654000', '霍城县', '654023');
INSERT INTO `area_mapping` VALUES (2966, '新疆维吾尔自治区', '650000', '伊犁哈萨克自治州', '654000', '巩留县', '654024');
INSERT INTO `area_mapping` VALUES (2967, '新疆维吾尔自治区', '650000', '伊犁哈萨克自治州', '654000', '新源县', '654025');
INSERT INTO `area_mapping` VALUES (2968, '新疆维吾尔自治区', '650000', '伊犁哈萨克自治州', '654000', '昭苏县', '654026');
INSERT INTO `area_mapping` VALUES (2969, '新疆维吾尔自治区', '650000', '伊犁哈萨克自治州', '654000', '特克斯县', '654027');
INSERT INTO `area_mapping` VALUES (2970, '新疆维吾尔自治区', '650000', '伊犁哈萨克自治州', '654000', '尼勒克县', '654028');
INSERT INTO `area_mapping` VALUES (2971, '新疆维吾尔自治区', '650000', '塔城地区', '654200', '塔城市', '654201');
INSERT INTO `area_mapping` VALUES (2972, '新疆维吾尔自治区', '650000', '塔城地区', '654200', '乌苏市', '654202');
INSERT INTO `area_mapping` VALUES (2973, '新疆维吾尔自治区', '650000', '塔城地区', '654200', '额敏县', '654221');
INSERT INTO `area_mapping` VALUES (2974, '新疆维吾尔自治区', '650000', '塔城地区', '654200', '沙湾县', '654223');
INSERT INTO `area_mapping` VALUES (2975, '新疆维吾尔自治区', '650000', '塔城地区', '654200', '托里县', '654224');
INSERT INTO `area_mapping` VALUES (2976, '新疆维吾尔自治区', '650000', '塔城地区', '654200', '裕民县', '654225');
INSERT INTO `area_mapping` VALUES (2977, '新疆维吾尔自治区', '650000', '塔城地区', '654200', '和布克赛尔蒙古自治县', '654226');
INSERT INTO `area_mapping` VALUES (2978, '新疆维吾尔自治区', '650000', '阿勒泰地区', '654300', '阿勒泰市', '654301');
INSERT INTO `area_mapping` VALUES (2979, '新疆维吾尔自治区', '650000', '阿勒泰地区', '654300', '布尔津县', '654321');
INSERT INTO `area_mapping` VALUES (2980, '新疆维吾尔自治区', '650000', '阿勒泰地区', '654300', '富蕴县', '654322');
INSERT INTO `area_mapping` VALUES (2981, '新疆维吾尔自治区', '650000', '阿勒泰地区', '654300', '福海县', '654323');
INSERT INTO `area_mapping` VALUES (2982, '新疆维吾尔自治区', '650000', '阿勒泰地区', '654300', '哈巴河县', '654324');
INSERT INTO `area_mapping` VALUES (2983, '新疆维吾尔自治区', '650000', '阿勒泰地区', '654300', '青河县', '654325');
INSERT INTO `area_mapping` VALUES (2984, '新疆维吾尔自治区', '650000', '阿勒泰地区', '654300', '吉木乃县', '654326');
INSERT INTO `area_mapping` VALUES (2985, '新疆维吾尔自治区', '650000', '自治区直辖县级行政区划', '659000', '石河子市', '659001');
INSERT INTO `area_mapping` VALUES (2986, '新疆维吾尔自治区', '650000', '自治区直辖县级行政区划', '659000', '阿拉尔市', '659002');
INSERT INTO `area_mapping` VALUES (2987, '新疆维吾尔自治区', '650000', '自治区直辖县级行政区划', '659000', '图木舒克市', '659003');
INSERT INTO `area_mapping` VALUES (2988, '新疆维吾尔自治区', '650000', '自治区直辖县级行政区划', '659000', '五家渠市', '659004');
INSERT INTO `area_mapping` VALUES (2989, '新疆维吾尔自治区', '650000', '自治区直辖县级行政区划', '659000', '北屯市', '659005');
INSERT INTO `area_mapping` VALUES (2990, '新疆维吾尔自治区', '650000', '自治区直辖县级行政区划', '659000', '铁门关市', '659006');
INSERT INTO `area_mapping` VALUES (2991, '新疆维吾尔自治区', '650000', '自治区直辖县级行政区划', '659000', '双河市', '659007');
INSERT INTO `area_mapping` VALUES (2992, '新疆维吾尔自治区', '650000', '自治区直辖县级行政区划', '659000', '可克达拉市', '659008');
INSERT INTO `area_mapping` VALUES (2993, '新疆维吾尔自治区', '650000', '自治区直辖县级行政区划', '659000', '昆玉市', '659009');
INSERT INTO `area_mapping` VALUES (2994, '新疆维吾尔自治区', '650000', '自治区直辖县级行政区划', '659000', '胡杨河市', '659010');
INSERT INTO `area_mapping` VALUES (2995, '台湾省', '710000', '台湾省', '710000', '澎湖县', '710010');
INSERT INTO `area_mapping` VALUES (2996, '台湾省', '710000', '台湾省', '710000', '屏东县', '710011');
INSERT INTO `area_mapping` VALUES (2997, '台湾省', '710000', '台湾省', '710000', '新北市', '710012');
INSERT INTO `area_mapping` VALUES (2998, '台湾省', '710000', '台湾省', '710000', '台东县', '710013');
INSERT INTO `area_mapping` VALUES (2999, '台湾省', '710000', '台湾省', '710000', '台南市', '710014');
INSERT INTO `area_mapping` VALUES (3000, '台湾省', '710000', '台湾省', '710000', '台中市', '710016');
INSERT INTO `area_mapping` VALUES (3001, '台湾省', '710000', '台湾省', '710000', '桃园市', '710018');
INSERT INTO `area_mapping` VALUES (3002, '台湾省', '710000', '台湾省', '710000', '新竹市', '710019');
INSERT INTO `area_mapping` VALUES (3003, '台湾省', '710000', '台湾省', '710000', '新竹县', '710020');
INSERT INTO `area_mapping` VALUES (3004, '台湾省', '710000', '台湾省', '710000', '宜兰县', '710021');
INSERT INTO `area_mapping` VALUES (3005, '台湾省', '710000', '台湾省', '710000', '云林县', '710022');
INSERT INTO `area_mapping` VALUES (3006, '台湾省', '710000', '台湾省', '710000', '彰化县', '710023');
INSERT INTO `area_mapping` VALUES (3007, '台湾省', '710000', '台湾省', '710000', '高雄市', '711000');
INSERT INTO `area_mapping` VALUES (3008, '台湾省', '710000', '台湾省', '710000', '花莲县', '713000');
INSERT INTO `area_mapping` VALUES (3009, '台湾省', '710000', '台湾省', '710000', '基隆市', '714000');
INSERT INTO `area_mapping` VALUES (3010, '台湾省', '710000', '台湾省', '710000', '嘉义市', '715000');
INSERT INTO `area_mapping` VALUES (3011, '台湾省', '710000', '台湾省', '710000', '嘉义县', '716000');
INSERT INTO `area_mapping` VALUES (3012, '台湾省', '710000', '台湾省', '710000', '苗栗县', '717000');
INSERT INTO `area_mapping` VALUES (3013, '台湾省', '710000', '台湾省', '710000', '南投县', '718000');
INSERT INTO `area_mapping` VALUES (3014, '台湾省', '710000', '台湾省', '710000', '台北市', '719000');
INSERT INTO `area_mapping` VALUES (3015, '香港特别行政区', '810000', '香港特别行政区', '810100', '中西区', '810001');
INSERT INTO `area_mapping` VALUES (3016, '香港特别行政区', '810000', '香港特别行政区', '810100', '湾仔区', '810002');
INSERT INTO `area_mapping` VALUES (3017, '香港特别行政区', '810000', '香港特别行政区', '810100', '东区', '810003');
INSERT INTO `area_mapping` VALUES (3018, '香港特别行政区', '810000', '香港特别行政区', '810100', '南区', '810004');
INSERT INTO `area_mapping` VALUES (3019, '香港特别行政区', '810000', '香港特别行政区', '810100', '油尖旺区', '810005');
INSERT INTO `area_mapping` VALUES (3020, '香港特别行政区', '810000', '香港特别行政区', '810100', '深水埗区', '810006');
INSERT INTO `area_mapping` VALUES (3021, '香港特别行政区', '810000', '香港特别行政区', '810100', '九龙城区', '810007');
INSERT INTO `area_mapping` VALUES (3022, '香港特别行政区', '810000', '香港特别行政区', '810100', '黄大仙区', '810008');
INSERT INTO `area_mapping` VALUES (3023, '香港特别行政区', '810000', '香港特别行政区', '810100', '观塘区', '810009');
INSERT INTO `area_mapping` VALUES (3024, '香港特别行政区', '810000', '香港特别行政区', '810100', '荃湾区', '810010');
INSERT INTO `area_mapping` VALUES (3025, '香港特别行政区', '810000', '香港特别行政区', '810100', '屯门区', '810011');
INSERT INTO `area_mapping` VALUES (3026, '香港特别行政区', '810000', '香港特别行政区', '810100', '元朗区', '810012');
INSERT INTO `area_mapping` VALUES (3027, '香港特别行政区', '810000', '香港特别行政区', '810100', '北区', '810013');
INSERT INTO `area_mapping` VALUES (3028, '香港特别行政区', '810000', '香港特别行政区', '810100', '大埔区', '810014');
INSERT INTO `area_mapping` VALUES (3029, '香港特别行政区', '810000', '香港特别行政区', '810100', '西贡区', '810015');
INSERT INTO `area_mapping` VALUES (3030, '香港特别行政区', '810000', '香港特别行政区', '810100', '沙田区', '810016');
INSERT INTO `area_mapping` VALUES (3031, '香港特别行政区', '810000', '香港特别行政区', '810100', '葵青区', '810017');
INSERT INTO `area_mapping` VALUES (3032, '香港特别行政区', '810000', '香港特别行政区', '810100', '离岛区', '810018');
INSERT INTO `area_mapping` VALUES (3033, '澳门特别行政区', '820000', '澳门特别行政区', '820000', '澳门特别行政区', '820000');
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;
