DROP TABLE IF EXISTS `demo_recent_local_cases`;
CREATE TABLE `demo_recent_local_cases` (
  `city`    varchar(50) NOT NULL DEFAULT '' COMMENT '城市',
  `province`    varchar(50) NOT NULL COMMENT '省市区',
  `new_add`     bigint(13) COMMENT '新增',
  `existing`     bigint(13) COMMENT '现有',
  `risk`    varchar(50) NOT NULL COMMENT '区域风险',
  PRIMARY KEY (`city`)
)ENGINE = InnoDB
DEFAULT CHARSET = utf8mb4;


INSERT INTO `demo_recent_local_cases` (`city`, `province`, `new_add`, `existing`, `risk`) VALUES ('广州', '广东', '8', '106', '部分中高风险');
INSERT INTO `demo_recent_local_cases` (`city`, `province`, `new_add`, `existing`, `risk`) VALUES ('深圳', '广东', '0', '4', '全部低风险');
INSERT INTO `demo_recent_local_cases` (`city`, `province`, `new_add`, `existing`, `risk`) VALUES ('佛山', '广东', '0', '10', '部分中风险');
INSERT INTO `demo_recent_local_cases` (`city`, `province`, `new_add`, `existing`, `risk`) VALUES ('湛江', '广东', '0', '1', '部分中风险');
INSERT INTO `demo_recent_local_cases` (`city`, `province`, `new_add`, `existing`, `risk`) VALUES ('营口', '辽宁', '0', '2', '全部低风险');
INSERT INTO `demo_recent_local_cases` (`city`, `province`, `new_add`, `existing`, `risk`) VALUES ('德宏州', '云南', '0', '2', '全部低风险');


DROP TABLE IF EXISTS `demo_vaccination`;
CREATE TABLE `demo_vaccination` (
   `cumulative`    DECIMAL(10,2) NOT NULL   COMMENT '累计接种',
   `new_add`     DECIMAL(10,2) COMMENT '较上日新增',
   `vaccination_per_100_people`    DECIMAL(10,2) NOT NULL COMMENT '每百人接种'
)ENGINE = InnoDB
DEFAULT CHARSET = utf8mb4;

INSERT INTO `demo_vaccination` (`cumulative`, `new_add`, `vaccination_per_100_people`) VALUES (7.9, 1625.5, 55.17);


DROP TABLE IF EXISTS `demo_domestic_epidemic`;
CREATE TABLE `demo_domestic_epidemic` (
   `statistical_time`    varchar(50) NOT NULL DEFAULT '' COMMENT '统计时间',
   `cumulative_cure`     bigint(13) COMMENT '累计治愈',
   `current_diagnosis`     bigint(13) COMMENT '现有确诊',
   `cumulative_diagnosis`     bigint(13) COMMENT '累计确诊',
   `asymptomatic_patient`     bigint(13) COMMENT '无症状感染者',
   `input`     bigint(13) COMMENT '境外输入',
   `cumulative_death`     bigint(13) COMMENT '累计死亡'
)ENGINE = InnoDB
DEFAULT CHARSET = utf8mb4;

INSERT INTO `demo_domestic_epidemic` (`statistical_time`, `cumulative_cure`, `current_diagnosis`, `cumulative_diagnosis`, `asymptomatic_patient`, `input` , `cumulative_death`) VALUES ('2021-06-09 10:24:27 ', 99071, 10740, 114929, 361, 6173, 5154);


DROP TABLE IF EXISTS `demo_new_trend_of_diagnosis`;
CREATE TABLE `demo_new_trend_of_diagnosis` (
       `date`    varchar(50) NOT NULL DEFAULT '' COMMENT '日期',
       `new_diagnosis`    bigint(13) COMMENT '新增确诊',
       `current_diagnosis`    bigint(13) COMMENT '现有确诊'
)ENGINE = InnoDB
DEFAULT CHARSET = utf8mb4;


INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-8', 22, 499);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-9', 13, 485);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5/10', 33, 505);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5/11', 28, 506);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5/12', 32, 512);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5/13', 35, 523);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5/14', 49, 542);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-15', 206, 727);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-16', 236, 935);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-17', 358, 1262);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-18', 258, 1497);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-19', 286, 1759);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-20', 317, 2097);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-21', 325, 2365);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-22', 743, 3098);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-23', 480, 3561);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-24', 612, 4143);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-25', 554, 4675);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-26', 655, 5036);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-27', 677, 5948);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-28', 570, 6480);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-29', 503, 6951);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-30', 381, 7303);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-5-31', 378, 7652);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-6-1', 362, 7983);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-6-2', 571, 8535);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-6-3', 610, 9110);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-6-4', 497, 9674);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-6-5', 541, 10049);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-6-6', 368, 10372);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-6-7', 233, 10552);
INSERT INTO `demo_new_trend_of_diagnosis` (`date`, `new_diagnosis`, `current_diagnosis`) VALUES ('2021-6-8', 232, 10740);



INSERT INTO  `datasource` (`id`, `name`, `desc`, `type`, `configuration`, `create_time`, `update_time`, `create_by`) VALUES ('76026997-94f9-4a35-96ca-151084638969', 'demo', 'demo', 'mysql', 'ROM9ccqPioJ1SCj70u/B+KCVPfwPyNbqgIgkguMQEbjrQLbGyQLfqnQdH64Nyb+LyW+vDZzSK0SJFxUGAwGxvUtKnmpwinKRZ9OcFiQB10Nq5r/DH4+2F9/dKBs2lQgrwNj5w6MyhRswSKzkfCw5fNndcN2ad990JjOQLYz2Y5M=', '1624247414781', '1624247414781', 'admin');

INSERT INTO  `dataset_group` (`id`, `name`, `pid`, `level`, `type`, `create_by`, `create_time`) VALUES ('f0728785-cc9a-4c9f-94ca-5bb106534916', '新冠肺炎疫情数据', '0', '0', 'group', 'admin', '1623211708679');
INSERT INTO  `dataset_group` (`id`, `name`, `pid`, `level`, `type`, `create_by`, `create_time`) VALUES ('873c9833-e79d-4004-b809-a81fa83d3e7b', '国内疫情', 'f0728785-cc9a-4c9f-94ca-5bb106534916', '1', 'group', 'admin', '1623211723216');

INSERT INTO  `dataset_table` (`id`, `name`, `scene_id`, `data_source_id`, `type`, `mode`, `info`, `create_by`, `create_time`) VALUES ('10de6211-3104-461f-a5e4-c01c997dcfea', '本土新增确诊趋势_demo', '873c9833-e79d-4004-b809-a81fa83d3e7b', '76026997-94f9-4a35-96ca-151084638969', 'db', '0', '{\"table\":\"demo_new_trend_of_diagnosis\"}', 'admin', '1624247848737');
INSERT INTO  `dataset_table` (`id`, `name`, `scene_id`, `data_source_id`, `type`, `mode`, `info`, `create_by`, `create_time`) VALUES ('23601ac8-d723-45f9-a84f-b1799982422d', '国内疫情_demo', '873c9833-e79d-4004-b809-a81fa83d3e7b', '76026997-94f9-4a35-96ca-151084638969', 'db', '0', '{\"table\":\"demo_domestic_epidemic\"}', 'admin', '1624247848685');
INSERT INTO  `dataset_table` (`id`, `name`, `scene_id`, `data_source_id`, `type`, `mode`, `info`, `create_by`, `create_time`) VALUES ('d54b3270-b8d3-49cb-95e5-1467467d6431', '近期31省市区本土病例_demo', '873c9833-e79d-4004-b809-a81fa83d3e7b', '76026997-94f9-4a35-96ca-151084638969', 'db', '0', '{\"table\":\"demo_recent_local_cases\"}', 'admin', '1624247848780');
INSERT INTO  `dataset_table` (`id`, `name`, `scene_id`, `data_source_id`, `type`, `mode`, `info`, `create_by`, `create_time`) VALUES ('d85a6ff8-1683-4e87-9fe7-3f393ad8a83c', '国内新冠疫苗接种追踪_demo', '873c9833-e79d-4004-b809-a81fa83d3e7b', '76026997-94f9-4a35-96ca-151084638969', 'db', '0', '{\"table\":\"demo_vaccination\"}', 'admin', '1624247848593');

INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `type`, `size`, `de_type`, `de_extract_type`, `checked`, `column_index`, `last_sync_time`) VALUES ('7d179f54-fb48-4e44-b316-f333e5e8e3bf', '10de6211-3104-461f-a5e4-c01c997dcfea', 'new_diagnosis', '新增确诊', 'C_a04c95358dd94af700a379bd5e55b200', 'BIGINT', '19', '2', '2', '1', '1', '1624247848759');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `type`, `size`, `de_type`, `de_extract_type`, `checked`, `column_index`, `last_sync_time`) VALUES ('8a4f319e-82fc-4368-9a96-5f233d3f302a', '10de6211-3104-461f-a5e4-c01c997dcfea', 'date', '日期', 'C_5fc732311905cb27e82d67f4f6511f7f', 'VARCHAR', '50', '0', '0', '1', '0', '1624247848759');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `type`, `size`, `de_type`, `de_extract_type`, `checked`, `column_index`, `last_sync_time`) VALUES ('e8be862b-2802-43b1-8eea-138fec66693c', '10de6211-3104-461f-a5e4-c01c997dcfea', 'current_diagnosis', '现有确诊', 'C_c3bd1b57fc3cd1b1462bae6430e32b01', 'BIGINT', '19', '2', '2', '1', '2', '1624247848759');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `type`, `size`, `de_type`, `de_extract_type`, `checked`, `column_index`, `last_sync_time`) VALUES ('1297d9a6-ee21-4f49-b0fa-10c9274652de', '23601ac8-d723-45f9-a84f-b1799982422d', 'cumulative_death', '累计死亡', 'C_3f83e60853692a995186ef663ef4b9c4', 'BIGINT', '19', '2', '2', '1', '6', '1624247848706');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `type`, `size`, `de_type`, `de_extract_type`, `checked`, `column_index`, `last_sync_time`) VALUES ('37b583fc-3227-4aef-a8d6-3337c1bb5816', '23601ac8-d723-45f9-a84f-b1799982422d', 'cumulative_cure', '累计治愈', 'C_e2e1c18cff9edab2282b9ac6f3428ada', 'BIGINT', '19', '2', '2', '1', '1', '1624247848706');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `type`, `size`, `de_type`, `de_extract_type`, `checked`, `column_index`, `last_sync_time`) VALUES ('3d664864-6575-4869-b452-4aba27c5da37', '23601ac8-d723-45f9-a84f-b1799982422d', 'input', '境外输入', 'C_a43c1b0aa53a0c908810c06ab1ff3967', 'BIGINT', '19', '2', '2', '1', '5', '1624247848706');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `type`, `size`, `de_type`, `de_extract_type`, `checked`, `column_index`, `last_sync_time`) VALUES ('b4cb38fb-521f-4b41-8856-3a5873a81e1c', '23601ac8-d723-45f9-a84f-b1799982422d', 'current_diagnosis', '现有确诊', 'C_c3bd1b57fc3cd1b1462bae6430e32b01', 'BIGINT', '19', '2', '2', '1', '2', '1624247848706');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `type`, `size`, `de_type`, `de_extract_type`, `checked`, `column_index`, `last_sync_time`) VALUES ('c016ec91-7490-498b-8d33-14aee11da501', '23601ac8-d723-45f9-a84f-b1799982422d', 'statistical_time', '统计时间', 'C_e52bb875b9521bcc59a6d571c612f9d6', 'VARCHAR', '50', '0', '0', '1', '0', '1624247848706');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `type`, `size`, `de_type`, `de_extract_type`, `checked`, `column_index`, `last_sync_time`) VALUES ('cb9e9310-1c25-4688-bbfe-5c96ebaa2912', '23601ac8-d723-45f9-a84f-b1799982422d', 'asymptomatic_patient', '无症状感染者', 'C_483c6dc1f3689e52364d81ac789bdbe8', 'BIGINT', '19', '2', '2', '1', '4', '1624247848706');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `type`, `size`, `de_type`, `de_extract_type`, `checked`, `column_index`, `last_sync_time`) VALUES ('fba80c10-fe67-4dbe-8983-8367461c4c8b', '23601ac8-d723-45f9-a84f-b1799982422d', 'cumulative_diagnosis', '累计确诊', 'C_497ca676e1e4729b00c9d1cb070f0834', 'BIGINT', '19', '2', '2', '1', '3', '1624247848706');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `type`, `size`, `de_type`, `de_extract_type`, `checked`, `column_index`, `last_sync_time`) VALUES ('3a4112a5-1e1c-4333-b9ca-df9ab2983a59', 'd54b3270-b8d3-49cb-95e5-1467467d6431', 'existing', '现有', 'C_f4e0ac58eb46d88efc451c164db3b837', 'BIGINT', '19', '2', '2', '1', '3', '1624247848804');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `type`, `size`, `de_type`, `de_extract_type`, `checked`, `column_index`, `last_sync_time`) VALUES ('4045a206-0a59-4a12-9920-9c0426f822c8', 'd54b3270-b8d3-49cb-95e5-1467467d6431', 'new_add', '新增', 'C_65e7f9dc5f5e7904f56be638600763ae', 'BIGINT', '19', '2', '2', '1', '2', '1624247848804');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `type`, `size`, `de_type`, `de_extract_type`, `checked`, `column_index`, `last_sync_time`) VALUES ('64bad760-b320-4f61-ad2d-d065b1cb70b2', 'd54b3270-b8d3-49cb-95e5-1467467d6431', 'city', '城市', 'C_4ed5d2eaed1a1fadcc41ad1d58ed603e', 'VARCHAR', '50', '0', '0', '1', '0', '1624247848804');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `type`, `size`, `de_type`, `de_extract_type`, `checked`, `column_index`, `last_sync_time`) VALUES ('a2a86354-6f3e-41e6-bbac-e4950d9b5370', 'd54b3270-b8d3-49cb-95e5-1467467d6431', 'province', '省市区', 'C_53aad639aca4b5c010927cf610c3ff9c', 'VARCHAR', '50', '0', '0', '1', '1', '1624247848804');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `type`, `size`, `de_type`, `de_extract_type`, `checked`, `column_index`, `last_sync_time`) VALUES ('c92ce162-9bd7-4c46-9fc1-49fa30c348d9', 'd54b3270-b8d3-49cb-95e5-1467467d6431', 'risk', '区域风险', 'C_c6142b27f1385bc163ffe7f4ebfc52ac', 'VARCHAR', '50', '0', '0', '1', '4', '1624247848804');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `type`, `size`, `de_type`, `de_extract_type`, `checked`, `column_index`, `last_sync_time`) VALUES ('59c03fe2-c026-4f61-b0eb-8aafcc7144c1', 'd85a6ff8-1683-4e87-9fe7-3f393ad8a83c', 'cumulative', '累计接种', 'C_dd259fe1898bfef8be8771aca900f7ea', 'DECIMAL', '10', '3', '3', '1', '0', '1624247848620');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `type`, `size`, `de_type`, `de_extract_type`, `checked`, `column_index`, `last_sync_time`) VALUES ('a1c180b0-8de3-447d-bd31-1359b92b74ce', 'd85a6ff8-1683-4e87-9fe7-3f393ad8a83c', 'vaccination_per_100_people', '每百人接种', 'C_26b2c7f3b8b45ddc449f4f16c39fa6b5', 'DECIMAL', '10', '3', '3', '1', '2', '1624247848620');
INSERT INTO  `dataset_table_field` (`id`, `table_id`, `origin_name`, `name`, `dataease_name`, `type`, `size`, `de_type`, `de_extract_type`, `checked`, `column_index`, `last_sync_time`) VALUES ('f3c5d452-8358-4669-bd7d-ce410b957556', 'd85a6ff8-1683-4e87-9fe7-3f393ad8a83c', 'new_add', '较上日新增', 'C_65e7f9dc5f5e7904f56be638600763ae', 'DECIMAL', '10', '3', '3', '1', '1', '1624247848620');


INSERT INTO  `chart_group` (`id`, `name`, `pid`, `level`, `type`, `create_by`, `create_time`) VALUES ('5a8e8b0a-2f64-4d1b-aac1-d284b2b8436f', '新冠疫情', '0', '0', 'group', 'admin', '1623212582950');
INSERT INTO  `chart_group` (`id`, `name`, `pid`, `level`, `type`, `create_by`, `create_time`) VALUES ('4de97755-5d5a-4fe0-9af0-27601f967787', '国内疫情分析', '5a8e8b0a-2f64-4d1b-aac1-d284b2b8436f', '1', 'group', 'admin', '1623212597088');

INSERT INTO  `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `style_priority`) VALUES ('03410ec1-1bd0-4afd-ac37-9306e00e328c', '累计死亡', '4de97755-5d5a-4fe0-9af0-27601f967787', '23601ac8-d723-45f9-a84f-b1799982422d', 'text', '累计死亡', '[]', '[{\"id\":\"1297d9a6-ee21-4f49-b0fa-10c9274652de\",\"tableId\":\"23601ac8-d723-45f9-a84f-b1799982422d\",\"originName\":\"cumulative_death\",\"name\":\"累计死亡\",\"dataeaseName\":\"C_3f83e60853692a995186ef663ef4b9c4\",\"type\":\"BIGINT\",\"size\":19,\"deType\":2,\"deExtractType\":2,\"checked\":true,\"columnIndex\":6,\"lastSyncTime\":1624247848706,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#969696\",\"quotaColor\":\"#a1b4cc\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"14\",\"quotaFontSize\":\"26\",\"spaceSplit\":5,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\"},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"累计死亡\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"background\":{\"color\":\"#ffffff\",\"alpha\":0}}', '[]', 'admin', '1624249965605', '1624252925726', 'view');
INSERT INTO  `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `style_priority`) VALUES ('0d8bc9d7-b76b-4ec5-96e7-0df1c3426205', '现有确诊', '4de97755-5d5a-4fe0-9af0-27601f967787', '10de6211-3104-461f-a5e4-c01c997dcfea', 'text', '现有确诊', '[]', '[{\"id\":\"e8be862b-2802-43b1-8eea-138fec66693c\",\"tableId\":\"10de6211-3104-461f-a5e4-c01c997dcfea\",\"originName\":\"current_diagnosis\",\"name\":\"现有确诊\",\"dataeaseName\":\"C_c3bd1b57fc3cd1b1462bae6430e32b01\",\"type\":\"BIGINT\",\"size\":19,\"deType\":2,\"deExtractType\":2,\"checked\":true,\"columnIndex\":2,\"lastSyncTime\":1624247848759,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#696969\",\"quotaColor\":\"#0071be\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"14\",\"quotaFontSize\":\"26\",\"spaceSplit\":5,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\"},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"现有确诊\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"background\":{\"color\":\"#ffffff\",\"alpha\":0}}', '[]', 'admin', '1624249438271', '1624249484520', 'view');
INSERT INTO  `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `style_priority`) VALUES ('1aad98e5-3f99-4c0a-aa75-ca9236de0f09', '境外输入', '4de97755-5d5a-4fe0-9af0-27601f967787', '23601ac8-d723-45f9-a84f-b1799982422d', 'text', '境外输入', '[]', '[{\"id\":\"3d664864-6575-4869-b452-4aba27c5da37\",\"tableId\":\"23601ac8-d723-45f9-a84f-b1799982422d\",\"originName\":\"input\",\"name\":\"境外输入\",\"dataeaseName\":\"C_a43c1b0aa53a0c908810c06ab1ff3967\",\"type\":\"BIGINT\",\"size\":19,\"deType\":2,\"deExtractType\":2,\"checked\":true,\"columnIndex\":5,\"lastSyncTime\":1624247848706,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#696969\",\"quotaColor\":\"#0071be\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"14\",\"quotaFontSize\":\"26\",\"spaceSplit\":5,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\"},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"境外输入\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"background\":{\"color\":\"#ffffff\",\"alpha\":0}}', '[]', 'admin', '1624249147884', '1624252914434', 'view');
INSERT INTO  `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `style_priority`) VALUES ('2f9bf4d5-b1d3-4cac-9df2-2c8827d65bbf', '全国新增确诊趋势', '4de97755-5d5a-4fe0-9af0-27601f967787', '10de6211-3104-461f-a5e4-c01c997dcfea', 'line', '全国新增确诊趋势', '[{\"id\":\"8a4f319e-82fc-4368-9a96-5f233d3f302a\",\"tableId\":\"10de6211-3104-461f-a5e4-c01c997dcfea\",\"originName\":\"date\",\"name\":\"日期\",\"dataeaseName\":\"C_5fc732311905cb27e82d67f4f6511f7f\",\"type\":\"VARCHAR\",\"size\":50,\"deType\":0,\"deExtractType\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1624247848759,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[]}]', '[{\"id\":\"7d179f54-fb48-4e44-b316-f333e5e8e3bf\",\"tableId\":\"10de6211-3104-461f-a5e4-c01c997dcfea\",\"originName\":\"new_diagnosis\",\"name\":\"新增确诊\",\"dataeaseName\":\"C_a04c95358dd94af700a379bd5e55b200\",\"type\":\"BIGINT\",\"size\":19,\"deType\":2,\"deExtractType\":2,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1624247848759,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"retro\",\"colors\":[\"#0780cf\",\"#765005\",\"#fa6d1d\",\"#0e2c82\",\"#b6b51f\",\"#da1f18\",\"#701866\",\"#f47a75\",\"#009db2\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":true,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\"},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"全国新增确诊趋势\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"background\":{\"color\":\"#ffffff\",\"alpha\":0}}', '[]', 'admin', '1624248675969', '1624248840182', 'view');
INSERT INTO  `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `style_priority`) VALUES ('3a5e4081-4cd5-427f-bd3a-ff7815efaf25', '无症状感染者', '4de97755-5d5a-4fe0-9af0-27601f967787', '23601ac8-d723-45f9-a84f-b1799982422d', 'text', '无症状感染者', '[]', '[{\"id\":\"cb9e9310-1c25-4688-bbfe-5c96ebaa2912\",\"tableId\":\"23601ac8-d723-45f9-a84f-b1799982422d\",\"originName\":\"asymptomatic_patient\",\"name\":\"无症状感染者\",\"dataeaseName\":\"C_483c6dc1f3689e52364d81ac789bdbe8\",\"type\":\"BIGINT\",\"size\":19,\"deType\":2,\"deExtractType\":2,\"checked\":true,\"columnIndex\":4,\"lastSyncTime\":1624247848706,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#696969\",\"quotaColor\":\"#0071be\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"14\",\"quotaFontSize\":\"26\",\"spaceSplit\":5,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\"},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"无症状感染者\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"background\":{\"color\":\"#ffffff\",\"alpha\":0}}', '[]', 'admin', '1624249361370', '1624252918488', 'view');
INSERT INTO  `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `style_priority`) VALUES ('57760693-15db-4de9-9170-55ee7d1eb0eb', '病例数TOP5城市', '4de97755-5d5a-4fe0-9af0-27601f967787', 'd54b3270-b8d3-49cb-95e5-1467467d6431', 'bar-horizontal', '病例数TOP5城市', '[{\"id\":\"a2a86354-6f3e-41e6-bbac-e4950d9b5370\",\"tableId\":\"d54b3270-b8d3-49cb-95e5-1467467d6431\",\"originName\":\"province\",\"name\":\"省市区\",\"dataeaseName\":\"C_53aad639aca4b5c010927cf610c3ff9c\",\"type\":\"VARCHAR\",\"size\":50,\"deType\":0,\"deExtractType\":0,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1624247848804,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[]},{\"id\":\"64bad760-b320-4f61-ad2d-d065b1cb70b2\",\"tableId\":\"d54b3270-b8d3-49cb-95e5-1467467d6431\",\"originName\":\"city\",\"name\":\"城市\",\"dataeaseName\":\"C_4ed5d2eaed1a1fadcc41ad1d58ed603e\",\"type\":\"VARCHAR\",\"size\":50,\"deType\":0,\"deExtractType\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1624247848804,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[]}]', '[{\"id\":\"3a4112a5-1e1c-4333-b9ca-df9ab2983a59\",\"tableId\":\"d54b3270-b8d3-49cb-95e5-1467467d6431\",\"originName\":\"existing\",\"name\":\"现有\",\"dataeaseName\":\"C_f4e0ac58eb46d88efc451c164db3b837\",\"type\":\"BIGINT\",\"size\":19,\"deType\":2,\"deExtractType\":2,\"checked\":true,\"columnIndex\":3,\"lastSyncTime\":1624247848804,\"summary\":\"sum\",\"sort\":\"asc\",\"filter\":[]}]', '{\"color\":{\"value\":\"retro\",\"colors\":[\"#0780cf\",\"#765005\",\"#fa6d1d\",\"#0e2c82\",\"#b6b51f\",\"#da1f18\",\"#701866\",\"#f47a75\",\"#009db2\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":true,\"position\":\"right\",\"color\":\"#909399\",\"fontSize\":\"12\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\"},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"background\":{\"color\":\"#ffffff\",\"alpha\":0}}', '[]', 'admin', '1624249684417', '1624249790735', 'view');
INSERT INTO  `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `style_priority`) VALUES ('5f694f25-b0fd-45f6-acbd-9dd338e196ce', '疫苗接种', '4de97755-5d5a-4fe0-9af0-27601f967787', 'd85a6ff8-1683-4e87-9fe7-3f393ad8a83c', 'gauge', '疫苗接种', '[]', '[{\"id\":\"a1c180b0-8de3-447d-bd31-1359b92b74ce\",\"tableId\":\"d85a6ff8-1683-4e87-9fe7-3f393ad8a83c\",\"originName\":\"vaccination_per_100_people\",\"name\":\"疫苗接种率\",\"dataeaseName\":\"C_26b2c7f3b8b45ddc449f4f16c39fa6b5\",\"type\":\"DECIMAL\",\"size\":10,\"deType\":3,\"deExtractType\":3,\"checked\":true,\"columnIndex\":2,\"lastSyncTime\":1624247848620,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[],\"index\":0,\"renameType\":\"quota\"}]', '{\"color\":{\"value\":\"retro\",\"colors\":[\"#0780cf\",\"#765005\",\"#fa6d1d\",\"#0e2c82\",\"#b6b51f\",\"#da1f18\",\"#701866\",\"#f47a75\",\"#009db2\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#e2534d\",\"fontSize\":\"14\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\"},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"疫苗接种\"},\"legend\":{\"show\":false,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"background\":{\"color\":\"#ffffff\",\"alpha\":0}}', '[]', 'admin', '1624249520603', '1624249658182', 'view');
INSERT INTO  `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `style_priority`) VALUES ('93a58625-3730-4a07-99bd-75f174ff428d', '全国现有确诊趋势', '4de97755-5d5a-4fe0-9af0-27601f967787', '10de6211-3104-461f-a5e4-c01c997dcfea', 'line', '全国现有确诊趋势', '[{\"id\":\"8a4f319e-82fc-4368-9a96-5f233d3f302a\",\"tableId\":\"10de6211-3104-461f-a5e4-c01c997dcfea\",\"originName\":\"date\",\"name\":\"日期\",\"dataeaseName\":\"C_5fc732311905cb27e82d67f4f6511f7f\",\"type\":\"VARCHAR\",\"size\":50,\"deType\":0,\"deExtractType\":0,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1624247848759,\"dateStyle\":\"y_M_d\",\"datePattern\":\"date_sub\",\"sort\":\"none\",\"filter\":[]}]', '[{\"id\":\"e8be862b-2802-43b1-8eea-138fec66693c\",\"tableId\":\"10de6211-3104-461f-a5e4-c01c997dcfea\",\"originName\":\"current_diagnosis\",\"name\":\"现有确诊\",\"dataeaseName\":\"C_c3bd1b57fc3cd1b1462bae6430e32b01\",\"type\":\"BIGINT\",\"size\":19,\"deType\":2,\"deExtractType\":2,\"checked\":true,\"columnIndex\":2,\"lastSyncTime\":1624247848759,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"retro\",\"colors\":[\"#0780cf\",\"#765005\",\"#fa6d1d\",\"#0e2c82\",\"#b6b51f\",\"#da1f18\",\"#701866\",\"#f47a75\",\"#009db2\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"none\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":18,\"quotaFontSize\":18,\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\"},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"background\":{\"color\":\"#ffffff\",\"alpha\":0}}', '[]', 'admin', '1624248876997', '1624248945385', 'view');
INSERT INTO  `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `style_priority`) VALUES ('ce33ad2c-3915-41cc-8d86-55405456ed05', '累计接种', '4de97755-5d5a-4fe0-9af0-27601f967787', 'd85a6ff8-1683-4e87-9fe7-3f393ad8a83c', 'text', '累计接种', '[]', '[{\"id\":\"59c03fe2-c026-4f61-b0eb-8aafcc7144c1\",\"tableId\":\"d85a6ff8-1683-4e87-9fe7-3f393ad8a83c\",\"originName\":\"cumulative\",\"name\":\"累计接种\",\"dataeaseName\":\"C_dd259fe1898bfef8be8771aca900f7ea\",\"type\":\"DECIMAL\",\"size\":10,\"deType\":3,\"deExtractType\":3,\"checked\":true,\"columnIndex\":0,\"lastSyncTime\":1624247848620,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#00af57\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"14\",\"quotaFontSize\":\"30\",\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\"},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":true,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"background\":{\"color\":\"#ffffff\",\"alpha\":0}}', '[]', 'admin', '1624249858884', '1624252923879', 'view');
INSERT INTO  `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `style_priority`) VALUES ('de923e69-df6b-4f61-9391-da2987f77b51', '较上日新增', '4de97755-5d5a-4fe0-9af0-27601f967787', 'd85a6ff8-1683-4e87-9fe7-3f393ad8a83c', 'text', '较上日新增', '[]', '[{\"id\":\"f3c5d452-8358-4669-bd7d-ce410b957556\",\"tableId\":\"d85a6ff8-1683-4e87-9fe7-3f393ad8a83c\",\"originName\":\"new_add\",\"name\":\"较上日新增\",\"dataeaseName\":\"C_65e7f9dc5f5e7904f56be638600763ae\",\"type\":\"DECIMAL\",\"size\":10,\"deType\":3,\"deExtractType\":3,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1624247848620,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#00afee\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"14\",\"quotaFontSize\":\"32\",\"spaceSplit\":10,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\"},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"较上日新增\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"background\":{\"color\":\"#ffffff\",\"alpha\":0}}', '[]', 'admin', '1624250284730', '1624252930099', 'view');
INSERT INTO  `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `style_priority`) VALUES ('eaa8947b-d9e7-4ca4-ba65-08965dfa620c', '新增确诊', '4de97755-5d5a-4fe0-9af0-27601f967787', '10de6211-3104-461f-a5e4-c01c997dcfea', 'text', '新增确诊', '[]', '[{\"id\":\"7d179f54-fb48-4e44-b316-f333e5e8e3bf\",\"tableId\":\"10de6211-3104-461f-a5e4-c01c997dcfea\",\"originName\":\"new_diagnosis\",\"name\":\"新增确诊\",\"dataeaseName\":\"C_a04c95358dd94af700a379bd5e55b200\",\"type\":\"BIGINT\",\"size\":19,\"deType\":2,\"deExtractType\":2,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1624247848759,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#696969\",\"quotaColor\":\"#0071be\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"14\",\"quotaFontSize\":\"26\",\"spaceSplit\":5,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\"},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"新增确诊\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"background\":{\"color\":\"#ffffff\",\"alpha\":0}}', '[]', 'admin', '1624249288236', '1624252916490', 'view');
INSERT INTO  `chart_view` (`id`, `name`, `scene_id`, `table_id`, `type`, `title`, `x_axis`, `y_axis`, `custom_attr`, `custom_style`, `custom_filter`, `create_by`, `create_time`, `update_time`, `style_priority`) VALUES ('9ecb6827-f47f-4b19-b788-81a6b55940af', '累计治愈', '4de97755-5d5a-4fe0-9af0-27601f967787', '23601ac8-d723-45f9-a84f-b1799982422d', 'text', '累计治愈', '[]', '[{\"id\":\"37b583fc-3227-4aef-a8d6-3337c1bb5816\",\"tableId\":\"23601ac8-d723-45f9-a84f-b1799982422d\",\"originName\":\"cumulative_cure\",\"name\":\"累计治愈\",\"dataeaseName\":\"C_e2e1c18cff9edab2282b9ac6f3428ada\",\"type\":\"BIGINT\",\"size\":19,\"deType\":2,\"deExtractType\":2,\"checked\":true,\"columnIndex\":1,\"lastSyncTime\":1624247848706,\"summary\":\"sum\",\"sort\":\"none\",\"filter\":[]}]', '{\"color\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#c4c4c4\",\"quotaColor\":\"#a1b4cc\"},\"tableColor\":{\"value\":\"default\",\"colors\":[\"#5470c6\",\"#91cc75\",\"#fac858\",\"#ee6666\",\"#73c0de\",\"#3ba272\",\"#fc8452\",\"#9a60b4\",\"#ea7ccc\"],\"alpha\":100,\"tableHeaderBgColor\":\"#4e81bb\",\"tableItemBgColor\":\"#c6d9f0\",\"tableFontColor\":\"#000000\",\"tableStripe\":true,\"dimensionColor\":\"#000000\",\"quotaColor\":\"#000000\"},\"size\":{\"barDefault\":true,\"barWidth\":40,\"barGap\":0.4,\"lineWidth\":1,\"lineType\":\"solid\",\"lineSymbol\":\"emptyCircle\",\"lineSymbolSize\":4,\"lineSmooth\":false,\"lineArea\":false,\"pieInnerRadius\":0,\"pieOuterRadius\":60,\"pieRoseType\":\"radius\",\"pieRoseRadius\":5,\"funnelWidth\":80,\"radarShape\":\"polygon\",\"tableTitleFontSize\":12,\"tableItemFontSize\":12,\"gaugeMin\":0,\"gaugeMax\":100,\"gaugeStartAngle\":225,\"gaugeEndAngle\":-45,\"dimensionFontSize\":\"14\",\"quotaFontSize\":\"26\",\"spaceSplit\":5,\"dimensionShow\":true,\"quotaShow\":true},\"label\":{\"show\":false,\"position\":\"top\",\"color\":\"#909399\",\"fontSize\":\"10\",\"formatter\":\"{c}\",\"gaugeFormatter\":\"{value}\"},\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"confine\":true,\"textStyle\":{\"fontSize\":\"10\",\"color\":\"#909399\"},\"formatter\":\"\"}}', '{\"text\":{\"show\":false,\"fontSize\":\"18\",\"color\":\"#303133\",\"hPosition\":\"center\",\"vPosition\":\"top\",\"isItalic\":false,\"title\":\"累计治愈\"},\"legend\":{\"show\":true,\"hPosition\":\"center\",\"vPosition\":\"bottom\",\"orient\":\"horizontal\",\"icon\":\"rect\",\"textStyle\":{\"color\":\"#333333\",\"fontSize\":\"12\"}},\"xAxis\":{\"show\":true,\"position\":\"bottom\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"yAxis\":{\"show\":true,\"position\":\"left\",\"name\":\"\",\"axisLabel\":{\"rotate\":0,\"formatter\":\"{value}\"}},\"background\":{\"color\":\"#ffffff\",\"alpha\":0}}', '[]', 'admin', '1624260562502', '1624260618861', 'view');

INSERT INTO  `panel_group` (`id`, `name`, `pid`, `level`, `node_type`, `create_by`, `create_time`, `panel_type`, `panel_style`, `panel_data`) VALUES ('308b5d60-ceb4-465d-9bad-cf901f2d38f1', '示例看板', 'panel_list', '0', 'folder', 'admin', '1624250448802', 'self', '{\"width\":1600,\"height\":900,\"scale\":100,\"scaleWidth\":100,\"scaleHeight\":100,\"selfAdaption\":true,\"auxiliaryMatrix\":true,\"openCommonStyle\":true,\"panel\":{\"color\":\"#ffffff\",\"imageUrl\":null,\"backgroundType\":\"image\",\"gap\":\"no\"},\"chart\":{\"xaxis\":\"[]\",\"yaxis\":\"[]\",\"show\":true,\"type\":\"panel\",\"title\":\"\",\"customAttr\":\"{\\\"color\\\":{\\\"value\\\":\\\"default\\\",\\\"colors\\\":[\\\"#5470c6\\\",\\\"#91cc75\\\",\\\"#fac858\\\",\\\"#ee6666\\\",\\\"#73c0de\\\",\\\"#3ba272\\\",\\\"#fc8452\\\",\\\"#9a60b4\\\",\\\"#ea7ccc\\\"],\\\"alpha\\\":100,\\\"tableHeaderBgColor\\\":\\\"#4e81bb\\\",\\\"tableItemBgColor\\\":\\\"#c6d9f0\\\",\\\"tableFontColor\\\":\\\"#000000\\\",\\\"tableStripe\\\":true,\\\"dimensionColor\\\":\\\"#000000\\\",\\\"quotaColor\\\":\\\"#000000\\\"},\\\"tableColor\\\":{\\\"value\\\":\\\"default\\\",\\\"colors\\\":[\\\"#5470c6\\\",\\\"#91cc75\\\",\\\"#fac858\\\",\\\"#ee6666\\\",\\\"#73c0de\\\",\\\"#3ba272\\\",\\\"#fc8452\\\",\\\"#9a60b4\\\",\\\"#ea7ccc\\\"],\\\"alpha\\\":100,\\\"tableHeaderBgColor\\\":\\\"#4e81bb\\\",\\\"tableItemBgColor\\\":\\\"#c6d9f0\\\",\\\"tableFontColor\\\":\\\"#000000\\\",\\\"tableStripe\\\":true,\\\"dimensionColor\\\":\\\"#000000\\\",\\\"quotaColor\\\":\\\"#000000\\\"},\\\"size\\\":{\\\"barDefault\\\":true,\\\"barWidth\\\":40,\\\"barGap\\\":0.4,\\\"lineWidth\\\":1,\\\"lineType\\\":\\\"solid\\\",\\\"lineSymbol\\\":\\\"emptyCircle\\\",\\\"lineSymbolSize\\\":4,\\\"lineSmooth\\\":false,\\\"lineArea\\\":false,\\\"pieInnerRadius\\\":0,\\\"pieOuterRadius\\\":60,\\\"pieRoseType\\\":\\\"radius\\\",\\\"pieRoseRadius\\\":5,\\\"funnelWidth\\\":80,\\\"radarShape\\\":\\\"polygon\\\",\\\"tableTitleFontSize\\\":12,\\\"tableItemFontSize\\\":12,\\\"gaugeMin\\\":0,\\\"gaugeMax\\\":100,\\\"gaugeStartAngle\\\":225,\\\"gaugeEndAngle\\\":-45,\\\"dimensionFontSize\\\":18,\\\"quotaFontSize\\\":18,\\\"spaceSplit\\\":10,\\\"dimensionShow\\\":true,\\\"quotaShow\\\":true},\\\"label\\\":{\\\"show\\\":false,\\\"position\\\":\\\"top\\\",\\\"color\\\":\\\"#909399\\\",\\\"fontSize\\\":\\\"10\\\",\\\"formatter\\\":\\\"{c}\\\",\\\"gaugeFormatter\\\":\\\"{value}\\\"},\\\"tooltip\\\":{\\\"show\\\":true,\\\"trigger\\\":\\\"item\\\",\\\"confine\\\":true,\\\"textStyle\\\":{\\\"fontSize\\\":\\\"10\\\",\\\"color\\\":\\\"#909399\\\"},\\\"formatter\\\":\\\"\\\"}}\",\"customStyle\":\"{\\\"text\\\":{\\\"show\\\":true,\\\"fontSize\\\":\\\"18\\\",\\\"color\\\":\\\"#303133\\\",\\\"hPosition\\\":\\\"center\\\",\\\"vPosition\\\":\\\"top\\\",\\\"isItalic\\\":false},\\\"legend\\\":{\\\"show\\\":true,\\\"hPosition\\\":\\\"center\\\",\\\"vPosition\\\":\\\"bottom\\\",\\\"orient\\\":\\\"horizontal\\\",\\\"icon\\\":\\\"rect\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#333333\\\",\\\"fontSize\\\":\\\"12\\\"}},\\\"xAxis\\\":{\\\"show\\\":true,\\\"position\\\":\\\"bottom\\\",\\\"name\\\":\\\"\\\",\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"formatter\\\":\\\"{value}\\\"}},\\\"yAxis\\\":{\\\"show\\\":true,\\\"position\\\":\\\"left\\\",\\\"name\\\":\\\"\\\",\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"formatter\\\":\\\"{value}\\\"}},\\\"background\\\":{\\\"color\\\":\\\"#ffffff\\\",\\\"alpha\\\":0}}\",\"customFilter\":\"[]\"}}', '[]');
INSERT INTO  `panel_group` (`id`, `name`, `pid`, `level`, `node_type`, `create_by`, `create_time`, `panel_type`, `panel_style`, `panel_data`) VALUES ('ceb6cd6c-531e-4a23-a467-caa5ef7218cc', '新冠疫情动态看板', '308b5d60-ceb4-465d-9bad-cf901f2d38f1', '1', 'panel', 'admin', '1624252989144', 'self', '{\"width\":1600,\"height\":900,\"scale\":100,\"scaleWidth\":100,\"scaleHeight\":100,\"selfAdaption\":true,\"auxiliaryMatrix\":false,\"openCommonStyle\":true,\"panel\":{\"color\":\"#ffffff\",\"imageUrl\":null,\"backgroundType\":\"image\",\"gap\":\"yes\"},\"chart\":{\"xaxis\":\"[]\",\"yaxis\":\"[]\",\"show\":true,\"type\":\"panel\",\"title\":\"\",\"customAttr\":\"{\\\"color\\\":{\\\"value\\\":\\\"default\\\",\\\"colors\\\":[\\\"#5470c6\\\",\\\"#91cc75\\\",\\\"#fac858\\\",\\\"#ee6666\\\",\\\"#73c0de\\\",\\\"#3ba272\\\",\\\"#fc8452\\\",\\\"#9a60b4\\\",\\\"#ea7ccc\\\"],\\\"alpha\\\":100,\\\"tableHeaderBgColor\\\":\\\"#4e81bb\\\",\\\"tableItemBgColor\\\":\\\"#c6d9f0\\\",\\\"tableFontColor\\\":\\\"#000000\\\",\\\"tableStripe\\\":true,\\\"dimensionColor\\\":\\\"#000000\\\",\\\"quotaColor\\\":\\\"#000000\\\"},\\\"tableColor\\\":{\\\"value\\\":\\\"default\\\",\\\"colors\\\":[\\\"#5470c6\\\",\\\"#91cc75\\\",\\\"#fac858\\\",\\\"#ee6666\\\",\\\"#73c0de\\\",\\\"#3ba272\\\",\\\"#fc8452\\\",\\\"#9a60b4\\\",\\\"#ea7ccc\\\"],\\\"alpha\\\":100,\\\"tableHeaderBgColor\\\":\\\"#4e81bb\\\",\\\"tableItemBgColor\\\":\\\"#c6d9f0\\\",\\\"tableFontColor\\\":\\\"#000000\\\",\\\"tableStripe\\\":true,\\\"dimensionColor\\\":\\\"#000000\\\",\\\"quotaColor\\\":\\\"#000000\\\"},\\\"size\\\":{\\\"barDefault\\\":true,\\\"barWidth\\\":40,\\\"barGap\\\":0.4,\\\"lineWidth\\\":1,\\\"lineType\\\":\\\"solid\\\",\\\"lineSymbol\\\":\\\"emptyCircle\\\",\\\"lineSymbolSize\\\":4,\\\"lineSmooth\\\":false,\\\"lineArea\\\":false,\\\"pieInnerRadius\\\":0,\\\"pieOuterRadius\\\":60,\\\"pieRoseType\\\":\\\"radius\\\",\\\"pieRoseRadius\\\":5,\\\"funnelWidth\\\":80,\\\"radarShape\\\":\\\"polygon\\\",\\\"tableTitleFontSize\\\":12,\\\"tableItemFontSize\\\":12,\\\"gaugeMin\\\":0,\\\"gaugeMax\\\":100,\\\"gaugeStartAngle\\\":225,\\\"gaugeEndAngle\\\":-45,\\\"dimensionFontSize\\\":18,\\\"quotaFontSize\\\":18,\\\"spaceSplit\\\":10,\\\"dimensionShow\\\":true,\\\"quotaShow\\\":true},\\\"label\\\":{\\\"show\\\":false,\\\"position\\\":\\\"top\\\",\\\"color\\\":\\\"#909399\\\",\\\"fontSize\\\":\\\"10\\\",\\\"formatter\\\":\\\"{c}\\\",\\\"gaugeFormatter\\\":\\\"{value}\\\"},\\\"tooltip\\\":{\\\"show\\\":true,\\\"trigger\\\":\\\"item\\\",\\\"confine\\\":true,\\\"textStyle\\\":{\\\"fontSize\\\":\\\"10\\\",\\\"color\\\":\\\"#909399\\\"},\\\"formatter\\\":\\\"\\\"}}\",\"customStyle\":\"{\\\"text\\\":{\\\"show\\\":true,\\\"fontSize\\\":\\\"18\\\",\\\"color\\\":\\\"#303133\\\",\\\"hPosition\\\":\\\"center\\\",\\\"vPosition\\\":\\\"top\\\",\\\"isItalic\\\":false},\\\"legend\\\":{\\\"show\\\":true,\\\"hPosition\\\":\\\"center\\\",\\\"vPosition\\\":\\\"bottom\\\",\\\"orient\\\":\\\"horizontal\\\",\\\"icon\\\":\\\"rect\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#333333\\\",\\\"fontSize\\\":\\\"12\\\"}},\\\"xAxis\\\":{\\\"show\\\":true,\\\"position\\\":\\\"bottom\\\",\\\"name\\\":\\\"\\\",\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"formatter\\\":\\\"{value}\\\"}},\\\"yAxis\\\":{\\\"show\\\":true,\\\"position\\\":\\\"left\\\",\\\"name\\\":\\\"\\\",\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"formatter\\\":\\\"{value}\\\"}},\\\"background\\\":{\\\"color\\\":\\\"#ffffff\\\",\\\"alpha\\\":0}}\",\"customFilter\":\"[]\"}}', '[{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"ca491ff0-d262-11eb-a946-2b135fb6155e\",\"component\":\"rect-shape\",\"label\":\"矩形\",\"propValue\":\"\",\"icon\":\"juxing\",\"type\":\"rect-shape\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":397.6811594202899,\"height\":333.63180515759313,\"borderColor\":\"#FFFFFF\",\"borderWidth\":1,\"backgroundColor\":\"#FFFFFF\",\"borderStyle\":\"solid\",\"top\":77.82951146131805,\"left\":1.1594202898550725},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"ca491ff1-d262-11eb-a946-2b135fb6155e\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"1df3b270-d257-11eb-81e2-d71facaac10c\",\"viewId\":\"3a5e4081-4cd5-427f-bd3a-ff7815efaf25\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":133.33333333333334,\"height\":112.5,\"borderRadius\":\"\",\"top\":84.02578796561603,\"left\":205.2173913043478},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"ca491ff2-d262-11eb-a946-2b135fb6155e\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"1c768850-d257-11eb-81e2-d71facaac10c\",\"viewId\":\"57760693-15db-4de9-9170-55ee7d1eb0eb\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":800,\"height\":487.49999999999994,\"borderRadius\":\"\",\"top\":412.49999999999994,\"left\":0},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"ca491ff3-d262-11eb-a946-2b135fb6155e\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"1d5c2d60-d257-11eb-81e2-d71facaac10c\",\"viewId\":\"0d8bc9d7-b76b-4ec5-96e7-0df1c3426205\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":133.33333333333334,\"height\":112.5,\"borderRadius\":\"\",\"top\":187.44627507163324,\"left\":18.55072463768116},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"ca491ff5-d262-11eb-a946-2b135fb6155e\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"1b8c4f60-d257-11eb-81e2-d71facaac10c\",\"viewId\":\"03410ec1-1bd0-4afd-ac37-9306e00e328c\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":133.33333333333334,\"height\":112.5,\"borderRadius\":\"\",\"top\":294.94985673352437,\"left\":207.53623188405797},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"ca491ff6-d262-11eb-a946-2b135fb6155e\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"1e658710-d257-11eb-81e2-d71facaac10c\",\"viewId\":\"eaa8947b-d9e7-4ca4-ba65-08965dfa620c\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":133.33333333333334,\"height\":112.5,\"borderRadius\":\"\",\"top\":83.86465616045847,\"left\":18.55072463768116},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"ca491ff7-d262-11eb-a946-2b135fb6155e\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"1f4d00e0-d257-11eb-81e2-d71facaac10c\",\"viewId\":\"93a58625-3730-4a07-99bd-75f174ff428d\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":800,\"height\":487.49999999999994,\"borderRadius\":\"\",\"top\":412.49999999999994,\"left\":800},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"ca491ff8-d262-11eb-a946-2b135fb6155e\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"1fd48060-d257-11eb-81e2-d71facaac10c\",\"viewId\":\"2f9bf4d5-b1d3-4cac-9df2-2c8827d65bbf\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":800,\"height\":337.5,\"borderRadius\":\"\",\"top\":74.99999999999999,\"left\":800},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"ca491ff9-d262-11eb-a946-2b135fb6155e\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"1ee7fd80-d257-11eb-81e2-d71facaac10c\",\"viewId\":\"1aad98e5-3f99-4c0a-aa75-ca9236de0f09\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":133.33333333333334,\"height\":112.5,\"borderRadius\":\"\",\"top\":294.94985673352437,\"left\":18.55072463768116},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"ca491ffa-d262-11eb-a946-2b135fb6155e\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"1ce96e60-d257-11eb-81e2-d71facaac10c\",\"viewId\":\"5f694f25-b0fd-45f6-acbd-9dd338e196ce\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":400,\"height\":337.5,\"borderRadius\":\"\",\"top\":74.99999999999999,\"left\":400},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"ca491ffb-d262-11eb-a946-2b135fb6155e\",\"component\":\"rect-shape\",\"label\":\"矩形\",\"propValue\":\"\",\"icon\":\"juxing\",\"type\":\"rect-shape\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":1598.840579710145,\"height\":73.7106017191977,\"borderColor\":\"#FFFFFF\",\"borderWidth\":1,\"backgroundColor\":\"#FFFFFF\",\"borderStyle\":\"solid\",\"top\":3.223452722063045,\"left\":1.1594202898550725},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"ca491ffc-d262-11eb-a946-2b135fb6155e\",\"component\":\"Picture\",\"label\":\"图片\",\"icon\":\"\",\"propValue\":\"data:image/png;base64,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\",\"style\":{\"rotate\":0,\"opacity\":1,\"top\":0,\"left\":214.4927536231884,\"width\":0,\"height\":74.99999999999999},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"ca491ffd-d262-11eb-a946-2b135fb6155e\",\"component\":\"v-text\",\"label\":\"文字\",\"propValue\":\"新冠疫情动态看板\",\"icon\":\"wenben\",\"type\":\"v-text\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":266.6666666666667,\"height\":46.63323782234955,\"fontSize\":\"24\",\"fontWeight\":500,\"lineHeight\":\"\",\"letterSpacing\":0,\"textAlign\":\"\",\"color\":\"#000000\",\"top\":12.607448424068776,\"left\":107.82608695652173},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"ca491ffe-d262-11eb-a946-2b135fb6155e\",\"component\":\"Picture\",\"label\":\"图片\",\"icon\":\"\",\"propValue\":\"data:image/png;base64,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\",\"style\":{\"rotate\":0,\"opacity\":1,\"top\":4.333815186246434,\"left\":8.115942028985508,\"width\":84.39566624454766,\"height\":71.06017191977074},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"ca491fff-d262-11eb-a946-2b135fb6155e\",\"component\":\"v-text\",\"label\":\"文字\",\"propValue\":\"2021/6/5 10:24:27\",\"icon\":\"wenben\",\"type\":\"v-text\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":186.66666666666666,\"height\":37.49999999999999,\"fontSize\":\"14\",\"fontWeight\":500,\"lineHeight\":\"\",\"letterSpacing\":0,\"textAlign\":\"center\",\"color\":\"#FF0000\",\"top\":21.042262177650432,\"left\":1348.4057971014493},\"filters\":[]},{\"animations\":[],\"events\":{},\"groupStyle\":{},\"isLock\":false,\"id\":\"d707e960-d262-11eb-a946-2b135fb6155e\",\"component\":\"user-view\",\"label\":\"用户视图\",\"propValue\":{\"id\":\"d707e960-d262-11eb-a946-2b135fb6155e\",\"viewId\":\"9ecb6827-f47f-4b19-b788-81a6b55940af\"},\"icon\":\"juxing\",\"type\":\"view\",\"style\":{\"rotate\":0,\"opacity\":1,\"width\":89.92,\"height\":76.8174474959612,\"borderRadius\":\"\",\"top\":204.17124394184165,\"left\":226.81727999999998},\"filters\":[]}]');

INSERT INTO `panel_subject`(`id`, `name`, `type`, `details`, `create_time`, `create_by`, `update_time`, `update_by`) VALUES ('dd557705-5bb7-436e-aee3-b81e822c1523', '系统主题1', 'system', '{\"width\":1600,\"height\":900,\"scale\":100,\"scaleWidth\":100,\"scaleHeight\":100,\"selfAdaption\":true,\"auxiliaryMatrix\":false,\"openCommonStyle\":true,\"panel\":{\"color\":\"#eaf1de\",\"imageUrl\":{},\"backgroundType\":\"color\",\"gap\":\"yes\"},\"chart\":{\"xaxis\":\"[]\",\"yaxis\":\"[]\",\"show\":true,\"type\":\"panel\",\"title\":\"\",\"customAttr\":\"{\\\"color\\\":{\\\"value\\\":\\\"gradual\\\",\\\"colors\\\":[\\\"#71ae46\\\",\\\"#96b744\\\",\\\"#c4cc38\\\",\\\"#ebe12a\\\",\\\"#eab026\\\",\\\"#e3852b\\\",\\\"#d85d2a\\\",\\\"#ce2626\\\",\\\"#ac2026\\\"],\\\"alpha\\\":100,\\\"tableHeaderBgColor\\\":\\\"#4e81bb\\\",\\\"tableItemBgColor\\\":\\\"#c6d9f0\\\",\\\"tableFontColor\\\":\\\"#000000\\\",\\\"tableStripe\\\":true,\\\"dimensionColor\\\":\\\"#000000\\\",\\\"quotaColor\\\":\\\"#000000\\\"},\\\"tableColor\\\":{\\\"value\\\":\\\"default\\\",\\\"colors\\\":[\\\"#5470c6\\\",\\\"#91cc75\\\",\\\"#fac858\\\",\\\"#ee6666\\\",\\\"#73c0de\\\",\\\"#3ba272\\\",\\\"#fc8452\\\",\\\"#9a60b4\\\",\\\"#ea7ccc\\\"],\\\"alpha\\\":100,\\\"tableHeaderBgColor\\\":\\\"#9aba60\\\",\\\"tableItemBgColor\\\":\\\"#ffffff\\\",\\\"tableFontColor\\\":\\\"#000000\\\",\\\"tableStripe\\\":true,\\\"dimensionColor\\\":\\\"#000000\\\",\\\"quotaColor\\\":\\\"#000000\\\"},\\\"size\\\":{\\\"barDefault\\\":true,\\\"barWidth\\\":40,\\\"barGap\\\":0.4,\\\"lineWidth\\\":1,\\\"lineType\\\":\\\"solid\\\",\\\"lineSymbol\\\":\\\"emptyCircle\\\",\\\"lineSymbolSize\\\":4,\\\"lineSmooth\\\":false,\\\"lineArea\\\":false,\\\"pieInnerRadius\\\":0,\\\"pieOuterRadius\\\":60,\\\"pieRoseType\\\":\\\"radius\\\",\\\"pieRoseRadius\\\":5,\\\"funnelWidth\\\":80,\\\"radarShape\\\":\\\"polygon\\\",\\\"tableTitleFontSize\\\":12,\\\"tableItemFontSize\\\":12,\\\"gaugeMin\\\":0,\\\"gaugeMax\\\":100,\\\"gaugeStartAngle\\\":225,\\\"gaugeEndAngle\\\":-45,\\\"dimensionFontSize\\\":18,\\\"quotaFontSize\\\":18,\\\"spaceSplit\\\":10,\\\"dimensionShow\\\":true,\\\"quotaShow\\\":true},\\\"label\\\":{\\\"show\\\":false,\\\"position\\\":\\\"top\\\",\\\"color\\\":\\\"#909399\\\",\\\"fontSize\\\":\\\"10\\\",\\\"formatter\\\":\\\"{c}\\\",\\\"gaugeFormatter\\\":\\\"{value}\\\"},\\\"tooltip\\\":{\\\"show\\\":true,\\\"trigger\\\":\\\"item\\\",\\\"confine\\\":true,\\\"textStyle\\\":{\\\"fontSize\\\":\\\"10\\\",\\\"color\\\":\\\"#909399\\\"},\\\"formatter\\\":\\\"\\\"}}\",\"customStyle\":\"{\\\"text\\\":{\\\"show\\\":true,\\\"fontSize\\\":\\\"18\\\",\\\"color\\\":\\\"#303133\\\",\\\"hPosition\\\":\\\"center\\\",\\\"vPosition\\\":\\\"top\\\",\\\"isItalic\\\":false},\\\"legend\\\":{\\\"show\\\":true,\\\"hPosition\\\":\\\"center\\\",\\\"vPosition\\\":\\\"bottom\\\",\\\"orient\\\":\\\"horizontal\\\",\\\"icon\\\":\\\"rect\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#333333\\\",\\\"fontSize\\\":\\\"12\\\"}},\\\"xAxis\\\":{\\\"show\\\":true,\\\"position\\\":\\\"bottom\\\",\\\"name\\\":\\\"\\\",\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"formatter\\\":\\\"{value}\\\"}},\\\"yAxis\\\":{\\\"show\\\":true,\\\"position\\\":\\\"left\\\",\\\"name\\\":\\\"\\\",\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"formatter\\\":\\\"{value}\\\"}},\\\"background\\\":{\\\"color\\\":\\\"#ffffff\\\",\\\"alpha\\\":100}}\",\"customFilter\":\"[]\"}}', 1624438510391, NULL, NULL, NULL);
INSERT INTO `panel_subject`(`id`, `name`, `type`, `details`, `create_time`, `create_by`, `update_time`, `update_by`) VALUES ('f37fc804-224c-4dec-99e7-b91b5f8c3820', '系统主题2', 'system', '{\"width\":1600,\"height\":900,\"scale\":100,\"scaleWidth\":100,\"scaleHeight\":100,\"selfAdaption\":true,\"auxiliaryMatrix\":false,\"openCommonStyle\":true,\"panel\":{\"color\":\"#f2f2f2\",\"imageUrl\":{},\"backgroundType\":\"color\",\"gap\":\"yes\"},\"chart\":{\"xaxis\":\"[]\",\"yaxis\":\"[]\",\"show\":true,\"type\":\"panel\",\"title\":\"\",\"customAttr\":\"{\\\"color\\\":{\\\"value\\\":\\\"default\\\",\\\"colors\\\":[\\\"#5470c6\\\",\\\"#91cc75\\\",\\\"#fac858\\\",\\\"#ee6666\\\",\\\"#73c0de\\\",\\\"#3ba272\\\",\\\"#fc8452\\\",\\\"#9a60b4\\\",\\\"#ea7ccc\\\"],\\\"alpha\\\":100,\\\"tableHeaderBgColor\\\":\\\"#4e81bb\\\",\\\"tableItemBgColor\\\":\\\"#c6d9f0\\\",\\\"tableFontColor\\\":\\\"#000000\\\",\\\"tableStripe\\\":true,\\\"dimensionColor\\\":\\\"#000000\\\",\\\"quotaColor\\\":\\\"#000000\\\"},\\\"tableColor\\\":{\\\"value\\\":\\\"default\\\",\\\"colors\\\":[\\\"#5470c6\\\",\\\"#91cc75\\\",\\\"#fac858\\\",\\\"#ee6666\\\",\\\"#73c0de\\\",\\\"#3ba272\\\",\\\"#fc8452\\\",\\\"#9a60b4\\\",\\\"#ea7ccc\\\"],\\\"alpha\\\":100,\\\"tableHeaderBgColor\\\":\\\"#4e81bb\\\",\\\"tableItemBgColor\\\":\\\"#c6d9f0\\\",\\\"tableFontColor\\\":\\\"#000000\\\",\\\"tableStripe\\\":true,\\\"dimensionColor\\\":\\\"#000000\\\",\\\"quotaColor\\\":\\\"#000000\\\"},\\\"size\\\":{\\\"barDefault\\\":true,\\\"barWidth\\\":40,\\\"barGap\\\":0.4,\\\"lineWidth\\\":1,\\\"lineType\\\":\\\"solid\\\",\\\"lineSymbol\\\":\\\"emptyCircle\\\",\\\"lineSymbolSize\\\":4,\\\"lineSmooth\\\":false,\\\"lineArea\\\":false,\\\"pieInnerRadius\\\":0,\\\"pieOuterRadius\\\":60,\\\"pieRoseType\\\":\\\"radius\\\",\\\"pieRoseRadius\\\":5,\\\"funnelWidth\\\":80,\\\"radarShape\\\":\\\"polygon\\\",\\\"tableTitleFontSize\\\":12,\\\"tableItemFontSize\\\":12,\\\"gaugeMin\\\":0,\\\"gaugeMax\\\":100,\\\"gaugeStartAngle\\\":225,\\\"gaugeEndAngle\\\":-45,\\\"dimensionFontSize\\\":18,\\\"quotaFontSize\\\":18,\\\"spaceSplit\\\":10,\\\"dimensionShow\\\":true,\\\"quotaShow\\\":true},\\\"label\\\":{\\\"show\\\":false,\\\"position\\\":\\\"top\\\",\\\"color\\\":\\\"#909399\\\",\\\"fontSize\\\":\\\"10\\\",\\\"formatter\\\":\\\"{c}\\\",\\\"gaugeFormatter\\\":\\\"{value}\\\"},\\\"tooltip\\\":{\\\"show\\\":true,\\\"trigger\\\":\\\"item\\\",\\\"confine\\\":true,\\\"textStyle\\\":{\\\"fontSize\\\":\\\"10\\\",\\\"color\\\":\\\"#909399\\\"},\\\"formatter\\\":\\\"\\\"}}\",\"customStyle\":\"{\\\"text\\\":{\\\"show\\\":true,\\\"fontSize\\\":\\\"18\\\",\\\"color\\\":\\\"#303133\\\",\\\"hPosition\\\":\\\"center\\\",\\\"vPosition\\\":\\\"top\\\",\\\"isItalic\\\":false},\\\"legend\\\":{\\\"show\\\":true,\\\"hPosition\\\":\\\"center\\\",\\\"vPosition\\\":\\\"bottom\\\",\\\"orient\\\":\\\"horizontal\\\",\\\"icon\\\":\\\"rect\\\",\\\"textStyle\\\":{\\\"color\\\":\\\"#333333\\\",\\\"fontSize\\\":\\\"12\\\"}},\\\"xAxis\\\":{\\\"show\\\":true,\\\"position\\\":\\\"bottom\\\",\\\"name\\\":\\\"\\\",\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"formatter\\\":\\\"{value}\\\"}},\\\"yAxis\\\":{\\\"show\\\":true,\\\"position\\\":\\\"left\\\",\\\"name\\\":\\\"\\\",\\\"axisLabel\\\":{\\\"rotate\\\":0,\\\"formatter\\\":\\\"{value}\\\"}},\\\"background\\\":{\\\"color\\\":\\\"#ffffff\\\",\\\"alpha\\\":100}}\",\"customFilter\":\"[]\"}}', 1624438690402, NULL, NULL, NULL);
