package io.dataease.commons.condition;

import io.dataease.commons.license.DefaultLicenseService;
import io.dataease.commons.license.F2CLicenseResponse;
import io.dataease.commons.utils.CommonBeanFactory;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;



public class LicStatusCondition implements Condition {

    @Override
    public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
        // BeanDefinitionRegistry registry = conditionContext.getRegistry();

        // DefaultLicenseService defaultLicenseService = conditionContext.getBeanFactory().getBean(DefaultLicenseService.class);

        DefaultLicenseService defaultLicenseService = CommonBeanFactory.getBean(DefaultLicenseService.class);

        /*if (null == defaultLicenseService) {
            registry.registerBeanDefinition();
        }*/
        if (ObjectUtils.isNotEmpty(defaultLicenseService)) {
            F2CLicenseResponse f2CLicenseResponse = defaultLicenseService.validateLicense();
            return F2CLicenseResponse.Status.valid == f2CLicenseResponse.getStatus();
        }
        return false;
    }
}
